package got.actions;

import java.io.PrintStream;

import org.eclipse.ui.console.ConsolePlugin;
import org.eclipse.ui.console.IConsole;
import org.eclipse.ui.console.IConsoleFactory;
import org.eclipse.ui.console.IConsoleManager;
import org.eclipse.ui.console.MessageConsole;
import org.eclipse.ui.console.MessageConsoleStream;

public class InfoViewGreatBear implements IConsoleFactory{

	private static MessageConsole console = new MessageConsole("gongqi.got", null);
	 
	private static PrintStream initConsolePrintStream = System.out;
	
	private static PrintStream errorPrintStream = System.err;
 
	private static PrintStream newConsolePrintStream;
 
	static boolean open = false;

	public static void setPrintStreamInConsole() {
		System.setOut(newConsolePrintStream);
		System.setErr(newConsolePrintStream);
	}
 
	public static void revertPrintStream() {
		System.setOut(initConsolePrintStream);
		System.setErr(errorPrintStream);
	}

	@Override
	public void openConsole() {
		if(!open){
			showConsole();
		}
	}
	
	public  void showConsole() {
		if (console == null) {
			console = new MessageConsole("gongqi.got", null);
		}
		final IConsoleManager manager = ConsolePlugin.getDefault().getConsoleManager();
		final IConsole[] existing = manager.getConsoles();
		boolean exists = false;
		for (int i = 0; i < existing.length; i++) {
			if (console == existing[i]) {
				exists = true;
			}
		}
		if (!exists) {
			manager.addConsoles(new IConsole[] { console });
		}
		manager.showConsoleView(console);
		final MessageConsoleStream stream = console.newMessageStream();
		newConsolePrintStream = new PrintStream(stream);
		setPrintStreamInConsole();
		open =true;
	}
 
	public void closeConsole() {
//		final IConsoleManager manager = ConsolePlugin.getDefault().getConsoleManager();
//		if (console != null) {
//			manager.removeConsoles(new IConsole[] { console });
//			console = null;
//		}
//		revertPrintStream();
//		open = false;
	}
 
	public MessageConsole getConsole() {
		return console;
	}

	
}
