/*
 * Decompiled with CFR 0.152.
 */
package gongqi.gdt.designer.utils.cache;

import edu.emory.mathcs.backport.java.util.Arrays;
import gongqi.gdt.designer.core.toolsgot.GOTHelper;
import gongqi.gdt.designer.utils.cache.GOTOverwrite;
import info.gongqi.got.model.GotXmlDto;
import info.gongqi.got.tool.GOTHelp;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.dom4j.Attribute;
import org.dom4j.Element;
import org.dom4j.Node;

public class GOTFinalValueHelper {
    private static final String FORMITEM = "FormItem";
    private static final String TRUE = "true";
    private static final String FALSE = "false";
    private static final String ATTR_NAME = "name";
    private static final String ATTR_ID = "id";
    private static final String ATTR_REFENTITYID = "refentityid";
    private static final String ATTR_REFINNERID = "refinnerid";
    private static final String ATTR_INNERID = "innerid";
    private static final String PROPERTY_X = "X";
    private static final String PROPERTY_Y = "Y";
    private static final String PROPERTY_WIDTH = "Width";
    private static final String PROPERTY_HEIGHT = "Height";
    private static final String PROPERTY_HIDEINVISIBLE = "HideInvisible";
    private static final String PROPERTY_LAYOUT = "Layout";
    private static final String PROPERTY_ICON = "Icon";
    private static final String PROPERTY_DISABLEDICON = "DisabledIcon";
    private static final String PROPERTY_SHORTCUT = "ShortCut";
    private static final String PROPERTY_DISPLAYMODE = "DisplayMode";
    private static final String PROPERTY_SAVERECORD = "SaveRecord";
    private static final String PROPERTY_MULTISELECT = "MultiSelect";
    private static final String PROPERTY_DISPLAYHEIGHT = "DisplayHeight";
    private static final String PROPERTY_SHOWLABEL = "ShowLabel";
    private static final String PROPERTY_LABELALIGNMENT = "LabelAlignment";
    private static final String PROPERTY_SEARCHMODE = "SearchMode";
    private static final String PROPERTY_RETURNLOOKUP = "ReturnLookup";
    private static final String PROPERTY_SOURCE = "Source";
    private static final String PROPERTY_DATASOURCE = "DataSource";
    private static final String PROPERTY_DATAMETHOD = "DataMethod";
    private static final String PROPERTY_EXTENDS = "Extends";
    private static final String PROPERTY_FIELDGROUP = "FieldGroup";
    private static final String PROPERTY_COMPONENT = "Component";
    private static final String PROPERTY_MENUITEM = "MenuItem";
    private static final String PROPERTY_SHOWHEADER = "ShowHeader";
    private static final String PROPERTY_SKIPTAB = "SkipTab";
    private static final String PROPERTY_LABELLENGTH = "LabelLength";
    private static final String PROPERTY_HEADERALIGN = "HeaderAlign";
    private static final String PROPERTY_ROWS = "Rows";
    private static final String PROPERTY_URL = "URL";
    private static final String PROPERTY_SUFFIX = "Suffix";
    private static final String PROPERTY_POPUP = "Popup";
    private static final String PROPERTY_LAYOUTMODE = "LayoutMode";
    private static final String PROPERTY_CONTROLTYPE = "ControlType";
    private static final String PROPERTY_CLASSNAME = "ClassName";
    private static final String PROPERTY_FAILUREIMAGE = "FailureImage";
    private static final String PROPERTY_QUERYTYPE = "QueryType";
    private static final String PROPERTY_GROUPTYPE = "GroupType";
    private static final String PROPERTY_QUERYSOURCE = "QuerySource";
    private static final String PROPERTY_QUERYFIELD = "QueryField";
    private static final String PROPERTY_QUERYFILTER = "QueryFilter";
    private static final String PROPERTY_TRIM = "Trim";
    private static final String PROPERTY_CHANGECASE = "ChangeCase";
    private static final String PROPERTY_SHOWZERO = "ShowZero";
    private static final String PROPERTY_ALLOWNEGATIVE = "AllowNegative";
    private static final String PROPERTY_THOUSANDSEPERATOR = "ThousandSeperator";
    private static final String PROPERTY_SHOWDECIMALS = "DisplayDecimals";
    private static final String PROPERTY_ROUNDOFF = "RoundOff";
    private static final String PROPERTY_SEPERATOR = "Seperator";
    private static final String PROPERTY_NUMOFYEAR = "NumOfYear";
    private static final String PROPERTY_NUMOFMONTH = "NumOfMonth";
    private static final String PROPERTY_NUMOFDAY = "NumOfDay";
    private static final String PROPERTY_SHOW1970 = "Show1970";
    private static final String PROPERTY_SHOWMINUTE = "ShowMinute";
    private static final String PROPERTY_SHOWSECOND = "ShowSecond";
    private static final String PROPERTY_SHOWHOUR = "ShowHour";
    private static final String PROPERTY_TEXTTRUE = "TextTrue";
    private static final String PROPERTY_TEXTFALSE = "TextFalse";
    private static final String PROPERTY_AUTHORITYLEVEL = "AuthorityLevel";
    private static final String PROPERTY_STRINGSIZE = "StringSize";
    private static final String PROPERTY_NUMOFDECIMALS = "NumOfDecimals";
    private static final String COLUMNS = "Columns";
    private static final String COLLAPSIBLE = "Collapsible";
    private static final String LOOKUPMODE = "LookupMode";
    private static final String ALLOWKEYIN = "AllowKeyIn";
    private static final String SHOWBORDER = "ShowBorder";
    private static final String WORKFLOW = "Workflow";
    private static final String AUTOSUM = "AutoSum";
    private static final String MAINCONTENTALIGNMENT = "MainContentAlignment";
    private static final String PROPERTY_LABEL = "Label";
    private static final String PROPERTY_HEADER_HEIGHT = "HeaderHeight";
    private static final String PROPERTY_DISABLEAUTOSAVE = "DisableAutoSave";
    private static final String PROPERTY_AUTOENTERLIST = "AutoEnterList";
    private static String[] nodeextendsproperties = null;
    private static Map<String, String> fromdatatypeproperties = null;
    private static Map<String, String> fromdatatypebutformitemalsoproperties = null;

    static {
        nodeextendsproperties = new String[]{PROPERTY_X, PROPERTY_Y, PROPERTY_WIDTH, PROPERTY_HEIGHT, PROPERTY_HIDEINVISIBLE, PROPERTY_LAYOUT, PROPERTY_ICON, PROPERTY_DISABLEDICON, PROPERTY_SHORTCUT, PROPERTY_DISPLAYMODE, PROPERTY_SAVERECORD, PROPERTY_MULTISELECT, PROPERTY_DISPLAYHEIGHT, PROPERTY_SHOWLABEL, PROPERTY_LABELALIGNMENT, PROPERTY_SEARCHMODE, PROPERTY_RETURNLOOKUP, PROPERTY_SOURCE, PROPERTY_DATASOURCE, PROPERTY_DATAMETHOD, PROPERTY_EXTENDS, PROPERTY_FIELDGROUP, PROPERTY_COMPONENT, PROPERTY_MENUITEM, PROPERTY_SHOWHEADER, PROPERTY_SKIPTAB, PROPERTY_LABELLENGTH, PROPERTY_HEADERALIGN, PROPERTY_ROWS, PROPERTY_URL, PROPERTY_SUFFIX, PROPERTY_POPUP, PROPERTY_LAYOUTMODE, PROPERTY_CONTROLTYPE, PROPERTY_CLASSNAME, PROPERTY_FAILUREIMAGE, PROPERTY_QUERYTYPE, PROPERTY_GROUPTYPE, PROPERTY_QUERYSOURCE, PROPERTY_QUERYFIELD, PROPERTY_QUERYFILTER, PROPERTY_AUTHORITYLEVEL, COLUMNS, COLLAPSIBLE, LOOKUPMODE, ALLOWKEYIN, SHOWBORDER, WORKFLOW, AUTOSUM, MAINCONTENTALIGNMENT, PROPERTY_HEADER_HEIGHT, PROPERTY_DISABLEAUTOSAVE, PROPERTY_AUTOENTERLIST};
        fromdatatypeproperties = new HashMap<String, String>();
        fromdatatypeproperties.put(PROPERTY_TRIM, "LeftRight");
        fromdatatypeproperties.put(PROPERTY_CHANGECASE, "Node");
        fromdatatypeproperties.put(PROPERTY_SHOWZERO, TRUE);
        fromdatatypeproperties.put(PROPERTY_ALLOWNEGATIVE, TRUE);
        fromdatatypeproperties.put(PROPERTY_THOUSANDSEPERATOR, FALSE);
        fromdatatypeproperties.put(PROPERTY_SHOWDECIMALS, "2");
        fromdatatypeproperties.put(PROPERTY_ROUNDOFF, "HalfUp");
        fromdatatypeproperties.put(PROPERTY_SEPERATOR, "-");
        fromdatatypeproperties.put(PROPERTY_NUMOFYEAR, "4");
        fromdatatypeproperties.put(PROPERTY_NUMOFMONTH, "2");
        fromdatatypeproperties.put(PROPERTY_NUMOFDAY, "2");
        fromdatatypeproperties.put(PROPERTY_SHOW1970, FALSE);
        fromdatatypeproperties.put(PROPERTY_SHOWMINUTE, TRUE);
        fromdatatypeproperties.put(PROPERTY_SHOWSECOND, TRUE);
        fromdatatypeproperties.put(PROPERTY_SHOWHOUR, TRUE);
        fromdatatypeproperties.put(PROPERTY_TEXTTRUE, "\u662f");
        fromdatatypeproperties.put(PROPERTY_TEXTFALSE, "\u5426");
        fromdatatypebutformitemalsoproperties = new HashMap<String, String>();
        fromdatatypebutformitemalsoproperties.put(PROPERTY_SHOWDECIMALS, "2");
        fromdatatypebutformitemalsoproperties.put(PROPERTY_SHOWZERO, TRUE);
        fromdatatypebutformitemalsoproperties.put(PROPERTY_SEPERATOR, "-");
        fromdatatypebutformitemalsoproperties.put(PROPERTY_NUMOFYEAR, "4");
        fromdatatypebutformitemalsoproperties.put(PROPERTY_NUMOFMONTH, "2");
        fromdatatypebutformitemalsoproperties.put(PROPERTY_NUMOFDAY, "2");
    }

    private static boolean hasProperty(Element reportField, String property) {
        Element pro = gongqi.erp.gotmodel.core.GOTHelper.getProperty((Element)reportField, (String)property);
        return pro != null;
    }

    public static String getReprotFinalValue(Element item, String property) {
        String nodeName = item.getName();
        if ("ReportField".equals(nodeName)) {
            String value;
            if (PROPERTY_EXTENDS.equals(property) || PROPERTY_SOURCE.equals(property)) {
                return gongqi.erp.gotmodel.core.GOTHelper.getPropertyValue((Element)item, (String)property);
            }
            boolean hasProperty = GOTFinalValueHelper.hasProperty(item, property);
            if (hasProperty && !"".equals(value = gongqi.erp.gotmodel.core.GOTHelper.getPropertyValue((Element)item, (String)property))) {
                return value;
            }
            Element extendsPro = gongqi.erp.gotmodel.core.GOTHelper.getProperty((Element)item, (String)PROPERTY_EXTENDS);
            if (extendsPro.attributeValue(ATTR_REFENTITYID) != null) {
                String refId = extendsPro.attributeValue(ATTR_REFENTITYID);
                Element entity = null;
                entity = "20".equals(refId.substring(0, 2)) ? GOTOverwrite.getDataType(refId) : GOTOverwrite.getEnum(refId);
                return GOTFinalValueHelper.getFinalValue(entity, property);
            }
            if (PROPERTY_LABEL.equals(property)) {
                return item.attributeValue(ATTR_NAME);
            }
            if ("Regular".equals(property)) {
                return "";
            }
            if ("NotNull".equals(property)) {
                return FALSE;
            }
            if ("AllowEdit".equals(property)) {
                return TRUE;
            }
            if ("AllowEditOnCreate".equals(property)) {
                return TRUE;
            }
            if ("Default".equals(property)) {
                return "";
            }
            if (PROPERTY_SKIPTAB.equals(property)) {
                return FALSE;
            }
            if (PROPERTY_DISPLAYHEIGHT.equals(property)) {
                return "1";
            }
            if (PROPERTY_SEPERATOR.equals(property)) {
                return "-";
            }
            if (PROPERTY_NUMOFYEAR.equals(property)) {
                return "4";
            }
            if (PROPERTY_NUMOFMONTH.equals(property)) {
                return "2";
            }
            if (PROPERTY_NUMOFDAY.equals(property)) {
                return "2";
            }
            if (PROPERTY_SHOW1970.equals(property)) {
                return TRUE;
            }
            if (PROPERTY_SHOWZERO.equals(property)) {
                return TRUE;
            }
            if (PROPERTY_THOUSANDSEPERATOR.equals(property)) {
                return ",";
            }
            if (PROPERTY_ALLOWNEGATIVE.equals(property)) {
                return TRUE;
            }
            if (PROPERTY_SHOWDECIMALS.equals(property)) {
                return TRUE;
            }
            if (PROPERTY_ROUNDOFF.equals(property)) {
                return "HalfUp";
            }
            if (PROPERTY_TRIM.equals(property)) {
                return "LeftRight";
            }
            if (PROPERTY_CHANGECASE.equals(property)) {
                return "None";
            }
            if (PROPERTY_SHOWHOUR.equals(property)) {
                return TRUE;
            }
            if (PROPERTY_SHOWMINUTE.equals(property)) {
                return TRUE;
            }
            if (PROPERTY_SHOWSECOND.equals(property)) {
                return TRUE;
            }
            return "";
        }
        if ("ReportQuery".equals(nodeName)) {
            return gongqi.erp.gotmodel.core.GOTHelper.getPropertyValue((Element)item, (String)property);
        }
        if ("Report".equals(nodeName)) {
            String label = gongqi.erp.gotmodel.core.GOTHelper.getPropertyValue((Element)item, (String)property);
            if ("".equals(label)) {
                return item.attributeValue(ATTR_NAME);
            }
            return label;
        }
        if ("Query".equals(property) && "Title".equals(property)) {
            String value = gongqi.erp.gotmodel.core.GOTHelper.getPropertyValue((Element)item, (String)property);
            if ("".equals(value)) {
                Element queryTable = item.element("QueryTable");
                if (queryTable == null) {
                    return item.attributeValue(ATTR_NAME);
                }
                Element extendsPro = gongqi.erp.gotmodel.core.GOTHelper.getProperty((Element)queryTable, (String)"Table");
                Element table = null;
                if (extendsPro.attribute(ATTR_REFENTITYID) != null) {
                    table = GOTOverwrite.getTable(extendsPro.attributeValue(ATTR_REFENTITYID));
                }
                if (table != null && "".equals(value = GOTFinalValueHelper.getFinalValue(table, PROPERTY_LABEL))) {
                    value = item.attributeValue(ATTR_NAME);
                }
            }
            return value;
        }
        return null;
    }

    private static String getFormItemDataTypePropertyValueFromFormItem(Element formItem, String propertyName) {
        String value = gongqi.erp.gotmodel.core.GOTHelper.getPropertyValue((Element)formItem, (String)propertyName);
        if (!"".equals(value) && value != null) {
            return value;
        }
        return GOTFinalValueHelper.getDataTypePropertyValueFromFormItem(formItem, propertyName);
    }

    /*
     * Enabled aggressive block sorting
     */
    private static String getDataTypePropertyValueFromFormItem(Element formItem, String propertyName) {
        Element dataType;
        Element pFormItem;
        block13: {
            pFormItem = gongqi.erp.gotmodel.core.GOTHelper.getProperty((Element)formItem, (String)PROPERTY_EXTENDS);
            if (pFormItem == null) {
                return null;
            }
            if (pFormItem.attribute(ATTR_REFENTITYID) == null) {
                if (PROPERTY_SHOWDECIMALS.equals(propertyName)) {
                    return GOTFinalValueHelper.getFinalValue(formItem, PROPERTY_NUMOFDECIMALS);
                }
                return null;
            }
            dataType = null;
            if (pFormItem.attribute(ATTR_REFINNERID) != null) {
                Element table = GOTOverwrite.getTable(pFormItem.attributeValue(ATTR_REFENTITYID));
                if (table != null) {
                    Element tableField = (Element)table.selectSingleNode(String.format("TableFields/TableField[@id='%s']", pFormItem.attributeValue(ATTR_REFINNERID)));
                    Element pTableField = gongqi.erp.gotmodel.core.GOTHelper.getProperty((Element)tableField, (String)PROPERTY_EXTENDS);
                    if (pTableField.attribute(ATTR_REFENTITYID) == null) {
                        if (PROPERTY_SHOWDECIMALS.equals(propertyName)) {
                            return GOTFinalValueHelper.getFinalValue(formItem, PROPERTY_NUMOFDECIMALS);
                        }
                        return null;
                    }
                    dataType = GOTOverwrite.getDataType(pTableField.attributeValue(ATTR_REFENTITYID));
                    break block13;
                } else {
                    if (PROPERTY_SHOWDECIMALS.equals(propertyName)) {
                        return GOTFinalValueHelper.getFinalValue(formItem, PROPERTY_NUMOFDECIMALS);
                    }
                    return null;
                }
            }
            dataType = GOTOverwrite.getDataType(pFormItem.attributeValue(ATTR_REFENTITYID));
        }
        if (PROPERTY_COMPONENT.equals(dataType.attributeValue("type"))) {
            String componentfieldvalue = pFormItem.elementText("Value").split("[.]")[1];
            Element arrayItem = (Element)dataType.selectSingleNode(String.format("DataTypeArray/DataTypeArrayItem[@name='%s']", componentfieldvalue));
            Element refdatatypepro = gongqi.erp.gotmodel.core.GOTHelper.getProperty((Element)arrayItem, (String)"RefDataType");
            dataType = GOTOverwrite.getDataType(refdatatypepro.attributeValue(ATTR_REFENTITYID));
        }
        String value = gongqi.erp.gotmodel.core.GOTHelper.getProperty((Element)dataType, (String)propertyName).elementText("Value");
        while (value == "") {
            dataType = GOTOverwrite.getDataType(gongqi.erp.gotmodel.core.GOTHelper.getProperty((Element)dataType, (String)PROPERTY_EXTENDS).attributeValue(ATTR_REFENTITYID));
            value = gongqi.erp.gotmodel.core.GOTHelper.getProperty((Element)dataType, (String)propertyName).elementText("Value");
        }
        if (!"".equals(value)) {
            return value;
        }
        if (PROPERTY_SHOWDECIMALS.equals(propertyName)) {
            return GOTFinalValueHelper.getFinalValue(formItem, PROPERTY_NUMOFDECIMALS);
        }
        return null;
    }

    private static String getFilterFieldFromFormItem(Element item) {
        Element extendsPro;
        String dataSource;
        String result = null;
        if ("StringEditor".equals(item.attributeValue("type")) && !"".equals(dataSource = gongqi.erp.gotmodel.core.GOTHelper.getPropertyValue((Element)item, (String)PROPERTY_DATASOURCE)) && dataSource != null && (extendsPro = gongqi.erp.gotmodel.core.GOTHelper.getProperty((Element)item, (String)PROPERTY_EXTENDS)).attribute(ATTR_REFENTITYID) != null && extendsPro.attribute(ATTR_REFINNERID) != null) {
            String filterField;
            String entityid = extendsPro.attributeValue(ATTR_REFENTITYID);
            String innerid = extendsPro.attributeValue(ATTR_REFINNERID);
            Element table = GOTOverwrite.getTable(entityid);
            Element tableField = (Element)table.selectSingleNode(String.format("TableFields/TableField[@id='%s']", innerid));
            if (tableField != null && !"".equals(filterField = gongqi.erp.gotmodel.core.GOTHelper.getPropertyValue((Element)tableField, (String)"FilterField"))) {
                return filterField;
            }
        }
        return result;
    }

    private static boolean isFindQueryField(String propertyName) {
        return PROPERTY_LABEL.equals(propertyName) || PROPERTY_NUMOFDECIMALS.equals(propertyName) || PROPERTY_STRINGSIZE.equals(propertyName);
    }

    /*
     * Unable to fully structure code
     */
    private static String getPropertyValueStepByStep(Element item, String propertyName, String validateString, boolean validateEquals, boolean findFormDataSourceField) {
        value = null;
        pFormItem_Extends = null;
        pFormDataSourceField_Field = null;
        if ("FormItem".equals(item.getName())) {
            value = gongqi.erp.gotmodel.core.GOTHelper.getPropertyValue((Element)item, (String)propertyName);
            if (value == null) {
                value = "";
            }
            if (validateEquals != false ? validateString.equals(value) != false : validateString.equals(value) == false) {
                return value;
            }
            if ("FieldGroup".equals(item.attributeValue("type"))) {
                pFormItem_Extends = gongqi.erp.gotmodel.core.GOTHelper.getProperty((Element)item, (String)"Component");
                if (pFormItem_Extends.attribute("refentityid") == null) {
                    return value;
                }
            } else {
                pFormItem_Extends = gongqi.erp.gotmodel.core.GOTHelper.getProperty((Element)item, (String)"Extends");
            }
            if (pFormItem_Extends == null) {
                System.out.println("FormItem\u4e0a\u627e\u4e0d\u5230Extends");
                return "";
            }
            isQueryField = false;
            attrrefentityid = attr = pFormItem_Extends.attribute("refentityid");
            if (attr == null && GOTFinalValueHelper.isFindQueryField(propertyName)) {
                pFormItem_Extends = gongqi.erp.gotmodel.core.GOTHelper.getProperty((Element)item, (String)"QueryField");
                if (pFormItem_Extends == null || pFormItem_Extends.attribute("refentityid") == null) {
                    return value;
                }
                isQueryField = true;
            }
            if ((attr = pFormItem_Extends.attribute("refinnerid")) != null) {
                if ("".equals(pFormItem_Extends.selectSingleNode("Value").getText())) {
                    return "";
                }
                if (findFormDataSourceField) {
                    pFormItem_DataSource = null;
                    pFormItem_DataSource = isQueryField == false ? gongqi.erp.gotmodel.core.GOTHelper.getProperty((Element)item, (String)"DataSource") : gongqi.erp.gotmodel.core.GOTHelper.getProperty((Element)item, (String)"QuerySource");
                    if (pFormItem_DataSource == null || pFormItem_DataSource.attribute("innerid") == null) {
                        return value;
                    }
                    form = GOTFinalValueHelper.getItemEntity(item);
                    if (form == null) {
                        return value;
                    }
                    item = (Element)form.selectSingleNode(String.format("FormDataSources/FormDataSource[@id='%s']/FormDataSourceFields/FormDataSourceField[@name='%s']", new Object[]{pFormItem_DataSource.attributeValue("innerid"), pFormItem_Extends.elementText("Value")}));
                } else {
                    table = GOTOverwrite.getTable(pFormItem_Extends.attributeValue("refentityid"));
                    item = (Element)table.selectSingleNode(String.format("TableFields/TableField[@id='%s']", new Object[]{pFormItem_Extends.attributeValue("refinnerid")}));
                }
            } else if (attrrefentityid != null && (item = GOTOverwrite.getDataType(pFormItem_Extends.attributeValue("refentityid"))) == null) {
                item = GOTOverwrite.getEnum(pFormItem_Extends.attributeValue("refentityid"));
            }
        }
        if (item == null) {
            return "";
        }
        if ("FormDataSourceField".equals(item.getName())) {
            value = gongqi.erp.gotmodel.core.GOTHelper.getPropertyValue((Element)item, (String)propertyName);
            if (value == null) {
                value = "";
            }
            if ("Visible".equals(propertyName)) {
                return value;
            }
            if (validateEquals != false ? validateString.equals(value) != false : validateString.equals(value) == false) {
                return value;
            }
            pFormDataSourceField_Field = gongqi.erp.gotmodel.core.GOTHelper.getProperty((Element)item, (String)"Field");
            table = GOTOverwrite.getTable(pFormDataSourceField_Field.attributeValue("refentityid"));
            if (table == null) {
                return "";
            }
            item = (Element)table.selectSingleNode(String.format("TableFields/TableField[@id='%s']", new Object[]{pFormDataSourceField_Field.attributeValue("refinnerid")}));
        }
        if (item == null) {
            return "";
        }
        if ("TableField".equals(item.getName())) {
            value = gongqi.erp.gotmodel.core.GOTHelper.getPropertyValue((Element)item, (String)propertyName);
            if (value == null) {
                value = "";
            }
            if ("Visible".equals(propertyName)) {
                return value;
            }
            if ("AllowEdit".equals(propertyName) || "NotNull".equals(propertyName)) {
                return value;
            }
            pTableField_Extends = null;
            if ("Component".equals(item.attributeValue("type"))) {
                if (pFormItem_Extends != null && pFormItem_Extends.elementText("Value").indexOf(".") != -1) {
                    pTableField_Extends = gongqi.erp.gotmodel.core.GOTHelper.getProperty((Element)item, (String)"Extends");
                    extendsValue = pFormItem_Extends.elementText("Value");
                    extendsFieldValue = extendsValue.split("[.]")[1];
                    datatype = GOTOverwrite.getDataType(pTableField_Extends.attributeValue("refentityid"));
                    property = datatype.selectSingleNode(String.format("DataTypeArray/DataTypeArrayItem[@name='%s']/Properties/Property[Name/text()='%s']", new Object[]{extendsFieldValue, "RefDataType"}));
                    refentityid = ((Element)property).attributeValue("refentityid");
                    item = GOTOverwrite.getDataType(refentityid);
                } else if (pFormDataSourceField_Field != null && pFormDataSourceField_Field.elementText("Value").indexOf(".") != -1) {
                    pTableField_Extends = gongqi.erp.gotmodel.core.GOTHelper.getProperty((Element)item, (String)"Extends");
                    extendsValue = pFormDataSourceField_Field.elementText("Value");
                    extendsFieldValue = extendsValue.split("[.]")[1];
                    datatype = GOTOverwrite.getDataType(pTableField_Extends.attributeValue("refentityid"));
                    property = (Element)datatype.selectSingleNode(String.format("DataTypeArray/DataTypeArrayItem[@name='%s']/Properties/Property[Name/text()='%s']", new Object[]{extendsFieldValue, "RefDataType"}));
                    item = GOTOverwrite.getDataType(property.attributeValue("refentityid"));
                } else {
                    if (validateEquals != false ? value.equals(validateString) != false : value.equals(validateString) == false) {
                        return value;
                    }
                    pTableField_Extends = gongqi.erp.gotmodel.core.GOTHelper.getProperty((Element)item, (String)"Extends");
                    if (pTableField_Extends.attribute("refentityid") == null) {
                        return value;
                    }
                    item = GOTOverwrite.getDataType(pTableField_Extends.attributeValue("refentityid"));
                }
            } else {
                if (value != null && (validateEquals != false ? value.equals(validateString) != false : value.equals(validateString) == false)) {
                    return value;
                }
                pTableField_Extends = gongqi.erp.gotmodel.core.GOTHelper.getProperty((Element)item, (String)"Extends");
                if (pTableField_Extends.attribute("refentityid") == null) {
                    return value;
                }
                item = GOTOverwrite.getDataType(pTableField_Extends.attributeValue("refentityid"));
                if (item == null) {
                    item = GOTOverwrite.getEnum(pTableField_Extends.attributeValue("refentityid"));
                }
            }
        }
        if (item != null) ** GOTO lbl119
        return "";
lbl-1000:
        // 1 sources

        {
            tmp = gongqi.erp.gotmodel.core.GOTHelper.getProperty((Element)item, (String)propertyName);
            if (tmp == null) {
                return value;
            }
            value = tmp.elementText("Value");
            if (validateEquals != false ? value.equals(validateString) != false : value.equals(validateString) == false) {
                return value;
            }
            pDataType_Extends = gongqi.erp.gotmodel.core.GOTHelper.getProperty((Element)item, (String)"Extends");
            if (pDataType_Extends == null) {
                return value;
            }
            if (pDataType_Extends.attribute("refentityid") == null) {
                return value;
            }
            item = GOTOverwrite.getDataType(pDataType_Extends.attributeValue("refentityid"));
            if (item != null) continue;
            item = GOTOverwrite.getEnum(pDataType_Extends.attributeValue("refentityid"));
lbl119:
            // 3 sources

            ** while ("DataType".equals((Object)item.getName()))
        }
lbl120:
        // 1 sources

        if ("Enum".equals(item.getName())) {
            tmp = gongqi.erp.gotmodel.core.GOTHelper.getProperty((Element)item, (String)propertyName);
            if (tmp == null) {
                return value;
            }
            value = tmp.elementText("Value");
            if (validateEquals != false ? value.equals(validateString) != false : value.equals(validateString) == false) {
                return value;
            }
        }
        return value;
    }

    private static Element getItemEntity(Element item) {
        if (item != null && item.attribute("version") != null) {
            return item;
        }
        if (item.getParent() != null) {
            return GOTFinalValueHelper.getItemEntity(item.getParent());
        }
        return null;
    }

    public static String getFinalValue(Element item, String propertyName) {
        String value;
        String nodeName = item.getName();
        if (FORMITEM.equals(nodeName)) {
            if (Arrays.asList((Object[])nodeextendsproperties).contains(propertyName)) {
                return gongqi.erp.gotmodel.core.GOTHelper.getPropertyValue((Element)item, (String)propertyName);
            }
            if (fromdatatypeproperties.containsKey(propertyName)) {
                if (fromdatatypebutformitemalsoproperties.containsKey(propertyName)) {
                    String value2 = GOTFinalValueHelper.getFormItemDataTypePropertyValueFromFormItem(item, propertyName);
                    return value2 == null ? fromdatatypebutformitemalsoproperties.get(propertyName) : value2;
                }
                String value3 = GOTFinalValueHelper.getDataTypePropertyValueFromFormItem(item, propertyName);
                return value3 == null ? fromdatatypeproperties.get(propertyName) : value3;
            }
            if ("FilterField".equals(propertyName)) {
                String value4 = GOTFinalValueHelper.getFilterFieldFromFormItem(item);
                if (value4 != null) {
                    return value4;
                }
                return "";
            }
            String formItemType = item.attributeValue("type");
            if ("Text".equals(formItemType)) {
                return gongqi.erp.gotmodel.core.GOTHelper.getPropertyValue((Element)item, (String)propertyName);
            }
            if (PROPERTY_LABEL.equals(propertyName) && PROPERTY_FIELDGROUP.equals(formItemType)) {
                String value5 = gongqi.erp.gotmodel.core.GOTHelper.getPropertyValue((Element)item, (String)propertyName);
                if (!"".equals(value5) && value5 != null) {
                    return value5;
                }
                Element p = gongqi.erp.gotmodel.core.GOTHelper.getProperty((Element)item, (String)PROPERTY_FIELDGROUP);
                Attribute attr = p.attribute(ATTR_REFENTITYID);
                if (attr != null) {
                    String refentityid = attr.getStringValue();
                    attr = p.attribute(ATTR_REFINNERID);
                    String refinnerid = attr.getStringValue();
                    Element table = GOTOverwrite.getTable(refentityid);
                    Node valuenode = table.selectSingleNode(String.format("TableFieldGroups/TableFieldGroup[@id='%s']/Properties/Property[Name/text()='%s']/Value", refinnerid, propertyName));
                    value5 = valuenode.getText();
                    if (value5 != "" && value5 != null) {
                        return value5;
                    }
                    return "";
                }
                p = gongqi.erp.gotmodel.core.GOTHelper.getProperty((Element)item, (String)PROPERTY_COMPONENT);
                attr = p.attribute(ATTR_REFINNERID);
                if (attr != null) {
                    String refinnerid = attr.getStringValue();
                    attr = p.attribute(ATTR_REFENTITYID);
                    String refentityid = attr.getStringValue();
                    Element table = GOTOverwrite.getTable(refentityid);
                    Node tablefield = table.selectSingleNode(String.format("TableFields/TableField[@id='%s']", refinnerid));
                    Node valuenode = tablefield.selectSingleNode(String.format("Properties/Property[Name/text()='%s']/Value", propertyName));
                    value5 = valuenode.getText();
                    if (value5 != "" && value5 != null) {
                        return value5;
                    }
                    p = gongqi.erp.gotmodel.core.GOTHelper.getProperty((Element)((Element)tablefield), (String)PROPERTY_EXTENDS);
                    attr = p.attribute(ATTR_REFENTITYID);
                    refentityid = attr.getStringValue();
                    valuenode = (p = GOTOverwrite.getDataType(refentityid)).selectSingleNode(String.format("Properties/Property[Name/text()='%s']/Value", propertyName));
                    value5 = valuenode.getText();
                    if (value5 != "" && value5 != null) {
                        return value5;
                    }
                    return "";
                }
                p = gongqi.erp.gotmodel.core.GOTHelper.getProperty((Element)item, (String)PROPERTY_COMPONENT);
                attr = p.attribute(ATTR_REFENTITYID);
                if (attr != null) {
                    String refentityid = attr.getStringValue();
                    p = GOTOverwrite.getDataType(refentityid);
                    value5 = (p = gongqi.erp.gotmodel.core.GOTHelper.getProperty((Element)p, (String)propertyName)).elementText("Value");
                    if (value5 != "" && value5 != null) {
                        return value5;
                    }
                    return "";
                }
                return value5;
            }
            if (formItemType.indexOf("Editor") == -1) {
                if ("AllowEdit".equals(propertyName) || "Visible".equals(propertyName)) {
                    if (PROPERTY_FIELDGROUP.equals(formItemType)) {
                        return GOTFinalValueHelper.getPropertyValueStepByStep(item, propertyName, FALSE, true, true);
                    }
                    return gongqi.erp.gotmodel.core.GOTHelper.getPropertyValue((Element)item, (String)propertyName);
                }
                if (PROPERTY_LABEL.equals(propertyName)) {
                    String menuItemId;
                    Element menuItem;
                    Element menuItemPro;
                    if (formItemType.equals("MenuItemButton") && (menuItemPro = gongqi.erp.gotmodel.core.GOTHelper.getProperty((Element)item, (String)PROPERTY_MENUITEM)).attributeValue(ATTR_REFENTITYID) != null && (menuItem = GOTHelper.getMenuItem(menuItemId = menuItemPro.attributeValue(ATTR_REFENTITYID))) != null) {
                        return GOTFinalValueHelper.getFinalValue(menuItem, propertyName);
                    }
                    String value6 = gongqi.erp.gotmodel.core.GOTHelper.getPropertyValue((Element)item, (String)propertyName);
                    if (!"".equals(value6) && value6 != null) {
                        return value6;
                    }
                    return item.attributeValue(ATTR_NAME);
                }
                return gongqi.erp.gotmodel.core.GOTHelper.getPropertyValue((Element)item, (String)propertyName);
            }
            if ("AllowEditOnCreate".equals(propertyName)) {
                String allowEdit = gongqi.erp.gotmodel.core.GOTHelper.getPropertyValue((Element)item, (String)"AllowEdit");
                if (FALSE.equals(allowEdit)) {
                    return FALSE;
                }
                Element p = gongqi.erp.gotmodel.core.GOTHelper.getProperty((Element)item, (String)PROPERTY_EXTENDS);
                Attribute attrentityid = p.attribute(ATTR_REFENTITYID);
                Attribute attrinnerid = p.attribute(ATTR_REFINNERID);
                if (attrentityid == null || attrinnerid == null) {
                    return FALSE;
                }
                String pvalue = p.elementText("Value");
                Element pFormItem_DataSource = gongqi.erp.gotmodel.core.GOTHelper.getProperty((Element)item, (String)PROPERTY_DATASOURCE);
                String datasourcerefid = pFormItem_DataSource.attributeValue(ATTR_INNERID);
                Element entity = GOTFinalValueHelper.getItemEntity(item);
                Node formdatasourcefield = entity.selectSingleNode(String.format("FormDataSources/FormDataSource[@id='%s']/FormDataSourceFields/FormDataSourceField[@name='%s']", datasourcerefid, pvalue));
                allowEdit = gongqi.erp.gotmodel.core.GOTHelper.getPropertyValue((Element)((Element)formdatasourcefield), (String)"AllowEdit");
                if (FALSE.equals(allowEdit)) {
                    return FALSE;
                }
                Element table = GOTOverwrite.getTable(attrentityid.getText());
                String istmp = gongqi.erp.gotmodel.core.GOTHelper.getPropertyValue((Element)table, (String)"Temporary");
                if (TRUE.equals(istmp)) {
                    return FALSE;
                }
                Node pronode = table.selectSingleNode(String.format("TableFields/TableField[@id='%s']/Properties/Property[Name/text()='%s']", attrinnerid.getText(), propertyName));
                return ((Element)pronode).elementText("Value");
            }
            if (PROPERTY_LABEL.equals(propertyName)) {
                String value7 = GOTFinalValueHelper.getPropertyValueStepByStep(item, propertyName, "", false, true);
                if (!"".equals(value7) && value7 != null) {
                    return value7;
                }
                return item.attributeValue(ATTR_NAME);
            }
            if ("HelpText".equals(propertyName) || "DisplayLength".equals(propertyName) || "Regular".equals(propertyName) || "Default".equals(propertyName)) {
                return GOTFinalValueHelper.getPropertyValueStepByStep(item, propertyName, "", false, true);
            }
            if ("Alignment".equals(propertyName) || PROPERTY_STRINGSIZE.equals(propertyName) || "FormLookup".equals(propertyName) || "ValidateLookup".equals(propertyName) || PROPERTY_NUMOFDECIMALS.equals(propertyName)) {
                return GOTFinalValueHelper.getPropertyValueStepByStep(item, propertyName, "", false, false);
            }
            if ("AllowEdit".equals(propertyName)) {
                return GOTFinalValueHelper.getPropertyValueStepByStep(item, propertyName, "", false, true);
            }
            if ("Visible".equals(propertyName)) {
                return GOTFinalValueHelper.getPropertyValueStepByStep(item, propertyName, FALSE, true, true);
            }
            if ("NotNull".equals(propertyName)) {
                return GOTFinalValueHelper.getPropertyValueStepByStep(item, propertyName, "", false, true);
            }
            if ("DisplayStyle".equals(propertyName)) {
                return GOTFinalValueHelper.getPropertyValueStepByStep(item, propertyName, "", false, true);
            }
            return null;
        }
        if ("FormDataSourceField".equals(nodeName) || "TableField".equals(nodeName) || "DataType".equals(nodeName) || "Enum".equals(nodeName)) {
            value = "AllowEdit".equals(propertyName) ? GOTFinalValueHelper.getPropertyValueStepByStep(item, propertyName, FALSE, true, true) : ("Visible".equals(propertyName) ? GOTFinalValueHelper.getPropertyValueStepByStep(item, propertyName, FALSE, true, true) : ("NotNull".equals(propertyName) ? GOTFinalValueHelper.getPropertyValueStepByStep(item, propertyName, "", false, true) : GOTFinalValueHelper.getPropertyValueStepByStep(item, propertyName, "", false, true)));
            if ("".equals(value)) {
                if (PROPERTY_LABEL.equals(propertyName)) {
                    return item.attributeValue(ATTR_NAME);
                }
            } else {
                return value == null ? "" : value;
            }
        }
        if ("FormDataSourceFieldGroup".equals(nodeName) && PROPERTY_LABEL.equals(propertyName)) {
            Element pFormDataSourceFieldGroup_FieldGroup = gongqi.erp.gotmodel.core.GOTHelper.getProperty((Element)item, (String)PROPERTY_FIELDGROUP);
            String refentityid = pFormDataSourceFieldGroup_FieldGroup.attributeValue(ATTR_REFENTITYID);
            String refinnerid = pFormDataSourceFieldGroup_FieldGroup.attributeValue(ATTR_REFINNERID);
            Element table = GOTOverwrite.getTable(refentityid);
            Node valuenode = table.selectSingleNode(String.format("TableFieldGroups/TableFieldGroup[@id='%s']/Properties/Property[Name/text()='%s']", refinnerid, propertyName));
            value = valuenode.getText();
            if ("".equals(value) || value == null) {
                return item.attributeValue(ATTR_NAME);
            }
            return value;
        }
        value = gongqi.erp.gotmodel.core.GOTHelper.getPropertyValue((Element)item, (String)propertyName);
        if ("".equals(value) || value == null) {
            if (propertyName.equals("Title") && nodeName.equals("Form")) {
                return GOTFinalValueHelper.getTitleByForm(item);
            }
            if (propertyName.equals(PROPERTY_LABEL) && nodeName.equals(PROPERTY_MENUITEM)) {
                return GOTFinalValueHelper.getLabelByForm(item);
            }
            if (propertyName.equals(PROPERTY_LABEL) && nodeName.equals("MenuRefMenu")) {
                Element refMenu;
                Element refMenuPro = GOTFinalValueHelper.getProperty(item, "Menu");
                if (refMenuPro.attribute(ATTR_REFENTITYID) != null && (refMenu = GOTFinalValueHelper.getMenu(refMenuPro.attributeValue(ATTR_REFENTITYID))) != null) {
                    return GOTFinalValueHelper.getFinalValue(refMenu, propertyName);
                }
                return item.attributeValue(ATTR_NAME);
            }
            if (propertyName.equals(PROPERTY_LABEL) && nodeName.equals("MenuRefMenuItem")) {
                Element refMenuItem;
                Element refMenuItemPro = GOTFinalValueHelper.getProperty(item, PROPERTY_MENUITEM);
                if (refMenuItemPro.attribute(ATTR_REFENTITYID) != null && (refMenuItem = GOTFinalValueHelper.getMenuItem(refMenuItemPro.attributeValue(ATTR_REFENTITYID))) != null) {
                    return GOTFinalValueHelper.getLabelByForm(refMenuItem);
                }
                return item.attributeValue(ATTR_NAME);
            }
            if (propertyName.equals(PROPERTY_LABEL) && !nodeName.equals("EnumItem")) {
                return item.attributeValue(ATTR_NAME);
            }
            if (propertyName.equals("DefaultOrderBy")) {
                Element table;
                Element tablePro;
                if (nodeName.equals("FormDataSource") && (tablePro = GOTFinalValueHelper.getProperty(item, "Table")).attribute(ATTR_REFENTITYID) != null && (table = GotXmlDto.getInstance().currentEntityByTypeAndId("Table", tablePro.attributeValue(ATTR_REFENTITYID))) != null) {
                    return GOTFinalValueHelper.getFinalValue(table, propertyName);
                }
                return "RecIdx";
            }
        }
        return value;
    }

    public static String getTitleByForm(Element form) {
        Element table;
        Element tablePro;
        Element mainSourceXML;
        Element tablePro2;
        String label = "";
        String menuItemid = form.attributeValue("menuItemId");
        Element menuItem = null;
        if (!"".equals(menuItemid) && menuItemid != null && (menuItem = GOTFinalValueHelper.getMenuItem(menuItemid)) != null && (label = GOTFinalValueHelper.getPropertyValue(menuItem, PROPERTY_LABEL)) != "") {
            return label;
        }
        List<Element> titlePro = GOTHelp.getPPAttElementList(form, "Name", "Title");
        label = titlePro.get(0).elementText("Value");
        if (label != "") {
            return label;
        }
        Element dataSource = GOTFinalValueHelper.getTitleFormDataSource(form);
        if (dataSource != null && (tablePro2 = GOTHelp.getPPAttElement(dataSource, "Name", "Table")).attribute(ATTR_REFENTITYID) != null) {
            Element table2 = GOTFinalValueHelper.getTable(tablePro2.attributeValue(ATTR_REFENTITYID));
            if (table2 == null) {
                throw new Error("GOT\u9519\u8bef \u5728DataSource\u7684Table\u4e0a\u627e\u4e0d\u5230Table Entity");
            }
            List<Element> labelPro = GOTHelp.getPPAttElementList(table2, "Name", PROPERTY_LABEL);
            label = labelPro.get(0).elementText("Value");
            if (!label.equals("")) {
                return label;
            }
        }
        if ((mainSourceXML = GOTFinalValueHelper.getFirstMainSource(form)) != null && (tablePro = GOTFinalValueHelper.getProperty(mainSourceXML, "Table")) != null && tablePro.attribute(ATTR_REFENTITYID) != null && (table = GOTFinalValueHelper.getTable(tablePro.attributeValue(ATTR_REFENTITYID))) != null && !(label = GOTFinalValueHelper.getPropertyValue(table, PROPERTY_LABEL)).equals("")) {
            return label;
        }
        if (menuItem != null) {
            return menuItem.attributeValue(ATTR_NAME);
        }
        return form.attributeValue(ATTR_NAME);
    }

    public static Element getMenuItem(String _id) {
        Element element = GotXmlDto.getInstance().currentEntityByTypeAndId(PROPERTY_MENUITEM, _id);
        return element;
    }

    public static String getPropertyValue(Element xml, String property) {
        return GOTHelp.getPPAttValue(xml, "Name", property);
    }

    public static Element getTitleFormDataSource(Element form) {
        List dataSource = form.element("FormDataSources").elements("FormDataSource");
        if (dataSource != null && dataSource.size() == 1) {
            return (Element)dataSource.get(0);
        }
        return null;
    }

    public static Element getTable(String _id) {
        Element element = GotXmlDto.getInstance().currentEntityByTypeAndId("Table", _id);
        return element;
    }

    private static Element getFirstMainSource(Element form) {
        List formDataSources = form.selectNodes("FormDataSources/FormDataSource");
        for (Element formDataSource : formDataSources) {
            String datasource = GOTFinalValueHelper.getPropertyValue(formDataSource, "JoinSource");
            if (datasource != null && !datasource.equals("")) continue;
            return formDataSource;
        }
        return null;
    }

    public static Element getProperty(Element xml, String property) {
        List<Element> list = GOTHelp.getPPAttElementList(xml, "Name", property);
        if (list.size() != 1) {
            return null;
        }
        return list.get(0);
    }

    public static String getLabelByForm(Element menuItem) {
        Element table;
        Element tablePro;
        Element tablePro2;
        String label = "";
        if (menuItem != null && !(label = GOTFinalValueHelper.getPropertyValue(menuItem, PROPERTY_LABEL)).equals("")) {
            return label;
        }
        Element refpro = GOTFinalValueHelper.getProperty(menuItem, PROPERTY_SOURCE);
        String refid = refpro.attributeValue(ATTR_REFENTITYID);
        if ("".equals(refid)) {
            if (menuItem != null) {
                return menuItem.attributeValue(ATTR_NAME);
            }
            return "";
        }
        Element form = GotXmlDto.getInstance().currentEntityByTypeAndId("Form", refid);
        if (form == null) {
            if (menuItem != null) {
                return menuItem.attributeValue(ATTR_NAME);
            }
            return "";
        }
        List<Element> titlePro = GOTHelp.getPPAttElementList(form, "Name", "Title");
        label = titlePro.get(0).elementText("Value");
        if (!label.equals("")) {
            return label;
        }
        Element dataSource = GOTFinalValueHelper.getTitleFormDataSource(form);
        if (dataSource != null && (tablePro2 = GOTHelp.getPPAttElementList(dataSource, "Name", "Table").get(0)).attribute(ATTR_REFENTITYID) != null) {
            Element table2 = GotXmlDto.getInstance().currentEntityByTypeAndId("Table", tablePro2.attributeValue(ATTR_REFENTITYID));
            if (table2 == null) {
                throw new Error("GOT\u9519\u8bef \u5728DataSource\u7684Table\u4e0a\u627e\u4e0d\u5230Table Entity");
            }
            List<Element> labelPro = GOTHelp.getPPAttElementList(table2, "Name", PROPERTY_LABEL);
            label = labelPro.get(0).elementText("Value");
            if (!label.equals("")) {
                return label;
            }
        }
        List sources = form.selectNodes("FormDataSources/FormDataSource");
        Element mainSource = null;
        for (Element item : sources) {
            String joinType = GOTFinalValueHelper.getPropertyValue(item, "JoinType");
            if (!joinType.equals("Passive") && !joinType.equals("Delayed") && !joinType.equals("Active") && !joinType.equals("")) continue;
            mainSource = item;
            break;
        }
        if (mainSource != null && (tablePro = GOTFinalValueHelper.getProperty(mainSource, "Table")) != null && tablePro.attribute(ATTR_REFENTITYID) != null && (table = GotXmlDto.getInstance().currentEntityByTypeAndId("Table", tablePro.attributeValue(ATTR_REFENTITYID))) != null && !(label = GOTFinalValueHelper.getPropertyValue(table, PROPERTY_LABEL)).equals("")) {
            return label;
        }
        if (menuItem != null) {
            return menuItem.attributeValue(ATTR_NAME);
        }
        return form.attributeValue(ATTR_NAME);
    }

    public static Element getMenu(String _id) {
        Element element = GotXmlDto.getInstance().currentEntityByTypeAndId("Menu", _id);
        return element;
    }
}

