/*
 * Decompiled with CFR 0.152.
 */
package gongqi.gdt.designer.core.got.node.menuitem;

import gongqi.designer.utils.GOTHelper;
import gongqi.erp.gotmodel.core.EntityType;
import gongqi.gdt.designer.core.got.node.Entity;
import gongqi.gdt.designer.core.got.node.NodeGOT;
import gongqi.gdt.designer.core.toolsgot.GOTXMLHelper;
import gongqi.gdt.designer.core.toolsgot.Macros;
import info.gongqi.got.model.GotXmlDto;
import info.gongqi.got.tool.GOTHelp;
import info.gongqi.got.ui.LoadXmlCore;
import info.gongqi.got.util.GOTMessageDialog;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.dom4j.Element;

public class MenuItem
extends Entity {
    @Override
    public List<String> getPropertyItemEditorArray(String propertyName, String fixedRegular, Element fixedBaseXML) {
        if (propertyName.equals("RefObject")) {
            ArrayList<String> array = new ArrayList<String>();
            List<Element> sourceTypePro = GOTHelp.getPPAttElementList(this.xml, "Name", "SourceType");
            List<Object> forms = new ArrayList();
            if (sourceTypePro.get(0).attributeValue("Value").equals("Form")) {
                forms = GotXmlDto.getInstance().currentElements("Forms");
            }
            for (Element form : forms) {
                array.add(form.attributeValue("name"));
            }
            return array;
        }
        return super.getPropertyItemEditorArray(propertyName, "", null);
    }

    @Override
    public void doAfterPropertyModified(Element property, String ... args) {
        List<Element> sourceTypePro = GOTHelp.getPPAttElementList(this.xml, "Name", "SourceType");
        if (property.elementText("Name").equals("Source")) {
            String source = sourceTypePro.get(0).elementText("Value");
            String formName = property.elementText("Value");
            List<Element> form = null;
            if (source.equals("Form")) {
                form = GotXmlDto.getInstance().currentElements("Forms", "name", formName);
            } else if (source.equals("Report")) {
                form = GotXmlDto.getInstance().currentElements("Reports", "name", formName);
            }
            if (form != null && form.size() > 0) {
                property.addAttribute("refentityid", form.get(0).attributeValue("id"));
            } else if (property.attribute("refentityid") != null) {
                property.remove(property.attribute("refentityid"));
            }
        }
        super.doAfterPropertyModified(property, args);
    }

    @Override
    protected void doPropertyTrigger(Element property) {
        super.doPropertyTrigger(property);
        if (property.elementText("Name").equals("Source") && this.xml.attributeValue("name").contains("A_MenuItem")) {
            Element sourcePro = GOTHelper.getProperty((Element)this.xml, (String)"SourceType");
            String source = sourcePro.elementText("Value");
            if (source.equals("Form")) {
                String entityId = this.xml.attributeValue("id");
                String solutionName = null;
                if (entityId.indexOf(".") != -1) {
                    solutionName = entityId.substring(0, entityId.lastIndexOf("."));
                }
                if (StringUtils.isNotBlank(solutionName)) {
                    this.xml.addAttribute("name", String.valueOf(solutionName) + "." + property.elementText("Value"));
                } else {
                    this.xml.addAttribute("name", property.elementText("Value"));
                }
            } else if (!source.equals("Html")) {
                this.xml.addAttribute("name", String.valueOf(source) + "_" + property.elementText("Value"));
            }
            this.setEntityUniqueName();
        }
    }

    private void setEntityUniqueName() {
        String origName;
        Element outer = this.xml.getParent();
        String newName = origName = this.xml.attributeValue("name");
        if (origName.contains(".")) {
            origName = origName.substring(origName.lastIndexOf("."), origName.length());
        }
        if (MenuItem.checkParentNodes(outer)) {
            outer = GotXmlDto.getInstance().getCurrentElements("MenuItems");
        }
        int last = 0;
        List elements = outer.selectNodes("./MenuItem");
        boolean duplicateName = false;
        for (Element menuItem : elements) {
            int num;
            String suffix;
            if (menuItem.attributeValue("id").equals(this.xml.attributeValue("id")) || menuItem.attribute("name") == null) continue;
            String menuItemName = menuItem.attributeValue("name");
            if (menuItemName.equals(origName)) {
                duplicateName = true;
            }
            if (!menuItemName.startsWith(origName) || !MenuItem.isNumber(suffix = menuItemName.replace(origName, "")) || (num = Integer.valueOf(suffix).intValue()) <= last) continue;
            last = num;
        }
        if (duplicateName) {
            newName = last > 0 ? String.valueOf(newName) + ++last : String.valueOf(newName) + 1;
        }
        this.xml.addAttribute("name", newName);
    }

    @Override
    public void doAfterDragDroped() {
        List<Element> refObjectPro = GOTHelp.getPPAttElementList(this.xml, "Name", "Source");
        this.doAfterPropertyModified(refObjectPro.get(0), new String[0]);
        String id = "";
        try {
            id = LoadXmlCore.gotServices.getEntityId(EntityType.MenuItem);
        }
        catch (Exception e) {
            Logger.getLogger(this.getClass()).error((Object)e);
            GOTMessageDialog.alert(e);
        }
        this.xml.addAttribute("id", id);
    }

    @Override
    public NodeGOT getAccpDragNewNode(Element src) {
        NodeGOT node = super.doAccpDragNew("MenuItem", "");
        this.doAccpDragNewAfter(src, node.xml);
        return node;
    }

    private void doAccpDragNewAfter(Element src, Element node) {
        String srcName = src.getName();
        GOTXMLHelper.setProperty(node, "SourceType", srcName, true);
        GOTXMLHelper.setProperty(node, "Source", src.attributeValue("name"), true);
    }

    @Override
    public String getAccpDragNewInsertBase() {
        return "parent";
    }

    @Override
    protected String validateProperties(Element nodeBeValidated) {
        Element property = GOTHelper.getProperty((Element)nodeBeValidated, (String)"Source");
        if (property.attribute("refentityid") != null) {
            String subForm;
            Element sourcePro = GOTHelper.getProperty((Element)nodeBeValidated, (String)"SourceType");
            String source = sourcePro.elementText("Value");
            String entityId = property.attributeValue("refentityid");
            Element entities = null;
            if (source.equals("Form")) {
                entities = GotXmlDto.getInstance().currentEntityByTypeAndId("Form", entityId);
            }
            if (entities == null) {
                return "RefObject \u5173\u8054\u65e0\u6548";
            }
            if (source.equals("Form") && "SubForm".equals(subForm = GOTHelp.getPPAttValue(entities, "Name", "FormType"))) {
                return "SubForm\u5c5e\u6027\u4e3atrue\u7684Form\uff0c\u4e0d\u80fd\u4fdd\u5b58\u4e3aMenuItem";
            }
        }
        return Macros.INFO_TRUE;
    }

    @Override
    public String validateAccpDragNew(Element srcItem) {
        String formType;
        String qName;
        if (srcItem != null && "Form".equals(qName = srcItem.getName()) && "Lookup".equals(formType = GOTHelper.getPropertyValue((Element)srcItem, (String)"FormType"))) {
            return "FormType\u5c5e\u6027\u4e3aLookup\u7684Form\u4e0d\u5141\u8bb8\u88ab\u62d6\u52a8\u5230MenuItem";
        }
        return "true";
    }

    @Override
    public String validateBeforeSave() {
        String source;
        String sourceType = GOTHelper.getPropertyValue((Element)this.xml, (String)"SourceType");
        if ("Form".equals(sourceType) && StringUtils.isBlank((String)(source = GOTHelper.getPropertyValue((Element)this.xml, (String)"Source")))) {
            return "grid\u3010Source\u3011\u5c5e\u6027\u4e0d\u5141\u8bb8\u4e3a\u7a7a";
        }
        return super.validateBeforeSave();
    }
}

