/*
 * Decompiled with CFR 0.152.
 */
package gongqi.gdt.designer.ui;

import gongqi.erp.framework.core.FrameworkManager;
import gongqi.erp.framework.core.LayerDefination;
import gongqi.erp.framework.core.LayerDefinationManager;
import gongqi.erp.framework.core.LayerDeploymentMode;
import gongqi.erp.framework.core.LayerResolver;
import gongqi.erp.framework.core.ObjectContainer;
import gongqi.erp.framework.core.extension.SolutionExtensionDefinition;
import gongqi.erp.framework.core.extension.SolutionExtensionDefinitionManager;
import gongqi.erp.framework.core.extension.SolutionExtensionDeploymentMode;
import gongqi.erp.framework.core.plugin.SolutionPluginDefinition;
import gongqi.erp.framework.core.plugin.SolutionPluginDefinitionManager;
import gongqi.erp.framework.core.plugin.SolutionPluginDeploymentMode;
import gongqi.erp.framework.core.solution.SolutionDefinition;
import gongqi.erp.framework.core.solution.SolutionDefinitionManager;
import gongqi.erp.framework.core.solution.SolutionDeploymentMode;
import gongqi.erp.framework.tools.ZipUtil;
import gongqi.erp.framework.util.FileUtils;
import gongqi.gdt.designer.ProjectConstants;
import gongqi.gdt.designer.ui.DependVersionDialog;
import gongqi.gdt.designer.ui.MarketOnlineVersion;
import gongqi.gdt.designer.utils.Images;
import gongqi.gdt.designer.utils.PedestalLayerInfo;
import gongqi.gdt.designer.utils.SWTUtils;
import gongqi.gdt.designer.utils.SolutionExtInfo;
import gongqi.gdt.designer.utils.SolutionLayerInfo;
import gongqi.gdt.designer.utils.SolutionPluginInfo;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.UUID;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.exception.ExceptionUtils;
import org.apache.log4j.Logger;
import org.dom4j.Document;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolItem;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeColumn;
import org.eclipse.swt.widgets.TreeItem;

public class LayerChainPage {
    private Shell shell;
    private Table pedestal;
    private Tree tree;
    private Label updateInfo;
    private Font font = new Font((Device)Display.getCurrent(), "\u5fae\u8f6f\u96c5\u9ed1", 9, 0);
    private static Map<String, PedestalLayerInfo> pedestalInfos;
    private static Map<String, SolutionLayerInfo> solutionInfos;
    private static Logger log;
    private Button button_Match;
    private Button button_Confirm;
    private ToolItem showBinaryOnly;
    private ToolItem showUpgradeOnly;
    private Consumer<String> confirmCallBack;
    private Consumer<String> openCallBack;

    static {
        log = Logger.getLogger(LayerChainPage.class);
    }

    public LayerChainPage(Consumer<String> confirmCallBack, Consumer<String> openCallBack) {
        Display display = Display.getCurrent();
        this.shell = new Shell(display.getActiveShell(), 208);
        this.shell.setText("\u5c42\u94fe\u5347\u7ea7");
        this.shell.setLayout((Layout)new FormLayout());
        this.shell.setSize(SWTUtils.zoom(750), SWTUtils.zoom(500));
        Rectangle bounds = Display.getDefault().getPrimaryMonitor().getBounds();
        Rectangle rect = this.shell.getBounds();
        int x = bounds.x + (bounds.width - rect.width) / 2;
        int y = bounds.y + (bounds.height - rect.height) / 2;
        this.shell.setLocation(x, y);
        this.confirmCallBack = confirmCallBack;
        this.openCallBack = openCallBack;
    }

    public void open() {
        this.createContent();
        this.shell.open();
        Display display = this.shell.getDisplay();
        while (!this.shell.isDisposed()) {
            if (display.readAndDispatch()) continue;
            display.sleep();
        }
    }

    protected void createContent() {
        ToolBar toolBar = new ToolBar((Composite)this.shell, 8519744);
        FormData formData = new FormData();
        formData.bottom = new FormAttachment(100, SWTUtils.zoom(-3));
        formData.right = new FormAttachment(100, SWTUtils.zoom(-90));
        toolBar.setLayoutData((Object)formData);
        this.showUpgradeOnly = new ToolItem(toolBar, 131104);
        this.showUpgradeOnly.setImage(Images.getIcon("layerUpgrade/Upgrade.png"));
        this.showUpgradeOnly.setToolTipText("\u4ec5\u663e\u793a\u5347\u7ea7\u5c42");
        this.showBinaryOnly = new ToolItem(toolBar, 131104);
        this.showBinaryOnly.setImage(Images.getIcon("layerUpgrade/Binary.png"));
        this.showBinaryOnly.setToolTipText("\u4ec5\u663e\u793a\u4e8c\u8fdb\u5236\u5c42");
        SelectionAdapter filterListen = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                LayerChainPage.this.buildTable();
                LayerChainPage.this.buildTree();
            }
        };
        this.showUpgradeOnly.addSelectionListener((SelectionListener)filterListen);
        this.showBinaryOnly.addSelectionListener((SelectionListener)filterListen);
        this.updateInfo = new Label((Composite)this.shell, 16384);
        formData = new FormData();
        formData.top = new FormAttachment((Control)toolBar, 0, 128);
        formData.bottom = new FormAttachment((Control)toolBar, 0, 1024);
        formData.left = new FormAttachment(0, SWTUtils.zoom(5));
        formData.right = new FormAttachment((Control)toolBar, SWTUtils.zoom(2), 16384);
        this.updateInfo.setForeground(Display.getCurrent().getSystemColor(9));
        this.updateInfo.setLayoutData((Object)formData);
        this.pedestal = new Table((Composite)this.shell, 0x10010800);
        this.pedestal.setHeaderVisible(true);
        this.pedestal.setLinesVisible(false);
        formData = new FormData();
        formData.left = new FormAttachment(0, SWTUtils.zoom(5));
        formData.right = new FormAttachment((Control)toolBar, 0, 131072);
        formData.top = new FormAttachment(0, SWTUtils.zoom(5));
        formData.bottom = new FormAttachment(25);
        this.pedestal.setLayoutData((Object)formData);
        this.pedestal.setFont(this.font);
        TableColumn layerName = new TableColumn(this.pedestal, 0);
        layerName.setText("\u5c42\u540d");
        layerName.setWidth(SWTUtils.zoom(180));
        TableColumn layerSpace = new TableColumn(this.pedestal, 0);
        layerSpace.setText("\u5c42\u7a7a\u95f4");
        layerSpace.setWidth(SWTUtils.zoom(100));
        TableColumn layerLabel = new TableColumn(this.pedestal, 0);
        layerLabel.setText("\u5c42\u6807\u7b7e");
        layerLabel.setWidth(SWTUtils.zoom(100));
        TableColumn LayerDeployMode = new TableColumn(this.pedestal, 0x1000000);
        LayerDeployMode.setText("\u90e8\u7f72\u6a21\u5f0f");
        LayerDeployMode.setWidth(SWTUtils.zoom(60));
        TableColumn currentVersion = new TableColumn(this.pedestal, 0);
        currentVersion.setText("\u5f53\u524d\u7248\u672c");
        currentVersion.setWidth(SWTUtils.zoom(80));
        TableColumn targetVersion = new TableColumn(this.pedestal, 0);
        targetVersion.setText("\u76ee\u6807\u7248\u672c");
        targetVersion.setWidth(SWTUtils.zoom(80));
        this.pedestal.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseDown(MouseEvent e) {
                PedestalLayerInfo pedestalLayerInfo;
                TableItem[] selections = LayerChainPage.this.pedestal.getSelection();
                if (selections.length == 0) {
                    return;
                }
                final TableItem select = selections[0];
                if (LayerChainPage.this.pedestal.getMenu() != null) {
                    LayerChainPage.this.pedestal.getMenu().dispose();
                }
                if ((pedestalLayerInfo = (PedestalLayerInfo)pedestalInfos.get(select.getData("LayerName"))) == null) {
                    return;
                }
                if (e.button == 3 && select != null) {
                    Menu layMenu = new Menu((Control)LayerChainPage.this.pedestal);
                    MenuItem addItem = new MenuItem(layMenu, 8);
                    addItem.setText("\u7248\u672c\u9009\u62e9");
                    addItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

                        public void widgetSelected(SelectionEvent e) {
                            LayerChainPage.this.selectOnlineFile(select);
                        }
                    });
                    MenuItem add_Local = new MenuItem(layMenu, 8);
                    add_Local.setText("\u672c\u5730\u4e0a\u4f20");
                    add_Local.addSelectionListener((SelectionListener)new SelectionAdapter(){

                        public void widgetSelected(SelectionEvent e) {
                            block6: {
                                FileDialog dialog = new FileDialog(LayerChainPage.this.shell, 69634);
                                dialog.setFilterExtensions(new String[]{"*.lyr"});
                                dialog.setText("\u5347\u7ea7\u6587\u4ef6");
                                dialog.open();
                                String[] selectFileNames = dialog.getFileNames();
                                if (selectFileNames != null && selectFileNames.length > 0) {
                                    File selectFile = new File(dialog.getFilterPath(), selectFileNames[0]);
                                    if (selectFile.exists() && selectFile.getName().endsWith(".lyr")) {
                                        FrameworkManager.registerObjects();
                                        LayerResolver layerResolver = (LayerResolver)ObjectContainer.getInstance(LayerResolver.class);
                                        try {
                                            LayerDefination layerDefination = layerResolver.resolveLayer(selectFile.getAbsolutePath());
                                            String layerName = layerDefination.getLayerName();
                                            PedestalLayerInfo pedestalInfo = (PedestalLayerInfo)pedestalInfos.get(select.getData("LayerName"));
                                            if (pedestalInfo.getLayerId().equals(layerName)) {
                                                FileUtils.copyFile((File)selectFile, (File)pedestalInfo.getUpdateFile(layerDefination.getLayerVersion()));
                                                pedestalInfo.setTargetVersion(layerDefination.getLayerVersion());
                                                pedestalInfo.setOnline(false);
                                                pedestalInfo.updateBindItem();
                                                break block6;
                                            }
                                            MessageDialog.openError((Shell)LayerChainPage.this.shell, (String)"\u63d0\u793a", (String)String.format("\u8bf7\u9009\u62e9\u3010%s\u3011\u5c42\u7684\u5347\u7ea7\u6587\u4ef6", pedestalInfo.getLayerId()));
                                        }
                                        catch (Exception exception) {
                                            MessageDialog.openError((Shell)LayerChainPage.this.shell, (String)"\u63d0\u793a", (String)"\u5347\u7ea7\u7684\u5c42\u6587\u4ef6\u975e\u6cd5");
                                        }
                                    } else {
                                        MessageDialog.openError((Shell)LayerChainPage.this.shell, (String)"\u63d0\u793a", (String)"\u65e0\u6548\u7684\u5347\u7ea7\u6587\u4ef6");
                                    }
                                }
                            }
                        }
                    });
                    MenuItem clearItem = new MenuItem(layMenu, 8);
                    clearItem.setText("\u91cd\u7f6e");
                    clearItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

                        public void widgetSelected(SelectionEvent e) {
                            PedestalLayerInfo pedestalLayerInfo = (PedestalLayerInfo)pedestalInfos.get(select.getData("LayerName"));
                            pedestalLayerInfo.setOnline(null);
                            pedestalLayerInfo.setTargetVersion(null);
                            pedestalLayerInfo.setDownloadUrl(null);
                            pedestalLayerInfo.updateBindItem();
                            LayerChainPage.this.updateInfoRefresh();
                        }
                    });
                    addItem.setEnabled(false);
                    add_Local.setEnabled(false);
                    clearItem.setEnabled(false);
                    if (pedestalLayerInfo.getDeploymentMode().equals((Object)LayerDeploymentMode.Package)) {
                        PedestalLayerInfo lowerLayerInfo = pedestalLayerInfo.getLowerLayerInfo();
                        addItem.setEnabled(true);
                        add_Local.setEnabled(true);
                        while (lowerLayerInfo != null) {
                            if (lowerLayerInfo.getDeploymentMode().equals((Object)LayerDeploymentMode.Source)) {
                                addItem.setEnabled(false);
                                add_Local.setEnabled(false);
                                break;
                            }
                            lowerLayerInfo = lowerLayerInfo.getLowerLayerInfo();
                        }
                    }
                    if (pedestalLayerInfo.isOnline() != null) {
                        clearItem.setEnabled(true);
                    }
                    LayerChainPage.this.pedestal.setMenu(layMenu);
                }
            }
        });
        this.tree = new Tree((Composite)this.shell, 67842);
        this.tree.setHeaderVisible(true);
        this.tree.setLinesVisible(false);
        formData = new FormData();
        formData.left = new FormAttachment((Control)this.pedestal, 0, 16384);
        formData.right = new FormAttachment((Control)this.pedestal, 0, 131072);
        formData.top = new FormAttachment((Control)this.pedestal, SWTUtils.zoom(5), 1024);
        formData.bottom = new FormAttachment((Control)toolBar, SWTUtils.zoom(-5), 128);
        this.tree.setLayoutData((Object)formData);
        this.tree.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseDown(MouseEvent e) {
                final TreeItem select = LayerChainPage.this.tree.getSelection()[0];
                final String type = (String)select.getData("type");
                if (LayerChainPage.this.tree.getMenu() != null) {
                    LayerChainPage.this.tree.getMenu().dispose();
                }
                if (type.equals("ext")) {
                    return;
                }
                if (e.button == 3 && select != null) {
                    Menu layMenu = new Menu((Control)LayerChainPage.this.tree);
                    MenuItem addItem = new MenuItem(layMenu, 8);
                    addItem.setText("\u7248\u672c\u9009\u62e9");
                    addItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

                        public void widgetSelected(SelectionEvent e) {
                            LayerChainPage.this.selectOnlineFile(select);
                        }
                    });
                    MenuItem add_Local = new MenuItem(layMenu, 8);
                    add_Local.setText("\u672c\u5730\u4e0a\u4f20");
                    add_Local.addSelectionListener((SelectionListener)new SelectionAdapter(){

                        public void widgetSelected(SelectionEvent e) {
                            block31: {
                                FileDialog dialog = new FileDialog(LayerChainPage.this.shell, 69634);
                                if (type.equals("app")) {
                                    dialog.setFilterExtensions(new String[]{"*.app"});
                                } else if (type.equals("plg")) {
                                    dialog.setFilterExtensions(new String[]{"*.plugin"});
                                } else {
                                    return;
                                }
                                dialog.setText("\u5347\u7ea7\u6587\u4ef6");
                                dialog.open();
                                String[] selectFileNames = dialog.getFileNames();
                                if (selectFileNames == null || selectFileNames.length <= 0) {
                                    return;
                                }
                                File updateFile = new File(dialog.getFilterPath(), selectFileNames[0]);
                                try {
                                    if (type.equals("app")) {
                                        SolutionLayerInfo solutionLayerInfo = (SolutionLayerInfo)solutionInfos.get(select.getText(1));
                                        File targetLayersRootDir = new File(FileUtils.getTempDirectory(), UUID.randomUUID().toString());
                                        targetLayersRootDir.mkdirs();
                                        try {
                                            try {
                                                String version;
                                                ZipUtil.unZipFiles((String)updateFile.getAbsolutePath(), (String)targetLayersRootDir.getAbsolutePath());
                                                File appXML = new File(targetLayersRootDir, "/Application.xml");
                                                Element document = FileUtils.readFileToDocument((File)appXML).getRootElement();
                                                String name = document.element("name").getText();
                                                String string = version = document.element("version") == null ? "" : document.element("version").getText();
                                                if (!solutionLayerInfo.getSolutionId().equals(name)) {
                                                    throw new RuntimeException(String.format("\u8bf7\u9009\u62e9\u5e94\u7528\u3010%s\u3011\u7684\u5347\u7ea7\u6587\u4ef6", solutionLayerInfo.getSolutionId()));
                                                }
                                                FileUtils.copyFile((File)updateFile, (File)solutionLayerInfo.getUpdateFile(version));
                                                solutionLayerInfo.setTargetVersion(version);
                                                solutionLayerInfo.setOnline(false);
                                                solutionLayerInfo.updateBindItem();
                                            }
                                            catch (IOException e1) {
                                                throw new RuntimeException(String.format("\u5347\u7ea7\u5c42\u6587\u4ef6\u89e3\u6790\u9519\u8bef\uff0c\u8bf7\u68c0\u67e5\u6587\u4ef6\u662f\u5426\u635f\u574f\uff1a%s", updateFile.getAbsolutePath()), e1);
                                            }
                                        }
                                        catch (Throwable throwable) {
                                            if (targetLayersRootDir.exists()) {
                                                try {
                                                    FileUtils.deleteDirectory((File)targetLayersRootDir);
                                                }
                                                catch (IOException iOException) {}
                                            }
                                            throw throwable;
                                        }
                                        if (targetLayersRootDir.exists()) {
                                            try {
                                                FileUtils.deleteDirectory((File)targetLayersRootDir);
                                            }
                                            catch (IOException iOException) {}
                                        }
                                        break block31;
                                    }
                                    if (!type.equals("plg")) break block31;
                                    String solutionName = select.getParentItem().getText(1);
                                    SolutionLayerInfo solutionLayerInfo = (SolutionLayerInfo)solutionInfos.get(solutionName);
                                    SolutionPluginInfo pluginInfo = solutionLayerInfo.getPluginInfo(select.getText(1));
                                    File targetLayersRootDir = new File(FileUtils.getTempDirectory(), UUID.randomUUID().toString());
                                    targetLayersRootDir.mkdirs();
                                    try {
                                        try {
                                            String version;
                                            ZipUtil.unZipFiles((String)updateFile.getAbsolutePath(), (String)targetLayersRootDir.getAbsolutePath());
                                            File pluginXML = new File(targetLayersRootDir, "/ApplicationPlugin.xml");
                                            Element document = FileUtils.readFileToDocument((File)pluginXML).getRootElement();
                                            String pluginName = document.element("name").getText();
                                            String string = version = document.element("version") == null ? "" : document.element("version").getText();
                                            if (!pluginInfo.getPluginId().equals(pluginName)) {
                                                throw new RuntimeException(String.format("\u8bf7\u9009\u62e9\u63d2\u4ef6\u3010%s\u3011\u7684\u5347\u7ea7\u6587\u4ef6", pluginInfo.getPluginId()));
                                            }
                                            FileUtils.copyFile((File)updateFile, (File)pluginInfo.getUpdateFile(version));
                                            pluginInfo.setTargetVersion(version);
                                            pluginInfo.setOnline(false);
                                            pluginInfo.updateBindItem();
                                        }
                                        catch (IOException e1) {
                                            throw new RuntimeException(String.format("\u5347\u7ea7\u5c42\u6587\u4ef6\u89e3\u6790\u9519\u8bef\uff0c\u8bf7\u68c0\u67e5\u6587\u4ef6\u662f\u5426\u635f\u574f\uff1a%s", updateFile.getAbsolutePath()), e1);
                                        }
                                    }
                                    catch (Throwable throwable) {
                                        if (targetLayersRootDir.exists()) {
                                            try {
                                                FileUtils.deleteDirectory((File)targetLayersRootDir);
                                            }
                                            catch (IOException iOException) {}
                                        }
                                        throw throwable;
                                    }
                                    if (targetLayersRootDir.exists()) {
                                        try {
                                            FileUtils.deleteDirectory((File)targetLayersRootDir);
                                        }
                                        catch (IOException iOException) {}
                                    }
                                }
                                catch (Exception e1) {
                                    MessageDialog.openError((Shell)LayerChainPage.this.shell, (String)"\u63d0\u793a", (String)e1.getMessage());
                                }
                            }
                        }
                    });
                    MenuItem clearItem = new MenuItem(layMenu, 8);
                    clearItem.setText("\u91cd\u7f6e");
                    clearItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

                        public void widgetSelected(SelectionEvent e) {
                            if (type.equals("app")) {
                                TreeItem[] plugins;
                                SolutionLayerInfo solutionLayerInfo = (SolutionLayerInfo)solutionInfos.get(select.getText(1));
                                solutionLayerInfo.setOnline(null);
                                solutionLayerInfo.setTargetVersion(null);
                                solutionLayerInfo.setAppUserId(null);
                                solutionLayerInfo.updateBindItem();
                                TreeItem[] treeItemArray = plugins = select.getItems();
                                int n = plugins.length;
                                int n2 = 0;
                                while (n2 < n) {
                                    TreeItem treeItem = treeItemArray[n2];
                                    String pluginName = treeItem.getText(1);
                                    SolutionPluginInfo pluginInfo = solutionLayerInfo.getPluginInfo(pluginName);
                                    if (pluginInfo != null) {
                                        pluginInfo.setDownloadPluginId(null);
                                        pluginInfo.setOnline(null);
                                        pluginInfo.setTargetVersion(null);
                                        pluginInfo.updateBindItem();
                                    }
                                    ++n2;
                                }
                            } else if (type.equals("plg")) {
                                String pluginName = select.getText(1);
                                String solutionName = select.getParentItem().getText(1);
                                SolutionLayerInfo solutionLayerInfo = (SolutionLayerInfo)solutionInfos.get(solutionName);
                                SolutionPluginInfo pluginInfo = solutionLayerInfo.getPluginInfo(pluginName);
                                pluginInfo.setDownloadPluginId(null);
                                pluginInfo.setOnline(null);
                                pluginInfo.setTargetVersion(null);
                                pluginInfo.updateBindItem();
                            }
                            LayerChainPage.this.updateInfoRefresh();
                        }
                    });
                    MenuItem dependItem = new MenuItem(layMenu, 8);
                    dependItem.setText("\u4f9d\u8d56\u7248\u672c");
                    dependItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

                        public void widgetSelected(SelectionEvent e) {
                            if (type.equals("app")) {
                                SolutionLayerInfo solutionLayerInfo = (SolutionLayerInfo)solutionInfos.get(select.getText(1));
                                DependVersionDialog dialog = new DependVersionDialog(solutionLayerInfo);
                                dialog.open();
                            } else if (type.equals("plg")) {
                                String pluginName = select.getText(1);
                                String solutionName = select.getParentItem().getText(1);
                                SolutionLayerInfo solutionLayerInfo = (SolutionLayerInfo)solutionInfos.get(solutionName);
                                SolutionPluginInfo pluginInfo = solutionLayerInfo.getPluginInfo(pluginName);
                                DependVersionDialog dialog = new DependVersionDialog(pluginInfo);
                                dialog.open();
                            }
                        }
                    });
                    dependItem.setEnabled(false);
                    clearItem.setEnabled(false);
                    addItem.setEnabled(false);
                    if (type.equals("app")) {
                        SolutionLayerInfo solutionLayerInfo = (SolutionLayerInfo)solutionInfos.get(select.getText(1));
                        if (solutionLayerInfo != null && solutionLayerInfo.getDeploymentMode().equals((Object)SolutionDeploymentMode.Package)) {
                            addItem.setEnabled(true);
                            dependItem.setEnabled(true);
                            if (solutionLayerInfo.isOnline() != null) {
                                clearItem.setEnabled(true);
                            }
                        }
                    } else if (type.equals("plg")) {
                        String pluginName = select.getText(1);
                        String solutionName = select.getParentItem().getText(1);
                        SolutionLayerInfo solutionLayerInfo = (SolutionLayerInfo)solutionInfos.get(solutionName);
                        SolutionPluginInfo pluginInfo = null;
                        if (solutionLayerInfo != null) {
                            pluginInfo = solutionLayerInfo.getPluginInfo(pluginName);
                        }
                        if (pluginInfo != null && pluginInfo.getDeploymentMode().equals((Object)SolutionPluginDeploymentMode.Package)) {
                            addItem.setEnabled(true);
                            dependItem.setEnabled(true);
                            if (pluginInfo.isOnline() != null) {
                                clearItem.setEnabled(true);
                            }
                        }
                    }
                    LayerChainPage.this.tree.setMenu(layMenu);
                }
            }
        });
        TreeColumn solutionName = new TreeColumn(this.tree, 0);
        solutionName.setText("\u5e94\u7528/\u63d2\u4ef6");
        solutionName.setWidth(SWTUtils.zoom(180));
        TreeColumn solutionId = new TreeColumn(this.tree, 0);
        solutionId.setText("\u7f16\u53f7");
        solutionId.setWidth(SWTUtils.zoom(200));
        TreeColumn solutionDeployMode = new TreeColumn(this.tree, 0x1000000);
        solutionDeployMode.setText("\u90e8\u7f72\u6a21\u5f0f");
        solutionDeployMode.setWidth(SWTUtils.zoom(60));
        TreeColumn solutionCurrentVersion = new TreeColumn(this.tree, 0);
        solutionCurrentVersion.setText("\u5f53\u524d\u7248\u672c");
        solutionCurrentVersion.setWidth(SWTUtils.zoom(80));
        TreeColumn solutionTargettVersion = new TreeColumn(this.tree, 0);
        solutionTargettVersion.setText("\u76ee\u6807\u7248\u672c");
        solutionTargettVersion.setWidth(SWTUtils.zoom(80));
        this.button_Match = new Button((Composite)this.shell, 8);
        this.button_Match.setText("\u7248\u672c\u5339\u914d");
        formData = new FormData(SWTUtils.zoom(80), SWTUtils.zoom(32));
        formData.top = new FormAttachment((Control)this.pedestal, 0, 128);
        formData.left = new FormAttachment((Control)this.pedestal, SWTUtils.zoom(5), 131072);
        this.button_Match.setLayoutData((Object)formData);
        Button resetAll = new Button((Composite)this.shell, 8);
        resetAll.setText("\u91cd\u7f6e");
        formData = new FormData(SWTUtils.zoom(80), SWTUtils.zoom(32));
        formData.top = new FormAttachment((Control)this.button_Match, SWTUtils.zoom(5), 1024);
        formData.left = new FormAttachment((Control)this.button_Match, 0, 16384);
        resetAll.setLayoutData((Object)formData);
        resetAll.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                LayerChainPage.this.resetAll();
            }
        });
        this.button_Confirm = new Button((Composite)this.shell, 8);
        this.button_Confirm.setText("\u786e\u8ba4");
        formData = new FormData(SWTUtils.zoom(80), SWTUtils.zoom(32));
        formData.top = new FormAttachment((Control)resetAll, SWTUtils.zoom(5), 1024);
        formData.left = new FormAttachment((Control)resetAll, 0, 16384);
        this.button_Confirm.setLayoutData((Object)formData);
        this.button_Match.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                try {
                    LayerChainPage.this.versionMatch();
                }
                catch (Exception e1) {
                    log.error((Object)"\u7248\u672c\u5339\u914d\u65f6\u51fa\u73b0\u5f02\u5e38", (Throwable)e1);
                    MessageDialog.openError((Shell)LayerChainPage.this.shell, (String)"\u63d0\u793a", (String)ExceptionUtils.getRootCause((Throwable)e1).getMessage());
                }
            }
        });
        this.button_Confirm.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (LayerChainPage.this.ifModify()) {
                    LayerChainPage.updateCache();
                    List<String> results = LayerChainPage.checkBeforeAnalysis();
                    if (results.isEmpty()) {
                        if (LayerChainPage.this.confirmCallBack != null) {
                            LayerChainPage.this.confirmCallBack.accept(LayerChainPage.this.updateInfo.getText());
                        }
                    } else {
                        MessageDialog.openError((Shell)LayerChainPage.this.shell, (String)"\u63d0\u793a", (String)String.join((CharSequence)System.lineSeparator(), results));
                    }
                }
                LayerChainPage.this.shell.close();
            }
        });
        this.findInLocalFileCache();
        this.openCallBack.accept(this.updateInfo.getText());
    }

    protected boolean ifModify() {
        String isOnline;
        Element cache;
        PedestalLayerInfo pedestalLayerInfo;
        File cacheFile = new File(LayerChainPage.getTempFileDir(), "Config.xml");
        Map<Object, Object> Pedestals_Cache = new HashMap();
        Map<Object, Object> Solutions_Cache = new HashMap();
        if (cacheFile.exists()) {
            try {
                Document document = FileUtils.readFileToDocument((File)cacheFile);
                Element Root = document.getRootElement();
                List Pedestals = Root.element("Pedestals").elements("Pedestal");
                List Solutions = Root.element("Solutions").elements("Solution");
                Pedestals_Cache = Pedestals.stream().collect(Collectors.toMap(p -> p.getText(), p -> p));
                Solutions_Cache = Solutions.stream().collect(Collectors.toMap(s -> s.attributeValue("id"), s -> s));
            }
            catch (Exception e) {
                log.error((Object)("\u8bfb\u53d6\u5c42\u94fe\u7f13\u5b58\u6587\u4ef6\u5f02\u5e38:" + cacheFile.getAbsolutePath()), (Throwable)e);
            }
        }
        if ((pedestalLayerInfo = pedestalInfos.get("sys")) != null && !Pedestals_Cache.containsKey("sys")) {
            if (pedestalLayerInfo.isOnline() != null) {
                return true;
            }
        } else {
            cache = (Element)Pedestals_Cache.get("sys");
            isOnline = cache.attributeValue("isOnline");
            if (!(Objects.equals(pedestalLayerInfo.isOnline(), Boolean.valueOf(isOnline)) && Objects.equals(pedestalLayerInfo.getTargetVersion(), cache.attributeValue("targetVersion")) && Objects.equals(pedestalLayerInfo.getDownloadUrl(), cache.attributeValue("downloadUrl")))) {
                return true;
            }
        }
        if ((pedestalLayerInfo = pedestalInfos.get("obj")) != null && !Pedestals_Cache.containsKey("obj")) {
            if (pedestalLayerInfo.isOnline() != null) {
                return true;
            }
        } else {
            cache = (Element)Pedestals_Cache.get("obj");
            isOnline = cache.attributeValue("isOnline");
            if (!(Objects.equals(pedestalLayerInfo.isOnline(), Boolean.valueOf(isOnline)) && Objects.equals(pedestalLayerInfo.getTargetVersion(), cache.attributeValue("targetVersion")) && Objects.equals(pedestalLayerInfo.getDownloadUrl(), cache.attributeValue("downloadUrl")))) {
                return true;
            }
        }
        if ((pedestalLayerInfo = pedestalInfos.get("iny")) != null && !Pedestals_Cache.containsKey("iny")) {
            if (pedestalLayerInfo.isOnline() != null) {
                return true;
            }
        } else {
            cache = (Element)Pedestals_Cache.get("iny");
            isOnline = cache.attributeValue("isOnline");
            if (!(Objects.equals(pedestalLayerInfo.isOnline(), Boolean.valueOf(isOnline)) && Objects.equals(pedestalLayerInfo.getTargetVersion(), cache.attributeValue("targetVersion")) && Objects.equals(pedestalLayerInfo.getDownloadUrl(), cache.attributeValue("downloadUrl")))) {
                return true;
            }
        }
        if ((pedestalLayerInfo = pedestalInfos.get("ent")) != null && !Pedestals_Cache.containsKey("ent")) {
            if (pedestalLayerInfo.isOnline() != null) {
                return true;
            }
        } else {
            cache = (Element)Pedestals_Cache.get("ent");
            isOnline = cache.attributeValue("isOnline");
            if (!(Objects.equals(pedestalLayerInfo.isOnline(), Boolean.valueOf(isOnline)) && Objects.equals(pedestalLayerInfo.getTargetVersion(), cache.attributeValue("targetVersion")) && Objects.equals(pedestalLayerInfo.getDownloadUrl(), cache.attributeValue("downloadUrl")))) {
                return true;
            }
        }
        for (String solutionId : solutionInfos.keySet()) {
            SolutionLayerInfo solutionLayerInfo = solutionInfos.get(solutionId);
            if (!Solutions_Cache.containsKey(solutionId)) {
                if (solutionLayerInfo.isOnline() == null) continue;
                return true;
            }
            Element cache2 = (Element)Solutions_Cache.get(solutionId);
            String isOnline2 = cache2.attributeValue("isOnline");
            if (!(Objects.equals(solutionLayerInfo.isOnline(), Boolean.valueOf(isOnline2)) && Objects.equals(solutionLayerInfo.getTargetVersion(), cache2.attributeValue("targetVersion")) && Objects.equals(solutionLayerInfo.getAppUserId(), cache2.attributeValue("appUserId")))) {
                return true;
            }
            List elements = cache2.element("Plugins").elements("Plugin");
            Map<String, Element> plugins_Cache = elements.stream().collect(Collectors.toMap(p -> p.attributeValue("id"), p -> p));
            List<SolutionPluginInfo> pluginInfos = solutionLayerInfo.getPluginInfos();
            for (SolutionPluginInfo pluginInfo : pluginInfos) {
                if (!plugins_Cache.containsKey(pluginInfo.getPluginId())) {
                    if (pluginInfo.isOnline() == null) continue;
                    return true;
                }
                cache2 = plugins_Cache.get(pluginInfo.getPluginId());
                pluginInfo.setOnline(Boolean.valueOf(isOnline2));
                if (Objects.equals(pluginInfo.isOnline(), Boolean.valueOf(isOnline2)) && Objects.equals(pluginInfo.getTargetVersion(), cache2.attributeValue("targetVersion")) && Objects.equals(pluginInfo.getDownloadPluginId(), cache2.attributeValue("downloadPluginId"))) continue;
                return true;
            }
        }
        return false;
    }

    private void findInLocalFileCache() {
        File cacheFile = new File(LayerChainPage.getTempFileDir(), "Config.xml");
        Map<String, Element> Pedestals_Cache = new HashMap<String, Element>();
        Map<String, Element> Solutions_Cache = new HashMap<String, Element>();
        if (cacheFile.exists()) {
            try {
                Document document = FileUtils.readFileToDocument((File)cacheFile);
                Element Root = document.getRootElement();
                List Pedestals = Root.element("Pedestals").elements("Pedestal");
                List Solutions = Root.element("Solutions").elements("Solution");
                Pedestals_Cache = Pedestals.stream().collect(Collectors.toMap(p -> p.getText(), p -> p));
                Solutions_Cache = Solutions.stream().collect(Collectors.toMap(s -> s.attributeValue("id"), s -> s));
            }
            catch (Exception e) {
                log.error((Object)("\u8bfb\u53d6\u5c42\u94fe\u7f13\u5b58\u6587\u4ef6\u5f02\u5e38:" + cacheFile.getAbsolutePath()), (Throwable)e);
            }
        }
        this.loadPedestal(Pedestals_Cache);
        this.loadSolution(Solutions_Cache);
        this.buildTable();
        this.buildTree();
        this.updateInfoRefresh();
    }

    protected static void clearCache() {
        pedestalInfos = new HashMap<String, PedestalLayerInfo>();
        solutionInfos = new HashMap<String, SolutionLayerInfo>();
        LayerDefinationManager manager = (LayerDefinationManager)ObjectContainer.getInstance(LayerDefinationManager.class);
        manager.resolveLayers();
        SolutionDefinitionManager solutionManager = (SolutionDefinitionManager)ObjectContainer.getInstance(SolutionDefinitionManager.class);
        solutionManager.resolveSolutions();
        SolutionPluginDefinitionManager pluginManager = (SolutionPluginDefinitionManager)ObjectContainer.getInstance(SolutionPluginDefinitionManager.class);
        pluginManager.resolveSolutionPlugins();
        SolutionExtensionDefinitionManager extensionManager = (SolutionExtensionDefinitionManager)ObjectContainer.getInstance(SolutionExtensionDefinitionManager.class);
        extensionManager.resolveSolutionExtensions();
        File tempFileDir = LayerChainPage.getTempFileDir();
        if (tempFileDir.exists()) {
            try {
                FileUtils.deleteDirectory((File)tempFileDir);
            }
            catch (IOException iOException) {}
        }
    }

    protected static void updateCache() {
        File cacheFile = new File(LayerChainPage.getTempFileDir(), "Config.xml");
        try {
            String targetVersion;
            if (!cacheFile.exists()) {
                cacheFile.getParentFile().mkdirs();
                cacheFile.createNewFile();
            }
            Document document = DocumentHelper.createDocument();
            Element Cache = document.addElement("Cache");
            Element Pedestals = Cache.addElement("Pedestals");
            Element Solutions = Cache.addElement("Solutions");
            for (String layer : pedestalInfos.keySet()) {
                PedestalLayerInfo pedestalLayerInfo = pedestalInfos.get(layer);
                if (pedestalLayerInfo.isOnline() == null) continue;
                targetVersion = pedestalLayerInfo.getTargetVersion();
                String downloadUrl = pedestalLayerInfo.getDownloadUrl();
                Element Pedestal = Pedestals.addElement("Pedestal");
                Pedestal.setText(layer);
                Pedestal.addAttribute("isOnline", pedestalLayerInfo.isOnline().toString());
                Pedestal.addAttribute("targetVersion", targetVersion);
                Pedestal.addAttribute("downloadUrl", downloadUrl);
            }
            for (String layer : solutionInfos.keySet()) {
                SolutionLayerInfo solutionLayerInfo = solutionInfos.get(layer);
                if (solutionLayerInfo.isOnline() == null) continue;
                targetVersion = solutionLayerInfo.getTargetVersion();
                String appUserId = solutionLayerInfo.getAppUserId();
                Element Solution = Solutions.addElement("Solution");
                Solution.addAttribute("id", layer);
                Solution.addAttribute("isOnline", solutionLayerInfo.isOnline().toString());
                Solution.addAttribute("targetVersion", targetVersion);
                Solution.addAttribute("appUserId", appUserId);
                List<SolutionPluginInfo> pluginInfos = solutionLayerInfo.getPluginInfos();
                Element Plugins = Solution.addElement("Plugins");
                for (SolutionPluginInfo pluginInfo : pluginInfos) {
                    if (pluginInfo.isOnline() == null) continue;
                    Element Plugin = Plugins.addElement("Plugin");
                    Plugin.addAttribute("id", pluginInfo.getPluginId());
                    Plugin.addAttribute("isOnline", pluginInfo.isOnline().toString());
                    Plugin.addAttribute("targetVersion", pluginInfo.getTargetVersion());
                    Plugin.addAttribute("downloadPluginId", pluginInfo.getDownloadPluginId());
                }
            }
            FileUtils.writeDocumentToFile((File)cacheFile, (Document)document);
        }
        catch (IOException e) {
            log.error((Object)"\u91cd\u7f6e\u5c42\u94fe\u7f13\u5b58\u6587\u4ef6\u5f02\u5e38", (Throwable)e);
        }
    }

    private void loadPedestalByCache(PedestalLayerInfo layerInfo, Element cache) {
        String isOnline = cache.attributeValue("isOnline");
        layerInfo.setOnline(Boolean.valueOf(isOnline));
        layerInfo.setTargetVersion(cache.attributeValue("targetVersion"));
        layerInfo.setDownloadUrl(cache.attributeValue("downloadUrl"));
    }

    private void loadPedestal(Map<String, Element> pedestals_Cache) {
        pedestalInfos = new HashMap<String, PedestalLayerInfo>();
        LayerDefinationManager manager = (LayerDefinationManager)ObjectContainer.getInstance(LayerDefinationManager.class);
        LayerDefination sysLayer = manager.getLayer("sys");
        if (sysLayer == null) {
            return;
        }
        PedestalLayerInfo layerInfo = new PedestalLayerInfo();
        layerInfo.setLayerId("sys");
        layerInfo.setLayerName("\u7cfb\u7edf\u5c42(sys)");
        layerInfo.setLabel(sysLayer.getLayerLabel());
        layerInfo.setNamespace(sysLayer.getLayerNamespace());
        layerInfo.setCurrentVersion(sysLayer.getLayerVersion());
        layerInfo.setDeploymentMode(sysLayer.getDeploymentMode());
        if (pedestals_Cache.containsKey("sys")) {
            this.loadPedestalByCache(layerInfo, pedestals_Cache.get("sys"));
        }
        pedestalInfos.put("sys", layerInfo);
        LayerDefination objLayer = manager.getLayer("obj");
        if (objLayer == null) {
            return;
        }
        layerInfo = new PedestalLayerInfo();
        layerInfo.setLayerId("obj");
        layerInfo.setLayerName("\u5bf9\u8c61\u5c42(obj)");
        layerInfo.setLabel(objLayer.getLayerLabel());
        layerInfo.setNamespace(objLayer.getLayerNamespace());
        layerInfo.setCurrentVersion(objLayer.getLayerVersion());
        layerInfo.setDeploymentMode(objLayer.getDeploymentMode());
        layerInfo.setLowerLayerInfo(pedestalInfos.get("sys"));
        if (pedestals_Cache.containsKey("obj")) {
            this.loadPedestalByCache(layerInfo, pedestals_Cache.get("obj"));
        }
        pedestalInfos.put("obj", layerInfo);
        LayerDefination inyLayer = manager.getLayer("iny");
        if (inyLayer == null) {
            return;
        }
        layerInfo = new PedestalLayerInfo();
        layerInfo.setLayerId("iny");
        layerInfo.setLayerName("\u884c\u4e1a\u5c42(iny)");
        layerInfo.setLabel(inyLayer.getLayerLabel());
        layerInfo.setNamespace(inyLayer.getLayerNamespace());
        layerInfo.setCurrentVersion(inyLayer.getLayerVersion());
        layerInfo.setDeploymentMode(inyLayer.getDeploymentMode());
        layerInfo.setLowerLayerInfo(pedestalInfos.get("obj"));
        if (pedestals_Cache.containsKey("iny")) {
            this.loadPedestalByCache(layerInfo, pedestals_Cache.get("iny"));
        }
        pedestalInfos.put("iny", layerInfo);
        LayerDefination entLayer = manager.getLayer("ent");
        if (entLayer == null) {
            return;
        }
        layerInfo = new PedestalLayerInfo();
        layerInfo.setLayerId("ent");
        layerInfo.setLayerName("\u4f01\u4e1a\u5c42(ent)");
        layerInfo.setLabel(entLayer.getLayerLabel());
        layerInfo.setNamespace(entLayer.getLayerNamespace());
        layerInfo.setCurrentVersion(entLayer.getLayerVersion());
        layerInfo.setDeploymentMode(entLayer.getDeploymentMode());
        layerInfo.setLowerLayerInfo(pedestalInfos.get("iny"));
        if (pedestals_Cache.containsKey("ent")) {
            this.loadPedestalByCache(layerInfo, pedestals_Cache.get("ent"));
        }
        pedestalInfos.put("ent", layerInfo);
    }

    private void buildTable() {
        this.pedestal.removeAll();
        if (pedestalInfos == null) {
            return;
        }
        this.doBuildTable("sys");
        this.doBuildTable("obj");
        this.doBuildTable("iny");
        this.doBuildTable("ent");
    }

    private void doBuildTable(String layerName) {
        if (!pedestalInfos.containsKey(layerName)) {
            return;
        }
        PedestalLayerInfo pedestalInfo = pedestalInfos.get(layerName);
        if (this.showBinaryOnly.getSelection() && pedestalInfo.getDeploymentMode().equals((Object)LayerDeploymentMode.Source)) {
            return;
        }
        if (this.showUpgradeOnly.getSelection() && pedestalInfo.isOnline() == null) {
            return;
        }
        TableItem tableItem = new TableItem(this.pedestal, 0);
        tableItem.setText(0, pedestalInfo.getLayerName());
        tableItem.setText(1, pedestalInfo.getNamespace());
        tableItem.setText(2, pedestalInfo.getLabel());
        tableItem.setText(3, pedestalInfo.getDeploymentMode().equals((Object)LayerDeploymentMode.Package) ? "\u4e8c\u8fdb\u5236" : "\u6e90\u7801");
        tableItem.setText(4, pedestalInfo.getCurrentVersion());
        tableItem.setText(5, pedestalInfo.getTargetVersion() == null ? "" : pedestalInfo.getTargetVersion());
        tableItem.setText(6, pedestalInfo.isOnline() == null ? "" : (pedestalInfo.isOnline() != false ? "\u5728\u7ebf" : "\u79bb\u7ebf"));
        tableItem.setData("LayerName", (Object)layerName);
        pedestalInfo.setBindItem(tableItem);
        pedestalInfo.updateBindItem();
    }

    private void loadSolution(Map<String, Element> solutions_Cache) {
        solutionInfos = new HashMap<String, SolutionLayerInfo>();
        SolutionDefinitionManager solutionManager = (SolutionDefinitionManager)ObjectContainer.getInstance(SolutionDefinitionManager.class);
        SolutionPluginDefinitionManager pluginManager = (SolutionPluginDefinitionManager)ObjectContainer.getInstance(SolutionPluginDefinitionManager.class);
        SolutionExtensionDefinitionManager extensionManager = (SolutionExtensionDefinitionManager)ObjectContainer.getInstance(SolutionExtensionDefinitionManager.class);
        List solutionDefinitions = solutionManager.getSolutions();
        for (SolutionDefinition solutionDefinition : solutionDefinitions) {
            SolutionLayerInfo solutionInfo = new SolutionLayerInfo();
            solutionInfo.setSolutionId(solutionDefinition.getSolutionName());
            if (StringUtils.isNotBlank((String)solutionDefinition.getSolutionLabel())) {
                solutionInfo.setSolutionName(solutionDefinition.getSolutionLabel());
            } else {
                solutionInfo.setSolutionName(solutionDefinition.getSolutionName());
            }
            solutionInfo.setCurrentVersion(solutionDefinition.getSolutionVersion());
            solutionInfo.setDeploymentMode(solutionDefinition.getDeploymentMode());
            solutionInfo.setFrameworkVersion(solutionDefinition.getFrameworkVersion());
            Map<Object, Object> plugins_Cache = new HashMap();
            if (solutions_Cache.containsKey(solutionDefinition.getSolutionName())) {
                Element cache = solutions_Cache.get(solutionDefinition.getSolutionName());
                String isOnline = cache.attributeValue("isOnline");
                solutionInfo.setOnline(Boolean.valueOf(isOnline));
                solutionInfo.setTargetVersion(cache.attributeValue("targetVersion"));
                solutionInfo.setAppUserId(cache.attributeValue("appUserId"));
                List elements = cache.element("Plugins").elements("Plugin");
                plugins_Cache = elements.stream().collect(Collectors.toMap(p -> p.attributeValue("id"), p -> p));
            }
            List solutionPlugins = pluginManager.getSolutionPlugins(solutionDefinition.getSolutionName());
            for (SolutionPluginDefinition solutionPlugin : solutionPlugins) {
                SolutionPluginInfo pluginInfo = new SolutionPluginInfo(solutionInfo);
                pluginInfo.setPluginId(solutionPlugin.getName());
                if (StringUtils.isNotBlank((String)solutionPlugin.getLabel())) {
                    pluginInfo.setPluginName(solutionPlugin.getLabel());
                } else {
                    pluginInfo.setPluginName(solutionPlugin.getName());
                }
                pluginInfo.setCurrentVersion(solutionPlugin.getVersion());
                pluginInfo.setDeploymentMode(solutionPlugin.getDeploymentMode());
                if (!plugins_Cache.containsKey(solutionPlugin.getName())) continue;
                Element cache = (Element)plugins_Cache.get(solutionPlugin.getName());
                String isOnline = cache.attributeValue("isOnline");
                pluginInfo.setOnline(Boolean.valueOf(isOnline));
                pluginInfo.setTargetVersion(cache.attributeValue("targetVersion"));
                pluginInfo.setDownloadPluginId(cache.attributeValue("downloadPluginId"));
            }
            SolutionExtensionDefinition solutionExtension = extensionManager.getSolutionExtension(solutionDefinition.getSolutionName());
            if (solutionExtension != null) {
                SolutionExtInfo solutionExtInfo = new SolutionExtInfo(solutionInfo);
                solutionExtInfo.setCurrentVersion(solutionExtension.getExtensionVersion());
                solutionExtInfo.setDeploymentMode(solutionExtension.getDeploymentMode());
            }
            solutionInfos.put(solutionDefinition.getSolutionName(), solutionInfo);
        }
    }

    private void buildTree() {
        SolutionLayerInfo solutionLayerInfo;
        this.tree.removeAll();
        if (solutionInfos == null) {
            return;
        }
        for (String solutionName : solutionInfos.keySet()) {
            solutionLayerInfo = solutionInfos.get(solutionName);
            List<SolutionPluginInfo> pluginInfos = solutionLayerInfo.getPluginInfos();
            if (this.showBinaryOnly.getSelection() && solutionLayerInfo.getDeploymentMode().equals((Object)SolutionDeploymentMode.Source) || this.showUpgradeOnly.getSelection() && solutionLayerInfo.isOnline() == null && !pluginInfos.stream().filter(p -> p.isOnline() != null).findFirst().isPresent()) continue;
            TreeItem solutionItem = new TreeItem(this.tree, 0);
            solutionLayerInfo.setBindItem(solutionItem);
            solutionItem.setImage(Images.getIcon("Lyr.png"));
            solutionItem.setText(0, solutionLayerInfo.getSolutionName() == null ? "" : solutionLayerInfo.getSolutionName());
            solutionItem.setText(1, solutionLayerInfo.getSolutionId());
            solutionItem.setText(2, solutionLayerInfo.getDeploymentMode().equals((Object)SolutionDeploymentMode.Package) ? "\u4e8c\u8fdb\u5236" : "\u6e90\u7801");
            solutionItem.setText(3, solutionLayerInfo.getCurrentVersion());
            solutionItem.setText(4, solutionLayerInfo.getTargetVersion() == null ? "" : solutionLayerInfo.getTargetVersion());
            solutionItem.setText(5, solutionLayerInfo.isOnline() == null ? "" : (solutionLayerInfo.isOnline() != false ? "\u5728\u7ebf" : "\u79bb\u7ebf"));
            solutionItem.setData("type", (Object)"app");
            for (SolutionPluginInfo pluginInfo : pluginInfos) {
                if (this.showBinaryOnly.getSelection() && pluginInfo.getDeploymentMode().equals((Object)SolutionPluginDeploymentMode.Source) || this.showUpgradeOnly.getSelection() && pluginInfo.isOnline() == null) continue;
                TreeItem pluginItem = new TreeItem(solutionItem, 0);
                pluginItem.setImage(Images.getIcon("Plg.png"));
                pluginItem.setText(0, pluginInfo.getPluginName() == null ? "" : pluginInfo.getPluginName());
                pluginItem.setText(1, pluginInfo.getPluginId());
                pluginItem.setText(2, pluginInfo.getDeploymentMode().equals((Object)SolutionPluginDeploymentMode.Package) ? "\u4e8c\u8fdb\u5236" : "\u6e90\u7801");
                pluginItem.setText(3, pluginInfo.getCurrentVersion());
                pluginItem.setText(4, pluginInfo.getTargetVersion() == null ? "" : pluginInfo.getTargetVersion());
                pluginItem.setText(5, pluginInfo.isOnline() == null ? "" : (pluginInfo.isOnline() != false ? "\u5728\u7ebf" : "\u79bb\u7ebf"));
                pluginItem.setData("type", (Object)"plg");
                pluginInfo.setBindItem(pluginItem);
                pluginInfo.updateBindItem();
            }
            SolutionExtInfo extInfo = solutionLayerInfo.getExtInfo();
            if (extInfo == null || this.showBinaryOnly.getSelection() && extInfo.getDeploymentMode().equals((Object)SolutionExtensionDeploymentMode.Source) || this.showUpgradeOnly.getSelection()) continue;
            TreeItem extItem = new TreeItem(solutionItem, 0);
            extItem.setImage(Images.getIcon("Ext.png"));
            extItem.setText(0, "\u5e94\u7528\u6269\u5c55");
            extItem.setText(1, "");
            extItem.setText(2, extInfo.getDeploymentMode().equals((Object)SolutionExtensionDeploymentMode.Package) ? "\u4e8c\u8fdb\u5236" : "\u6e90\u7801");
            extItem.setText(3, extInfo.getCurrentVersion());
            extItem.setText(4, extInfo.getTargetVersion() == null ? "" : extInfo.getTargetVersion());
            extItem.setData("type", (Object)"ext");
        }
        for (String solutionName : solutionInfos.keySet()) {
            solutionLayerInfo = solutionInfos.get(solutionName);
            if (solutionLayerInfo.getBindItem().isDisposed()) continue;
            solutionLayerInfo.getBindItem().setExpanded(true);
            solutionLayerInfo.updateBindItem();
        }
    }

    private void selectOnlineFile(TableItem objItem) {
        String layerName = (String)objItem.getData("LayerName");
        PedestalLayerInfo pedestalLayerInfo = pedestalInfos.get(layerName);
        if (pedestalLayerInfo.getDeploymentMode().equals((Object)LayerDeploymentMode.Source)) {
            return;
        }
        MarketOnlineVersion marketOnline = new MarketOnlineVersion(pedestalLayerInfo);
        marketOnline.open();
        this.updateInfoRefresh();
    }

    private void selectOnlineFile(TreeItem treeItem) {
        String type = (String)treeItem.getData("type");
        if (type.equals("app")) {
            SolutionLayerInfo solutionInfo = solutionInfos.get(treeItem.getText(1));
            if (solutionInfo.getDeploymentMode().equals((Object)SolutionDeploymentMode.Source)) {
                return;
            }
            MarketOnlineVersion marketOnline = new MarketOnlineVersion(solutionInfo);
            marketOnline.open();
            this.updateInfoRefresh();
        } else if (type.equals("plg")) {
            String solutionName = treeItem.getParentItem().getText(1);
            SolutionLayerInfo solutionInfo = solutionInfos.get(solutionName);
            SolutionPluginInfo pluginInfo = solutionInfo.getPluginInfo(treeItem.getText(1));
            if (pluginInfo.getDeploymentMode().equals((Object)SolutionPluginDeploymentMode.Source)) {
                return;
            }
            MarketOnlineVersion marketOnline = new MarketOnlineVersion(pluginInfo);
            marketOnline.open();
            this.updateInfoRefresh();
        }
    }

    private void updateInfoRefresh() {
        long pedestalSelect = pedestalInfos.values().stream().filter(p -> p.isOnline() != null && !p.getTargetVersion().equals(p.getCurrentVersion())).count();
        long solutionSelect = solutionInfos.values().stream().filter(s -> s.isOnline() != null && !s.getTargetVersion().equals(s.getCurrentVersion())).count();
        List plugins = solutionInfos.values().stream().flatMap(s -> s.getPluginInfos().stream()).collect(Collectors.toList());
        long pluginSelect = plugins.stream().filter(p -> p.isOnline() != null && !p.getTargetVersion().equals(p.getCurrentVersion())).count();
        this.updateInfo.setText(String.format("\u5e95\u5ea7: %d/%d    \u5e94\u7528:%d/%d    \u63d2\u4ef6:%d/%d", pedestalSelect, pedestalInfos.size(), solutionSelect, solutionInfos.size(), pluginSelect, plugins.size()));
    }

    private static int getLayerLevel(String layerName) {
        switch (layerName) {
            case "sys": {
                return 1;
            }
            case "obj": {
                return 2;
            }
            case "iny": {
                return 3;
            }
            case "ent": {
                return 4;
            }
            case "app": {
                return 5;
            }
            case "plg": {
                return 6;
            }
            case "ext": {
                return 7;
            }
        }
        return 0;
    }

    protected static List<String> checkBeforeAnalysis() {
        ArrayList<String> errInfos = new ArrayList<String>();
        List updateLayers = pedestalInfos.values().stream().filter(p -> p.isOnline() != null).collect(Collectors.toList());
        if (updateLayers.isEmpty()) {
            for (PedestalLayerInfo pedestalInfo : pedestalInfos.values()) {
                pedestalInfo.setOnline(true);
                pedestalInfo.setEmptyLayer(false);
                pedestalInfo.setTargetVersion(pedestalInfo.getCurrentVersion());
            }
        } else {
            List layers = pedestalInfos.values().stream().sorted((p1, p2) -> LayerChainPage.getLayerLevel(p1.getLayerId()) > LayerChainPage.getLayerLevel(p2.getLayerId()) ? -1 : 1).collect(Collectors.toList());
            boolean flag = false;
            for (PedestalLayerInfo layer : layers) {
                if (layer.isOnline() != null) {
                    flag = true;
                    continue;
                }
                if (!flag) {
                    layer.setOnline(true);
                    layer.setEmptyLayer(true);
                    layer.setTargetVersion(layer.getCurrentVersion());
                    continue;
                }
                errInfos.add(String.format("\u8bf7\u9009\u62e9\u5e95\u5ea7\u3010%s\u3011\u7684\u5347\u7ea7\u7248\u672c", layer.getLayerId()));
            }
        }
        for (PedestalLayerInfo pedestalInfo : pedestalInfos.values()) {
            if (pedestalInfo.isOnline() == null || pedestalInfo.isOnline().booleanValue() || pedestalInfo.getUpdateFile(pedestalInfo.getTargetVersion()).exists()) continue;
            errInfos.add(String.format("\u5e95\u5ea7\u3010%s\u3011\u5347\u7ea7\u6587\u4ef6\u5df2\u4e22\u5931\uff0c\u8bf7\u91cd\u65b0\u4e0a\u4f20", pedestalInfo.getLayerId()));
        }
        for (SolutionLayerInfo layerInfo : solutionInfos.values()) {
            SolutionPluginInfo solutionPluginInfo2;
            List<SolutionPluginInfo> pluginInfos = layerInfo.getPluginInfos();
            if (layerInfo.isOnline() != null) {
                List solutionPluginInfos = pluginInfos.stream().filter(p -> p.getDeploymentMode().equals((Object)SolutionPluginDeploymentMode.Package) && p.isOnline() == null).collect(Collectors.toList());
                for (SolutionPluginInfo solutionPluginInfo2 : solutionPluginInfos) {
                    solutionPluginInfo2.setTargetVersion(solutionPluginInfo2.getCurrentVersion());
                    solutionPluginInfo2.setOnline(true);
                }
                if (layerInfo.isOnline() == null || layerInfo.isOnline().booleanValue() || layerInfo.getUpdateFile(layerInfo.getTargetVersion()).exists()) continue;
                errInfos.add(String.format("\u5e94\u7528\u3010%s\u3011\u5347\u7ea7\u6587\u4ef6\u5df2\u4e22\u5931\uff0c\u8bf7\u91cd\u65b0\u4e0a\u4f20", layerInfo.getSolutionName()));
                continue;
            }
            Optional<SolutionPluginInfo> findFirst = pluginInfos.stream().filter(p -> p.isOnline() != null).findFirst();
            if (!findFirst.isPresent()) continue;
            solutionPluginInfo2 = findFirst.get();
            SolutionLayerInfo solutionLayerInfo = solutionPluginInfo2.getSolutionLayerInfo();
            solutionLayerInfo.setOnline(true);
            solutionLayerInfo.setTargetVersion(solutionLayerInfo.getCurrentVersion());
        }
        List pluginInfos = solutionInfos.values().stream().flatMap(solutionInfo -> solutionInfo.getPluginInfos().stream()).filter(p -> p.isOnline() != null && p.isOnline() == false && !p.getUpdateFile(p.getTargetVersion()).exists()).collect(Collectors.toList());
        for (SolutionPluginInfo pluginInfo : pluginInfos) {
            errInfos.add(String.format("\u63d2\u4ef6\u3010%s\u3011:\u5347\u7ea7\u6587\u4ef6\u5df2\u4e22\u5931\uff0c\u8bf7\u91cd\u65b0\u4e0a\u4f20", pluginInfo.getPluginName()));
        }
        return errInfos;
    }

    private void versionMatch() throws InvocationTargetException, InterruptedException {
        final String objVersion = pedestalInfos.get("obj").getTargetVersion();
        if (StringUtils.isBlank((String)objVersion)) {
            MessageDialog.openError((Shell)this.shell, (String)"\u63d0\u793a", (String)"\u8bf7\u5148\u9009\u62e9\u5e95\u5ea7\u7248\u672c");
            return;
        }
        ProgressMonitorDialog progressMonitorDialog = new ProgressMonitorDialog(Display.getCurrent().getActiveShell());
        progressMonitorDialog.run(true, false, new IRunnableWithProgress(){

            public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                List solutions = solutionInfos.values().stream().filter(s -> s.getDeploymentMode().equals((Object)SolutionDeploymentMode.Package)).collect(Collectors.toList());
                List plugins = solutionInfos.values().stream().flatMap(s -> s.getPluginInfos().stream()).filter(p -> p.getDeploymentMode().equals((Object)SolutionPluginDeploymentMode.Package)).collect(Collectors.toList());
                monitor.beginTask("", solutions.size() + plugins.size() + 1);
                for (SolutionLayerInfo solutionInfo : solutions) {
                    monitor.setTaskName(String.format("\u5e95\u5ea7\u7248\u672c\u3010%s\u3011\uff1a\u6b63\u5728\u5339\u914d\u5e94\u7528\u3010%s\u3011", objVersion, solutionInfo.getSolutionId()));
                    Display.getDefault().syncExec(() -> {
                        boolean success = MarketOnlineVersion.setLastSolutionVersion(solutionInfo, objVersion);
                        if (!success) {
                            solutionInfo.setOnline(null);
                            solutionInfo.setOnline(null);
                            solutionInfo.setTargetVersion(null);
                            solutionInfo.setAppUserId(null);
                            solutionInfo.updateBindItem();
                        }
                    });
                    monitor.worked(1);
                }
                for (SolutionPluginInfo plugin : plugins) {
                    monitor.setTaskName(String.format("\u6b63\u5728\u5339\u914d\u5e94\u63d2\u4ef6\u3010%s\u3011", plugin.getPluginId()));
                    Display.getDefault().syncExec(() -> {
                        boolean success = MarketOnlineVersion.setLastPluginVersion(plugin);
                        if (!success) {
                            plugin.setDownloadPluginId(null);
                            plugin.setOnline(null);
                            plugin.setTargetVersion(null);
                            plugin.updateBindItem();
                        }
                    });
                    monitor.worked(1);
                }
                monitor.done();
            }
        });
    }

    protected void resetAll() {
        this.loadPedestal(new HashMap<String, Element>());
        this.buildTable();
        this.loadSolution(new HashMap<String, Element>());
        this.buildTree();
        this.updateInfoRefresh();
    }

    private static File getTempFileDir() {
        File basePath = ProjectConstants.getBasePath();
        File cacheFile = new File(basePath, "Temp/LayerChainCache");
        if (!cacheFile.exists()) {
            cacheFile.mkdirs();
        }
        return cacheFile;
    }

    protected static Map<String, SolutionLayerInfo> getSolutions() {
        return solutionInfos;
    }

    protected static Map<String, PedestalLayerInfo> getPedestals() {
        return pedestalInfos;
    }
}

