/*
 * Decompiled with CFR 0.152.
 */
package gongqi.gdt.designer.utils;

import gongqi.erp.framework.core.plugin.SolutionPluginDeploymentMode;
import gongqi.gdt.designer.ProjectConstants;
import gongqi.gdt.designer.utils.SolutionLayerInfo;
import java.io.File;
import org.apache.commons.lang.StringUtils;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.TreeItem;

public class SolutionPluginInfo {
    private SolutionLayerInfo solutionLayerInfo;
    private String pluginId;
    private String pluginName;
    private SolutionPluginDeploymentMode deploymentMode;
    private String currentVersion;
    private String targetVersion;
    private TreeItem bindItem;
    private Boolean online;
    private String downloadPluginId;

    public String getDownloadPluginId() {
        return this.downloadPluginId;
    }

    public void setDownloadPluginId(String downloadPluginId) {
        this.downloadPluginId = downloadPluginId;
    }

    public Boolean isOnline() {
        return this.online;
    }

    public void setOnline(Boolean online) {
        this.online = online;
    }

    public TreeItem getBindItem() {
        return this.bindItem;
    }

    public void setBindItem(TreeItem bindItem) {
        this.bindItem = bindItem;
    }

    public SolutionPluginInfo(SolutionLayerInfo solutionLayerInfo) {
        this.solutionLayerInfo = solutionLayerInfo;
        solutionLayerInfo.addPlugin(this);
    }

    public SolutionLayerInfo getSolutionLayerInfo() {
        return this.solutionLayerInfo;
    }

    public String getPluginId() {
        return this.pluginId;
    }

    public void setPluginId(String pluginId) {
        this.pluginId = pluginId;
    }

    public String getPluginName() {
        return this.pluginName;
    }

    public void setPluginName(String pluginName) {
        this.pluginName = pluginName;
    }

    public SolutionPluginDeploymentMode getDeploymentMode() {
        return this.deploymentMode;
    }

    public void setDeploymentMode(SolutionPluginDeploymentMode deploymentMode) {
        this.deploymentMode = deploymentMode;
    }

    public String getCurrentVersion() {
        return this.currentVersion;
    }

    public void setCurrentVersion(String currentVersion) {
        this.currentVersion = currentVersion;
    }

    public String getTargetVersion() {
        return this.targetVersion;
    }

    public void setTargetVersion(String targetVersion) {
        this.targetVersion = targetVersion;
    }

    public File getUpdateFile(String version) {
        File basePath = ProjectConstants.getBasePath();
        File updateFile = new File(basePath, String.format("Temp/LayerChainCache/UpdateFile/plg/%s/%s/%s/%s.plugin", this.solutionLayerInfo.getSolutionId(), this.pluginId, version, this.pluginId));
        if (!updateFile.getParentFile().exists()) {
            updateFile.getParentFile().mkdirs();
        }
        return updateFile;
    }

    public void updateBindItem() {
        this.bindItem.setText(0, this.getPluginName() == null ? "" : this.getPluginName());
        this.bindItem.setText(1, this.getPluginId());
        this.bindItem.setText(2, this.getDeploymentMode().equals((Object)SolutionPluginDeploymentMode.Package) ? "\u4e8c\u8fdb\u5236" : "\u6e90\u7801");
        this.bindItem.setText(3, this.getCurrentVersion());
        this.bindItem.setText(4, this.getTargetVersion() == null ? "" : this.getTargetVersion());
        this.bindItem.setText(5, this.isOnline() == null ? "" : (this.isOnline() != false ? "\u5728\u7ebf" : "\u79bb\u7ebf"));
        if (StringUtils.isNotBlank((String)this.getTargetVersion()) && !this.getTargetVersion().equals(this.getCurrentVersion())) {
            FontData fontData = this.bindItem.getFont().getFontData()[0];
            fontData.setStyle(1);
            this.bindItem.setFont(new Font((Device)Display.getCurrent(), fontData));
        } else {
            FontData fontData = this.bindItem.getFont().getFontData()[0];
            fontData.setStyle(0);
            this.bindItem.setFont(new Font((Device)Display.getCurrent(), fontData));
        }
        this.bindItem.setForeground(Display.getCurrent().getSystemColor(2));
    }

    public SolutionPluginInfo clone(SolutionLayerInfo solutionLayerInfo) {
        SolutionPluginInfo pluginInfo = new SolutionPluginInfo(solutionLayerInfo);
        pluginInfo.setPluginId(this.pluginId);
        pluginInfo.setPluginName(this.pluginName);
        pluginInfo.setDeploymentMode(this.deploymentMode);
        pluginInfo.setCurrentVersion(this.currentVersion);
        pluginInfo.setTargetVersion(this.targetVersion);
        pluginInfo.setBindItem(this.bindItem);
        pluginInfo.setOnline(this.online);
        pluginInfo.setDownloadPluginId(this.downloadPluginId);
        return pluginInfo;
    }
}

