/*
 * Decompiled with CFR 0.152.
 */
package info.gongqi.got.ui;

import org.apache.log4j.Logger;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.DocumentEvent;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IDocumentListener;
import org.eclipse.jface.text.TextViewer;
import org.eclipse.swt.custom.StyleRange;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.ColorDialog;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;

public class ConsoleViewerOp
extends TextViewer
implements IDocumentListener {
    private int maxLines = 500;
    public static ConsoleViewerOp consoleViewerOp;
    private Composite parentComposite;
    private Color selectColor;
    private StyleRange[] ranges = new StyleRange[1];
    private StyledText styledText;
    private Color red = new Color(null, 255, 0, 0);

    public static synchronized ConsoleViewerOp getInstance(Composite parent) {
        if (consoleViewerOp == null) {
            consoleViewerOp = new ConsoleViewerOp(parent);
            ConsoleViewerOp.consoleViewerOp.parentComposite = parent;
        }
        return consoleViewerOp;
    }

    public void addText(String text, boolean error) {
        try {
            IDocument document = consoleViewerOp.getDocument();
            if (document != null) {
                document.replace(document.getLength(), 0, text);
                this.checkOverflow();
                int start = this.styledText.getText().length();
                if (error) {
                    this.ranges[0] = new StyleRange(start - text.length(), text.length(), this.red, null);
                    this.styledText.replaceStyleRanges(0, text.length(), this.ranges);
                }
                Thread.sleep(50L);
            }
        }
        catch (Exception e) {
            Logger.getLogger(((Object)((Object)this)).getClass()).error((Object)"", (Throwable)e);
        }
    }

    private void checkOverflow() {
        if (this.maxLines <= 0) {
            return;
        }
        IDocument document = this.getDocument();
        int numberOfLines = document.getNumberOfLines();
        if (numberOfLines > this.maxLines + 1) {
            try {
                int overflow = document.getLineOffset(numberOfLines - this.maxLines);
                document.replace(0, overflow, "");
            }
            catch (BadLocationException e) {
                Logger.getLogger(((Object)((Object)this)).getClass()).error((Object)"", (Throwable)e);
            }
        }
    }

    private ConsoleViewerOp(Composite parent) {
        super(parent, 576);
        this.initialization(parent);
    }

    private void initialization(Composite parent) {
        FormData data2 = new FormData();
        data2.top = new FormAttachment(0, 2);
        data2.bottom = new FormAttachment(100, -2);
        data2.left = new FormAttachment(0, 2);
        data2.right = new FormAttachment(100, -2);
        this.styledText = this.getTextWidget();
        this.styledText.setLayout((Layout)new FormLayout());
        this.styledText.setParent(parent);
        this.styledText.setLayoutData((Object)data2);
        this.styledText.setAlwaysShowScrollBars(false);
        Font font = new Font(null, "\u5fae\u8f6f\u96c5\u9ed1", 10, 0);
        this.styledText.setFont(font);
        this.styledText.setEditable(false);
        this.styledText.setWordWrap(true);
        this.styledText.setVisible(true);
        Document document = new Document();
        document.addDocumentListener((IDocumentListener)this);
        this.setDocument((IDocument)document);
        this.styledText.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseDown(MouseEvent e) {
                if (e.button == 3) {
                    Menu menu = new Menu((Control)ConsoleViewerOp.this.styledText);
                    ConsoleViewerOp.this.styledText.setMenu(menu);
                    MenuItem item = new MenuItem(menu, 8);
                    item.setText("\u6e05\u7a7a");
                    item.addSelectionListener((SelectionListener)new SelectionAdapter(){

                        public void widgetSelected(SelectionEvent event) {
                            ConsoleViewerOp.this.cleanText();
                        }
                    });
                    MenuItem itemBack = new MenuItem(menu, 8);
                    itemBack.setText("\u9009\u62e9\u6587\u5b57\u989c\u8272");
                    itemBack.addSelectionListener((SelectionListener)new SelectionAdapter(){

                        public void widgetSelected(SelectionEvent event) {
                            ColorDialog colorDialog = new ColorDialog(ConsoleViewerOp.this.parentComposite.getShell());
                            final RGB rgb = colorDialog.open();
                            Display.getDefault().asyncExec(new Runnable(){

                                @Override
                                public void run() {
                                    ConsoleViewerOp.this.selectColor = new Color((Device)ConsoleViewerOp.this.parentComposite.getShell().getDisplay(), rgb);
                                    ConsoleViewerOp.this.styledText.setForeground(ConsoleViewerOp.this.selectColor);
                                }
                            });
                        }
                    });
                    MenuItem itemBackGround = new MenuItem(menu, 8);
                    itemBackGround.setText("\u9009\u62e9\u80cc\u666f\u989c\u8272");
                    itemBackGround.addSelectionListener((SelectionListener)new SelectionAdapter(){

                        public void widgetSelected(SelectionEvent event) {
                            ColorDialog colorDialog = new ColorDialog(ConsoleViewerOp.this.parentComposite.getShell());
                            final RGB rgb = colorDialog.open();
                            Display.getDefault().asyncExec(new Runnable(){

                                @Override
                                public void run() {
                                    ConsoleViewerOp.this.styledText.setBackground(new Color((Device)ConsoleViewerOp.this.parentComposite.getShell().getDisplay(), rgb));
                                }
                            });
                        }
                    });
                }
            }
        });
    }

    public void documentAboutToBeChanged(DocumentEvent event) {
    }

    public void documentChanged(DocumentEvent event) {
        Display.getDefault().asyncExec(new Runnable(){

            @Override
            public void run() {
                try {
                    int numberOfLines;
                    int lineStartOffset;
                    int lineEndOffset;
                    StyledText styledText = ConsoleViewerOp.this.getTextWidget();
                    IDocument document = ConsoleViewerOp.this.getDocument();
                    if (document != null && (lineEndOffset = (lineStartOffset = document.getLineOffset((numberOfLines = document.getNumberOfLines()) - 1)) + document.getLineLength(numberOfLines - 1)) > 0) {
                        styledText.setCaretOffset(lineEndOffset);
                        styledText.showSelection();
                    }
                }
                catch (BadLocationException badLocationException) {}
            }
        });
    }

    public void cleanText() {
        IDocument document = this.getDocument();
        int numberOfLines = document.getNumberOfLines();
        try {
            int overflow = document.getLineOffset(numberOfLines - 1);
            document.replace(0, overflow, "");
        }
        catch (BadLocationException badLocationException) {}
    }
}

