/*
 * Decompiled with CFR 0.152.
 */
package info.gongqi.got.ui;

import gongqi.designer.core.LayerLevelManager;
import gongqi.designer.services.LayerService;
import gongqi.designer.utils.GOTHelper;
import gongqi.erp.framework.core.ObjectContainer;
import gongqi.erp.gotmodel.core.EntityType;
import gongqi.gdt.designer.core.got.node.NodeFactory;
import gongqi.gdt.designer.core.got.node.NodeGOT;
import gongqi.gdt.designer.core.resolvergot.ResolverNode;
import gongqi.gdt.designer.core.toolsgot.GOTXMLHelper;
import gongqi.gdt.designer.core.toolsgot.Macros;
import gongqi.gdt.designer.utils.GOTXMLUtils;
import info.gongqi.got.model.GotXmlDto;
import info.gongqi.got.tool.FormDataSyn;
import info.gongqi.got.tool.GOTHelp;
import info.gongqi.got.tool.GetPropertieValue;
import info.gongqi.got.tool.ProgressBarExchangeLayer;
import info.gongqi.got.tool.TreeChineseLabel;
import info.gongqi.got.tool.TreeOperationInfo;
import info.gongqi.got.ui.ConfigComposite;
import info.gongqi.got.ui.LoadXML;
import info.gongqi.got.ui.LoadXmlCore;
import info.gongqi.got.ui.TreeUiBean;
import info.gongqi.got.ui.event.MouseRightMenuEvent;
import info.gongqi.got.ui.event.TableMouseEvent;
import info.gongqi.got.ui.event.TreeMouseRigthMenuEvent;
import info.gongqi.got.util.ComposeIMG;
import info.gongqi.got.util.FromToMapping;
import info.gongqi.got.util.GOTMessageDialog;
import info.gongqi.got.util.NumCore;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.dom4j.Element;
import org.dom4j.Node;
import org.eclipse.swt.dnd.DragSource;
import org.eclipse.swt.dnd.DragSourceEvent;
import org.eclipse.swt.dnd.DragSourceListener;
import org.eclipse.swt.dnd.DropTarget;
import org.eclipse.swt.dnd.DropTargetAdapter;
import org.eclipse.swt.dnd.DropTargetEvent;
import org.eclipse.swt.dnd.DropTargetListener;
import org.eclipse.swt.dnd.TextTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeColumn;
import org.eclipse.swt.widgets.TreeItem;

public class TreeUi {
    private static Logger log = Logger.getLogger(TreeUi.class);
    private Table table;
    private Tree tree;
    private Font boldFont;
    public TreeColumn trclmnNewColumnLabel;
    public TreeColumn trclmnNewColumnText;
    private TreeMouseRigthMenuEvent menuEvent;
    public Map<String, TreeItem> itemsMap = new HashMap<String, TreeItem>();
    public DragSource dragSource;
    public DropTarget dropTarget;
    public Map<String, Boolean> expanedMap = new HashMap<String, Boolean>();
    public TreeItem selected = null;
    public List<TreeItem> selects = new ArrayList<TreeItem>();
    public boolean ctrl = false;
    public TreeUiBean treeUiBean;

    public TreeUi(Tree t, Table tab, final Element targetEl) {
        this.table = tab;
        this.tree = t;
        new Thread(new Runnable(){

            @Override
            public void run() {
                try {
                    Element root = TreeUi.this.initXML(targetEl);
                    Display.getDefault().syncExec(() -> {
                        TreeUi.this.initFont();
                        if (TreeUi.this.tree.getListeners(8).length == 0) {
                            TreeUi.this.addListener();
                        } else {
                            TreeUi.this.menuEvent = new TreeMouseRigthMenuEvent(TreeUi.this);
                            TreeUi.this.tree.addMouseListener((MouseListener)TreeUi.this.menuEvent);
                        }
                        TreeUi.this.bulidTree(root, TreeUi.this.tree);
                        TreeUi.this.insertMap(TreeUi.this.tree);
                    });
                    LoadXmlCore.softModel();
                }
                catch (Exception e) {
                    log.error((Object)"\u52a0\u8f7dXML\u9519\u8bef", (Throwable)e);
                    Display.getDefault().syncExec(() -> {
                        ConfigComposite.progressBar.setShellText("\u52a0\u8f7d\u914d\u7f6e\u9519\u8bef");
                        ConfigComposite.progressBar.setProgressBar(100);
                        ConfigComposite.configComposite.init();
                        ConfigComposite.configComposite.button_restart.setEnabled(true);
                    });
                    return;
                }
            }
        }).start();
    }

    private Element initXML(Element targetEl) {
        Element root = null;
        if (targetEl == null) {
            LoadXmlCore.load();
            Element document = GotXmlDto.getInstance().getGotXMl();
            if (document == null) {
                return root;
            }
            root = document;
        } else {
            root = targetEl;
        }
        return root;
    }

    public void refreshGOTTree() {
        this.tree.removeAll();
        this.table.removeAll();
        for (Shell shell : GOTMessageDialog.shells) {
            if (shell.isDisposed()) continue;
            shell.close();
        }
        this.itemsMap = new HashMap<String, TreeItem>();
        ConfigComposite.tableNum = 0;
        ConfigComposite.fromNum = 0;
        this.itemsMap = new HashMap<String, TreeItem>();
        new Thread(new Runnable(){

            @Override
            public void run() {
                Element root = TreeUi.this.initXML(null);
                Display.getDefault().syncExec(() -> {
                    TreeUi.this.bulidTree(root, TreeUi.this.tree);
                    TreeUi.this.insertMap(TreeUi.this.tree);
                    ConfigComposite.configComposite.text_Label_title.setText("\u5207\u6362\u65b9\u6848\u52a0\u8f7d\u5b8c\u6210");
                    ProgressBarExchangeLayer.barExchangeLayer.shell.close();
                });
                LoadXmlCore.softModel();
            }
        }).start();
    }

    public void afterInit() {
        if (!ConfigComposite.progressBar.getParent().isDisposed()) {
            ConfigComposite.progressBar.setShellText("\u52a0\u8f7d\u5b8c\u6210");
            ConfigComposite.progressBar.setProgressBar(100);
            ConfigComposite.configComposite.buttonEnable(true);
            ConfigComposite.configComposite.text_Label_title.setVisible(true);
            ConfigComposite.text_static_info();
            log.info((Object)"\u52a0\u8f7d\u5b8c\u6210");
            if (LoadXmlCore.softModel) {
                GOTMessageDialog.alert("\u8fdb\u5165\u5b89\u5168\u6a21\u5f0f");
            }
        }
    }

    private void initFont() {
        Font fonts = this.tree.getFont();
        FontData data = fonts.getFontData()[0];
        data.setStyle(1);
        this.boldFont = new Font((Device)this.tree.getShell().getDisplay(), data);
        int width = 5;
        int width_label = 125;
        if (this.tree.getVerticalBar().getVisible()) {
            width = 25;
        }
        int w = this.tree.getBounds().width - width;
        this.trclmnNewColumnText = new TreeColumn(this.tree, 16384);
        this.trclmnNewColumnText.setWidth(w - width_label);
        this.trclmnNewColumnText.setText("text");
        this.trclmnNewColumnLabel = new TreeColumn(this.tree, 131072);
        this.trclmnNewColumnLabel.setResizable(true);
        this.trclmnNewColumnLabel.setText("label");
        this.tree.addControlListener(new ControlListener(){

            public void controlMoved(ControlEvent arg0) {
            }

            public void controlResized(ControlEvent arg0) {
                int totle = 0;
                totle = TreeUi.this.tree.getVerticalBar().getVisible() ? ((TreeUi)TreeUi.this).tree.getBounds().width - 25 : ((TreeUi)TreeUi.this).tree.getBounds().width - 5;
                TreeUi.this.trclmnNewColumnText.setWidth(totle);
            }
        });
        this.setDropSource(this);
        this.setDropTarget(this);
    }

    private void initFontBean() {
        Font fonts = this.tree.getFont();
        FontData data = fonts.getFontData()[0];
        data.setStyle(1);
        this.boldFont = new Font((Device)this.tree.getShell().getDisplay(), data);
        int width = 5;
        if (this.tree.getVerticalBar().getVisible()) {
            width = 25;
        }
        int w = this.tree.getBounds().width - width;
        this.trclmnNewColumnText = new TreeColumn(this.tree, 16384);
        this.trclmnNewColumnText.setWidth(w);
        this.trclmnNewColumnText.setText("text");
        this.trclmnNewColumnLabel = new TreeColumn(this.tree, 131072);
        this.trclmnNewColumnLabel.setResizable(true);
        this.trclmnNewColumnLabel.setText("label");
        this.tree.addControlListener(new ControlListener(){

            public void controlMoved(ControlEvent arg0) {
            }

            public void controlResized(ControlEvent arg0) {
                int totle = 0;
                totle = TreeUi.this.tree.getVerticalBar().getVisible() ? ((TreeUi)TreeUi.this).tree.getBounds().width - 25 : ((TreeUi)TreeUi.this).tree.getBounds().width - 5;
                TreeUi.this.trclmnNewColumnText.setWidth(totle);
            }
        });
    }

    public TreeUi(Tree t, Table tab, TreeItem treeItem, boolean expanded) {
        this.table = tab;
        this.tree = t;
        this.initFontBean();
        this.bulidTree(treeItem, this.tree, expanded);
        this.addListener();
        this.setDropSource(this);
        this.setDropTarget(this);
    }

    public TreeUi(Tree t, Table tab, TreeItem treeItem) {
        this.table = tab;
        this.tree = t;
        this.initFontBean();
        this.bulidTree(treeItem, this.tree);
        this.addListener();
        this.setDropSource(this);
        this.setDropTarget(this);
    }

    public void bulidTree(Element element, Tree parent) {
        if (element == null) {
            return;
        }
        if (!ConfigComposite.progressBar.getParent().isDisposed()) {
            ConfigComposite.progressBar.setShellText("\u6b63\u5728\u52a0\u8f7d\u6811");
            ConfigComposite.progressBar.setProgressBar(80);
        }
        TreeItem treeItem = new TreeItem(parent, 0);
        treeItem.setText(this.getTreeItemText(element));
        treeItem.setImage(ComposeIMG.drawImgDef(element));
        treeItem.setExpanded(true);
        this.setTreeItemFont(element, treeItem);
        treeItem.setData("id", (Object)this.getTreeItemId(element));
        treeItem.setData("elementName", (Object)element.getName());
        if (element.attributeValue("id") != null) {
            treeItem.setData("elementId", (Object)element.attributeValue("id"));
        }
        if (NodeGOT.getEntity(element) != null) {
            treeItem.setData("elementEntityId", (Object)NodeGOT.getEntity(element).attributeValue("id"));
        }
        this.bulidTree(element, treeItem, true);
    }

    private void bulidTree(TreeItem baseItem, Tree parent, boolean expended) {
        TreeItem treeitem = new TreeItem(parent, 0);
        treeitem.setExpanded(expended);
        FormDataSyn.restoreSyn(baseItem, treeitem, this, expended);
    }

    private void bulidTree(TreeItem baseItem, Tree parent) {
        TreeItem treeitem = new TreeItem(parent, 0);
        FormDataSyn.copyTreeItem(baseItem, treeitem, this);
    }

    public void bulidTree(Element parentElement, TreeItem parentTreeItem, boolean recursiveBuild) {
        List list = parentElement.elements();
        for (Element element : list) {
            if (!LoadXML.nodeShowRule(element)) continue;
            TreeItem treeItem = new TreeItem(parentTreeItem, 0);
            treeItem.setText(this.getTreeItemText(element));
            treeItem.setImage(ComposeIMG.drawImgDef(element));
            this.setTreeItemFont(element, treeItem);
            treeItem.setExpanded(true);
            treeItem.setData("id", (Object)this.getTreeItemId(element));
            treeItem.setData("elementName", (Object)element.getName());
            treeItem.setData("chinese", (Object)"false");
            if (element.attributeValue("id") != null) {
                treeItem.setData("elementId", (Object)element.attributeValue("id"));
            }
            if (NodeGOT.getEntity(element) != null) {
                treeItem.setData("elementEntityId", (Object)NodeGOT.getEntity(element).attributeValue("id"));
            }
            this.setNumInfo(element);
            String parentElementName = parentElement.getName();
            if (parentElementName.equals("GOT") || parentElementName.equals("DataDictionary")) {
                parentTreeItem.setExpanded(true);
            }
            if (!recursiveBuild) continue;
            this.bulidTree(element, treeItem, recursiveBuild);
        }
    }

    public String getTreeItemText(Element element) {
        String text = LoadXML.nodeText(element);
        if (StringUtils.isBlank((String)text)) {
            text = element.getName();
        }
        return text;
    }

    public String getTreeItemId(Element element) {
        String treeItemId = "";
        TreeItem oldTreeItem = FormDataSyn.getTreeItrmByElement(element, this);
        treeItemId = oldTreeItem != null ? oldTreeItem.getData("id").toString() : NumCore.getId();
        return treeItemId;
    }

    public void loadTableValue(Table table, Element node, TreeItem trtmNewTreeitem) {
        String nodeString = node.getUniquePath();
        if (nodeString.equals(table.getData())) {
            return;
        }
        table.removeAll();
        Rectangle bound = table.getBounds();
        TableColumn column = table.getColumn(0);
        column.setWidth(bound.width / 2 - 5);
        column = table.getColumn(1);
        column.setWidth(bound.width / 2);
        if (node.element("Properties") != null) {
            List elements = node.element("Properties").elements("Property");
            for (Element element : elements) {
                TableItem item = new TableItem(table, 0);
                Element elementName = element.element("Name");
                Map<String, String> elementValueMap = GetPropertieValue.getValue(element);
                String elementValue = elementValueMap.get("flabel");
                if ("true".equals(elementValueMap.get("ifExtend"))) {
                    item.setData("ifExtend", (Object)true);
                } else {
                    item.setData("ifExtend", (Object)false);
                }
                item.setData((Object)element);
                item.setData("treeItem", (Object)trtmNewTreeitem);
                item.setText(new String[]{elementName.getText(), elementValue});
            }
        }
    }

    public void setTreeItemFont(Element element, TreeItem treeitem) {
        String createdLayer = element.attributeValue("createdLayer");
        String modifiedLayer = element.attributeValue("modifiedLayer");
        if (createdLayer == null || modifiedLayer == null) {
            return;
        }
        if (((LayerService)ObjectContainer.getInstance(LayerService.class)).getCurrentLayer() == null) {
            return;
        }
        String currentLayer = ((LayerService)ObjectContainer.getInstance(LayerService.class)).getCurrentLayer();
        if (modifiedLayer.equals(currentLayer)) {
            treeitem.setFont(this.boldFont);
        }
    }

    public Tree getTree() {
        return this.tree;
    }

    public void setTree(Tree tree) {
        this.tree = tree;
    }

    public Table getTable() {
        return this.table;
    }

    public void setTable(Table table) {
        this.table = table;
    }

    public TreeColumn getTrclmnNewColumnLabel() {
        return this.trclmnNewColumnLabel;
    }

    public void setTrclmnNewColumnLabel(TreeColumn trclmnNewColumnLabel) {
        this.trclmnNewColumnLabel = trclmnNewColumnLabel;
    }

    private void addListener() {
        this.tree.addListener(42, new Listener(){

            public void handleEvent(Event event) {
                TreeItem treeItem = (TreeItem)event.item;
                if (ConfigComposite.configComposite.button_label.getSelection() && treeItem.getText() != null && treeItem.getData("label") != null) {
                    int total = 0;
                    total = TreeUi.this.tree.getVerticalBar().getVisible() ? ((TreeUi)TreeUi.this).tree.getBounds().width - 20 : ((TreeUi)TreeUi.this).tree.getBounds().width - 8;
                    String treeItemLabel = (String)treeItem.getData("label");
                    Point labelPoint = event.gc.textExtent(treeItemLabel);
                    int remainWidth = total - event.width - event.x;
                    if (remainWidth > 0) {
                        String displayLabel = treeItemLabel;
                        int displayWidth = labelPoint.x;
                        if (remainWidth < displayWidth) {
                            int i = 1;
                            while (i < treeItemLabel.length() - 1) {
                                Point point = event.gc.textExtent(String.format("\u3010%s...\u3011", treeItemLabel.substring(1, i)));
                                if (point.x > remainWidth) {
                                    if (i > 2) {
                                        displayLabel = String.format("\u3010%s...\u3011", treeItemLabel.substring(1, i - 1));
                                        displayWidth = event.gc.textExtent((String)displayLabel).x;
                                        if (displayWidth <= remainWidth) break;
                                        displayLabel = "";
                                        break;
                                    }
                                    displayLabel = "";
                                    break;
                                }
                                ++i;
                            }
                        }
                        if (StringUtils.isNotBlank((String)displayLabel)) {
                            event.gc.drawText(displayLabel, total - displayWidth, event.y + 2, true);
                        }
                    }
                }
            }
        });
        this.tree.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                FormDataSyn.currentTreeUi = TreeUi.this;
                TreeItem trtmNewTreeitem = (TreeItem)event.item;
                Element element = GotXmlDto.getInstance().getCurrentElement(trtmNewTreeitem);
                if (element != null) {
                    TreeUi.this.loadChildItem(trtmNewTreeitem);
                    TreeUi.this.loadTableValue(TreeUi.this.table, element, trtmNewTreeitem);
                }
                int count = TreeUi.this.tree.getSelectionCount();
                if (!TreeUi.this.ctrl && count == 1) {
                    TreeUi.this.selects.clear();
                    TreeUi.this.selects.add(trtmNewTreeitem);
                }
                ConfigComposite.selectNum = count;
                ConfigComposite.text_static_info();
                TreeUi.this.selected = trtmNewTreeitem;
            }
        });
        this.tree.addListener(8, new Listener(){

            public void handleEvent(Event event) {
                int count = TreeUi.this.tree.getSelectionCount();
                if (count == 1) {
                    TreeItem treeitem = TreeUi.this.tree.getSelection()[0];
                    if (treeitem == null) {
                        event.doit = false;
                        return;
                    }
                    Element element = GotXmlDto.getInstance().getCurrentElement(treeitem);
                    NodeGOT node = NodeFactory.getNode(element);
                    boolean enter = false;
                    boolean edit = false;
                    if (node.allowDcEnter().equals("true")) {
                        enter = true;
                    }
                    if (node.allowEdit().equals("true")) {
                        edit = true;
                    }
                    if (enter) {
                        FormDataSyn.treeItemEditor(treeitem, node, edit, TreeUi.this);
                    }
                }
            }
        });
        this.tree.addListener(17, new Listener(){

            public void handleEvent(Event event) {
                TreeItem[] treeitems;
                TreeItem trtmNewTreeitem = (TreeItem)event.item;
                if (trtmNewTreeitem == null) {
                    event.doit = false;
                    return;
                }
                TreeUi.this.loadChildItem(trtmNewTreeitem);
                TreeItem[] treeItemArray = treeitems = trtmNewTreeitem.getItems();
                int n = treeitems.length;
                int n2 = 0;
                while (n2 < n) {
                    TreeItem child = treeItemArray[n2];
                    TreeUi.this.setChineseLabel(child, false);
                    ++n2;
                }
            }
        });
        this.tree.addListener(14, new Listener(){

            public void handleEvent(Event event) {
                TreeItem trtmNewTreeitem = (TreeItem)event.item;
                if (trtmNewTreeitem.getItems().length == 0) {
                    Element element = GotXmlDto.getInstance().getCurrentElement(trtmNewTreeitem);
                    TreeUi.this.bulidTree(element, trtmNewTreeitem, true);
                }
            }
        });
        this.menuEvent = new TreeMouseRigthMenuEvent(this);
        this.tree.addMouseListener((MouseListener)this.menuEvent);
        this.tree.addKeyListener(new KeyListener(){

            public void keyReleased(KeyEvent arg0) {
            }

            public void keyPressed(KeyEvent e) {
                MouseRightMenuEvent mouseRightMenuEvent;
                TreeItem treeitem;
                Element element;
                TreeItem[] items;
                if (e.stateMask == 393216 && e.keyCode == 0x1000005) {
                    int i = 0;
                    while (i < FormDataSyn.treeUis.size()) {
                        if (FormDataSyn.treeUis.get(i).getTree() == TreeUi.this.tree && i > 0) {
                            FormDataSyn.treeUis.get(i - 1).getTree().setFocus();
                        }
                        ++i;
                    }
                    TreeOperationInfo.addInfo("\u5207\u6362\u4e0a\u4e00\u4e2a\u7a97\u4f53");
                    return;
                }
                if (e.stateMask == 393216 && e.keyCode == 0x1000006) {
                    int i = 0;
                    while (i < FormDataSyn.treeUis.size()) {
                        if (FormDataSyn.treeUis.get(i).getTree() == TreeUi.this.tree && i < FormDataSyn.treeUis.size() - 1) {
                            FormDataSyn.treeUis.get(i + 1).getTree().setFocus();
                        }
                        ++i;
                    }
                    TreeOperationInfo.addInfo("\u5207\u6362\u4e0b\u4e00\u4e2a\u7a97\u4f53");
                    return;
                }
                if (e.stateMask == 9) {
                    String msg = "\u5f53\u524d\u7126\u70b9\u5728\uff1a";
                    if (TreeUi.this.tree.forceFocus()) {
                        TreeUi.this.table.setFocus();
                        if (TreeUi.this.table.getSelection().length == 0) {
                            TreeUi.this.table.setSelection(0);
                        }
                        msg = String.valueOf(msg) + "table";
                    } else {
                        TreeUi.this.tree.setFocus();
                        msg = String.valueOf(msg) + "tree";
                    }
                    TreeOperationInfo.addInfo("\u5207\u6362\u7126\u70b9\uff1a" + msg);
                    return;
                }
                if (e.keyCode == 13) {
                    items = TreeUi.this.tree.getSelection();
                    if (items.length < 1) {
                        e.doit = false;
                        return;
                    }
                    element = GotXmlDto.getInstance().getCurrentElement(items[0]);
                    NodeGOT node = NodeFactory.getNode(element);
                    if (!node.allowDcEnter().equals("true")) {
                        e.doit = false;
                        return;
                    }
                    if (!node.allowEdit().equals("true")) {
                        e.doit = false;
                        return;
                    }
                    TreeOperationInfo.addInfo("\u8fdb\u5165\u7f16\u8f91" + items[0].getText());
                    FormDataSyn.treeItemEditor(items[0], node, true, TreeUi.this);
                }
                if (e.keyCode == 32) {
                    items = TreeUi.this.tree.getSelection();
                    if (items.length < 1) {
                        e.doit = false;
                        return;
                    }
                    items[0].setExpanded(!items[0].getExpanded());
                }
                if (e.stateMask == 262144 && e.keyCode == 102) {
                    String search = GOTMessageDialog.searchTreeItem();
                    if (search != null && !"".equals(search)) {
                        TreeUi.this.setSelect(search, false);
                    }
                    TreeOperationInfo.addInfo("\u641c\u7d22:" + search);
                    return;
                }
                if (e.stateMask == 262144 && e.keyCode == 119) {
                    if (TreeUi.this.tree.getSelection().length > 0) {
                        treeitem = TreeUi.this.tree.getSelection()[0];
                        element = GotXmlDto.getInstance().getCurrentElement(treeitem);
                        if (TreeUi.this.alowShortCut(element, "newWindow")) {
                            mouseRightMenuEvent = new MouseRightMenuEvent(element, treeitem);
                            mouseRightMenuEvent.openNewFrom(false);
                            TreeOperationInfo.addInfo("\u6253\u5f00\u65b0\u7a97\u4f53 ");
                        }
                    }
                    return;
                }
                if (e.stateMask == 262144 && e.keyCode == 110) {
                    if (TreeUi.this.tree.getSelection().length > 0) {
                        treeitem = TreeUi.this.tree.getSelection()[0];
                        element = GotXmlDto.getInstance().getCurrentElement(treeitem);
                        if (TreeUi.this.alowShortCut(element, "new")) {
                            mouseRightMenuEvent = new MouseRightMenuEvent(element, treeitem);
                            mouseRightMenuEvent.AddHandle();
                            TreeOperationInfo.addInfo("\u65b0\u589e: " + treeitem.getText() + "\u5b50\u8282\u70b9");
                        }
                    }
                    return;
                }
                if (e.stateMask == 262144 && e.keyCode == 114) {
                    if (TreeUi.this.tree.getSelection().length > 0) {
                        treeitem = TreeUi.this.tree.getSelection()[0];
                        element = GotXmlDto.getInstance().getCurrentElement(treeitem);
                        if (TreeUi.this.alowShortCut(element, "restore")) {
                            mouseRightMenuEvent = new MouseRightMenuEvent(element, treeitem);
                            mouseRightMenuEvent.restoreNode();
                            TreeOperationInfo.addInfo(String.valueOf(treeitem.getText()) + "\u6062\u590d\uff1a" + Macros.INFO_OPR_SUCCESS);
                        }
                    }
                    return;
                }
                if (e.stateMask == 262144 && e.keyCode == 121) {
                    if (TreeUi.this.tree.getSelection().length > 0) {
                        treeitem = TreeUi.this.tree.getSelection()[0];
                        element = GotXmlDto.getInstance().getCurrentElement(treeitem);
                        if (TreeUi.this.alowShortCut(element, "sync")) {
                            mouseRightMenuEvent = new MouseRightMenuEvent(element, treeitem);
                            mouseRightMenuEvent.syncNodes();
                            TreeOperationInfo.addInfo("\u540c\u6b65:" + treeitem.getText());
                        }
                    }
                    return;
                }
                if (e.stateMask == 262144 && e.keyCode == 121) {
                    if (TreeUi.this.tree.getSelection().length > 0) {
                        treeitem = TreeUi.this.tree.getSelection()[0];
                        element = GotXmlDto.getInstance().getCurrentElement(treeitem);
                        if (TreeUi.this.alowShortCut(element, "restore")) {
                            mouseRightMenuEvent = new MouseRightMenuEvent(element, treeitem);
                            mouseRightMenuEvent.restoreNode();
                            TreeOperationInfo.addInfo("\u6062\u590d:" + treeitem.getText());
                        }
                    }
                    return;
                }
                if (e.stateMask == 262144 && e.keyCode == 127) {
                    if (TreeUi.this.tree.getSelection().length > 0) {
                        treeitem = TreeUi.this.tree.getSelection()[0];
                        String text = treeitem.getText();
                        Element element2 = GotXmlDto.getInstance().getCurrentElement(treeitem);
                        if (TreeUi.this.alowShortCut(element2, "delete")) {
                            MouseRightMenuEvent mouseRightMenuEvent2 = new MouseRightMenuEvent(element2, treeitem);
                            mouseRightMenuEvent2.deleteNodeCMI(true);
                            TreeOperationInfo.addInfo("\u5220\u9664:" + text);
                        }
                    }
                    return;
                }
                if (e.stateMask == 262144 && e.keyCode == 109) {
                    if (TreeUi.this.tree.getSelection().length > 0) {
                        treeitem = TreeUi.this.tree.getSelection()[0];
                        element = GotXmlDto.getInstance().getCurrentElement(treeitem);
                        if (TreeUi.this.alowShortCut(element, "method")) {
                            mouseRightMenuEvent = new MouseRightMenuEvent(element, treeitem);
                            mouseRightMenuEvent.methodSet();
                            TreeOperationInfo.addInfo("M\u6062\u590d:" + treeitem.getText());
                        }
                    }
                    return;
                }
                if (e.stateMask == 262144 && e.keyCode == 115) {
                    if (TreeUi.this.tree.getSelection().length > 0) {
                        treeitem = TreeUi.this.tree.getSelection()[0];
                        element = GotXmlDto.getInstance().getCurrentElement(treeitem);
                        mouseRightMenuEvent = new MouseRightMenuEvent(element, treeitem);
                        mouseRightMenuEvent.saveHandle(true);
                        element = GotXmlDto.getInstance().getCurrentElement(treeitem);
                        TreeUi.this.loadTableValue(TreeUi.this.table, element, treeitem);
                        TreeOperationInfo.addInfo("\u4fdd\u5b58:" + treeitem.getText());
                    }
                    return;
                }
                if (e.stateMask == 262144 && e.keyCode == 113) {
                    if (TreeUi.this.tree.getSelection().length > 0) {
                        treeitem = TreeUi.this.tree.getSelection()[0];
                        element = GotXmlDto.getInstance().getCurrentElement(treeitem);
                        if (TreeUi.this.alowShortCut(element, "quote")) {
                            mouseRightMenuEvent = new MouseRightMenuEvent(element, treeitem);
                            mouseRightMenuEvent.enterNodeRef();
                            TreeOperationInfo.addInfo("\u5f15\u7528\u5217\u8868:" + treeitem.getText());
                        }
                    }
                    return;
                }
                ConfigComposite.configComposite.setUnsavedText();
            }
        });
        final TableMouseEvent tableMouseEvent = new TableMouseEvent(this);
        this.table.addMouseListener((MouseListener)tableMouseEvent);
        this.table.addControlListener(new ControlListener(){
            int lastWidth = -1;

            public void controlMoved(ControlEvent event) {
            }

            public void controlResized(ControlEvent event) {
                if (((TreeUi)TreeUi.this).table.getBounds().width == this.lastWidth) {
                    return;
                }
                if (TreeUi.this.table.getVisible()) {
                    int w = ((TreeUi)TreeUi.this).table.getBounds().width;
                    if (TreeUi.this.table.getVerticalBar().getVisible()) {
                        w -= 25;
                    }
                    TreeUi.this.table.getColumn(0).setWidth((int)((double)w * 0.5) - 5);
                    TreeUi.this.table.getColumn(1).setWidth((int)((double)w * 0.5) - 5);
                }
                this.lastWidth = ((TreeUi)TreeUi.this).table.getBounds().width;
            }
        });
        this.table.addKeyListener(new KeyListener(){

            public void keyReleased(KeyEvent arg0) {
            }

            public void keyPressed(KeyEvent arg0) {
                int selectCol;
                if (arg0.keyCode == 13 && (selectCol = TreeUi.this.table.getSelectionCount()) > 0) {
                    TableItem item = TreeUi.this.table.getItem(TreeUi.this.table.getSelectionIndex());
                    tableMouseEvent.eidtTableItem(TreeUi.this.table, item, selectCol);
                }
                if (arg0.stateMask == 262144 && arg0.keyCode == 115) {
                    if (TreeUi.this.tree.getSelection().length > 0) {
                        TreeItem treeitem = TreeUi.this.tree.getSelection()[0];
                        Element element = GotXmlDto.getInstance().getCurrentElement(treeitem);
                        MouseRightMenuEvent mouseRightMenuEvent = new MouseRightMenuEvent(element, treeitem);
                        mouseRightMenuEvent.saveHandle(true);
                    }
                    return;
                }
                if (arg0.stateMask == 262144 && arg0.keyCode == 49) {
                    tableMouseEvent.enterRelation();
                }
                if (arg0.stateMask == 262144 && arg0.keyCode == 50) {
                    tableMouseEvent.enterNodeExtends();
                }
            }
        });
    }

    public void setDropSource(final TreeUi treeUi) {
        this.dragSource = new DragSource((Control)treeUi.getTree(), 3);
        this.dragSource.setTransfer(new Transfer[]{TextTransfer.getInstance()});
        this.dragSource.addDragListener(new DragSourceListener(){

            public void dragFinished(DragSourceEvent arg0) {
            }

            public void dragSetData(DragSourceEvent event) {
                if (TextTransfer.getInstance().isSupportedType(event.dataType)) {
                    TreeItem[] treeitems = treeUi.getTree().getSelection();
                    event.data = "" + FormDataSyn.treeUis.indexOf(treeUi);
                    TreeOperationInfo.addInfo("\u5f53\u524d\u9009\u4e2d\uff1a" + treeitems.length + "\u6761");
                }
            }

            public void dragStart(DragSourceEvent event) {
                TreeOperationInfo.addInfo("\u62d6\u52a8\u5f00\u59cb");
                if (!TreeUi.this.allowDragOpr().booleanValue()) {
                    TreeOperationInfo.addInfo("\u7981\u6b62\u62d6\u52a8");
                    event.doit = false;
                }
                FormDataSyn.dragTreeUi = treeUi;
            }
        });
    }

    public void setDropTarget(TreeUi treeUi) {
        this.dropTarget = new DropTarget((Control)treeUi.getTree(), 3);
        this.dropTarget.setTransfer(new Transfer[]{TextTransfer.getInstance()});
        this.dropTarget.addDropListener((DropTargetListener)new DropTargetAdapter(){
            TreeItem overItem = null;
            TreeItem overItemLast = null;
            int times = 0;
            int lastY = 0;
            boolean dir = true;
            boolean dropFlag = false;

            public void dragOver(DropTargetEvent event) {
                Element parentEl;
                event.detail = 0;
                if (event.y - this.lastY > 0) {
                    this.dir = true;
                } else if (event.y - this.lastY < 0) {
                    this.dir = false;
                }
                int treeY = ((TreeUi)TreeUi.this).tree.getParent().getBounds().y;
                int up = (int)((double)(treeY + ((TreeUi)TreeUi.this).tree.getParent().getBounds().height) * 0.6);
                int down = (int)((double)(treeY + ((TreeUi)TreeUi.this).tree.getParent().getBounds().height) * 0.8);
                TreeItem[] treeitems = FormDataSyn.dragTreeUi.getTree().getSelection();
                if (treeitems == null || treeitems.length == 0) {
                    return;
                }
                Element element = GotXmlDto.getInstance().getCurrentElement(treeitems[0]);
                if (element.getName().equals("TableFieldGroupItem") && (parentEl = element.getParent()) != null && "RecordCM".equals(parentEl.attributeValue("name"))) {
                    event.feedback = 0;
                    this.dropFlag = false;
                    return;
                }
                if (event.item != null) {
                    this.overItem = (TreeItem)event.item;
                    if (this.overItemLast == null) {
                        this.overItemLast = this.overItem;
                    }
                    if (this.overItemLast == this.overItem) {
                        ++this.times;
                    } else {
                        this.overItemLast = this.overItem;
                        this.lastY = event.y;
                    }
                    if (this.times > 12 && this.dir && event.y >= down) {
                        TreeUi.this.setTopItem(this.dir);
                        this.times = 12;
                    } else if (this.times > 12 && !this.dir && event.y <= up) {
                        TreeUi.this.setTopItem(this.dir);
                        this.times = 8;
                    }
                    Element hoverTarget = GotXmlDto.getInstance().getCurrentElement(this.overItem);
                    if (hoverTarget == null) {
                        event.feedback = 0;
                        this.dropFlag = false;
                        return;
                    }
                    if (TreeUi.this.allowDropOpr(element, hoverTarget).booleanValue() && TreeUi.this.validateDrop(element, hoverTarget, null).booleanValue()) {
                        event.feedback = 18;
                        event.detail = element.getName().equals("Menu") ? 2 : 1;
                        this.dropFlag = true;
                        return;
                    }
                }
                this.dropFlag = false;
                event.feedback = 1;
                TreeOperationInfo.addInfo("\u62d6\u52a8\u7ed3\u675f");
            }

            public void drop(DropTargetEvent event) {
                block24: {
                    try {
                        if (!this.dropFlag) break block24;
                        TreeItem[] treeitems = null;
                        if (FormDataSyn.dragTreeUi.selects.size() > 1 && FormDataSyn.dragTreeUi.selects.size() == FormDataSyn.dragTreeUi.getTree().getSelectionCount()) {
                            treeitems = FormDataSyn.dragTreeUi.selects.toArray(new TreeItem[FormDataSyn.dragTreeUi.selects.size()]);
                        } else {
                            FormDataSyn.dragTreeUi.selects.clear();
                            treeitems = FormDataSyn.dragTreeUi.getTree().getSelection();
                        }
                        if (treeitems == null || treeitems.length == 0) {
                            GOTMessageDialog.alert("\u672a\u627e\u5230\u9009\u4e2d\u7684\u8282\u70b9");
                            return;
                        }
                        TreeItem[] srcItemsNew = TreeUi.this.reverse(treeitems);
                        Element srcItem = GotXmlDto.getInstance().getCurrentElement(treeitems[0]);
                        ResolverNode rNode = ResolverNode.getNode(srcItem);
                        Element dropTarget = GotXmlDto.getInstance().getCurrentElement(this.overItem);
                        NodeGOT node = NodeFactory.getNode(dropTarget);
                        String moveType = node.moveType(srcItem, ((TreeUi)TreeUi.this).menuEvent.dragEvent);
                        if (moveType.equals("append")) {
                            TreeUi.this.nodeMoveHandler(treeitems, this.overItem, dropTarget);
                            return;
                        }
                        if (moveType.equals("switch")) {
                            int index = this.overItem.getParentItem().indexOf(this.overItem);
                            String treeItemId = NumCore.getId();
                            Element item = GotXmlDto.getInstance().getCurrentElement(treeitems[0]);
                            String xpath = item.attribute("id") != null ? String.format(".//%s[@id='%s']", item.getName(), item.attributeValue("id")) : (item.attribute("name") != null ? String.format(".//%s[@name='%s']", item.getName(), item.attributeValue("id")) : String.format(".//%s[@id='%s']", item.getName()));
                            Element element = (Element)NodeGOT.getEntity(dropTarget).selectSingleNode(xpath);
                            if (element != null) {
                                GOTXMLHelper.deleteNode(element);
                            }
                            GOTHelp.insertChildBefore(dropTarget.getParent(), dropTarget, item);
                            GotXmlDto.getInstance().updateEntityElement(NodeGOT.getEntity(dropTarget));
                            FormDataSyn.actionSyn(this.overItem.getParentItem(), treeItemId, item, null, index, "new", true);
                            FormDataSyn.deleteTreeItem(treeitems[0], true);
                            FormDataSyn.setUnSave(this.overItem);
                            return;
                        }
                        String validateInfo = "";
                        boolean isEntity = false;
                        if (dropTarget.getName().equals("Menu")) {
                            isEntity = true;
                        } else {
                            boolean bl = isEntity = !rNode.getInfoValue("NodeType").equals("entity");
                        }
                        if (node.isSibling(srcItem).booleanValue() && isEntity) {
                            String baseValidateInfo = node.validateAccpDragMove(srcItem, ((TreeUi)TreeUi.this).menuEvent.dragEvent);
                            TreeItem[] treeItemArray = srcItemsNew;
                            int n = srcItemsNew.length;
                            int element = 0;
                            while (element < n) {
                                TreeItem treeItem = treeItemArray[element];
                                srcItem = GotXmlDto.getInstance().getCurrentElement(treeItem);
                                validateInfo = node.validateAccpDragMove(srcItem, ((TreeUi)TreeUi.this).menuEvent.dragEvent);
                                if (!validateInfo.equals("true") && !validateInfo.equals("down")) {
                                    ConfigComposite.configComposite.set_text_op_info(String.valueOf(srcItem.attributeValue("name")) + Macros.INFO_OPR_FAIL);
                                    TreeOperationInfo.addInfo(String.valueOf(srcItem.attributeValue("name")) + Macros.INFO_OPR_FAIL);
                                    return;
                                }
                                if (!validateInfo.equals(baseValidateInfo)) {
                                    TreeOperationInfo.addErrorInfo("\u64cd\u4f5c\u4e0d\u4e00\u81f4");
                                    ConfigComposite.configComposite.set_text_op_info("\u64cd\u4f5c\u4e0d\u4e00\u81f4");
                                    return;
                                }
                                ++element;
                            }
                            if (validateInfo.equals("down")) {
                                TreeUi.this.nodeMoveHandler(treeitems, this.overItem, dropTarget);
                                return;
                            }
                            if (!TreeUi.this.nodeMoveHandler1(treeitems, this.overItem, dropTarget)) {
                                return;
                            }
                            break block24;
                        }
                        srcItemsNew = treeitems;
                        node = NodeFactory.getNode(dropTarget);
                        int i = 0;
                        while (i < srcItemsNew.length) {
                            srcItem = GotXmlDto.getInstance().getCurrentElement(srcItemsNew[i]);
                            if (!srcItem.equals(",") && srcItem != dropTarget) {
                                validateInfo = node.validateAccpDragNew(srcItem);
                                if (!validateInfo.equals("true") && !validateInfo.equals("down")) {
                                    ConfigComposite.configComposite.set_text_op_info(String.valueOf(srcItem.attributeValue("name")) + Macros.INFO_OPR_FAIL);
                                    TreeOperationInfo.addInfo(String.valueOf(srcItem.attributeValue("name")) + Macros.INFO_OPR_FAIL);
                                    return;
                                }
                                if ("TableField".equals(srcItem.getName()) && "Component".equals(srcItem.attributeValue("type")) && "TableIndex".equals(dropTarget.getName())) {
                                    Element Name2 = (Element)srcItem.selectSingleNode("./Properties/Property/Name[text()='Extends']");
                                    if (Name2 != null) {
                                        String id = Name2.getParent().attributeValue("refentityid");
                                        Element dataTypes = GotXmlDto.getInstance().getEntity(id);
                                        List dataTypeArrayItems = dataTypes.selectNodes("./DataTypeArray/DataTypeArrayItem");
                                        List currentItems = dropTarget.selectNodes(String.format("./TableIndexItem/Properties/Property[@innerid = '%s']", srcItem.attributeValue("id")));
                                        ArrayList<String> arrayItems = new ArrayList<String>();
                                        for (Element currentItem : currentItems) {
                                            Element tableIndexItem = currentItem.getParent().getParent();
                                            String arrayItem = GOTHelp.getPPAttValue(tableIndexItem, "Name", "ArrayItem");
                                            arrayItems.add(arrayItem);
                                        }
                                        for (Element dataTypeArrayItem : dataTypeArrayItems) {
                                            if (arrayItems.contains(dataTypeArrayItem.attributeValue("name"))) continue;
                                            TreeUi.this.doDrop(node, dataTypeArrayItem, this.overItem, srcItemsNew, dropTarget, i);
                                        }
                                    }
                                } else {
                                    TreeUi.this.doDrop(node, srcItem, this.overItem, srcItemsNew, dropTarget, i);
                                }
                            }
                            ++i;
                        }
                        return;
                    }
                    catch (Exception e) {
                        Display.getDefault().asyncExec(new Runnable(){

                            @Override
                            public void run() {
                                GOTMessageDialog.alert(e);
                            }
                        });
                        Logger.getLogger(((Object)((Object)this)).getClass()).error((Object)"", (Throwable)e);
                    }
                }
            }
        });
    }

    private void doDrop(NodeGOT node, Element srcItem, TreeItem overItem, TreeItem[] srcItemsNew, Element dropTarget, int i) {
        NodeGOT newNode = node.getAccpDragNewNode(srcItem);
        String parent = node.getAccpDragNewInsertBase();
        Integer index = null;
        boolean addTreeItem = false;
        TreeItem parentItem = null;
        if (parent.equals("self")) {
            Element childBefore = newNode.getInsertChildBefore(dropTarget);
            if (overItem.getParentItem() == srcItemsNew[i].getParentItem() && overItem.getParentItem() != null) {
                index = overItem.getParentItem().indexOf(overItem);
            }
            if (overItem.getText().equals("Forms") || overItem.getText().equals("MenuItems") || overItem.getText().equals("Menus")) {
                index = 0;
            }
            this.insertNode(newNode, dropTarget, childBefore, false, overItem, index);
            if (childBefore == null) {
                String insertAt = newNode.getInsertAt();
                index = insertAt.equals("append") ? null : Integer.valueOf(0);
            }
            parentItem = overItem;
            addTreeItem = true;
        } else if (parent.equals("parent")) {
            this.insertNode(newNode, dropTarget.getParent(), dropTarget, false, overItem.getParentItem(), overItem.getParentItem().indexOf(overItem) + i);
            index = overItem.getParentItem().indexOf(overItem);
            parentItem = overItem.getParentItem();
            addTreeItem = true;
        } else if (parent.equals("false")) {
            return;
        }
        newNode.doAfterDragDroped();
        if (NodeGOT.getEntity(newNode.xml.getParent()) == null) {
            GotXmlDto.getInstance().addEntityElement(newNode.xml);
        } else {
            GotXmlDto.getInstance().updateEntityElement(NodeGOT.getEntity(newNode.xml));
        }
        if (addTreeItem) {
            String treeItemId = NumCore.getId();
            if (i == srcItemsNew.length - 1) {
                FormDataSyn.actionSyn(parentItem, treeItemId, newNode.xml, node, index, "new", true);
            } else {
                FormDataSyn.actionSyn(parentItem, treeItemId, newNode.xml, node, index, "new", false);
            }
        }
    }

    private Boolean allowDragOpr() {
        TreeItem[] treeSelectedItems = this.tree.getSelection();
        if (treeSelectedItems == null || treeSelectedItems.length == 0) {
            return false;
        }
        Element element = GotXmlDto.getInstance().getCurrentElement(treeSelectedItems[0]);
        if ("true".equals(GOTXMLHelper.getPropertyValue(element, "SubForm"))) {
            return false;
        }
        TreeItem parentItem = treeSelectedItems[0].getParentItem();
        if (this.isInDragMapping(element.getName(), null, true, false).booleanValue()) {
            TreeItem[] treeItemArray = treeSelectedItems;
            int n = treeSelectedItems.length;
            int n2 = 0;
            while (n2 < n) {
                TreeItem item = treeItemArray[n2];
                Element obj = GotXmlDto.getInstance().getCurrentElement(item);
                if (item.getParentItem() != parentItem) {
                    return false;
                }
                if (obj.attribute("saved") != null) {
                    return false;
                }
                ++n2;
            }
            return true;
        }
        return false;
    }

    public Boolean isInDragMapping(String src, String des, Boolean checkFrom, Boolean checkTo) {
        block6: {
            block5: {
                if (checkFrom == null) {
                    checkFrom = true;
                }
                if (checkTo == null) {
                    checkTo = true;
                }
                if (checkFrom.booleanValue() && checkTo.booleanValue()) {
                    return FromToMapping.fromToMap.containsKey(String.valueOf(src) + des);
                }
                if (!checkFrom.booleanValue()) break block5;
                for (String key : FromToMapping.fromToMap.keySet()) {
                    if (!key.contains(src)) continue;
                    return true;
                }
                break block6;
            }
            if (!checkTo.booleanValue()) break block6;
            for (String key : FromToMapping.fromToMap.keySet()) {
                if (!key.contains(des)) continue;
                return true;
            }
        }
        return false;
    }

    private Boolean allowDropOpr(Element src, Element target) {
        Boolean allow;
        if (src == null) {
            return false;
        }
        String currentLayer = ((LayerService)ObjectContainer.getInstance(LayerService.class)).getCurrentLayer();
        if ("plg".equals(currentLayer)) {
            String sourceCreateLayer = GOTXMLUtils.getCreatedLayer(src);
            int sourceCreateLayerLevel = ((LayerLevelManager)ObjectContainer.getInstance(LayerLevelManager.class)).getLayerLevel(sourceCreateLayer);
            if (sourceCreateLayerLevel < 5) {
                if ("TableField".equals(src.getName())) {
                    if ("TableIndex".equals(target.getName()) || "TableIndexItem".equals(target.getName()) || "DataTypes".equals(target.getName()) || "DataType".equals(target.getName())) {
                        return true;
                    }
                } else if ("FormDataSourceField".equals(src.getName())) {
                    if ("FormItem".equals(target.getName()) || "FormDesign".equals(target.getName())) {
                        return true;
                    }
                } else if ("Table".equals(src.getName())) {
                    if ("Forms".equals(target.getName()) || "Form".equals(target.getName()) && target.getParent() != null || "FormDataSources".equals(target.getName()) || "FormDataSource".equals(target.getName())) {
                        return true;
                    }
                } else if ("MenuItem".equals(src.getName())) {
                    if ("FormItem".equals(target.getName()) || "FormDesign".equals(target.getName())) {
                        return true;
                    }
                    if ("Menu".equals(target.getName()) || "MenuSub".equals(target.getName()) || "MenuRefMenuItem".equals(target.getName())) {
                        return true;
                    }
                } else {
                    if (EntityType.Enum.name().equals(src.getName())) {
                        return true;
                    }
                    if (EntityType.DataType.name().equals(src.getName())) {
                        return true;
                    }
                }
                return false;
            }
        }
        if ((allow = this.isInDragMapping(src.getName(), target.getName(), null, null)).booleanValue()) {
            if ((src.getName().equals("Table") || src.getName().equals("DataType")) && !this.checkClobAndBlobField(src, target.getName())) {
                TreeOperationInfo.addInfo("\u5305\u542b\u6709Clob\u6216Blob\u5c5e\u6027\u7684\u5b9e\u4f53\u8282\u70b9\u6216\u5b50\u8282\u70b9\uff0c\u4e0d\u80fd\u88ab\u62d6\u52a8\u5230" + target.getName());
                ConfigComposite.configComposite.set_text_op_info("\u5305\u542b\u6709Clob\u6216Blob\u5c5e\u6027\u7684\u5b9e\u4f53\u8282\u70b9\u6216\u5b50\u8282\u70b9\uff0c\u4e0d\u80fd\u88ab\u62d6\u52a8\u5230" + target.getName());
                return false;
            }
            if (src.getName().equals("Table") && "Form".equals(target.getName()) && target.getParent() == null) {
                return false;
            }
            if (src.getName().equals("TableField") && target.getName().equals("TableIndex") && "RecIdx".equals(target.attributeValue("name"))) {
                return false;
            }
            if (target.getParent() != null && src.getName().equals("TableField") && target.getParent().getName().equals("TableIndex") && "RecIdx".equals(target.getParent().attributeValue("name"))) {
                return false;
            }
            String result = FromToMapping.fromToMap.get(String.valueOf(src.getName()) + target.getName());
            if ("true".equals(result)) {
                if (NodeGOT.getEntity(src).asXML().equals(NodeGOT.getEntity(target).asXML())) {
                    return true;
                }
                return false;
            }
            if ("ref".equals(result)) {
                if (src.getParent().asXML().equals(target.getParent().asXML())) {
                    return true;
                }
                return false;
            }
            return true;
        }
        return false;
    }

    private boolean checkClobAndBlobField(Element xml, String tarName) {
        String type;
        String name = xml.getName();
        if (name.equals("Table")) {
            List tableFields = xml.element("TableFields").elements("TableField");
            for (Element element : tableFields) {
                String type2 = element.attributeValue("type");
                if (!type2.equals("Clob") && !type2.equals("Blob")) continue;
                return false;
            }
        } else if (name.equals("DataType") && ((type = xml.attributeValue("type")).equals("Clob") || type.equals("Blob")) && tarName.startsWith("Form")) {
            return false;
        }
        return true;
    }

    private Boolean validateDrop(Element item, Element dropItem, Boolean down) {
        if (!(down = Boolean.valueOf(down == null ? true : down)).booleanValue() && dropItem.getParent() == item.getParent() && dropItem.getParent().indexOf((Node)dropItem) == item.getParent().indexOf((Node)dropItem) + 1) {
            return false;
        }
        Element parent = dropItem;
        while (parent != null && !NodeGOT.isEntity(parent).booleanValue()) {
            if (parent.asXML().equals(item.asXML())) {
                return false;
            }
            parent = parent.getParent();
        }
        return true;
    }

    public TreeItem[] reverse(TreeItem[] array) {
        TreeItem[] newArray = new TreeItem[array.length];
        int i = 0;
        while (i < newArray.length) {
            newArray[i] = array[array.length - i - 1];
            ++i;
        }
        return newArray;
    }

    private boolean nodeMoveHandler(TreeItem[] treeitems, TreeItem overItem, Element dropTarget) {
        Element item;
        int i = 0;
        while (i < treeitems.length) {
            item = GotXmlDto.getInstance().getCurrentElement(treeitems[i]);
            if (!this.validateDrop(item, dropTarget, null).booleanValue()) {
                return false;
            }
            ++i;
        }
        i = 0;
        while (i < treeitems.length) {
            item = GotXmlDto.getInstance().getCurrentElement(treeitems[i]);
            Element copy = item.createCopy();
            GOTXMLHelper.deleteNode(item);
            dropTarget = GotXmlDto.getInstance().getCurrentElement(overItem);
            dropTarget.add(copy.detach());
            GotXmlDto.getInstance().updateEntityElement(NodeGOT.getEntity(dropTarget));
            String treeItemId = NumCore.getId();
            if (i == treeitems.length - 1) {
                FormDataSyn.actionSyn(overItem, treeItemId, copy, null, null, "new", true);
            } else {
                FormDataSyn.actionSyn(overItem, treeItemId, copy, null, null, "new", false);
            }
            FormDataSyn.deleteTreeItem(treeitems[i], false);
            ++i;
        }
        return true;
    }

    private boolean nodeMoveHandler1(TreeItem[] treeitems, TreeItem overItem, Element dropTarget) {
        int i = 0;
        while (i < treeitems.length) {
            Element item = GotXmlDto.getInstance().getCurrentElement(treeitems[i]);
            if (!this.validateDrop(item, dropTarget, null).booleanValue()) {
                return false;
            }
            ++i;
        }
        TreeItem itemParent = treeitems[0].getParentItem();
        boolean after = itemParent == null;
        int index = overItem.getParentItem().indexOf(overItem);
        TreeItem overItemParent = overItem.getParentItem();
        int i2 = 0;
        while (i2 < treeitems.length) {
            Element item;
            Element copy = item = GotXmlDto.getInstance().getCurrentElement(treeitems[i2]);
            GOTXMLHelper.deleteNode(item);
            dropTarget = GotXmlDto.getInstance().getCurrentElement(overItem);
            String treeItemId = NumCore.getId();
            NodeGOT node = NodeFactory.getNode(copy);
            if (after) {
                if (!item.getName().equals("Menu")) {
                    FormDataSyn.actionSyn(overItemParent, treeItemId, copy, node, null, "new", true);
                    dropTarget.getParent().add(copy.detach());
                } else {
                    FormDataSyn.actionSyn(overItemParent, treeItemId, copy, node, null, "exchange", true);
                }
            } else if (!item.getName().equals("Menu")) {
                GOTHelp.insertChildBefore(dropTarget.getParent(), dropTarget, copy);
                GotXmlDto.getInstance().updateEntityElement(NodeGOT.getEntity(dropTarget));
                if (i2 == treeitems.length - 1) {
                    FormDataSyn.actionSyn(overItemParent, treeItemId, copy, node, i2 + index, "new", true);
                } else {
                    FormDataSyn.actionSyn(overItemParent, treeItemId, copy, node, i2 + index, "new", false);
                }
            } else {
                FormDataSyn.actionSyn(overItemParent, treeItemId, copy, node, i2 + index, "exchange", true);
            }
            ++i2;
        }
        i2 = 0;
        while (i2 < treeitems.length) {
            FormDataSyn.deleteTreeItem(treeitems[i2], false);
            ++i2;
        }
        return true;
    }

    private void insertNode(NodeGOT node, Element parent, Element childBefore, Boolean autoEnterEdit, TreeItem overItem, Integer index) {
        node.doBeforeInsert();
        Element xml = node.xml;
        if (parent == null) {
            parent = GotXmlDto.getInstance().getCurrentElement(overItem);
        }
        if (childBefore == null) {
            String insertAt = node.getInsertAt();
            if (insertAt.equals("append")) {
                parent.add(xml.detach());
                index = null;
            } else {
                parent.elements().add(0, xml);
                index = 0;
            }
        } else {
            Element parentChild = null;
            if (childBefore.getParent() != null) {
                parentChild = childBefore.getParent();
                GOTHelp.insertChildBefore(parentChild, childBefore, xml);
            }
        }
        node.doAfterInsert();
    }

    public void setSelect(String search, boolean openWin) {
        Pattern p = Pattern.compile("[\u4e00-\u9fa5]");
        Matcher m = p.matcher(search);
        TreeItem[] items = null;
        TreeItem entityItem = this.getSearchEntityTreeItem(search);
        items = entityItem == null ? this.tree.getItems() : entityItem.getItems();
        if (m.find()) {
            TreeItem item = this.tree.getSelection()[0];
            String itText = item.getText();
            if (itText.equals("Enums") || itText.equals("DataTypes") || itText.equals("Tables") || itText.equals("Maps") || itText.equals("Menus") || itText.equals("MenuItems") || itText.equals("Forms") || itText.equals("Classes")) {
                items = item.getItems();
            }
            int i = 0;
            while (i < items.length) {
                String Label2 = (String)items[i].getData("label");
                if (Label2 != null && (Label2.equals(search) || search.contains("*") && Label2.contains(search.replace("*", "")) || Label2.equals("\u3010" + search + "\u3011"))) {
                    if (!openWin) {
                        this.tree.setSelection(items[i]);
                        Element temp = GotXmlDto.getInstance().getCurrentElement(items[i]);
                        this.loadTableValue(this.table, temp, items[i]);
                        ConfigComposite.configComposite.set_text_Label_title(items[i]);
                        break;
                    }
                    new TreeUiBean(items[i], false, true);
                    return;
                }
                this.findTreeItemEntity(items[i], search, openWin);
                ++i;
            }
        } else {
            String[] temp;
            String childId = null;
            if (search.contains(".") && (temp = search.split("\\.")).length == 2) {
                search = temp[0];
                childId = temp[1];
            }
            int i = 0;
            while (i < items.length) {
                Element element = GotXmlDto.getInstance().getCurrentElement(items[i]);
                if (search.equals(element.attributeValue("id"))) {
                    if (childId != null) {
                        this.findTreeItemChild(items[i], childId);
                    } else if (openWin) {
                        new TreeUiBean(items[i], false, true);
                    } else {
                        this.tree.setSelection(items[i]);
                        Element temp2 = GotXmlDto.getInstance().getCurrentElement(items[i]);
                        this.loadTableValue(this.table, temp2, items[i]);
                        ConfigComposite.configComposite.set_text_Label_title(items[i]);
                    }
                    return;
                }
                this.findTreeItem(items[i], search, childId, openWin);
                ++i;
            }
        }
    }

    public void openEntityShell(String search) {
        TreeItem[] items = FormDataSyn.treeUis.get(0).getTree().getItems();
        int i = 0;
        while (i < items.length) {
            Element element = GotXmlDto.getInstance().getCurrentElement(items[i]);
            if (element.attribute("version") != null) {
                if (search.equals(element.attributeValue("id"))) {
                    new TreeUiBean(items[i], false, true);
                    return;
                }
            } else {
                this.findTreeItem(items[i], search, null, true);
            }
            ++i;
        }
    }

    private void findTreeItem(TreeItem treeItemParent, String search, String childId, boolean openWin) {
        TreeItem[] items = treeItemParent.getItems();
        int i = 0;
        while (i < items.length) {
            Element element = GotXmlDto.getInstance().getCurrentElement(items[i]);
            if (search.equals(element.attributeValue("id"))) {
                if (childId != null) {
                    this.findTreeItemChild(items[i], childId);
                } else if (openWin) {
                    new TreeUiBean(items[i], false, true);
                } else {
                    this.tree.setSelection(items[i]);
                    Element temp = GotXmlDto.getInstance().getCurrentElement(items[i]);
                    this.loadTableValue(this.table, temp, items[i]);
                    ConfigComposite.configComposite.set_text_Label_title(items[i]);
                }
                return;
            }
            this.findTreeItem(items[i], search, childId, openWin);
            ++i;
        }
    }

    private void findTreeItemChild(TreeItem treeItemParent, String search) {
        TreeItem[] items = treeItemParent.getItems();
        int i = 0;
        while (i < items.length) {
            Element element = GotXmlDto.getInstance().getCurrentElement(items[i]);
            if (search.equals(element.attributeValue("id"))) {
                this.tree.setSelection(items[i]);
                Element temp = GotXmlDto.getInstance().getCurrentElement(items[i]);
                this.loadTableValue(this.table, temp, items[i]);
                ConfigComposite.configComposite.set_text_Label_title(items[i]);
                return;
            }
            this.findTreeItemChild(items[i], search);
            ++i;
        }
    }

    private void findTreeItemEntity(TreeItem treeItemParent, String search, boolean openWin) {
        TreeItem[] items = treeItemParent.getItems();
        int i = 0;
        while (i < items.length) {
            String Label2 = (String)items[i].getData("label");
            if (Label2 != null && (Label2.equals(search) || search.contains("*") && Label2.contains(search.replace("*", "")) || Label2.equals("\u3010" + search + "\u3011"))) {
                if (!openWin) {
                    this.tree.setSelection(items[i]);
                    Element temp = GotXmlDto.getInstance().getCurrentElement(items[i]);
                    this.loadTableValue(this.table, temp, items[i]);
                    ConfigComposite.configComposite.set_text_Label_title(items[i]);
                    break;
                }
                new TreeUiBean(items[i], false, true);
                return;
            }
            this.findTreeItemEntity(items[i], search, openWin);
            ++i;
        }
    }

    private void setNumInfo(Element element) {
        if (element.getName().equals("Table")) {
            ++ConfigComposite.tableNum;
            String createBy = GOTHelper.getPropertyValue((Element)element, (String)"CreatedBy");
            if (!"sys".equals(createBy)) {
                ++ConfigComposite.tableBusNum;
            }
        } else if (element.getName().equals("Form")) {
            ++ConfigComposite.fromNum;
        }
    }

    public void setChineseLabel(TreeItem treeitem, boolean setAll) {
        block8: {
            block7: {
                TreeItem[] treeitems;
                if (treeitem == null) {
                    return;
                }
                if (StringUtils.isNotBlank((String)((String)treeitem.getData("label"))) && !"false".equals(String.valueOf(treeitem.getData("chinese")))) {
                    return;
                }
                String itemName = treeitem.getText();
                if (!itemName.equals("GOT") && !itemName.equals("DataDictionary") && !itemName.equals("Enums") && !itemName.equals("DataTypes") && !itemName.equals("Tables") && !itemName.equals("Menus") && !itemName.equals("Forms")) break block7;
                TreeItem[] treeItemArray = treeitems = treeitem.getItems();
                int n = treeitems.length;
                int n2 = 0;
                while (n2 < n) {
                    TreeItem child = treeItemArray[n2];
                    Element element = GotXmlDto.getInstance().getCurrentElement(child);
                    String label = (String)child.getData("label");
                    if (StringUtils.isBlank((String)label)) {
                        child.setData("label", (Object)TreeChineseLabel.commitProperties(element));
                    }
                    ++n2;
                }
                break block8;
            }
            if (!ConfigComposite.configComposite.button_label.getSelection()) break block8;
            Element element = GotXmlDto.getInstance().getCurrentElement(treeitem);
            String text = TreeChineseLabel.commitProperties(element);
            treeitem.setData("label", (Object)text);
            if (!"".equals(text)) {
                treeitem.setData("chinese", (Object)"true");
            }
            if (setAll) {
                TreeItem[] treeitems;
                TreeItem[] treeItemArray = treeitems = treeitem.getItems();
                int n = treeitems.length;
                int n3 = 0;
                while (n3 < n) {
                    TreeItem child = treeItemArray[n3];
                    this.setChineseLabel(child, setAll);
                    ++n3;
                }
            }
        }
    }

    public void cleanMaps(TreeItem treeItem) {
        TreeItem[] items;
        TreeItem[] treeItemArray = items = treeItem.getItems();
        int n = items.length;
        int n2 = 0;
        while (n2 < n) {
            TreeItem treeItem2 = treeItemArray[n2];
            String id = treeItem2.getData("id").toString();
            this.itemsMap.remove(id);
            this.cleanMaps(treeItem2);
            ++n2;
        }
    }

    public void insertMap(Tree tree_) {
        TreeItem[] items;
        TreeItem[] treeItemArray = items = tree_.getItems();
        int n = items.length;
        int n2 = 0;
        while (n2 < n) {
            TreeItem treeItem = treeItemArray[n2];
            this.itemsMap.put(treeItem.getData("id").toString(), treeItem);
            this.insertMap(treeItem);
            ++n2;
        }
    }

    public void insertMap(TreeItem treeItems) {
        TreeItem[] items;
        TreeItem[] treeItemArray = items = treeItems.getItems();
        int n = items.length;
        int n2 = 0;
        while (n2 < n) {
            TreeItem treeItem = treeItemArray[n2];
            this.itemsMap.put(treeItem.getData("id").toString(), treeItem);
            if (treeItem.getItems().length > 0) {
                this.insertMap(treeItem);
            }
            ++n2;
        }
    }

    public TreeItem getSearchEntityTreeItem(String search) {
        TreeItem[] items = this.tree.getSelection();
        if (items.length == 0) {
            return null;
        }
        Element itemData = GotXmlDto.getInstance().getCurrentElement(items[0]);
        Element eneity = NodeGOT.getEntity(itemData);
        if (eneity == null) {
            return null;
        }
        if (eneity.attributeValue("id").equals(itemData.attributeValue("id")) && search.length() > 5) {
            return null;
        }
        TreeItem item = FormDataSyn.getTreeItrmByElement(eneity, this);
        return item;
    }

    private void setTopItem(boolean dir) {
        TreeItem item = this.tree.getTopItem();
        if (dir) {
            if (item.getExpanded()) {
                TreeItem[] child = item.getItems();
                this.tree.setTopItem(child[0]);
            } else {
                this.topItem(item, dir);
            }
        } else {
            this.topItem(item, dir);
        }
    }

    private void topItem(TreeItem item, boolean dir) {
        if (dir) {
            TreeItem parentItem = item.getParentItem();
            if (parentItem != null) {
                TreeItem[] child = parentItem.getItems();
                int index = parentItem.indexOf(item);
                if (index < child.length - 1) {
                    this.tree.setTopItem(child[index + 1]);
                } else {
                    this.topItem(parentItem, dir);
                }
            }
        } else {
            TreeItem parentItem = item.getParentItem();
            if (parentItem != null) {
                TreeItem[] child = parentItem.getItems();
                int index = parentItem.indexOf(item);
                if (index > 0) {
                    this.tree.setTopItem(child[index - 1]);
                } else {
                    this.tree.setTopItem(parentItem);
                }
            }
        }
    }

    public boolean alowShortCut(Element node, String operate) {
        List elements = NodeGOT.getContextMenu(node).selectNodes("./menuitem");
        for (Element element : elements) {
            if (!operate.equals(element.attributeValue("func"))) continue;
            return true;
        }
        return false;
    }

    public void loadChildItem(TreeItem trtmNewTreeitem) {
        if (trtmNewTreeitem.getData("items") != null && trtmNewTreeitem.getData("items").equals("part")) {
            trtmNewTreeitem.removeAll();
            String treeItemId = String.valueOf(trtmNewTreeitem.getData("id"));
            TreeItem base = FormDataSyn.treeUis.get((int)0).itemsMap.get(treeItemId);
            FormDataSyn.copyTreeItem(base, trtmNewTreeitem, this);
            trtmNewTreeitem.setData("items", (Object)"all");
        }
    }
}

