/*
 * Decompiled with CFR 0.152.
 */
package gongqi.gdt.designer.core.got.node.form;

import com.ximpleware.VTDException;
import gongqi.designer.got.vtd.EntityNode;
import gongqi.designer.got.vtd.GOTNode;
import gongqi.erp.gotmodel.core.EntityType;
import gongqi.gdt.designer.core.got.node.Branch;
import gongqi.gdt.designer.core.got.node.NodeGOT;
import info.gongqi.got.model.GotXmlDto;
import info.gongqi.got.tool.GOTHelp;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.lang.StringUtils;
import org.dom4j.Element;

public class FormDataSourceGroupBy
extends Branch {
    @Override
    public Boolean allowNew() {
        if (!super.allowNew().booleanValue()) {
            return false;
        }
        Element formDataSource = this.xml.getParent();
        String joinSource = GOTHelp.getPPAttValue(formDataSource, "Name", "JoinSource");
        String joinType = GOTHelp.getPPAttValue(formDataSource, "Name", "JoinType");
        List<String> joinTypes = Arrays.asList("InnerJoin", "ExistJoin", "NotExistJoin", "LeftJoin");
        if (StringUtils.isNotBlank((String)joinSource) || joinTypes.contains(joinType)) {
            return false;
        }
        String dataSourceType = GOTHelp.getPPAttValue(formDataSource, "Name", "DataSourceType");
        if (!"Aggregate".equals(dataSourceType) && !"Pivot".equals(dataSourceType)) {
            return false;
        }
        return true;
    }

    @Override
    public String getAccpDragNewInsertBase() {
        return "self";
    }

    @Override
    public NodeGOT getAccpDragNewNode(Element src) {
        if (!this.allowNew().booleanValue()) {
            throw new RuntimeException("\u5f53\u524d\u8282\u70b9\u4e0d\u5141\u8bb8\u65b0\u589e");
        }
        if (src.getName().equals("FormDataSourceField")) {
            Element formDataSource = src.getParent().getParent();
            Element baseFormDataSource = this.xml.getParent();
            String type = "";
            if (formDataSource.attributeValue("id").equals(baseFormDataSource.attributeValue("id"))) {
                type = "Field";
            } else {
                type = "UnionField";
                if (!this.isUnionDataSource(baseFormDataSource, formDataSource)) {
                    throw new RuntimeException(String.format("%s\u548c%s\u4e0d\u5c5e\u4e8e\u540c\u4e00\u6570\u636e\u6e90\u7ec4", formDataSource.attributeValue("name"), baseFormDataSource.attributeValue("name")));
                }
            }
            NodeGOT node = super.doAccpDragNew("FormDataSourceGroupByItem", type);
            this.doAccpDragNewAfer(src, node.xml);
            return node;
        }
        return null;
    }

    private boolean isUnionDataSource(Element baseDataSource, Element validateDataSource) {
        String baseId = baseDataSource.attributeValue("id");
        Element joinSource = GOTHelp.getPPAttElement(validateDataSource, "Name", "JoinSource");
        String joinType = GOTHelp.getPPAttValue(validateDataSource, "Name", "JoinType");
        List formDataSource = baseDataSource.getParent().elements("./FormDataSource");
        Map<String, Element> maps = formDataSource.stream().collect(Collectors.toMap(e -> e.attributeValue("id"), e -> e));
        while (joinSource != null && StringUtils.isNotBlank((String)joinSource.attributeValue("innerid")) && !joinType.equals("Delayed")) {
            String innerid = joinSource.attributeValue("innerid");
            if (innerid.equals(baseId)) {
                return true;
            }
            Element joinDataSource = maps.get(innerid);
            if (joinDataSource == null) {
                return false;
            }
            joinSource = GOTHelp.getPPAttElement(joinDataSource, "Name", "JoinSource");
            joinType = GOTHelp.getPPAttValue(validateDataSource, "Name", "JoinType");
        }
        return false;
    }

    private void doAccpDragNewAfer(Element src, Element xml) {
        try {
            Element dataSourceFieldProperty = GOTHelp.getPPAttElement(src, "Name", "Field");
            String refentityid = dataSourceFieldProperty.attributeValue("refentityid");
            String refinnerid = dataSourceFieldProperty.attributeValue("refinnerid");
            String srcName = src.attributeValue("name");
            Element formDataSource = src.getParent().getParent();
            String name = String.format("%s.%s", formDataSource.attributeValue("name"), srcName);
            List findSame = this.xml.selectNodes(String.format("./FormDataSourceGroupByItem[@name = '%s']", name));
            if (!findSame.isEmpty()) {
                throw new RuntimeException("\u91cd\u590d\u6dfb\u52a0\u7684\u5b57\u6bb5" + name);
            }
            xml.addAttribute("name", name);
            Element fieldProperty = GOTHelp.getPPAttElement(xml, "Name", xml.attributeValue("type"));
            fieldProperty.addAttribute("refentityid", refentityid);
            fieldProperty.addAttribute("refinnerid", refinnerid);
            if (srcName.contains(".")) {
                fieldProperty.element("Value").setText(srcName.substring(0, srcName.indexOf(".")));
            } else {
                fieldProperty.element("Value").setText(srcName);
            }
            EntityNode table = GotXmlDto.getInstance().getEntityByIdAndType(EntityType.Table, refentityid);
            GOTNode tableField = table.selectSingleNode(String.format("./TableFields/TableField[@id ='%s']", refinnerid));
            if ("Component".equals(tableField.getAttributeValue("type"))) {
                Element arrayItemProperty = GOTHelp.getPPAttElement(xml, "Name", "ArrayItem");
                String componentName = srcName.substring(srcName.lastIndexOf(".") + 1);
                String dataTypeId = tableField.getProperty("Extends").getRefEntityId();
                EntityNode dataType = GotXmlDto.getInstance().getEntityByIdAndType(EntityType.DataType, dataTypeId);
                GOTNode dataTypeArrayItem = dataType.selectSingleNode("./DataTypeArray/DataTypeArrayItem[@name='" + componentName + "']");
                arrayItemProperty.addAttribute("refentityid", dataTypeId);
                arrayItemProperty.addAttribute("refinnerid", dataTypeArrayItem.getId());
                arrayItemProperty.element("Value").setText(componentName);
            }
            if ("UnionField".equals(xml.attributeValue("type"))) {
                Element unionSourcePro = GOTHelp.getPPAttElement(xml, "Name", "UnionSource");
                unionSourcePro.addAttribute("innerid", formDataSource.attributeValue("id"));
                unionSourcePro.element("Value").setText(formDataSource.attributeValue("name"));
            }
        }
        catch (VTDException e) {
            throw new RuntimeException(e);
        }
    }
}

