/*
 * Decompiled with CFR 0.152.
 */
package gongqi.gdt.designer.service.modify;

import gongqi.gdt.designer.handler.JDTHandler;
import gongqi.gdt.designer.service.GOTModel;
import gongqi.gdt.designer.service.modify.BaseModify;
import gongqi.gdt.designer.service.node.GOTEntity;
import gongqi.gdt.designer.service.node.GOTNode;
import gongqi.gdt.osgi.JDTService;
import java.io.File;
import org.eclipse.jdt.core.ICompilationUnit;

public class EnumModify
extends BaseModify {
    public EnumModify(GOTModel sourceGOT, GOTModel targetGOT, GOTModel originalTargetGOT) {
        super(sourceGOT, targetGOT, originalTargetGOT);
    }

    @Override
    protected void afterEntityRename(GOTEntity entity, String srcName, String destName) {
        File srcJavaFile = new File(this.getJavaSourceDir(entity), String.format("/enums/%s.java", srcName));
        if (!srcJavaFile.exists()) {
            this.log.warn((Object)String.format("\u5b9e\u4f53%sJava\u6587\u4ef6\u4e0d\u5b58\u5728%s", entity.getId(), srcJavaFile.getName()));
            return;
        }
        try {
            JDTService server = JDTHandler.getServer();
            ICompilationUnit classUnit = server.getClassUnit(srcJavaFile.getAbsolutePath());
            server.renameClass(classUnit, destName);
        }
        catch (Exception e) {
            this.log.warn((Object)String.format("\u5b9e\u4f53%sJava\u6587\u4ef6\u91cd\u547d\u540d\u3010%s -> %s\u3011\u5931\u8d25", entity.getId(), srcName, destName), (Throwable)e);
        }
    }

    @Override
    protected void afterInnerNodeRename(GOTEntity entity, GOTNode node, String srcName, String destName) {
        File srcJavaFile;
        String entityName = entity.getName();
        if (entityName.contains(".")) {
            entityName = entityName.substring(entityName.lastIndexOf(".") + 1);
        }
        if (!(srcJavaFile = new File(this.getJavaSourceDir(entity), String.format("/enums/%s.java", entityName))).exists()) {
            this.log.warn((Object)String.format("\u5b9e\u4f53%sJava\u6587\u4ef6\u4e0d\u5b58\u5728%s", entity.getId(), srcJavaFile.getName()));
            return;
        }
        try {
            JDTService server = JDTHandler.getServer();
            ICompilationUnit classUnit = server.getClassUnit(srcJavaFile.getAbsolutePath());
            server.renameVariable(classUnit, srcName, destName);
        }
        catch (Exception e) {
            this.log.warn((Object)String.format("\u5b9e\u4f53%sJava\u5185\u90e8\u8282\u70b9\u91cd\u547d\u540d\u3010%s -> %s\u3011\u5931\u8d25", entity.getId(), srcName, destName), (Throwable)e);
        }
    }
}

