/*
 * Decompiled with CFR 0.152.
 */
package gongqi.gdt.designer.service.modify;

import gongqi.gdt.designer.handler.JDTHandler;
import gongqi.gdt.designer.service.GOTModel;
import gongqi.gdt.designer.service.modify.BaseModify;
import gongqi.gdt.designer.service.node.GOTEntity;
import gongqi.gdt.designer.service.node.GOTNode;
import gongqi.gdt.osgi.JDTService;
import java.io.File;
import org.eclipse.jdt.core.ICompilationUnit;

public class TableModify
extends BaseModify {
    public TableModify(GOTModel sourceGOT, GOTModel targetGOT, GOTModel originalTargetGOT) {
        super(sourceGOT, targetGOT, originalTargetGOT);
    }

    @Override
    protected void afterEntityRename(GOTEntity entity, String srcName, String destName) {
        File srcJavaFile = new File(this.getJavaSourceDir(entity), String.format("/tables/%s.java", srcName));
        if (!srcJavaFile.exists()) {
            this.log.warn((Object)String.format("\u5b9e\u4f53%sJava\u6587\u4ef6\u4e0d\u5b58\u5728%s", entity.getId(), srcJavaFile.getName()));
            return;
        }
        try {
            JDTService server = JDTHandler.getServer();
            ICompilationUnit classUnit = server.getClassUnit(srcJavaFile.getAbsolutePath());
            server.renameClass(classUnit, destName);
        }
        catch (Exception exception) {
            this.log.warn((Object)String.format("\u5b9e\u4f53%sJava\u6587\u4ef6\u91cd\u547d\u540d\u3010%s -> %s\u3011\u5931\u8d25\uff0c\u5b58\u5728\u91cd\u540d\u76ee\u6807\u6587\u4ef6", entity.getId(), srcName, destName));
        }
        File srcBaseTableJavaFile = new File(this.getJavaSourceDir(entity), String.format("/tables/base/Base%s.java", srcName));
        if (!srcBaseTableJavaFile.exists()) {
            this.log.warn((Object)String.format("\u5b9e\u4f53%sBaseJava\u6587\u4ef6\u4e0d\u5b58\u5728%s", entity.getId(), srcBaseTableJavaFile.getName()));
            return;
        }
        try {
            JDTService server = JDTHandler.getServer();
            ICompilationUnit classUnit = server.getClassUnit(srcBaseTableJavaFile.getAbsolutePath());
            server.renameClass(classUnit, "Base" + destName);
        }
        catch (Exception exception) {
            this.log.warn((Object)String.format("Table\u3010%s\u3011Base Java\u6587\u4ef6\u91cd\u547d\u540d\u3010%s -> %s\u3011\u5931\u8d25\uff0c\u5b58\u5728\u91cd\u540d\u76ee\u6807\u6587\u4ef6", entity.getId(), srcName, destName));
        }
    }

    @Override
    protected void afterInnerNodeRename(GOTEntity entity, GOTNode node, String srcName, String destName) {
    }
}

