/*
 * Decompiled with CFR 0.152.
 */
package gongqi.gdt.designer.ui;

import gongqi.erp.gotmodel.core.EntityType;
import gongqi.gdt.designer.core.got.validate.ValidateResult;
import gongqi.gdt.designer.utils.SWTUtils;
import info.gongqi.got.util.ComposeIMG;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;

public class MergeMatchResultDialog {
    private Shell shell;
    private List<ValidateResult> results;
    private Tree tree;

    public MergeMatchResultDialog(List<ValidateResult> results) {
        this.results = results;
    }

    private void createContent() {
        Display display = Display.getCurrent();
        this.shell = new Shell(display.getActiveShell(), 208);
        this.shell.setText("\u8bca\u65ad\u4fe1\u606f");
        this.shell.setLayout((Layout)new FormLayout());
        this.shell.setSize(SWTUtils.zoom(800), SWTUtils.zoom(450));
        Rectangle bounds = Display.getDefault().getPrimaryMonitor().getBounds();
        Rectangle rect = this.shell.getBounds();
        int x = bounds.x + (bounds.width - rect.width) / 2;
        int y = bounds.y + (bounds.height - rect.height) / 2;
        this.shell.setLocation(x, y);
        SashForm mainComposite = new SashForm((Composite)this.shell, 256);
        FormData formData = new FormData();
        formData.left = new FormAttachment(0, 5);
        formData.right = new FormAttachment(100, -5);
        formData.bottom = new FormAttachment(100, -5);
        formData.top = new FormAttachment(0, 5);
        mainComposite.setLayoutData((Object)formData);
        mainComposite.setLayout((Layout)new FormLayout());
        this.tree = new Tree((Composite)mainComposite, 2050);
        TreeItem rootDatabase = new TreeItem(this.tree, 0);
        rootDatabase.setText("GOT");
        rootDatabase.setImage(ComposeIMG.drawImgDef("GOT"));
        final Table detailTable = new Table((Composite)mainComposite, 67588);
        detailTable.setHeaderVisible(true);
        detailTable.setLinesVisible(true);
        TableColumn descriptionColumn = new TableColumn(detailTable, 16384, 0);
        descriptionColumn.setText("\u63cf\u8ff0");
        descriptionColumn.setWidth(SWTUtils.zoom(470));
        Map<EntityType, List<ValidateResult>> types = this.results.stream().collect(Collectors.groupingBy(r -> r.getEntityType()));
        for (EntityType type : types.keySet()) {
            TreeItem typeItem = new TreeItem(rootDatabase, 0);
            typeItem.setText(type.name());
            if (EntityType.Class.equals((Object)type)) {
                typeItem.setImage(ComposeIMG.drawImgDef(String.valueOf(type.name()) + "es"));
            } else {
                typeItem.setImage(ComposeIMG.drawImgDef(String.valueOf(type.name()) + "s"));
            }
            List<ValidateResult> entitys = types.get(type);
            entitys.sort((e1, e2) -> e1.getEntityName().compareTo(e2.getEntityName()));
            for (ValidateResult result : entitys) {
                TreeItem entityItem = new TreeItem(typeItem, 0);
                entityItem.setText(result.getEntityName());
                entityItem.setImage(ComposeIMG.drawImgDef(result.getNodeType()));
                entityItem.setData(result.getResults());
            }
            typeItem.setExpanded(true);
        }
        rootDatabase.setExpanded(true);
        this.tree.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                detailTable.removeAll();
                TreeItem select = MergeMatchResultDialog.this.tree.getSelection()[0];
                List descriptions = (List)select.getData();
                if (descriptions == null) {
                    return;
                }
                for (String description : descriptions) {
                    TableItem rowItem = new TableItem(detailTable, 0);
                    rowItem.setText(description);
                }
            }
        });
        mainComposite.setWeights(new int[]{3, 5});
    }

    public void open() {
        this.createContent();
        this.shell.open();
        Display display = this.shell.getDisplay();
        while (!this.shell.isDisposed()) {
            if (display.readAndDispatch()) continue;
            display.sleep();
        }
    }
}

