/*
 * Decompiled with CFR 0.152.
 */
package info.gongqi.got.tool;

import gongqi.designer.got.vtd.EntityNode;
import gongqi.designer.services.LayerService;
import gongqi.erp.framework.core.ObjectContainer;
import gongqi.gdt.designer.utils.Images;
import info.gongqi.got.model.GotXmlDto;
import info.gongqi.got.tool.FormDataSyn;
import info.gongqi.got.util.GOTMessageDialog;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.dom4j.Element;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Dialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Monitor;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;

public class EnterNodeRef
extends Dialog {
    protected Object result;
    protected Shell shell;
    private Element xml;
    private Element currentXML;
    private Tree tree;
    private Tree curentTree;
    private Label info;
    private boolean flag;
    Shell tip = null;
    Label label = null;

    public EnterNodeRef(Shell parent, int style, Element element, boolean flags) {
        super(parent, style);
        this.setText("ref");
        this.xml = element;
        this.flag = flags;
    }

    public Object open() {
        this.createContents();
        this.shell.open();
        this.shell.layout();
        Display display = this.getParent().getDisplay();
        while (!this.shell.isDisposed()) {
            if (display.readAndDispatch()) continue;
            display.sleep();
        }
        return this.result;
    }

    private void createContents() {
        this.shell = new Shell(this.getParent(), this.getStyle());
        this.shell.setSize(500, 320);
        this.shell.setText("\u63d0\u793a");
        this.shell.setImage(Images.getIcon("EnumItem.png"));
        Monitor monitor = this.shell.getMonitor();
        Rectangle bounds = monitor.getBounds();
        Rectangle rect = this.shell.getBounds();
        int x = bounds.x + (bounds.width - rect.width) / 2;
        int y = bounds.y + (bounds.height - rect.height) / 2;
        this.shell.setLocation(x, y);
        this.shell.setLayout((Layout)new FormLayout());
        this.tree = new Tree((Composite)this.shell, 2624);
        this.curentTree = new Tree((Composite)this.shell, 2624);
        Display.getDefault().syncExec(new Runnable(){

            @Override
            public void run() {
                if (!EnterNodeRef.this.xml.getName().equals("tempRoot")) {
                    List elements = EnterNodeRef.this.xml.elements();
                    Collections.sort(elements, new Comparator<Element>(){

                        @Override
                        public int compare(Element o1, Element o2) {
                            if (o1.attributeValue("nodeType").compareToIgnoreCase(o2.attributeValue("nodeType")) == 0) {
                                return o1.attributeValue("name").compareToIgnoreCase(o2.attributeValue("name"));
                            }
                            return o1.attributeValue("nodeType").compareToIgnoreCase(o2.attributeValue("nodeType"));
                        }
                    });
                    EnterNodeRef.this.xml.setContent(elements);
                }
                EnterNodeRef.this.buildTree(EnterNodeRef.this.xml, EnterNodeRef.this.tree, null);
                if (EnterNodeRef.this.flag) {
                    EnterNodeRef.this.filterXML(EnterNodeRef.this.xml);
                    EnterNodeRef.this.buildTree(EnterNodeRef.this.currentXML, EnterNodeRef.this.curentTree, null);
                }
            }
        });
        FormData fd_table = new FormData();
        fd_table.top = new FormAttachment(0, 0);
        fd_table.bottom = new FormAttachment(100, -35);
        fd_table.left = new FormAttachment(0, 0);
        fd_table.right = new FormAttachment(100, 0);
        this.tree.setLayoutData((Object)fd_table);
        Button button = new Button((Composite)this.shell, 0x800000);
        button.setText("  \u786e\u5b9a  ");
        FormData fd_button = new FormData();
        fd_button.top = new FormAttachment((Control)this.tree, 2);
        fd_button.bottom = new FormAttachment(100, -2);
        fd_button.right = new FormAttachment(100, -2);
        button.setLayoutData((Object)fd_button);
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                EnterNodeRef.this.shell.close();
            }
        });
        if (this.flag) {
            this.curentTree.setLayoutData((Object)fd_table);
            this.curentTree.setVisible(false);
            this.curentTree.setVisible(true);
            final Button filter = new Button((Composite)this.shell, 0x800020);
            filter.setText("\u53ea\u663e\u793a\u5f53\u524d\u8303\u56f4");
            FormData fi_button = new FormData();
            fi_button.top = new FormAttachment((Control)this.tree, 2);
            fi_button.bottom = new FormAttachment(100, -2);
            fi_button.right = new FormAttachment((Control)button, -2);
            filter.setLayoutData((Object)fi_button);
            filter.addSelectionListener(new SelectionListener(){

                public void widgetSelected(SelectionEvent e) {
                    if (filter.getSelection()) {
                        EnterNodeRef.this.tree.setEnabled(false);
                        EnterNodeRef.this.tree.setVisible(false);
                        EnterNodeRef.this.curentTree.setEnabled(true);
                        EnterNodeRef.this.curentTree.setVisible(true);
                        String title = EnterNodeRef.this.getAttrChain(EnterNodeRef.this.currentXML, "relation");
                        EnterNodeRef.this.shell.setText(title);
                    } else {
                        EnterNodeRef.this.tree.setEnabled(true);
                        EnterNodeRef.this.tree.setVisible(true);
                        EnterNodeRef.this.curentTree.setEnabled(false);
                        EnterNodeRef.this.curentTree.setVisible(false);
                        String title = EnterNodeRef.this.getAttrChain(EnterNodeRef.this.xml, "relation");
                        EnterNodeRef.this.shell.setText(title);
                    }
                }

                public void widgetDefaultSelected(SelectionEvent e) {
                }
            });
        }
        this.info = new Label((Composite)this.shell, 0);
        FormData fd_info = new FormData();
        fd_info.top = new FormAttachment((Control)this.tree, 6);
        fd_info.bottom = new FormAttachment(100, -2);
        fd_info.left = new FormAttachment(0, 2);
        fd_info.right = new FormAttachment(60, -2);
        this.info.setLayoutData((Object)fd_info);
        if (this.flag) {
            this.tree.addListener(13, new Listener(){

                public void handleEvent(Event event) {
                    TreeItem trtmNewTreeitem = (TreeItem)event.item;
                    Element element = (Element)trtmNewTreeitem.getData();
                    String title = EnterNodeRef.this.getAttrChain(element, "relation");
                    EnterNodeRef.this.shell.setText(title);
                }
            });
            this.tree.addListener(8, new Listener(){

                public void handleEvent(Event event) {
                    int count = EnterNodeRef.this.tree.getSelectionCount();
                    TreeItem[] items = EnterNodeRef.this.tree.getSelection();
                    if (count != 0) {
                        TreeItem treeitem = items[0];
                        if (treeitem == null) {
                            event.doit = false;
                            return;
                        }
                        Element element = (Element)treeitem.getData();
                        FormDataSyn.refTreeItem(element);
                    }
                }
            });
            this.curentTree.addListener(13, new Listener(){

                public void handleEvent(Event event) {
                    TreeItem trtmNewTreeitem = (TreeItem)event.item;
                    Element element = (Element)trtmNewTreeitem.getData();
                    String title = EnterNodeRef.this.getAttrChain(element, "relation");
                    EnterNodeRef.this.shell.setText(title);
                }
            });
            this.curentTree.addListener(8, new Listener(){

                public void handleEvent(Event event) {
                    int count = EnterNodeRef.this.curentTree.getSelectionCount();
                    TreeItem[] items = EnterNodeRef.this.curentTree.getSelection();
                    if (count != 0) {
                        TreeItem treeitem = items[0];
                        if (treeitem == null) {
                            event.doit = false;
                            return;
                        }
                        Element element = (Element)treeitem.getData();
                        FormDataSyn.refTreeItem(element);
                    }
                }
            });
        } else {
            this.tree.addListener(13, new Listener(){

                public void handleEvent(Event event) {
                    TreeItem trtmNewTreeitem = (TreeItem)event.item;
                    if (trtmNewTreeitem != null && trtmNewTreeitem.getData("tip") != null) {
                        EnterNodeRef.this.info.setText((String)trtmNewTreeitem.getData("tip"));
                    }
                }
            });
            this.tree.addListener(5, new Listener(){

                public void handleEvent(Event event) {
                    if (EnterNodeRef.this.tip != null) {
                        EnterNodeRef.this.tip.dispose();
                        EnterNodeRef.this.tip = null;
                        EnterNodeRef.this.label = null;
                    }
                }
            });
            this.tree.addListener(32, new Listener(){

                public void handleEvent(Event event) {
                    TreeItem item = EnterNodeRef.this.tree.getItem(new Point(event.x, event.y));
                    if (item != null && item.getData("tip") != null) {
                        if (EnterNodeRef.this.tip != null && !EnterNodeRef.this.tip.isDisposed()) {
                            EnterNodeRef.this.tip.dispose();
                        }
                        EnterNodeRef.this.tip = new Shell(EnterNodeRef.this.shell, 540676);
                        EnterNodeRef.this.tip.setBackground(Display.getDefault().getSystemColor(29));
                        FillLayout layout = new FillLayout();
                        layout.marginWidth = 2;
                        EnterNodeRef.this.tip.setLayout((Layout)layout);
                        EnterNodeRef.this.label = new Label((Composite)EnterNodeRef.this.tip, 0);
                        EnterNodeRef.this.label.setForeground(Display.getDefault().getSystemColor(28));
                        EnterNodeRef.this.label.setBackground(Display.getDefault().getSystemColor(29));
                        EnterNodeRef.this.label.setData("tip", (Object)item);
                        EnterNodeRef.this.label.setText((String)item.getData("tip"));
                        Point size = EnterNodeRef.this.tip.computeSize(-1, -1);
                        Rectangle rect = item.getBounds(0);
                        Point pt = EnterNodeRef.this.tree.toDisplay(rect.x, rect.y);
                        EnterNodeRef.this.tip.setBounds(pt.x, pt.y, size.x, size.y);
                        EnterNodeRef.this.tip.setVisible(true);
                    }
                }
            });
        }
        GOTMessageDialog.shells.add(this.shell);
    }

    private void buildTree(Element elementTar, Tree treeParent, TreeItem parentItem) {
        if (elementTar.getName().equals("tempRoot")) {
            List elements = elementTar.elements();
            for (Element element : elements) {
                this.buildTree(element, treeParent, null);
            }
            return;
        }
        TreeItem trtmNewTreeitem = null;
        if (parentItem != null) {
            trtmNewTreeitem = new TreeItem(parentItem, 0);
            if (parentItem.getParentItem() == null) {
                parentItem.setExpanded(true);
            }
        } else {
            trtmNewTreeitem = new TreeItem(treeParent, 0);
            trtmNewTreeitem.setExpanded(true);
        }
        String text = "";
        if (this.flag) {
            text = this.extendsChainTreeLabelFunc(elementTar);
            trtmNewTreeitem.setData((Object)elementTar);
        } else {
            text = elementTar.getText().equals("") || elementTar.getText() == null ? elementTar.getName() : String.valueOf(elementTar.getName()) + " --> " + elementTar.getText();
        }
        if (StringUtils.isNotBlank((String)elementTar.attributeValue("tip"))) {
            trtmNewTreeitem.setData("tip", (Object)elementTar.attributeValue("tip"));
            trtmNewTreeitem.setForeground(trtmNewTreeitem.getDisplay().getSystemColor(3));
        }
        trtmNewTreeitem.setText(text);
        if (this.flag) {
            trtmNewTreeitem.setImage(this.extendsChainTreeIconFunc(elementTar));
        }
        List elements = elementTar.elements();
        for (Element element : elements) {
            this.buildTree(element, null, trtmNewTreeitem);
        }
    }

    private void filterXML(Element elementTar) {
        this.currentXML = (Element)elementTar.clone();
        List elements = this.currentXML.elements();
        String currentLayer = ((LayerService)ObjectContainer.getInstance(LayerService.class)).getCurrentLayer();
        for (Element elementChild : elements) {
            String modifiedLayer;
            String entityId = elementChild.attributeValue("entityId");
            EntityNode entityNode = GotXmlDto.getInstance().getEntityById(entityId);
            if (entityNode != null && (modifiedLayer = entityNode.getAttributeValue("modifiedLayer")).equals(currentLayer)) continue;
            this.currentXML.remove(elementChild);
        }
    }

    private String extendsChainTreeLabelFunc(Element item) {
        String _nodeType;
        String label = item.attributeValue("name");
        if (item.attribute("relation") != null) {
            label = String.valueOf(label) + " --> [" + item.attributeValue("relation") + "]";
        }
        if (item.attribute("nodeType") != null && (_nodeType = item.attributeValue("nodeType")) != null) {
            label = "[" + _nodeType + "]   " + label;
        }
        return label;
    }

    public String getAttrChain(Element node, String ... args) {
        if (node == null) {
            return "";
        }
        String entityId = node.attributeValue("entityId");
        String innerId = node.attributeValue("innerId");
        String str = "entityId:" + entityId + ",innerId:" + innerId;
        HashMap<String, Integer> type = new HashMap<String, Integer>();
        this.typeMap(node, type);
        String msg = "";
        for (String key : type.keySet()) {
            msg = String.valueOf(msg) + key + "[" + type.get(key) + "] ";
        }
        this.info.setText(msg);
        return str;
    }

    private void typeMap(Element node, Map<String, Integer> type) {
        List elements = node.elements();
        for (Element element : elements) {
            String nodeType = element.attributeValue("nodeType");
            if (type.containsKey(nodeType)) {
                int num = type.get(nodeType);
                type.put(nodeType, ++num);
            } else {
                type.put(nodeType, 1);
            }
            this.typeMap(element, type);
        }
    }

    private Image extendsChainTreeIconFunc(Element item) {
        String nodeName = item.attributeValue("nodeType");
        String iconClassName = nodeName;
        Image image = Images.getIcon(String.valueOf(iconClassName) + ".png");
        if (image == null) {
            image = Images.getIcon("Default.png");
        }
        return image;
    }
}

