/*
 * Decompiled with CFR 0.152.
 */
package info.gongqi.got.tool;

import info.gongqi.got.tool.FormDataSyn;
import info.gongqi.got.util.GOTMessageDialog;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Dialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Monitor;
import org.eclipse.swt.widgets.ProgressBar;
import org.eclipse.swt.widgets.Shell;

public class ProgressBarExchangeLayer
extends Dialog {
    protected Object resultDialog = "";
    public Shell shell;
    public ProgressBar progressBar;
    public static ProgressBarExchangeLayer barExchangeLayer;

    public ProgressBarExchangeLayer(Shell parent, int style) {
        super(parent, style);
        this.setText("\u6b63\u5728\u5904\u7406...");
        if (barExchangeLayer == null) {
            barExchangeLayer = this;
        }
    }

    public Object open() {
        this.createContents();
        this.shell.open();
        this.shell.layout();
        Display display = this.getParent().getDisplay();
        while (!this.shell.isDisposed()) {
            if (display.readAndDispatch()) continue;
            display.sleep();
        }
        return this.resultDialog;
    }

    private void createContents() {
        this.shell = new Shell(this.getParent(), this.getStyle());
        this.shell.setSize(600, 50);
        this.shell.setText(this.getText());
        this.shell.setLayout((Layout)new FillLayout(256));
        GOTMessageDialog.shell.setEnabled(false);
        Monitor monitor = this.shell.getMonitor();
        Rectangle bounds = monitor.getBounds();
        Rectangle rect = this.shell.getBounds();
        int x = bounds.x + (bounds.width - rect.width) / 2;
        int y = bounds.y + (bounds.height - rect.height) / 2;
        this.shell.setLocation(x, y);
        this.progressBar = new ProgressBar((Composite)this.shell, 258);
        this.shell.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent arg0) {
                barExchangeLayer = null;
                GOTMessageDialog.shell.setEnabled(true);
            }
        });
        Thread thread = new Thread(new Runnable(){

            @Override
            public void run() {
                Display.getDefault().asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        FormDataSyn.setShowTreeItemByLayerAndSolution();
                    }
                });
            }
        });
        thread.start();
    }

    public void setProgressBar(final int num) {
        Display.getDefault().syncExec(new Runnable(){

            @Override
            public void run() {
                if (ProgressBarExchangeLayer.this.progressBar.isDisposed()) {
                    return;
                }
                ProgressBarExchangeLayer.this.progressBar.setSelection(num);
            }
        });
    }

    public void setShellText(final String text) {
        Display.getDefault().syncExec(new Runnable(){

            @Override
            public void run() {
                if (ProgressBarExchangeLayer.this.shell.isDisposed()) {
                    return;
                }
                ProgressBarExchangeLayer.this.shell.setText(text);
            }
        });
    }

    public void setAlert(final String text, final String title) {
        Display.getDefault().syncExec(new Runnable(){

            @Override
            public void run() {
                GOTMessageDialog.showXmlInfo(text, title);
            }
        });
    }
}

