/*
 * Decompiled with CFR 0.152.
 */
package info.gongqi.got.tool;

import info.gongqi.got.ui.event.MouseRightMenuEvent;
import info.gongqi.got.util.GOTMessageDialog;
import org.apache.log4j.Logger;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Dialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Monitor;
import org.eclipse.swt.widgets.ProgressBar;
import org.eclipse.swt.widgets.Shell;

public class ProgressBarUtil
extends Dialog {
    protected Object resultDialog = "";
    public Shell shell;
    public ProgressBar progressBar;
    MouseRightMenuEvent event;

    public ProgressBarUtil(Shell parent, int style, MouseRightMenuEvent e) {
        super(parent, style);
        this.event = e;
        this.setText("\u6b63\u5728\u5904\u7406");
    }

    public Object open() {
        this.createContents();
        this.shell.open();
        this.shell.layout();
        Display display = this.getParent().getDisplay();
        while (!this.shell.isDisposed()) {
            if (display.readAndDispatch()) continue;
            display.sleep();
        }
        return this.resultDialog;
    }

    private void createContents() {
        this.shell = new Shell(this.getParent(), this.getStyle());
        this.shell.setSize(600, 50);
        this.shell.setText(this.getText());
        this.shell.setLayout((Layout)new FillLayout(256));
        GOTMessageDialog.shell.setEnabled(false);
        Monitor monitor = this.shell.getMonitor();
        Rectangle bounds = monitor.getBounds();
        Rectangle rect = this.shell.getBounds();
        int x = bounds.x + (bounds.width - rect.width) / 2;
        int y = bounds.y + (bounds.height - rect.height) / 2;
        this.shell.setLocation(x, y);
        this.progressBar = new ProgressBar((Composite)this.shell, 258);
        this.shell.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent arg0) {
                GOTMessageDialog.shell.setEnabled(true);
            }
        });
        Thread thread = new Thread(new Runnable(){

            @Override
            public void run() {
                Display.getDefault().syncExec(new Runnable(){

                    @Override
                    public void run() {
                        try {
                            (this).ProgressBarUtil.this.event.doSyncNodes();
                        }
                        catch (Throwable e) {
                            Logger.getLogger(this.getClass()).error((Object)"\u540c\u6b65\u9519\u8bef", e);
                            MessageDialog.openError((Shell)(this).ProgressBarUtil.this.shell, (String)"\u63d0\u793a", (String)String.format("\u540c\u6b65\u5931\u8d25\uff1a%s", e.getMessage()));
                        }
                    }
                });
            }
        });
        thread.start();
    }

    public void setProgressBar(final int num) {
        Display.getDefault().asyncExec(new Runnable(){

            @Override
            public void run() {
                if (ProgressBarUtil.this.progressBar.isDisposed()) {
                    return;
                }
                ProgressBarUtil.this.progressBar.setSelection(num);
            }
        });
    }

    public void setShellText(final String text) {
        Display.getDefault().syncExec(new Runnable(){

            @Override
            public void run() {
                if (ProgressBarUtil.this.shell.isDisposed()) {
                    return;
                }
                ProgressBarUtil.this.shell.setText(text);
            }
        });
    }

    public void setAlert(final String text, final String title) {
        Display.getDefault().syncExec(new Runnable(){

            @Override
            public void run() {
                GOTMessageDialog.showXmlInfo(text, title);
            }
        });
    }
}

