/*
 * Decompiled with CFR 0.152.
 */
package info.gongqi.got.ui;

import gongqi.designer.core.DesignerServer;
import gongqi.designer.got.RefErrorItemVO;
import gongqi.designer.services.DatabaseService;
import gongqi.designer.services.GOTService;
import gongqi.erp.framework.core.ObjectContainer;
import gongqi.gdt.designer.ProjectConstants;
import gongqi.gdt.designer.core.got.node.NodeGOT;
import gongqi.gdt.designer.core.resolvergot.ResolverUi;
import gongqi.gdt.designer.core.toolsgot.GOTXMLHelper;
import info.gongqi.got.model.GotXmlDto;
import info.gongqi.got.tool.FormDataSyn;
import info.gongqi.got.ui.ConfigComposite;
import info.gongqi.got.ui.TreeUi;
import info.gongqi.got.util.GOTMessageDialog;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;
import org.dom4j.Element;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.Tree;

public class LoadXmlCore {
    private static Logger log = Logger.getLogger(LoadXmlCore.class);
    public static GOTService gotServices;
    public static DatabaseService databaseServices;
    public static List<Map<String, Object>> softDataRef;
    public static List<Map<String, Object>> softDataDB;
    public static Map<String, Object> softDataDuplicate;
    public static boolean softModel;
    public static Map<String, Map<String, String>> gotMap;

    static {
        softModel = false;
        gotMap = new HashMap<String, Map<String, String>>();
    }

    public static void init(final Tree tree, final Table table) {
        if (DesignerServer.getState() != DesignerServer.State.STARTED) {
            try {
                DesignerServer.start((File)ProjectConstants.getBasePath());
                gotServices = (GOTService)ObjectContainer.getInstance(GOTService.class);
                databaseServices = (DatabaseService)ObjectContainer.getInstance(DatabaseService.class);
                ConfigComposite.progressBar.setProgressBar(20);
                Display.getDefault().syncExec(new Runnable(){

                    @Override
                    public void run() {
                        boolean result = GOTMessageDialog.ChoseUser();
                        if (result) {
                            LoadXmlCore.load();
                            tree.setBackgroundImage(null);
                            Element e = null;
                            TreeUi treeUi = new TreeUi(tree, table, e);
                            FormDataSyn.treeUis.add(treeUi);
                            LoadXmlCore.softModel();
                            ConfigComposite.text_static_info();
                        } else {
                            Display.getDefault().syncExec(new Runnable(){

                                @Override
                                public void run() {
                                    ConfigComposite.progressBar.setShellText("\u52a0\u8f7d\u914d\u7f6e\u9519\u8bef");
                                    ConfigComposite.progressBar.setProgressBar(100);
                                    ConfigComposite.configComposite.init();
                                    ConfigComposite.configComposite.button_restart.setEnabled(true);
                                }
                            });
                        }
                    }
                });
            }
            catch (Throwable e) {
                log.error((Object)"Designer\u521d\u59cb\u5316\u9519\u8bef", e);
                Display.getDefault().syncExec(new Runnable(){

                    @Override
                    public void run() {
                        ConfigComposite.progressBar.setShellText("\u52a0\u8f7d\u914d\u7f6e\u9519\u8bef");
                        ConfigComposite.progressBar.setProgressBar(100);
                        ConfigComposite.configComposite.init();
                        ConfigComposite.configComposite.button_restart.setEnabled(true);
                    }
                });
                Display.getDefault().syncExec(new Runnable(){

                    @Override
                    public void run() {
                        GOTMessageDialog.alert("Designer\u521d\u59cb\u5316\u9519\u8bef" + e.getMessage());
                    }
                });
                return;
            }
        }
    }

    public static void load() {
        Display.getDefault().syncExec(new Runnable(){

            @Override
            public void run() {
                ConfigComposite.progressBar.setShellText("\u6b63\u5728\u52a0\u8f7dGOT");
                ConfigComposite.progressBar.setProgressBar(30);
            }
        });
        GotXmlDto.getInstance().init();
        ResolverUi.init();
        GOTXMLHelper.init();
        softDataRef = new ArrayList<Map<String, Object>>();
        softDataDB = new ArrayList<Map<String, Object>>();
        softDataDuplicate = new HashMap<String, Object>();
        NodeGOT.gridRightMenuData = GOTXMLHelper.createElementByXMLString(NodeGOT.gridRightMenuDataString);
    }

    public static void softModel() {
        try {
            if (gotServices.isSafeMode()) {
                Map duplicateId;
                List db;
                log.info((Object)"\u8fdb\u5165\u5b89\u5168\u6a21\u5f0f");
                Map map = (Map)gotServices.getErrors();
                List ref = (List)map.get("ref");
                if (!ref.isEmpty()) {
                    for (RefErrorItemVO mapNode : ref) {
                        softDataRef.add(LoadXmlCore.javaBeanMap(mapNode));
                    }
                }
                if (!(db = (List)map.get("db")).isEmpty()) {
                    softDataDB.addAll(db);
                }
                if (!(duplicateId = (Map)map.get("duplicateId")).isEmpty()) {
                    softDataDuplicate = duplicateId;
                }
                Display.getDefault().syncExec(new Runnable(){

                    @Override
                    public void run() {
                        int softDataSize = softDataRef.size() + softDataDB.size() + softDataDuplicate.size();
                        ConfigComposite.label_soft.setText("\u5f02\u5e38\u6570\u91cf:" + softDataSize);
                        ConfigComposite.label_soft.setVisible(true);
                    }
                });
                String xml = "<menuitem label='\u4fee\u6539\u7ee7\u627f\u5173\u7cfb' func='modifyExtends'/>";
                Element addele = GOTXMLHelper.createElementByXMLString(xml);
                NodeGOT.gridRightMenuData.add(addele.detach());
                softModel = true;
            }
            Display.getDefault().syncExec(new Runnable(){

                @Override
                public void run() {
                    FormDataSyn.treeUis.get(0).afterInit();
                    if (softDataRef != null && !softDataRef.isEmpty() || softDataDB != null && !softDataDB.isEmpty() || softDataDuplicate != null && !softDataDuplicate.isEmpty()) {
                        GOTMessageDialog.showsoftView(softDataRef, softDataDB, softDataDuplicate);
                    }
                }
            });
        }
        catch (Exception e) {
            Logger.getLogger(LoadXmlCore.class).error((Object)"", (Throwable)e);
            GOTMessageDialog.alert(e);
        }
    }

    public static Map<String, Object> javaBeanMap(RefErrorItemVO javaBean) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        if (javaBean.getEntityId() != null) {
            map.put("entityId", javaBean.getEntityId());
        }
        if (javaBean.getErrorInfo() != null) {
            map.put("errorInfo", javaBean.getErrorInfo());
        }
        if (javaBean.getInnerId() != null) {
            map.put("innerId", javaBean.getInnerId());
        }
        if (javaBean.getNodeType() != null) {
            map.put("nodeType", javaBean.getNodeType());
        }
        if (javaBean.getPropertyName() != null) {
            map.put("propertyName", javaBean.getPropertyName());
        }
        if (javaBean.getEntityName() != null) {
            map.put("EntityName", javaBean.getEntityName());
        }
        if (javaBean.getInnerName() != null) {
            map.put("InnerName", javaBean.getInnerName());
        }
        if (javaBean.getEntityType() != null) {
            map.put("EntityType", javaBean.getEntityType());
        }
        return map;
    }
}

