/*
 * Decompiled with CFR 0.152.
 */
package gongqi.gdt.designer.core.got.node.table;

import com.alibaba.fastjson.JSONObject;
import gongqi.designer.got.vtd.EntityNode;
import gongqi.designer.got.vtd.GOTNode;
import gongqi.designer.services.LayerService;
import gongqi.designer.utils.Dom4jUtils;
import gongqi.erp.framework.core.ObjectContainer;
import gongqi.erp.gotmodel.core.EntityType;
import gongqi.erp.gotmodel.datatype.GongqiDataType;
import gongqi.gdt.designer.core.event.ValidationResultEvent;
import gongqi.gdt.designer.core.got.node.Inner;
import gongqi.gdt.designer.core.got.node.NodeFactory;
import gongqi.gdt.designer.core.got.node.NodeGOT;
import gongqi.gdt.designer.core.got.node.NodeNameInvalidException;
import gongqi.gdt.designer.core.toolsgot.GOTHelper;
import gongqi.gdt.designer.core.toolsgot.GOTXMLHelper;
import gongqi.gdt.designer.core.toolsgot.Macros;
import info.gongqi.got.model.GotXmlDto;
import info.gongqi.got.tool.FormDataSyn;
import info.gongqi.got.tool.GOTHelp;
import info.gongqi.got.ui.event.MouseRightMenuEvent;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.dom4j.Attribute;
import org.dom4j.Element;
import org.eclipse.swt.widgets.TreeItem;

public class TableField
extends Inner {
    @Override
    protected void addRelation(Element property) {
        super.addRelation(property);
    }

    @Override
    public ValidationResultEvent validateProperty(Element property) {
        String propertyName;
        Element tableFieldElement = property.getParent().getParent();
        if (StringUtils.isBlank((String)GOTHelper.getPropertyValue(tableFieldElement, "Extends")) && ("StringSize".equals(propertyName = property.elementText("Name")) || "DisplayLength".equals(propertyName) || "NumOfDecimals".equals(propertyName) || "DisplayDecimals".equals(propertyName))) {
            String propertyValue = property.elementText("Value");
            ValidationResultEvent resultEvent = ValidationResultEvent.validateNonBlank(propertyValue);
            if (resultEvent.results != null) {
                return resultEvent;
            }
            resultEvent = ValidationResultEvent.unNegativeInteger(propertyValue);
            if (resultEvent.results != null) {
                return resultEvent;
            }
            long value = Long.parseLong(propertyValue);
            if ("StringSize".equals(propertyName) && value <= 0L) {
                return ValidationResultEvent.newValidationResultEvent("\u503c\u5fc5\u987b\u5927\u4e8e0");
            }
            if ("StringSize".equals(propertyName) && value > 4000L) {
                return ValidationResultEvent.newValidationResultEvent("\u503c\u4e0d\u80fd\u5927\u4e8e4000");
            }
        }
        return super.validateProperty(property);
    }

    @Override
    public void doAfterPropertyModified(Element property, String ... args) {
        if (property.elementText("Name").equals("Source")) {
            List<Element> extendsPro = GOTHelp.getPPAttElementList(this.xml, "Name", "Extends");
            extendsPro.get(0).element("Value").setText("");
            this.doAfterPropertyModified(extendsPro.get(0), new String[0]);
            return;
        }
        String extendName = property.elementText("Value");
        if (property.elementText("Name").equals("Extends")) {
            EntityNode extendNode;
            if (this.resolverNode.getInfoValue("Type").equals("Enum")) {
                if (extendName.equals("")) {
                    ArrayList attributes = new ArrayList();
                    attributes.addAll(property.attributes());
                    for (Attribute attribute : attributes) {
                        property.remove(attribute);
                    }
                } else {
                    EntityNode extendNode2;
                    String source = GOTHelp.getPPAttValue(this.xml, "Name", "Source");
                    if (source.equals("Enum")) {
                        extendNode2 = GotXmlDto.getInstance().getEntityByName(EntityType.Enum, extendName);
                        property.addAttribute("refentityid", extendNode2.getId());
                    } else if (source.equals("DataType")) {
                        extendNode2 = GotXmlDto.getInstance().getEntityByName(EntityType.DataType, extendName);
                        property.addAttribute("refentityid", extendNode2.getId());
                    }
                }
            }
            if (GongqiDataType.TypeDecimal.getValue().equals(this.resolverNode.getInfoValue("Type")) && (extendNode = GotXmlDto.getInstance().getEntityByName(EntityType.DataType, extendName)) != null && "DataType".equals(extendNode.getNodeType()) && "SysLineNum".equals(extendNode.getName())) {
                Element tableFieldElement = property.getParent().getParent();
                Element tableEntity = TableField.getEntity(property);
                Element indexes = tableEntity.element("TableIndexes");
                TreeItem treeItem = FormDataSyn.getTreeItrmByElement(indexes, null);
                String lineNumIndexName = "SysLineNumIdx";
                Element linNumIndexElement = (Element)tableEntity.selectSingleNode(String.format("./TableIndexes/TableIndex[@name='%s']", lineNumIndexName));
                if (linNumIndexElement == null) {
                    String layerName = tableFieldElement.attributeValue("modifiedLayer");
                    long nextInnerId = Long.parseLong(tableEntity.attributeValue("nextInnerId"));
                    String tableIndexTemplate = "<TableIndex name=\"\" id=\"\" createdLayer=\"\" modifiedLayer=\"\"><Properties><Property><Name>Unique</Name><Value>false</Value></Property></Properties><TableIndexItem name=\"\" id=\"\" createdLayer=\"\" modifiedLayer=\"\"><Properties><Property innerid=\"\"><Name>Field</Name><Value/></Property><Property><Name>ArrayItem</Name><Value/></Property><Property><Name>SortOrder</Name><Value>ASC</Value></Property></Properties></TableIndexItem></TableIndex>";
                    Element tableIndexElement = Dom4jUtils.parserElement((String)tableIndexTemplate);
                    tableIndexElement.addAttribute("id", Long.toString(nextInnerId++));
                    tableIndexElement.addAttribute("name", lineNumIndexName);
                    tableIndexElement.addAttribute("createdLayer", layerName);
                    tableIndexElement.addAttribute("modifiedLayer", layerName);
                    Element tableIndexItemElement = tableIndexElement.element("TableIndexItem");
                    tableIndexItemElement.addAttribute("id", Long.toString(nextInnerId++));
                    tableIndexItemElement.addAttribute("name", tableFieldElement.attributeValue("name"));
                    tableIndexItemElement.addAttribute("createdLayer", layerName);
                    tableIndexItemElement.addAttribute("modifiedLayer", layerName);
                    Element fieldProperty = GOTHelp.getProperty(tableIndexItemElement, "Field");
                    fieldProperty.addAttribute("innerid", tableFieldElement.attributeValue("id"));
                    fieldProperty.element("Value").setText(tableFieldElement.attributeValue("name"));
                    tableEntity.element("TableIndexes").add(tableIndexElement.createCopy());
                    tableEntity.addAttribute("nextInnerId", Long.toString(nextInnerId));
                    if (treeItem != null) {
                        FormDataSyn.restore2(treeItem, indexes);
                    }
                }
            }
        }
        super.doAfterPropertyModified(property, args);
    }

    @Override
    protected String getPropertyStrict(String propertyName) {
        String _type = this.xml.attributeValue("type");
        if (_type.equals("Long") && propertyName.equals("Default")) {
            return "0-9";
        }
        if (_type.equals("Decimal") && propertyName.equals("Default")) {
            return ".0-9";
        }
        return null;
    }

    @Override
    public List<String> getPropertyItemEditorArray(String propertyName, String fixedRuglar, GOTNode baseXML) {
        if (this.xml.attributeValue("type").equals("Enum") && propertyName.equals("Extends")) {
            if (GOTHelp.getPPAttValue(this.xml, "Name", "Source").equals("Enum")) {
                return super.getPropertyItemEditorArray(propertyName, "Enums", null);
            }
            return super.getPropertyItemEditorArray(propertyName, "DataType[@type='Enum']", null);
        }
        if (propertyName.equals("Default") && this.xml.attributeValue("type").equals("Enum")) {
            List<String> result = GOTHelper.getDataSourceByTableField(this.xml);
            ArrayList<String> ar = new ArrayList<String>();
            for (String item : result) {
                JSONObject jsonObject = JSONObject.parseObject((String)item);
                ar.add(jsonObject.getString("label"));
            }
            return ar.size() != 0 ? ar : super.getPropertyItemEditorArray(propertyName, "", null);
        }
        if (propertyName.equals("Default") && this.xml.attributeValue("type").equals("Boolean")) {
            ArrayList<String> lists = new ArrayList<String>();
            lists.add("true");
            lists.add("false");
            return lists;
        }
        return super.getPropertyItemEditorArray(propertyName, "", null);
    }

    @Override
    public Boolean isSibling(Element srcItem) {
        if (srcItem.getParent() == null) {
            return false;
        }
        if (srcItem.getParent().asXML().equals(this.xml.getParent().asXML()) && srcItem.getName().equals(this.xml.getName())) {
            return true;
        }
        return false;
    }

    @Override
    public NodeGOT getAccpDragNewNode(Element src) {
        if (src.getName().equals("Enum")) {
            NodeGOT node = super.doAccpDragNew("TableField", "Enum");
            this.doAccpDragNewAfer(src, node.xml);
            return node;
        }
        if (src.getName().equals("DataType")) {
            NodeGOT node = super.doAccpDragNew("TableField", src.attributeValue("type"));
            this.doAccpDragNewAfer(src, node.xml);
            return node;
        }
        if (src.getName().equals("TableField")) {
            Element srcTableField = src.createCopy();
            String lay = ((LayerService)ObjectContainer.getInstance(LayerService.class)).getCurrentLayer();
            srcTableField.addAttribute("createdLayer", lay);
            srcTableField.addAttribute("modifiedLayer", lay);
            List elements = srcTableField.selectNodes(".//Property[@innerid]");
            for (Element element : elements) {
                element.remove(element.attribute("innerid"));
            }
            GOTXMLHelper.setProperty(srcTableField, "FilterField", "", true);
            NodeGOT node = NodeFactory.getNode(srcTableField);
            return node;
        }
        return null;
    }

    @Override
    public String getAccpDragNewInsertBase() {
        return "parent";
    }

    private void doAccpDragNewAfer(Element src, Element node) {
        String extendName = src.attributeValue("name");
        GOTXMLHelper.setProperty(node, "Extends", extendName, true);
        if (extendName.contains(".")) {
            String[] name = extendName.split("\\.");
            extendName = name[name.length - 1];
        }
        node.addAttribute("name", extendName);
        if (node.attributeValue("type").equals("Enum")) {
            if (src.getName().equals("Enum")) {
                GOTXMLHelper.setProperty(node, "Source", "Enum", true);
            } else {
                GOTXMLHelper.setProperty(node, "Source", "DataType", true);
            }
        } else if (node.attributeValue("type").equals("Component")) {
            node.addAttribute("editOnCreate", "true");
        }
    }

    @Override
    public Element getInsertChildBefore(Element parent) {
        if (parent.getName().equals("TableField")) {
            return parent;
        }
        Element entityTable = parent.getParent();
        String isDTBExist = GOTHelp.getPPAttValue(entityTable, "Name", "RecordCM");
        if ("None".equals(isDTBExist)) {
            return null;
        }
        String isSessionExist = "false";
        if ("DateTimeBy".equals(isDTBExist)) {
            isSessionExist = "false";
            isDTBExist = "true";
        } else if ("Session".equals(isDTBExist)) {
            isSessionExist = "true";
            isDTBExist = "false";
        } else {
            isSessionExist = "true";
            isDTBExist = "true";
        }
        if (isDTBExist.equals("true") && isSessionExist.equals("true")) {
            List elements = parent.selectNodes("/TableField[@name='CreatedSessionId']");
            if (elements.isEmpty()) {
                return null;
            }
            return (Element)elements.get(0);
        }
        if (isDTBExist.equals("true")) {
            List elList = parent.selectNodes("TableField[@name='CreatedDate']");
            if (elList.isEmpty()) {
                return null;
            }
            return (Element)elList.get(0);
        }
        if (isSessionExist.equals("true")) {
            List elList = parent.selectNodes("/TableField[@name='CreatedSessionId']");
            if (elList.isEmpty()) {
                return null;
            }
            return (Element)elList.get(0);
        }
        List elList = parent.selectNodes("/TableField[@name='RecVersion']");
        if (elList.isEmpty()) {
            return null;
        }
        return (Element)elList.get(0);
    }

    @Override
    public void doAfterDragDroped() {
        this.doAfterPropertyModified(GOTHelp.getPPAttElement(this.xml, "Name", "Extends"), new String[0]);
    }

    @Override
    public String allowPropertyEdit(String propertyName) {
        Element extendsPro;
        if (propertyName.equals("NotNull") && this.resolverNode.getInfoValue("Type").equals("Component")) {
            return Macros.INFO_FALSE;
        }
        if (propertyName.equals("Extends") && this.xml.attributeValue("type").equals("Component")) {
            if (this.xml.attribute("editOnCreate") != null) {
                return Macros.INFO_TRUE;
            }
            return Macros.INFO_FALSE;
        }
        if (("NumOfDecimals".equals(propertyName) || "StringSize".equals(propertyName) || "ChangeCase".equals(propertyName) || "Trim".equals(propertyName)) && StringUtils.isNotBlank((String)(extendsPro = GOTHelper.getProperty(this.xml, "Extends")).attributeValue("refentityid"))) {
            return Macros.INFO_FALSE;
        }
        return super.allowPropertyEdit(propertyName);
    }

    @Override
    public String allowEdit() {
        String superresult = super.allowEdit();
        if (!superresult.equals("true")) {
            String lay = ((LayerService)ObjectContainer.getInstance(LayerService.class)).getCurrentLayer();
            if (this.xml.attribute("createdLayer") != null && !this.xml.attributeValue("createdLayer").equals(lay)) {
                superresult = "\u8be5\u8282\u70b9\u4e0d\u5c5e\u4e8e\u5f53\u524d\u5c42,\u4e0d\u5141\u8bb8\u7f16\u8f91";
            }
        }
        return superresult;
    }

    @Override
    protected Boolean isIfExtendsRelated(String proName) {
        if (proName != null && proName.equals("Extends")) {
            return true;
        }
        return false;
    }

    @Override
    public Boolean editOnCreate() {
        if (this.xml.attributeValue("type").equals("Component")) {
            return true;
        }
        return false;
    }

    @Override
    public Boolean validateNewName(String newName) {
        String _type;
        String key = NodeGOT.getEntity(this.xml).attributeValue("id");
        List<String> nv = MouseRightMenuEvent.deletedNodesCache.get(key);
        if (nv != null) {
            for (String n : nv) {
                if (!n.equals(newName)) continue;
                return false;
            }
        }
        if ((_type = this.xml.attributeValue("type")).equals("Date") && newName.indexOf("Time") != -1) {
            return false;
        }
        if (KeyWords.contains(newName.toLowerCase())) {
            throw new NodeNameInvalidException(String.format("\u65e0\u6548\u7684\u8282\u70b9\u540d\u79f0\uff1a%s\u5c5e\u4e8e\u5173\u952e\u5b57", newName));
        }
        return super.validateNewName(newName);
    }

    @Override
    protected void doPropertyTrigger(Element property) {
        String oldName = this.xml.attributeValue("name");
        super.doPropertyTrigger(property);
        String newName = this.xml.attributeValue("name");
        if (!oldName.equals(newName)) {
            this.updateRelationNameInEntity();
            Element entity = TableField.getEntity(this.xml);
            Element indexes = entity.element("TableIndexes");
            List selectNodes = indexes.selectNodes(String.format("./TableIndex/TableIndexItem/Properties/Property[@innerid='%s']", this.xml.attributeValue("id")));
            if (!selectNodes.isEmpty()) {
                TreeItem treeItem = FormDataSyn.getTreeItrmByElement(indexes, null);
                FormDataSyn.restore2(treeItem, indexes);
            }
        }
    }
}

