/*
 * Decompiled with CFR 0.152.
 */
package gongqi.gdt.designer.core.got.validate;

import com.ximpleware.VTDException;
import gongqi.designer.got.vtd.EntityNode;
import gongqi.designer.got.vtd.GOTNode;
import gongqi.designer.got.vtd.NodeProperty;
import gongqi.designer.utils.GOTHelper;
import gongqi.erp.gotmodel.core.EntityType;
import gongqi.gdt.designer.core.got.node.NodeGOT;
import gongqi.gdt.designer.core.got.validate.EntityValidateService;
import gongqi.gdt.designer.core.toolsgot.GOTXMLHelper;
import gongqi.gdt.designer.core.toolsgot.Macros;
import gongqi.gdt.designer.service.node.GOTEntity;
import info.gongqi.got.model.GotXmlDto;
import info.gongqi.got.tool.FormDataSyn;
import info.gongqi.got.tool.GOTHelp;
import info.gongqi.got.tool.LayerInfo;
import info.gongqi.got.tool.LayerInfoSoultion;
import info.gongqi.got.tool.MergeCleanAllTable;
import info.gongqi.got.tool.MergeMatchingTips;
import info.gongqi.got.tool.MergeSaveAll;
import info.gongqi.got.tool.TreeOperationInfo;
import info.gongqi.got.ui.ConfigComposite;
import info.gongqi.got.ui.LoadXmlCore;
import info.gongqi.got.util.GOTMessageDialog;
import info.gongqi.got.util.TreeUIUtil;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.dom4j.Element;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;

public class DoMerge {
    private static List<GOTEntity> getSelectEntitys() {
        ArrayList<GOTEntity> entityNodes = new ArrayList<GOTEntity>();
        if (FormDataSyn.treeUis.isEmpty()) {
            return entityNodes;
        }
        if (FormDataSyn.currentTreeUi == null) {
            return entityNodes;
        }
        Tree tree = FormDataSyn.currentTreeUi.getTree();
        TreeItem[] items = tree.getSelection();
        if (items.length <= 0) {
            return entityNodes;
        }
        TreeItem[] treeItemArray = items;
        int n = items.length;
        int n2 = 0;
        while (n2 < n) {
            TreeItem select = treeItemArray[n2];
            String elementEntityId = (String)select.getData("elementEntityId");
            if (StringUtils.isBlank((String)elementEntityId)) {
                String nodeName = select.getText();
                if (TreeUIUtil.isUINode(nodeName)) {
                    if (nodeName.equals("Enums") || nodeName.equals("GOT")) {
                        entityNodes.addAll(GotXmlDto.getInstance().getGOTEntityList(EntityType.Enum));
                    }
                    if (nodeName.equals("Tables") || nodeName.equals("GOT")) {
                        entityNodes.addAll(GotXmlDto.getInstance().getGOTEntityList(EntityType.Table));
                    }
                    if (nodeName.equals("DataTypes") || nodeName.equals("GOT")) {
                        entityNodes.addAll(GotXmlDto.getInstance().getGOTEntityList(EntityType.DataType));
                    }
                    if (nodeName.equals("Menus") || nodeName.equals("GOT")) {
                        entityNodes.addAll(GotXmlDto.getInstance().getGOTEntityList(EntityType.Menu));
                    }
                    if (nodeName.equals("MenuItems") || nodeName.equals("GOT")) {
                        entityNodes.addAll(GotXmlDto.getInstance().getGOTEntityList(EntityType.MenuItem));
                    }
                    if (nodeName.equals("Forms") || nodeName.equals("GOT")) {
                        entityNodes.addAll(GotXmlDto.getInstance().getGOTEntityList(EntityType.Form));
                    }
                    if (nodeName.equals("Reports") || nodeName.equals("GOT")) {
                        entityNodes.addAll(GotXmlDto.getInstance().getGOTEntityList(EntityType.Report));
                    }
                    if (nodeName.equals("Classs") || nodeName.equals("Classes") || nodeName.equals("GOT")) {
                        entityNodes.addAll(GotXmlDto.getInstance().getGOTEntityList(EntityType.Class));
                    }
                } else {
                    GOTMessageDialog.alert("\u4e0d\u652f\u6301\u9009\u4e2d\u7684\u8282\u70b9:" + nodeName);
                }
            } else {
                entityNodes.add(GotXmlDto.getInstance().getGOTEntityById(elementEntityId));
            }
            ++n2;
        }
        return entityNodes.stream().collect(Collectors.toMap(gongqi.gdt.designer.service.node.GOTNode::getId, e -> e, (existing, replacement) -> existing, LinkedHashMap::new)).values().stream().collect(Collectors.toList());
    }

    public static void doMatchingTips(Button btn) {
        List<GOTEntity> selectEntitys = DoMerge.getSelectEntitys();
        if (selectEntitys.isEmpty()) {
            return;
        }
        MergeMatchingTips matchingTips = new MergeMatchingTips(GOTMessageDialog.shell, 2144);
        matchingTips.open(btn, selectEntitys, EntityValidateService.MergeMatching.Validate);
    }

    public static void doMatching(Button btn) {
        List<GOTEntity> selectEntitys = DoMerge.getSelectEntitys();
        if (selectEntitys.isEmpty()) {
            return;
        }
        MergeMatchingTips matchingTips = new MergeMatchingTips(GOTMessageDialog.shell, 2144);
        matchingTips.open(btn, selectEntitys, EntityValidateService.MergeMatching.Adjust);
    }

    public static void doSaveAll() {
        if (FormDataSyn.treeUis.isEmpty()) {
            return;
        }
        MergeSaveAll mergeSaveAll = new MergeSaveAll(GOTMessageDialog.shell, 2144);
        mergeSaveAll.open("all");
    }

    public static void refGOTPrint() {
        if (FormDataSyn.treeUis.isEmpty()) {
            return;
        }
        String result = "";
        try {
            result = LoadXmlCore.gotServices.printRefGOT();
        }
        catch (Exception e) {
            Logger.getLogger(DoMerge.class).error((Object)"", (Throwable)e);
            GOTMessageDialog.alert(e);
        }
        GOTMessageDialog.showXmlInfo(result, "\u65e5\u5fd7\u6253\u5370");
    }

    public static void cleanSplithTable() {
        if (FormDataSyn.treeUis.isEmpty()) {
            return;
        }
        List result = null;
        try {
            result = LoadXmlCore.databaseServices.cleanSplithTable();
        }
        catch (Exception e) {
            Logger.getLogger(DoMerge.class).error((Object)"", (Throwable)e);
            GOTMessageDialog.alert(e);
            return;
        }
        List list = result;
        String str = "\u6e05\u7406\u591a\u4f59\u8868\uff1a" + list.size() + "\u4e2a" + "\n";
        for (String tabl : list) {
            str = String.valueOf(str) + "\n" + tabl;
        }
        GOTMessageDialog.showXmlInfo(str, "\u6e05\u7406\u591a\u4f59\u8868");
    }

    public static void modifyDim() {
        GOTMessageDialog.showModifyDim();
    }

    public static void checkAllTable() {
        if (FormDataSyn.treeUis.isEmpty()) {
            return;
        }
        if (FormDataSyn.currentTreeUi == null) {
            return;
        }
        Tree tree = FormDataSyn.currentTreeUi.getTree();
        TreeItem[] items = tree.getSelection();
        if (items.length > 0) {
            MergeCleanAllTable allTable = new MergeCleanAllTable(GOTMessageDialog.shell, 2144);
            allTable.open(true);
        }
    }

    public static void checkSelectTable() {
        if (FormDataSyn.treeUis.isEmpty()) {
            return;
        }
        if (FormDataSyn.currentTreeUi == null) {
            return;
        }
        Tree tree = FormDataSyn.currentTreeUi.getTree();
        TreeItem[] items = tree.getSelection();
        if (items.length > 0) {
            GOTNode selectedItem = TreeUIUtil.getCurrentElement2(items[0]);
            if (selectedItem != null && selectedItem.getNodeType().equals("Table")) {
                MergeCleanAllTable allTable = new MergeCleanAllTable(GOTMessageDialog.shell, 2144);
                allTable.open(false);
            } else {
                GOTMessageDialog.alert("\u8bf7\u9009\u62e9\u5df2\u4fdd\u5b58\u7684Table");
            }
        }
    }

    public static void saveModifiedForm() {
        if (FormDataSyn.treeUis.isEmpty()) {
            return;
        }
        MergeSaveAll mergeSaveAll = new MergeSaveAll(GOTMessageDialog.shell, 2144);
        mergeSaveAll.open("Form");
    }

    public static void checkFormDataSourceFieldRate() throws VTDException {
        if (FormDataSyn.treeUis.isEmpty()) {
            return;
        }
        if (FormDataSyn.currentTreeUi == null) {
            return;
        }
        Tree tree = FormDataSyn.currentTreeUi.getTree();
        TreeItem[] items = tree.getSelection();
        String result = "";
        if (items.length > 0) {
            TreeItem[] treeItemArray = items;
            int n = items.length;
            int n2 = 0;
            while (n2 < n) {
                TreeItem treeItem = treeItemArray[n2];
                GOTNode xml = TreeUIUtil.getCurrentElement2(treeItem);
                String qname = xml.getNodeType();
                if (qname.equals("Form")) {
                    result = String.valueOf(result) + DoMerge.checkFormDataSourceFieldRateByForm(xml);
                } else if (qname.equals("Forms")) {
                    result = String.valueOf(result) + DoMerge.checkFormDataSourceFieldRateByForms(xml);
                } else if (qname.equals("FormDataSources")) {
                    result = String.valueOf(result) + DoMerge.checkFormDataSourceFieldRateByFormDataSources(xml);
                } else if (qname.equals("FormDataSource")) {
                    result = String.valueOf(result) + DoMerge.checkFormDataSourceFieldRateByFormDataSource(xml);
                } else if (qname.equals("FormDataSourceFields")) {
                    result = String.valueOf(result) + DoMerge.checkFormDataSourceFieldRateByFormDataSourceFields(xml);
                } else if (qname.equals("FormDataSourceField")) {
                    result = String.valueOf(result) + DoMerge.checkFormDataSourceFieldRateByFormDataSourceField(xml);
                }
                ++n2;
            }
        }
        if (!result.equals("")) {
            GOTMessageDialog.info(result);
        }
    }

    public static void getCurrentLayer() {
        if (FormDataSyn.treeUis.isEmpty()) {
            return;
        }
        LayerInfo info = new LayerInfo(GOTMessageDialog.shell, 2144, "getCurrentLayer");
        info.open();
    }

    public static void createLayer() {
        if (FormDataSyn.treeUis.isEmpty()) {
            return;
        }
        LayerInfo info = new LayerInfo(GOTMessageDialog.shell, 2144, "createLayer");
        info.open();
    }

    public static void recycleLayer() {
        if (FormDataSyn.treeUis.isEmpty()) {
            return;
        }
        LayerInfo info = new LayerInfo(GOTMessageDialog.shell, 2144, "recycleLayer");
        info.open();
    }

    public static void packLayer() {
        if (FormDataSyn.treeUis.isEmpty()) {
            return;
        }
        LayerInfo info = new LayerInfo(GOTMessageDialog.shell, 2144, "packLayer");
        info.open();
    }

    public static void moduleImport() {
        if (FormDataSyn.treeUis.isEmpty()) {
            return;
        }
        LayerInfo info = new LayerInfo(GOTMessageDialog.shell, 2144, "moduleImport");
        info.open();
    }

    public static void moduleExport() {
        if (FormDataSyn.treeUis.isEmpty()) {
            return;
        }
        LayerInfo info = new LayerInfo(GOTMessageDialog.shell, 2144, "moduleExport");
        info.open();
    }

    public static void moduleDelete() {
        if (FormDataSyn.treeUis.isEmpty()) {
            return;
        }
        LayerInfo info = new LayerInfo(GOTMessageDialog.shell, 2144, "moduleDelete");
        info.open();
    }

    public static void packSolution() {
        if (FormDataSyn.treeUis.isEmpty()) {
            return;
        }
        LayerInfoSoultion info = new LayerInfoSoultion(GOTMessageDialog.shell, 2144, "packSolution");
        info.open();
    }

    public static void createSolution() {
        if (FormDataSyn.treeUis.isEmpty()) {
            return;
        }
        LayerInfoSoultion info = new LayerInfoSoultion(GOTMessageDialog.shell, 2144, "createSolution");
        info.open();
    }

    public static void packSolutionExtension() {
        if (FormDataSyn.treeUis.isEmpty()) {
            return;
        }
        LayerInfoSoultion info = new LayerInfoSoultion(GOTMessageDialog.shell, 2144, "packSolutionExtension");
        info.open();
    }

    public static void createSolutionExtension() {
        if (FormDataSyn.treeUis.isEmpty()) {
            return;
        }
        LayerInfoSoultion info = new LayerInfoSoultion(GOTMessageDialog.shell, 2144, "createSolutionExtension");
        info.open();
    }

    public static void resetEnum() {
        TreeItem[] items;
        if (FormDataSyn.treeUis.isEmpty()) {
            return;
        }
        boolean changed = false;
        Tree tree = FormDataSyn.currentTreeUi.getTree();
        TreeItem[] treeItemArray = items = tree.getSelection();
        int n = items.length;
        int n2 = 0;
        while (n2 < n) {
            TreeItem selectedItem = treeItemArray[n2];
            Element xml = GotXmlDto.getInstance().getCurrentElement(selectedItem);
            if (xml.getName().equals("Enum")) {
                List enumItems = xml.elements("EnumItem");
                int i = 0;
                Boolean adjust = false;
                for (Element enumItem : enumItems) {
                    String value = GOTHelper.getPropertyValue((Element)enumItem, (String)"Value");
                    if (value.equals(String.valueOf(i))) {
                        ++i;
                        continue;
                    }
                    adjust = true;
                    break;
                }
                if (adjust.booleanValue()) {
                    int j = 0;
                    xml.addAttribute("saved", "0");
                    changed = true;
                    for (Element enumItem : enumItems) {
                        Element valuePro = gongqi.gdt.designer.core.toolsgot.GOTHelper.getProperty(enumItem, "Value");
                        if (valuePro.element("Value") == null) {
                            valuePro.addElement("Value");
                        }
                        valuePro.element("Value").setText(String.valueOf(j));
                        ++j;
                    }
                    GotXmlDto.getInstance().updateEntityElement(xml);
                    FormDataSyn.setUnSave(selectedItem);
                }
            }
            ++n2;
        }
        if (changed) {
            GOTMessageDialog.info("\u5df2\u505a\u8c03\u6574");
        } else {
            GOTMessageDialog.alert("\u4e0d\u9700\u8c03\u6574");
        }
    }

    public static void synchronizeColumnOrder() {
        if (FormDataSyn.treeUis.isEmpty()) {
            return;
        }
        Tree tree = FormDataSyn.treeUis.get(0).getTree();
        TreeItem[] items = tree.getSelection();
        if (items.length == 0) {
            GOTMessageDialog.alert("\u8bf7\u9009\u4e2dTable");
        } else {
            GOTNode selectedItem = TreeUIUtil.getCurrentElement2(items[0]);
            if (selectedItem.getNodeType().equals("Table")) {
                byte[] bytes = null;
                try {
                    bytes = LoadXmlCore.gotServices.synchronizeColumnOrder(selectedItem.getName());
                    String result = new String(bytes, StandardCharsets.UTF_8);
                    DoMerge.rpc_synchronizeColumnOrder(result, items[0]);
                }
                catch (Exception e) {
                    Logger.getLogger(DoMerge.class).error((Object)"", (Throwable)e);
                    GOTMessageDialog.alert(e);
                }
            } else {
                GOTMessageDialog.alert("\u8bf7\u9009\u4e2dTable");
            }
        }
    }

    private static void rpc_synchronizeColumnOrder(String result, TreeItem treeItem) {
        if (FormDataSyn.treeUis.isEmpty()) {
            return;
        }
        result = "<rootTemp>" + result + "</rootTemp>";
        Element xmlParent = GOTXMLHelper.createElementByXMLString(result);
        List list = xmlParent.elements();
        int total = list.size();
        String his = "";
        String info = "";
        EntityNode node = null;
        int j = 0;
        while (j < total) {
            Element xml = (Element)list.get(j);
            if (xml.attribute("id") != null) {
                String strId = xml.attributeValue("id");
                int k = j + 1;
                while (k < total) {
                    Element xmlCompare = (Element)list.get(k);
                    if (xmlCompare.attribute("id") != null && xmlCompare.attributeValue("id").equals(strId)) {
                        xml.addAttribute("del", "true");
                        break;
                    }
                    ++k;
                }
            }
            ++j;
        }
        for (Element r : list) {
            if (r.attribute("del") != null) continue;
            if (r.getName().equals("Error")) {
                info = String.valueOf(info) + r.getText() + "\n\u4fdd\u5b58\u5931\u8d25\uff0c\u5e94\u6267\u884c\u53f3\u952e\u6062\u590d\uff0c\u4ee5\u9632\u6570\u636e\u4e22\u5931\n";
                continue;
            }
            if (his.indexOf(r.attributeValue("id")) != -1) continue;
            his = String.valueOf(his) + "$" + r.attributeValue("id");
            String nodeId = r.attributeValue("id");
            String qname = r.getName();
            node = DoMerge.getGOTNodeByQname(qname, nodeId);
            if (node == null) {
                GOTMessageDialog.alert("\u4e0d\u5b58\u5728id\u4e3a" + nodeId + "\u7684\u8282\u70b9\uff0c\u5e94\u65b0\u5efa");
                continue;
            }
            TreeItem item = FormDataSyn.getTreeItrmByNode((GOTNode)node, null);
            if (item != null) {
                Element entityElement = node.toElement();
                if ("0".equals(r.attributeValue("saved"))) {
                    entityElement.remove(r.attribute("saved"));
                }
                Element parent = entityElement.getParent();
                GOTHelp.insertChildBefore(parent, entityElement, r);
                parent.remove(entityElement);
                GotXmlDto.getInstance().updateEntityElement(NodeGOT.getEntity(r));
                FormDataSyn.restore(item, null);
            }
            info = String.valueOf(info) + r.attributeValue("name") + ":" + r.getName() + "  \u5df2\u4fee\u6539 OK\n";
        }
        ConfigComposite.configComposite.set_text_op_info(Macros.INFO_OPR_SUCCESS);
        TreeOperationInfo.addInfo("\u540c\u6b65\u5b57\u6bb5\u987a\u5e8f" + Macros.INFO_OPR_SUCCESS);
        if (list.size() > 1) {
            TreeOperationInfo.addInfo("\u540c\u6b65\u5b57\u6bb5\u987a\u5e8f" + info);
            FormDataSyn.setSaved(treeItem);
        } else if (list.size() == 1) {
            Element error = (Element)list.get(0);
            if (error.getName().equals("Error")) {
                TreeOperationInfo.addErrorInfo(info);
            } else {
                FormDataSyn.setSaved(treeItem);
            }
        } else {
            GOTMessageDialog.alert("\u8fd4\u56delist.length()<1\uff0c\u5f02\u5e38");
        }
    }

    private static EntityNode getGOTNodeByQname(String qname, String nodeId) {
        if (qname.equals("Form")) {
            return GotXmlDto.getInstance().getEntityByIdAndType(EntityType.Form, nodeId);
        }
        if (qname.equals("Table")) {
            return GotXmlDto.getInstance().getEntityByIdAndType(EntityType.Table, nodeId);
        }
        if (qname.equals("DataType")) {
            return GotXmlDto.getInstance().getEntityByIdAndType(EntityType.DataType, nodeId);
        }
        if (qname.equals("MenuItem")) {
            return GotXmlDto.getInstance().getEntityByIdAndType(EntityType.MenuItem, nodeId);
        }
        if (qname.equals("Menu")) {
            return GotXmlDto.getInstance().getEntityByIdAndType(EntityType.Menu, nodeId);
        }
        if (qname.equals("Enum")) {
            return GotXmlDto.getInstance().getEntityByIdAndType(EntityType.Enum, nodeId);
        }
        if (qname.equals("Report")) {
            return GotXmlDto.getInstance().getEntityByIdAndType(EntityType.Report, nodeId);
        }
        qname.equals("Map");
        return null;
    }

    private static String checkFormDataSourceFieldRateByForms(GOTNode forms) throws VTDException {
        String result = "";
        List elements = forms.selectNodes("Form");
        for (GOTNode form : elements) {
            result = String.valueOf(result) + DoMerge.checkFormDataSourceFieldRateByForm(form);
        }
        return result;
    }

    private static String checkFormDataSourceFieldRateByForm(GOTNode xml) throws VTDException {
        String result = "";
        GOTNode datasources = xml.selectSingleNode("FormDataSources");
        if (datasources != null) {
            result = String.valueOf(result) + DoMerge.checkFormDataSourceFieldRateByFormDataSources(datasources);
        }
        return result;
    }

    private static String checkFormDataSourceFieldRateByFormDataSources(GOTNode datasources) throws VTDException {
        String result = "";
        List elements = datasources.selectNodes("FormDataSource");
        for (GOTNode formdatasource : elements) {
            result = String.valueOf(result) + DoMerge.checkFormDataSourceFieldRateByFormDataSource(formdatasource);
        }
        return result;
    }

    private static String checkFormDataSourceFieldRateByFormDataSource(GOTNode formdatasource) throws VTDException {
        String result = "";
        GOTNode datasourcefields = formdatasource.selectSingleNode("FormDataSourceFields");
        if (datasourcefields != null) {
            result = String.valueOf(result) + DoMerge.checkFormDataSourceFieldRateByFormDataSourceFields(datasourcefields);
        }
        return result;
    }

    private static String checkFormDataSourceFieldRateByFormDataSourceFields(GOTNode datasourcefields) throws VTDException {
        String result = "";
        List elements = datasourcefields.selectNodes("FormDataSourceField");
        for (GOTNode formdatasourcefield : elements) {
            result = String.valueOf(result) + DoMerge.checkFormDataSourceFieldRateByFormDataSourceField(formdatasourcefield);
        }
        return result;
    }

    private static String checkFormDataSourceFieldRateByFormDataSourceField(GOTNode formdatasourcefield) throws VTDException {
        String result = "";
        GOTNode formdatasource = formdatasourcefield.getParent().getParent();
        GOTNode form = formdatasource.getParent().getParent();
        GOTNode formDesign = form.selectSingleNode("FormDesign");
        NodeProperty fieldPro = formdatasourcefield.getProperty("Field");
        String _refentityid = fieldPro.getRefEntityId();
        String _refinnerid = fieldPro.getRefInnerId();
        String xpath = ".//FormItem/Properties/Property[@refentityid='" + _refentityid + "' and @refinnerid='" + _refinnerid + "']/Value[text()='" + formdatasourcefield.getName() + "']/../../..";
        List properties = formDesign.selectNodes(xpath);
        result = String.valueOf(formdatasource.getAttributeValue("name")) + "." + formdatasourcefield.getAttributeValue("name") + "\t\u88ab\u4f7f\u7528\t" + properties.size() + "\t\u6b21\n";
        return result;
    }

    private static String getNodePosition(Tree tree, Element node) {
        Element tmp = null;
        tmp = node == null ? GotXmlDto.getInstance().getCurrentElement(tree.getSelection()[0]) : node;
        String info = "";
        while (tmp != null) {
            String s = tmp.attribute("name") != null ? tmp.attributeValue("name") : tmp.getName();
            info = "/" + s + info;
            tmp = tmp.getParent();
        }
        return info;
    }
}

