/*
 * Decompiled with CFR 0.152.
 */
package gongqi.gdt.designer.service.analysis;

import com.ximpleware.VTDException;
import gongqi.erp.gotmodel.core.EntityType;
import gongqi.gdt.designer.service.GOTModel;
import gongqi.gdt.designer.service.analysis.BaseAnalysis;
import gongqi.gdt.designer.service.modify.ModifyLevel;
import gongqi.gdt.designer.service.modify.ModifyType;
import gongqi.gdt.designer.service.node.GOTEntity;
import gongqi.gdt.designer.service.node.GOTNode;
import gongqi.gdt.designer.utils.LayerUtils;
import java.util.ArrayList;
import java.util.List;
import org.dom4j.Element;

public class TableAnalysis
extends BaseAnalysis {
    public TableAnalysis(GOTModel sourceGOT, GOTModel targetGOT, GOTModel originalGOT) {
        super(sourceGOT, targetGOT, originalGOT);
    }

    @Override
    protected EntityType getSupportEntityType() {
        return EntityType.Table;
    }

    @Override
    protected List<Element> analysisEntityInnerModify(GOTEntity sourceEntity, GOTEntity targetEntity) throws VTDException {
        ArrayList<Element> modifyItems = new ArrayList<Element>();
        String nodeBaseXPath = "TableFields/TableField";
        for (GOTNode targetTableField : targetEntity.selectNodes(nodeBaseXPath)) {
            modifyItems.addAll(this.analysisInnerNode(targetTableField));
        }
        nodeBaseXPath = "TableIndexes/TableIndex";
        for (GOTNode targetTableIndex : targetEntity.selectNodes(nodeBaseXPath)) {
            modifyItems.addAll(this.analysisInnerNode(targetTableIndex));
            GOTNode sourceTableIndex = sourceEntity.selectSingleNode(targetTableIndex.getEntityXPath());
            if (sourceTableIndex == null) continue;
            nodeBaseXPath = "TableIndexItem";
            for (GOTNode targetTableIndexItem : targetTableIndex.selectNodes(nodeBaseXPath)) {
                GOTNode prevSiblingNode;
                modifyItems.addAll(this.analysisInnerNode(targetTableIndexItem));
                GOTNode sourceTableIndexItem = sourceEntity.selectSingleNode(targetTableIndexItem.getEntityXPath());
                if (sourceTableIndexItem == null) continue;
                GOTNode targetPrevTableIndexItem = targetTableIndexItem.getPrevSiblingNode();
                GOTNode sourcePrevTableIndexItem = null;
                GOTNode node = sourceTableIndexItem;
                while (true) {
                    if ((prevSiblingNode = node.getPrevSiblingNode()) == null || LayerUtils.isLowerLayer(this.targetGOT.getTopLayerDefination().getLayerName(), prevSiblingNode.getCreatedLayer(), true, true)) break;
                    node = prevSiblingNode;
                }
                sourcePrevTableIndexItem = prevSiblingNode;
                if (!(targetPrevTableIndexItem == null && sourcePrevTableIndexItem != null || targetPrevTableIndexItem != null && sourcePrevTableIndexItem == null) && (targetPrevTableIndexItem == null || sourcePrevTableIndexItem == null || targetPrevTableIndexItem.getId().equals(sourcePrevTableIndexItem.getId()))) continue;
                Element modifyItem = this.createModifyItem(ModifyType.InnerNode_Order, ModifyLevel.Must, sourceTableIndexItem.getNodeType(), sourceTableIndexItem.getId(), null, String.format("TableIndex\u3010%s\u3011\u5185\u90e8TableIndexItem\u3010%s\u3011\u987a\u5e8f\u8c03\u6574", sourceTableIndex.getName(), sourceTableIndexItem.getName()), null, null);
                modifyItems.add(modifyItem);
            }
        }
        nodeBaseXPath = "TableFieldGroups/TableFieldGroup";
        for (GOTNode targetTableFieldGroup : targetEntity.selectNodes(nodeBaseXPath)) {
            modifyItems.addAll(this.analysisInnerNode(targetTableFieldGroup));
            GOTNode sourceTableFieldGroup = sourceEntity.selectSingleNode(targetTableFieldGroup.getEntityXPath());
            if (sourceTableFieldGroup == null) continue;
            nodeBaseXPath = "TableFieldGroupItem";
            for (GOTNode targetTableFieldGroupItem : targetTableFieldGroup.selectNodes(nodeBaseXPath)) {
                modifyItems.addAll(this.analysisInnerNode(targetTableFieldGroupItem));
            }
        }
        return modifyItems;
    }

    @Override
    protected List<Element> analysisEntityInnerDelete(GOTEntity sourceEntity, GOTEntity targetEntity) throws VTDException {
        ArrayList<Element> items = new ArrayList<Element>();
        for (GOTNode sourceTableField : sourceEntity.selectNodes("TableFields/TableField")) {
            items.addAll(this.analysisReverseInnerNode(sourceTableField));
        }
        for (GOTNode sourceTableIndex : sourceEntity.selectNodes("TableIndexes/TableIndex")) {
            items.addAll(this.analysisReverseInnerNode(sourceTableIndex));
            GOTNode targetTableIndex = targetEntity.selectSingleNode(sourceTableIndex.getEntityXPath());
            if (targetTableIndex == null) continue;
            for (GOTNode sourceTableIndexItem : sourceTableIndex.selectNodes("TableIndexItem")) {
                items.addAll(this.analysisReverseInnerNode(sourceTableIndexItem));
            }
        }
        for (GOTNode sourceTableFieldGroup : sourceEntity.selectNodes("TableFieldGroups/TableFieldGroup")) {
            items.addAll(this.analysisReverseInnerNode(sourceTableFieldGroup));
            GOTNode targetTableFieldGroup = targetEntity.selectSingleNode(sourceTableFieldGroup.getEntityXPath());
            if (targetTableFieldGroup == null) continue;
            for (GOTNode sourceTableFieldGroupItem : sourceTableFieldGroup.selectNodes("TableFieldGroupItem")) {
                items.addAll(this.analysisReverseInnerNode(sourceTableFieldGroupItem));
            }
        }
        return items;
    }
}

