/*
 * Decompiled with CFR 0.152.
 */
package gongqi.gdt.designer.service.node;

import com.ximpleware.ModifyException;
import com.ximpleware.ParseException;
import com.ximpleware.TranscodeException;
import com.ximpleware.VTDException;
import com.ximpleware.VTDNav;
import com.ximpleware.XMLModifier;
import gongqi.erp.framework.exception.ERPException;
import gongqi.erp.gotmodel.core.EntityType;
import gongqi.gdt.designer.service.node.GOTNode;
import gongqi.gdt.designer.utils.VTDUtils;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.log4j.Logger;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;

public class GOTEntity
extends GOTNode {
    private VTDNav entityNav;
    private XMLModifier modifier;
    private boolean modify = false;
    private ReentrantLock navLock = new ReentrantLock();

    public GOTEntity(VTDNav entityNav) throws VTDException {
        this.entityNav = entityNav;
        this.modifier = new XMLModifier();
        this.modifier.bind(entityNav);
        this.setEntity(this);
        this.setNodeIndex(entityNav.getRootIndex());
    }

    public VTDNav acquireEntityNav() {
        return this.acquireEntityNav(true);
    }

    VTDNav acquireEntityNav(boolean lock) {
        if (lock) {
            this.navLock.lock();
        }
        return this.entityNav;
    }

    public void releaseEntityNav() {
        if (this.navLock.isHeldByCurrentThread()) {
            this.navLock.unlock();
        }
    }

    synchronized XMLModifier getEntityModifier() {
        return this.modifier;
    }

    public synchronized void applyModifier() {
        try {
            this.entityNav = this.modifier.outputAndReparse();
            this.setNodeIndex(this.entityNav.getRootIndex());
            this.modifier.reset();
            this.modifier.bind(this.entityNav);
            this.modify = true;
        }
        catch (ModifyException | ParseException | TranscodeException | IOException e) {
            throw new RuntimeException("\u5b9e\u4f53\u8282\u70b9\u4fee\u6539\u9519\u8bef\uff1a" + this.getId(), e);
        }
    }

    public boolean hasModify() {
        return this.modify;
    }

    public EntityType getEntityType() {
        return EntityType.valueOf((String)this.getNodeType());
    }

    public GOTNode getChildNode(String nodeId) throws VTDException {
        try {
            VTDNav entityNav = this.acquireEntityNav();
            this.recoverNode();
            if (VTDUtils.toXPathElement(entityNav, String.format("//*[@id='%s']", nodeId))) {
                GOTNode gOTNode = new GOTNode(this, entityNav.getCurrentIndex());
                return gOTNode;
            }
        }
        finally {
            this.releaseEntityNav();
        }
        return null;
    }

    public GOTEntity clone() {
        try {
            return new GOTEntity(this.entityNav.cloneNav());
        }
        catch (VTDException e) {
            throw new ERPException("clone GOTEntity Error", (Throwable)e);
        }
    }

    public static GOTEntity parse(String xml) {
        try {
            return new GOTEntity(VTDUtils.parseXML(xml.getBytes(StandardCharsets.UTF_8)));
        }
        catch (VTDException | IOException e) {
            throw new RuntimeException("\u89e3\u6790\u5b9e\u4f53\u5f02\u5e38", e);
        }
    }

    public Element toElement() {
        Document document = null;
        try {
            document = DocumentHelper.parseText((String)this.asXML());
        }
        catch (DocumentException e) {
            Logger.getLogger(GOTEntity.class).error((Object)"\u5b9e\u4f53\u8282\u70b9\u89e3\u6790\u5f02\u5e38", (Throwable)e);
        }
        Element root = document.getRootElement();
        return root;
    }

    public int getSize() {
        return this.toString().length();
    }
}

