/*
 * Decompiled with CFR 0.152.
 */
package gongqi.gdt.designer.service.rename;

import com.ximpleware.VTDException;
import gongqi.erp.gotmodel.core.EntityType;
import gongqi.gdt.designer.handler.JDTHandler;
import gongqi.gdt.designer.service.rename.BaseRename;
import gongqi.gdt.designer.service.rename.EntityRename;
import gongqi.gdt.designer.service.rename.NodeRename;
import gongqi.gdt.osgi.JDTService;

public class EnumRename
extends BaseRename {
    @Override
    protected void doModifyEntity(EntityRename element) throws VTDException {
        String type;
        String entityId = element.getEntityId();
        String sourcePackageName = String.valueOf(this.getJavaPackage(entityId, element.getSourceEntityModifyLayer())) + ".enums";
        String targetPackageName = String.valueOf(this.getJavaPackage(entityId, element.getTargetEntityModifyLayer())) + ".enums";
        String entityName = this.getSimpleName(element.getSourceEntityName());
        String destName = this.getSimpleName(element.getTargetEntityName());
        for (NodeRename nodeRename : element.getNodeRenames()) {
            type = nodeRename.getNodeType();
            if (!type.equals("EnumItem")) continue;
            this.renameEnumItem(targetPackageName, entityName, nodeRename.getSourceNodeName(), nodeRename.getTargetNodeName());
        }
        if (!entityName.equals(destName)) {
            this.renameEntityName(targetPackageName, entityName, destName);
        }
        if (element.getIsPromote().booleanValue()) {
            for (NodeRename nodeRename : element.getNodeRenames()) {
                type = nodeRename.getNodeType();
                if (!type.equals("EnumItem")) continue;
                this.renameEnumItem(sourcePackageName, entityName, nodeRename.getSourceNodeName(), nodeRename.getTargetNodeName());
            }
            if (!entityName.equals(destName)) {
                this.renameEntityName(sourcePackageName, entityName, destName);
            }
        }
    }

    private void renameEnumItem(String packageName, String entityName, String srcName, String destName) {
        try {
            JDTService server = JDTHandler.getServer();
            server.renameVariable(packageName, entityName, srcName, destName);
        }
        catch (Exception e) {
            this.log.warn((Object)String.format("\u3010%s.%s\u3011\u7684EnumItem\u8282\u70b9\u91cd\u547d\u540d\u3010%s -> %s\u3011\u5931\u8d25", packageName, entityName, srcName, destName), (Throwable)e);
        }
    }

    @Override
    protected EntityType getSupportEntityType() {
        return EntityType.Enum;
    }
}

