/*
 * Decompiled with CFR 0.152.
 */
package gongqi.gdt.designer.service.rename;

import com.ximpleware.NavException;
import gongqi.gdt.designer.service.node.GOTNode;
import gongqi.gdt.designer.service.node.GOTProperty;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;

public class MethodUtil {
    private static final Map<String, String[]> formDataSourceFieldMethods = new HashMap<String, String[]>();
    private static final Map<String, String[]> formItemMethos;

    static {
        formDataSourceFieldMethods.put("modifiedField_", new String[]{"QCommandArg;", "QObject;", "QObject;", "QGongqiRecord;", "QGongqiRecord;", "QCommandResult;"});
        formDataSourceFieldMethods.put("openLookup_", new String[]{"QCommandArg;"});
        formDataSourceFieldMethods.put("lookup_", new String[]{"QCommandArg;", "QGongqiRecord;", "QQueryTable;", "QFormDataSourceGroupResult;"});
        formDataSourceFieldMethods.put("mainForm_", new String[]{"QCommandArg;", "QOpenMainFormArg;"});
        formDataSourceFieldMethods.put("dataTip_", new String[]{"QCommandArg;"});
        formItemMethos = new HashMap<String, String[]>();
        formItemMethos.put("buttonOK_", new String[]{"QCommandArg;"});
        formItemMethos.put("modifiedEditor_", new String[]{"QCommandArg;", "QObject;", "QObject;"});
        formItemMethos.put("openLookup_", new String[]{"QCommandArg;"});
        formItemMethos.put("lookup_", new String[]{"QCommandArg;", "Ljava.lang.String;", "QQueryTable;", "QFormDataSourceGroupResult;"});
        formItemMethos.put("mainForm_", new String[]{"QCommandArg;", "QOpenMainFormArg;"});
        formItemMethos.put("dataTip_", new String[]{"QCommandArg;"});
        formItemMethos.put("clipboardOK_", new String[]{"QCommandArg;"});
        formItemMethos.put("pluginRadioItemSelect_", new String[]{"QCommandArg;", "QObject;", "QObject;"});
        formItemMethos.put("pluginTreeNodeChange_", new String[]{"QCommandArg;"});
        formItemMethos.put("pluginTreeNodeAdd_", new String[]{"QCommandArg;"});
        formItemMethos.put("pluginTreeNodeDelete_", new String[]{"QCommandArg;"});
        formItemMethos.put("tabPageChanged_", new String[]{"QCommandArg;"});
        formItemMethos.put("lookupSelect_", new String[]{"QCommandArg;"});
    }

    public static Map<String, String[]> getFormDataSourceFileMethods() {
        return formDataSourceFieldMethods;
    }

    public static List<String> getFormItemMethods(GOTNode formItem) throws NavException {
        ArrayList<String> methods = new ArrayList<String>();
        String type = formItem.getAttributeValue("type");
        if ("Button".equals(type)) {
            methods.add("buttonOK_");
        } else if (type.endsWith("Editor")) {
            GOTProperty dataSourcePro = formItem.getProperty("DataSource");
            if (dataSourcePro == null || StringUtils.isBlank((String)dataSourcePro.getValue())) {
                methods.add("modifiedEditor_");
                methods.add("openLookup_");
                methods.add("lookup_");
                methods.add("mainForm_");
                methods.add("dataTip_");
            }
            methods.add("clipboardOK_");
        } else if ("Plugin".equals(type) && formItem.getProperty("PluginType") != null) {
            String pluginType = formItem.getProperty("PluginType").getValue();
            if ("Radio".equals(pluginType)) {
                methods.add("pluginRadioItemSelect_");
            } else if ("Tree".equals(pluginType)) {
                methods.add("pluginTreeNodeChange_");
                methods.add("pluginTreeNodeAdd_");
                methods.add("pluginTreeNodeDelete_");
            }
        } else if ("TabPage".equals(type)) {
            methods.add("tabPageChanged_");
        } else if ("DataGrid".equals(type)) {
            methods.add("lookupSelect_");
        }
        return methods;
    }

    public static String[] getMethodParams(String method) {
        return formItemMethos.get(method);
    }
}

