/*
 * Decompiled with CFR 0.152.
 */
package gongqi.gdt.designer.ui;

import com.ximpleware.VTDException;
import gongqi.erp.framework.core.LayerDeploymentMode;
import gongqi.erp.framework.core.extension.SolutionExtensionDeploymentMode;
import gongqi.erp.framework.core.plugin.SolutionPluginDeploymentMode;
import gongqi.erp.framework.core.solution.SolutionDeploymentMode;
import gongqi.erp.framework.exception.ERPException;
import gongqi.gdt.designer.service.node.GOTNode;
import gongqi.gdt.designer.ui.LayerChainPage;
import gongqi.gdt.designer.utils.Images;
import gongqi.gdt.designer.utils.PedestalLayerInfo;
import gongqi.gdt.designer.utils.SWTUtils;
import gongqi.gdt.designer.utils.SolutionExtInfo;
import gongqi.gdt.designer.utils.SolutionLayerInfo;
import gongqi.gdt.designer.utils.SolutionPluginInfo;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.lang.StringUtils;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Sash;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolItem;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;

public class StructureCompare {
    private Shell shell;
    private GOTNode leftGOT;
    private GOTNode rightGOT;
    private Map<String, TreeItem> leftTreeItems = new HashMap<String, TreeItem>();
    private Map<String, TreeItem> rightTreeItems = new HashMap<String, TreeItem>();
    private Tree leftTree;
    private Tree rightTree;
    private ToolItem filterButton;
    private Set<String> commonKeys;
    private Set<String> orderKeysInMap;
    private Set<String> extraKeysInMap;
    private Set<String> missingKeysInMap;
    private Image addImg = Images.getIcon("layerUpgrade/Add.png", SWTUtils.zoom(16), SWTUtils.zoom(16));
    private Image deleteImage = Images.getIcon("layerUpgrade/Delete.png", SWTUtils.zoom(16), SWTUtils.zoom(16));
    private Image ordImage = Images.getIcon("layerUpgrade/Order.png", SWTUtils.zoom(16), SWTUtils.zoom(16));

    public StructureCompare(Object leftNode, Object rightNode) {
        this.leftGOT = leftNode instanceof GOTNode ? (GOTNode)leftNode : null;
        this.rightGOT = rightNode instanceof GOTNode ? (GOTNode)rightNode : null;
    }

    private void createContent() {
        Display display = Display.getCurrent();
        this.shell = new Shell(display.getActiveShell(), 208);
        this.shell.setText("\u7ed3\u6784\u5bf9\u6bd4");
        this.shell.setLayout((Layout)new FormLayout());
        this.shell.setSize(SWTUtils.zoom(900), SWTUtils.zoom(550));
        Rectangle bounds = Display.getDefault().getPrimaryMonitor().getBounds();
        Rectangle rect = this.shell.getBounds();
        int x = bounds.x + (bounds.width - rect.width) / 2;
        int y = bounds.y + (bounds.height - rect.height) / 2;
        this.shell.setLocation(x, y);
        ToolBar toolBar = new ToolBar((Composite)this.shell, 8519744);
        FormData formData = new FormData();
        formData.bottom = new FormAttachment(100, SWTUtils.zoom(-3));
        formData.right = new FormAttachment(100);
        toolBar.setLayoutData((Object)formData);
        this.filterButton = new ToolItem(toolBar, 131104);
        this.filterButton.setImage(Images.getIcon("layerUpgrade/filter.png", SWTUtils.zoom(16), SWTUtils.zoom(16)));
        this.filterButton.setToolTipText("\u4ec5\u663e\u793a\u5dee\u5f02");
        this.filterButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                StructureCompare.this.compare();
            }
        });
        Composite leftComposite = new Composite((Composite)this.shell, 2048);
        formData = new FormData();
        formData.left = new FormAttachment(0, SWTUtils.zoom(5));
        formData.right = new FormAttachment(50, SWTUtils.zoom(-2));
        formData.top = new FormAttachment(0, SWTUtils.zoom(5));
        formData.bottom = new FormAttachment(100, SWTUtils.zoom(-28));
        leftComposite.setLayoutData((Object)formData);
        leftComposite.setLayout((Layout)new FormLayout());
        Label leftTitle = new Label(leftComposite, 0);
        formData = new FormData();
        formData.top = new FormAttachment(0, SWTUtils.zoom(5));
        formData.bottom = new FormAttachment(0, SWTUtils.zoom(23));
        formData.left = new FormAttachment(0);
        formData.right = new FormAttachment(100);
        leftTitle.setText(" \u5f53\u524d\u73af\u5883-" + this.leftGOT.getEntity().getName());
        Font font = new Font((Device)Display.getCurrent(), "\u5fae\u8f6f\u96c5\u9ed1", 9, 1);
        leftTitle.setFont(font);
        leftTitle.setAlignment(16384);
        leftTitle.setLayoutData((Object)formData);
        this.leftTree = new Tree(leftComposite, 65792);
        formData = new FormData();
        formData.left = new FormAttachment(0);
        formData.right = new FormAttachment(100);
        formData.top = new FormAttachment((Control)leftTitle, SWTUtils.zoom(2), 1024);
        formData.bottom = new FormAttachment(100);
        this.leftTree.setLayoutData((Object)formData);
        Sash sash = new Sash((Composite)this.shell, 512);
        formData = new FormData();
        formData.left = new FormAttachment((Control)leftComposite, 2, 131072);
        formData.top = new FormAttachment((Control)leftComposite, 0, 128);
        formData.bottom = new FormAttachment((Control)leftComposite, 0, 1024);
        sash.setLayoutData((Object)formData);
        Composite rightComposite = new Composite((Composite)this.shell, 2048);
        formData = new FormData();
        formData.left = new FormAttachment((Control)sash, SWTUtils.zoom(2), SWTUtils.zoom(2));
        formData.right = new FormAttachment(100, SWTUtils.zoom(-5));
        formData.top = new FormAttachment((Control)leftComposite, 0, 128);
        formData.bottom = new FormAttachment((Control)leftComposite, 0, 1024);
        rightComposite.setLayoutData((Object)formData);
        rightComposite.setLayout((Layout)new FormLayout());
        Label rightTitle = new Label(rightComposite, 0);
        formData = new FormData();
        formData.top = new FormAttachment(0, SWTUtils.zoom(5));
        formData.bottom = new FormAttachment(0, SWTUtils.zoom(23));
        formData.left = new FormAttachment(0);
        formData.right = new FormAttachment(100);
        rightTitle.setText(" \u76ee\u6807\u73af\u5883-" + this.rightGOT.getEntity().getName());
        rightTitle.setFont(font);
        rightTitle.setAlignment(16384);
        rightTitle.setLayoutData((Object)formData);
        this.rightTree = new Tree(rightComposite, 65792);
        formData = new FormData();
        formData.left = new FormAttachment(0);
        formData.right = new FormAttachment(100);
        formData.top = new FormAttachment((Control)rightTitle, SWTUtils.zoom(2), 1024);
        formData.bottom = new FormAttachment(100);
        this.rightTree.setLayoutData((Object)formData);
        sash.addSelectionListener(SelectionListener.widgetSelectedAdapter(e -> {
            leftComposite.setSize(e.x, composite.getBounds().height);
            sash.setBounds(e.x + 2, sash.getBounds().y, sash.getBounds().width, sash.getBounds().height);
            int detailTableX = sash.getBounds().x + sash.getBounds().width + 2;
            rightComposite.setBounds(detailTableX, composite2.getBounds().y, this.shell.getBounds().width - detailTableX, composite2.getBounds().height);
        }));
        this.leftTree.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                TreeItem select = StructureCompare.this.leftTree.getSelection()[0];
                String id = (String)select.getData("id");
                if (StructureCompare.this.commonKeys.contains(id)) {
                    TreeItem treeItem = (TreeItem)StructureCompare.this.rightTreeItems.get(id);
                    StructureCompare.this.rightTree.select(treeItem);
                }
            }
        });
        this.rightTree.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                TreeItem select = StructureCompare.this.rightTree.getSelection()[0];
                String id = (String)select.getData("id");
                if (StructureCompare.this.commonKeys.contains(id)) {
                    TreeItem treeItem = (TreeItem)StructureCompare.this.leftTreeItems.get(id);
                    StructureCompare.this.leftTree.select(treeItem);
                }
            }
        });
        try {
            List<GOTNode> childNodes = this.leftGOT.getChildNodeBFS(true);
            Map<String, GOTNode> leftItems = childNodes.stream().collect(Collectors.toMap(n -> {
                if (StringUtils.isNotBlank((String)n.getId())) {
                    return n.getId();
                }
                return n.getNodeType();
            }, n -> n));
            childNodes = this.rightGOT.getChildNodeBFS(true);
            Map<String, GOTNode> rightItems = childNodes.stream().collect(Collectors.toMap(n -> {
                if (StringUtils.isNotBlank((String)n.getId())) {
                    return n.getId();
                }
                return n.getNodeType();
            }, n -> n));
            Set<String> keySet1 = leftItems.keySet();
            Set<String> keySet2 = rightItems.keySet();
            this.extraKeysInMap = new HashSet<String>(keySet1);
            this.extraKeysInMap.removeAll(keySet2);
            HashSet<String> soureCreates = new HashSet<String>();
            for (String id : this.extraKeysInMap) {
                GOTNode gotNode = leftItems.get(id);
                if (!this.isSoureNode(gotNode)) continue;
                soureCreates.add(id);
            }
            this.extraKeysInMap.removeAll(soureCreates);
            this.missingKeysInMap = new HashSet<String>(keySet2);
            this.missingKeysInMap.removeAll(keySet1);
            this.commonKeys = new HashSet<String>(keySet1);
            this.commonKeys.retainAll(keySet2);
            this.orderKeysInMap = new HashSet<String>();
            for (String id : this.commonKeys) {
                GOTNode rightItem;
                GOTNode parentItem_r;
                String id_r;
                GOTNode leftItem = leftItems.get(id);
                GOTNode parentItem_l = leftItem.getParent();
                String id_l = parentItem_l.getId();
                if (StringUtils.isBlank((String)id_l)) {
                    id_l = parentItem_l.getNodeType();
                }
                if (StringUtils.isBlank((String)(id_r = (parentItem_r = (rightItem = rightItems.get(id)).getParent()).getId()))) {
                    id_r = parentItem_r.getNodeType();
                }
                if (id_l.equals(id_r)) {
                    String brotherId;
                    id_l = "";
                    GOTNode prevSiblingNode = leftItem.getPrevSiblingNode();
                    while (prevSiblingNode != null) {
                        brotherId = prevSiblingNode.getId();
                        if (StringUtils.isBlank((String)brotherId)) {
                            brotherId = prevSiblingNode.getNodeType();
                        }
                        if (!this.extraKeysInMap.contains(brotherId) && !this.missingKeysInMap.contains(brotherId)) {
                            id_l = brotherId;
                            break;
                        }
                        prevSiblingNode = prevSiblingNode.getPrevSiblingNode();
                    }
                    prevSiblingNode = rightItem.getPrevSiblingNode();
                    id_r = "";
                    while (prevSiblingNode != null) {
                        brotherId = prevSiblingNode.getId();
                        if (StringUtils.isBlank((String)brotherId)) {
                            brotherId = prevSiblingNode.getNodeType();
                        }
                        if (!this.extraKeysInMap.contains(brotherId) && !this.missingKeysInMap.contains(brotherId)) {
                            id_r = brotherId;
                            break;
                        }
                        prevSiblingNode = prevSiblingNode.getPrevSiblingNode();
                    }
                    if (id_l.equals(id_r)) continue;
                    this.orderKeysInMap.add(id);
                    continue;
                }
                this.orderKeysInMap.add(id);
            }
        }
        catch (Exception e2) {
            e2.printStackTrace();
        }
        this.compare();
    }

    private boolean isSoureNode(GOTNode node) {
        String createdLayer = node.getCreatedLayer();
        Map<String, PedestalLayerInfo> pedestals = LayerChainPage.getInstance().getPedestals();
        if (pedestals.containsKey(createdLayer)) {
            return LayerDeploymentMode.Source.equals((Object)pedestals.get(createdLayer).getDeploymentMode());
        }
        String id = node.getId();
        if (!id.contains(".")) {
            return false;
        }
        id = id.substring(0, id.lastIndexOf("."));
        Map<String, SolutionLayerInfo> solutions = LayerChainPage.getInstance().getSolutions();
        if ("app".equals(createdLayer)) {
            if (!solutions.containsKey(id)) {
                return false;
            }
            return SolutionDeploymentMode.Source.equals((Object)solutions.get(id).getDeploymentMode());
        }
        if ("plg".equals(createdLayer)) {
            String pluginId = id;
            Optional<SolutionPluginInfo> findAny = solutions.values().stream().flatMap(s -> s.getPluginInfos().stream()).filter(p -> p.getPluginId().equals(pluginId)).findAny();
            if (!findAny.isPresent()) {
                return false;
            }
            return SolutionPluginDeploymentMode.Source.equals((Object)findAny.get().getDeploymentMode());
        }
        if ("ext".equals(createdLayer)) {
            if (!solutions.containsKey(id)) {
                return false;
            }
            SolutionExtInfo extInfo = solutions.get(id).getExtInfo();
            if (extInfo == null) {
                return false;
            }
            return SolutionExtensionDeploymentMode.Source.equals((Object)extInfo.getDeploymentMode());
        }
        return false;
    }

    private void compare() {
        this.leftTree.removeAll();
        this.rightTree.removeAll();
        this.leftTreeItems = new HashMap<String, TreeItem>();
        this.rightTreeItems = new HashMap<String, TreeItem>();
        try {
            this.buildTree(this.leftGOT, this.leftTree, this.leftTreeItems);
            this.buildTree(this.rightGOT, this.rightTree, this.rightTreeItems);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private void buildTree(GOTNode node, Tree tree, Map<String, TreeItem> bindItems) throws DocumentException, VTDException {
        TreeItem rootItem = new TreeItem(tree, 0);
        String sourceName = node.getAttributeValue("name");
        rootItem.setText(sourceName);
        rootItem.setImage(Images.getIcon(String.format("%s.png", node.getNodeType())));
        Document nodeXML = DocumentHelper.parseText((String)node.asXML());
        List childNodes = new ArrayList();
        if (node.getNodeType().equals("Menu")) {
            childNodes = nodeXML.getRootElement().elements();
        } else if (node.getNodeType().equals("FormDesign")) {
            childNodes = nodeXML.getRootElement().element(node.getNodeType()).elements();
        } else {
            throw new ERPException(String.format("\u4e0d\u652f\u6301\u5bf9\u6bd4\u3010%s\u3011\u8282\u70b9", node.getNodeType()));
        }
        for (Element childNode : childNodes) {
            this.buildChild(childNode, rootItem, bindItems);
        }
        rootItem.setExpanded(true);
        String id = node.getId();
        if (StringUtils.isBlank((String)id)) {
            id = node.getNodeType();
        }
        rootItem.setData("id", (Object)id);
    }

    private void buildChild(Element node, TreeItem parent, Map<String, TreeItem> bindItems) throws VTDException {
        if (node.getName().equals("Properties")) {
            return;
        }
        String id = node.attributeValue("id");
        if (StringUtils.isBlank((String)id)) {
            id = node.getName();
        }
        if (!this.isInScope(node)) {
            return;
        }
        TreeItem nodeItem = new TreeItem(parent, 0);
        String name = node.attributeValue("name");
        if (node.getName().equals("FormItem")) {
            name = String.valueOf(node.attributeValue("type")) + "::" + name;
        }
        nodeItem.setText(name);
        if (this.extraKeysInMap.contains(id)) {
            nodeItem.setImage(this.deleteImage);
        } else if (this.missingKeysInMap.contains(id)) {
            nodeItem.setImage(this.addImg);
        } else if (this.orderKeysInMap.contains(id)) {
            nodeItem.setImage(this.ordImage);
        } else {
            nodeItem.setImage(Images.getIcon(String.format("%s.png", node.getName())));
        }
        List childNodes = node.elements();
        for (Element childNode : childNodes) {
            this.buildChild(childNode, nodeItem, bindItems);
        }
        nodeItem.setExpanded(true);
        nodeItem.setData("id", (Object)id);
        nodeItem.setData((Object)node);
        bindItems.put(id, nodeItem);
    }

    private boolean isInScope(Element node) {
        String id = node.attributeValue("id");
        if (StringUtils.isBlank((String)id)) {
            id = node.getName();
        }
        if (this.isInScope(id)) {
            return true;
        }
        List childNodes = node.elements();
        for (Element childNode : childNodes) {
            if (!this.isInScope(childNode)) continue;
            return true;
        }
        return false;
    }

    private boolean isInScope(String id) {
        return !this.filterButton.getSelection() || this.orderKeysInMap.contains(id) || this.extraKeysInMap.contains(id) || this.missingKeysInMap.contains(id);
    }

    public void open() {
        this.createContent();
        this.shell.open();
        Display display = this.shell.getDisplay();
        while (!this.shell.isDisposed()) {
            if (display.readAndDispatch()) continue;
            display.sleep();
        }
    }
}

