/*
 * Decompiled with CFR 0.152.
 */
package gongqi.gdt.designer.utils;

import gongqi.erp.framework.core.LayerDeploymentMode;
import gongqi.gdt.designer.utils.LayerJavaMethod;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.eclipse.jdt.core.dom.ASTParser;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.dom.MethodDeclaration;
import org.eclipse.jdt.core.dom.TypeDeclaration;

public class LayerJavaCode {
    private String layerName;
    private LayerDeploymentMode deploymentMode;
    private JavaType javaType;
    private String content;
    private String javaPackagePath;
    private String simpleName;
    private List<LayerJavaMethod> layerJavaMethods = new ArrayList<LayerJavaMethod>();

    public String getLayerName() {
        return this.layerName;
    }

    public void setLayerName(String layerName) {
        this.layerName = layerName;
    }

    public LayerDeploymentMode getDeploymentMode() {
        return this.deploymentMode;
    }

    public void setDeploymentMode(LayerDeploymentMode deploymentMode) {
        this.deploymentMode = deploymentMode;
    }

    public List<LayerJavaMethod> getLayerJavaMethods() {
        return this.layerJavaMethods;
    }

    public JavaType getJavaType() {
        return this.javaType;
    }

    public void setJavaType(JavaType javaType) {
        this.javaType = javaType;
    }

    public String getContent() {
        return this.content;
    }

    public void setContent(String content) {
        MethodDeclaration[] methodDeclarations;
        this.content = content;
        this.layerJavaMethods = new ArrayList<LayerJavaMethod>();
        MethodDeclaration[] methodDeclarationArray = methodDeclarations = this.compilationCode(content);
        int n = methodDeclarations.length;
        int n2 = 0;
        while (n2 < n) {
            MethodDeclaration methodDeclaration = methodDeclarationArray[n2];
            LayerJavaMethod layerJavaMethod = new LayerJavaMethod(this, methodDeclaration, content);
            this.layerJavaMethods.add(layerJavaMethod);
            ++n2;
        }
    }

    public String getJavaPackagePath() {
        return this.javaPackagePath;
    }

    public void setJavaPackagePath(String javaPackagePath) {
        this.javaPackagePath = javaPackagePath;
    }

    public String getSimpleName() {
        return this.simpleName;
    }

    public void setSimpleName(String simpleName) {
        this.simpleName = simpleName;
    }

    public boolean containMethod(String signature) {
        return this.layerJavaMethods.stream().filter(m -> m.getSignature().equals(signature)).findAny().isPresent();
    }

    private MethodDeclaration[] compilationCode(String codeText) {
        if (StringUtils.isBlank((String)codeText)) {
            return new MethodDeclaration[0];
        }
        ASTParser p = ASTParser.newParser((int)4);
        p.setKind(8);
        p.setSource(codeText.toCharArray());
        p.setResolveBindings(true);
        CompilationUnit compilationUnit = (CompilationUnit)p.createAST(null);
        this.javaPackagePath = compilationUnit.getPackage().toString();
        TypeDeclaration typeDeclaration = (TypeDeclaration)compilationUnit.types().get(0);
        return typeDeclaration.getMethods();
    }

    public static enum JavaType {
        Table,
        Form,
        DataSource,
        Class;

    }
}

