/*
 * Decompiled with CFR 0.152.
 */
package gongqi.gdt.designer.utils;

import gongqi.gdt.designer.utils.LayerJavaCode;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.lang.StringUtils;
import org.eclipse.jdt.core.dom.MethodDeclaration;

public class LayerJavaMethod {
    private LayerJavaCode parent;
    private String signature;
    private MethodDeclaration methodDeclaration;
    private String content;

    public LayerJavaMethod(LayerJavaCode parent, MethodDeclaration methodDeclaration, String sourceCode) {
        this.parent = parent;
        this.methodDeclaration = methodDeclaration;
        this.signature = this.initMethodSignature();
        this.content = this.formatCode(sourceCode.substring(methodDeclaration.getStartPosition(), methodDeclaration.getStartPosition() + methodDeclaration.getLength()));
    }

    private String initMethodSignature() {
        List parameters = this.methodDeclaration.parameters();
        String params = parameters.stream().map(p -> p.getType().toString()).collect(Collectors.joining(", "));
        return String.format("%s(%s)", this.methodDeclaration.getName(), params);
    }

    public LayerJavaCode getParent() {
        return this.parent;
    }

    public String getSignature() {
        return this.signature;
    }

    public MethodDeclaration getMethodDeclaration() {
        return this.methodDeclaration;
    }

    public String getContent() {
        return this.content;
    }

    private String formatCode(String originCode) {
        String[] lines = originCode.split("\r?\n");
        if (lines.length <= 1 || !lines[0].startsWith("@") && !lines[0].startsWith("/*")) {
            return originCode;
        }
        int indent = 0;
        int i = 1;
        while (i < lines.length) {
            String line = lines[i];
            if (!StringUtils.isBlank((String)line)) {
                line = line.replace("\t", "    ");
                indent = this.countLeadingSpaces(line);
                break;
            }
            ++i;
        }
        if (indent < 1) {
            return originCode;
        }
        StringBuilder formatString = new StringBuilder();
        formatString.append(lines[0]).append(System.lineSeparator());
        int i2 = 1;
        while (i2 < lines.length) {
            String line = lines[i2];
            int countLeadingSpaces = this.countLeadingSpaces(line = line.replace("\t", "    "));
            formatString.append(line.substring(indent < countLeadingSpaces ? indent : countLeadingSpaces)).append(System.lineSeparator());
            ++i2;
        }
        return formatString.toString();
    }

    private int countLeadingSpaces(String text) {
        int leadingSpaces = 0;
        int index = 0;
        while (index < text.length() && Character.isWhitespace(text.charAt(index))) {
            if (text.charAt(index) == ' ') {
                ++leadingSpaces;
            }
            ++index;
        }
        return leadingSpaces;
    }
}

