/*
 * Decompiled with CFR 0.152.
 */
package info.gongqi.got.tool;

import com.ximpleware.VTDException;
import gongqi.designer.got.vtd.EntityNode;
import gongqi.designer.got.vtd.GOTNode;
import gongqi.designer.got.vtd.NodeProperty;
import gongqi.erp.framework.core.LayerDefination;
import gongqi.erp.framework.core.LayerDefinationManager;
import gongqi.erp.framework.core.ObjectContainer;
import gongqi.erp.framework.core.extension.SolutionExtensionDefinition;
import gongqi.erp.framework.core.extension.SolutionExtensionDefinitionManager;
import gongqi.erp.framework.core.plugin.SolutionPluginDefinition;
import gongqi.erp.framework.core.plugin.SolutionPluginDefinitionManager;
import gongqi.erp.framework.core.solution.SolutionDefinition;
import gongqi.erp.framework.core.solution.SolutionDefinitionManager;
import gongqi.erp.gotmodel.core.EntityType;
import gongqi.gdt.designer.utils.Images;
import gongqi.gdt.designer.utils.SWTUtils;
import info.gongqi.got.model.GotXmlDto;
import info.gongqi.got.tool.FormDataSyn;
import info.gongqi.got.tool.ImageButton;
import info.gongqi.got.ui.ConfigComposite;
import info.gongqi.got.ui.TreeUi;
import info.gongqi.got.util.ComposeIMG;
import info.gongqi.got.util.GOTMessageDialog;
import java.io.IOException;
import java.lang.invoke.LambdaMetafactory;
import java.math.BigDecimal;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolItem;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;

public class PromoteSyncDialog {
    private Shell shell;
    private Label windowTitle;
    private Tree leftTree;
    private Table propertyTables;
    private ToolItem filterButton;
    private Set<String> addNodes;
    private Set<String> deleteNodes;
    private Map<String, String> renameNodes;
    private Image addImg = Images.getIcon("layerUpgrade/Add.png", SWTUtils.zoom(16), SWTUtils.zoom(16));
    private Image deleteImage = Images.getIcon("layerUpgrade/Delete.png", SWTUtils.zoom(16), SWTUtils.zoom(16));
    private EntityNode entity;

    public PromoteSyncDialog(EntityNode entity) {
        this.entity = entity.clone();
        try {
            this.init();
        }
        catch (Exception e) {
            throw new RuntimeException("\u521d\u59cb\u5316\u5931\u8d25", e);
        }
    }

    private void init() throws VTDException, IOException {
        this.addNodes = new HashSet<String>();
        this.deleteNodes = new HashSet<String>();
        this.renameNodes = new HashMap<String, String>();
        String modifiedLayer = this.entity.getModifiedLayer();
        String id = this.entity.getId();
        EntityType type = EntityType.valueOf((String)this.entity.getNodeType());
        LayerDefination currentLayer = ((LayerDefinationManager)ObjectContainer.getInstance(LayerDefinationManager.class)).getLayer(this.entity.getCreatedLayer());
        while (currentLayer != null) {
            SolutionPluginDefinition plugin2;
            EntityNode entityNode;
            String currentEntity;
            String solutionId;
            String layerName = currentLayer.getLayerName();
            if (layerName.equals(modifiedLayer) || currentLayer.getUpperLayer().equals("Gongqi_ERP_No_More_Layer")) break;
            if (layerName.equals("app")) {
                if (id.contains(".")) {
                    solutionId = id.substring(0, id.lastIndexOf("."));
                    SolutionDefinition solution = ((SolutionDefinitionManager)ObjectContainer.getInstance(SolutionDefinitionManager.class)).getSolution(solutionId);
                    if (solution != null && StringUtils.isNotBlank((String)(currentEntity = (String)solution.getEntityDocumentMap(type).get(id)))) {
                        entityNode = EntityNode.parse((String)currentEntity);
                        this.analysis(solutionId, entityNode);
                    }
                }
            } else if (layerName.equals("plg")) {
                if (id.contains(".")) {
                    solutionId = id.substring(0, id.lastIndexOf("."));
                    List plugins = ((SolutionPluginDefinitionManager)ObjectContainer.getInstance(SolutionPluginDefinitionManager.class)).getSolutionPlugins(solutionId);
                    if (!plugins.isEmpty()) {
                        for (SolutionPluginDefinition plugin2 : plugins) {
                            String currentEntity2 = (String)plugin2.getSolutionEntityDocuments(type).get(id);
                            if (!StringUtils.isNotBlank((String)currentEntity2)) continue;
                            EntityNode entityNode2 = EntityNode.parse((String)currentEntity2);
                            this.analysis(plugin2.getName(), entityNode2);
                        }
                    } else {
                        String currentEntity3;
                        plugin2 = ((SolutionPluginDefinitionManager)ObjectContainer.getInstance(SolutionPluginDefinitionManager.class)).getSolutionPlugin(solutionId);
                        if (plugin2 != null && StringUtils.isNotBlank((String)(currentEntity3 = (String)plugin2.getEntityDocumentMap(type).get(id)))) {
                            EntityNode entityNode3 = EntityNode.parse((String)currentEntity3);
                            this.analysis(plugin2.getName(), entityNode3);
                        }
                    }
                }
            } else if (layerName.equals("ext")) {
                if (id.contains(".")) {
                    solutionId = id.substring(0, id.lastIndexOf("."));
                    SolutionExtensionDefinition extension = null;
                    if (this.entity.getCreatedLayer().equals("plg")) {
                        plugin2 = ((SolutionPluginDefinitionManager)ObjectContainer.getInstance(SolutionPluginDefinitionManager.class)).getSolutionPlugin(solutionId);
                        if (plugin2 != null) {
                            extension = ((SolutionExtensionDefinitionManager)ObjectContainer.getInstance(SolutionExtensionDefinitionManager.class)).getSolutionExtension(plugin2.getSolutionName());
                        }
                    } else if (this.entity.getCreatedLayer().equals("app")) {
                        extension = ((SolutionExtensionDefinitionManager)ObjectContainer.getInstance(SolutionExtensionDefinitionManager.class)).getSolutionExtension(solutionId);
                    }
                    if (extension != null && StringUtils.isNotBlank((String)(currentEntity = (String)extension.getEntityDocumentMap(type).get(id)))) {
                        entityNode = EntityNode.parse((String)currentEntity);
                        this.analysis(solutionId, entityNode);
                    }
                }
            } else {
                LayerDefination layer = ((LayerDefinationManager)ObjectContainer.getInstance(LayerDefinationManager.class)).getLayer(layerName);
                String currentEntity4 = (String)layer.getEntityDocumentMap(type).get(id);
                if (StringUtils.isNotBlank((String)currentEntity4)) {
                    EntityNode entityNode4 = EntityNode.parse((String)currentEntity4);
                    this.analysis("", entityNode4);
                }
            }
            currentLayer = ((LayerDefinationManager)ObjectContainer.getInstance(LayerDefinationManager.class)).getLayer(currentLayer.getUpperLayer());
        }
    }

    private void createContent() {
        Display display = Display.getCurrent();
        this.shell = new Shell(display.getActiveShell(), 24);
        this.shell.setBackground(new Color((Device)this.shell.getDisplay(), 255, 255, 255));
        this.shell.setLayout((Layout)new FormLayout());
        final Rectangle bounds = Display.getDefault().getPrimaryMonitor().getBounds();
        Rectangle rect = this.shell.getBounds();
        int x = bounds.x + (bounds.width - rect.width) / 2;
        int y = bounds.y + (bounds.height - rect.height) / 2;
        this.shell.setLocation(x, y);
        int hight = SWTUtils.zoom(555);
        int phight = GOTMessageDialog.shell.getBounds().height;
        if (hight > phight) {
            hight = (int)((double)phight * 0.9);
        }
        hight = new BigDecimal(hight).divide(ConfigComposite.configComposite.DPIZOOM, 1).intValue();
        this.shell.setSize(SWTUtils.zoom(625), hight);
        Composite composite = new Composite((Composite)this.shell, 2048);
        FormData formData = new FormData();
        formData.top = new FormAttachment(0);
        formData.bottom = new FormAttachment(100);
        formData.left = new FormAttachment(0);
        formData.right = new FormAttachment(100);
        composite.setLayoutData((Object)formData);
        composite.setLayout((Layout)new FormLayout());
        composite.setBackground(new Color((Device)this.shell.getDisplay(), 255, 255, 255));
        ImageButton buttonClose = new ImageButton(composite, Images.getImage("/window_close.png"), Images.getImage("window_close_hover.png"));
        buttonClose.setBackground(new Color((Device)this.shell.getDisplay(), 255, 255, 255));
        formData = new FormData();
        formData.top = new FormAttachment(0);
        formData.right = new FormAttachment(100, SWTUtils.zoom(-5));
        buttonClose.setLayoutData(formData);
        buttonClose.addSelectionListener(SelectionListener.widgetSelectedAdapter(e -> this.shell.close()));
        this.windowTitle = new Label(composite, 0);
        this.windowTitle.setBackground(new Color((Device)this.shell.getDisplay(), 255, 255, 255));
        FontData data = this.windowTitle.getFont().getFontData()[0];
        data.setStyle(1);
        this.windowTitle.setFont(new Font((Device)this.shell.getDisplay(), data));
        formData = new FormData();
        formData.top = new FormAttachment(0, SWTUtils.zoom(5));
        formData.bottom = new FormAttachment((Control)buttonClose, SWTUtils.zoom(5), 1024);
        formData.left = new FormAttachment(0, SWTUtils.zoom(10));
        formData.right = new FormAttachment(100, SWTUtils.zoom(-10));
        this.windowTitle.setLayoutData((Object)formData);
        Listener listener = new Listener(){
            private int startX;
            private int startY;

            public void handleEvent(Event e) {
                if (e.type == 3 && e.button == 1) {
                    this.startX = e.x;
                    this.startY = e.y;
                }
                if (e.type == 5 && (e.stateMask & 0x80000) != 0) {
                    Point p = PromoteSyncDialog.this.shell.toDisplay(e.x, e.y);
                    p.x -= this.startX;
                    p.y -= this.startY;
                    int parentX = Display.getDefault().getBounds().x;
                    int parentY = Display.getDefault().getBounds().y;
                    if (p.x <= parentX + 10 || p.y <= parentY + 110 || p.x + ((PromoteSyncDialog)PromoteSyncDialog.this).shell.getBounds().width >= parentX + bounds.width - 10 || p.y + ((PromoteSyncDialog)PromoteSyncDialog.this).shell.getBounds().height >= parentY + bounds.height - 10) {
                        return;
                    }
                    PromoteSyncDialog.this.shell.setLocation(p);
                }
            }
        };
        this.windowTitle.addListener(3, listener);
        this.windowTitle.addListener(5, listener);
        ToolBar toolBar = new ToolBar(composite, 0x804040);
        formData = new FormData();
        formData.bottom = new FormAttachment(100, SWTUtils.zoom(-5));
        formData.left = new FormAttachment(0, SWTUtils.zoom(5));
        toolBar.setLayoutData((Object)formData);
        this.filterButton = new ToolItem(toolBar, 131104);
        this.filterButton.setImage(Images.getIcon("layerUpgrade/filter.png", SWTUtils.zoom(16), SWTUtils.zoom(16)));
        this.filterButton.setToolTipText("\u4ec5\u663e\u793a\u5dee\u5f02");
        this.filterButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                try {
                    PromoteSyncDialog.this.buildTree();
                }
                catch (VTDException e1) {
                    throw new RuntimeException(e1);
                }
            }
        });
        this.filterButton.setSelection(true);
        SashForm mainComposite = new SashForm(composite, 256);
        formData = new FormData();
        formData.left = new FormAttachment(0, SWTUtils.zoom(5));
        formData.right = new FormAttachment(100, SWTUtils.zoom(-5));
        formData.top = new FormAttachment((Control)this.windowTitle, SWTUtils.zoom(2));
        formData.bottom = new FormAttachment(100, SWTUtils.zoom(-35));
        mainComposite.setLayoutData((Object)formData);
        mainComposite.setLayout((Layout)new FormLayout());
        this.leftTree = new Tree((Composite)mainComposite, 67840);
        Font font = new Font((Device)this.leftTree.getDisplay(), "\u5b8b\u4f53", 9, 0);
        this.leftTree.setFont(font);
        this.propertyTables = new Table((Composite)mainComposite, 67588);
        this.propertyTables.setLinesVisible(true);
        this.propertyTables.setHeaderVisible(true);
        this.propertyTables.addControlListener(new ControlListener(){

            public void controlResized(ControlEvent e) {
                Rectangle bound = PromoteSyncDialog.this.propertyTables.getBounds();
                TableColumn column = PromoteSyncDialog.this.propertyTables.getColumn(0);
                column.setWidth(bound.width / 2 - 5);
                column = PromoteSyncDialog.this.propertyTables.getColumn(1);
                column.setWidth(bound.width / 2);
            }

            public void controlMoved(ControlEvent e) {
            }
        });
        TableColumn name = new TableColumn(this.propertyTables, 0);
        name.setText("Name");
        name.setWidth(SWTUtils.zoom(150));
        TableColumn value = new TableColumn(this.propertyTables, 0);
        value.setText("Value");
        value.setWidth(SWTUtils.zoom(150));
        this.leftTree.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                TreeItem select = PromoteSyncDialog.this.leftTree.getSelection()[0];
                GOTNode gotNode = (GOTNode)select.getData();
                if (gotNode == null) {
                    return;
                }
                PromoteSyncDialog.this.loadTable(gotNode);
            }
        });
        mainComposite.setWeights(new int[]{1, 1});
        Button confirm = new Button(composite, 0);
        formData = new FormData(SWTUtils.zoom(70), SWTUtils.zoom(30));
        formData.right = new FormAttachment(100, SWTUtils.zoom(-5));
        formData.bottom = new FormAttachment(100, SWTUtils.zoom(-2));
        confirm.setText("\u786e\u8ba4");
        confirm.setLayoutData((Object)formData);
        confirm.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                try {
                    PromoteSyncDialog.this.confirm();
                }
                catch (Exception e1) {
                    Logger.getLogger(((Object)((Object)this)).getClass()).error((Object)"\u7ed3\u6784\u540c\u6b65\u5931\u8d25", (Throwable)e1);
                }
            }
        });
        Button cancel = new Button(composite, 0);
        formData = new FormData(SWTUtils.zoom(70), SWTUtils.zoom(30));
        formData.right = new FormAttachment((Control)confirm, SWTUtils.zoom(-10), 16384);
        formData.bottom = new FormAttachment((Control)confirm, 0, 1024);
        cancel.setText("\u53d6\u6d88");
        cancel.setLayoutData((Object)formData);
        cancel.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                PromoteSyncDialog.this.shell.close();
            }
        });
        try {
            this.buildTree();
        }
        catch (Exception e2) {
            throw new RuntimeException("\u7ed8\u5236\u5bf9\u6bd4\u7ed3\u679c\u65f6\u51fa\u73b0\u5f02\u5e38", e2);
        }
    }

    private void confirm() throws VTDException, IOException {
        EntityNode clone = this.entity.clone();
        List childNodes = clone.getChildNodeBFS(true);
        Map<String, GOTNode> nodes = childNodes.stream().collect(Collectors.toMap(n -> {
            if (StringUtils.isNotBlank((String)n.getId())) {
                return n.getId();
            }
            return n.getNodeType();
        }, n -> n));
        for (String id : nodes.keySet()) {
            GOTNode gotNode;
            if (this.deleteNodes.contains(id)) {
                gotNode = nodes.get(id);
                gotNode.remove();
                clone.applyModifier();
                continue;
            }
            if (!this.renameNodes.containsKey(id)) continue;
            gotNode = nodes.get(id);
            gotNode.setName(this.renameNodes.get(id));
            clone.applyModifier();
        }
        GotXmlDto.getInstance().updateEntityElement(clone.toElement());
        FormDataSyn.restore(clone.getId());
        this.shell.close();
    }

    private void loadTable(GOTNode gotNode) {
        this.windowTitle.setText("");
        this.propertyTables.removeAll();
        Rectangle bound = this.propertyTables.getBounds();
        TableColumn column = this.propertyTables.getColumn(0);
        column.setWidth(bound.width / 2 - 5);
        column = this.propertyTables.getColumn(1);
        column.setWidth(bound.width / 2);
        try {
            String tip = "name=" + gotNode.getName() + " createLayer=" + gotNode.getCreatedLayer() + " modifiedLayer=" + gotNode.getModifiedLayer();
            if (gotNode.hasAttribute("type")) {
                tip = String.valueOf(tip) + " type=" + gotNode.getAttributeValue("type");
            }
            this.windowTitle.setText(tip);
            List propertys = gotNode.getPropertys();
            for (NodeProperty property : propertys) {
                TableItem tableItem = new TableItem(this.propertyTables, 0);
                tableItem.setText(new String[]{property.getName(), property.getValue()});
            }
        }
        catch (VTDException e) {
            Logger.getLogger(this.getClass()).error((Object)"\u52a0\u8f7d\u8282\u70b9\u5c5e\u6027\u65f6\u51fa\u73b0\u5f02\u5e38", (Throwable)e);
        }
    }

    /*
     * Unable to fully structure code
     */
    private void analysis(String layerId, EntityNode leftGOT) throws VTDException, IOException {
        childNodes = leftGOT.getChildNodeBFS(true);
        leftItems = childNodes.stream().collect(Collectors.toMap((Function<GOTNode, String>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, lambda$3(gongqi.designer.got.vtd.GOTNode ), (Lgongqi/designer/got/vtd/GOTNode;)Ljava/lang/String;)(), (Function<GOTNode, GOTNode>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, lambda$4(gongqi.designer.got.vtd.GOTNode ), (Lgongqi/designer/got/vtd/GOTNode;)Lgongqi/designer/got/vtd/GOTNode;)()));
        block0: for (String id : leftItems.keySet()) {
            block5: {
                leftNode = leftItems.get(id);
                rightNode = this.entity.selectSingleNode(leftNode.getEntityXPath());
                if (rightNode != null) break block5;
                this.addNodes.add(id);
                prevSiblingNode = leftNode.getPrevSiblingNode();
                if (prevSiblingNode != null) ** GOTO lbl27
                sourceParent = this.entity.getChildNode(leftNode.getParent().getId());
                if (sourceParent == null) {
                    sourceParent = this.entity.selectSingleNode(leftNode.getParent().getEntityXPath());
                }
                sourceParent.insertAfterHead(leftNode.dumpFragment());
                this.entity.applyModifier();
                continue;
lbl-1000:
                // 1 sources

                {
                    sourcePrevSiblingNode = this.entity.getChildNode(prevSiblingNode.getId());
                    if (sourcePrevSiblingNode != null) {
                        sourcePrevSiblingNode.insertAfterElement(leftNode.dumpFragment());
                        this.entity.applyModifier();
                        continue block0;
                    }
                    if ((prevSiblingNode = prevSiblingNode.getPrevSiblingNode()) != null) continue;
                    sourceParent = this.entity.getChildNode(leftNode.getParent().getId());
                    sourceParent.insertAfterHead(leftNode.dumpFragment());
                    this.entity.applyModifier();
                    continue block0;
lbl27:
                    // 2 sources

                    ** while (prevSiblingNode != null)
                }
lbl28:
                // 1 sources

                continue;
            }
            if (leftNode.getName().equals(rightNode.getName())) continue;
            this.renameNodes.put(id, leftNode.getName());
        }
        childNodes = this.entity.getChildNodeBFS(true);
        rightItems = childNodes.stream().collect(Collectors.toMap((Function<GOTNode, String>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, lambda$5(gongqi.designer.got.vtd.GOTNode ), (Lgongqi/designer/got/vtd/GOTNode;)Ljava/lang/String;)(), (Function<GOTNode, GOTNode>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, lambda$6(gongqi.designer.got.vtd.GOTNode ), (Lgongqi/designer/got/vtd/GOTNode;)Lgongqi/designer/got/vtd/GOTNode;)()));
        for (String id : rightItems.keySet()) {
            if (leftItems.containsKey(id) || !(right = rightItems.get(id)).getCreatedLayer().equals(leftGOT.getModifiedLayer()) || !right.getCreatedLayer().equals("plg") || !id.startsWith(layerId)) continue;
            this.deleteNodes.add(id);
        }
    }

    private void buildTree() throws VTDException {
        this.leftTree.removeAll();
        TreeItem rootItem = new TreeItem(this.leftTree, 0);
        rootItem.setText(this.entity.getName());
        rootItem.setImage(ComposeIMG.drawImg((GOTNode)this.entity));
        List childNodes = this.entity.getChildNodeBFS(false);
        for (GOTNode childNode : childNodes) {
            this.buildChild(childNode, rootItem);
        }
        rootItem.setExpanded(true);
        rootItem.setData((Object)this.entity);
        this.leftTree.setSelection(rootItem);
        this.loadTable((GOTNode)this.entity);
    }

    private void buildChild(GOTNode node, TreeItem parent) throws VTDException {
        String id = node.getId();
        if (StringUtils.isBlank((String)id)) {
            id = node.getNodeType();
        }
        if (!this.isInScope(node)) {
            return;
        }
        TreeItem nodeItem = new TreeItem(parent, 0);
        if (this.addNodes.contains(id)) {
            nodeItem.setImage(this.addImg);
        } else if (this.deleteNodes.contains(id)) {
            nodeItem.setImage(this.deleteImage);
        } else {
            nodeItem.setImage(ComposeIMG.drawImg(node));
        }
        TreeUi.setTreeItemFont(node, nodeItem);
        String name = node.getName();
        if (node.getNodeType().equals("FormItem")) {
            name = String.valueOf(node.getAttributeValue("type")) + "::" + name;
        }
        if (this.renameNodes.containsKey(id)) {
            String newName = this.renameNodes.get(id);
            if (node.getNodeType().equals("FormItem")) {
                newName = String.valueOf(node.getAttributeValue("type")) + "::" + newName;
            }
            nodeItem.setText(String.valueOf(name) + " -> " + newName);
        } else {
            nodeItem.setText(name);
        }
        List childNodes = node.getChildNodeBFS(false);
        for (GOTNode childNode : childNodes) {
            this.buildChild(childNode, nodeItem);
        }
        nodeItem.setExpanded(true);
        nodeItem.setData((Object)node);
    }

    private boolean isInScope(GOTNode node) throws VTDException {
        String id = node.getId();
        if (StringUtils.isBlank((String)id)) {
            id = node.getNodeType();
        }
        if (this.isInScope(id)) {
            return true;
        }
        List childNodes = node.getChildNodeBFS(false);
        for (GOTNode childNode : childNodes) {
            if (!this.isInScope(childNode)) continue;
            return true;
        }
        return false;
    }

    private boolean isInScope(String id) {
        return !this.filterButton.getSelection() || this.addNodes.contains(id) || this.deleteNodes.contains(id) || this.deleteNodes.contains(id);
    }

    public void open() {
        this.createContent();
        this.shell.open();
        Display display = this.shell.getDisplay();
        while (!this.shell.isDisposed()) {
            if (display.readAndDispatch()) continue;
            display.sleep();
        }
    }

    private static /* synthetic */ String lambda$3(GOTNode n) {
        if (StringUtils.isNotBlank((String)n.getId())) {
            return n.getId();
        }
        return n.getNodeType();
    }

    private static /* synthetic */ GOTNode lambda$4(GOTNode n) {
        return n;
    }

    private static /* synthetic */ String lambda$5(GOTNode n) {
        if (StringUtils.isNotBlank((String)n.getId())) {
            return n.getId();
        }
        return n.getNodeType();
    }

    private static /* synthetic */ GOTNode lambda$6(GOTNode n) {
        return n;
    }
}

