/*
 * Decompiled with CFR 0.152.
 */
package gongqi.gdt.designer;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.log4j.Logger;

public class MethodCostMonitor {
    private static Logger log = Logger.getLogger(MethodCostMonitor.class);
    private static final ConcurrentHashMap<String, AtomicLong> methodMaps = new ConcurrentHashMap();
    private static final List<AtomicLong> costTimes = new ArrayList<AtomicLong>();

    public static void addTime(String methodName, long time) {
        long cost = System.currentTimeMillis() - time;
        AtomicLong totalTime = methodMaps.get(methodName);
        if (totalTime != null) {
            totalTime.addAndGet(cost);
        } else {
            methodMaps.putIfAbsent(methodName, new AtomicLong(cost));
        }
    }

    public static void remarkTime(long time) {
        long cost = System.currentTimeMillis() - time;
        costTimes.add(new AtomicLong(cost));
    }

    public static Long getTotalTime(String methodName) {
        AtomicLong totalTime = methodMaps.get(methodName);
        return totalTime != null ? Long.valueOf(totalTime.get()) : null;
    }

    public static void printAllMethods() {
        System.out.println("Printing all monitored methods and their cumulative execution times (sorted by method name):");
        ArrayList<Map.Entry<String, AtomicLong>> sortedEntries = new ArrayList<Map.Entry<String, AtomicLong>>(methodMaps.entrySet());
        sortedEntries.stream().sorted(Map.Entry.comparingByKey()).forEach(entry -> log.info((Object)String.format("Method: %-30s Total Time(ns): %,12d", entry.getKey(), ((AtomicLong)entry.getValue()).get())));
        log.info((Object)("\u65b9\u6cd5\u6267\u884c\u4e86" + costTimes.size()));
        for (AtomicLong entry2 : costTimes) {
            if (entry2.get() <= 100L) continue;
            log.info((Object)entry2.get());
        }
        methodMaps.clear();
        costTimes.clear();
    }
}

