/*
 * Decompiled with CFR 0.152.
 */
package gongqi.gdt.designer.service;

import gongqi.erp.framework.core.LayerLocator;
import gongqi.erp.framework.core.ObjectContainer;
import gongqi.gdt.designer.ProjectConstants;
import gongqi.gdt.designer.ui.LayerChainPage;
import java.io.File;
import java.io.IOException;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileAttribute;
import java.util.HashSet;
import java.util.UUID;
import org.apache.commons.io.FileUtils;
import org.apache.log4j.Logger;
import org.eclipse.core.runtime.IProgressMonitor;

public class BackupService {
    private static Logger log = Logger.getLogger(BackupService.class);
    private File bakupDir = new File(LayerChainPage.getTempFileDir(), "Backup/" + UUID.randomUUID().toString());
    private File layersRoot;
    private File layerProject;

    public BackupService() {
        this.bakupDir.mkdirs();
    }

    public File getBackupLayersRoot() {
        return this.layersRoot;
    }

    public void backup(IProgressMonitor monitor) {
        try {
            monitor.subTask("\u6b63\u5728\u5907\u4efdlayers\u76ee\u5f55");
            log.info((Object)"\u6b63\u5728\u5907\u4efdlayers\u76ee\u5f55");
            this.layersRoot = ((LayerLocator)ObjectContainer.getInstance(LayerLocator.class)).getLayersRoot();
            FileUtils.copyDirectoryToDirectory((File)this.layersRoot, (File)this.bakupDir);
            monitor.worked(1);
            monitor.subTask("\u6b63\u5728\u5907\u4efdLayerProject\u76ee\u5f55");
            log.info((Object)"\u6b63\u5728\u5907\u4efdLayerProject\u76ee\u5f55");
            this.layerProject = new File(ProjectConstants.getBasePath(), "Project/Server/LayerProject");
            FileUtils.copyDirectoryToDirectory((File)this.layerProject, (File)this.bakupDir);
            monitor.worked(1);
        }
        catch (Exception e) {
            log.error((Object)"\u5907\u4efd\u5931\u8d25", (Throwable)e);
            throw new RuntimeException(e);
        }
    }

    public void restore() {
        try {
            log.info((Object)"\u6b63\u5728\u8fd8\u539flayers\u76ee\u5f55");
            this.replaceDir(String.valueOf(this.bakupDir.getAbsolutePath()) + "/layers", this.layersRoot.getAbsolutePath());
            log.info((Object)"\u6b63\u5728\u8fd8\u539fLayerProject\u76ee\u5f55");
            this.replaceDir(String.valueOf(this.bakupDir.getAbsolutePath()) + "/LayerProject", this.layerProject.getAbsolutePath());
        }
        catch (Exception e) {
            log.error((Object)"\u8fd8\u539f\u5931\u8d25", (Throwable)e);
            throw new RuntimeException(String.format("\u8fd8\u539f\u5931\u8d25\uff0c\u5907\u4efd\u76ee\u5f55\u3010%s\u3011", this.bakupDir.getAbsolutePath()), e);
        }
    }

    private void replaceDir(String sourceDirPath, String targetDirPath) {
        final HashSet backupFilesAndDirs = new HashSet();
        final HashSet targetFilesAndDirs = new HashSet();
        final Path sourceDir = Paths.get(sourceDirPath, new String[0]);
        final Path targetDir = Paths.get(targetDirPath, new String[0]);
        try {
            Files.walkFileTree(sourceDir, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

                @Override
                public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
                    Path targetPath = targetDir.resolve(sourceDir.relativize(file));
                    backupFilesAndDirs.add(targetPath);
                    return FileVisitResult.CONTINUE;
                }

                @Override
                public FileVisitResult preVisitDirectory(Path dir, BasicFileAttributes attrs) throws IOException {
                    Path targetPath = targetDir.resolve(sourceDir.relativize(dir));
                    backupFilesAndDirs.add(targetPath);
                    if (!Files.exists(targetPath, new LinkOption[0])) {
                        Files.createDirectories(targetPath, new FileAttribute[0]);
                    }
                    return FileVisitResult.CONTINUE;
                }
            });
            Files.walkFileTree(targetDir, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

                @Override
                public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
                    targetFilesAndDirs.add(file);
                    return FileVisitResult.CONTINUE;
                }

                @Override
                public FileVisitResult preVisitDirectory(Path dir, BasicFileAttributes attrs) throws IOException {
                    targetFilesAndDirs.add(dir);
                    return FileVisitResult.CONTINUE;
                }
            });
            for (Path backupFilePath : backupFilesAndDirs) {
                if (Files.isDirectory(backupFilePath, new LinkOption[0])) continue;
                Path relativePath = targetDir.relativize(backupFilePath);
                Path sourceFilePath = sourceDir.resolve(relativePath);
                try {
                    Files.copy(sourceFilePath, backupFilePath, StandardCopyOption.REPLACE_EXISTING);
                }
                catch (IOException e) {
                    log.error((Object)("\u6587\u4ef6\u66ff\u6362\u5931\u8d25\uff0c\u6587\u4ef6\u53ef\u80fd\u88ab\u5360\u7528\uff1a" + backupFilePath), (Throwable)e);
                }
            }
            Files.walkFileTree(targetDir, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

                @Override
                public FileVisitResult postVisitDirectory(Path dir, IOException exc) throws IOException {
                    if (exc == null && !dir.equals(targetDir) && !backupFilesAndDirs.contains(dir) && Files.list(dir).count() == 0L) {
                        try {
                            Files.delete(dir);
                        }
                        catch (IOException e) {
                            log.error((Object)("\u6587\u4ef6\u5939\u5220\u9664\u5931\u8d25\uff0c\u6587\u4ef6\u5939\u53ef\u80fd\u88ab\u5360\u7528 :" + dir), (Throwable)e);
                        }
                    }
                    return FileVisitResult.CONTINUE;
                }

                @Override
                public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
                    if (!backupFilesAndDirs.contains(file)) {
                        try {
                            Files.delete(file);
                        }
                        catch (IOException e) {
                            log.error((Object)("\u6587\u4ef6\u5220\u9664\u5931\u8d25\uff0c\u6587\u4ef6\u53ef\u80fd\u88ab\u5360\u7528: " + file), (Throwable)e);
                        }
                    }
                    return FileVisitResult.CONTINUE;
                }
            });
        }
        catch (IOException e) {
            log.error((Object)"\u6062\u590d\u5931\u8d25", (Throwable)e);
            throw new RuntimeException("\u5907\u4efd\u6062\u590d\u5931\u8d25", e);
        }
    }
}

