/*
 * Decompiled with CFR 0.152.
 */
package gongqi.gdt.designer.service.analysis;

import com.ximpleware.VTDException;
import gongqi.erp.framework.core.FrameworkEnvironment;
import gongqi.erp.framework.core.LayerDefination;
import gongqi.erp.framework.core.LayerDefinationManager;
import gongqi.erp.framework.core.LayerDeploymentMode;
import gongqi.erp.framework.core.ObjectContainer;
import gongqi.erp.framework.core.extension.SolutionExtensionDefinition;
import gongqi.erp.framework.core.extension.SolutionExtensionDeploymentMode;
import gongqi.erp.framework.core.plugin.SolutionPluginDefinition;
import gongqi.erp.framework.core.plugin.SolutionPluginDeploymentMode;
import gongqi.erp.framework.core.solution.SolutionDefinition;
import gongqi.erp.framework.core.solution.SolutionDeploymentMode;
import gongqi.erp.framework.util.FileUtils;
import gongqi.erp.gotmodel.core.EntityType;
import gongqi.gdt.designer.service.GOTModel;
import gongqi.gdt.designer.service.ProgressMonitor;
import gongqi.gdt.designer.service.analysis.Analysis;
import gongqi.gdt.designer.service.modify.ModifyLevel;
import gongqi.gdt.designer.service.modify.ModifyType;
import gongqi.gdt.designer.service.node.GOTEntity;
import gongqi.gdt.designer.service.node.GOTNode;
import gongqi.gdt.designer.service.node.GOTProperty;
import gongqi.gdt.designer.utils.LayerJavaCode;
import gongqi.gdt.designer.utils.LayerJavaMethod;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;

public abstract class BaseAnalysis
implements Analysis {
    protected Logger log = Logger.getLogger(this.getClass());
    private static List<String> ignoreAnalysisPropertys = Arrays.asList("CreatedDate", "CreatedTime", "CreatedBy", "ModifiedDate", "ModifiedTime", "ModifiedBy");
    protected GOTModel sourceGOT;
    protected GOTModel targetGOT;
    protected GOTModel originalTargetGOT;

    public BaseAnalysis(GOTModel sourceGOT, GOTModel targetGOT, GOTModel originalGOT) {
        this.sourceGOT = sourceGOT;
        this.targetGOT = targetGOT;
        this.originalTargetGOT = originalGOT;
    }

    @Override
    public void analysis(ProgressMonitor monitor) {
        EntityType entityType = this.getSupportEntityType();
        this.forwardAnalysis(this.targetGOT.getEntitys(entityType).values(), monitor);
        this.backwardAnalysis(this.sourceGOT.getEntitys(entityType).values(), monitor);
    }

    protected void forwardAnalysis(Collection<GOTEntity> entitys, ProgressMonitor monitor) {
        for (GOTEntity targetEntity : entitys) {
            monitor.worked(1, String.format("\u6b63\u5728\u5206\u6790%s\u3010%s\u3011...", targetEntity.getEntityType().name(), targetEntity.getName()));
            try {
                List<Element> modifyItems = this.analysisEntityNode(targetEntity);
                GOTEntity sourceEntity = this.sourceGOT.getEntityById(targetEntity.getEntityType(), targetEntity.getId());
                if (sourceEntity != null) {
                    modifyItems.addAll(this.analysisEntityInnerModify(sourceEntity, targetEntity));
                }
                if (modifyItems.size() <= 0) continue;
                Element entityResult = this.aggregationEntityResult(targetEntity, modifyItems);
                monitor.reportResult(entityResult);
            }
            catch (VTDException e) {
                this.log.warn((Object)String.format("\u5206\u6790%s\u5b9e\u4f53%s\u9519\u8bef", targetEntity.getEntityType().name(), targetEntity.getId()), (Throwable)e);
            }
        }
    }

    protected void backwardAnalysis(Collection<GOTEntity> entitys, ProgressMonitor monitor) {
        for (GOTEntity sourceEntity : entitys) {
            try {
                String solutionPluginName;
                String solutionName;
                if (sourceEntity.getCreatedLayer().equals(sourceEntity.getModifiedLayer())) {
                    SolutionExtensionDefinition extensionDefinition;
                    LayerDefination layerDefination;
                    if ("app".equals(sourceEntity.getCreatedLayer())) {
                        solutionName = sourceEntity.getId().substring(0, sourceEntity.getId().lastIndexOf("."));
                        SolutionDefinition solutionDefinition = this.sourceGOT.getSolutionDefinition(solutionName);
                        if (solutionDefinition.getDeploymentMode() == SolutionDeploymentMode.Source) {
                            continue;
                        }
                    } else if ("plg".equals(sourceEntity.getCreatedLayer())) {
                        String pluginName = sourceEntity.getId().substring(0, sourceEntity.getId().lastIndexOf("."));
                        SolutionPluginDefinition pluginDefinition = this.sourceGOT.getSolutionPluginDefinition(pluginName);
                        if (pluginDefinition.getDeploymentMode() == SolutionPluginDeploymentMode.Source) {
                            continue;
                        }
                    } else if (!"ext".equals(sourceEntity.getCreatedLayer()) ? (layerDefination = this.sourceGOT.getLayerDefination(sourceEntity.getCreatedLayer())).getDeploymentMode() == LayerDeploymentMode.Source : (extensionDefinition = this.sourceGOT.getSolutionExtensionDefinition(solutionName = sourceEntity.getId().substring(0, sourceEntity.getId().lastIndexOf(".")))).getDeploymentMode() == SolutionExtensionDeploymentMode.Source) continue;
                }
                if ("ent".equals(sourceEntity.getCreatedLayer()) || this.targetGOT.getLayerDefination(sourceEntity.getCreatedLayer()) == null || ("app".equals(sourceEntity.getCreatedLayer()) ? this.targetGOT.getSolutionDefinition(solutionName = sourceEntity.getId().substring(0, sourceEntity.getId().lastIndexOf("."))) == null : ("plg".equals(sourceEntity.getCreatedLayer()) ? this.targetGOT.getSolutionPluginDefinition(solutionPluginName = sourceEntity.getId().substring(0, sourceEntity.getId().lastIndexOf("."))) == null : "ext".equals(sourceEntity.getCreatedLayer()) && this.targetGOT.getSolutionExtensionDefinition(solutionName = sourceEntity.getId().substring(0, sourceEntity.getId().lastIndexOf("."))) == null))) continue;
                monitor.worked(1, String.format("\u6b63\u5728\u53cd\u5411\u5206\u6790%s\u3010%s\u3011...", sourceEntity.getEntityType().name(), sourceEntity.getName()));
                List<Element> modifyItems = this.analysisReverseEntityNode(sourceEntity);
                GOTEntity targetEntity = this.targetGOT.getEntityById(sourceEntity.getEntityType(), sourceEntity.getId());
                if (targetEntity != null) {
                    modifyItems.addAll(this.analysisEntityInnerDelete(sourceEntity, targetEntity));
                }
                if ((EntityType.Table.equals((Object)sourceEntity.getEntityType()) || EntityType.Form.equals((Object)sourceEntity.getEntityType()) || EntityType.Class.equals((Object)sourceEntity.getEntityType())) && this.ifHasMethodPromote(sourceEntity, this.sourceGOT)) {
                    modifyItems.add(this.createModifyItem(ModifyType.Entity_Promote, ModifyLevel.Notify, sourceEntity.getNodeType(), sourceEntity.getId(), null, String.format("\u5b58\u5728\u63d0\u5347\u7684\u65b9\u6cd5", new Object[0]), null, null));
                }
                if (modifyItems.size() <= 0) continue;
                Element entityResult = this.aggregationEntityResult(sourceEntity, modifyItems);
                monitor.reportResult(entityResult);
            }
            catch (VTDException e) {
                this.log.warn((Object)String.format("\u5206\u6790%s\u5b9e\u4f53%s\u9519\u8bef", sourceEntity.getEntityType().name(), sourceEntity.getId()), (Throwable)e);
            }
        }
    }

    protected List<Element> analysisEntityInnerModify(GOTEntity sourceEntity, GOTEntity targetEntity) throws VTDException {
        return Collections.EMPTY_LIST;
    }

    protected List<Element> analysisEntityInnerDelete(GOTEntity sourceEntity, GOTEntity targetEntity) throws VTDException {
        return Collections.EMPTY_LIST;
    }

    protected abstract EntityType getSupportEntityType();

    private List<Element> analysisEntityNode(GOTEntity targetEntity) throws VTDException {
        ArrayList<Element> modifyItems = new ArrayList<Element>();
        GOTEntity sourceEntity = this.sourceGOT.getEntityById(targetEntity.getEntityType(), targetEntity.getId());
        if (sourceEntity != null) {
            GOTEntity transitionEntity;
            if (!targetEntity.getName().equals(sourceEntity.getName())) {
                GOTEntity entity = this.sourceGOT.getEntityByName(targetEntity.getEntityType(), targetEntity.getName());
                if (entity != null && !entity.getId().equals(targetEntity.getId()) && this.sourceGOT.isSourceDeployment(entity.getCreatedLayer(), entity, null)) {
                    Element modifyItem = this.createModifyItem(ModifyType.Entity_Rename, ModifyLevel.Cannot, sourceEntity.getEntityType().name(), sourceEntity.getId(), null, String.format("\u5b9e\u4f53\u540d\u79f0\u4fee\u6539\u3010%s-->%s\u3011,\u4e0e\u3010%s\u3011\u5c42\u521b\u5efa\u5b9e\u4f53\u91cd\u540d\uff0c\u65e0\u6cd5\u5347\u7ea7", sourceEntity.getName(), targetEntity.getName(), targetEntity.getCreatedLayer()), entity.getId(), null);
                    modifyItems.add(modifyItem);
                } else if (this.sourceGOT.isSourceDeployment(sourceEntity.getModifiedLayer(), sourceEntity, null)) {
                    if (this.sourceGOT.getLayerDefination(sourceEntity.getModifiedLayer()).getDeploymentMode() == LayerDeploymentMode.Source) {
                        Element modifyItem = this.createModifyItem(ModifyType.Entity_Rename, ModifyLevel.Must, sourceEntity.getEntityType().name(), sourceEntity.getId(), null, String.format("\u5b9e\u4f53\u540d\u79f0\u4fee\u6539\u3010%s-->%s\u3011", sourceEntity.getName(), targetEntity.getName()), null, null);
                        modifyItems.add(modifyItem);
                    } else {
                        Element modifyItem = this.createModifyItem(ModifyType.Entity_Rename, ModifyLevel.Cannot, sourceEntity.getEntityType().name(), sourceEntity.getId(), null, String.format("\u5b9e\u4f53\u540d\u79f0\u4fee\u6539\u3010%s-->%s\u3011,\u4e0e\u3010%s\u3011\u5c42\u521b\u5efa\u5b9e\u4f53\u91cd\u540d\uff0c\u65e0\u6cd5\u5347\u7ea7", sourceEntity.getName(), targetEntity.getName(), targetEntity.getCreatedLayer()), null, null);
                        modifyItems.add(modifyItem);
                    }
                } else {
                    Element modifyItem = this.createModifyItem(ModifyType.Entity_Rename, ModifyLevel.Must, sourceEntity.getEntityType().name(), sourceEntity.getId(), null, String.format("\u5b9e\u4f53\u540d\u79f0\u4fee\u6539\u3010%s-->%s\u3011", sourceEntity.getName(), targetEntity.getName()), null, null);
                    modifyItems.add(modifyItem);
                }
            }
            if ((transitionEntity = this.originalTargetGOT.getEntityById(sourceEntity.getEntityType(), sourceEntity.getId())) != null) {
                modifyItems.addAll(this.analysisProperty(targetEntity, sourceEntity, transitionEntity));
            }
        } else {
            sourceEntity = this.sourceGOT.getEntityByName(targetEntity.getEntityType(), targetEntity.getName());
            if (sourceEntity != null) {
                LayerDefination layerDefination = this.targetGOT.getLayerDefination(sourceEntity.getCreatedLayer());
                GOTEntity entity = this.targetGOT.getEntityById(sourceEntity.getEntityType(), sourceEntity.getId());
                if (layerDefination != null && entity != null && this.sourceGOT.isSourceDeployment(sourceEntity.getModifiedLayer(), sourceEntity, null) || layerDefination == null && this.sourceGOT.isSourceDeployment(sourceEntity.getModifiedLayer(), sourceEntity, null) || !sourceEntity.getId().equals(targetEntity.getId()) && this.sourceGOT.isSourceDeployment(sourceEntity.getModifiedLayer(), sourceEntity, null)) {
                    Element modifyItem = this.createModifyItem(ModifyType.Entity_Add, ModifyLevel.Cannot, targetEntity.getEntityType().name(), targetEntity.getId(), null, String.format("\u65b0\u589e\u5b9e\u4f53\u8282\u70b9\uff0c\u4e0e\u3010%s\u3011\u5c42\u5b9e\u4f53\u8282\u70b9\u91cd\u540d\uff0c\u65e0\u6cd5\u5347\u7ea7", sourceEntity.getCreatedLayer()), null, null);
                    modifyItems.add(modifyItem);
                } else {
                    Element modifyItem = this.createModifyItem(ModifyType.Entity_Add, ModifyLevel.Must, targetEntity.getEntityType().name(), targetEntity.getId(), null, String.format("\u3010%s\u3011\u5c42\u65b0\u589e%s\u5b9e\u4f53\u8282\u70b9", targetEntity.getModifiedLayer(), targetEntity.getEntityType().name()), null, null);
                    modifyItems.add(modifyItem);
                }
            } else {
                Element modifyItem = this.createModifyItem(ModifyType.Entity_Add, ModifyLevel.Must, targetEntity.getEntityType().name(), targetEntity.getId(), null, String.format("\u3010%s\u3011\u5c42\u65b0\u589e%s\u3010 %s\u3011\u5b9e\u4f53\u8282\u70b9", targetEntity.getModifiedLayer(), targetEntity.getEntityType().name(), targetEntity.getName()), null, null);
                modifyItems.add(modifyItem);
            }
        }
        return modifyItems;
    }

    protected List<Element> analysisInnerNode(GOTNode targetNode) throws VTDException {
        Element modifyItem;
        GOTNode node2;
        ArrayList<Element> modifyItems = new ArrayList<Element>();
        GOTEntity targetEntity = targetNode.getEntity();
        GOTEntity sourceEntity = this.sourceGOT.getEntityById(targetEntity.getEntityType(), targetEntity.getId());
        GOTNode sourceNode = sourceEntity.selectSingleNode(targetNode.getEntityXPath());
        String nodeType = targetNode.getNodeType();
        String targetNodeId = targetNode.getId();
        String targetNodeName = targetNode.getName();
        if (sourceNode == null && "FormItem".equals(nodeType)) {
            sourceNode = sourceEntity.selectSingleNode(String.format(".//FormItem[@id='%s']", targetNodeId));
        }
        if ("EnumItem".equals(nodeType)) {
            for (GOTNode node2 : sourceEntity.selectNodes("./EnumItem")) {
                if (!targetNode.getProperty("Value").getValue().equals(node2.getProperty("Value").getValue()) || targetNodeId.equals(node2.getId()) || !this.sourceGOT.isSourceDeployment(node2.getModifiedLayer(), sourceEntity, null)) continue;
                modifyItem = sourceNode != null ? this.createModifyItem(ModifyType.InnerNode_Property_Value, ModifyLevel.Cannot, sourceNode.getNodeType(), sourceNode.getId(), null, String.format("Enum\u3010%s\u3011\u5b9e\u4f53EnumItem\u3010%s %s\u3011\u5185\u90e8\u8282\u70b9Value\u503c\u51b2\u7a81\uff0c\u65e0\u6cd5\u5347\u7ea7", sourceEntity.getName(), sourceNode.getName(), node2.getName()), null, node2.getId()) : this.createModifyItem(ModifyType.InnerNode_Property_Value, ModifyLevel.Cannot, nodeType, targetNodeId, null, String.format("\u3010%s\u3011\u5c42\u5b9e\u4f53\u65b0\u589eEnumItem\u3010%s\u3011\u4e0e\u5347\u7ea7\u5c42\u65b0\u589e\u7684EnumItem\u3010%s\u3011\u5c5e\u6027Value\u503c\u51b2\u7a81\uff0c\u65e0\u6cd5\u5347\u7ea7", sourceEntity.getModifiedLayer(), targetNodeName, node2.getName()), null, node2.getId());
                modifyItems.add(modifyItem);
            }
        }
        if (sourceNode != null) {
            GOTEntity transitionEntity;
            if (!targetNodeName.equals(sourceNode.getName())) {
                node2 = sourceEntity.selectSingleNode(String.format("%s/%s[@name='%s']", targetNode.getParent().getEntityXPath(), nodeType, targetNodeName));
                if (node2 != null && !node2.getId().equals(sourceNode.getId()) && this.sourceGOT.isSourceDeployment(node2.getCreatedLayer(), sourceEntity, null) && this.sourceGOT.isSourceDeployment(sourceEntity.getModifiedLayer(), sourceEntity, null)) {
                    modifyItem = this.createModifyItem(ModifyType.InnerNode_Rename, ModifyLevel.Cannot, sourceNode.getNodeType(), sourceNode.getId(), null, String.format("\u5185\u90e8\u8282\u70b9%s\u3010%s\u3011\u540d\u79f0\u4fee\u6539\u3010%s-->%s\u3011,\u4e0e\u3010%s\u3011\u5c42\u521b\u5efa\u7684\u5185\u90e8\u8282\u70b9\u3010id=%s\u3011\u91cd\u540d,\u65e0\u6cd5\u5347\u7ea7!", sourceNode.getNodeType(), sourceNode.getName(), sourceNode.getName(), targetNodeName, node2.getCreatedLayer(), node2.getId()), sourceEntity.getId(), node2.getId());
                    modifyItems.add(modifyItem);
                } else {
                    modifyItem = this.createModifyItem(ModifyType.InnerNode_Rename, ModifyLevel.Must, sourceNode.getNodeType(), sourceNode.getId(), null, String.format("\u5185\u90e8\u8282\u70b9%s\u3010%s\u3011\u540d\u79f0\u4fee\u6539\u3010%s-->%s\u3011", sourceNode.getNodeType(), sourceNode.getName(), sourceNode.getName(), targetNodeName), null, null);
                    modifyItems.add(modifyItem);
                }
            }
            if ((transitionEntity = this.originalTargetGOT.getEntityById(sourceEntity.getEntityType(), sourceEntity.getId())) == null) {
                return modifyItems;
            }
            if ("FormItem".equals(sourceNode.getNodeType())) {
                GOTNode transitionNode = transitionEntity.selectSingleNode(sourceNode.getEntityXPath());
                if (transitionNode == null) {
                    transitionNode = transitionEntity.selectSingleNode(String.format("/Form[@id='%s']/FormDesign[@name='Design']//FormItem[@id='%s']", sourceEntity.getId(), sourceNode.getId()));
                }
                if (transitionNode != null) {
                    modifyItems.addAll(this.analysisProperty(targetNode, sourceNode, transitionNode));
                }
            }
        } else {
            node2 = sourceEntity.selectSingleNode(String.format("%s/%s[@name='%s']", targetNode.getParent().getEntityXPath(), nodeType, targetNodeName));
            if (node2 != null && this.sourceGOT.getLayerLevel(node2.getCreatedLayer()) > this.targetGOT.getTopLayerLevel() && this.sourceGOT.getLayerLevel(sourceEntity.getModifiedLayer()) > this.targetGOT.getTopLayerLevel()) {
                modifyItem = this.createModifyItem(ModifyType.InnerNode_Add, ModifyLevel.Cannot, nodeType, targetNodeId, null, String.format("\u65b0\u589e%s\u3010%s %s\u3011\u5185\u90e8\u8282\u70b9\uff0c\u4e0e\u3010%s\u3011\u5c42\u521b\u5efa\u7684\u5185\u90e8\u8282\u70b9\u3010id=%s\u3011\u91cd\u540d\uff0c\u65e0\u6cd5\u5347\u7ea7!", nodeType, targetNodeId, targetNodeName, node2.getCreatedLayer(), node2.getId()), sourceEntity.getId(), node2.getId());
                modifyItems.add(modifyItem);
            } else if ("TableIndexItem".equals(nodeType)) {
                List<GOTNode> findNodes = sourceEntity.selectNodes(String.format("%s/%s/Properties/Property[@innerid='%s']/Name[text()='Field']/../../..", targetNode.getParent().getEntityXPath(), nodeType, targetNode.getProperty("Field").getAttributeValue("innerid")));
                boolean same = false;
                for (GOTNode gotNode : findNodes) {
                    if (gotNode.getId().equals(targetNodeId) || this.sourceGOT.getLayerLevel(gotNode.getModifiedLayer()) <= this.targetGOT.getTopLayerLevel()) continue;
                    modifyItem = this.createModifyItem(ModifyType.InnerNode_Add, ModifyLevel.Cannot, nodeType, targetNodeId, null, String.format("\u65b0\u589eTableIndexItem\u3010%s\u3011\u5185\u90e8\u8282\u70b9\uff0c\u4e14\u4e0e\u5f53\u524dTableIndexItem\u3010%s\u3011\u5173\u8054\u76f8\u540c\u7684TableField\uff0c\u65e0\u6cd5\u5347\u7ea7!", targetNodeName, gotNode.getId()), sourceEntity.getId(), gotNode.getId());
                    modifyItems.add(modifyItem);
                    same = true;
                    break;
                }
                if (!same) {
                    modifyItem = this.createModifyItem(ModifyType.InnerNode_Add, ModifyLevel.Must, nodeType, targetNodeId, null, String.format("\u65b0\u589e%s\u3010%s\u3011\u5185\u90e8\u8282\u70b9", nodeType, targetNodeName), null, null);
                    modifyItems.add(modifyItem);
                }
            } else if (!("FormItem".equals(nodeType) || "MenuRefMenu".equals(nodeType) || "MenuRefMenuItem".equals(nodeType) || "MenuSeperator".equals(nodeType) || "MenuSub".equals(nodeType))) {
                modifyItem = this.createModifyItem(ModifyType.InnerNode_Add, ModifyLevel.Must, nodeType, targetNodeId, null, String.format("%s\u3010%s\u3011\u5b9e\u4f53\u65b0\u589e%s\u3010%s\u3011\u5185\u90e8\u8282\u70b9", sourceEntity.getEntityType().name(), sourceEntity.getName(), nodeType, targetNodeName), null, null);
                modifyItems.add(modifyItem);
            }
        }
        return modifyItems;
    }

    protected List<Element> analysisProperty(GOTNode targetNode, GOTNode sourceNode, GOTNode transitionNode) throws VTDException {
        Element modifyItem;
        ArrayList<Element> modifyItems = new ArrayList<Element>();
        String sourceNodeType = sourceNode.getNodeType();
        GOTEntity sourceEntity = sourceNode.getEntity();
        String sourceEntityModifiedLayer = sourceEntity.getModifiedLayer();
        List<GOTProperty> sourcePropertys = sourceNode.getPropertys();
        HashMap<String, GOTProperty> sourcePropertyMaps = new HashMap<String, GOTProperty>();
        for (GOTProperty sourceProperty : sourcePropertys) {
            sourcePropertyMaps.put(sourceProperty.getName(), sourceProperty);
        }
        List<GOTProperty> transitionPropertys = transitionNode.getPropertys();
        HashMap<String, GOTProperty> transitionPropertyMaps = new HashMap<String, GOTProperty>();
        for (GOTProperty transitionProperty : transitionPropertys) {
            transitionPropertyMaps.put(transitionProperty.getName(), transitionProperty);
        }
        HashMap<String, GOTProperty> targetPropertyMaps = new HashMap<String, GOTProperty>();
        for (GOTProperty targetProperty : targetNode.getPropertys()) {
            String propertyName = targetProperty.getName();
            targetPropertyMaps.put(propertyName, targetProperty);
            if (ignoreAnalysisPropertys.contains(propertyName)) continue;
            if (sourcePropertyMaps.containsKey(propertyName)) {
                String description;
                GOTProperty transitionProperty = (GOTProperty)transitionPropertyMaps.get(propertyName);
                if (transitionProperty == null) continue;
                GOTProperty sourceProperty = (GOTProperty)sourcePropertyMaps.get(propertyName);
                String targetValue = targetProperty.getValue();
                String sourceValue = sourceProperty.getValue();
                if (!(targetValue == null && sourceValue == null || targetValue != null && targetValue.equals(sourceValue) || sourceValue != null && sourceValue.equals(targetValue))) {
                    String transitionValue = transitionProperty.getValue();
                    if (sourceValue == null && transitionValue == null || sourceValue != null && sourceValue.equals(transitionValue) || transitionValue != null && transitionValue.equals(sourceValue)) {
                        String description2 = sourceNode.isEntityNode() ? String.format("\u5b9e\u4f53\u3010%s\u3011\u5c5e\u6027\u503c\u4fee\u6539\u3010%s-->%s\u3011", propertyName, sourceValue, targetValue) : String.format("\u5185\u90e8\u8282\u70b9\u3010%s\u3011\u5c5e\u6027\u503c\u4fee\u6539\u3010%s-->%s\u3011", propertyName, sourceValue, targetValue);
                        if (this.sourceGOT.getLayerDefination(sourceEntityModifiedLayer).getDeploymentMode() == LayerDeploymentMode.Source) {
                            if (("DataType".equals(sourceNodeType) || "TableField".equals(sourceNodeType)) && "StringSize".equals(propertyName) || "NumOfDecimals".equals(propertyName)) {
                                if (StringUtils.isNotBlank((String)targetValue) && StringUtils.isNotBlank((String)sourceValue) && Integer.parseInt(targetValue) < Integer.parseInt(sourceValue)) continue;
                                modifyItems.add(this.createModifyItem(sourceNode.isEntityNode() ? ModifyType.Entity_Property_Value : ModifyType.InnerNode_Property_Value, ModifyLevel.Must, sourceNodeType, sourceNode.getId(), targetProperty.getName(), description2, null, null));
                                continue;
                            }
                            modifyItems.add(this.createModifyItem(sourceNode.isEntityNode() ? ModifyType.Entity_Property_Value : ModifyType.InnerNode_Property_Value, ModifyLevel.Must, sourceNodeType, sourceNode.getId(), targetProperty.getName(), description2, null, null));
                            continue;
                        }
                        modifyItems.add(this.createModifyItem(sourceNode.isEntityNode() ? ModifyType.Entity_Property_Value : ModifyType.InnerNode_Property_Value, ModifyLevel.Notify, sourceNodeType, sourceNode.getId(), targetProperty.getName(), description2, null, null));
                        continue;
                    }
                    if (("DataType".equals(sourceNodeType) || "TableField".equals(sourceNodeType)) && ("StringSize".equals(propertyName) || "NumOfDecimals".equals(propertyName))) {
                        boolean analysis = true;
                        if ("TableField".equals(sourceNodeType)) {
                            GOTProperty targetExtends = targetNode.getProperty("Extends");
                            GOTProperty sourceExtends = sourceNode.getProperty("Extends");
                            if (StringUtils.isNotBlank((String)targetExtends.getValue()) && StringUtils.isNotBlank((String)sourceExtends.getValue())) {
                                analysis = false;
                            }
                        }
                        if (analysis && StringUtils.isNotBlank((String)targetValue) && StringUtils.isNotBlank((String)sourceValue) && Integer.parseInt(targetValue) > Integer.parseInt(sourceValue)) {
                            if (this.sourceGOT.getLayerLevel(sourceEntityModifiedLayer) <= this.targetGOT.getTopLayerLevel() || this.sourceGOT.getLayerDefination(sourceEntityModifiedLayer).getDeploymentMode() == LayerDeploymentMode.Source) {
                                description = sourceNode.isEntityNode() ? String.format("\u5b9e\u4f53\u3010%s\u3011\u5c5e\u6027\u503c\u4fee\u6539\u3010%s-->%s\u3011", propertyName, sourceValue, targetValue) : String.format("\u5185\u90e8\u8282\u70b9\u3010%s\u3011\u5c5e\u6027\u503c\u4fee\u6539\u3010%s-->%s\u3011", propertyName, sourceValue, targetValue);
                                modifyItems.add(this.createModifyItem(sourceNode.isEntityNode() ? ModifyType.Entity_Property_Value : ModifyType.InnerNode_Property_Value, ModifyLevel.Must, sourceNodeType, sourceNode.getId(), targetProperty.getName(), description, null, null));
                                continue;
                            }
                            description = sourceNode.isEntityNode() ? String.format("\u5b9e\u4f53\u3010%s\u3011\u5c5e\u6027\u503c\u4fee\u6539\u3010%s-->%s\u3011, \u7531\u4e8e%s\u3010%s\u3011\u5728\u3010%s\u3011\u5c42\u4fee\u6539\uff0c\u65e0\u6cd5\u5347\u7ea7", propertyName, sourceValue, targetValue, sourceEntity.getNodeType(), sourceEntity.getName(), sourceNode.getModifiedLayer()) : String.format("\u5185\u90e8\u8282\u70b9\u3010%s\u3011\u5c5e\u6027\u503c\u4fee\u6539\u3010%s-->%s\u3011, \u7531\u4e8e%s\u3010%s\u3011\u5728\u3010%s\u3011\u5c42\u4fee\u6539\uff0c\u65e0\u6cd5\u5347\u7ea7", propertyName, sourceValue, targetValue, sourceEntity.getNodeType(), sourceEntity.getName(), sourceNode.getModifiedLayer());
                            modifyItems.add(this.createModifyItem(sourceNode.isEntityNode() ? ModifyType.Entity_Property_Value : ModifyType.InnerNode_Property_Value, ModifyLevel.Cannot, sourceNodeType, sourceNode.getId(), targetProperty.getName(), description, null, null));
                            continue;
                        }
                    }
                }
                for (Map.Entry<String, String> targetEntry : targetProperty.getAttributes().entrySet()) {
                    if (sourceProperty.hasAttribute(targetEntry.getKey())) {
                        if (targetEntry.getValue().equals(sourceProperty.getAttributeValue(targetEntry.getKey()))) continue;
                        if (sourceProperty.getAttributeValue(targetEntry.getKey()).equals(transitionProperty.getAttributeValue(targetEntry.getKey()))) {
                            if (this.sourceGOT.getLayerLevel(sourceEntityModifiedLayer) <= this.targetGOT.getTopLayerLevel()) {
                                description = sourceNode.isEntityNode() ? String.format("%s\u3010%s\u3011\u5b9e\u4f53\u3010%s\u3011\u5c5e\u6027\u5728\u3010%s\u3011\u5c42\u4fee\u6539", sourceNodeType, sourceNode.getName(), propertyName, targetNode.getModifiedLayer()) : String.format("%s\u3010%s\u3011\u5b9e\u4f53%s\u3010%s\u3011\u5185\u90e8\u8282\u70b9\u3010%s\u3011\u5c5e\u6027\u5728\u3010%s\u3011\u5c42\u4fee\u6539", sourceEntity.getNodeType(), sourceEntity.getName(), sourceNodeType, sourceNode.getName(), propertyName, targetNode.getModifiedLayer());
                                modifyItems.add(this.createModifyItem(sourceNode.isEntityNode() ? ModifyType.Entity_Property_Value : ModifyType.InnerNode_Property_Value, ModifyLevel.Notify, sourceNodeType, sourceNode.getId(), targetProperty.getName(), description, null, null));
                                continue;
                            }
                            if (this.sourceGOT.getLayerDefination(sourceEntityModifiedLayer).getDeploymentMode() == LayerDeploymentMode.Source) {
                                description = sourceNode.isEntityNode() ? String.format("%s\u3010%s\u3011\u5b9e\u4f53\u3010%s\u3011\u5c5e\u6027\u503c\u5728\u3010%s\u3011\u5c42\u4fee\u6539", sourceNodeType, sourceNode.getName(), propertyName, targetNode.getModifiedLayer()) : String.format("%s\u3010%s\u3011\u5b9e\u4f53%s\u3010%s\u3011\u5185\u90e8\u8282\u70b9\u3010%s\u3011\u5c5e\u6027\u5728\u3010%s\u3011\u5c42\u4fee\u6539", sourceEntity.getNodeType(), sourceEntity.getName(), sourceNodeType, sourceNode.getName(), propertyName, targetNode.getModifiedLayer());
                                modifyItems.add(this.createModifyItem(sourceNode.isEntityNode() ? ModifyType.Entity_Property_Value : ModifyType.InnerNode_Property_Value, ModifyLevel.Must, sourceNodeType, sourceNode.getId(), targetProperty.getName(), description, null, null));
                                continue;
                            }
                            description = sourceNode.isEntityNode() ? String.format("%s\u3010%s\u3011\u5b9e\u4f53\u3010%s\u3011\u5c5e\u6027\u5728\u3010%s\u3011\u5c42\u4fee\u6539, \u7531\u4e8e%s\u3010%s\u3011\u5728\u3010%s\u3011\u5c42\u4fee\u6539\uff0c\u65e0\u6cd5\u5347\u7ea7", sourceNodeType, sourceNode.getName(), propertyName, targetNode.getModifiedLayer(), sourceEntity.getNodeType(), sourceEntity.getName(), sourceNode.getModifiedLayer()) : String.format("%s\u3010%s\u3011\u5b9e\u4f53%s\u3010%s\u3011\u5185\u90e8\u8282\u70b9\u3010%s\u3011\u5c5e\u6027\u5728\u3010%s\u3011\u5c42\u4fee\u6539, \u7531\u4e8e%s\u3010%s\u3011\u5728\u3010%s\u3011\u5c42\u4fee\u6539\uff0c\u65e0\u6cd5\u5347\u7ea7", sourceEntity.getNodeType(), sourceEntity.getName(), sourceNodeType, sourceNode.getName(), propertyName, targetNode.getModifiedLayer(), sourceEntity.getNodeType(), sourceEntity.getName(), sourceNode.getModifiedLayer());
                            modifyItems.add(this.createModifyItem(sourceNode.isEntityNode() ? ModifyType.Entity_Property_Value : ModifyType.InnerNode_Property_Value, ModifyLevel.Cannot, sourceNodeType, sourceNode.getId(), targetProperty.getName(), description, null, null));
                            continue;
                        }
                        if (this.isModifiedLayerSource(this.sourceGOT, sourceNode)) {
                            description = sourceNode.isEntityNode() ? String.format("%s\u3010%s\u3011\u5b9e\u4f53\u3010%s\u3011\u5c5e\u6027\u503c\u5728\u3010%s\u3011\u5c42\u4fee\u6539", sourceNodeType, sourceNode.getName(), propertyName, targetNode.getModifiedLayer()) : String.format("%s\u3010%s\u3011\u5b9e\u4f53%s\u3010%s\u3011\u5185\u90e8\u8282\u70b9\u3010%s\u3011\u5c5e\u6027\u5728\u3010%s\u3011\u5c42\u4fee\u6539", sourceEntity.getNodeType(), sourceEntity.getName(), sourceNodeType, sourceNode.getName(), propertyName, targetNode.getModifiedLayer());
                            modifyItems.add(this.createModifyItem(sourceNode.isEntityNode() ? ModifyType.Entity_Property_Value : ModifyType.InnerNode_Property_Value, ModifyLevel.Notify, sourceNodeType, sourceNode.getId(), targetProperty.getName(), description, null, null));
                            continue;
                        }
                        description = sourceNode.isEntityNode() ? String.format("%s\u3010%s\u3011\u5b9e\u4f53\u3010%s\u3011\u5c5e\u6027\u5728\u3010%s\u3011\u5c42\u4fee\u6539, \u7531\u4e8e%s\u3010%s\u3011\u5728\u3010%s\u3011\u5c42\u4fee\u6539\uff0c\u65e0\u6cd5\u5347\u7ea7", sourceNodeType, sourceNode.getName(), propertyName, targetNode.getModifiedLayer(), sourceEntity.getNodeType(), sourceEntity.getName(), sourceNode.getModifiedLayer()) : String.format("%s\u3010%s\u3011\u5b9e\u4f53%s\u3010%s\u3011\u5185\u90e8\u8282\u70b9\u3010%s\u3011\u5c5e\u6027\u5728\u3010%s\u3011\u5c42\u4fee\u6539, \u7531\u4e8e%s\u3010%s\u3011\u5728\u3010%s\u3011\u5c42\u4fee\u6539\uff0c\u65e0\u6cd5\u5347\u7ea7", sourceEntity.getNodeType(), sourceEntity.getName(), sourceNodeType, sourceNode.getName(), propertyName, targetNode.getModifiedLayer(), sourceEntity.getNodeType(), sourceEntity.getName(), sourceNode.getModifiedLayer());
                        modifyItems.add(this.createModifyItem(sourceNode.isEntityNode() ? ModifyType.Entity_Property_Value : ModifyType.InnerNode_Property_Value, ModifyLevel.Cannot, sourceNodeType, sourceNode.getId(), targetProperty.getName(), description, null, null));
                        continue;
                    }
                    if (this.sourceGOT.getLayerLevel(sourceEntityModifiedLayer) <= this.targetGOT.getTopLayerLevel()) {
                        description = sourceNode.isEntityNode() ? String.format("%s\u3010%s\u3011\u5b9e\u4f53\u3010%s\u3011\u5c5e\u6027\u5728\u3010%s\u3011\u5c42\u4fee\u6539", sourceNodeType, sourceNode.getName(), propertyName, targetNode.getModifiedLayer()) : String.format("%s\u3010%s\u3011\u5b9e\u4f53%s\u3010%s\u3011\u5185\u90e8\u8282\u70b9\u3010%s\u3011\u5c5e\u6027\u5728\u3010%s\u3011\u5c42\u4fee\u6539", sourceEntity.getNodeType(), sourceEntity.getName(), sourceNodeType, sourceNode.getName(), propertyName, targetNode.getModifiedLayer());
                        modifyItems.add(this.createModifyItem(sourceNode.isEntityNode() ? ModifyType.Entity_Property_Value : ModifyType.InnerNode_Property_Value, ModifyLevel.Notify, sourceNodeType, sourceNode.getId(), targetProperty.getName(), description, null, null));
                        continue;
                    }
                    if (this.sourceGOT.getLayerDefination(sourceEntityModifiedLayer).getDeploymentMode() == LayerDeploymentMode.Source) {
                        description = sourceNode.isEntityNode() ? String.format("%s\u3010%s\u3011\u5b9e\u4f53\u3010%s\u3011\u5c5e\u6027\u503c\u5728\u3010%s\u3011\u5c42\u4fee\u6539", sourceNodeType, sourceNode.getName(), propertyName, targetNode.getModifiedLayer()) : String.format("%s\u3010%s\u3011\u5b9e\u4f53%s\u3010%s\u3011\u5185\u90e8\u8282\u70b9\u3010%s\u3011\u5c5e\u6027\u5728\u3010%s\u3011\u5c42\u4fee\u6539", sourceEntity.getNodeType(), sourceEntity.getName(), sourceNodeType, sourceNode.getName(), propertyName, targetNode.getModifiedLayer());
                        modifyItems.add(this.createModifyItem(sourceNode.isEntityNode() ? ModifyType.Entity_Property_Value : ModifyType.InnerNode_Property_Value, ModifyLevel.Must, sourceNodeType, sourceNode.getId(), targetProperty.getName(), description, null, null));
                        continue;
                    }
                    description = sourceNode.isEntityNode() ? String.format("%s\u3010%s\u3011\u5b9e\u4f53\u3010%s\u3011\u5c5e\u6027\u5728\u3010%s\u3011\u5c42\u4fee\u6539, \u7531\u4e8e%s\u3010%s\u3011\u5728\u3010%s\u3011\u5c42\u4fee\u6539\uff0c\u65e0\u6cd5\u5347\u7ea7", sourceNodeType, sourceNode.getName(), propertyName, targetNode.getModifiedLayer(), sourceEntity.getNodeType(), sourceEntity.getName(), sourceNode.getModifiedLayer()) : String.format("%s\u3010%s\u3011\u5b9e\u4f53%s\u3010%s\u3011\u5185\u90e8\u8282\u70b9\u3010%s\u3011\u5c5e\u6027\u5728\u3010%s\u3011\u5c42\u4fee\u6539, \u7531\u4e8e%s\u3010%s\u3011\u5728\u3010%s\u3011\u5c42\u4fee\u6539\uff0c\u65e0\u6cd5\u5347\u7ea7", sourceEntity.getNodeType(), sourceEntity.getName(), sourceNodeType, sourceNode.getName(), propertyName, targetNode.getModifiedLayer(), sourceEntity.getNodeType(), sourceEntity.getName(), sourceNode.getModifiedLayer());
                    modifyItems.add(this.createModifyItem(sourceNode.isEntityNode() ? ModifyType.Entity_Property_Value : ModifyType.InnerNode_Property_Value, ModifyLevel.Cannot, sourceNodeType, sourceNode.getId(), targetProperty.getName(), description, null, null));
                }
                for (Map.Entry<String, String> sourceEntry : sourceProperty.getAttributes().entrySet()) {
                    String description3;
                    if (targetProperty.hasAttribute(sourceEntry.getKey()) || !transitionProperty.hasAttribute(sourceEntry.getKey()) || !transitionProperty.getAttributeValue(sourceEntry.getKey()).equals(sourceEntry.getValue())) continue;
                    if (this.sourceGOT.getLayerLevel(sourceEntityModifiedLayer) <= this.targetGOT.getTopLayerLevel()) {
                        description3 = sourceNode.isEntityNode() ? String.format("%s\u3010%s\u3011\u5b9e\u4f53\u3010%s\u3011\u5c5e\u6027\u5728\u3010%s\u3011\u5c42\u4fee\u6539", sourceNodeType, sourceNode.getName(), propertyName, targetNode.getModifiedLayer()) : String.format("%s\u3010%s\u3011\u5b9e\u4f53%s\u3010%s\u3011\u5185\u90e8\u8282\u70b9\u3010%s\u3011\u5c5e\u6027\u5728\u3010%s\u3011\u5c42\u4fee\u6539", sourceEntity.getNodeType(), sourceEntity.getName(), sourceNodeType, sourceNode.getName(), propertyName, targetNode.getModifiedLayer());
                        modifyItems.add(this.createModifyItem(sourceNode.isEntityNode() ? ModifyType.Entity_Property_Value : ModifyType.InnerNode_Property_Value, ModifyLevel.Notify, sourceNodeType, sourceNode.getId(), targetProperty.getName(), description3, null, null));
                        continue;
                    }
                    if (this.sourceGOT.getLayerDefination(sourceEntityModifiedLayer).getDeploymentMode() == LayerDeploymentMode.Source) {
                        description3 = sourceNode.isEntityNode() ? String.format("%s\u3010%s\u3011\u5b9e\u4f53\u3010%s\u3011\u5c5e\u6027\u503c\u5728\u3010%s\u3011\u5c42\u4fee\u6539", sourceNodeType, sourceNode.getName(), propertyName, targetNode.getModifiedLayer()) : String.format("%s\u3010%s\u3011\u5b9e\u4f53%s\u3010%s\u3011\u5185\u90e8\u8282\u70b9\u3010%s\u3011\u5c5e\u6027\u5728\u3010%s\u3011\u5c42\u4fee\u6539", sourceEntity.getNodeType(), sourceEntity.getName(), sourceNodeType, sourceNode.getName(), propertyName, targetNode.getModifiedLayer());
                        modifyItems.add(this.createModifyItem(sourceNode.isEntityNode() ? ModifyType.Entity_Property_Value : ModifyType.InnerNode_Property_Value, ModifyLevel.Must, sourceNodeType, sourceNode.getId(), targetProperty.getName(), description3, null, null));
                        continue;
                    }
                    description3 = sourceNode.isEntityNode() ? String.format("%s\u3010%s\u3011\u5b9e\u4f53\u3010%s\u3011\u5c5e\u6027\u5728\u3010%s\u3011\u5c42\u4fee\u6539, \u7531\u4e8e%s\u3010%s\u3011\u5728\u3010%s\u3011\u5c42\u4fee\u6539\uff0c\u65e0\u6cd5\u5347\u7ea7", sourceNodeType, sourceNode.getName(), propertyName, targetNode.getModifiedLayer(), sourceEntity.getNodeType(), sourceEntity.getName(), sourceNode.getModifiedLayer()) : String.format("%s\u3010%s\u3011\u5b9e\u4f53%s\u3010%s\u3011\u5185\u90e8\u8282\u70b9\u3010%s\u3011\u5c5e\u6027\u5728\u3010%s\u3011\u5c42\u4fee\u6539, \u7531\u4e8e%s\u3010%s\u3011\u5728\u3010%s\u3011\u5c42\u4fee\u6539\uff0c\u65e0\u6cd5\u5347\u7ea7", sourceEntity.getNodeType(), sourceEntity.getName(), sourceNodeType, sourceNode.getName(), propertyName, targetNode.getModifiedLayer(), sourceEntity.getNodeType(), sourceEntity.getName(), sourceNode.getModifiedLayer());
                    modifyItems.add(this.createModifyItem(sourceNode.isEntityNode() ? ModifyType.Entity_Property_Value : ModifyType.InnerNode_Property_Value, ModifyLevel.Cannot, sourceNodeType, sourceNode.getId(), targetProperty.getName(), description3, null, null));
                }
                continue;
            }
            modifyItem = this.createModifyItem(sourceNode.isEntityNode() ? ModifyType.Entity_Property_Add : ModifyType.InnerNode_Property_Add, ModifyLevel.Must, sourceNodeType, sourceNode.getId(), targetProperty.getName(), String.format("\u3010%s %s\u3011\u8282\u70b9\u589e\u52a0\u3010%s\u3011\u5c5e\u6027", sourceNodeType, sourceNode.getName(), targetProperty.getName()), null, null);
            modifyItems.add(modifyItem);
        }
        for (GOTProperty sourceProperty : sourceNode.getPropertys()) {
            if (targetPropertyMaps.containsKey(sourceProperty.getName())) continue;
            modifyItem = this.createModifyItem(sourceNode.isEntityNode() ? ModifyType.Entity_Property_Delete : ModifyType.InnerNode_Property_Delete, ModifyLevel.Must, sourceNodeType, sourceNode.getId(), sourceProperty.getName(), String.format("\u3010%s %s\u3011\u8282\u70b9\u5220\u9664\u3010%s\u3011\u5c5e\u6027", sourceNodeType, sourceNode.getName(), sourceProperty.getName()), null, null);
            modifyItems.add(modifyItem);
        }
        return modifyItems;
    }

    protected List<Element> analysisReverseEntityNode(GOTEntity sourceEntity) throws VTDException {
        if (this.sourceGOT.getLayerLevel(sourceEntity.getCreatedLayer()) > this.targetGOT.getTopLayerLevel()) {
            return Collections.emptyList();
        }
        ArrayList<Element> modifyItems = new ArrayList<Element>();
        GOTEntity targetDataType = this.targetGOT.getEntityById(sourceEntity.getEntityType(), sourceEntity.getId());
        if (targetDataType == null) {
            boolean validRef = false;
            List<GOTProperty> refPropertys = this.sourceGOT.getRefEntityPropertys(sourceEntity.getId());
            for (GOTProperty refProperty : refPropertys) {
                GOTNode srcRefNode = refProperty.getGOTNode();
                GOTEntity srcRefEntity = srcRefNode.getEntity();
                if (this.sourceGOT.getLayerLevel(srcRefEntity.getCreatedLayer()) > this.targetGOT.getTopLayerLevel()) {
                    GOTEntity destRefEntity = this.targetGOT.getEntityById(srcRefEntity.getEntityType(), srcRefEntity.getId());
                    if (destRefEntity != null) {
                        if (srcRefNode.isEntityNode()) {
                            GOTProperty destRefProperty = destRefEntity.getProperty(refProperty.getName());
                            if (destRefProperty == null || !sourceEntity.getId().equals(destRefProperty.getRefEntityId())) continue;
                            modifyItems.add(this.createModifyItem(ModifyType.Entity_Delete, ModifyLevel.Cannot, sourceEntity.getNodeType(), sourceEntity.getId(), null, String.format("%s\u5c42\u5220\u9664%s\u5b9e\u4f53\u3010%s\u3011,\u3010%s\u3011\u5c42\u521b\u5efa\u7684%s\u3010%s\u3011%s\u7c7b\u578b\u5b9e\u4f53\u7684\u5185\u90e8\u8282\u70b9\u3010%s %s\u3011\u5b58\u5728\u5f15\u7528\uff0c\u65e0\u6cd5\u5347\u7ea7\uff01", sourceEntity.getCreatedLayer(), sourceEntity.getNodeType(), sourceEntity.getName(), srcRefEntity.getCreatedLayer(), srcRefEntity.getEntityType().name(), srcRefEntity.getName(), srcRefNode.getNodeType(), srcRefNode.getName(), refProperty.getName()), null, null));
                            validRef = true;
                            continue;
                        }
                        GOTNode destRefNode = destRefEntity.getChildNode(srcRefNode.getId());
                        if (destRefNode != null) {
                            GOTProperty destRefProperty = destRefNode.getProperty(refProperty.getName());
                            if (destRefProperty == null || !sourceEntity.getId().equals(destRefProperty.getRefEntityId())) continue;
                            modifyItems.add(this.createModifyItem(ModifyType.Entity_Delete, ModifyLevel.Cannot, sourceEntity.getNodeType(), sourceEntity.getId(), null, String.format("%s\u5c42\u5220\u9664%s\u7c7b\u578b\u5b9e\u4f53\u3010%s\u3011,%s\u3010%s\u3011\u5b9e\u4f53\u5185\u90e8\u8282\u70b9%s\u3010%s %s\u3011\u5b58\u5728\u5f15\u7528\uff0c\u65e0\u6cd5\u5347\u7ea7\uff01", sourceEntity.getCreatedLayer(), sourceEntity.getNodeType(), sourceEntity.getName(), srcRefEntity.getEntityType().name(), srcRefEntity.getName(), srcRefNode.getNodeType(), srcRefNode.getName(), refProperty.getName()), null, null));
                            validRef = true;
                            continue;
                        }
                        if (!this.sourceGOT.isSourceDeployment(srcRefNode.getCreatedLayer(), destRefEntity, null)) continue;
                        modifyItems.add(this.createModifyItem(ModifyType.Entity_Delete, ModifyLevel.Cannot, sourceEntity.getNodeType(), sourceEntity.getId(), null, String.format("%s\u5c42\u5220\u9664%s\u7c7b\u578b\u5b9e\u4f53\u3010%s\u3011,%s\u3010%s\u3011\u5b9e\u4f53\u5185\u90e8\u8282\u70b9%s\u3010%s %s\u3011\u5b58\u5728\u5f15\u7528\uff0c\u65e0\u6cd5\u5347\u7ea7\uff01", sourceEntity.getCreatedLayer(), sourceEntity.getNodeType(), sourceEntity.getName(), srcRefEntity.getEntityType().name(), srcRefEntity.getName(), srcRefNode.getNodeType(), srcRefNode.getName(), refProperty.getName()), null, null));
                        validRef = true;
                        continue;
                    }
                    if (!this.sourceGOT.isSourceDeployment(srcRefEntity.getCreatedLayer(), srcRefEntity, null)) continue;
                    modifyItems.add(this.createModifyItem(ModifyType.Entity_Delete, ModifyLevel.Cannot, sourceEntity.getNodeType(), sourceEntity.getId(), null, String.format("%s\u5c42\u5220\u9664%s\u7c7b\u578b\u5b9e\u4f53\u3010%s\u3011, %s\u3010%s\u3011\u5b9e\u4f53\u5185\u90e8\u8282\u70b9%s\u3010%s %s\u3011\u5b58\u5728\u5f15\u7528\uff0c\u65e0\u6cd5\u5347\u7ea7\uff01", sourceEntity.getCreatedLayer(), sourceEntity.getNodeType(), sourceEntity.getName(), srcRefEntity.getEntityType().name(), srcRefEntity.getName(), srcRefNode.getNodeType(), srcRefNode.getName(), refProperty.getName()), null, null));
                    validRef = true;
                    continue;
                }
                GOTEntity entity = this.targetGOT.getEntityById(srcRefEntity.getEntityType(), srcRefEntity.getId());
                if (entity == null) continue;
                GOTNode node = entity.selectSingleNode(srcRefNode.getEntityXPath());
                if (node != null) {
                    GOTProperty property = node.getProperty(refProperty.getName());
                    if (property == null || !refProperty.getRefEntityId().equals(property.getRefEntityId())) continue;
                    modifyItems.add(this.createModifyItem(ModifyType.Entity_Delete, ModifyLevel.Cannot, sourceEntity.getNodeType(), sourceEntity.getId(), null, String.format("%s\u5c42\u5220\u9664%s\u5b9e\u4f53\u3010%s\u3011,\u3010%s\u3011\u5c42\u521b\u5efa\u7684%s\u3010%s\u3011%s\u7c7b\u578b\u5b9e\u4f53\u7684\u5185\u90e8\u8282\u70b9\u3010%s %s\u3011\u5b58\u5728\u5f15\u7528\uff0c\u65e0\u6cd5\u5347\u7ea7", sourceEntity.getCreatedLayer(), sourceEntity.getNodeType(), sourceEntity.getName(), srcRefEntity.getCreatedLayer(), srcRefEntity.getEntityType().name(), srcRefEntity.getName(), srcRefNode.getNodeType(), srcRefNode.getName(), refProperty.getName()), null, null));
                    validRef = true;
                    continue;
                }
                if (!this.sourceGOT.isSourceDeployment(srcRefNode.getCreatedLayer(), srcRefEntity, null)) continue;
                modifyItems.add(this.createModifyItem(ModifyType.Entity_Delete, ModifyLevel.Cannot, sourceEntity.getNodeType(), sourceEntity.getId(), null, String.format("%s\u5c42\u5220\u9664%s\u5b9e\u4f53\u3010%s\u3011,\u3010%s\u3011\u5c42\u521b\u5efa\u7684%s\u3010%s\u3011%s\u7c7b\u578b\u5b9e\u4f53\u7684\u5185\u90e8\u8282\u70b9\u3010%s %s\u3011\u5b58\u5728\u5f15\u7528\uff0c\u65e0\u6cd5\u5347\u7ea7\uff01", sourceEntity.getCreatedLayer(), sourceEntity.getNodeType(), sourceEntity.getName(), srcRefEntity.getCreatedLayer(), srcRefEntity.getEntityType().name(), srcRefEntity.getName(), srcRefNode.getNodeType(), srcRefNode.getName(), refProperty.getName()), null, null));
                validRef = true;
            }
            if (!validRef) {
                if (this.sourceGOT.getLayerLevel(sourceEntity.getModifiedLayer()) <= this.targetGOT.getTopLayerLevel()) {
                    modifyItems.add(this.createModifyItem(ModifyType.Entity_Delete, ModifyLevel.Must, sourceEntity.getNodeType(), sourceEntity.getId(), null, String.format("%s\u5c42\u5220\u9664%s\u3010%s\u3011", sourceEntity.getCreatedLayer(), sourceEntity.getNodeType(), sourceEntity.getName()), null, null));
                } else {
                    modifyItems.add(this.createModifyItem(ModifyType.Entity_Delete, ModifyLevel.Cannot, sourceEntity.getNodeType(), sourceEntity.getId(), null, String.format("%s\u5c42\u5220\u9664%s\u5b9e\u4f53\u3010%s\u3011\uff0c\u5b9e\u4f53\u5728\u3010%s\u3011\u5c42\u5df2\u63d0\u5347\uff0c\u65e0\u6cd5\u5347\u7ea7", sourceEntity.getCreatedLayer(), sourceEntity.getNodeType(), sourceEntity.getName(), sourceEntity.getModifiedLayer()), null, null));
                }
            }
        }
        return modifyItems;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected List<Element> analysisReverseInnerNode(GOTNode sourceNode) throws VTDException {
        GOTNode targetNode;
        LayerDefination layerDefination;
        SolutionExtensionDefinition extensionDefinition;
        SolutionExtensionDefinition extensionDefinition2;
        SolutionPluginDefinition pluginDefinition;
        String pluginName;
        String solutionName;
        GOTEntity entity;
        if (sourceNode == null || this.sourceGOT.getLayerLevel(sourceNode.getCreatedLayer()) > this.targetGOT.getTopLayerLevel()) {
            return Collections.emptyList();
        }
        if ("app".equals(sourceNode.getCreatedLayer())) {
            entity = sourceNode.getEntity();
            solutionName = entity.getId().substring(0, entity.getId().lastIndexOf("."));
            SolutionDefinition solutionDefinition = this.sourceGOT.getSolutionDefinition(solutionName);
            if (solutionDefinition.getDeploymentMode() == SolutionDeploymentMode.Source) {
                return Collections.emptyList();
            }
        } else if ("plg".equals(sourceNode.getCreatedLayer())) {
            entity = sourceNode.getEntity();
            if ("app".equals(entity.getCreatedLayer())) {
                if ("plg".equals(entity.getModifiedLayer())) {
                    return Collections.emptyList();
                }
                if (!"ext".equals(entity.getModifiedLayer())) {
                    throw new RuntimeException("\u65e0\u6548\u7684\u4fee\u6539\u5c42");
                }
            } else {
                if (!"plg".equals(entity.getCreatedLayer())) throw new RuntimeException(String.format("\u65e0\u6548\u7684\u5b9e\u4f53\u3010%s\u3011\u521b\u5efa\u5c42\uff1a%s", entity.getId(), entity.getCreatedLayer()));
                pluginName = entity.getId().substring(0, entity.getId().lastIndexOf("."));
                pluginDefinition = this.sourceGOT.getSolutionPluginDefinition(pluginName);
                if (pluginDefinition.getDeploymentMode() == SolutionPluginDeploymentMode.Source) {
                    return Collections.emptyList();
                }
            }
        } else if ("ext".equals(sourceNode.getCreatedLayer()) ? ("plg".equals((entity = sourceNode.getEntity()).getCreatedLayer()) ? (extensionDefinition2 = this.sourceGOT.getSolutionExtensionDefinition((pluginDefinition = this.sourceGOT.getSolutionPluginDefinition(pluginName = entity.getId().substring(0, entity.getId().lastIndexOf(".")))).getSolutionName())).getDeploymentMode() == SolutionExtensionDeploymentMode.Source : (extensionDefinition = this.sourceGOT.getSolutionExtensionDefinition(solutionName = entity.getId().substring(0, entity.getId().lastIndexOf(".")))).getDeploymentMode() == SolutionExtensionDeploymentMode.Source) : (layerDefination = this.sourceGOT.getLayerDefination(sourceNode.getCreatedLayer())).getDeploymentMode() == LayerDeploymentMode.Source) {
            return Collections.emptyList();
        }
        if ("ent".equals(sourceNode.getCreatedLayer())) {
            return Collections.emptyList();
        }
        GOTEntity sourceEntity = sourceNode.getEntity();
        ArrayList<Element> modifyItems = new ArrayList<Element>();
        GOTEntity targetEntity = this.targetGOT.getEntityById(sourceEntity.getEntityType(), sourceEntity.getId());
        if (targetEntity == null || (targetNode = targetEntity.selectSingleNode(sourceNode.getEntityXPath())) != null || "ent".equals(sourceNode.getCreatedLayer())) return modifyItems;
        boolean validRef = false;
        List<GOTProperty> refPropertys = this.sourceGOT.getRefInnerPropertys(targetEntity.getId(), sourceNode.getId());
        for (GOTProperty refProperty : refPropertys) {
            GOTProperty destRefProperty;
            GOTNode destRefNode;
            GOTNode refNode = refProperty.getGOTNode();
            GOTEntity refEntity = refNode.getEntity();
            if ("TableField".equals(sourceNode.getNodeType()) && "FormDataSourceField".equals(refNode.getNodeType())) continue;
            GOTEntity destRefEntity = this.targetGOT.getEntityById(refEntity.getEntityType(), refEntity.getId());
            if (destRefEntity != null && !refNode.isEntityNode() && (destRefNode = destRefEntity.getChildNode(refNode.getId())) != null && (destRefProperty = destRefNode.getProperty(refProperty.getName())) != null && refProperty.getRefEntityId().equals(destRefProperty.getRefEntityId()) && (StringUtils.isBlank((String)refProperty.getRefInnerId()) || refProperty.getRefInnerId().equals(destRefProperty.getRefInnerId()))) {
                modifyItems.add(this.createModifyItem(ModifyType.InnerNode_Delete, ModifyLevel.Cannot, sourceNode.getNodeType(), sourceNode.getId(), null, String.format("\u5220\u9664\u5185\u90e8\u8282\u70b9%s\u3010%s\u3011,%s\u5c42\u521b\u5efa\u7684%s\u3010%s\u3011%s\u7c7b\u578b\u5b9e\u4f53\u7684\u5185\u90e8\u8282\u70b9\u3010%s %s\u3011\u5b58\u5728\u5f15\u7528\uff0c\u65e0\u6cd5\u5347\u7ea7\uff01", sourceNode.getNodeType(), sourceNode.getName(), refEntity.getModifiedLayer(), refEntity.getNodeType(), refEntity.getName(), refNode.getNodeType(), refNode.getName(), refProperty.getName()), null, null));
                validRef = true;
            }
            if (!this.sourceGOT.isSourceDeployment(refEntity.getCreatedLayer(), refEntity, null)) {
                if (destRefEntity == null || !this.sourceGOT.isSourceDeployment(refNode.getCreatedLayer(), refEntity, refNode.getId())) continue;
                modifyItems.add(this.createModifyItem(ModifyType.InnerNode_Delete, ModifyLevel.Cannot, sourceNode.getNodeType(), sourceNode.getId(), null, String.format("\u5220\u9664\u5185\u90e8\u8282\u70b9%s\u3010%s\u3011,%s\u5c42\u521b\u5efa\u7684%s\u3010%s\u3011%s\u7c7b\u578b\u5b9e\u4f53\u7684\u5185\u90e8\u8282\u70b9\u3010%s %s\u3011\u5b58\u5728\u5f15\u7528\uff0c\u65e0\u6cd5\u5347\u7ea7\uff01", sourceNode.getNodeType(), sourceNode.getName(), refEntity.getModifiedLayer(), refEntity.getNodeType(), refEntity.getName(), refNode.getNodeType(), refNode.getName(), refProperty.getName()), null, null));
                validRef = true;
                continue;
            }
            modifyItems.add(this.createModifyItem(ModifyType.InnerNode_Delete, ModifyLevel.Cannot, sourceNode.getNodeType(), sourceNode.getId(), null, String.format("\u5220\u9664\u5185\u90e8\u8282\u70b9%s\u3010%s\u3011,%s\u5c42\u521b\u5efa\u7684%s\u3010%s\u3011%s\u7c7b\u578b\u5b9e\u4f53\u7684\u5185\u90e8\u8282\u70b9\u3010%s %s\u3011\u5b58\u5728\u5f15\u7528\uff0c\u65e0\u6cd5\u5347\u7ea7\uff01", sourceNode.getNodeType(), sourceNode.getName(), refEntity.getModifiedLayer(), refEntity.getNodeType(), refEntity.getName(), refNode.getNodeType(), refNode.getName(), refProperty.getName()), null, null));
            validRef = true;
        }
        if (validRef) return modifyItems;
        modifyItems.add(this.createModifyItem(ModifyType.InnerNode_Delete, ModifyLevel.Must, sourceNode.getNodeType(), sourceNode.getId(), null, String.format("\u5220\u9664\u5185\u90e8\u8282\u70b9%s\u3010%s\u3011", sourceNode.getNodeType(), sourceNode.getName()), null, null));
        return modifyItems;
    }

    protected Element createModifyItem(ModifyType modifyType, ModifyLevel modifyLevel, String nodeType, String innerId, String propertyName, String description, String refEntityId, String refInnerId) {
        return this.createModifyItem(modifyType, modifyLevel, nodeType, innerId, propertyName, description, refEntityId, refInnerId, false);
    }

    protected Element createModifyItem(ModifyType modifyType, ModifyLevel modifyLevel, String nodeType, String innerId, String propertyName, String description, String refEntityId, String refInnerId, Boolean related) {
        Element modifyItem = DocumentHelper.createElement((String)"Item");
        modifyItem.addAttribute("modifyType", modifyType.name());
        modifyItem.addAttribute("modifyLevel", modifyLevel.name());
        modifyItem.addAttribute("nodeType", StringUtils.isNotBlank((String)nodeType) ? nodeType : "");
        modifyItem.addAttribute("innerId", StringUtils.isNotBlank((String)innerId) ? innerId : "");
        modifyItem.addAttribute("propertyName", StringUtils.isNotBlank((String)propertyName) ? propertyName : "");
        modifyItem.addAttribute("description", StringUtils.isNotBlank((String)description) ? description : "");
        modifyItem.addAttribute("select", Boolean.toString(modifyLevel == ModifyLevel.Must));
        modifyItem.addAttribute("related", related.toString());
        return modifyItem;
    }

    protected Element aggregationEntityResult(GOTEntity enntity, List<Element> items) {
        Element entityResult = DocumentHelper.createElement((String)enntity.getEntityType().name());
        entityResult.addAttribute("id", enntity.getId());
        entityResult.addAttribute("name", enntity.getName());
        for (Element element : items) {
            entityResult.add(element);
        }
        return entityResult;
    }

    private boolean isModifiedLayerSource(GOTModel got, GOTNode node) {
        GOTEntity entity = node.getEntity();
        String modifiedLayer = entity.getModifiedLayer();
        if ("app".equals(modifiedLayer)) {
            String solutionName = entity.getId().substring(0, entity.getId().lastIndexOf("."));
            SolutionDefinition solutionDefinition = got.getSolutionDefinition(solutionName);
            return solutionDefinition != null && solutionDefinition.getDeploymentMode() == SolutionDeploymentMode.Source;
        }
        if ("plg".equals(modifiedLayer)) {
            String solutionPluginName = entity.getId().substring(0, entity.getId().lastIndexOf("."));
            SolutionPluginDefinition solutionPluginDefinition = got.getSolutionPluginDefinition(solutionPluginName);
            return solutionPluginDefinition != null && solutionPluginDefinition.getDeploymentMode() == SolutionPluginDeploymentMode.Source;
        }
        if ("ext".equals(modifiedLayer)) {
            SolutionExtensionDefinition solutionExtensionDefinition = null;
            String namespace = entity.getId().substring(0, entity.getId().lastIndexOf("."));
            if ("plg".equals(node.getCreatedLayer())) {
                SolutionPluginDefinition solutionPluginDefinition = got.getSolutionPluginDefinition(namespace);
                solutionExtensionDefinition = got.getSolutionExtensionDefinition(solutionPluginDefinition.getSolutionName());
            } else {
                solutionExtensionDefinition = got.getSolutionExtensionDefinition(namespace);
            }
            return solutionExtensionDefinition != null && solutionExtensionDefinition.getDeploymentMode() == SolutionExtensionDeploymentMode.Source;
        }
        LayerDefination layerDefination = got.getLayerDefination(modifiedLayer);
        return layerDefination != null && layerDefination.getDeploymentMode() == LayerDeploymentMode.Source;
    }

    protected boolean ifHasMethodPromote(GOTEntity gotEntity, GOTModel gotModel) {
        String modifiedLayer;
        String createdLayer = gotEntity.getCreatedLayer();
        if (createdLayer.equals(modifiedLayer = gotEntity.getModifiedLayer())) {
            return false;
        }
        LayerDefinationManager layerDefinationManager = (LayerDefinationManager)ObjectContainer.getInstance(LayerDefinationManager.class);
        LayerDefination layerDefination = layerDefinationManager.getLayer(modifiedLayer);
        String layerName = layerDefination.getLayerName();
        LayerDeploymentMode currentDeployMode = this.getEntityLayerDeployMode(layerName, gotEntity, gotModel);
        if (currentDeployMode == null || currentDeployMode.equals((Object)LayerDeploymentMode.Package)) {
            return false;
        }
        String entityName = gotEntity.getName();
        if (entityName.contains(".")) {
            entityName = entityName.substring(entityName.lastIndexOf(".") + 1, entityName.length());
        }
        String lowerLayer = layerDefination.getLowerLayer();
        LayerDefination lowerLayerDefination = layerDefinationManager.getLayer(lowerLayer);
        while (lowerLayerDefination != null) {
            File entityFile = lowerLayerDefination.getEntityFile(gotEntity.getEntityType(), gotEntity.getName());
            if (entityFile != null || lowerLayerDefination.getLayerName().equals(createdLayer) || "Gongqi_ERP_No_More_Layer".equals(lowerLayer = lowerLayerDefination.getLowerLayer()) || lowerLayer == null) break;
            lowerLayerDefination = layerDefinationManager.getLayer(lowerLayer);
        }
        if ("Gongqi_ERP_No_More_Layer".equals(lowerLayer) || lowerLayer == null) {
            return false;
        }
        lowerLayer = lowerLayerDefination.getLayerName();
        LayerDeploymentMode lowerDeployMode = this.getEntityLayerDeployMode(lowerLayer, gotEntity, gotModel);
        if (EntityType.Table.equals((Object)gotEntity.getEntityType())) {
            LayerJavaCode currentJavaCode = this.createJavaCode(layerName, currentDeployMode, String.format("tables/%s.java", entityName), entityName, LayerJavaCode.JavaType.Table, gotEntity, gotModel);
            LayerJavaCode lowerJavaCode = this.createJavaCode(lowerLayer, lowerDeployMode, String.format("tables/%s.java", entityName), entityName, LayerJavaCode.JavaType.Table, gotEntity, gotModel);
            return this.compareJavaCode(currentJavaCode, lowerJavaCode);
        }
        if (EntityType.Class.equals((Object)gotEntity.getEntityType())) {
            LayerJavaCode currentJavaCode = this.createJavaCode(layerName, currentDeployMode, String.format("classes/%s.java", entityName), entityName, LayerJavaCode.JavaType.Class, gotEntity, gotModel);
            LayerJavaCode lowerJavaCode = this.createJavaCode(lowerLayer, lowerDeployMode, String.format("classes/%s.java", entityName), entityName, LayerJavaCode.JavaType.Class, gotEntity, gotModel);
            return this.compareJavaCode(currentJavaCode, lowerJavaCode);
        }
        if (EntityType.Form.equals((Object)gotEntity.getEntityType())) {
            LayerJavaCode lowerJavaCode;
            LayerJavaCode currentJavaCode = this.createJavaCode(layerName, currentDeployMode, String.format("forms/%s/Form_%s.java", entityName, entityName), entityName, LayerJavaCode.JavaType.Form, gotEntity, gotModel);
            if (this.compareJavaCode(currentJavaCode, lowerJavaCode = this.createJavaCode(lowerLayer, lowerDeployMode, String.format("forms/%s/Form_%s.java", entityName, entityName), entityName, LayerJavaCode.JavaType.Form, gotEntity, gotModel))) {
                return true;
            }
            List<GOTNode> formDataSources = gotEntity.selectNodes("FormDataSources/FormDataSource");
            for (GOTNode formDataSource : formDataSources) {
                currentJavaCode = this.createJavaCode(layerName, currentDeployMode, String.format("forms/%s/datasource/Form_%s_DataSource_%s.java", entityName, entityName, formDataSource.getName()), formDataSource.getName(), LayerJavaCode.JavaType.DataSource, gotEntity, gotModel);
                if (!this.compareJavaCode(currentJavaCode, lowerJavaCode = this.createJavaCode(lowerLayer, lowerDeployMode, String.format("forms/%s/datasource/Form_%s_DataSource_%s.java", entityName, entityName, formDataSource.getName()), formDataSource.getName(), LayerJavaCode.JavaType.DataSource, gotEntity, gotModel))) continue;
                return true;
            }
        }
        return false;
    }

    private boolean compareJavaCode(LayerJavaCode currentJavaCode, LayerJavaCode lowerJavaCode) {
        if (currentJavaCode == null || lowerJavaCode == null) {
            return false;
        }
        Set signatures = currentJavaCode.getLayerJavaMethods().stream().map(m -> m.getSignature()).collect(Collectors.toSet());
        for (LayerJavaMethod method : lowerJavaCode.getLayerJavaMethods()) {
            if (!signatures.contains(method.getSignature())) continue;
            return true;
        }
        return false;
    }

    private LayerJavaCode createJavaCode(String layerName, LayerDeploymentMode deployMode, String entityPath, String simpleName, LayerJavaCode.JavaType javaType, GOTEntity gotEntity, GOTModel gotModel) {
        String javaContent = this.getJavaContent(layerName, gotEntity, gotModel, entityPath);
        if (StringUtils.isBlank((String)javaContent)) {
            return null;
        }
        LayerJavaCode javaCode = new LayerJavaCode();
        javaCode.setLayerName(layerName);
        javaCode.setDeploymentMode(deployMode);
        javaCode.setSimpleName(simpleName);
        javaCode.setJavaType(javaType);
        javaCode.setContent(javaContent);
        return javaCode;
    }

    private LayerDeploymentMode getEntityLayerDeployMode(String layerName, GOTEntity gotEntity, GOTModel gotModel) {
        if ("app".equals(layerName)) {
            String id = gotEntity.getId();
            String solutionName = id.substring(0, id.lastIndexOf("."));
            SolutionDefinition solutionDefinition = gotModel.getSolutionDefinition(solutionName);
            if (solutionDefinition == null) {
                return null;
            }
            if (solutionDefinition.getDeploymentMode().equals((Object)SolutionDeploymentMode.Package)) {
                return LayerDeploymentMode.Package;
            }
        } else if ("plg".equals(layerName)) {
            String id = gotEntity.getId();
            String solutionPluginName = id.substring(0, id.lastIndexOf("."));
            SolutionPluginDefinition pluginDefinition = gotModel.getSolutionPluginDefinition(solutionPluginName);
            if (pluginDefinition == null) {
                return null;
            }
            if (pluginDefinition.getDeploymentMode().equals((Object)SolutionPluginDeploymentMode.Package)) {
                return LayerDeploymentMode.Package;
            }
        } else if ("ext".equals(layerName)) {
            String id = gotEntity.getId();
            if ("plg".equals(gotEntity.getCreatedLayer())) {
                String pluginName = id.substring(0, id.lastIndexOf("."));
                SolutionPluginDefinition pluginDefinition = gotModel.getSolutionPluginDefinition(pluginName);
                SolutionExtensionDefinition extensionDefinition = gotModel.getSolutionExtensionDefinition(pluginDefinition.getSolutionName());
                if (extensionDefinition.getDeploymentMode().equals((Object)SolutionExtensionDeploymentMode.Package)) {
                    return LayerDeploymentMode.Package;
                }
            } else {
                String solutionName = id.substring(0, id.lastIndexOf("."));
                SolutionExtensionDefinition extensionDefinition = gotModel.getSolutionExtensionDefinition(solutionName);
                if (extensionDefinition == null) {
                    return null;
                }
                if (extensionDefinition.getDeploymentMode().equals((Object)SolutionExtensionDeploymentMode.Package)) {
                    return LayerDeploymentMode.Package;
                }
            }
        } else {
            LayerDefination layerDefination = gotModel.getLayerDefination(layerName);
            if (layerDefination == null) {
                return null;
            }
            if (layerDefination.getDeploymentMode().equals((Object)LayerDeploymentMode.Package)) {
                return LayerDeploymentMode.Package;
            }
        }
        return LayerDeploymentMode.Source;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private String getJavaContent(String layerName, GOTEntity gotEntity, GOTModel gotModel, String entityPath) {
        File projectDir = new File(FrameworkEnvironment.getGongqiDir(), "Project/Server/LayerProject");
        if ("app".equals(layerName)) {
            String id = gotEntity.getId();
            String solutionName = id.substring(0, id.lastIndexOf("."));
            SolutionDefinition solutionDefinition = gotModel.getSolutionDefinition(solutionName);
            if (solutionDefinition == null) {
                return null;
            }
            if (solutionDefinition.getDeploymentMode().equals((Object)SolutionDeploymentMode.Package)) {
                String binaryDir = solutionDefinition.getSolutionBinaryDir();
                File sourceJar = new File(binaryDir, String.format("%s-source.jar", solutionName));
                if (!sourceJar.exists()) return null;
                return this.getJavaContentInJar(sourceJar, String.format("%s/layers/app/%s", solutionName.replace(".", "/"), entityPath));
            }
            File javaFile = new File(projectDir, String.format("app_%s/%s/layers/app/%s", solutionName, solutionName.replace(".", "/"), entityPath));
            try {
                return FileUtils.readFileToString((File)javaFile, (Charset)StandardCharsets.UTF_8);
            }
            catch (IOException iOException) {
                this.log.error((Object)("\u8bfb\u53d6\u6587\u4ef6\u5931\u8d25\uff1a" + javaFile.getAbsolutePath()));
                return null;
            }
        } else if ("plg".equals(layerName)) {
            String id = gotEntity.getId();
            String solutionPluginName = id.substring(0, id.lastIndexOf("."));
            SolutionPluginDefinition pluginDefinition = gotModel.getSolutionPluginDefinition(solutionPluginName);
            if (pluginDefinition == null) {
                return null;
            }
            if (pluginDefinition.getDeploymentMode().equals((Object)SolutionPluginDeploymentMode.Package)) {
                String binaryDir = pluginDefinition.getPluginBinaryDir();
                File sourceJar = new File(binaryDir, String.format("%s-source.jar", solutionPluginName));
                if (!sourceJar.exists()) return null;
                return this.getJavaContentInJar(sourceJar, String.format("%s/layers/plg/%s", solutionPluginName.replace(".", "/"), entityPath));
            }
            File javaFile = new File(projectDir, String.format("plg_%s/%s/layers/plg/%s", solutionPluginName, solutionPluginName.replace(".", "/"), entityPath));
            try {
                return FileUtils.readFileToString((File)javaFile, (Charset)StandardCharsets.UTF_8);
            }
            catch (IOException iOException) {
                this.log.error((Object)("\u8bfb\u53d6\u6587\u4ef6\u5931\u8d25\uff1a" + javaFile.getAbsolutePath()));
                return null;
            }
        } else if ("ext".equals(layerName)) {
            String id = gotEntity.getId();
            String solutionName = null;
            SolutionExtensionDefinition extensionDefinition = null;
            if ("plg".equals(gotEntity.getCreatedLayer())) {
                String pluginName = id.substring(0, id.lastIndexOf("."));
                SolutionPluginDefinition pluginDefinition = gotModel.getSolutionPluginDefinition(pluginName);
                solutionName = pluginDefinition.getSolutionName();
                extensionDefinition = gotModel.getSolutionExtensionDefinition(pluginDefinition.getSolutionName());
            } else {
                solutionName = id.substring(0, id.lastIndexOf("."));
                extensionDefinition = gotModel.getSolutionExtensionDefinition(solutionName);
            }
            if (extensionDefinition == null) {
                return null;
            }
            if (extensionDefinition.getDeploymentMode().equals((Object)SolutionExtensionDeploymentMode.Package)) {
                String binaryDir = extensionDefinition.getExtensionBinaryDir();
                File sourceJar = new File(binaryDir, String.format("%s-source.jar", solutionName));
                String entityName = gotEntity.getName();
                entityName = entityName.substring(entityName.lastIndexOf(".") + 1, entityName.length());
                if (!sourceJar.exists()) return null;
                return this.getJavaContentInJar(sourceJar, String.format("%s/layers/ext/%s", solutionName.replace(".", "/"), entityPath));
            }
            File javaFile = new File(projectDir, String.format("ext_%s/%s/layers/ext/%s", solutionName, solutionName.replace(".", "/"), entityPath));
            try {
                return FileUtils.readFileToString((File)javaFile, (Charset)StandardCharsets.UTF_8);
            }
            catch (IOException iOException) {
                this.log.error((Object)("\u8bfb\u53d6\u6587\u4ef6\u5931\u8d25\uff1a" + javaFile.getAbsolutePath()));
                return null;
            }
        } else {
            LayerDefination layerDefination = gotModel.getLayerDefination(layerName);
            if (layerDefination == null) {
                return null;
            }
            if (layerDefination.getDeploymentMode().equals((Object)LayerDeploymentMode.Package)) {
                String binaryDir = layerDefination.getLayerBinaryDir();
                File sourceJar = new File(binaryDir, String.format("layer_%s-source.jar", layerName));
                if (!sourceJar.exists()) return null;
                return this.getJavaContentInJar(sourceJar, String.format("gongqi/erp/layers/%s/%s", layerName, entityPath));
            }
            File javaFile = new File(projectDir, String.format("layer_%s/gongqi/erp/layers/%s/%s", layerName, layerName, entityPath));
            try {
                return FileUtils.readFileToString((File)javaFile, (Charset)StandardCharsets.UTF_8);
            }
            catch (IOException iOException) {
                this.log.error((Object)("\u8bfb\u53d6\u6587\u4ef6\u5931\u8d25\uff1a" + javaFile.getAbsolutePath()));
            }
        }
        return null;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private String getJavaContentInJar(File jarFile, String javaPath) {
        StringBuilder content = new StringBuilder();
        try {
            Throwable throwable = null;
            Object var5_7 = null;
            try (ZipFile zipFile = new ZipFile(jarFile.getAbsoluteFile());){
                ZipEntry entry = zipFile.getEntry(javaPath);
                if (entry == null) {
                    return null;
                }
                Throwable throwable2 = null;
                Object var9_13 = null;
                try (BufferedReader reader = new BufferedReader(new InputStreamReader(zipFile.getInputStream(entry), StandardCharsets.UTF_8));){
                    while (true) {
                        String line;
                        if ((line = reader.readLine()) == null) {
                            return content.toString();
                        }
                        content.append(line).append(System.lineSeparator());
                    }
                }
                catch (Throwable throwable3) {
                    if (throwable2 == null) {
                        throwable2 = throwable3;
                        throw throwable2;
                    }
                    if (throwable2 == throwable3) throw throwable2;
                    throwable2.addSuppressed(throwable3);
                    throw throwable2;
                }
            }
            catch (Throwable throwable4) {
                if (throwable == null) {
                    throwable = throwable4;
                    throw throwable;
                }
                if (throwable == throwable4) throw throwable;
                throwable.addSuppressed(throwable4);
                throw throwable;
            }
        }
        catch (Exception e) {
            this.log.error((Object)String.format("\u83b7\u53d6Jar\u3010%s\u3011\u7684\u7c7b\u3010%s\u3011\u65f6\u51fa\u73b0\u5f02\u5e38", jarFile.getAbsolutePath(), javaPath), (Throwable)e);
        }
        return content.toString();
    }
}

