/*
 * Decompiled with CFR 0.152.
 */
package gongqi.gdt.designer.service.analysis;

import com.ximpleware.VTDException;
import gongqi.erp.gotmodel.core.EntityType;
import gongqi.gdt.designer.service.GOTModel;
import gongqi.gdt.designer.service.ProgressMonitor;
import gongqi.gdt.designer.service.analysis.BaseAnalysis;
import gongqi.gdt.designer.service.modify.ModifyLevel;
import gongqi.gdt.designer.service.modify.ModifyType;
import gongqi.gdt.designer.service.node.GOTEntity;
import gongqi.gdt.designer.service.node.GOTNode;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Collectors;
import org.dom4j.Element;

public class FormAnalysis
extends BaseAnalysis {
    public FormAnalysis(GOTModel sourceGOT, GOTModel targetGOT, GOTModel originalGOT) {
        super(sourceGOT, targetGOT, originalGOT);
    }

    @Override
    public final void analysis(ProgressMonitor monitor) {
        long currentTimeMillis = System.currentTimeMillis();
        EntityType entityType = this.getSupportEntityType();
        Collection<GOTEntity> allEntities = this.targetGOT.getEntitys(entityType).values();
        long totalSize = allEntities.stream().mapToLong(GOTEntity::getSize).sum();
        int partCount = 3;
        long avgPartSize = totalSize / (long)partCount;
        long remainingSize = totalSize % (long)partCount;
        ArrayList partitions = new ArrayList();
        ArrayList<GOTEntity> currentPartition = new ArrayList<GOTEntity>();
        long currentPartitionSize = 0L;
        for (GOTEntity entity : allEntities) {
            if (currentPartitionSize + (long)entity.getSize() > avgPartSize + (long)((long)partitions.size() < remainingSize ? 1 : 0)) {
                partitions.add(currentPartition);
                currentPartition = new ArrayList();
                currentPartitionSize = 0L;
            }
            currentPartition.add(entity);
            currentPartitionSize += (long)entity.getSize();
        }
        if (!currentPartition.isEmpty()) {
            partitions.add(currentPartition);
        }
        try {
            CompletableFuture.allOf(CompletableFuture.runAsync(() -> {
                if (partitions.size() > 0) {
                    this.forwardAnalysis((Collection)partitions.get(0), monitor);
                }
            }), CompletableFuture.runAsync(() -> {
                if (partitions.size() > 1) {
                    this.forwardAnalysis((Collection)partitions.get(1), monitor);
                }
            }), CompletableFuture.runAsync(() -> {
                if (partitions.size() > 2) {
                    int i = 2;
                    while (i < partitions.size()) {
                        this.forwardAnalysis((Collection)partitions.get(i), monitor);
                        ++i;
                    }
                }
            })).get();
        }
        catch (Throwable e) {
            throw new RuntimeException(String.format("%s\u5b9e\u4f53\u5206\u6790\u9519\u8bef", entityType), e);
        }
        this.backwardAnalysis(this.sourceGOT.getEntitys(entityType).values(), monitor);
        System.out.println(String.valueOf(entityType.name()) + "\u8282\u70b9\u5206\u6790\u8017\u65f6:" + (System.currentTimeMillis() - currentTimeMillis));
    }

    @Override
    protected EntityType getSupportEntityType() {
        return EntityType.Form;
    }

    @Override
    protected List<Element> analysisEntityInnerModify(GOTEntity sourceEntity, GOTEntity targetEntity) throws VTDException {
        ArrayList<Element> modifyItems = new ArrayList<Element>();
        String nodeBaseXPath = "FormDataSources";
        GOTNode targetFormDataSources = targetEntity.selectSingleNode(nodeBaseXPath);
        modifyItems.addAll(this.analysisInnerNode(targetFormDataSources));
        nodeBaseXPath = "FormDataSources/FormDataSource";
        for (GOTNode targetFormDataSource : targetEntity.selectNodes(nodeBaseXPath)) {
            modifyItems.addAll(this.analysisInnerNode(targetFormDataSource));
            if (sourceEntity.selectSingleNode(targetFormDataSource.getEntityXPath()) == null) continue;
            nodeBaseXPath = "FormDataSourceFields/FormDataSourceField";
            for (GOTNode gOTNode : targetFormDataSource.selectNodes(nodeBaseXPath)) {
                modifyItems.addAll(this.analysisInnerNode(gOTNode));
            }
            nodeBaseXPath = "FormDataSourceFieldGroups/FormDataSourceFieldGroup";
            for (GOTNode gOTNode : targetFormDataSource.selectNodes(nodeBaseXPath)) {
                modifyItems.addAll(this.analysisInnerNode(gOTNode));
            }
            nodeBaseXPath = "FormDataSourceRelation/FormDataSourceRelationItem";
            for (GOTNode gOTNode : targetFormDataSource.selectNodes(nodeBaseXPath)) {
                modifyItems.addAll(this.analysisInnerNode(gOTNode));
            }
        }
        nodeBaseXPath = "FormDesign";
        GOTNode targetFormDesign = targetEntity.selectSingleNode(nodeBaseXPath);
        modifyItems.addAll(this.analysisInnerNode(targetFormDesign));
        nodeBaseXPath = ".//FormItem";
        for (GOTNode targetFormItem : targetFormDesign.selectNodes(nodeBaseXPath)) {
            modifyItems.addAll(this.analysisInnerNode(targetFormItem));
        }
        GOTEntity entity = this.originalTargetGOT.getEntityById(sourceEntity.getEntityType(), sourceEntity.getId());
        if (entity == null) {
            return modifyItems;
        }
        GOTNode gOTNode = entity.selectSingleNode("FormDesign");
        List<GOTNode> targetFormItems = targetFormDesign.getChildNodeBFS(true);
        List<GOTNode> transitionFormItems = gOTNode.getChildNodeBFS(true);
        if (targetFormItems.size() == transitionFormItems.size()) {
            int i = 0;
            while (i < targetFormItems.size()) {
                if (targetFormItems.get(i).getId() != null && !targetFormItems.get(i).getId().equals(transitionFormItems.get(i).getId())) {
                    modifyItems.add(this.createModifyItem(ModifyType.InnerNode_Order, ModifyLevel.Must, targetFormDesign.getNodeType(), null, null, String.format("Form\u3010%s %s\u3011\u753b\u9762\u7ed3\u6784\u8c03\u6574", sourceEntity.getId(), sourceEntity.getName()), null, null));
                    break;
                }
                ++i;
            }
        } else {
            modifyItems.add(this.createModifyItem(ModifyType.InnerNode_Order, ModifyLevel.Must, targetFormDesign.getNodeType(), null, null, String.format("Form\u3010%s %s\u3011\u753b\u9762\u7ed3\u6784\u8c03\u6574", sourceEntity.getId(), sourceEntity.getName()), null, null));
        }
        return modifyItems;
    }

    @Override
    protected List<Element> analysisEntityInnerDelete(GOTEntity sourceEntity, GOTEntity targetEntity) throws VTDException {
        ArrayList<Element> items = new ArrayList<Element>();
        for (GOTNode sourceFormDataSource : sourceEntity.selectNodes("FormDataSources/FormDataSource")) {
            items.addAll(this.analysisReverseInnerNode(sourceFormDataSource));
            GOTNode targetFormDataSource = targetEntity.selectSingleNode(sourceFormDataSource.getEntityXPath());
            if (targetFormDataSource == null) continue;
            for (GOTNode sourceFormDataSourceFieldGroup : sourceFormDataSource.selectNodes("FormDataSourceFieldGroups/FormDataSourceFieldGroup")) {
                items.addAll(this.analysisReverseInnerNode(sourceFormDataSourceFieldGroup));
            }
            for (GOTNode sourceFormDataSourceRelationItem : sourceFormDataSource.selectNodes("FormDataSourceRelation/FormDataSourceRelationItem")) {
                items.addAll(this.analysisReverseInnerNode(sourceFormDataSourceRelationItem));
            }
        }
        List targetFormItemIds = targetEntity.selectNodes("//FormItem").stream().map(f -> f.getId()).collect(Collectors.toList());
        for (GOTNode sourceFormItem : sourceEntity.selectNodes("//FormItem")) {
            if (this.sourceGOT.isSourceDeployment(sourceFormItem.getCreatedLayer(), sourceEntity, sourceFormItem.getId()) || targetFormItemIds.contains(sourceFormItem.getId())) continue;
            items.add(this.createModifyItem(ModifyType.InnerNode_Order, ModifyLevel.Must, "FormDesign", null, null, "\u753b\u9762\u7ed3\u6784\u8c03\u6574", null, null));
            break;
        }
        return items;
    }
}

