/*
 * Decompiled with CFR 0.152.
 */
package gongqi.gdt.designer.ui;

import com.alibaba.fastjson.JSONObject;
import com.ximpleware.NavException;
import com.ximpleware.VTDException;
import gongqi.designer.core.DesignerServer;
import gongqi.designer.got.vtd.EntityNode;
import gongqi.designer.got.vtd.GOTNode;
import gongqi.erp.framework.core.FrameworkManager;
import gongqi.erp.framework.core.GongqiEnvironment;
import gongqi.erp.framework.core.LayerDefination;
import gongqi.erp.framework.core.LayerDeploymentMode;
import gongqi.erp.framework.core.LayerLocator;
import gongqi.erp.framework.core.LayerResolver;
import gongqi.erp.framework.core.ObjectContainer;
import gongqi.erp.framework.core.plugin.SolutionPluginDeploymentMode;
import gongqi.erp.framework.core.solution.SolutionDeploymentMode;
import gongqi.erp.framework.exception.ERPException;
import gongqi.erp.framework.tools.ZipUtil;
import gongqi.erp.framework.util.FileUtils;
import gongqi.erp.gotmodel.core.EntityType;
import gongqi.gdt.designer.ProjectConstants;
import gongqi.gdt.designer.handler.JDTHandler;
import gongqi.gdt.designer.service.BackupService;
import gongqi.gdt.designer.service.LayerUpgradeService;
import gongqi.gdt.designer.service.ProgressMonitor;
import gongqi.gdt.designer.service.modify.ModifyLevel;
import gongqi.gdt.designer.service.modify.ModifyType;
import gongqi.gdt.designer.service.node.GOTEntity;
import gongqi.gdt.designer.service.node.GOTProperty;
import gongqi.gdt.designer.ui.DatabaseConflictDialog;
import gongqi.gdt.designer.ui.DatabaseDifDialog;
import gongqi.gdt.designer.ui.ErrorInfoDialog;
import gongqi.gdt.designer.ui.LayerChainFilter;
import gongqi.gdt.designer.ui.LayerChainPage;
import gongqi.gdt.designer.ui.NodeRelationErrorDialog;
import gongqi.gdt.designer.ui.StructureCompare;
import gongqi.gdt.designer.utils.EntityMethods;
import gongqi.gdt.designer.utils.Images;
import gongqi.gdt.designer.utils.LayerChainConfig;
import gongqi.gdt.designer.utils.LayerJavaCode;
import gongqi.gdt.designer.utils.LayerJavaMethod;
import gongqi.gdt.designer.utils.MarketUtil;
import gongqi.gdt.designer.utils.MergeDatabaseUtil;
import gongqi.gdt.designer.utils.PedestalLayerInfo;
import gongqi.gdt.designer.utils.RenameNode;
import gongqi.gdt.designer.utils.SWTUtils;
import gongqi.gdt.designer.utils.SolutionLayerInfo;
import gongqi.gdt.designer.utils.SolutionPluginInfo;
import gongqi.gdt.osgi.JDTService;
import gongqi.gdt.util.EclipsePluginUtils;
import info.gongqi.got.database.Database;
import info.gongqi.got.database.DatabaseFactory;
import info.gongqi.got.datadictionary.Datadictionary;
import info.gongqi.got.model.GotXmlDto;
import info.gongqi.got.tool.FormDataSyn;
import info.gongqi.got.ui.TreeUi;
import info.gongqi.got.ui.TreeUiBean;
import info.gongqi.got.ui.compare.JavaCodeTypedElement;
import info.gongqi.got.util.ComposeIMG;
import info.gongqi.got.util.GOTMessageDialog;
import java.io.File;
import java.io.FileFilter;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.invoke.LambdaMetafactory;
import java.lang.reflect.InvocationTargetException;
import java.net.Socket;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.exception.ExceptionUtils;
import org.apache.http.HttpEntity;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.util.EntityUtils;
import org.apache.log4j.Logger;
import org.apache.poi.hssf.usermodel.HSSFCellStyle;
import org.apache.poi.hssf.usermodel.HSSFFont;
import org.apache.poi.hssf.usermodel.HSSFRow;
import org.apache.poi.hssf.usermodel.HSSFSheet;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.ss.usermodel.IndexedColors;
import org.apache.poi.ss.util.CellRangeAddress;
import org.dom4j.DocumentException;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;
import org.eclipse.compare.CompareConfiguration;
import org.eclipse.compare.CompareUI;
import org.eclipse.compare.CompareViewerSwitchingPane;
import org.eclipse.compare.ITypedElement;
import org.eclipse.compare.structuremergeviewer.DiffNode;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.jdt.core.dom.Modifier;
import org.eclipse.jdt.core.dom.Type;
import org.eclipse.jdt.ui.text.JavaSourceViewerConfiguration;
import org.eclipse.jdt.ui.text.JavaTextTools;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.source.SourceViewer;
import org.eclipse.jface.text.source.SourceViewerConfiguration;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.window.Window;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.events.ControlAdapter;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TabFolder;
import org.eclipse.swt.widgets.TabItem;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolItem;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeColumn;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.ui.preferences.ScopedPreferenceStore;

public class AnalysisResultPage {
    private Shell shell;
    private static Logger log = Logger.getLogger(AnalysisResultPage.class);
    private Tree gotTree;
    private Table detailTable;
    private Tree compareTree;
    private Tree propertyInfoTree;
    private Tree javaMethodTree;
    private TabFolder tabFolder;
    private ToolBar modelToolBar;
    private ToolBar javaToolBar;
    private Composite left;
    private Composite right;
    private Composite modelResultComposite;
    private Composite viewComposite;
    private SashForm mainComposite;
    private SashForm treeResultComposite;
    private SashForm codeResultComposite;
    private boolean analysis_Finish = false;
    private boolean upgrade_Succeed = false;
    private Button button_Resource;
    private Button button_analysis;
    private Button button_ExportExcel;
    private Button button_Upgrade;
    private LayerUpgradeService upgradeService = new LayerUpgradeService();
    private static Element structureXML;
    private static List<String> ignoreAnalysisPropertys;
    private ToolItem addButton;
    private ToolItem deleteButton;
    private ToolItem difButton;
    private ToolItem sameButton;
    private ToolItem showPublic;
    private ToolItem showProtect;
    private ToolItem showPrivate;
    private ToolItem showDefault;
    private ToolItem showPromote;
    private ToolItem showOrigin;
    private ToolItem showSource;
    private ToolItem showTarget;
    private ToolItem origin_Source;
    private ToolItem target_origin;
    private CompareViewerSwitchingPane compareViewerPane;
    private SourceViewer javaCodeText;
    private Label resourceInfo;
    private Label tipInfo;
    private static Image addImage;
    private static Image deleteImage;
    private static Image difImage;
    private static Image sameImage;
    private static Image orderImage;
    private static Image promoteImage;
    private static Image noAddImage;
    private static Image noDeleteImage;
    private static Image noDifImage;
    private static Image noSameImage;
    private static Image publicMethod;
    private static Image protectMethod;
    private static Image privateMethod;
    private static Image defaultMethod;
    private List<Element> analysisResult_Cache = new ArrayList<Element>();
    private Font font = new Font((Device)Display.getCurrent(), "\u5fae\u8f6f\u96c5\u9ed1", 9, 0);
    private LayerChainConfig layerChainConfig = new LayerChainConfig();
    private static List<DisplayType> displayScope;
    private Listener paintListener = new Listener(){

        public void handleEvent(Event event) {
            if ((event.detail & 2) != 0) {
                TreeItem treeItem = (TreeItem)event.item;
                if (treeItem == null) {
                    return;
                }
                Rectangle bounds = treeItem.getBounds();
                Color color = null;
                color = treeItem.getParent().isFocusControl() ? new Color((Device)Display.getCurrent(), 204, 232, 255) : new Color((Device)Display.getCurrent(), 217, 217, 217);
                event.gc.setBackground(color);
                event.gc.fillRectangle(bounds.x, bounds.y, bounds.width, bounds.height);
                event.gc.setForeground(treeItem.getForeground());
                event.gc.drawText(treeItem.getText(), bounds.x, bounds.y, true);
            }
        }
    };
    private static AnalysisResultPage analysisResultPage;

    static {
        ignoreAnalysisPropertys = Arrays.asList("CreatedDate", "CreatedTime", "CreatedBy", "ModifiedDate", "ModifiedTime", "ModifiedBy");
        displayScope = new ArrayList<DisplayType>(Arrays.asList(DisplayType.Add, DisplayType.Dif, DisplayType.Delete));
        addImage = Images.getIcon("layerUpgrade/Add.png", SWTUtils.zoom(16), SWTUtils.zoom(16));
        deleteImage = Images.getIcon("layerUpgrade/Delete.png", SWTUtils.zoom(16), SWTUtils.zoom(16));
        difImage = Images.getIcon("layerUpgrade/Dif.png", SWTUtils.zoom(16), SWTUtils.zoom(16));
        sameImage = Images.getIcon("layerUpgrade/Same.png", SWTUtils.zoom(16), SWTUtils.zoom(16));
        orderImage = Images.getIcon("layerUpgrade/Order.png", SWTUtils.zoom(16), SWTUtils.zoom(16));
        promoteImage = Images.getIcon("layerUpgrade/JavaPromote.png", SWTUtils.zoom(16), SWTUtils.zoom(16));
        noAddImage = Images.getIcon("layerUpgrade/noAdd.png", SWTUtils.zoom(16), SWTUtils.zoom(16));
        noDeleteImage = Images.getIcon("layerUpgrade/noDelete.png", SWTUtils.zoom(16), SWTUtils.zoom(16));
        noDifImage = Images.getIcon("layerUpgrade/noDif.png", SWTUtils.zoom(16), SWTUtils.zoom(16));
        noSameImage = Images.getIcon("layerUpgrade/noSame.png", SWTUtils.zoom(16), SWTUtils.zoom(16));
        publicMethod = Images.getIcon("layerUpgrade/Method_Public.png", SWTUtils.zoom(16), SWTUtils.zoom(16));
        protectMethod = Images.getIcon("layerUpgrade/Method_Protect.png", SWTUtils.zoom(16), SWTUtils.zoom(16));
        privateMethod = Images.getIcon("layerUpgrade/Method_Private.png", SWTUtils.zoom(16), SWTUtils.zoom(16));
        defaultMethod = Images.getIcon("layerUpgrade/Method_Default.png", SWTUtils.zoom(16), SWTUtils.zoom(16));
        try {
            structureXML = DocumentHelper.parseText((String)"<GOT>\r\n\t<DataDictionary>\r\n\t\t<Enums>\r\n\t\t\t<EnumItem/>\r\n\t\t</Enums>\r\n\t\t<DataTypes>\r\n\t\t\t<DataTypeRelation/>\r\n\t\t</DataTypes>\r\n\t\t<Tables>\r\n\t\t\t<TableFields type=\"Default\">\r\n\t\t\t\t<TableField/>\r\n\t\t\t</TableFields>\r\n\t\t\t<TableIndexes type=\"Default\">\r\n\t\t\t\t<TableIndex>\r\n\t\t\t\t\t<TableIndexItem/>\r\n\t\t\t\t</TableIndex>\r\n\t\t\t</TableIndexes>\r\n\t\t\t<TableFieldGroups type=\"Default\">\r\n\t\t\t\t<TableFieldGroup>\r\n\t\t\t\t\t<TableFieldGroupItem/>\r\n\t\t\t\t</TableFieldGroup>\r\n\t\t\t</TableFieldGroups>\r\n\t\t</Tables>\r\n\t</DataDictionary>\r\n\t<Menus>\r\n\t\t<MenuSub>\r\n\t\t\t<MenuRefMenuItem/>\r\n\t\t</MenuSub>\r\n\t\t<MenuRefMenuItem/>\r\n\t</Menus>\r\n\t<MenuItems/>\r\n\t<Forms>\r\n\t\t<FormDataSources type=\"Default\">\r\n\t\t\t<FormDataSource>\r\n\t\t\t\t<FormDataSourceFields type=\"Default\">\r\n\t\t\t\t\t<FormDataSourceField/>\r\n\t\t\t\t</FormDataSourceFields>\r\n\t\t\t\t<FormDataSourceFieldGroups type=\"Default\">\r\n\t\t\t\t\t<FormDataSourceFieldGroup/>\r\n\t\t\t\t</FormDataSourceFieldGroups>\r\n\t\t\t\t<FormDataSourceRelation type=\"Default\">\r\n\t\t\t\t\t<FormDataSourceRelationItem/>\r\n\t\t\t\t</FormDataSourceRelation>\r\n\t\t\t</FormDataSource>\r\n\t\t</FormDataSources>\r\n\t\t<FormDesign type=\"Default\">\r\n\t\t\t<FormItem/>\r\n\t\t</FormDesign>\r\n\t</Forms>\r\n\t<Reports/>\r\n\t<Classes>\r\n\t\t<Class/>\r\n\t</Classes>\r\n</GOT>").getRootElement();
        }
        catch (DocumentException documentException) {}
    }

    public Shell getCurrentShell() {
        return this.shell;
    }

    public static AnalysisResultPage getInstance() {
        if (analysisResultPage == null) {
            analysisResultPage = new AnalysisResultPage();
        }
        return analysisResultPage;
    }

    public void show() {
        if (this.shell == null || this.shell.isDisposed()) {
            this.createContent();
            this.buildGOTTree();
            this.updateButtonStatus();
            this.shell.open();
            LayerChainPage layerChainPage = LayerChainPage.getInstance();
            layerChainPage.setConfirmCallBack(info -> {
                this.button_analysis.setEnabled(true);
                this.analysis_Finish = false;
                this.updateButtonStatus();
            });
            layerChainPage.setOpenCallBack(info -> this.resourceInfo.setText(info));
            layerChainPage.open();
        } else {
            this.shell.setMinimized(false);
            this.shell.setMaximized(false);
        }
    }

    protected void createContent() {
        Display display = Display.getCurrent();
        this.shell = new Shell(display.getActiveShell(), 208);
        this.shell.setText("\u5c42\u94fe\u5347\u7ea7");
        this.shell.setLayout((Layout)new FormLayout());
        this.shell.setSize(SWTUtils.zoom(1200), SWTUtils.zoom(600));
        Rectangle bounds = Display.getDefault().getPrimaryMonitor().getBounds();
        Rectangle rect = this.shell.getBounds();
        int x = bounds.x + (bounds.width - rect.width) / 2;
        int y = bounds.y + (bounds.height - rect.height) / 2;
        this.shell.setLocation(x, y);
        this.shell.addListener(21, event -> {
            MessageBox messageBox = new MessageBox(this.shell, 196);
            messageBox.setMessage("\u662f\u5426\u9000\u51fa\u5c42\u94fe\u5347\u7ea7");
            int response = messageBox.open();
            if (response == 128) {
                event.doit = false;
            }
        });
        this.mainComposite = new SashForm((Composite)this.shell, 256);
        FormData formData = new FormData();
        formData.left = new FormAttachment(0, SWTUtils.zoom(5));
        formData.right = new FormAttachment(100, SWTUtils.zoom(-90));
        formData.top = new FormAttachment(0, SWTUtils.zoom(5));
        formData.bottom = new FormAttachment(100, SWTUtils.zoom(-5));
        this.mainComposite.setLayoutData((Object)formData);
        this.mainComposite.setLayout((Layout)new FormLayout());
        this.createGOTArea();
        this.createTabFolder();
        this.mainComposite.setWeights(new int[]{1, 3});
        this.button_Resource = new Button((Composite)this.shell, 8);
        this.button_Resource.setText("\u5347\u7ea7\u6587\u4ef6");
        formData = new FormData(SWTUtils.zoom(80), SWTUtils.zoom(32));
        formData.top = new FormAttachment((Control)this.mainComposite, 0, 128);
        formData.left = new FormAttachment((Control)this.mainComposite, SWTUtils.zoom(5), 131072);
        this.button_Resource.setLayoutData((Object)formData);
        this.button_analysis = new Button((Composite)this.shell, 8);
        this.button_analysis.setText("\u5185\u5bb9\u5206\u6790");
        formData = new FormData(SWTUtils.zoom(80), SWTUtils.zoom(32));
        formData.top = new FormAttachment((Control)this.button_Resource, SWTUtils.zoom(5), 1024);
        formData.left = new FormAttachment((Control)this.button_Resource, 0, 16384);
        this.button_analysis.setLayoutData((Object)formData);
        this.button_ExportExcel = new Button((Composite)this.shell, 8);
        this.button_ExportExcel.setText("\u5bfc\u51fa\u7ed3\u679c");
        formData = new FormData(SWTUtils.zoom(80), SWTUtils.zoom(32));
        formData.top = new FormAttachment((Control)this.button_analysis, SWTUtils.zoom(5), 1024);
        formData.left = new FormAttachment((Control)this.button_analysis, 0, 16384);
        this.button_ExportExcel.setLayoutData((Object)formData);
        this.button_Upgrade = new Button((Composite)this.shell, 8);
        this.button_Upgrade.setText("\u786e\u8ba4\u5347\u7ea7");
        formData = new FormData(SWTUtils.zoom(80), SWTUtils.zoom(32));
        formData.top = new FormAttachment((Control)this.button_ExportExcel, SWTUtils.zoom(5), 1024);
        formData.left = new FormAttachment((Control)this.button_ExportExcel, 0, 16384);
        this.button_Upgrade.setLayoutData((Object)formData);
        this.button_Resource.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                LayerChainPage.getInstance().open();
            }
        });
        this.button_analysis.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                MessageBox messagebox = new MessageBox(GOTMessageDialog.shell, 196);
                messagebox.setText("\u5185\u5bb9\u5206\u6790");
                messagebox.setMessage("\u786e\u5b9a\u5f00\u59cb\u8fdb\u884c\u5185\u5bb9\u5206\u6790");
                int message = messagebox.open();
                if (message == 64) {
                    try {
                        List<String> results = LayerChainPage.getInstance().checkBeforeAnalysis();
                        if (results.isEmpty()) {
                            long currentTimeMillis = System.currentTimeMillis();
                            AnalysisResultPage.this.analysis();
                            log.info((Object)("\u5185\u5bb9\u5206\u6790\u603b\u8017\u65f6:" + (System.currentTimeMillis() - currentTimeMillis)));
                        } else {
                            MessageDialog.openError((Shell)AnalysisResultPage.this.shell, (String)"\u63d0\u793a", (String)String.join((CharSequence)System.lineSeparator(), results));
                        }
                    }
                    catch (Exception e1) {
                        e1.printStackTrace();
                        MessageDialog.openError((Shell)AnalysisResultPage.this.shell, (String)"\u63d0\u793a", (String)e1.getMessage());
                    }
                }
            }
        });
        this.button_ExportExcel.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                FileDialog directory = new FileDialog(AnalysisResultPage.this.shell);
                directory.setFileName("\u5c42\u94fe\u5206\u6790\u7ed3\u679c.xls");
                directory.setFilterExtensions(new String[]{".xls"});
                String path = directory.open();
                if (StringUtils.isNotBlank((String)path)) {
                    if (!path.endsWith(".xls")) {
                        GOTMessageDialog.alert("\u8bf7\u5bfc\u51fa.xls\u6587\u4ef6");
                        return;
                    }
                    try {
                        AnalysisResultPage.this.exportResultAsExcel(path);
                        GOTMessageDialog.info("\u5b8c\u6210\u5bfc\u51fa");
                    }
                    catch (Exception e1) {
                        log.error((Object)e1);
                        GOTMessageDialog.alert("\u5bfc\u51fa\u5931\u8d25\uff1a" + e1.getMessage());
                    }
                }
            }
        });
        this.button_Upgrade.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                boolean automaticallyBuild = EclipsePluginUtils.isAutomaticallyBuild();
                if (automaticallyBuild) {
                    EclipsePluginUtils.disableAutomaticallyBuild();
                }
                try {
                    try {
                        long currentTimeMillis = System.currentTimeMillis();
                        boolean upgrade = AnalysisResultPage.this.upgrade();
                        log.info((Object)("\u786e\u8ba4\u5347\u7ea7\u8017\u65f6\uff1a" + (System.currentTimeMillis() - currentTimeMillis)));
                        if (upgrade) {
                            AnalysisResultPage.this.analysis_Finish = false;
                            AnalysisResultPage.this.button_ExportExcel.setEnabled(false);
                            AnalysisResultPage.this.button_Upgrade.setEnabled(false);
                            AnalysisResultPage.this.analysisResult_Cache = new ArrayList();
                            AnalysisResultPage.this.upgradeService = new LayerUpgradeService();
                            AnalysisResultPage.this.gotTree.removeAll();
                            AnalysisResultPage.this.initGOTTree(AnalysisResultPage.this.newEmptyGOTElement(), null);
                            AnalysisResultPage.this.gotTree.getItem(0).setExpanded(true);
                            AnalysisResultPage.this.gotTree.getItem(0).getItem(0).setExpanded(true);
                            currentTimeMillis = System.currentTimeMillis();
                            AnalysisResultPage.this.compareTree.removeAll();
                            AnalysisResultPage.this.propertyInfoTree.removeAll();
                            AnalysisResultPage.this.detailTable.removeAll();
                            AnalysisResultPage.this.tipInfo.setText("");
                            LayerChainPage layerChainPage = LayerChainPage.getInstance();
                            layerChainPage.clearCache();
                            currentTimeMillis = System.currentTimeMillis();
                            layerChainPage = LayerChainPage.getInstance();
                            layerChainPage.setConfirmCallBack(info -> {
                                AnalysisResultPage.this.button_analysis.setEnabled(true);
                                AnalysisResultPage.this.analysis_Finish = false;
                                AnalysisResultPage.this.updateButtonStatus();
                            });
                            layerChainPage.setOpenCallBack(info -> AnalysisResultPage.this.resourceInfo.setText(info));
                            layerChainPage.loadPedestal(new HashMap<String, Element>());
                            layerChainPage.loadSolution(new HashMap<String, Element>());
                            currentTimeMillis = System.currentTimeMillis();
                        }
                    }
                    catch (Exception e1) {
                        throw new RuntimeException(e1);
                    }
                }
                finally {
                    if (automaticallyBuild) {
                        EclipsePluginUtils.enableAutomaticallyBuild();
                    }
                }
            }
        });
    }

    private void createGOTArea() {
        this.left = new Composite((Composite)this.mainComposite, 0);
        FormData formData = new FormData(SWTUtils.zoom(200), -1);
        formData.top = new FormAttachment(0);
        formData.bottom = new FormAttachment(100);
        formData.left = new FormAttachment(0);
        formData.right = new FormAttachment((Control)this.mainComposite, 0);
        this.left.setLayoutData((Object)formData);
        this.left.setLayout((Layout)new FormLayout());
        this.gotTree = new Tree(this.left, 67840);
        formData = new FormData(SWTUtils.zoom(200), -1);
        formData.top = new FormAttachment(0);
        formData.bottom = new FormAttachment(100, SWTUtils.zoom(-27));
        formData.left = new FormAttachment(0);
        formData.right = new FormAttachment(100);
        this.gotTree.setLayoutData((Object)formData);
        this.gotTree.setFont(this.font);
        this.gotTree.addMouseListener(MouseListener.mouseDownAdapter(this::showTreeItemContextMenu));
        this.gotTree.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                TreeItem treeItem = (TreeItem)e.item;
                AnalysisResultPage.this.showCompareResult(treeItem);
            }
        });
        this.gotTree.addListener(42, this.paintListener);
        this.resourceInfo = new Label(this.left, 16384);
        formData = new FormData();
        formData.bottom = new FormAttachment(100, SWTUtils.zoom(-5));
        formData.left = new FormAttachment((Control)this.gotTree, SWTUtils.zoom(5), 16384);
        formData.right = new FormAttachment((Control)this.gotTree, SWTUtils.zoom(-25), 131072);
        this.resourceInfo.setForeground(Display.getCurrent().getSystemColor(9));
        this.resourceInfo.setLayoutData((Object)formData);
        ToolBar gotToolBar = new ToolBar(this.left, 8519744);
        formData = new FormData();
        formData.bottom = new FormAttachment(100, SWTUtils.zoom(-3));
        formData.left = new FormAttachment((Control)this.gotTree, SWTUtils.zoom(-22), 131072);
        formData.right = new FormAttachment((Control)this.gotTree, 0, 131072);
        gotToolBar.setLayoutData((Object)formData);
        ToolItem filterButton = new ToolItem(gotToolBar, 131072);
        filterButton.setImage(Images.getIcon("layerUpgrade/filter.png", SWTUtils.zoom(16), SWTUtils.zoom(16)));
        filterButton.setToolTipText("\u7b5b\u9009");
        filterButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                LayerChainFilter layerChainFilter = new LayerChainFilter(LayerChainPage.getInstance().getSolutions(), AnalysisResultPage.this.layerChainConfig);
                layerChainFilter.show();
                AnalysisResultPage.this.buildGOTTree();
                AnalysisResultPage.this.resetView();
            }
        });
    }

    private void createTabFolder() {
        this.right = new Composite((Composite)this.mainComposite, 0);
        FormData formData = new FormData(SWTUtils.zoom(200), -1);
        formData.top = new FormAttachment(0);
        formData.bottom = new FormAttachment(100);
        formData.left = new FormAttachment((Control)this.mainComposite, 0);
        formData.right = new FormAttachment(SWTUtils.zoom(20));
        this.right.setLayoutData((Object)formData);
        this.right.setLayout((Layout)new FormLayout());
        this.tabFolder = new TabFolder(this.right, 0);
        formData = new FormData();
        formData.left = new FormAttachment((Control)this.left, 4, 131072);
        formData.right = new FormAttachment(100);
        formData.top = new FormAttachment(0);
        formData.bottom = new FormAttachment(100, SWTUtils.zoom(-26));
        this.tabFolder.setLayoutData((Object)formData);
        this.createModelArea();
        this.createJavaArea();
        this.createBottomToolBar();
        final TabItem modelTab = new TabItem(this.tabFolder, 0);
        modelTab.setText("\u6a21\u578b");
        modelTab.setControl((Control)this.modelResultComposite);
        final TabItem codeTab = new TabItem(this.tabFolder, 0);
        codeTab.setText("\u4ee3\u7801");
        codeTab.setControl((Control)this.codeResultComposite);
        this.tabFolder.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (AnalysisResultPage.this.tabFolder.getSelection()[0] == modelTab) {
                    AnalysisResultPage.this.modelToolBar.setVisible(true);
                    AnalysisResultPage.this.javaToolBar.setVisible(false);
                    AnalysisResultPage.this.codeResultComposite.setVisible(false);
                    AnalysisResultPage.this.modelResultComposite.setVisible(true);
                    AnalysisResultPage.this.tipInfo.setVisible(true);
                } else if (AnalysisResultPage.this.tabFolder.getSelection()[0] == codeTab) {
                    AnalysisResultPage.this.modelToolBar.setVisible(false);
                    AnalysisResultPage.this.javaToolBar.setVisible(true);
                    AnalysisResultPage.this.codeResultComposite.setVisible(true);
                    AnalysisResultPage.this.modelResultComposite.setVisible(false);
                    AnalysisResultPage.this.tipInfo.setVisible(false);
                }
            }
        });
    }

    private void createModelArea() {
        this.modelResultComposite = new Composite((Composite)this.tabFolder, 0);
        FormData formData = new FormData();
        formData.left = new FormAttachment(0);
        formData.right = new FormAttachment(100);
        formData.top = new FormAttachment(0);
        formData.bottom = new FormAttachment(100);
        this.modelResultComposite.setLayoutData((Object)formData);
        this.modelResultComposite.setLayout((Layout)new FormLayout());
        this.treeResultComposite = new SashForm(this.modelResultComposite, 256);
        formData = new FormData();
        formData.left = new FormAttachment(0);
        formData.right = new FormAttachment(100);
        formData.top = new FormAttachment(0);
        formData.bottom = new FormAttachment(100);
        this.treeResultComposite.setLayoutData((Object)formData);
        this.treeResultComposite.setLayout((Layout)new FormLayout());
        this.compareTree = new Tree((Composite)this.treeResultComposite, 67840);
        formData = new FormData();
        formData.left = new FormAttachment(0);
        formData.right = new FormAttachment((Control)this.treeResultComposite, 0);
        formData.top = new FormAttachment(0);
        formData.bottom = new FormAttachment(100);
        this.compareTree.setLayoutData((Object)formData);
        this.compareTree.addListener(42, this.paintListener);
        this.compareTree.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                TreeItem selection = AnalysisResultPage.this.compareTree.getSelection()[0];
                Object SourceNode = selection.getData("SourceNode");
                Object TargetNode = selection.getData("TargetNode");
                if (SourceNode == null && TargetNode == null) {
                    return;
                }
                String entityType = "";
                Map<Object, Object> attributes = new HashMap();
                try {
                    if (SourceNode != null) {
                        if (SourceNode instanceof gongqi.gdt.designer.service.node.GOTNode) {
                            AnalysisResultPage.this.buildTreeInfoTable(((gongqi.gdt.designer.service.node.GOTNode)SourceNode).getPropertys(), TargetNode != null ? ((gongqi.gdt.designer.service.node.GOTNode)TargetNode).getPropertys() : new ArrayList(), TargetNode == null);
                            attributes = ((gongqi.gdt.designer.service.node.GOTNode)SourceNode).getAttributes();
                            entityType = ((gongqi.gdt.designer.service.node.GOTNode)SourceNode).getNodeType();
                        } else if (SourceNode instanceof GOTEntity) {
                            AnalysisResultPage.this.buildTreeInfoTable(((GOTEntity)SourceNode).getPropertys(), TargetNode != null ? ((GOTEntity)TargetNode).getPropertys() : new ArrayList(), TargetNode == null);
                            attributes = ((GOTEntity)SourceNode).getAttributes();
                            entityType = ((GOTEntity)SourceNode).getNodeType();
                        }
                    } else if (TargetNode instanceof gongqi.gdt.designer.service.node.GOTNode) {
                        AnalysisResultPage.this.buildTreeInfoTable(new ArrayList(), ((gongqi.gdt.designer.service.node.GOTNode)TargetNode).getPropertys(), true);
                        attributes = ((gongqi.gdt.designer.service.node.GOTNode)TargetNode).getAttributes();
                        entityType = ((gongqi.gdt.designer.service.node.GOTNode)TargetNode).getNodeType();
                    } else if (TargetNode instanceof GOTEntity) {
                        AnalysisResultPage.this.buildTreeInfoTable(new ArrayList(), ((GOTEntity)TargetNode).getPropertys(), true);
                        attributes = ((GOTEntity)TargetNode).getAttributes();
                        entityType = ((GOTEntity)TargetNode).getNodeType();
                    }
                }
                catch (Exception exception) {}
                AnalysisResultPage.this.setTipInfo(entityType, attributes);
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        this.compareTree.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseDown(MouseEvent e) {
                TreeItem[] selections = AnalysisResultPage.this.compareTree.getSelection();
                if (e.button != 3 || selections.length <= 0) {
                    return;
                }
                if (AnalysisResultPage.this.compareTree.getMenu() != null) {
                    AnalysisResultPage.this.compareTree.getMenu().dispose();
                }
                String id = (String)selections[0].getData("id");
                String nodeType = (String)selections[0].getData("nodeType");
                if (StringUtils.isBlank((String)id)) {
                    return;
                }
                Object data = AnalysisResultPage.this.compareTree.getData();
                if (data == null || !(data instanceof Element)) {
                    return;
                }
                Element element = (Element)data;
                List items = element.elements();
                if ((items = items.stream().filter(item -> id.equals(item.attributeValue("innerId")) || id.equals(item.attributeValue("nodeType")) || item.attributeValue("nodeType").equals(nodeType) && StringUtils.isBlank((String)item.attributeValue("innerId"))).collect(Collectors.toList())).isEmpty()) {
                    return;
                }
                Menu layMenu = new Menu((Control)AnalysisResultPage.this.compareTree);
                MenuItem addItem = new MenuItem(layMenu, 8);
                addItem.setText("\u67e5\u770b\u8be6\u60c5");
                addItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

                    public void widgetSelected(SelectionEvent e) {
                        TreeItem[] selections = AnalysisResultPage.this.compareTree.getSelection();
                        String id = (String)selections[0].getData("id");
                        String nodeType = (String)selections[0].getData("nodeType");
                        Object data = AnalysisResultPage.this.compareTree.getData();
                        if (data == null || !(data instanceof Element)) {
                            return;
                        }
                        Element element = (Element)data;
                        List<Element> items = element.elements();
                        items = items.stream().filter(item -> id.equals(item.attributeValue("innerId")) || id.equals(item.attributeValue("nodeType")) || item.attributeValue("nodeType").equals(nodeType) && StringUtils.isBlank((String)item.attributeValue("innerId"))).collect(Collectors.toList());
                        ErrorInfoDialog dialog = new ErrorInfoDialog(items);
                        dialog.open();
                    }
                });
                if (items.stream().filter(item -> item.attributeValue("modifyType").equals(ModifyType.InnerNode_Order.name())).findAny().isPresent()) {
                    MenuItem compareStructure = new MenuItem(layMenu, 8);
                    compareStructure.setText("\u5bf9\u6bd4\u7ed3\u6784");
                    compareStructure.addSelectionListener((SelectionListener)new SelectionAdapter(){

                        public void widgetSelected(SelectionEvent e) {
                            TreeItem selection = AnalysisResultPage.this.compareTree.getSelection()[0];
                            Object SourceNode = selection.getData("SourceNode");
                            Object TargetNode = selection.getData("TargetNode");
                            try {
                                StructureCompare compare = new StructureCompare(SourceNode, TargetNode);
                                compare.open();
                            }
                            catch (Exception e1) {
                                MessageDialog.openError((Shell)AnalysisResultPage.this.shell, (String)"\u63d0\u5347", (String)e1.getMessage());
                            }
                        }
                    });
                }
                AnalysisResultPage.this.compareTree.setMenu(layMenu);
            }
        });
        this.propertyInfoTree = new Tree((Composite)this.treeResultComposite, 67840);
        formData = new FormData();
        formData.left = new FormAttachment((Control)this.treeResultComposite, 0);
        formData.right = new FormAttachment(100);
        formData.top = new FormAttachment(0);
        formData.bottom = new FormAttachment((Control)this.compareTree, 0, 1024);
        this.propertyInfoTree.setLayoutData((Object)formData);
        this.propertyInfoTree.setHeaderVisible(true);
        this.propertyInfoTree.setLinesVisible(true);
        this.propertyInfoTree.addListener(42, this.paintListener);
        TreeColumn propertyColumn = new TreeColumn(this.propertyInfoTree, 16384, 0);
        propertyColumn.setText("\u5c5e\u6027\u540d");
        propertyColumn.setWidth(150);
        TreeColumn UpgradeBefore = new TreeColumn(this.propertyInfoTree, 16384, 1);
        UpgradeBefore.setText("\u5f53\u524d\u503c");
        UpgradeBefore.setWidth(175);
        TreeColumn UpgradeAfter = new TreeColumn(this.propertyInfoTree, 16384, 2);
        UpgradeAfter.setText("\u5347\u7ea7\u503c");
        UpgradeAfter.setWidth(175);
        this.treeResultComposite.setWeights(new int[]{2, 3});
        this.detailTable = new Table(this.modelResultComposite, 65540);
        formData = new FormData();
        formData.left = new FormAttachment(0);
        formData.right = new FormAttachment(100);
        formData.top = new FormAttachment(0);
        formData.bottom = new FormAttachment(100);
        this.detailTable.setLayoutData((Object)formData);
        this.detailTable.setHeaderVisible(true);
        this.detailTable.setLinesVisible(true);
        TableColumn entityId = new TableColumn(this.detailTable, 0x1000000, 0);
        entityId.setText("\u5b9e\u4f53Id");
        entityId.setWidth(200);
        TableColumn nodeType = new TableColumn(this.detailTable, 0x1000000, 1);
        nodeType.setText("\u7c7b\u578b");
        nodeType.setWidth(100);
        TableColumn descriptionColumn = new TableColumn(this.detailTable, 16384, 2);
        descriptionColumn.setText("\u5185\u5bb9\u63cf\u8ff0");
        descriptionColumn.setWidth(300);
        this.detailTable.addControlListener((ControlListener)new ControlAdapter(){

            public void controlResized(ControlEvent e) {
                int width = AnalysisResultPage.this.detailTable.getColumn(0).getWidth() + AnalysisResultPage.this.detailTable.getColumn(1).getWidth();
                AnalysisResultPage.this.detailTable.getColumn(2).setWidth(((AnalysisResultPage)AnalysisResultPage.this).detailTable.getBounds().width - width);
            }
        });
        this.detailTable.setVisible(false);
    }

    private void setCompareInput() {
        this.compareViewerPane.setInput(null);
        TreeItem[] selects = this.javaMethodTree.getSelection();
        if (selects.length <= 0) {
            return;
        }
        TreeItem treeItem = selects[0];
        Object originMethod = treeItem.getData("originMethod");
        Object sourceMethod = treeItem.getData("sourceMethod");
        Object targetMethod = treeItem.getData("targetMethod");
        if (!(originMethod != null && originMethod instanceof String && sourceMethod != null && sourceMethod instanceof String && targetMethod != null && targetMethod instanceof String)) {
            return;
        }
        String originMethodLayer = (String)treeItem.getData("originMethodLayer");
        String sourceMethodLayer = (String)treeItem.getData("sourceMethodLayer");
        String targetMethodLayer = (String)treeItem.getData("targetMethodLayer");
        if (this.showOrigin.getSelection()) {
            this.compareViewerPane.setVisible(false);
            this.javaCodeText.getControl().setVisible(true);
            this.javaCodeText.setDocument((IDocument)new Document(originMethod.toString()));
        } else if (this.showSource.getSelection()) {
            this.compareViewerPane.setVisible(false);
            this.javaCodeText.getControl().setVisible(true);
            this.javaCodeText.setDocument((IDocument)new Document(sourceMethod.toString()));
        } else if (this.showTarget.getSelection()) {
            this.compareViewerPane.setVisible(false);
            this.javaCodeText.getControl().setVisible(true);
            this.javaCodeText.setDocument((IDocument)new Document(targetMethod.toString()));
        } else if (this.origin_Source.getSelection()) {
            this.compareViewerPane.setVisible(true);
            this.javaCodeText.getControl().setVisible(false);
            DiffNode diffNode = new DiffNode((ITypedElement)new JavaCodeTypedElement("\u521d\u59cb\u65b9\u6cd5-" + originMethodLayer, originMethod.toString()), (ITypedElement)new JavaCodeTypedElement("\u5f53\u524d\u65b9\u6cd5-" + sourceMethodLayer, sourceMethod.toString()));
            this.compareViewerPane.setInput((Object)diffNode);
        } else if (this.target_origin.getSelection()) {
            this.compareViewerPane.setVisible(true);
            this.javaCodeText.getControl().setVisible(false);
            DiffNode diffNode = new DiffNode((ITypedElement)new JavaCodeTypedElement("\u5347\u7ea7\u65b9\u6cd5-" + targetMethodLayer, targetMethod.toString()), (ITypedElement)new JavaCodeTypedElement("\u521d\u59cb\u65b9\u6cd5-" + originMethodLayer, originMethod.toString()));
            this.compareViewerPane.setInput((Object)diffNode);
        }
    }

    private void createJavaArea() {
        this.codeResultComposite = new SashForm((Composite)this.tabFolder, 256);
        FormData formData = new FormData();
        formData.left = new FormAttachment(0);
        formData.right = new FormAttachment(100);
        formData.top = new FormAttachment(0);
        formData.bottom = new FormAttachment(100);
        this.codeResultComposite.setLayoutData((Object)formData);
        this.codeResultComposite.setLayout((Layout)new FormLayout());
        this.javaMethodTree = new Tree((Composite)this.codeResultComposite, 67840);
        formData = new FormData();
        formData.left = new FormAttachment(0, 0);
        formData.right = new FormAttachment((Control)this.codeResultComposite, 0);
        formData.top = new FormAttachment(0, 0);
        formData.bottom = new FormAttachment(100, 0);
        this.javaMethodTree.setLayoutData((Object)formData);
        this.javaMethodTree.setHeaderVisible(false);
        this.javaMethodTree.setLinesVisible(false);
        this.javaMethodTree.addListener(42, this.paintListener);
        this.javaMethodTree.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                AnalysisResultPage.this.javaCodeText.setDocument((IDocument)new Document(""));
                AnalysisResultPage.this.setCompareInput();
            }
        });
        this.viewComposite = new Composite((Composite)this.codeResultComposite, 2048);
        formData = new FormData();
        formData.left = new FormAttachment((Control)this.codeResultComposite, 0);
        formData.right = new FormAttachment(100, 0);
        formData.top = new FormAttachment(0, 0);
        formData.bottom = new FormAttachment(100, 0);
        this.viewComposite.setLayout((Layout)new FormLayout());
        this.viewComposite.setLayoutData((Object)formData);
        this.compareViewerPane = new CompareViewerSwitchingPane(this.viewComposite, 0x800800, true){

            protected Viewer getViewer(Viewer oldViewer, Object input) {
                CompareConfiguration cc = new CompareConfiguration();
                DiffNode node = (DiffNode)input;
                if (node != null) {
                    cc.setLeftLabel(node.getLeft().getName());
                    cc.setRightLabel(node.getRight().getName());
                }
                cc.setLeftEditable(false);
                cc.setRightEditable(false);
                Viewer findContentViewer = CompareUI.findContentViewer((Viewer)oldViewer, (Object)input, (Composite)this, (CompareConfiguration)cc);
                return findContentViewer;
            }
        };
        this.compareViewerPane.setVisible(false);
        formData = new FormData();
        formData.left = new FormAttachment(0, 0);
        formData.right = new FormAttachment(100, 0);
        formData.top = new FormAttachment(0, 0);
        formData.bottom = new FormAttachment(100, 0);
        this.javaCodeText = new SourceViewer(this.viewComposite, null, 768);
        ScopedPreferenceStore preferenceStore = new ScopedPreferenceStore(InstanceScope.INSTANCE, "org.eclipse.jdt.ui");
        JavaTextTools textTools = new JavaTextTools((IPreferenceStore)preferenceStore);
        this.javaCodeText.configure((SourceViewerConfiguration)new JavaSourceViewerConfiguration(textTools.getColorManager(), (IPreferenceStore)preferenceStore, null, null));
        this.javaCodeText.setEditable(false);
        this.javaCodeText.getControl().setLayoutData((Object)formData);
        this.compareViewerPane.setLayoutData((Object)formData);
        this.codeResultComposite.setWeights(new int[]{1, 4});
    }

    private void createBottomToolBar() {
        this.modelToolBar = new ToolBar(this.right, 8519744);
        FormData formData = new FormData();
        formData.bottom = new FormAttachment(100, SWTUtils.zoom(-2));
        formData.right = new FormAttachment(100, SWTUtils.zoom(-10));
        this.modelToolBar.setLayoutData((Object)formData);
        final ToolItem maxToolItem = new ToolItem(this.modelToolBar, 131104);
        maxToolItem.setImage(Images.getIcon("layerUpgrade/maximize.png", SWTUtils.zoom(16), SWTUtils.zoom(16)));
        maxToolItem.setSelection(false);
        maxToolItem.setToolTipText("\u6700\u5927\u5316");
        new ToolItem(this.modelToolBar, 2).setWidth(10);
        final ToolItem treeLayoutButton = new ToolItem(this.modelToolBar, 131104);
        treeLayoutButton.setImage(Images.getIcon("layerUpgrade/treeLayout.png", SWTUtils.zoom(16), SWTUtils.zoom(16)));
        treeLayoutButton.setSelection(true);
        treeLayoutButton.setToolTipText("\u6811\u5f62\u5c55\u793a");
        final ToolItem tableLayoutButton = new ToolItem(this.modelToolBar, 131104);
        tableLayoutButton.setImage(Images.getIcon("layerUpgrade/tableLayout.png", SWTUtils.zoom(16), SWTUtils.zoom(16)));
        tableLayoutButton.setToolTipText("\u5217\u8868\u5c55\u793a");
        treeLayoutButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                boolean select = treeLayoutButton.getSelection();
                if (select) {
                    AnalysisResultPage.this.detailTable.setVisible(false);
                    AnalysisResultPage.this.treeResultComposite.setVisible(true);
                    tableLayoutButton.setSelection(false);
                } else {
                    treeLayoutButton.setSelection(true);
                }
            }
        });
        tableLayoutButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                boolean select = tableLayoutButton.getSelection();
                if (select) {
                    AnalysisResultPage.this.detailTable.setVisible(true);
                    AnalysisResultPage.this.treeResultComposite.setVisible(false);
                    treeLayoutButton.setSelection(false);
                } else {
                    tableLayoutButton.setSelection(true);
                }
            }
        });
        new ToolItem(this.modelToolBar, 2).setWidth(10);
        this.addButton = new ToolItem(this.modelToolBar, 131104);
        this.addButton.setImage(addImage);
        this.addButton.setSelection(true);
        this.addButton.setToolTipText("\u663e\u793a\u65b0\u589e");
        this.deleteButton = new ToolItem(this.modelToolBar, 131104);
        this.deleteButton.setImage(deleteImage);
        this.deleteButton.setSelection(true);
        this.deleteButton.setToolTipText("\u663e\u793a\u5220\u9664");
        this.difButton = new ToolItem(this.modelToolBar, 131104);
        this.difButton.setImage(difImage);
        this.difButton.setSelection(true);
        this.difButton.setToolTipText("\u663e\u793a\u5dee\u5f02");
        this.sameButton = new ToolItem(this.modelToolBar, 131104);
        this.sameButton.setImage(noSameImage);
        this.sameButton.setToolTipText("\u663e\u793a\u76f8\u540c");
        SelectionAdapter treeFilterListen = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                displayScope = new ArrayList();
                if (!AnalysisResultPage.this.sameButton.getSelection()) {
                    AnalysisResultPage.this.sameButton.setImage(noSameImage);
                } else {
                    AnalysisResultPage.this.sameButton.setImage(sameImage);
                    displayScope.add(DisplayType.Same);
                }
                if (!AnalysisResultPage.this.difButton.getSelection()) {
                    AnalysisResultPage.this.difButton.setImage(noDifImage);
                } else {
                    AnalysisResultPage.this.difButton.setImage(difImage);
                    displayScope.add(DisplayType.Dif);
                }
                if (!AnalysisResultPage.this.deleteButton.getSelection()) {
                    AnalysisResultPage.this.deleteButton.setImage(noDeleteImage);
                } else {
                    AnalysisResultPage.this.deleteButton.setImage(deleteImage);
                    displayScope.add(DisplayType.Delete);
                }
                if (!AnalysisResultPage.this.addButton.getSelection()) {
                    AnalysisResultPage.this.addButton.setImage(noAddImage);
                } else {
                    AnalysisResultPage.this.addButton.setImage(addImage);
                    displayScope.add(DisplayType.Add);
                }
                TreeItem[] selection = AnalysisResultPage.this.gotTree.getSelection();
                if (selection.length > 0) {
                    AnalysisResultPage.this.showCompareResult(selection[0]);
                }
            }
        };
        this.addButton.addSelectionListener((SelectionListener)treeFilterListen);
        this.deleteButton.addSelectionListener((SelectionListener)treeFilterListen);
        this.difButton.addSelectionListener((SelectionListener)treeFilterListen);
        this.sameButton.addSelectionListener((SelectionListener)treeFilterListen);
        this.tipInfo = new Label(this.right, 16384);
        formData = new FormData();
        formData.bottom = new FormAttachment(100, SWTUtils.zoom(-5));
        formData.left = new FormAttachment((Control)this.tabFolder, SWTUtils.zoom(5), 16384);
        formData.right = new FormAttachment((Control)this.modelToolBar, SWTUtils.zoom(5), 16384);
        this.tipInfo.setForeground(Display.getCurrent().getSystemColor(9));
        this.tipInfo.setLayoutData((Object)formData);
        this.javaToolBar = new ToolBar(this.right, 0x804040);
        formData = new FormData();
        formData.bottom = new FormAttachment(100, SWTUtils.zoom(-2));
        formData.left = new FormAttachment(0, SWTUtils.zoom(2));
        this.javaToolBar.setLayoutData((Object)formData);
        this.showPromote = new ToolItem(this.javaToolBar, 131104);
        this.showPromote.setImage(Images.getIcon("layerUpgrade/Public_Override.png", SWTUtils.zoom(16), SWTUtils.zoom(16)));
        this.showPromote.setToolTipText("\u4ec5\u663e\u793a\u63d0\u5347\u65b9\u6cd5");
        new ToolItem(this.javaToolBar, 2).setWidth(10);
        this.showPublic = new ToolItem(this.javaToolBar, 131104);
        this.showPublic.setImage(publicMethod);
        this.showPublic.setSelection(true);
        this.showPublic.setToolTipText("Public");
        this.showProtect = new ToolItem(this.javaToolBar, 131104);
        this.showProtect.setImage(protectMethod);
        this.showProtect.setSelection(true);
        this.showProtect.setToolTipText("Protected");
        this.showPrivate = new ToolItem(this.javaToolBar, 131104);
        this.showPrivate.setImage(privateMethod);
        this.showPrivate.setSelection(true);
        this.showPrivate.setToolTipText("Private");
        this.showDefault = new ToolItem(this.javaToolBar, 131104);
        this.showDefault.setImage(defaultMethod);
        this.showDefault.setSelection(true);
        this.showDefault.setToolTipText("Default");
        SelectionAdapter methodFilterListen = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                AnalysisResultPage.this.buildJavaMethod();
            }
        };
        this.showPromote.addSelectionListener((SelectionListener)methodFilterListen);
        this.showPublic.addSelectionListener((SelectionListener)methodFilterListen);
        this.showProtect.addSelectionListener((SelectionListener)methodFilterListen);
        this.showPrivate.addSelectionListener((SelectionListener)methodFilterListen);
        this.showDefault.addSelectionListener((SelectionListener)methodFilterListen);
        ToolBar viewToolBar = new ToolBar(this.right, 0x804040);
        formData = new FormData();
        formData.bottom = new FormAttachment(100, SWTUtils.zoom(-2));
        formData.right = new FormAttachment(100, SWTUtils.zoom(-10));
        viewToolBar.setLayoutData((Object)formData);
        final ToolItem maxButton = new ToolItem(viewToolBar, 131104);
        maxButton.setImage(Images.getIcon("layerUpgrade/maximize.png", SWTUtils.zoom(16), SWTUtils.zoom(16)));
        maxButton.setSelection(false);
        maxButton.setToolTipText("\u6700\u5927\u5316");
        maxButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                maxToolItem.setSelection(maxButton.getSelection());
                if (maxButton.getSelection()) {
                    AnalysisResultPage.this.mainComposite.setMaximizedControl((Control)AnalysisResultPage.this.right);
                    AnalysisResultPage.this.codeResultComposite.setMaximizedControl((Control)AnalysisResultPage.this.viewComposite);
                } else {
                    AnalysisResultPage.this.mainComposite.setMaximizedControl(null);
                    AnalysisResultPage.this.codeResultComposite.setMaximizedControl(null);
                }
            }
        });
        maxToolItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                maxButton.setSelection(maxToolItem.getSelection());
                if (maxToolItem.getSelection()) {
                    AnalysisResultPage.this.mainComposite.setMaximizedControl((Control)AnalysisResultPage.this.right);
                    AnalysisResultPage.this.codeResultComposite.setMaximizedControl((Control)AnalysisResultPage.this.viewComposite);
                } else {
                    AnalysisResultPage.this.mainComposite.setMaximizedControl(null);
                    AnalysisResultPage.this.codeResultComposite.setMaximizedControl(null);
                }
            }
        });
        new ToolItem(viewToolBar, 2).setWidth(10);
        this.showOrigin = new ToolItem(viewToolBar, 131104);
        this.showOrigin.setImage(Images.getIcon("layerUpgrade/showOrigin.png", SWTUtils.zoom(16), SWTUtils.zoom(16)));
        this.showOrigin.setSelection(false);
        this.showOrigin.setToolTipText("\u521d\u59cb\u65b9\u6cd5");
        this.showSource = new ToolItem(viewToolBar, 131104);
        this.showSource.setImage(Images.getIcon("layerUpgrade/showSource.png", SWTUtils.zoom(16), SWTUtils.zoom(16)));
        this.showSource.setSelection(true);
        this.showSource.setToolTipText("\u5f53\u524d\u65b9\u6cd5");
        this.showTarget = new ToolItem(viewToolBar, 131104);
        this.showTarget.setImage(Images.getIcon("layerUpgrade/showTarget.png", SWTUtils.zoom(16), SWTUtils.zoom(16)));
        this.showTarget.setSelection(false);
        this.showTarget.setToolTipText("\u5347\u7ea7\u65b9\u6cd5");
        new ToolItem(viewToolBar, 2).setWidth(10);
        this.origin_Source = new ToolItem(viewToolBar, 131104);
        this.origin_Source.setImage(Images.getIcon("layerUpgrade/showOrigin.png", SWTUtils.zoom(16), SWTUtils.zoom(16)));
        this.origin_Source.setSelection(false);
        this.origin_Source.setToolTipText("\u521d\u59cb\u65b9\u6cd5 VS \u5f53\u524d\u65b9\u6cd5");
        this.target_origin = new ToolItem(viewToolBar, 131104);
        this.target_origin.setImage(Images.getIcon("layerUpgrade/showTarget.png", SWTUtils.zoom(16), SWTUtils.zoom(16)));
        this.target_origin.setSelection(false);
        this.target_origin.setToolTipText("\u5347\u7ea7\u65b9\u6cd5 VS \u521d\u59cb\u65b9\u6cd5");
        final List<ToolItem> items = Arrays.asList(this.showOrigin, this.showSource, this.showTarget, this.origin_Source, this.target_origin);
        SelectionAdapter javaConfigChangeAdt = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ToolItem item = (ToolItem)e.widget;
                if (!item.getSelection()) {
                    item.setSelection(true);
                    return;
                }
                for (ToolItem toolItem : items) {
                    if (toolItem == item) continue;
                    toolItem.setSelection(false);
                }
                AnalysisResultPage.this.setCompareInput();
            }
        };
        this.showOrigin.addSelectionListener((SelectionListener)javaConfigChangeAdt);
        this.showSource.addSelectionListener((SelectionListener)javaConfigChangeAdt);
        this.showTarget.addSelectionListener((SelectionListener)javaConfigChangeAdt);
        this.origin_Source.addSelectionListener((SelectionListener)javaConfigChangeAdt);
        this.target_origin.addSelectionListener((SelectionListener)javaConfigChangeAdt);
    }

    private void showTreeItemContextMenu(MouseEvent e) {
        if (e.button != 3) {
            return;
        }
        TreeItem treeItem = this.gotTree.getItem(new Point(e.x, e.y));
        if (treeItem == null) {
            return;
        }
        String entityId = (String)treeItem.getData("entityId");
        if (StringUtils.isBlank((String)entityId)) {
            return;
        }
        Menu menu = new Menu((Control)this.gotTree);
        MenuItem enterEntity = new MenuItem(menu, 8);
        enterEntity.setText("\u8fdb\u5165\u5173\u8054");
        enterEntity.addSelectionListener(SelectionListener.widgetSelectedAdapter(event -> {
            TreeUi mainTreeUI = FormDataSyn.treeUis.get(0);
            EntityNode entityElement = GotXmlDto.getInstance().getEntityById(entityId);
            if (entityElement != null) {
                TreeItem entityTreeItem = FormDataSyn.getTreeItrmByNode((GOTNode)entityElement, mainTreeUI);
                new TreeUiBean(entityTreeItem, false);
            } else {
                MessageDialog.openInformation((Shell)this.shell, (String)"\u63d0\u793a", (String)String.format("\u5f53\u524dGOT\u6811\u4e0d\u5b58\u5728\u5b9e\u4f53%s", entityId));
            }
        }));
        this.gotTree.setMenu(menu);
    }

    private void buildDetailTable(TreeItem treeItem) {
        String entityId = (String)treeItem.getData("entityId");
        if (StringUtils.isBlank((String)entityId)) {
            TreeItem[] treeItemArray = treeItem.getItems();
            int n = treeItemArray.length;
            int n2 = 0;
            while (n2 < n) {
                TreeItem child = treeItemArray[n2];
                this.buildDetailTable(child);
                ++n2;
            }
            return;
        }
        Element result = (Element)treeItem.getData("result");
        if (result == null) {
            return;
        }
        List itemElements = result.elements();
        itemElements.stream().sorted((e1, e2) -> e1.attributeValue("modifyType").compareTo(e2.attributeValue("modifyType"))).forEach(itemElement -> {
            ModifyType modifyType = ModifyType.valueOf(itemElement.attributeValue("modifyType"));
            if (this.IsInDisplayScope(modifyType)) {
                TableItem rowItem = new TableItem(this.detailTable, 0);
                rowItem.setText(0, treeItem.getText());
                rowItem.setText(1, modifyType.getLabel());
                rowItem.setText(2, itemElement.attributeValue("description"));
                String modifyLevel = itemElement.attributeValue("modifyLevel");
                if (ModifyLevel.valueOf(modifyLevel) == ModifyLevel.Cannot) {
                    rowItem.setForeground(this.shell.getDisplay().getSystemColor(3));
                }
            }
        });
    }

    private void showCompareResult(TreeItem treeItem) {
        String modifyLyr;
        String targetName;
        this.detailTable.removeAll();
        this.compareTree.removeAll();
        this.tipInfo.setText("");
        this.javaMethodTree.removeAll();
        this.javaCodeText.setDocument((IDocument)new Document(""));
        this.compareViewerPane.setInput(null);
        this.propertyInfoTree.removeAll();
        String entityId = (String)treeItem.getData("entityId");
        if (StringUtils.isBlank((String)entityId)) {
            this.detailTable.getColumn(0).setWidth(200);
            this.buildDetailTable(treeItem);
            return;
        }
        this.detailTable.getColumn(0).setWidth(0);
        Map<Object, Object> innerIds = new HashMap();
        Element result = (Element)treeItem.getData("result");
        boolean entityAddOrDelete = false;
        if (result != null) {
            List itemElements = result.elements();
            entityAddOrDelete = itemElements.stream().filter(e -> {
                ModifyType modifyType = ModifyType.valueOf(e.attributeValue("modifyType"));
                return modifyType == ModifyType.Entity_Add || modifyType == ModifyType.Entity_Delete;
            }).findFirst().isPresent();
            for (Element itemElement : itemElements) {
                ModifyType modifyType = ModifyType.valueOf(itemElement.attributeValue("modifyType"));
                if (!this.IsInDisplayScope(modifyType)) continue;
                TableItem rowItem = new TableItem(this.detailTable, 0);
                rowItem.setText(0, treeItem.getText());
                rowItem.setText(1, modifyType.getLabel());
                rowItem.setText(2, itemElement.attributeValue("description"));
                String modifyLevel = itemElement.attributeValue("modifyLevel");
                if (ModifyLevel.valueOf(modifyLevel) != ModifyLevel.Cannot) continue;
                rowItem.setForeground(this.shell.getDisplay().getSystemColor(3));
            }
            innerIds = itemElements.stream().collect(Collectors.groupingBy(i -> {
                String innerId = i.attributeValue("innerId");
                if (StringUtils.isNotBlank((String)innerId)) {
                    return innerId;
                }
                return i.attributeValue("nodeType");
            }));
        }
        this.compareTree.setData((Object)result);
        String entityTypes = treeItem.getParentItem().getText();
        if (entityTypes.contains("(")) {
            entityTypes = entityTypes.substring(0, entityTypes.indexOf("("));
        }
        entityTypes = entityTypes.equals("Classes") ? entityTypes.substring(0, entityTypes.length() - 2) : entityTypes.substring(0, entityTypes.length() - 1);
        EntityType entityType = EntityType.valueOf((String)entityTypes);
        GOTEntity sourceEntity = this.upgradeService.getSourceEntity(entityType, entityId);
        GOTEntity targetEntity = this.upgradeService.getTargetEntity(entityType, entityId);
        if (sourceEntity == null && targetEntity == null) {
            return;
        }
        Element element = (Element)structureXML.selectSingleNode(entityType.getEntityTypeXPath());
        TreeItem entityItem = new TreeItem(this.compareTree, 0);
        String sourceName = sourceEntity != null ? sourceEntity.getAttributeValue("name") : "";
        String string = targetName = targetEntity != null ? targetEntity.getAttributeValue("name") : "";
        if (sourceName.contains(".")) {
            sourceName = sourceName.substring(sourceName.lastIndexOf(".") + 1, sourceName.length());
        }
        if (targetName.contains(".")) {
            targetName = targetName.substring(targetName.lastIndexOf(".") + 1, targetName.length());
        }
        if (StringUtils.isBlank((String)sourceName)) {
            entityItem.setText(targetName);
        } else if (StringUtils.isBlank((String)targetName)) {
            entityItem.setText(sourceName);
        } else if (!sourceName.equals(targetName)) {
            entityItem.setText(String.valueOf(sourceName) + " -> " + targetName);
        } else {
            entityItem.setText(sourceName);
        }
        String nodeType = sourceEntity != null ? sourceEntity.getNodeType() : targetEntity.getNodeType();
        List<Element> modifyInfos = new ArrayList();
        if (innerIds.containsKey(entityId)) {
            modifyInfos = (List)innerIds.get(entityId);
        }
        if (innerIds.containsKey(nodeType)) {
            modifyInfos.addAll((Collection)innerIds.get(nodeType));
        }
        if (modifyInfos.isEmpty()) {
            entityItem.setImage(Images.getIcon(String.format("%s.png", entityType.name())));
        } else {
            this.setTreeItemStyle(entityItem, modifyInfos);
        }
        entityItem.setData("id", (Object)entityId);
        entityItem.setData("nodeType", (Object)nodeType);
        entityItem.setData("SourceNode", (Object)sourceEntity);
        entityItem.setData("TargetNode", (Object)targetEntity);
        String createLyr = sourceEntity != null ? sourceEntity.getCreatedLayer() : targetEntity.getCreatedLayer();
        String string2 = modifyLyr = sourceEntity != null ? sourceEntity.getModifiedLayer() : targetEntity.getModifiedLayer();
        if (!createLyr.equals(modifyLyr)) {
            FontData fontData = this.compareTree.getFont().getFontData()[0];
            fontData.setStyle(1);
            entityItem.setFont(new Font((Device)Display.getCurrent(), fontData));
        }
        try {
            ArrayList<GOTProperty> propertys_s = sourceEntity != null ? sourceEntity.getPropertys() : new ArrayList<GOTProperty>();
            ArrayList<GOTProperty> propertys_t = targetEntity != null ? targetEntity.getPropertys() : new ArrayList<GOTProperty>();
            this.buildTreeInfoTable(propertys_s, propertys_t, sourceEntity == null || targetEntity == null);
            List childNode = element.elements();
            for (Element nodeXML : childNode) {
                this.compareChild(nodeXML, sourceEntity, targetEntity, entityItem, innerIds, entityAddOrDelete);
            }
        }
        catch (Exception e1) {
            log.error((Object)"\u5355\u8282\u70b9\u5bf9\u6bd4\u65f6\u51fa\u73b0\u5f02\u5e38", (Throwable)e1);
        }
        entityItem.setExpanded(true);
        this.compareTree.setSelection(entityItem);
        try {
            Map<String, String> attributes = sourceEntity != null ? sourceEntity.getAttributes() : targetEntity.getAttributes();
            this.setTipInfo(entityType.toString(), attributes);
        }
        catch (NavException navException) {}
        if (!(EntityType.Table.equals((Object)entityType) || EntityType.Form.equals((Object)entityType) || EntityType.Class.equals((Object)entityType))) {
            this.javaMethodTree.removeAll();
            return;
        }
        Object entityMethodsObject = treeItem.getData("entityMethods");
        if (entityMethodsObject == null || !(entityMethodsObject instanceof EntityMethods)) {
            EntityMethods entityMethods = new EntityMethods(sourceEntity, targetEntity, entityType);
            if (sourceEntity != null) {
                List<LayerJavaCode> sourceJavaCodes = this.upgradeService.getEntityJavaContent(sourceEntity, true);
                entityMethods.setSourceJavaCodes(sourceJavaCodes);
            }
            if (targetEntity != null) {
                List<LayerJavaCode> targetJavaCodes = this.upgradeService.getEntityJavaContent(targetEntity, false);
                entityMethods.setTargetJavaCodes(targetJavaCodes);
            }
            treeItem.setData("entityMethods", (Object)entityMethods);
        }
        this.buildJavaMethod();
    }

    private void setTreeItemStyle(TreeItem treeItem, List<Element> modifyInfos) {
        List modifyTypes = modifyInfos.stream().map(m -> ModifyType.valueOf(m.attributeValue("modifyType"))).collect(Collectors.toList());
        if (modifyTypes.contains((Object)ModifyType.InnerNode_Add) || modifyTypes.contains((Object)ModifyType.Entity_Add)) {
            treeItem.setImage(addImage);
        } else if (modifyTypes.contains((Object)ModifyType.InnerNode_Delete) || modifyTypes.contains((Object)ModifyType.Entity_Delete)) {
            treeItem.setImage(deleteImage);
        } else if (modifyTypes.contains((Object)ModifyType.InnerNode_Order)) {
            treeItem.setImage(orderImage);
        } else {
            treeItem.setImage(difImage);
        }
    }

    private void compareChild(Element nodeXML, gongqi.gdt.designer.service.node.GOTNode sourceNode, gongqi.gdt.designer.service.node.GOTNode targetNode, TreeItem parentItem, Map<String, List<Element>> innerIds, boolean showMust) throws VTDException {
        String id;
        List<Object> childNodes_t;
        String xpath = nodeXML.getName();
        ArrayList<String> ids = new ArrayList<String>();
        List<Object> childNodes_s = sourceNode != null ? sourceNode.selectNodes(xpath) : new ArrayList();
        List<Object> list = childNodes_t = targetNode != null ? targetNode.selectNodes(xpath) : new ArrayList();
        if (childNodes_s.isEmpty() && childNodes_t.isEmpty()) {
            return;
        }
        List childNodeXMLs = nodeXML.elements();
        for (gongqi.gdt.designer.service.node.GOTNode gOTNode : childNodes_s) {
            gongqi.gdt.designer.service.node.GOTNode childNode_t;
            Optional<gongqi.gdt.designer.service.node.GOTNode> findFirst;
            id = gOTNode.getId();
            if (StringUtils.isBlank((String)id)) {
                id = gOTNode.getNodeType();
                findFirst = childNodes_t.stream().filter(t -> t.getNodeType().equals(childNode_s.getNodeType())).findFirst();
            } else {
                findFirst = childNodes_t.stream().filter(t -> t.getId().equals(childNode_s.getId())).findFirst();
            }
            ids.add(id);
            gongqi.gdt.designer.service.node.GOTNode gOTNode2 = childNode_t = findFirst.isPresent() ? findFirst.get() : null;
            if (!showMust && !this.isInScope(nodeXML, gOTNode, childNode_t, innerIds, id)) continue;
            TreeItem nodeItem = new TreeItem(parentItem, 0);
            nodeItem.setImage(ComposeIMG.drawImgDef(gOTNode));
            if (innerIds.containsKey(id)) {
                List<Element> itemElements = innerIds.get(id);
                if (itemElements.stream().filter(i -> ModifyLevel.Cannot.name().equals(i.attributeValue("modifyLevel"))).findFirst().isPresent()) {
                    nodeItem.setForeground(Display.getCurrent().getSystemColor(3));
                }
                this.setTreeItemStyle(nodeItem, itemElements);
            }
            if (!gOTNode.getCreatedLayer().equals(gOTNode.getModifiedLayer())) {
                FontData fontData = this.compareTree.getFont().getFontData()[0];
                fontData.setStyle(1);
                nodeItem.setFont(new Font((Device)Display.getCurrent(), fontData));
            }
            String sourceName = "";
            String targetName = "";
            if (xpath.equals("FormItem")) {
                sourceName = String.valueOf(gOTNode.getAttributeValue("type")) + "::" + gOTNode.getName();
                if (childNode_t != null) {
                    targetName = String.valueOf(childNode_t.getAttributeValue("type")) + "::" + childNode_t.getName();
                }
            } else {
                sourceName = gOTNode.getName();
                String string = targetName = childNode_t != null ? childNode_t.getName() : "";
            }
            if (StringUtils.isBlank((String)sourceName)) {
                nodeItem.setText(targetName);
            } else if (StringUtils.isBlank((String)targetName)) {
                nodeItem.setText(sourceName);
            } else if (!sourceName.equals(targetName)) {
                nodeItem.setText(String.valueOf(sourceName) + " -> " + targetName);
            } else {
                nodeItem.setText(sourceName);
            }
            nodeItem.setData("id", (Object)id);
            nodeItem.setData("nodeType", (Object)gOTNode.getNodeType());
            nodeItem.setData("SourceNode", (Object)gOTNode);
            nodeItem.setData("TargetNode", (Object)childNode_t);
            if (xpath.equals("FormItem")) {
                this.compareChild(nodeXML, gOTNode, childNode_t, nodeItem, innerIds, showMust);
            } else {
                if (xpath.equals("MenuSub")) {
                    this.compareChild(nodeXML, gOTNode, childNode_t, nodeItem, innerIds, showMust);
                }
                if (xpath.equals("TableIndex")) {
                    for (Element childNodeXML : childNodeXMLs) {
                        this.compareChild(childNodeXML, gOTNode, childNode_t, nodeItem, innerIds, true);
                    }
                } else {
                    for (Element childNodeXML : childNodeXMLs) {
                        this.compareChild(childNodeXML, gOTNode, childNode_t, nodeItem, innerIds, showMust);
                    }
                }
            }
            nodeItem.setExpanded(true);
        }
        for (gongqi.gdt.designer.service.node.GOTNode gOTNode : childNodes_t) {
            id = gOTNode.getId();
            if (StringUtils.isBlank((String)id)) {
                id = gOTNode.getNodeType();
            }
            if (ids.contains(id) || !showMust && !this.isInScope(nodeXML, gOTNode, null, innerIds, id)) continue;
            TreeItem nodeItem = new TreeItem(parentItem, 0);
            String targetName = xpath.equals("FormItem") ? String.valueOf(gOTNode.getAttributeValue("type")) + "::" + gOTNode.getName() : gOTNode.getName();
            nodeItem.setText(targetName);
            nodeItem.setImage(ComposeIMG.drawImgDef(gOTNode));
            if (innerIds.containsKey(id)) {
                List<Element> itemElements = innerIds.get(id);
                if (itemElements.stream().filter(i -> ModifyLevel.Cannot.name().equals(i.attributeValue("modifyLevel"))).findFirst().isPresent()) {
                    nodeItem.setForeground(Display.getCurrent().getSystemColor(3));
                }
                this.setTreeItemStyle(nodeItem, itemElements);
            }
            if (!gOTNode.getCreatedLayer().equals(gOTNode.getModifiedLayer())) {
                FontData fontData = this.compareTree.getFont().getFontData()[0];
                fontData.setStyle(1);
                nodeItem.setFont(new Font((Device)Display.getCurrent(), fontData));
            }
            nodeItem.setData("id", (Object)id);
            nodeItem.setData("nodeType", (Object)gOTNode.getNodeType());
            nodeItem.setData("SourceNode", null);
            nodeItem.setData("TargetNode", (Object)gOTNode);
            if (xpath.equals("FormItem")) {
                this.compareChild(nodeXML, null, gOTNode, nodeItem, innerIds, showMust);
            } else {
                if (xpath.equals("MenuSub")) {
                    this.compareChild(nodeXML, null, gOTNode, nodeItem, innerIds, showMust);
                }
                if (xpath.equals("TableIndex")) {
                    for (Element childNodeXML : childNodeXMLs) {
                        this.compareChild(childNodeXML, null, gOTNode, nodeItem, innerIds, true);
                    }
                } else {
                    for (Element childNodeXML : childNodeXMLs) {
                        this.compareChild(childNodeXML, null, gOTNode, nodeItem, innerIds, showMust);
                    }
                }
            }
            nodeItem.setExpanded(true);
        }
    }

    private boolean isInScope(Element nodeXML, gongqi.gdt.designer.service.node.GOTNode childNode_s, gongqi.gdt.designer.service.node.GOTNode childNode_t, Map<String, List<Element>> innerIds, String id) throws VTDException {
        String xpath = nodeXML.getName();
        String type = nodeXML.attributeValue("type");
        if (StringUtils.isNotBlank((String)type) && "Default".equals(type)) {
            return true;
        }
        if (childNode_s.getChildNodeBFS(false).isEmpty()) {
            return this.IsInDisplayScope(innerIds, id);
        }
        if (this.IsInDisplayScope(innerIds, id)) {
            return true;
        }
        if (xpath.equals("FormItem")) {
            return this.hasEligibleChildNode(nodeXML, childNode_s, childNode_t, innerIds);
        }
        if (xpath.equals("MenuSub") && this.hasEligibleChildNode(nodeXML, childNode_s, childNode_t, innerIds)) {
            return true;
        }
        for (Element childNodeXML : nodeXML.elements()) {
            if (!this.hasEligibleChildNode(childNodeXML, childNode_s, childNode_t, innerIds)) continue;
            return true;
        }
        return false;
    }

    private boolean hasEligibleChildNode(Element nodeXML, gongqi.gdt.designer.service.node.GOTNode sourceNode, gongqi.gdt.designer.service.node.GOTNode targetNode, Map<String, List<Element>> innerIds) throws VTDException {
        List childNodeXMLs;
        String id;
        List<Object> childNodes_t;
        String xpath = nodeXML.getName();
        List<Object> childNodes_s = sourceNode != null ? sourceNode.selectNodes(xpath) : new ArrayList();
        List<Object> list = childNodes_t = targetNode != null ? targetNode.selectNodes(xpath) : new ArrayList();
        if (childNodes_s.isEmpty() && childNodes_t.isEmpty()) {
            return false;
        }
        ArrayList<String> ids = new ArrayList<String>();
        for (gongqi.gdt.designer.service.node.GOTNode gOTNode : childNodes_s) {
            gongqi.gdt.designer.service.node.GOTNode childNode_t;
            Optional<gongqi.gdt.designer.service.node.GOTNode> findFirst;
            id = gOTNode.getId();
            if (gOTNode.getChildNodeBFS(false).isEmpty()) {
                if (!this.IsInDisplayScope(innerIds, id)) continue;
                return true;
            }
            if (this.IsInDisplayScope(innerIds, id)) {
                return true;
            }
            childNodeXMLs = nodeXML.elements();
            if (StringUtils.isBlank((String)id)) {
                ids.add(gOTNode.getNodeType());
                findFirst = childNodes_t.stream().filter(t -> t.getNodeType().equals(childNode_s.getNodeType())).findFirst();
            } else {
                ids.add(id);
                findFirst = childNodes_t.stream().filter(t -> t.getId().equals(id)).findFirst();
            }
            gongqi.gdt.designer.service.node.GOTNode gOTNode2 = childNode_t = findFirst.isPresent() ? findFirst.get() : null;
            if (xpath.equals("FormItem")) {
                if (!this.hasEligibleChildNode(nodeXML, gOTNode, childNode_t, innerIds)) continue;
                return true;
            }
            if (xpath.equals("MenuSub") && this.hasEligibleChildNode(nodeXML, gOTNode, childNode_t, innerIds)) {
                return true;
            }
            for (Element childNodeXML : childNodeXMLs) {
                if (!this.hasEligibleChildNode(childNodeXML, gOTNode, childNode_t, innerIds)) continue;
                return true;
            }
        }
        for (gongqi.gdt.designer.service.node.GOTNode gOTNode : childNodes_t) {
            id = gOTNode.getId();
            if (StringUtils.isBlank((String)id)) {
                id = gOTNode.getNodeType();
            }
            if (ids.contains(id)) continue;
            if (gOTNode.getChildNodeBFS(false).isEmpty()) {
                if (!this.IsInDisplayScope(innerIds, id)) continue;
                return true;
            }
            if (this.IsInDisplayScope(innerIds, id)) {
                return true;
            }
            childNodeXMLs = nodeXML.elements();
            if (xpath.equals("FormItem")) {
                if (!this.hasEligibleChildNode(nodeXML, null, gOTNode, innerIds)) continue;
                return true;
            }
            if (xpath.equals("MenuSub") && this.hasEligibleChildNode(nodeXML, null, gOTNode, innerIds)) {
                return true;
            }
            for (Element childNodeXML : childNodeXMLs) {
                if (!this.hasEligibleChildNode(childNodeXML, null, gOTNode, innerIds)) continue;
                return true;
            }
        }
        return false;
    }

    private boolean IsInDisplayScope(Map<String, List<Element>> innerIds, String id) {
        if (innerIds.containsKey(id)) {
            List<Element> modifyInfos = innerIds.get(id);
            List modifyTypes = modifyInfos.stream().map(m -> ModifyType.valueOf(m.attributeValue("modifyType"))).collect(Collectors.toList());
            for (ModifyType modifyType : modifyTypes) {
                if (!this.IsInDisplayScope(modifyType)) continue;
                return true;
            }
            return false;
        }
        return displayScope.contains((Object)DisplayType.Same);
    }

    private boolean IsInDisplayScope(ModifyType modifyType) {
        switch (modifyType) {
            case Entity_Add: 
            case InnerNode_Add: {
                return displayScope.contains((Object)DisplayType.Add);
            }
            case Entity_Delete: 
            case InnerNode_Delete: {
                return displayScope.contains((Object)DisplayType.Delete);
            }
        }
        return displayScope.contains((Object)DisplayType.Dif);
    }

    private void setTipInfo(String entityType, Map<String, String> attributes) {
        List<String> ignore = Arrays.asList("name", "version", "nextInnerId");
        String tip = attributes.entrySet().stream().filter(entry -> !ignore.contains(entry.getKey())).map(entry -> String.valueOf((String)entry.getKey()) + "=" + (String)entry.getValue()).collect(Collectors.joining("; "));
        this.tipInfo.setText(String.valueOf(entityType) + " " + tip);
        this.tipInfo.setToolTipText(String.valueOf(entityType) + " " + tip);
    }

    private void buildJavaMethod() {
        this.javaMethodTree.removeAll();
        TreeItem[] selection = this.gotTree.getSelection();
        if (selection.length < 1) {
            return;
        }
        Object entityMethodsObject = selection[0].getData("entityMethods");
        if (entityMethodsObject == null || !(entityMethodsObject instanceof EntityMethods)) {
            return;
        }
        EntityMethods entityMethods = (EntityMethods)entityMethodsObject;
        Comparator<LayerJavaMethod> comparator = new Comparator<LayerJavaMethod>(){

            @Override
            public int compare(LayerJavaMethod o1, LayerJavaMethod o2) {
                return AnalysisResultPage.this.getLayerLevel(o1.getParent().getLayerName()) > AnalysisResultPage.this.getLayerLevel(o2.getParent().getLayerName()) ? -1 : 1;
            }
        };
        List<RenameNode> renameNodes = entityMethods.getRenameNodes();
        if (entityMethods.getEntityType().equals((Object)EntityType.Form)) {
            TreeItem classItem;
            boolean find;
            TreeItem formDataSourceItem = new TreeItem(this.javaMethodTree, 0);
            formDataSourceItem.setText("datasource");
            formDataSourceItem.setImage(Images.getIcon("layerUpgrade/Package.png"));
            List<String> allCodes = entityMethods.getAllCodes(LayerJavaCode.JavaType.Form);
            for (String javaFileName : allCodes) {
                find = renameNodes.stream().filter(n -> n.getJavaType() == LayerJavaCode.JavaType.Form && (javaFileName.equals(n.getNewName()) || javaFileName.equals(n.getOldName()))).findFirst().isPresent();
                if (find) continue;
                classItem = new TreeItem(this.javaMethodTree, 0, 0);
                this.doBuildJavaMethod(classItem, entityMethods, javaFileName, javaFileName, LayerJavaCode.JavaType.Form, comparator);
            }
            allCodes = entityMethods.getAllCodes(LayerJavaCode.JavaType.DataSource);
            for (String javaFileName : allCodes) {
                find = renameNodes.stream().filter(n -> n.getJavaType() == LayerJavaCode.JavaType.DataSource && (javaFileName.equals(n.getNewName()) || javaFileName.equals(n.getOldName()))).findFirst().isPresent();
                if (find) continue;
                classItem = new TreeItem(formDataSourceItem, 0, 0);
                this.doBuildJavaMethod(classItem, entityMethods, javaFileName, javaFileName, LayerJavaCode.JavaType.DataSource, comparator);
            }
            for (RenameNode renameNode : renameNodes) {
                if (renameNode.getJavaType() == LayerJavaCode.JavaType.Form) {
                    TreeItem classItem2 = new TreeItem(this.javaMethodTree, 0, 0);
                    this.doBuildJavaMethod(classItem2, entityMethods, renameNode.getOldName(), renameNode.getNewName(), LayerJavaCode.JavaType.Form, comparator);
                    continue;
                }
                if (renameNode.getJavaType() != LayerJavaCode.JavaType.DataSource) continue;
                TreeItem classItem3 = new TreeItem(formDataSourceItem, 0, 0);
                this.doBuildJavaMethod(classItem3, entityMethods, renameNode.getOldName(), renameNode.getNewName(), LayerJavaCode.JavaType.DataSource, comparator);
            }
            formDataSourceItem.setExpanded(true);
        } else {
            LayerJavaCode.JavaType javaType;
            if (entityMethods.getEntityType() == EntityType.Table) {
                javaType = LayerJavaCode.JavaType.Table;
            } else if (entityMethods.getEntityType() == EntityType.Class) {
                javaType = LayerJavaCode.JavaType.Class;
            } else {
                return;
            }
            List<String> allCodes = entityMethods.getAllCodes(javaType);
            for (String javaFileName : allCodes) {
                boolean find = renameNodes.stream().filter(n -> n.getJavaType() == javaType && (javaFileName.equals(n.getNewName()) || javaFileName.equals(n.getOldName()))).findFirst().isPresent();
                if (find) continue;
                TreeItem classItem = new TreeItem(this.javaMethodTree, 0, 0);
                this.doBuildJavaMethod(classItem, entityMethods, javaFileName, javaFileName, javaType, comparator);
            }
            for (RenameNode renameNode : renameNodes) {
                TreeItem classItem = new TreeItem(this.javaMethodTree, 0, 0);
                this.doBuildJavaMethod(classItem, entityMethods, renameNode.getOldName(), renameNode.getNewName(), renameNode.getJavaType(), comparator);
            }
        }
    }

    private void doBuildJavaMethod(TreeItem classItem, EntityMethods entityMethods, String oldFileNmae, String newFileName, LayerJavaCode.JavaType javaType, Comparator<LayerJavaMethod> comparator) {
        if (oldFileNmae.equals(newFileName)) {
            classItem.setText(oldFileNmae);
        } else {
            classItem.setText(String.valueOf(oldFileNmae) + " -> " + newFileName);
        }
        classItem.setImage(Images.getIcon("layerUpgrade/Java.png"));
        Map<String, List<LayerJavaMethod>> sourceMethods = entityMethods.getSourceMethods(oldFileNmae, javaType);
        Map<String, List<LayerJavaMethod>> targetMethods = entityMethods.getTargetMethods(newFileName, javaType);
        HashSet<String> allSignatures = new HashSet<String>(sourceMethods.keySet());
        allSignatures.addAll(targetMethods.keySet());
        List signatures = allSignatures.stream().sorted((s1, s2) -> s1.compareTo((String)s2)).collect(Collectors.toList());
        for (String signature : signatures) {
            LayerJavaMethod sourceMethod = null;
            LayerJavaMethod originMethod = null;
            LayerJavaMethod targetMethod = null;
            int modifiers = 0;
            Type returnType = null;
            boolean current = false;
            boolean promote = false;
            Image methodImg = null;
            List<LayerJavaMethod> sourceMethodList = sourceMethods.get(signature);
            if (sourceMethodList != null && !sourceMethodList.isEmpty()) {
                sourceMethodList.sort(comparator);
                sourceMethod = sourceMethodList.get(0);
                if (sourceMethod.getParent().getDeploymentMode().equals((Object)LayerDeploymentMode.Source)) {
                    current = true;
                    if (sourceMethodList.size() > 1) {
                        promote = true;
                        originMethod = sourceMethodList.get(1);
                        modifiers = originMethod.getMethodDeclaration().getModifiers();
                        returnType = originMethod.getMethodDeclaration().getReturnType2();
                    } else {
                        modifiers = sourceMethod.getMethodDeclaration().getModifiers();
                        returnType = sourceMethod.getMethodDeclaration().getReturnType2();
                    }
                } else {
                    sourceMethod = originMethod = sourceMethodList.get(0);
                    modifiers = sourceMethod.getMethodDeclaration().getModifiers();
                    returnType = sourceMethod.getMethodDeclaration().getReturnType2();
                }
            }
            if (targetMethods.containsKey(signature)) {
                List<LayerJavaMethod> targetMethodList = targetMethods.get(signature);
                targetMethodList.sort(comparator);
                if (!targetMethodList.isEmpty()) {
                    targetMethod = targetMethodList.get(0);
                    if (sourceMethodList == null || sourceMethodList.isEmpty()) {
                        modifiers = targetMethod.getMethodDeclaration().getModifiers();
                        returnType = targetMethod.getMethodDeclaration().getReturnType2();
                    }
                }
            } else if (originMethod != null && !entityMethods.isDeleteEntity()) {
                methodImg = deleteImage;
            }
            if (this.showPromote.getSelection() && !promote) continue;
            if (Modifier.isPublic((int)modifiers)) {
                if (!this.showPublic.getSelection()) continue;
                if (methodImg == null) {
                    methodImg = promote ? Images.getIcon("layerUpgrade/Public_Override.png") : publicMethod;
                }
            } else if (Modifier.isProtected((int)modifiers)) {
                if (!this.showProtect.getSelection()) continue;
                if (methodImg == null) {
                    methodImg = promote ? Images.getIcon("layerUpgrade/Protected_Override.png") : protectMethod;
                }
            } else if (Modifier.isPrivate((int)modifiers)) {
                if (!this.showPrivate.getSelection()) continue;
                if (methodImg == null) {
                    methodImg = privateMethod;
                }
            } else if (Modifier.isDefault((int)modifiers)) {
                if (!this.showDefault.getSelection()) continue;
                if (methodImg == null) {
                    methodImg = defaultMethod;
                }
            }
            TreeItem methodItem = new TreeItem(classItem, 0);
            methodItem.setImage(methodImg);
            if (current) {
                FontData fontData = methodItem.getFont().getFontData()[0];
                fontData.setStyle(1);
                methodItem.setFont(new Font((Device)this.shell.getDisplay(), fontData));
            }
            methodItem.setText(String.valueOf(signature) + " : " + returnType);
            methodItem.setData("sourceMethod", (Object)(sourceMethod != null ? sourceMethod.getContent() : ""));
            methodItem.setData("sourceMethodLayer", (Object)(sourceMethod != null ? sourceMethod.getParent().getLayerName() : ""));
            methodItem.setData("originMethod", (Object)(originMethod != null ? originMethod.getContent() : ""));
            methodItem.setData("originMethodLayer", (Object)(originMethod != null ? originMethod.getParent().getLayerName() : ""));
            methodItem.setData("targetMethod", (Object)(targetMethod != null ? targetMethod.getContent() : ""));
            methodItem.setData("targetMethodLayer", (Object)(targetMethod != null ? targetMethod.getParent().getLayerName() : ""));
            String javaPackagePath = targetMethod != null ? targetMethod.getParent().getJavaPackagePath() : (sourceMethod != null ? sourceMethod.getParent().getJavaPackagePath() : originMethod.getParent().getJavaPackagePath());
            methodItem.setData("javaPackagePath", (Object)(String.valueOf(javaPackagePath) + "." + signature));
        }
        classItem.setExpanded(true);
    }

    private int getLayerLevel(String layerName) {
        switch (layerName) {
            case "sys": {
                return 1;
            }
            case "obj": {
                return 2;
            }
            case "iny": {
                return 3;
            }
            case "ent": {
                return 4;
            }
            case "app": {
                return 5;
            }
            case "plg": {
                return 6;
            }
            case "ext": {
                return 7;
            }
        }
        return 0;
    }

    private void buildTreeInfoTable(List<GOTProperty> propertys_s, List<GOTProperty> propertys_t, boolean entityDif) throws VTDException {
        Color red = this.shell.getDisplay().getSystemColor(3);
        Color blue = this.shell.getDisplay().getSystemColor(9);
        Color green = this.shell.getDisplay().getSystemColor(6);
        FontData fontData = this.propertyInfoTree.getFont().getFontData()[0];
        fontData.setStyle(1);
        Font bold = new Font((Device)Display.getCurrent(), fontData);
        this.propertyInfoTree.removeAll();
        ArrayList<String> pNames = new ArrayList<String>();
        for (GOTProperty property_s : propertys_s) {
            String refInnerId_t;
            Image image = null;
            String name = property_s.getName();
            if (ignoreAnalysisPropertys.contains(name)) continue;
            pNames.add(name);
            Color displayColor = null;
            String value_s = StringUtils.isBlank((String)property_s.getValue()) ? "" : property_s.getValue();
            String value_t = "";
            Optional<GOTProperty> findFirst = propertys_t.stream().filter(p -> {
                try {
                    return p.getName().equals(name);
                }
                catch (NavException navException) {
                    return false;
                }
            }).findFirst();
            GOTProperty property_t = null;
            if (findFirst.isPresent()) {
                property_t = findFirst.get();
                String string = value_t = StringUtils.isBlank((String)property_t.getValue()) ? "" : property_t.getValue();
                if (!value_s.equals(value_t)) {
                    if (!this.difButton.getSelection()) continue;
                    displayColor = blue;
                    image = difImage;
                }
            } else {
                if (!this.deleteButton.getSelection()) continue;
                displayColor = red;
                image = deleteImage;
            }
            String innerId_s = property_s.getInnerId();
            String refEntityId_s = property_s.getRefEntityId();
            String refInnerId_s = property_s.getRefInnerId();
            String innerId_t = property_t != null ? property_t.getInnerId() : "";
            String refEntityId_t = property_t != null ? property_t.getRefEntityId() : "";
            String string = refInnerId_t = property_t != null ? property_t.getRefInnerId() : "";
            if (StringUtils.isNotBlank((String)innerId_s) || StringUtils.isNotBlank((String)innerId_t)) {
                innerId_s = innerId_s == null ? "" : innerId_s;
                String string2 = innerId_t = innerId_t == null ? "" : innerId_t;
                if (property_t != null && !innerId_s.equals(innerId_t)) {
                    displayColor = blue;
                }
            }
            if (StringUtils.isNotBlank((String)refEntityId_s) || StringUtils.isNotBlank((String)refEntityId_t)) {
                refEntityId_s = refEntityId_s == null ? "" : refEntityId_s;
                String string3 = refEntityId_t = refEntityId_t == null ? "" : refEntityId_t;
                if (property_t != null && !refEntityId_s.equals(refEntityId_t)) {
                    displayColor = blue;
                }
            }
            if (StringUtils.isNotBlank((String)refInnerId_s) || StringUtils.isNotBlank((String)refInnerId_t)) {
                refInnerId_s = refInnerId_s == null ? "" : refInnerId_s;
                String string4 = refInnerId_t = refInnerId_t == null ? "" : refInnerId_t;
                if (property_t != null && !refInnerId_s.equals(refInnerId_t)) {
                    displayColor = blue;
                }
            }
            if (displayColor != null && !this.difButton.getSelection() || displayColor == null && !this.difButton.getSelection()) continue;
            TreeItem treeItem = new TreeItem(this.propertyInfoTree, 0);
            treeItem.setText(name);
            treeItem.setText(1, value_s);
            treeItem.setText(2, value_t);
            if (displayColor != null && !entityDif) {
                treeItem.setForeground(displayColor);
                treeItem.setFont(bold);
            }
            if (image != null && !entityDif) {
                treeItem.setImage(image);
            }
            if (StringUtils.isNotBlank((String)innerId_s) || StringUtils.isNotBlank((String)innerId_t)) {
                TreeItem innerIdItem = new TreeItem(treeItem, 0);
                innerIdItem.setText("innerId");
                innerIdItem.setText(1, innerId_s);
                innerIdItem.setText(2, innerId_t);
            }
            if (StringUtils.isNotBlank((String)refEntityId_s) || StringUtils.isNotBlank((String)refEntityId_t)) {
                TreeItem refEntityIdItem = new TreeItem(treeItem, 0);
                refEntityIdItem.setText("refEntityId");
                refEntityIdItem.setText(1, refEntityId_s);
                refEntityIdItem.setText(2, refEntityId_t);
            }
            if (!StringUtils.isNotBlank((String)refInnerId_s) && !StringUtils.isNotBlank((String)refInnerId_t)) continue;
            TreeItem refInnerIdItem = new TreeItem(treeItem, 0);
            refInnerIdItem.setText("refInnerId");
            refInnerIdItem.setText(1, refInnerId_s);
            refInnerIdItem.setText(2, refInnerId_t);
        }
        if (!this.addButton.getSelection()) {
            return;
        }
        for (GOTProperty property_t : propertys_t) {
            String refInnerId_t;
            String name = property_t.getName();
            if (ignoreAnalysisPropertys.contains(name) || pNames.contains(name)) continue;
            int index = propertys_t.indexOf(property_t);
            if (index != 0) {
                while (index >= 0) {
                    GOTProperty gotProperty = propertys_t.get(index);
                    if (pNames.contains(gotProperty.getName())) {
                        index = pNames.indexOf(gotProperty.getName());
                        ++index;
                        break;
                    }
                    --index;
                }
            }
            TreeItem treeItem = new TreeItem(this.propertyInfoTree, 0, index);
            pNames.add(index, name);
            treeItem.setText(name);
            treeItem.setText(2, StringUtils.isBlank((String)property_t.getValue()) ? "" : property_t.getValue());
            if (!entityDif) {
                treeItem.setForeground(green);
                treeItem.setFont(bold);
                treeItem.setImage(addImage);
            }
            String innerId_t = property_t != null ? property_t.getInnerId() : "";
            String refEntityId_t = property_t != null ? property_t.getRefEntityId() : "";
            String string = refInnerId_t = property_t != null ? property_t.getRefInnerId() : "";
            if (StringUtils.isNotBlank((String)innerId_t)) {
                TreeItem innerIdItem = new TreeItem(treeItem, 0);
                innerIdItem.setText("innerId");
                innerIdItem.setText(2, innerId_t);
            }
            if (StringUtils.isNotBlank((String)refEntityId_t)) {
                TreeItem refEntityIdItem = new TreeItem(treeItem, 0);
                refEntityIdItem.setText("refEntityId");
                refEntityIdItem.setText(2, refEntityId_t);
            }
            if (!StringUtils.isNotBlank((String)refInnerId_t)) continue;
            TreeItem refInnerIdItem = new TreeItem(treeItem, 0);
            refInnerIdItem.setText("refInnerId");
            refInnerIdItem.setText(2, refInnerId_t);
        }
    }

    private void initGOTTree(Element element, TreeItem parentTreeItem) {
        TreeItem treeitem;
        if (parentTreeItem == null) {
            this.gotTree.removeAll();
            treeitem = new TreeItem(this.gotTree, 0);
        } else {
            treeitem = new TreeItem(parentTreeItem, 0);
        }
        treeitem.setText(element.getName());
        treeitem.setData((Object)element);
        treeitem.setImage(Images.getIcon(String.format("%s.png", element.getName())));
        List elements = element.elements();
        for (Element childElement : elements) {
            this.initGOTTree(childElement, treeitem);
        }
    }

    private void analysis() {
        this.upgradeService = null;
        this.upgradeService = new LayerUpgradeService();
        final Map<String, SolutionLayerInfo> solutionInfos = LayerChainPage.getInstance().getSolutions();
        final Map<String, PedestalLayerInfo> pedestalInfos = LayerChainPage.getInstance().getPedestals();
        try {
            this.analysisResult_Cache = new ArrayList<Element>();
            final ProgressMonitorDialog progressMonitorDialog = new ProgressMonitorDialog(this.shell);
            progressMonitorDialog.run(true, false, new IRunnableWithProgress(){

                /*
                 * Unable to fully structure code
                 */
                public void run(final IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                    Display.getDefault().syncExec((Runnable)LambdaMetafactory.metafactory(null, null, null, ()V, lambda$0(org.eclipse.jface.dialogs.ProgressMonitorDialog ), ()V)((ProgressMonitorDialog)progressMonitorDialog));
                    solutionDownloads = solutionInfos.values().stream().filter((Predicate<SolutionLayerInfo>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Z, lambda$1(gongqi.gdt.designer.utils.SolutionLayerInfo ), (Lgongqi/gdt/designer/utils/SolutionLayerInfo;)Z)()).collect(Collectors.toList());
                    pluginDownloads = solutionInfos.values().stream().flatMap((Function<SolutionLayerInfo, Stream>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, lambda$2(gongqi.gdt.designer.utils.SolutionLayerInfo ), (Lgongqi/gdt/designer/utils/SolutionLayerInfo;)Ljava/util/stream/Stream;)()).filter((Predicate<SolutionPluginInfo>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Z, lambda$3(gongqi.gdt.designer.utils.SolutionPluginInfo ), (Lgongqi/gdt/designer/utils/SolutionPluginInfo;)Z)()).collect(Collectors.toList());
                    monitor.beginTask("", solutionDownloads.size() + pluginDownloads.size() + 1);
                    monitor.setTaskName("\u30101/4\u3011\u6b63\u5728\u52a0\u8f7d\u5c42\u6587\u4ef6...");
                    monitor.subTask("\u6b63\u5728\u4e0b\u8f7d\u5e95\u5ea7");
                    baseUrl = MarketUtil.baseUrl;
                    for (final PedestalLayerInfo pedestalInfo : pedestalInfos.values()) {
                        targetUpdateFile = pedestalInfo.getUpdateFile(pedestalInfo.getTargetVersion());
                        if (pedestalInfo.isOnline() != null && pedestalInfo.isOnline().booleanValue() && !targetUpdateFile.exists()) {
                            if (!targetUpdateFile.getParentFile().exists()) {
                                targetUpdateFile.getParentFile().mkdirs();
                            }
                            if (pedestalInfo.getCurrentVersion().equals(pedestalInfo.getTargetVersion())) {
                                try {
                                    basePath = ProjectConstants.getBasePath();
                                    if (pedestalInfo.getDeploymentMode().equals((Object)LayerDeploymentMode.Package)) {
                                        updateFile = new File(basePath, String.format("Project/Server/GongqiERP/WEB-INF/layers/layer_%s.lyr", new Object[]{pedestalInfo.getLayerId()}));
                                        FileUtils.copyFile((File)updateFile, (File)targetUpdateFile);
                                    }
                                    if (targetUpdateFile.exists()) {
                                        FileUtils.deleteDirectory((File)targetUpdateFile);
                                    }
                                    targetUpdateFile.mkdirs();
                                }
                                catch (Exception e) {
                                    AnalysisResultPage.access$1().error((Object)"\u590d\u5236\u5e95\u5ea7\u6e90\u5305\u65f6\u53d1\u751f\u9519\u8bef", (Throwable)e);
                                    throw new RuntimeException("\u590d\u5236\u5e95\u5ea7\u6e90\u5305\u65f6\u53d1\u751f\u9519\u8bef", e);
                                }
                            } else {
                                downloadUrl = pedestalInfo.getDownloadUrl();
                                split = downloadUrl.split("/");
                                filename = split[split.length - 1];
                                if (!filename.endsWith(".lyr") && !filename.endsWith(".lyrs")) {
                                    return;
                                }
                                try {
                                    url = new URL(downloadUrl);
                                    connection = url.openConnection();
                                    connection.addRequestProperty("Cookie", MarketUtil.getCookie());
                                    tempDirectory = new File(FileUtils.getTempDirectory(), UUID.randomUUID().toString());
                                    tempDirectory.mkdirs();
                                    layerFile = new File(tempDirectory, filename);
                                    layerFile.createNewFile();
                                    var15_32 = null;
                                    var16_34 = null;
                                    try {
                                        inputStream = connection.getInputStream();
                                        try {
                                            outputStream = new FileOutputStream(layerFile);
                                            try {
                                                IOUtils.copy((InputStream)inputStream, (OutputStream)outputStream);
                                            }
                                            finally {
                                                if (outputStream != null) {
                                                    outputStream.close();
                                                }
                                            }
                                            ** if (inputStream == null) goto lbl-1000
                                        }
                                        catch (Throwable var16_35) {
                                            if (var15_32 == null) {
                                                var15_32 = var16_35;
                                            } else if (var15_32 != var16_35) {
                                                var15_32.addSuppressed(var16_35);
                                            }
                                            if (inputStream != null) {
                                                inputStream.close();
                                            }
                                            throw var15_32;
                                        }
lbl-1000:
                                        // 1 sources

                                        {
                                            inputStream.close();
                                        }
lbl-1000:
                                        // 2 sources

                                        {
                                        }
                                    }
                                    catch (Throwable var16_36) {
                                        if (var15_32 == null) {
                                            var15_32 = var16_36;
                                        } else if (var15_32 != var16_36) {
                                            var15_32.addSuppressed(var16_36);
                                        }
                                        throw var15_32;
                                    }
                                    objLyr = null;
                                    tempDir = null;
                                    if (layerFile.getName().endsWith(".lyrs")) {
                                        tempDir = FileUtils.mkTempDir();
                                        ZipUtil.unZipFiles((String)layerFile.getAbsolutePath(), (String)tempDir.getAbsolutePath());
                                        objLyr = tempDir.listFiles(new FileFilter(){

                                            @Override
                                            public boolean accept(File file) {
                                                if (!file.getName().endsWith(".lyr")) {
                                                    return false;
                                                }
                                                FrameworkManager.registerObjects();
                                                LayerResolver layerResolver = (LayerResolver)ObjectContainer.getInstance(LayerResolver.class);
                                                try {
                                                    LayerDefination layerDefination = layerResolver.resolveLayer(file.getAbsolutePath());
                                                    return pedestalInfo.getLayerId().equals(layerDefination.getLayerName());
                                                }
                                                catch (Exception exception) {
                                                    return false;
                                                }
                                            }
                                        })[0];
                                    } else if (layerFile.getName().endsWith(".lyr")) {
                                        try {
                                            FrameworkManager.registerObjects();
                                            layerResolver = (LayerResolver)ObjectContainer.getInstance(LayerResolver.class);
                                            layerDefination = layerResolver.resolveLayer(layerFile.getAbsolutePath());
                                            if (pedestalInfo.getLayerId().equals(layerDefination.getLayerName())) {
                                                objLyr = layerFile;
                                            }
                                        }
                                        catch (Exception v0) {}
                                    }
                                    if (objLyr == null || !objLyr.exists()) {
                                        throw new RuntimeException("\u65e0\u6548\u7684\u5c42\u6587\u4ef6");
                                    }
                                    FileUtils.copyFile((File)objLyr, (File)targetUpdateFile);
                                }
                                catch (IOException e) {
                                    AnalysisResultPage.access$1().error((Object)"\u4e0b\u8f7d\u5e95\u5ea7\u6e90\u5305\u65f6\u53d1\u751f\u9519\u8bef", (Throwable)e);
                                    throw new RuntimeException("\u4e0b\u8f7d\u5e95\u5ea7\u6e90\u5305\u65f6\u53d1\u751f\u9519\u8bef", e);
                                }
                            }
                        }
                        monitor.worked(1);
                    }
                    for (SolutionLayerInfo solutionInfo : solutionDownloads) {
                        block132: {
                            monitor.subTask(String.format("\u6b63\u5728\u4e0b\u8f7d\u5e94\u7528\u3010%s\u3011...", new Object[]{solutionInfo.getSolutionName()}));
                            if (solutionInfo.getDeploymentMode().equals((Object)SolutionDeploymentMode.Source)) continue;
                            if (solutionInfo.getCurrentVersion().equals(solutionInfo.getTargetVersion())) {
                                layersRoot = ((LayerLocator)ObjectContainer.getInstance(LayerLocator.class)).getLayersRoot();
                                appFile = new File((File)layersRoot, String.format("app/%s%s", new Object[]{solutionInfo.getSolutionId(), ".app"}));
                                if (appFile.exists() && appFile.exists()) {
                                    try {
                                        FileUtils.copyFile((File)appFile, (File)solutionInfo.getUpdateFile(solutionInfo.getTargetVersion()));
                                    }
                                    catch (IOException e) {
                                        AnalysisResultPage.access$1().error((Object)"\u590d\u5236\u5e94\u7528\u6e90\u5305\u65f6\u53d1\u751f\u9519\u8bef", (Throwable)e);
                                        throw new RuntimeException("\u590d\u5236\u5e94\u7528\u6e90\u5305\u65f6\u53d1\u751f\u9519\u8bef", e);
                                    }
                                }
                                throw new RuntimeException("\u672a\u627e\u5230\u5e94\u7528\u6587\u4ef6" + appFile.getAbsolutePath());
                            }
                            try {
                                layersRoot = null;
                                appFile = null;
                                try {
                                    httpClient = HttpClients.createDefault();
                                    try {
                                        httpPost = new HttpPost(String.format("%s/appuser/download/source?appUserId=%s&versionId=%s", new Object[]{baseUrl, solutionInfo.getAppUserId(), solutionInfo.getTargetVersion()}));
                                        httpPost.addHeader("Cookie", MarketUtil.getCookie());
                                        e = null;
                                        connection = null;
                                        try {
                                            response = httpClient.execute((HttpUriRequest)httpPost);
                                            try {
                                                if (response.getStatusLine().getStatusCode() != 200) break block132;
                                                entity = response.getEntity();
                                                responseResult = JSONObject.parseObject((String)EntityUtils.toString((HttpEntity)entity, (String)"utf-8"));
                                                if (responseResult.getInteger("errcode") != 0) {
                                                    throw new RuntimeException(String.valueOf(solutionInfo.getSolutionId()) + "\u4e0b\u8f7d\u5931\u8d25\uff1a" + responseResult.getString("errmsg"));
                                                }
                                                url = new URL(responseResult.getString("content"));
                                                connection = url.openConnection();
                                                connection.addRequestProperty("Cookie", MarketUtil.getCookie());
                                                appFile = solutionInfo.getUpdateFile(solutionInfo.getTargetVersion());
                                                appFile.createNewFile();
                                                var19_39 = null;
                                                var20_42 = null;
                                                try {
                                                    inputStream = connection.getInputStream();
                                                    try {
                                                        outputStream = new FileOutputStream(appFile);
                                                        try {
                                                            IOUtils.copy((InputStream)inputStream, (OutputStream)outputStream);
                                                        }
                                                        finally {
                                                            if (outputStream != null) {
                                                                outputStream.close();
                                                            }
                                                        }
                                                        ** if (inputStream == null) goto lbl-1000
                                                    }
                                                    catch (Throwable var20_43) {
                                                        if (var19_39 == null) {
                                                            var19_39 = var20_43;
                                                        } else if (var19_39 != var20_43) {
                                                            var19_39.addSuppressed(var20_43);
                                                        }
                                                        if (inputStream != null) {
                                                            inputStream.close();
                                                        }
                                                        throw var19_39;
                                                    }
lbl-1000:
                                                    // 1 sources

                                                    {
                                                        inputStream.close();
                                                    }
lbl-1000:
                                                    // 2 sources

                                                    {
                                                    }
                                                }
                                                catch (Throwable var20_44) {
                                                    if (var19_39 == null) {
                                                        var19_39 = var20_44;
                                                    } else if (var19_39 != var20_44) {
                                                        var19_39.addSuppressed(var20_44);
                                                    }
                                                    throw var19_39;
                                                }
                                            }
                                            finally {
                                                if (response != null) {
                                                    response.close();
                                                }
                                            }
                                        }
                                        catch (Throwable connection) {
                                            if (e == null) {
                                                e = connection;
                                            } else if (e != connection) {
                                                e.addSuppressed(connection);
                                            }
                                            throw e;
                                        }
                                    }
                                    finally {
                                        if (httpClient != null) {
                                            httpClient.close();
                                        }
                                    }
                                }
                                catch (Throwable appFile) {
                                    if (layersRoot == null) {
                                        layersRoot = appFile;
                                    } else if (layersRoot != appFile) {
                                        layersRoot.addSuppressed(appFile);
                                    }
                                    throw layersRoot;
                                }
                            }
                            catch (IOException e) {
                                AnalysisResultPage.access$1().error((Object)String.format("\u4e0b\u8f7d\u5e94\u7528\u3010%s\u3011\u6e90\u5305\u65f6\u53d1\u751f\u9519\u8bef", new Object[]{solutionInfo.getSolutionId()}), (Throwable)e);
                                throw new RuntimeException(String.format("\u4e0b\u8f7d\u5e94\u7528\u3010%s\u3011\u6e90\u5305\u65f6\u53d1\u751f\u9519\u8bef", new Object[]{solutionInfo.getSolutionId()}), e);
                            }
                        }
                        monitor.worked(1);
                    }
                    for (SolutionPluginInfo pluginInfo : pluginDownloads) {
                        block134: {
                            monitor.subTask(String.format("\u6b63\u5728\u4e0b\u8f7d\u63d2\u4ef6\u3010%s\u3011...", new Object[]{pluginInfo.getPluginId()}));
                            if (pluginInfo.getDeploymentMode().equals((Object)SolutionPluginDeploymentMode.Source)) continue;
                            if (pluginInfo.getCurrentVersion().equals(pluginInfo.getTargetVersion())) {
                                layersRoot = ((LayerLocator)ObjectContainer.getInstance(LayerLocator.class)).getLayersRoot();
                                plgFile = new File((File)layersRoot, String.format("plg/%s/%s%s", new Object[]{pluginInfo.getSolutionLayerInfo().getSolutionId(), pluginInfo.getPluginId(), ".plugin"}));
                                if (plgFile.exists() && plgFile.exists()) {
                                    tempDirectory = new File(FileUtils.getTempDirectory(), UUID.randomUUID().toString());
                                    tempDirectory.mkdirs();
                                    try {
                                        FileUtils.copyFile((File)plgFile, (File)pluginInfo.getUpdateFile(pluginInfo.getTargetVersion()));
                                    }
                                    catch (IOException e) {
                                        AnalysisResultPage.access$1().error((Object)"\u590d\u5236\u63d2\u4ef6\u6e90\u5305\u65f6\u53d1\u751f\u9519\u8bef", (Throwable)e);
                                        throw new RuntimeException("\u590d\u5236\u63d2\u4ef6\u6e90\u5305\u65f6\u53d1\u751f\u9519\u8bef", e);
                                    }
                                }
                                throw new RuntimeException("\u672a\u627e\u5230\u5e94\u7528\u6587\u4ef6" + plgFile.getAbsolutePath());
                            }
                            try {
                                layersRoot = null;
                                plgFile = null;
                                try {
                                    httpClient = HttpClients.createDefault();
                                    try {
                                        httpPost = new HttpPost(String.format("%s/plugin/download/version?pluginId=%s&versionId=%s", new Object[]{baseUrl, pluginInfo.getDownloadPluginId(), pluginInfo.getTargetVersion()}));
                                        httpPost.addHeader("Cookie", MarketUtil.getCookie());
                                        e = null;
                                        connection = null;
                                        try {
                                            response = httpClient.execute((HttpUriRequest)httpPost);
                                            try {
                                                if (response.getStatusLine().getStatusCode() != 200) break block134;
                                                entity = response.getEntity();
                                                responseResult = JSONObject.parseObject((String)EntityUtils.toString((HttpEntity)entity, (String)"utf-8"));
                                                if (responseResult.getInteger("errcode") != 0) {
                                                    throw new RuntimeException(responseResult.getString("errmsg"));
                                                }
                                                url = new URL(responseResult.getString("content"));
                                                connection = url.openConnection();
                                                connection.addRequestProperty("Cookie", MarketUtil.getCookie());
                                                pluginFile = pluginInfo.getUpdateFile(pluginInfo.getTargetVersion());
                                                pluginFile.createNewFile();
                                                var19_39 = null;
                                                var20_42 = null;
                                                try {
                                                    inputStream = connection.getInputStream();
                                                    try {
                                                        outputStream = new FileOutputStream(pluginFile);
                                                        try {
                                                            IOUtils.copy((InputStream)inputStream, (OutputStream)outputStream);
                                                        }
                                                        finally {
                                                            if (outputStream != null) {
                                                                outputStream.close();
                                                            }
                                                        }
                                                        ** if (inputStream == null) goto lbl-1000
                                                    }
                                                    catch (Throwable var20_45) {
                                                        if (var19_39 == null) {
                                                            var19_39 = var20_45;
                                                        } else if (var19_39 != var20_45) {
                                                            var19_39.addSuppressed(var20_45);
                                                        }
                                                        if (inputStream != null) {
                                                            inputStream.close();
                                                        }
                                                        throw var19_39;
                                                    }
lbl-1000:
                                                    // 1 sources

                                                    {
                                                        inputStream.close();
                                                    }
lbl-1000:
                                                    // 2 sources

                                                    {
                                                    }
                                                }
                                                catch (Throwable var20_46) {
                                                    if (var19_39 == null) {
                                                        var19_39 = var20_46;
                                                    } else if (var19_39 != var20_46) {
                                                        var19_39.addSuppressed(var20_46);
                                                    }
                                                    throw var19_39;
                                                }
                                            }
                                            finally {
                                                if (response != null) {
                                                    response.close();
                                                }
                                            }
                                        }
                                        catch (Throwable connection) {
                                            if (e == null) {
                                                e = connection;
                                            } else if (e != connection) {
                                                e.addSuppressed(connection);
                                            }
                                            throw e;
                                        }
                                    }
                                    finally {
                                        if (httpClient != null) {
                                            httpClient.close();
                                        }
                                    }
                                }
                                catch (Throwable plgFile) {
                                    if (layersRoot == null) {
                                        layersRoot = plgFile;
                                    } else if (layersRoot != plgFile) {
                                        layersRoot.addSuppressed(plgFile);
                                    }
                                    throw layersRoot;
                                }
                            }
                            catch (IOException e) {
                                AnalysisResultPage.access$1().error((Object)String.format("\u4e0b\u8f7d\u63d2\u4ef6\u3010%s\u3011\u6e90\u5305\u65f6\u53d1\u751f\u9519\u8bef", new Object[]{pluginInfo.getPluginId()}), (Throwable)e);
                                throw new RuntimeException(String.format("\u4e0b\u8f7d\u63d2\u4ef6\u3010%s\u3011\u6e90\u5305\u65f6\u53d1\u751f\u9519\u8bef", new Object[]{pluginInfo.getPluginId()}), e);
                            }
                        }
                        monitor.worked(1);
                    }
                    solutionPluginFiles = solutionInfos.values().stream().flatMap((Function<SolutionLayerInfo, Stream>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, lambda$4(gongqi.gdt.designer.utils.SolutionLayerInfo ), (Lgongqi/gdt/designer/utils/SolutionLayerInfo;)Ljava/util/stream/Stream;)()).filter((Predicate<SolutionPluginInfo>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Z, lambda$5(gongqi.gdt.designer.utils.SolutionPluginInfo ), (Lgongqi/gdt/designer/utils/SolutionPluginInfo;)Z)()).map((Function<SolutionPluginInfo, File>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, lambda$6(gongqi.gdt.designer.utils.SolutionPluginInfo ), (Lgongqi/gdt/designer/utils/SolutionPluginInfo;)Ljava/io/File;)()).collect(Collectors.toList());
                    solutionFiles = solutionInfos.values().stream().filter((Predicate<SolutionLayerInfo>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Z, lambda$7(gongqi.gdt.designer.utils.SolutionLayerInfo ), (Lgongqi/gdt/designer/utils/SolutionLayerInfo;)Z)()).filter((Predicate<SolutionLayerInfo>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Z, lambda$8(gongqi.gdt.designer.utils.SolutionLayerInfo ), (Lgongqi/gdt/designer/utils/SolutionLayerInfo;)Z)()).map((Function<SolutionLayerInfo, File>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, lambda$9(gongqi.gdt.designer.utils.SolutionLayerInfo ), (Lgongqi/gdt/designer/utils/SolutionLayerInfo;)Ljava/io/File;)()).collect(Collectors.toList());
                    layerFiles = pedestalInfos.values().stream().filter((Predicate<PedestalLayerInfo>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Z, lambda$10(gongqi.gdt.designer.utils.PedestalLayerInfo ), (Lgongqi/gdt/designer/utils/PedestalLayerInfo;)Z)()).map((Function<PedestalLayerInfo, File>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, lambda$11(gongqi.gdt.designer.utils.PedestalLayerInfo ), (Lgongqi/gdt/designer/utils/PedestalLayerInfo;)Ljava/io/File;)()).collect(Collectors.toList());
                    AnalysisResultPage.access$54(AnalysisResultPage.this).setLayerFiles(layerFiles);
                    AnalysisResultPage.access$54(AnalysisResultPage.this).setSolutionFiles(solutionFiles);
                    AnalysisResultPage.access$54(AnalysisResultPage.this).setSolutionPluginFiles(solutionPluginFiles);
                    AnalysisResultPage.access$54(AnalysisResultPage.this).setSolutionExtensionFiles(new ArrayList<File>());
                    monitor.done();
                    try {
                        monitor.beginTask("", 1);
                        monitor.subTask("");
                        monitor.setTaskName("\u30101/4\u3011\u6b63\u5728\u8fdb\u884c\u73af\u5883\u68c0\u6d4b");
                        result = AnalysisResultPage.access$55(AnalysisResultPage.this);
                        if (StringUtils.isNotBlank((String)result)) {
                            throw new RuntimeException(result);
                        }
                        monitor.worked(1);
                        monitor.beginTask("", 10);
                        monitor.setTaskName("\u30102/4\u3011\u6b63\u5728\u8fdb\u884c\u6a21\u578b\u6821\u9a8c");
                        scopeIds = solutionInfos.values().stream().filter((Predicate<SolutionLayerInfo>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Z, lambda$12(gongqi.gdt.designer.utils.SolutionLayerInfo ), (Lgongqi/gdt/designer/utils/SolutionLayerInfo;)Z)()).map((Function<SolutionLayerInfo, String>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, lambda$13(gongqi.gdt.designer.utils.SolutionLayerInfo ), (Lgongqi/gdt/designer/utils/SolutionLayerInfo;)Ljava/lang/String;)()).collect(Collectors.toList());
                        scopeIds.addAll((Collection)solutionInfos.values().stream().filter((Predicate<SolutionLayerInfo>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Z, lambda$14(gongqi.gdt.designer.utils.SolutionLayerInfo ), (Lgongqi/gdt/designer/utils/SolutionLayerInfo;)Z)()).flatMap((Function<SolutionLayerInfo, Stream>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, lambda$15(gongqi.gdt.designer.utils.SolutionLayerInfo ), (Lgongqi/gdt/designer/utils/SolutionLayerInfo;)Ljava/util/stream/Stream;)()).map((Function<SolutionPluginInfo, String>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, lambda$16(gongqi.gdt.designer.utils.SolutionPluginInfo ), (Lgongqi/gdt/designer/utils/SolutionPluginInfo;)Ljava/lang/String;)()).collect(Collectors.toList()));
                        sourceResults = new ArrayList<E>();
                        targetResults = new ArrayList<E>();
                        try {
                            CompletableFuture.allOf(new CompletableFuture[]{CompletableFuture.runAsync((Runnable)LambdaMetafactory.metafactory(null, null, null, ()V, lambda$17(org.eclipse.core.runtime.IProgressMonitor java.util.List java.util.List ), ()V)(this, (IProgressMonitor)monitor, sourceResults, scopeIds)), CompletableFuture.runAsync((Runnable)LambdaMetafactory.metafactory(null, null, null, ()V, lambda$18(org.eclipse.core.runtime.IProgressMonitor java.util.List ), ()V)(this, (IProgressMonitor)monitor, targetResults))}).get();
                        }
                        catch (Throwable e) {
                            throw new RuntimeException("\u521d\u59cb\u5316\u5f53\u524d\u5c42\u6a21\u578b\u548c\u5347\u7ea7\u5c42\u6a21\u5f02\u5e38", e);
                        }
                        if (sourceResults.size() > 0) {
                            new Thread((Runnable)LambdaMetafactory.metafactory(null, null, null, ()V, lambda$19(org.eclipse.jface.dialogs.ProgressMonitorDialog java.util.List ), ()V)(this, (ProgressMonitorDialog)progressMonitorDialog, sourceResults)).start();
                            return;
                        }
                        if (targetResults.size() > 0) {
                            new Thread((Runnable)LambdaMetafactory.metafactory(null, null, null, ()V, lambda$20(org.eclipse.jface.dialogs.ProgressMonitorDialog java.util.List ), ()V)(this, (ProgressMonitorDialog)progressMonitorDialog, targetResults)).start();
                            return;
                        }
                        dataDifs = new ArrayList<E>();
                        dataConflicts = new HashMap<K, V>();
                        monitor.beginTask("", 6);
                        monitor.setTaskName("\u30103/4\u3011\u6b63\u5728\u8fdb\u884c\u7ed3\u6784\u6821\u9a8c..");
                        try {
                            CompletableFuture.allOf(new CompletableFuture[]{CompletableFuture.runAsync((Runnable)LambdaMetafactory.metafactory(null, null, null, ()V, lambda$21(java.util.Map java.util.List java.util.List org.eclipse.core.runtime.IProgressMonitor ), ()V)(this, (Map)pedestalInfos, scopeIds, dataDifs, (IProgressMonitor)monitor)), CompletableFuture.runAsync((Runnable)LambdaMetafactory.metafactory(null, null, null, ()V, lambda$22(org.eclipse.core.runtime.IProgressMonitor ), ()V)(this, (IProgressMonitor)monitor))}).get();
                        }
                        catch (Throwable e) {
                            throw new RuntimeException("\u7ed3\u6784\u6821\u9a8c\u5f02\u5e38", e);
                        }
                        if (dataDifs.size() > 0) {
                            new Thread((Runnable)LambdaMetafactory.metafactory(null, null, null, ()V, lambda$23(org.eclipse.jface.dialogs.ProgressMonitorDialog java.util.List ), ()V)(this, (ProgressMonitorDialog)progressMonitorDialog, dataDifs)).start();
                            return;
                        }
                        if (dataConflicts.size() > 0) {
                            new Thread((Runnable)LambdaMetafactory.metafactory(null, null, null, ()V, lambda$24(org.eclipse.jface.dialogs.ProgressMonitorDialog java.util.Map ), ()V)(this, (ProgressMonitorDialog)progressMonitorDialog, dataConflicts)).start();
                            return;
                        }
                        AnalysisResultPage.access$54(AnalysisResultPage.this).analysis(new ProgressMonitor(){

                            @Override
                            public void worked(int work, String message) {
                                monitor.subTask(message);
                                monitor.worked(1);
                            }

                            @Override
                            public void reportResult(final Element entityResult) {
                                AnalysisResultPage.this.shell.getDisplay().asyncExec(new Runnable(){

                                    @Override
                                    public void run() {
                                        AnalysisResultPage.this.analysisResult_Cache.add(entityResult);
                                    }
                                });
                            }

                            @Override
                            public void done(final Throwable e) {
                                AnalysisResultPage.this.shell.getDisplay().asyncExec(new Runnable(){

                                    @Override
                                    public void run() {
                                        if (e == null) {
                                            MessageDialog.openInformation((Shell)AnalysisResultPage.this.shell, (String)"\u63d0\u793a", (String)"\u5206\u6790\u5b8c\u6210");
                                            for (Element result : AnalysisResultPage.this.analysisResult_Cache) {
                                                List cannotItems = result.selectNodes(String.format(".//Item[@modifyLevel='%s']", new Object[]{ModifyLevel.Cannot}));
                                                AnalysisResultPage.this.analysis_Finish = cannotItems.isEmpty();
                                                if (!AnalysisResultPage.this.analysis_Finish) break;
                                            }
                                            AnalysisResultPage.this.updateButtonStatus();
                                        } else {
                                            MessageDialog.openError((Shell)AnalysisResultPage.this.shell, (String)"\u63d0\u793a", (String)String.format("\u5206\u6790\u9519\u8bef\uff1a%s", e.getLocalizedMessage()));
                                            log.error((Object)"\u5347\u7ea7\u5185\u5bb9\u5206\u6790\u9519\u8bef", e);
                                        }
                                    }
                                });
                            }

                            @Override
                            public void beginTask(int totalWork) {
                                monitor.beginTask("", totalWork);
                            }

                            @Override
                            public void setTaskName(String name) {
                                monitor.setTaskName(name);
                            }
                        });
                    }
                    catch (VTDException | IOException e) {
                        AnalysisResultPage.access$1().error((Object)"\u5347\u7ea7\u5185\u5bb9\u5206\u6790\u7a0b\u5e8f\u5f02\u5e38", e);
                    }
                }

                private static /* synthetic */ void lambda$0(ProgressMonitorDialog progressMonitorDialog2) {
                    progressMonitorDialog2.getShell().setText("\u5185\u5bb9\u5206\u6790");
                }

                private static /* synthetic */ boolean lambda$1(SolutionLayerInfo solutionInfo) {
                    return solutionInfo.isOnline() != null && solutionInfo.isOnline() != false && !solutionInfo.getUpdateFile(solutionInfo.getTargetVersion()).exists();
                }

                private static /* synthetic */ Stream lambda$2(SolutionLayerInfo solutionInfo) {
                    return solutionInfo.getPluginInfos().stream();
                }

                private static /* synthetic */ boolean lambda$3(SolutionPluginInfo pluginInfo) {
                    return pluginInfo.isOnline() != null && pluginInfo.isOnline() != false && !pluginInfo.getUpdateFile(pluginInfo.getTargetVersion()).exists();
                }

                private static /* synthetic */ Stream lambda$4(SolutionLayerInfo solutionInfo) {
                    return solutionInfo.getPluginInfos().stream();
                }

                private static /* synthetic */ boolean lambda$5(SolutionPluginInfo p) {
                    return p.isOnline() != null && p.getDeploymentMode().equals((Object)SolutionPluginDeploymentMode.Package);
                }

                private static /* synthetic */ File lambda$6(SolutionPluginInfo p) {
                    return p.getUpdateFile(p.getTargetVersion());
                }

                private static /* synthetic */ boolean lambda$7(SolutionLayerInfo a) {
                    return a.isOnline() != null && a.getDeploymentMode().equals((Object)SolutionDeploymentMode.Package);
                }

                private static /* synthetic */ boolean lambda$8(SolutionLayerInfo a) {
                    return a.getTargetVersion() != null;
                }

                private static /* synthetic */ File lambda$9(SolutionLayerInfo a) {
                    return a.getUpdateFile(a.getTargetVersion());
                }

                private static /* synthetic */ boolean lambda$10(PedestalLayerInfo a) {
                    return a.isOnline() != null;
                }

                private static /* synthetic */ File lambda$11(PedestalLayerInfo a) {
                    return a.getUpdateFile(a.getTargetVersion());
                }

                private static /* synthetic */ boolean lambda$12(SolutionLayerInfo s) {
                    return s.isOnline() != null;
                }

                private static /* synthetic */ String lambda$13(SolutionLayerInfo s) {
                    return s.getSolutionId();
                }

                private static /* synthetic */ boolean lambda$14(SolutionLayerInfo s) {
                    return s.isOnline() != null;
                }

                private static /* synthetic */ Stream lambda$15(SolutionLayerInfo s) {
                    return s.getPluginInfos().stream();
                }

                private static /* synthetic */ String lambda$16(SolutionPluginInfo p) {
                    return p.getPluginId();
                }

                private /* synthetic */ void lambda$17(IProgressMonitor iProgressMonitor, List list, List list2) {
                    try {
                        AnalysisResultPage.this.upgradeService.initSourceGOTModel();
                    }
                    catch (Exception e) {
                        throw new RuntimeException("\u89e3\u6790\u5f53\u524d\u5c42\u6a21\u578b\u9519\u8bef", e);
                    }
                    iProgressMonitor.worked(3);
                    list.addAll(AnalysisResultPage.this.upgradeService.checkSourceRelation(list2));
                    iProgressMonitor.worked(2);
                }

                private /* synthetic */ void lambda$18(IProgressMonitor iProgressMonitor, List list) {
                    try {
                        AnalysisResultPage.this.upgradeService.initTargetGOTModel();
                    }
                    catch (Exception e) {
                        throw new RuntimeException("\u89e3\u6790\u5f53\u5347\u7ea7\u6a21\u578b\u9519\u8bef", e);
                    }
                    iProgressMonitor.worked(3);
                    list.addAll(AnalysisResultPage.this.upgradeService.checkTargetRelation());
                    iProgressMonitor.worked(2);
                }

                private /* synthetic */ void lambda$19(final ProgressMonitorDialog progressMonitorDialog2, final List list) {
                    Display.getDefault().asyncExec(new Runnable(){

                        @Override
                        public void run() {
                            NodeRelationErrorDialog dialog = new NodeRelationErrorDialog((Window)progressMonitorDialog2, "\u5f53\u524d\u5c42\u6a21\u578b\u8282\u70b9\u5f15\u7528\u5f02\u5e38", list);
                            dialog.open();
                        }
                    });
                }

                private /* synthetic */ void lambda$20(final ProgressMonitorDialog progressMonitorDialog2, final List list) {
                    Display.getDefault().asyncExec(new Runnable(){

                        @Override
                        public void run() {
                            NodeRelationErrorDialog dialog = new NodeRelationErrorDialog((Window)progressMonitorDialog2, "\u5347\u7ea7\u6a21\u578b\u8282\u70b9\u5f15\u7528\u5f02\u5e38", list);
                            dialog.open();
                        }
                    });
                }

                private /* synthetic */ void lambda$21(Map map, List list, List list2, IProgressMonitor iProgressMonitor) {
                    Datadictionary datadictionary = AnalysisResultPage.this.upgradeService.getDatadictionary(map, list);
                    List<Map<String, Object>> results = MergeDatabaseUtil.validateGotDatabase(datadictionary, list);
                    list2.addAll(results);
                    iProgressMonitor.worked(1);
                    if (results.size() > 0) {
                        return;
                    }
                    datadictionary = null;
                }

                private /* synthetic */ void lambda$22(IProgressMonitor iProgressMonitor) {
                    AnalysisResultPage.this.upgradeService.initGOTModel(iProgressMonitor);
                }

                private /* synthetic */ void lambda$23(final ProgressMonitorDialog progressMonitorDialog2, final List list) {
                    Display.getDefault().asyncExec(new Runnable(){

                        @Override
                        public void run() {
                            DatabaseDifDialog dialog = new DatabaseDifDialog((Window)progressMonitorDialog2, list);
                            dialog.open();
                        }
                    });
                }

                private /* synthetic */ void lambda$24(final ProgressMonitorDialog progressMonitorDialog2, final Map map) {
                    Display.getDefault().asyncExec(new Runnable(){

                        @Override
                        public void run() {
                            DatabaseConflictDialog dialog = new DatabaseConflictDialog((Window)progressMonitorDialog2, map);
                            dialog.open();
                        }
                    });
                }
            });
        }
        catch (InterruptedException | InvocationTargetException e) {
            log.error((Object)"\u5347\u7ea7\u5185\u5bb9\u5206\u6790\u7a0b\u5e8f\u5f02\u5e38", (Throwable)e);
            if (e instanceof InvocationTargetException) {
                MessageDialog.openError((Shell)this.shell, (String)"\u63d0\u793a", (String)e.getCause().getMessage());
            }
            MessageDialog.openError((Shell)this.shell, (String)"\u63d0\u793a", (String)e.getMessage());
        }
        this.buildGOTTree();
    }

    private String checkEnvironment() {
        try {
            File containerDir = ((GongqiEnvironment)ObjectContainer.getInstance(GongqiEnvironment.class)).getContainerDir();
            String devDataArea = FileUtils.readFileToDocument((File)new File(containerDir, "/WEB-INF/config/DataArea.xml")).getRootElement().selectSingleNode("./general-configuration/property[@name='gongqi.framework.data.dev_data_area']").getText();
            Element dataAreaConfigurationElement = FileUtils.readFileToDocument((File)new File(containerDir, String.format("/WEB-INF/config/dataArea/dataArea.%s.xml", devDataArea))).getRootElement();
            Element sessionFactoryElement = (Element)dataAreaConfigurationElement.selectSingleNode("./hibernate-configuration/session-factory");
            String jdbcUrl = sessionFactoryElement.selectSingleNode(String.format("./property[@name='%s']", "hibernate.connection.url")).getText();
            String jdbcUsername = sessionFactoryElement.selectSingleNode(String.format("./property[@name='%s']", "hibernate.connection.username")).getText();
            String jdbcPassword = sessionFactoryElement.selectSingleNode(String.format("./property[@name='%s']", "hibernate.connection.password")).getText();
            Database database = DatabaseFactory.createDatabase((String)jdbcUrl, (String)jdbcUsername, (String)jdbcPassword, (Collection)DesignerServer.db_ignoreRegexs);
            database.close();
        }
        catch (Exception exception) {
            return "\u672a\u80fd\u83b7\u53d6\u5230\u6570\u636e\u5e93\u8fde\u63a5";
        }
        try {
            JDTService server = JDTHandler.getServer();
            if (server.isLayerProjectHasCompileError()) {
                return "LayerProject\u9879\u76ee\u5b58\u5728\u7f16\u8bd1\u62a5\u9519\uff0c\u6e05\u5148\u89e3\u51b3\u7f16\u8bd1\u62a5\u9519\uff0c\u518d\u8fdb\u884c\u5c42\u94fe\u5347\u7ea7";
            }
        }
        catch (Exception exception) {}
        return "";
    }

    private void buildGOTTree() {
        this.gotTree.removeAll();
        this.initGOTTree(this.newEmptyGOTElement(), null);
        this.gotTree.getItem(0).setExpanded(true);
        this.gotTree.getItem(0).getItem(0).setExpanded(true);
        List<String> pedestals = Arrays.asList("sys".toString(), "obj".toString(), "iny".toString(), "ent".toString());
        List<SolutionLayerInfo> solutions = this.layerChainConfig.getSolutions();
        List solutionIds = solutions.stream().map(s -> s.getSolutionId()).collect(Collectors.toList());
        List pluginIds = solutions.stream().flatMap(s -> s.getPluginInfos().stream()).map(p -> p.getPluginId()).collect(Collectors.toList());
        Map<EntityType, List<Element>> modifyInfos = this.analysisResult_Cache.stream().collect(Collectors.groupingBy(e -> EntityType.valueOf((String)e.getName())));
        EntityType[] entityTypeArray = EntityType.values();
        int n = entityTypeArray.length;
        int n2 = 0;
        while (n2 < n) {
            EntityType entityType = entityTypeArray[n2];
            List<Object> modifyInfo = new ArrayList();
            Collection<Object> sourceEntitys = new ArrayList();
            Map<String, GOTEntity> allEntitys = this.upgradeService.getSourceEntitys(entityType);
            if (this.layerChainConfig.isShowSame() && !this.layerChainConfig.isShowConflict() && !this.layerChainConfig.isShowPromote() && allEntitys != null) {
                sourceEntitys = allEntitys.values();
            }
            List<Object> modifyInfoList = new ArrayList();
            if (modifyInfos.containsKey(entityType)) {
                modifyInfo = modifyInfos.get(entityType);
                List entityIds = modifyInfo.stream().map(e -> e.attributeValue("id")).collect(Collectors.toList());
                sourceEntitys = sourceEntitys.stream().filter(gotNode -> !entityIds.contains(gotNode.getId())).collect(Collectors.toList());
                modifyInfoList = modifyInfo.stream().filter(m -> {
                    List elements = m.elements();
                    if (this.layerChainConfig.isShowConflict() && !elements.stream().filter(e -> ModifyLevel.Cannot.name().equals(e.attributeValue("modifyLevel"))).findFirst().isPresent()) {
                        return false;
                    }
                    if (this.layerChainConfig.isShowJavaPromote() && !elements.stream().filter(e -> ModifyType.Entity_Promote.name().equals(e.attributeValue("modifyType"))).findFirst().isPresent()) {
                        return false;
                    }
                    if (!this.layerChainConfig.isShowAdd() && elements.stream().filter(e -> ModifyType.Entity_Add.name().equals(e.attributeValue("modifyType"))).findFirst().isPresent()) {
                        return false;
                    }
                    if (!this.layerChainConfig.isShowDelete() && elements.stream().filter(e -> ModifyType.Entity_Delete.name().equals(e.attributeValue("modifyType"))).findFirst().isPresent()) {
                        return false;
                    }
                    return this.layerChainConfig.isShowDif() || elements.stream().filter(e -> ModifyType.Entity_Add.name().equals(e.attributeValue("modifyType")) || ModifyType.Entity_Delete.name().equals(e.attributeValue("modifyType"))).findFirst().isPresent();
                }).map(m -> {
                    String entityId = m.attributeValue("id");
                    GOTEntity sourceEntity = this.upgradeService.getSourceEntity(entityType, entityId);
                    if (sourceEntity != null) {
                        return sourceEntity;
                    }
                    return this.upgradeService.getTargetEntity(entityType, entityId);
                }).filter(gotNode -> {
                    boolean promote;
                    boolean bl = promote = gotNode != null && !gotNode.getModifiedLayer().equals(gotNode.getCreatedLayer());
                    return !this.layerChainConfig.isShowPromote() || promote;
                }).collect(Collectors.toList());
            }
            List gotNodes = Stream.concat(sourceEntitys.stream(), modifyInfoList.stream()).collect(Collectors.toMap(gongqi.gdt.designer.service.node.GOTNode::getId, item -> item, (existing, replacement) -> existing)).values().stream().sorted(Comparator.comparing(gongqi.gdt.designer.service.node.GOTNode::getName)).collect(Collectors.toList());
            TreeItem entitysTreeItem = this.getEntitysTreeItem(entityType);
            HashMap<String, TreeItem> idTrees = new HashMap<String, TreeItem>();
            for (GOTEntity n3 : gotNodes) {
                String entityId = n3.getId();
                if (LayerChainConfig.DisplayScope.Pedestal.equals((Object)this.layerChainConfig.getDisplayScope())) {
                    if (!pedestals.contains(n3.getModifiedLayer())) {
                        continue;
                    }
                } else if (LayerChainConfig.DisplayScope.Solution.equals((Object)this.layerChainConfig.getDisplayScope())) {
                    String id;
                    if (pedestals.contains(n3.getModifiedLayer()) || StringUtils.isBlank((String)(id = n3.getId()))) continue;
                    if (id.contains(".")) {
                        id = id.substring(0, id.lastIndexOf("."));
                    }
                    if (!solutionIds.contains(id) && !pluginIds.contains(id)) continue;
                }
                TreeItem entityTreeItem = new TreeItem(entitysTreeItem, 0);
                entityTreeItem.setText(n3.getName());
                entityTreeItem.setData("entityId", (Object)entityId);
                entityTreeItem.setImage(ComposeIMG.drawImgDef(n3));
                idTrees.put(entityId, entityTreeItem);
            }
            for (Element element : modifyInfo) {
                boolean promote;
                Object element22;
                Element result;
                Object data;
                TreeItem treeItem = (TreeItem)idTrees.get(element.attributeValue("id"));
                if (treeItem == null) continue;
                GOTEntity gotNode3 = this.upgradeService.getSourceEntity(entityType, element.attributeValue("id"));
                if (gotNode3 == null) {
                    gotNode3 = this.upgradeService.getTargetEntity(entityType, element.attributeValue("id"));
                }
                if ((data = treeItem.getData("result")) != null && data instanceof Element) {
                    result = (Element)data;
                    List elements = element.elements();
                    for (Object element22 : elements) {
                        result.add((Element)element22.clone());
                    }
                } else {
                    result = (Element)element.clone();
                    treeItem.setData("result", (Object)result);
                    ((Element)entitysTreeItem.getData()).add(result);
                }
                List elements = ((Element)treeItem.getData("result")).elements();
                element22 = elements.iterator();
                while (element22.hasNext()) {
                    Element element3 = (Element)element22.next();
                    String modifyLevel = element3.attributeValue("modifyLevel");
                    if (!ModifyLevel.Cannot.name().equals(modifyLevel)) continue;
                    treeItem.setForeground(this.shell.getDisplay().getSystemColor(3));
                    entitysTreeItem.setForeground(this.shell.getDisplay().getSystemColor(3));
                    break;
                }
                if (elements.stream().filter(e -> ModifyType.Entity_Add.name().equals(e.attributeValue("modifyType"))).findFirst().isPresent()) {
                    treeItem.setImage(addImage);
                } else if (elements.stream().filter(e -> ModifyType.Entity_Delete.name().equals(e.attributeValue("modifyType"))).findFirst().isPresent()) {
                    treeItem.setImage(deleteImage);
                } else if (elements.stream().filter(e -> ModifyType.Entity_Promote.name().equals(e.attributeValue("modifyType"))).findFirst().isPresent()) {
                    treeItem.setImage(promoteImage);
                } else {
                    treeItem.setImage(difImage);
                }
                boolean bl = promote = gotNode3 != null && !gotNode3.getModifiedLayer().equals(gotNode3.getCreatedLayer());
                if (!promote) continue;
                FontData fontData = treeItem.getFont().getFontData()[0];
                fontData.setStyle(1);
                treeItem.setFont(new Font((Device)Display.getCurrent(), fontData));
                treeItem.setData("promote", (Object)true);
            }
            ++n2;
        }
        Map<String, List<Element>> distinctByIdList = this.analysisResult_Cache.stream().collect(Collectors.groupingBy(item -> item.getName()));
        long countAll = 0L;
        long countItem = 0L;
        long countDictionaryAll = 0L;
        long countDictionaryItem = 0L;
        EntityType[] entityTypeArray2 = EntityType.values();
        int n3 = entityTypeArray2.length;
        int idTrees = 0;
        while (idTrees < n3) {
            Map<String, GOTEntity> sourceEntitys;
            EntityType entityType = entityTypeArray2[idTrees];
            TreeItem entitysTreeItem = this.getEntitysTreeItem(entityType);
            List<String> difEnityIds = new ArrayList<String>();
            if (distinctByIdList.containsKey(entityType.name())) {
                difEnityIds = distinctByIdList.get(entityType.name()).stream().map(e -> e.attributeValue("id")).collect(Collectors.toList());
            }
            if ((sourceEntitys = this.upgradeService.getSourceEntitys(entityType)) != null) {
                Set<String> sourceEnityIds = sourceEntitys.keySet();
                difEnityIds.addAll(sourceEnityIds);
            }
            long count = difEnityIds.stream().distinct().count();
            entitysTreeItem.setText(String.valueOf(entitysTreeItem.getText()) + String.format("(%d/%d)", entitysTreeItem.getItems().length, count));
            if (entityType == EntityType.Table || entityType == EntityType.DataType || entityType == EntityType.Enum) {
                countDictionaryAll += count;
                countDictionaryItem += (long)entitysTreeItem.getItems().length;
            }
            countAll += count;
            countItem += (long)entitysTreeItem.getItems().length;
            ++idTrees;
        }
        TreeItem gotTreeItem = this.gotTree.getItem(0);
        gotTreeItem.setText("GOT" + String.format("(%d/%d)", countItem, countAll));
        TreeItem dictionaryItem = gotTreeItem.getItem(0);
        dictionaryItem.setText("Dictionary" + String.format("(%d/%d)", countDictionaryItem, countDictionaryAll));
    }

    private void updateButtonStatus() {
        this.button_ExportExcel.setEnabled(!this.analysisResult_Cache.isEmpty());
        if (this.analysis_Finish) {
            this.button_Upgrade.setEnabled(true);
        } else {
            this.button_Upgrade.setEnabled(false);
        }
    }

    private boolean upgrade() {
        final Element entityModifys = (Element)this.gotTree.getItem(0).getData();
        this.upgrade_Succeed = false;
        try {
            final ProgressMonitorDialog progressMonitorDialog = new ProgressMonitorDialog(this.shell);
            progressMonitorDialog.run(true, false, new IRunnableWithProgress(){

                public void run(final IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                    Display.getDefault().syncExec(() -> progressMonitorDialog.getShell().setText("\u5c42\u94fe\u5347\u7ea7"));
                    try {
                        monitor.beginTask("\u6b63\u5728\u5907\u4efd\u9879\u76ee", 2);
                        final BackupService backupService = new BackupService();
                        backupService.backup(monitor);
                        monitor.subTask("");
                        Map<String, SolutionLayerInfo> solutionInfos = LayerChainPage.getInstance().getSolutions();
                        Map<String, PedestalLayerInfo> pedestalInfos = LayerChainPage.getInstance().getPedestals();
                        monitor.beginTask("", AnalysisResultPage.this.analysisResult_Cache.size());
                        AnalysisResultPage.this.upgradeService.modifys((Window)progressMonitorDialog, backupService.getBackupLayersRoot(), pedestalInfos, solutionInfos, entityModifys, new ProgressMonitor(){

                            @Override
                            public void worked(int work, String message) {
                                if (StringUtils.isNotBlank((String)message)) {
                                    monitor.setTaskName(message);
                                }
                                monitor.worked(1);
                            }

                            @Override
                            public void reportResult(Element entityResult) {
                            }

                            @Override
                            public void done(final Throwable e) {
                                AnalysisResultPage.this.shell.getDisplay().asyncExec(new Runnable(){

                                    @Override
                                    public void run() {
                                        if (e == null) {
                                            AnalysisResultPage.this.upgrade_Succeed = true;
                                            MessageDialog.openInformation((Shell)AnalysisResultPage.this.shell, (String)"\u63d0\u793a", (String)"\u5347\u7ea7\u5b8c\u6210");
                                        } else {
                                            boolean openConfirm = MessageDialog.openConfirm((Shell)AnalysisResultPage.this.shell, (String)"\u63d0\u793a", (String)String.format("\u5347\u7ea7\u9519\u8bef\uff1a%s \u662f\u5426\u8981\u8fd8\u539f\u9879\u76ee?", String.valueOf(ExceptionUtils.getMessage((Throwable)e)) + System.lineSeparator()));
                                            log.error((Object)"\u5347\u7ea7\u9519\u8bef", e);
                                            AnalysisResultPage.this.button_Upgrade.setEnabled(false);
                                            if (openConfirm) {
                                                ProgressMonitorDialog progressMonitorDialog = new ProgressMonitorDialog(AnalysisResultPage.this.shell);
                                                try {
                                                    progressMonitorDialog.run(true, false, new IRunnableWithProgress(){

                                                        public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                                                            monitor.beginTask("\u5347\u7ea7\u5931\u8d25\uff0c\u6b63\u5728\u8fd8\u539f...", 1);
                                                            monitor.subTask("\u3010\u6b63\u5728\u8fd8\u539f\u5c42\u6587\u4ef6...");
                                                            backupService.restore();
                                                            monitor.worked(1);
                                                            monitor.done();
                                                        }
                                                    });
                                                }
                                                catch (InterruptedException | InvocationTargetException exception) {}
                                            }
                                        }
                                    }
                                });
                            }

                            @Override
                            public void beginTask(int totalWork) {
                                monitor.beginTask("", totalWork);
                            }

                            @Override
                            public void setTaskName(String name) {
                                monitor.setTaskName(name);
                            }
                        });
                    }
                    catch (Exception e) {
                        log.error((Object)"\u5347\u7ea7\u7a0b\u5e8f\u5f02\u5e38", (Throwable)e);
                    }
                    catch (OutOfMemoryError e) {
                        log.error((Object)"\u5185\u5b58\u6ea2\u51fa", (Throwable)e);
                        AnalysisResultPage.this.upgradeService = null;
                    }
                }
            });
        }
        catch (InterruptedException | InvocationTargetException e) {
            log.error((Object)"\u5347\u7ea7\u5185\u5bb9\u5206\u6790\u7a0b\u5e8f\u5f02\u5e38", (Throwable)e);
        }
        catch (OutOfMemoryError e) {
            log.error((Object)"\u5185\u5b58\u6ea2\u51fa", (Throwable)e);
            this.upgradeService = null;
        }
        return this.upgrade_Succeed;
    }

    private TreeItem getEntitysTreeItem(EntityType entityType) {
        TreeItem gotTreeItem = this.gotTree.getItem(0);
        if (entityType == EntityType.Enum) {
            return gotTreeItem.getItem(0).getItem(0);
        }
        if (entityType == EntityType.DataType) {
            return gotTreeItem.getItem(0).getItem(1);
        }
        if (entityType == EntityType.Table) {
            return gotTreeItem.getItem(0).getItem(2);
        }
        if (entityType == EntityType.Form) {
            return gotTreeItem.getItem(3);
        }
        if (entityType == EntityType.MenuItem) {
            return gotTreeItem.getItem(2);
        }
        if (entityType == EntityType.Menu) {
            return gotTreeItem.getItem(1);
        }
        if (entityType == EntityType.Class) {
            return gotTreeItem.getItem(5);
        }
        if (entityType == EntityType.Report) {
            return gotTreeItem.getItem(4);
        }
        throw new RuntimeException(String.format("%s\u7c7b\u578b\u8282\u70b9\u4e0d\u652f\u6301\u5347\u7ea7", entityType.name()));
    }

    private Element newEmptyGOTElement() {
        try {
            String emptyGOTText = "<GOT><DataDictionary><Enums/><DataTypes/><Tables/></DataDictionary><Menus/><MenuItems/><Forms/><Reports/><Classes/></GOT>";
            return DocumentHelper.parseText((String)emptyGOTText).getRootElement();
        }
        catch (DocumentException e) {
            throw new RuntimeException("\u6784\u9020Empty GOT\u6811\u8282\u70b9\u9519\u8bef", e);
        }
    }

    /*
     * Loose catch block
     */
    protected boolean checkTomcatOccupy() throws FileNotFoundException {
        Socket socket;
        block14: {
            File basePath = ProjectConstants.getBasePath();
            File envConf = new File(basePath, "Conf/environment.cfg");
            if (!envConf.exists()) {
                throw new FileNotFoundException(String.format("\u672a\u627e\u5230\u73af\u5883\u914d\u7f6e\u6587\u4ef6\u3010%s\u3011", envConf.getAbsolutePath()));
            }
            String port = "";
            try {
                port = String.valueOf(FileUtils.readFileToDocument((File)envConf).getRootElement().selectSingleNode("./Property[@name = 'PortPrefix']").getText()) + "2";
            }
            catch (Exception exception) {
                throw new ERPException(String.format("\u89e3\u6790\u73af\u5883\u914d\u7f6e\u6587\u4ef6\u3010%s\u3011\u5f02\u5e38", envConf.getAbsolutePath()));
            }
            int tomcatPort = Integer.parseInt(port);
            socket = null;
            socket = new Socket("127.0.0.1", tomcatPort);
            if (socket == null) break block14;
            try {
                socket.close();
            }
            catch (IOException iOException) {}
        }
        return true;
        catch (Exception exception) {
            block15: {
                try {
                    if (socket == null) break block15;
                }
                catch (Throwable throwable) {
                    if (socket != null) {
                        try {
                            socket.close();
                        }
                        catch (IOException iOException) {}
                    }
                    throw throwable;
                }
                try {
                    socket.close();
                }
                catch (IOException iOException) {}
            }
            return false;
        }
    }

    private void exportResultAsExcel(String path) throws IOException {
        File file = new File(path);
        FileOutputStream outputStream = new FileOutputStream(file);
        HSSFWorkbook workbook = new HSSFWorkbook();
        try {
            HSSFFont font = workbook.getFontAt((short)0);
            font.setFontName("\u5fae\u8f6f\u96c5\u9ed1");
            HSSFSheet sheet = workbook.createSheet("\u5185\u5bb9\u5206\u6790");
            sheet.setDefaultRowHeight((short)400);
            HSSFCellStyle cellStyle = workbook.createCellStyle();
            cellStyle.setAlignment((short)2);
            cellStyle.setVerticalAlignment((short)1);
            cellStyle.setBorderBottom((short)1);
            cellStyle.setBorderLeft((short)1);
            cellStyle.setBorderTop((short)1);
            cellStyle.setBorderRight((short)1);
            HSSFCellStyle cellLeft = workbook.createCellStyle();
            cellLeft.setAlignment((short)1);
            cellLeft.setVerticalAlignment((short)1);
            cellLeft.setBorderBottom((short)1);
            cellLeft.setBorderLeft((short)1);
            cellLeft.setBorderTop((short)1);
            cellLeft.setBorderRight((short)1);
            HSSFCellStyle cellHead = workbook.createCellStyle();
            cellHead.setAlignment((short)2);
            cellHead.setVerticalAlignment((short)1);
            cellHead.setFillForegroundColor(IndexedColors.GREY_25_PERCENT.getIndex());
            cellHead.setFillPattern((short)1);
            cellHead.setBorderBottom((short)1);
            cellHead.setBorderLeft((short)1);
            cellHead.setBorderTop((short)1);
            cellHead.setBorderRight((short)1);
            sheet.setColumnWidth(0, 3072);
            sheet.setColumnWidth(1, 7680);
            sheet.setColumnWidth(2, 3072);
            sheet.setColumnWidth(3, 38400);
            sheet.createFreezePane(0, 1, 0, 1);
            HSSFRow row = sheet.createRow(0);
            row.createCell(0).setCellValue("\u8282\u70b9\u7c7b\u578b");
            row.createCell(1).setCellValue("\u8282\u70b9\u540d\u79f0");
            row.createCell(2).setCellValue("\u7c7b\u578b");
            row.createCell(3).setCellValue("\u5185\u5bb9\u63cf\u8ff0");
            row.getCell(0).setCellStyle(cellHead);
            row.getCell(1).setCellStyle(cellHead);
            row.getCell(2).setCellStyle(cellHead);
            row.getCell(3).setCellStyle(cellHead);
            int line = 1;
            TreeItem treeItem = this.gotTree.getItem(0);
            if (this.gotTree.getSelectionCount() > 0) {
                treeItem = this.gotTree.getSelection()[0];
            }
            this.buildExcelLine(treeItem, sheet, line, cellStyle, cellLeft);
            workbook.setActiveSheet(0);
            workbook.write((OutputStream)outputStream);
        }
        finally {
            workbook.close();
            ((OutputStream)outputStream).close();
        }
    }

    private int buildExcelLine(TreeItem treeItem, HSSFSheet sheet, int line, HSSFCellStyle cellStyle, HSSFCellStyle cellLeft) {
        int start = line;
        if (treeItem.getItemCount() > 0) {
            TreeItem[] treeItemArray = treeItem.getItems();
            int n = treeItemArray.length;
            int n2 = 0;
            while (n2 < n) {
                TreeItem childItem = treeItemArray[n2];
                line = this.buildExcelLine(childItem, sheet, line, cellStyle, cellLeft);
                ++n2;
            }
            if (line - start > 1) {
                CellRangeAddress address = new CellRangeAddress(start, line - 1, 0, 0);
                sheet.addMergedRegion(address);
            }
        } else {
            String entityId = (String)treeItem.getData("entityId");
            if (StringUtils.isBlank((String)entityId)) {
                return line;
            }
            Element result = (Element)treeItem.getData("result");
            List itemElements = result.elements();
            String entityTypes = treeItem.getParentItem().getText();
            if (entityTypes.contains("(")) {
                entityTypes = entityTypes.substring(0, entityTypes.indexOf("("));
            }
            for (Element itemElement : itemElements) {
                HSSFRow row = sheet.createRow(line++);
                row.createCell(0).setCellStyle(cellStyle);
                row.createCell(1).setCellStyle(cellStyle);
                row.createCell(2).setCellStyle(cellStyle);
                row.createCell(3).setCellStyle(cellLeft);
                row.getCell(0).setCellValue(entityTypes);
                row.getCell(1).setCellValue(treeItem.getText());
                String modifyType = ModifyType.valueOf(itemElement.attributeValue("modifyType")).getLabel();
                String description = itemElement.attributeValue("description");
                row.getCell(2).setCellValue(modifyType);
                row.getCell(3).setCellValue(description);
            }
            if (itemElements.size() > 1) {
                CellRangeAddress address = new CellRangeAddress(line - itemElements.size(), line - 1, 1, 1);
                sheet.addMergedRegion(address);
            }
        }
        return line;
    }

    private void resetView() {
        this.compareTree.removeAll();
        this.tipInfo.setText("");
        this.propertyInfoTree.removeAll();
        this.javaMethodTree.removeAll();
        this.javaCodeText.setDocument((IDocument)new Document(""));
        this.compareViewerPane.setInput(null);
    }

    static /* synthetic */ String access$55(AnalysisResultPage analysisResultPage) {
        return analysisResultPage.checkEnvironment();
    }

    private static enum DisplayType {
        Add,
        Dif,
        Delete,
        Same;

    }
}

