/*
 * Decompiled with CFR 0.152.
 */
package gongqi.gdt.designer.ui;

import gongqi.gdt.designer.utils.SWTUtils;
import info.gongqi.got.util.ComposeIMG;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.eclipse.jface.window.Window;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;

public class DatabaseDifDialog {
    private Shell shell;
    private Shell parentShell;
    private Tree tree;
    private Map<String, List<Map<String, Object>>> tables;

    public DatabaseDifDialog(Window parentWindow, List<Map<String, Object>> errorInfos) {
        this.parentShell = parentWindow.getShell();
        this.tables = errorInfos.stream().filter(e -> e != null && e.get("tableName") != null).collect(Collectors.groupingBy(e -> (String)e.get("tableName")));
    }

    private void createContent() {
        Display.getCurrent();
        this.shell = new Shell(this.parentShell, 208);
        this.shell.setText("\u6570\u636e\u7ed3\u6784\u5dee\u5f02");
        this.shell.setLayout((Layout)new FormLayout());
        this.shell.setSize(SWTUtils.zoom(700), SWTUtils.zoom(400));
        Rectangle bounds = Display.getDefault().getPrimaryMonitor().getBounds();
        Rectangle rect = this.shell.getBounds();
        int x = bounds.x + (bounds.width - rect.width) / 2;
        int y = bounds.y + (bounds.height - rect.height) / 2;
        this.shell.setLocation(x, y);
        SashForm mainComposite = new SashForm((Composite)this.shell, 256);
        FormData formData = new FormData();
        formData.left = new FormAttachment(0, 5);
        formData.right = new FormAttachment(100, -5);
        formData.bottom = new FormAttachment(100, -5);
        formData.top = new FormAttachment(0, 5);
        mainComposite.setLayoutData((Object)formData);
        mainComposite.setLayout((Layout)new FormLayout());
        this.tree = new Tree((Composite)mainComposite, 2050);
        TreeItem rootDatabase = new TreeItem(this.tree, 0);
        rootDatabase.setText("\u6570\u636e\u5e93\u7ed3\u6784\u9519\u8bef");
        rootDatabase.setImage(ComposeIMG.drawImgDef("DbGOTDiff"));
        Font font = new Font((Device)Display.getCurrent(), "Consolas", 10, 1);
        final Table detailTable = new Table((Composite)mainComposite, 67588);
        detailTable.setHeaderVisible(true);
        detailTable.setLinesVisible(true);
        TableColumn descriptionColumn = new TableColumn(detailTable, 16384, 0);
        descriptionColumn.setText("\u63cf\u8ff0");
        descriptionColumn.setWidth(SWTUtils.zoom(450));
        for (String tableId : this.tables.keySet()) {
            TreeItem treeItem = new TreeItem(rootDatabase, 0);
            treeItem.setText(tableId);
            treeItem.setFont(font);
            if (this.tables.get(tableId).get(0).get("tableId") == null) {
                treeItem.setImage(ComposeIMG.drawImgDef("DeleteDB"));
                continue;
            }
            treeItem.setImage(ComposeIMG.drawImgDef("Synchro"));
        }
        rootDatabase.setExpanded(true);
        this.tree.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                detailTable.removeAll();
                TreeItem select = DatabaseDifDialog.this.tree.getSelection()[0];
                if (!DatabaseDifDialog.this.tables.containsKey(select.getText())) {
                    return;
                }
                List errorInfos = (List)DatabaseDifDialog.this.tables.get(select.getText());
                for (Map map : errorInfos) {
                    TableItem rowItem = new TableItem(detailTable, 0);
                    rowItem.setText(0, (String)map.get("description"));
                }
            }
        });
    }

    public void open() {
        this.createContent();
        this.shell.open();
        Display display = this.shell.getDisplay();
        while (!this.shell.isDisposed()) {
            if (display.readAndDispatch()) continue;
            display.sleep();
        }
    }
}

