/*
 * Decompiled with CFR 0.152.
 */
package gongqi.gdt.designer.ui;

import com.alibaba.fastjson.JSONObject;
import gongqi.gdt.designer.ui.LayerChainPage;
import gongqi.gdt.designer.ui.MarketOnlineVersion;
import gongqi.gdt.designer.utils.PedestalLayerInfo;
import gongqi.gdt.designer.utils.SWTUtils;
import gongqi.gdt.designer.utils.SolutionLayerInfo;
import gongqi.gdt.designer.utils.SolutionPluginInfo;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeColumn;
import org.eclipse.swt.widgets.TreeItem;

public class DependVersionDialog {
    private Shell shell;
    private Tree infoTree;

    public DependVersionDialog(SolutionLayerInfo solutionLayerInfo) {
        this.createContent();
        JSONObject targetInfo = StringUtils.isNotBlank((String)solutionLayerInfo.getTargetVersion()) ? MarketOnlineVersion.getSolutionVersionInfo(solutionLayerInfo, solutionLayerInfo.getTargetVersion()) : null;
        String sysVersion = "";
        String objVersion = "";
        String inyVersion = "";
        String entVersion = "";
        if (targetInfo != null) {
            sysVersion = targetInfo.getString("sysVersion");
            objVersion = targetInfo.getString("objVersion");
            inyVersion = targetInfo.getString("inyVersion");
            entVersion = targetInfo.getString("entVersion");
        }
        this.shell.setText(String.format("\u3010%s\u3011\u7248\u672c\u4f9d\u8d56", solutionLayerInfo.getSolutionName()));
        Map<String, PedestalLayerInfo> pedestals = LayerChainPage.getInstance().getPedestals();
        TreeItem sys = new TreeItem(this.infoTree, 0);
        PedestalLayerInfo pedestalLayerInfo = pedestals.get("sys");
        sys.setText(new String[]{"sys(\u7cfb\u7edf\u5c42)", pedestalLayerInfo.getCurrentVersion(), sysVersion});
        TreeItem obj = new TreeItem(this.infoTree, 0);
        pedestalLayerInfo = pedestals.get("obj");
        obj.setText(new String[]{"obj(\u5bf9\u8c61\u5c42)", pedestalLayerInfo.getCurrentVersion(), objVersion});
        TreeItem iny = new TreeItem(this.infoTree, 0);
        pedestalLayerInfo = pedestals.get("iny");
        iny.setText(new String[]{"iny(\u884c\u4e1a\u5c42)", pedestalLayerInfo.getCurrentVersion(), inyVersion});
        TreeItem ent = new TreeItem(this.infoTree, 0);
        pedestalLayerInfo = pedestals.get("ent");
        ent.setText(new String[]{"ent(\u4f01\u4e1a\u5c42)", pedestalLayerInfo.getCurrentVersion(), entVersion});
        this.compare();
    }

    public DependVersionDialog(SolutionPluginInfo pluginInfo) {
        this.createContent();
        this.shell.setText(String.format("\u3010%s\u3011\u7248\u672c\u4f9d\u8d56", pluginInfo.getPluginName()));
        JSONObject targetInfo = StringUtils.isNotBlank((String)pluginInfo.getTargetVersion()) ? MarketOnlineVersion.getPluginVersionInfo(pluginInfo, pluginInfo.getTargetVersion()) : null;
        String sysVersion = "";
        String objVersion = "";
        String inyVersion = "";
        String entVersion = "";
        String appVersion = "";
        String frameworkVersion = "";
        if (targetInfo != null) {
            sysVersion = targetInfo.getString("sysVersion");
            objVersion = targetInfo.getString("objVersion");
            inyVersion = targetInfo.getString("inyVersion");
            entVersion = targetInfo.getString("entVersion");
            appVersion = targetInfo.getString("appVersion");
            frameworkVersion = targetInfo.getString("frameworkVersion");
        }
        Map<String, PedestalLayerInfo> pedestals = LayerChainPage.getInstance().getPedestals();
        TreeItem sys = new TreeItem(this.infoTree, 0);
        PedestalLayerInfo pedestalLayerInfo = pedestals.get("sys");
        sys.setText(new String[]{"sys(\u7cfb\u7edf\u5c42)", pedestalLayerInfo.getCurrentVersion(), sysVersion});
        TreeItem obj = new TreeItem(this.infoTree, 0);
        pedestalLayerInfo = pedestals.get("obj");
        obj.setText(new String[]{"obj(\u5bf9\u8c61\u5c42)", pedestalLayerInfo.getCurrentVersion(), objVersion});
        TreeItem iny = new TreeItem(this.infoTree, 0);
        pedestalLayerInfo = pedestals.get("iny");
        iny.setText(new String[]{"iny(\u884c\u4e1a\u5c42)", pedestalLayerInfo.getCurrentVersion(), inyVersion});
        TreeItem ent = new TreeItem(this.infoTree, 0);
        pedestalLayerInfo = pedestals.get("ent");
        ent.setText(new String[]{"ent(\u4f01\u4e1a\u5c42)", pedestalLayerInfo.getCurrentVersion(), entVersion});
        TreeItem app = new TreeItem(this.infoTree, 0);
        pedestalLayerInfo = pedestals.get("ent");
        app.setText(new String[]{"app(\u5e94\u7528)", pluginInfo.getSolutionLayerInfo().getCurrentVersion(), appVersion});
        TreeItem framework = new TreeItem(this.infoTree, 0);
        pedestalLayerInfo = pedestals.get("ent");
        framework.setText(new String[]{"framework", pluginInfo.getSolutionLayerInfo().getFrameworkVersion(), frameworkVersion});
        this.compare();
    }

    private void compare() {
        TreeItem[] items;
        Color blue = this.shell.getDisplay().getSystemColor(9);
        TreeItem[] treeItemArray = items = this.infoTree.getItems();
        int n = items.length;
        int n2 = 0;
        while (n2 < n) {
            TreeItem treeItem = treeItemArray[n2];
            if (!treeItem.getText(1).equals(treeItem.getText(2))) {
                treeItem.setForeground(blue);
            }
            ++n2;
        }
    }

    private void createContent() {
        Display display = Display.getCurrent();
        this.shell = new Shell(display.getActiveShell(), 208);
        this.shell.setLayout((Layout)new FormLayout());
        this.shell.setSize(SWTUtils.zoom(390), SWTUtils.zoom(250));
        Rectangle bounds = Display.getDefault().getPrimaryMonitor().getBounds();
        Rectangle rect = this.shell.getBounds();
        int x = bounds.x + (bounds.width - rect.width) / 2;
        int y = bounds.y + (bounds.height - rect.height) / 2;
        this.shell.setLocation(x, y);
        Font font = new Font((Device)Display.getCurrent(), "\u5fae\u8f6f\u96c5\u9ed1", 10, 0);
        this.infoTree = new Tree((Composite)this.shell, 67842);
        FormData formData = new FormData();
        formData.left = new FormAttachment(0, 5);
        formData.right = new FormAttachment(100, -5);
        formData.top = new FormAttachment(0, 5);
        formData.bottom = new FormAttachment(100, -5);
        this.infoTree.setLayoutData((Object)formData);
        this.infoTree.setHeaderVisible(true);
        this.infoTree.setLinesVisible(true);
        this.infoTree.setFont(font);
        TreeColumn propertyColumn = new TreeColumn(this.infoTree, 16384, 0);
        propertyColumn.setText("");
        propertyColumn.setWidth(SWTUtils.zoom(120));
        TreeColumn UpgradeBefore = new TreeColumn(this.infoTree, 0x1000000, 1);
        UpgradeBefore.setText("\u5f53\u524d\u7248\u672c");
        UpgradeBefore.setWidth(SWTUtils.zoom(120));
        TreeColumn UpgradeAfter = new TreeColumn(this.infoTree, 0x1000000, 2);
        UpgradeAfter.setText("\u5347\u7ea7\u7248\u672c");
        UpgradeAfter.setWidth(SWTUtils.zoom(120));
    }

    public void open() {
        this.shell.open();
        Display display = this.shell.getDisplay();
        while (!this.shell.isDisposed()) {
            if (display.readAndDispatch()) continue;
            display.sleep();
        }
    }
}

