/*
 * Decompiled with CFR 0.152.
 */
package gongqi.gdt.designer.ui;

import gongqi.gdt.designer.utils.LayerChainConfig;
import gongqi.gdt.designer.utils.SWTUtils;
import gongqi.gdt.designer.utils.SolutionLayerInfo;
import java.util.ArrayList;
import java.util.Map;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableItem;

public class LayerChainFilter {
    private LayerChainConfig config;
    private Map<String, SolutionLayerInfo> map;
    private Table solutionTable;
    private Shell shell;

    public LayerChainFilter(LayerChainConfig layerChainConfig) {
        this.config = layerChainConfig;
    }

    public LayerChainFilter(Map<String, SolutionLayerInfo> map, LayerChainConfig layerChainConfig) {
        this.config = layerChainConfig;
        this.map = map;
    }

    private void createContent() {
        Display display = Display.getCurrent();
        this.shell = new Shell(display.getActiveShell(), 208);
        this.shell.setText("\u7b5b\u9009");
        this.shell.setLayout((Layout)new FormLayout());
        this.shell.setSize(SWTUtils.zoom(400), SWTUtils.zoom(400));
        Rectangle bounds = Display.getDefault().getPrimaryMonitor().getBounds();
        Rectangle rect = this.shell.getBounds();
        int x = bounds.x + (bounds.width - rect.width) / 2;
        int y = bounds.y + (bounds.height - rect.height) / 2;
        this.shell.setLocation(x, y);
        Group displayGroup = new Group((Composite)this.shell, 0);
        displayGroup.setText("\u663e\u793a\u8282\u70b9");
        GridLayout layout = new GridLayout(4, true);
        layout.horizontalSpacing = SWTUtils.zoom(40);
        displayGroup.setLayout((Layout)layout);
        FormData formData = new FormData();
        formData.top = new FormAttachment(0, SWTUtils.zoom(10));
        formData.left = new FormAttachment(3, 0);
        formData.right = new FormAttachment(97, 0);
        displayGroup.setLayoutData((Object)formData);
        final Button showAdd = new Button((Composite)displayGroup, 32);
        showAdd.setText("\u65b0\u589e");
        showAdd.setSelection(this.config.isShowAdd());
        final Button showDelete = new Button((Composite)displayGroup, 32);
        showDelete.setText("\u5220\u9664");
        showDelete.setSelection(this.config.isShowDelete());
        final Button showDif = new Button((Composite)displayGroup, 32);
        showDif.setText("\u4fee\u6539");
        showDif.setSelection(this.config.isShowDif());
        final Button showSame = new Button((Composite)displayGroup, 32);
        showSame.setText("\u672a\u4fee\u6539");
        showSame.setSelection(this.config.isShowSame());
        Group filterGroup = new Group((Composite)this.shell, 0);
        filterGroup.setText("\u8fc7\u6ee4\u8282\u70b9");
        GridLayout layout2 = new GridLayout(3, true);
        filterGroup.setLayout((Layout)layout2);
        final Button showConflict = new Button((Composite)filterGroup, 32);
        showConflict.setText("\u4ec5\u663e\u793a\u51b2\u7a81");
        showConflict.setSelection(this.config.isShowConflict());
        final Button showPromote = new Button((Composite)filterGroup, 32);
        showPromote.setText("\u4ec5\u663e\u793a\u63d0\u5347");
        showPromote.setSelection(this.config.isShowPromote());
        final Button showJavaPromote = new Button((Composite)filterGroup, 32);
        showJavaPromote.setText("\u4ec5\u663e\u793a\u4ee3\u7801\u63d0\u5347");
        showJavaPromote.setSelection(this.config.isShowJavaPromote());
        formData = new FormData();
        formData.top = new FormAttachment((Control)displayGroup, SWTUtils.zoom(10), 1024);
        formData.left = new FormAttachment((Control)displayGroup, 0, 16384);
        formData.right = new FormAttachment((Control)displayGroup, 0, 131072);
        filterGroup.setLayoutData((Object)formData);
        Group scopeGroup = new Group((Composite)this.shell, 0);
        scopeGroup.setText("\u663e\u793a\u8303\u56f4");
        scopeGroup.setLayout((Layout)layout);
        final Button showAll = new Button((Composite)scopeGroup, 16400);
        showAll.setText("\u663e\u793a\u6240\u6709");
        final Button showPedestal = new Button((Composite)scopeGroup, 16400);
        showPedestal.setText("\u4ec5\u663e\u793a\u5e95\u5ea7");
        final Button showSolution = new Button((Composite)scopeGroup, 131088);
        showSolution.setText("\u4ec5\u663e\u793a\u5e94\u7528");
        SelectionAdapter scopeListener = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                LayerChainFilter.this.solutionTable.setEnabled(showSolution.getSelection());
            }
        };
        showAll.addSelectionListener((SelectionListener)scopeListener);
        showPedestal.addSelectionListener((SelectionListener)scopeListener);
        showSolution.addSelectionListener((SelectionListener)scopeListener);
        formData = new FormData();
        formData.top = new FormAttachment((Control)filterGroup, SWTUtils.zoom(10), 1024);
        formData.left = new FormAttachment((Control)filterGroup, 0, 16384);
        formData.right = new FormAttachment((Control)filterGroup, 0, 131072);
        scopeGroup.setLayoutData((Object)formData);
        this.solutionTable = new Table((Composite)this.shell, 67620);
        formData = new FormData();
        formData.left = new FormAttachment((Control)scopeGroup, 0, 16384);
        formData.right = new FormAttachment((Control)scopeGroup, SWTUtils.zoom(-5), 131072);
        formData.top = new FormAttachment((Control)scopeGroup, SWTUtils.zoom(10), 1024);
        formData.bottom = new FormAttachment(85);
        this.solutionTable.setLayoutData((Object)formData);
        this.solutionTable.setEnabled(false);
        this.solutionTable.setHeaderVisible(false);
        this.solutionTable.setLinesVisible(false);
        Button confirm = new Button((Composite)this.shell, 8);
        confirm.setText("\u786e\u8ba4");
        formData = new FormData(SWTUtils.zoom(60), SWTUtils.zoom(30));
        formData.bottom = new FormAttachment(100, SWTUtils.zoom(-10));
        formData.right = new FormAttachment((Control)displayGroup, SWTUtils.zoom(-4), 131072);
        confirm.setLayoutData((Object)formData);
        confirm.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                LayerChainFilter.this.config.setShowAdd(showAdd.getSelection());
                LayerChainFilter.this.config.setShowDelete(showDelete.getSelection());
                LayerChainFilter.this.config.setShowDif(showDif.getSelection());
                LayerChainFilter.this.config.setShowSame(showSame.getSelection());
                LayerChainFilter.this.config.setShowConflict(showConflict.getSelection());
                LayerChainFilter.this.config.setShowPromote(showPromote.getSelection());
                LayerChainFilter.this.config.setShowJavaPromote(showJavaPromote.getSelection());
                if (showAll.getSelection()) {
                    LayerChainFilter.this.config.setDisplayScope(LayerChainConfig.DisplayScope.All);
                } else if (showPedestal.getSelection()) {
                    LayerChainFilter.this.config.setDisplayScope(LayerChainConfig.DisplayScope.Pedestal);
                } else if (showSolution.getSelection()) {
                    LayerChainFilter.this.config.setDisplayScope(LayerChainConfig.DisplayScope.Solution);
                }
                ArrayList<SolutionLayerInfo> solutionLayerInfos = new ArrayList<SolutionLayerInfo>();
                TableItem[] tableItemArray = LayerChainFilter.this.solutionTable.getItems();
                int n = tableItemArray.length;
                int n2 = 0;
                while (n2 < n) {
                    SolutionLayerInfo solutionLayerInfo;
                    TableItem tableItem = tableItemArray[n2];
                    if (tableItem.getChecked() && (solutionLayerInfo = (SolutionLayerInfo)LayerChainFilter.this.map.get(tableItem.getText())) != null) {
                        solutionLayerInfos.add(solutionLayerInfo);
                    }
                    ++n2;
                }
                LayerChainFilter.this.config.setSolutions(solutionLayerInfos);
                LayerChainFilter.this.shell.close();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        Button cancel = new Button((Composite)this.shell, 8);
        cancel.setText("\u53d6\u6d88");
        formData = new FormData(SWTUtils.zoom(60), SWTUtils.zoom(30));
        formData.bottom = new FormAttachment((Control)confirm, 0, 1024);
        formData.right = new FormAttachment((Control)confirm, SWTUtils.zoom(-10), 16384);
        cancel.setLayoutData((Object)formData);
        cancel.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                LayerChainFilter.this.shell.close();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        if (this.config.getDisplayScope().equals((Object)LayerChainConfig.DisplayScope.All)) {
            showAll.setSelection(true);
        } else if (this.config.getDisplayScope().equals((Object)LayerChainConfig.DisplayScope.Pedestal)) {
            showPedestal.setSelection(true);
        } else if (this.config.getDisplayScope().equals((Object)LayerChainConfig.DisplayScope.Solution)) {
            showSolution.setSelection(true);
            this.solutionTable.setEnabled(true);
        }
        this.buildTree();
    }

    private void buildTree() {
        this.solutionTable.removeAll();
        for (String solutionId : this.map.keySet()) {
            TableItem tableItem = new TableItem(this.solutionTable, 0);
            tableItem.setText(solutionId);
            tableItem.setChecked(this.config.isFilterSolution(solutionId));
        }
    }

    public void show() {
        this.createContent();
        this.shell.open();
        Display display = this.shell.getDisplay();
        while (!this.shell.isDisposed()) {
            if (display.readAndDispatch()) continue;
            display.sleep();
        }
    }
}

