/*
 * Decompiled with CFR 0.152.
 */
package info.gongqi.got.tool;

import com.ximpleware.NavException;
import com.ximpleware.VTDException;
import gongqi.designer.got.vtd.EntityNode;
import gongqi.designer.got.vtd.GOTNode;
import gongqi.designer.got.vtd.NodeProperty;
import gongqi.designer.services.LayerService;
import gongqi.erp.framework.core.ObjectContainer;
import gongqi.erp.gotmodel.core.EntityType;
import gongqi.erp.gotmodel.util.GOTDom4jUtils;
import gongqi.gdt.designer.core.got.node.Entity;
import gongqi.gdt.designer.core.got.node.NodeFactory;
import gongqi.gdt.designer.core.got.node.NodeGOT;
import gongqi.gdt.designer.core.resolvergot.ResolverNode;
import gongqi.gdt.designer.core.resolvergot.ResolverNodeFactory;
import gongqi.gdt.designer.core.toolsgot.GOTHelper;
import gongqi.gdt.designer.core.toolsgot.GOTXMLHelper;
import gongqi.gdt.designer.core.toolsgot.Macros;
import gongqi.gdt.designer.handler.JDTHandler;
import info.gongqi.got.model.GotXmlDto;
import info.gongqi.got.tool.FormDataSyn;
import info.gongqi.got.tool.GOTHelp;
import info.gongqi.got.ui.LoadXmlCore;
import info.gongqi.got.util.GOTMessageDialog;
import info.gongqi.got.util.TreeUIUtil;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.dom4j.Element;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Dialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Monitor;
import org.eclipse.swt.widgets.ProgressBar;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;

public class MergeCleanAllTable
extends Dialog {
    protected Object resultDialog = "";
    protected Shell shell;
    public ProgressBar progressBar;
    private Boolean canceled = false;
    private List<EntityNode> xmllist = new ArrayList<EntityNode>();

    public MergeCleanAllTable(Shell parent, int style) {
        super(parent, style);
        this.setText("\u6b63\u5728\u9a8c\u8bc1");
    }

    public Object open(boolean all) {
        this.createContents(all);
        this.shell.open();
        this.shell.layout();
        Display display = this.getParent().getDisplay();
        while (!this.shell.isDisposed()) {
            if (display.readAndDispatch()) continue;
            display.sleep();
        }
        return this.resultDialog;
    }

    private void createContents(boolean all) {
        this.shell = new Shell(this.getParent(), this.getStyle());
        this.shell.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent arg0) {
                MergeCleanAllTable.this.canceled = true;
            }
        });
        this.shell.setSize(600, 50);
        this.shell.setText(this.getText());
        this.shell.setLayout((Layout)new FillLayout(256));
        Monitor monitor = this.shell.getMonitor();
        Rectangle bounds = monitor.getBounds();
        Rectangle rect = this.shell.getBounds();
        int x = bounds.x + (bounds.width - rect.width) / 2;
        int y = bounds.y + (bounds.height - rect.height) / 2;
        this.shell.setLocation(x, y);
        this.progressBar = new ProgressBar((Composite)this.shell, 65536);
        this.progressBar.setMaximum(100);
        this.progressBar.setMinimum(0);
        if (all) {
            this.xmllist = GotXmlDto.getInstance().getEntityList(EntityType.Table);
        } else {
            TreeItem[] items;
            Tree tree = FormDataSyn.currentTreeUi.getTree();
            TreeItem[] treeItemArray = items = tree.getSelection();
            int n = items.length;
            int n2 = 0;
            while (n2 < n) {
                TreeItem treeItem = treeItemArray[n2];
                GOTNode element = TreeUIUtil.getCurrentElement2(treeItem);
                if (element != null && element.getNodeType().equals("Table")) {
                    this.xmllist.add(element.getEntity());
                }
                ++n2;
            }
        }
        int total = this.xmllist.size();
        if (total > 0) {
            this.start(0, total, this.xmllist, "");
        } else {
            this.shell.setText("\u6ca1\u6709\u9700\u8981\u6e05\u7406\u7684table");
        }
    }

    public void start(final int i, final int total, final List<EntityNode> xmllist, final String result) {
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                MergeCleanAllTable.this.stepCheckTables(i, total, xmllist, result);
                Display.getDefault().syncExec(new Runnable(){

                    @Override
                    public void run() {
                        if ((this).MergeCleanAllTable.this.shell.isDisposed()) {
                            return;
                        }
                    }
                });
            }
        };
        new Thread(runnable).start();
    }

    public void stepCheckTables(int cur, int total, List<EntityNode> xmllist, String result) {
        EntityNode table = xmllist.get(cur);
        int percent = ++cur * 100 / total;
        this.setShellText("\u6b63\u5728\u534f\u540c" + table.getName() + " " + percent + "%");
        this.setProgressBar(percent);
        result = String.valueOf(result) + this.checkSingleTable(table);
        if (this.canceled.booleanValue() || cur >= total) {
            this.setProgressBar(100);
            if (result.equals("")) {
                result = "\u5df2\u81ea\u52a8\u5904\u7406\uff0c\u65e0\u9700\u624b\u52a8\u8c03\u6574";
            }
            String _title = "\u68c0\u67e5\u7ed3\u679c";
            if (this.canceled.booleanValue() && cur < total) {
                _title = String.valueOf(_title) + "(\u5df2\u4e2d\u65ad)";
            }
            this.canceled = false;
            this.setAlert(result, _title);
        } else {
            try {
                Thread.sleep(50L);
            }
            catch (InterruptedException e) {
                Logger.getLogger(((Object)((Object)this)).getClass()).error((Object)e);
            }
            this.stepCheckTables(cur, total, xmllist, result);
        }
    }

    public void setProgressBar(final int num) {
        Display.getDefault().asyncExec(new Runnable(){

            @Override
            public void run() {
                if (MergeCleanAllTable.this.progressBar.isDisposed()) {
                    return;
                }
                if (num == 100) {
                    MergeCleanAllTable.this.shell.close();
                } else {
                    MergeCleanAllTable.this.progressBar.setSelection(num);
                }
            }
        });
    }

    public void setShellText(final String text) {
        Display.getDefault().asyncExec(new Runnable(){

            @Override
            public void run() {
                if (MergeCleanAllTable.this.shell.isDisposed()) {
                    return;
                }
                MergeCleanAllTable.this.shell.setText(text);
            }
        });
    }

    public void setAlert(final String text, final String title) {
        Display.getDefault().asyncExec(new Runnable(){

            @Override
            public void run() {
                GOTMessageDialog.showXmlInfo(text, title);
            }
        });
    }

    public String checkSingleTable(final EntityNode table) {
        String result = "";
        String tableId = table.getId();
        List<EntityNode> forms = GotXmlDto.getInstance().getEntityList(EntityType.Form);
        try {
            for (EntityNode form : forms) {
                List dses = form.selectNodes(String.format("./FormDataSources/FormDataSource[Properties/Property[@refentityid='%s']/Name[text()='Table']]", tableId));
                if (dses.isEmpty()) continue;
                String currentLayer = ((LayerService)ObjectContainer.getInstance(LayerService.class)).getCurrentLayer();
                if (!form.getModifiedLayer().equals(currentLayer)) {
                    Element xml = form.toElement();
                    NodeGOT node = NodeFactory.getNode(xml);
                    Entity entity = (Entity)node;
                    String info = entity.validateBeforePromote();
                    if (!info.equals(Macros.INFO_TRUE) || !NodeGOT.canPromote(xml).booleanValue()) continue;
                    String promoteResult = "";
                    try {
                        promoteResult = LoadXmlCore.gotServices.promoteEntity(xml.asXML());
                    }
                    catch (Exception e) {
                        Logger.getLogger(((Object)((Object)this)).getClass()).error((Object)"", (Throwable)e);
                        continue;
                    }
                    this.rpc_result_Save(promoteResult, info, entity, "promote");
                    form = GotXmlDto.getInstance().getEntityById(form.getId());
                    dses = form.selectNodes(String.format("./FormDataSources/FormDataSource[Properties/Property[@refentityid='%s']/Name[text()='Table']]", tableId));
                }
                final List ds_finals = dses;
                Display.getDefault().asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        for (GOTNode ds : ds_finals) {
                            EntityNode entity = GotXmlDto.getInstance().getEntityById(ds.getEntity().getId());
                            try {
                                GOTNode node = entity.selectSingleNode(ds.getEntityXPath());
                                if (MergeCleanAllTable.this.isTableDsDif(node, table).booleanValue()) continue;
                                MergeCleanAllTable.this.adjustDSByTable(node, table);
                            }
                            catch (Exception e) {
                                Logger.getLogger(MergeCleanAllTable.class).error((Object)"", (Throwable)e);
                            }
                        }
                    }
                });
            }
        }
        catch (Exception e) {
            Logger.getLogger(MergeCleanAllTable.class).error((Object)"", (Throwable)e);
        }
        return result;
    }

    private void rpc_result_Save(String result, String info, Entity entity, String type) {
        result = "<rootTemp>" + result + "</rootTemp>";
        Element xmlParent = GOTXMLHelper.createElementByXMLString(result);
        List list = xmlParent.elements();
        JDTHandler.getServer().saveEntity();
        for (Element r : list) {
            if (r.getName().equals("Error")) {
                info = String.valueOf(info) + r.getText() + "\n\u4fdd\u5b58\u5931\u8d25\uff0c\u5e94\u6267\u884c\u53f3\u952e\u6062\u590d\uff0c\u4ee5\u9632\u6570\u636e\u4e22\u5931\n";
                continue;
            }
            String nodeId = r.attributeValue("id");
            String qname = r.getName();
            GotXmlDto.getInstance().saveEntity(nodeId);
            EntityNode node = GotXmlDto.getInstance().getEntityByIdAndType(EntityType.valueOf((String)qname), nodeId);
            if (node == null) continue;
            if (entity.xml.attributeValue("id").equals(r.attributeValue("id"))) {
                info = String.valueOf(info) + r.attributeValue("name") + ":" + r.getName() + "  \u5df2\u4fee\u6539 OK\n";
                if (!type.equals("promote")) continue;
                JDTHandler.asyncTask(() -> JDTHandler.getServer().promoteEntity(r.asXML(), entity.xml.attributeValue("modifiedLayer")));
                continue;
            }
            TreeItem item = FormDataSyn.getTreeItrmByNode((GOTNode)node, null);
            if (item != null) {
                FormDataSyn.restore(item, null);
            }
            info = String.valueOf(info) + r.attributeValue("name") + ":" + r.getName() + "  \u5df2\u4fee\u6539 OK\n";
        }
    }

    private Boolean isTableDsDif(GOTNode dataSource, EntityNode table) throws VTDException {
        List tableFields = table.selectNodes("./TableFields/TableField");
        List formdatasourcefields = dataSource.selectNodes("./FormDataSourceFields/FormDataSourceField");
        int i = 0;
        for (GOTNode tableField : tableFields) {
            if (formdatasourcefields.size() <= i) {
                return false;
            }
            if ("Component".equals(tableField.getAttributeValue("type"))) {
                String dataTypeId = tableField.getProperty("Extends").getRefEntityId();
                EntityNode dataType = GotXmlDto.getInstance().getEntityByIdAndType(EntityType.DataType, dataTypeId);
                if (dataType == null) {
                    throw new RuntimeException(String.format("\u6821\u9a8c\u5931\u8d25: form\u3010%s\u3011\u7684formDataSource\u3010%s\u3011\u7684formDataSourceField\u3010%s\u3011\u7ee7\u627f\u7684DataType\u4e0d\u5b58\u5728", dataSource.getEntity().getName(), dataSource.getName(), tableField.getName()));
                }
                List dataTypeArrayItems = dataType.selectNodes("./DataTypeArray/DataTypeArrayItem");
                for (GOTNode dataTypeArrayItem : dataTypeArrayItems) {
                    if (formdatasourcefields.size() <= i) {
                        return false;
                    }
                    GOTNode formdatasourcefield = (GOTNode)formdatasourcefields.get(i);
                    NodeProperty property = formdatasourcefield.getProperty("Field");
                    if (!tableField.getId().equals(property.getRefInnerId())) {
                        return false;
                    }
                    String dataTypeName = dataType.getName();
                    if (dataTypeName.contains(".")) {
                        dataTypeName = dataTypeName.substring(dataTypeName.lastIndexOf(".") + 1);
                    }
                    if (!property.getValue().equals(String.valueOf(dataTypeName) + "." + dataTypeArrayItem.getName())) {
                        return false;
                    }
                    ++i;
                }
                GOTNode formdatasourcefield = (GOTNode)formdatasourcefields.get(i);
                NodeProperty property = formdatasourcefield.getProperty("Field");
                if (property == null || !tableField.getId().equals(property.getRefInnerId())) {
                    return false;
                }
            } else {
                GOTNode formdatasourcefield = (GOTNode)formdatasourcefields.get(i);
                NodeProperty property = formdatasourcefield.getProperty("Field");
                if (property == null || !tableField.getId().equals(property.getRefInnerId())) {
                    return false;
                }
                if (property == null || !tableField.getName().equals(property.getValue())) {
                    return false;
                }
            }
            ++i;
        }
        String id = table.getId();
        GOTNode formElement = dataSource.getParent().getParent();
        GOTNode FormDesign2 = formElement.selectSingleNode("./FormDesign");
        List formItems = FormDesign2.selectNodes(".//FormItem");
        for (GOTNode formItem : formItems) {
            String refinnerid;
            GOTNode TableField2;
            NodeProperty Extends = formItem.getProperty("Extends");
            if (Extends == null || !id.equals(Extends.getRefEntityId()) || (TableField2 = table.selectSingleNode(String.format("TableFields/TableField[@id='%s']", refinnerid = Extends.getRefInnerId()))) == null) continue;
            String name = TableField2.getName();
            String extendValue = Extends.getValue();
            if ("Component".equals(TableField2.getAttributeValue("type")) && extendValue.indexOf(".") > 0) {
                extendValue = extendValue.substring(extendValue.lastIndexOf("."), extendValue.length());
                name = String.valueOf(name) + extendValue;
            }
            if (name.equals(extendValue)) continue;
            return false;
        }
        return true;
    }

    private Boolean tableToDsChanged(GOTNode ds, EntityNode table) throws VTDException {
        List tableFields = table.selectNodes("./TableFields/TableField");
        List formdatasourcefields = ds.selectNodes("./FormDataSourceFields/FormDataSourceField");
        int j = 0;
        int i = 0;
        while (i < formdatasourcefields.size()) {
            GOTNode fdsf = (GOTNode)formdatasourcefields.get(i);
            String fdsfName = fdsf.getName();
            if (fdsfName.indexOf(".") == -1) {
                GOTNode tableField = (GOTNode)tableFields.get(j);
                NodeProperty fieldPro = fdsf.getProperty("Field");
                String refinnerid = fieldPro.getRefInnerId();
                if (!refinnerid.equals(tableField.getId())) {
                    return true;
                }
                String tableFieldName = tableField.getName();
                if (!fdsfName.equals(tableFieldName)) {
                    return true;
                }
                if (!tableField.getAttributeValue("type").equals(fdsf.getAttributeValue("type"))) {
                    return true;
                }
                ++j;
            }
            ++i;
        }
        String id = table.getId();
        GOTNode formElement = ds.getParent().getParent();
        GOTNode FormDesign2 = formElement.selectSingleNode("./FormDesign");
        List formItems = FormDesign2.selectNodes(".//FormItem");
        for (GOTNode formItem : formItems) {
            String refinnerid;
            Element TableField2;
            NodeProperty Extends = formItem.getProperty("Extends");
            if (Extends == null || !id.equals(Extends.getRefEntityId()) || (TableField2 = (Element)table.selectSingleNode(String.format("TableFields/TableField[@id='%s']", refinnerid = Extends.getRefInnerId()))) == null) continue;
            String name = TableField2.attributeValue("name");
            String extendValue = Extends.getValue();
            if ("Component".equals(TableField2.attributeValue("type")) && extendValue.indexOf(".") > 0) {
                extendValue = extendValue.substring(extendValue.lastIndexOf("."), extendValue.length());
                name = String.valueOf(name) + extendValue;
            }
            if (name.equals(extendValue)) continue;
            return true;
        }
        return true;
    }

    private void adjustDSByTable(GOTNode dataSource, EntityNode table) throws VTDException {
        String name;
        EntityNode form = dataSource.getEntity();
        Element formEle = form.toElement();
        Element dataSourceEle = (Element)formEle.selectSingleNode(dataSource.getEntityXPath());
        Element dataSourceClone = (Element)dataSourceEle.clone();
        Element newFormDataSourceFields = dataSourceEle.element("FormDataSourceFields");
        List formDataSourceFields = newFormDataSourceFields.elements("FormDataSourceField");
        for (Element formDataSourceField : formDataSourceFields) {
            newFormDataSourceFields.remove(formDataSourceField);
        }
        List tableFields = table.selectNodes("./TableFields/TableField");
        for (GOTNode tableField : tableFields) {
            if ("Component".equals(tableField.getAttributeValue("type"))) {
                String dataTypeId = tableField.getProperty("Extends").getRefEntityId();
                EntityNode dataType = GotXmlDto.getInstance().getEntityByIdAndType(EntityType.DataType, dataTypeId);
                List dataTypeArrayItems = dataType.selectNodes("./DataTypeArray/DataTypeArrayItem");
                for (GOTNode dataTypeArrayItem : dataTypeArrayItems) {
                    String dataTypeName = dataType.getName();
                    if (dataTypeName.contains(".")) {
                        dataTypeName = dataTypeName.substring(dataTypeName.lastIndexOf(".") + 1);
                    }
                    name = String.valueOf(dataTypeName) + "." + dataTypeArrayItem.getName();
                    Element formDataSourceField = (Element)dataSourceClone.selectSingleNode(String.format("./FormDataSourceFields/FormDataSourceField[Properties/Property[@refinnerid='%s'][Name[text()='Field'] and Value ='%s']]", tableField.getId(), name));
                    if (formDataSourceField != null) {
                        newFormDataSourceFields.add(formDataSourceField.detach());
                        continue;
                    }
                    newFormDataSourceFields.add(this.createFormDataField(tableField, NodeGOT.getNextInnerId(formEle), dataType.getAttributeValue("type"), name).detach());
                }
                Element formDataSourceField = (Element)dataSourceClone.selectSingleNode(String.format("./FormDataSourceFields/FormDataSourceField[Properties/Property[@refinnerid='%s'][Name[text()='Field'] and Value ='%s']]", tableField.getId(), tableField.getName()));
                if (formDataSourceField != null) {
                    newFormDataSourceFields.add(formDataSourceField.detach());
                    continue;
                }
                newFormDataSourceFields.add(this.createFormDataField(tableField, NodeGOT.getNextInnerId(formEle), tableField.getAttributeValue("type"), tableField.getName()).detach());
                continue;
            }
            Element formDataSourceField = (Element)dataSourceClone.selectSingleNode(String.format("./FormDataSourceFields/FormDataSourceField[Properties/Property[@refinnerid='%s']/Name[text()='Field']]", tableField.getId()));
            if (formDataSourceField != null) {
                Element newFormDataField = this.createFormDataField(tableField, NodeGOT.getNextInnerId(formEle), tableField.getAttributeValue("type"), tableField.getName());
                formDataSourceField.addAttribute("name", newFormDataField.attributeValue("name"));
                Element property = (Element)formDataSourceField.selectSingleNode(String.format("Properties/Property[@refinnerid='%s' and Name='Field']/Value", tableField.getId()));
                if (property != null) {
                    property.setText(tableField.getAttributeValue("name"));
                }
                newFormDataSourceFields.add(formDataSourceField.detach());
                continue;
            }
            newFormDataSourceFields.add(this.createFormDataField(tableField, NodeGOT.getNextInnerId(formEle), tableField.getAttributeValue("type"), tableField.getName()).detach());
        }
        String id = table.getId();
        Element FormDesign2 = formEle.element("FormDesign");
        List formItems = FormDesign2.selectNodes(".//FormItem");
        for (Element formItem : formItems) {
            String extendValue;
            String oldName;
            String refinnerid;
            GOTNode TableField2;
            Element Extends = GOTHelper.getProperty(formItem, "Extends");
            if (Extends == null || !id.equals(Extends.attributeValue("refentityid")) || (TableField2 = table.selectSingleNode(String.format("TableFields/TableField[@id='%s']", refinnerid = Extends.attributeValue("refinnerid")))) == null) continue;
            name = TableField2.getName();
            if ("Component".equals(TableField2.getAttributeValue("type")) && (oldName = Extends.element("Value").getText()).indexOf(".") > 0) {
                oldName = oldName.substring(oldName.lastIndexOf("."), oldName.length());
                name = String.valueOf(name) + oldName;
            }
            if (name.equals(extendValue = Extends.element("Value").getText())) continue;
            Extends.element("Value").setText(name);
        }
        GotXmlDto.getInstance().updateEntityElement(formEle);
        FormDataSyn.restore(form.getId());
    }

    private Element createFormDataField(GOTNode tableField, String innerId, String type, String fieldName) throws NavException {
        ResolverNode rNode = ResolverNodeFactory.getResolverNode("FormDataSourceField", type);
        String name = rNode.getNode().attributeValue("name");
        String rNodeType = rNode.getInfoValue("Type");
        NodeGOT newNode = NodeFactory.createNode(name, rNodeType, "");
        Element formDataSourceField = newNode.xml;
        formDataSourceField.addAttribute("id", innerId);
        formDataSourceField.addAttribute("name", fieldName);
        formDataSourceField.addAttribute("type", type);
        formDataSourceField.addAttribute("createdLayer", tableField.getCreatedLayer());
        formDataSourceField.addAttribute("modifiedLayer", tableField.getModifiedLayer());
        GOTDom4jUtils.setPropertyRefEntityId((Element)formDataSourceField, (String)"Field", (String)tableField.getEntity().getId());
        GOTDom4jUtils.setPropertyRefInnerId((Element)formDataSourceField, (String)"Field", (String)tableField.getId());
        GOTDom4jUtils.setPropertyValue((Element)formDataSourceField, (String)"Field", (String)fieldName);
        return formDataSourceField;
    }

    private String adjustDsByTable(final GOTNode ds, final EntityNode table) {
        Display.getDefault().asyncExec(new Runnable(){

            @Override
            public void run() {
                try {
                    EntityNode formNode = ds.getEntity();
                    TreeItem trtmNewTreeitem = FormDataSyn.getTreeItrmByNode((GOTNode)formNode, FormDataSyn.treeUis.get(0));
                    Element formElement = formNode.toElement();
                    Element formDataSource = (Element)formElement.selectSingleNode(ds.getEntityXPath());
                    Element datasourceFields = formDataSource.element("FormDataSourceFields");
                    Element base = null;
                    List tableFields = table.selectNodes("./TableFields/TableField");
                    for (GOTNode tableFieldElement : tableFields) {
                        int i;
                        Element fieldPro;
                        String _id = tableFieldElement.getId();
                        ArrayList<Element> formDataSourceFieldList = new ArrayList<Element>();
                        List fdsfs = datasourceFields.elements("FormDataSourceField");
                        for (Element temp : fdsfs) {
                            fieldPro = GOTHelper.getProperty(temp, "Field");
                            if (!_id.equals(fieldPro.attributeValue("refinnerid"))) continue;
                            formDataSourceFieldList.add(temp);
                        }
                        if (formDataSourceFieldList.size() == 0) {
                            NodeProperty extendsProperty;
                            ResolverNode rNode = ResolverNodeFactory.getResolverNode("FormDataSourceField", tableFieldElement.getAttributeValue("type"));
                            Object name = rNode.getNode().attributeValue("name");
                            String type = rNode.getInfoValue("Type");
                            NodeGOT newNode = NodeFactory.createNode((String)name, type, "");
                            Element formDataSourceField = newNode.xml;
                            formDataSourceField.addAttribute("id", NodeGOT.getNextInnerId(formElement));
                            formDataSourceField.addAttribute("name", tableFieldElement.getName());
                            formDataSourceField.addAttribute("type", tableFieldElement.getAttributeValue("type"));
                            formDataSourceField.addAttribute("createdLayer", ((LayerService)ObjectContainer.getInstance(LayerService.class)).getCurrentLayer());
                            formDataSourceField.addAttribute("modifiedLayer", ((LayerService)ObjectContainer.getInstance(LayerService.class)).getCurrentLayer());
                            GOTDom4jUtils.setPropertyRefEntityId((Element)formDataSourceField, (String)"Field", (String)table.getId());
                            GOTDom4jUtils.setPropertyRefInnerId((Element)formDataSourceField, (String)"Field", (String)tableFieldElement.getId());
                            GOTDom4jUtils.setPropertyValue((Element)formDataSourceField, (String)"Field", (String)tableFieldElement.getName());
                            if ("Component".equals(tableFieldElement.getAttributeValue("type")) && StringUtils.isNotBlank((String)(extendsProperty = tableFieldElement.getProperty("Extends")).getRefEntityId())) {
                                String dataTypeId = extendsProperty.getRefEntityId();
                                EntityNode dataTypes = GotXmlDto.getInstance().getEntityByIdAndType(EntityType.DataType, dataTypeId);
                                if (dataTypes != null) {
                                    EntityNode dataType = dataTypes;
                                    List arrayItems = dataType.selectNodes("./DataTypeArray/DataTypeArrayItem");
                                    int length = arrayItems.size();
                                    i = 0;
                                    while (i < length) {
                                        GOTNode arrayItem = (GOTNode)arrayItems.get(i);
                                        ResolverNode arrayItemrNode = ResolverNodeFactory.getResolverNode("FormDataSourceField", arrayItem.getAttributeValue("type"));
                                        name = arrayItemrNode.getNode().attributeValue("name");
                                        type = arrayItemrNode.getInfoValue("Type");
                                        newNode = NodeFactory.createNode((String)name, type, "");
                                        Element arrayItemFormDataSourceField = newNode.xml;
                                        arrayItemFormDataSourceField.addAttribute("id", NodeGOT.getNextInnerId(formElement));
                                        arrayItemFormDataSourceField.addAttribute("name", String.format("%s.%s", tableFieldElement.getName(), arrayItem.getName()));
                                        arrayItemFormDataSourceField.addAttribute("type", "String");
                                        arrayItemFormDataSourceField.addAttribute("createdLayer", ((LayerService)ObjectContainer.getInstance(LayerService.class)).getCurrentLayer());
                                        arrayItemFormDataSourceField.addAttribute("modifiedLayer", ((LayerService)ObjectContainer.getInstance(LayerService.class)).getCurrentLayer());
                                        GOTDom4jUtils.setPropertyRefEntityId((Element)arrayItemFormDataSourceField, (String)"Field", (String)table.getId());
                                        GOTDom4jUtils.setPropertyRefInnerId((Element)arrayItemFormDataSourceField, (String)"Field", (String)tableFieldElement.getId());
                                        GOTDom4jUtils.setPropertyValue((Element)arrayItemFormDataSourceField, (String)"Field", (String)String.format("%s.%s", tableFieldElement.getName(), arrayItem.getName()));
                                        if (base == null) {
                                            datasourceFields.add(arrayItemFormDataSourceField.detach());
                                        } else {
                                            GOTHelp.insertChildAfter(datasourceFields, base, arrayItemFormDataSourceField);
                                        }
                                        base = arrayItemFormDataSourceField;
                                        ++i;
                                    }
                                }
                            }
                            if (base == null) {
                                datasourceFields.add(formDataSourceField.detach());
                            } else {
                                GOTHelp.insertChildAfter(datasourceFields, base, formDataSourceField);
                            }
                            base = formDataSourceField;
                        } else {
                            for (Element fdsf : formDataSourceFieldList) {
                                fdsfs.remove(fdsf);
                                fieldPro = GOTHelper.getProperty(fdsf, "Field");
                                String refinnerid = fieldPro.attributeValue("refinnerid");
                                String fdsfName = fdsf.attributeValue("name");
                                String tableFieldName = tableFieldElement.getName();
                                String tableFieldId = tableFieldElement.getId();
                                String fdsfType = fdsf.attributeValue("type");
                                String tableFieldType = tableFieldElement.getAttributeValue("type");
                                if (tableFieldId.equals(refinnerid)) {
                                    if (!"Component".equals(tableFieldType)) {
                                        fdsf.addAttribute("name", tableFieldName);
                                        if (fieldPro.element("Value") == null) {
                                            fieldPro.addElement("Value");
                                        }
                                        fieldPro.element("Value").setText(tableFieldName);
                                    } else {
                                        String[] array = fdsfName.split("\\.");
                                        array[0] = tableFieldName;
                                        String newFdsfName = "";
                                        i = 0;
                                        while (i < array.length) {
                                            newFdsfName = i == 0 ? String.valueOf(newFdsfName) + array[i] : String.valueOf(newFdsfName) + "." + array[i];
                                            ++i;
                                        }
                                        fdsf.addAttribute("name", newFdsfName);
                                        if (fieldPro.element("Value") == null) {
                                            fieldPro.addElement("Value");
                                        }
                                        fieldPro.element("Value").setText(newFdsfName);
                                    }
                                }
                                if ("Component".equals(tableFieldType) || fdsfType.equals(tableFieldType)) continue;
                                fdsf.addAttribute("type", tableFieldType);
                            }
                        }
                        for (Element fdsf : formDataSourceFieldList) {
                            if (base == null) {
                                datasourceFields.add(fdsf.detach());
                            } else {
                                GOTHelp.insertChildAfter(datasourceFields, base, fdsf);
                            }
                            base = fdsf;
                        }
                    }
                    List fdsfs = datasourceFields.elements("FormDataSourceField");
                    for (Element fdsf : fdsfs) {
                        Element fieldPro = GOTHelper.getProperty(fdsf, "Field");
                        String _id = fieldPro.attributeValue("refinnerid");
                        GOTNode tableField = null;
                        for (GOTNode element : tableFields) {
                            if (!_id.equals(element.getId())) continue;
                            tableField = element;
                            break;
                        }
                        if (tableField != null) continue;
                        GOTXMLHelper.deleteNode(fdsf);
                    }
                    String id = table.getId();
                    Element FormDesign2 = formElement.element("FormDesign");
                    List formItems = FormDesign2.selectNodes(".//FormItem");
                    for (Element formItem : formItems) {
                        String extendValue;
                        String oldName;
                        String refinnerid;
                        GOTNode TableField2;
                        Element Extends = GOTHelper.getProperty(formItem, "Extends");
                        if (Extends == null || !id.equals(Extends.attributeValue("refentityid")) || (TableField2 = table.selectSingleNode(String.format("TableFields/TableField[@id='%s']", refinnerid = Extends.attributeValue("refinnerid")))) == null) continue;
                        String name = TableField2.getName();
                        if ("Component".equals(TableField2.getAttributeValue("type")) && (oldName = Extends.element("Value").getText()).indexOf(".") > 0) {
                            oldName = oldName.substring(oldName.lastIndexOf("."), oldName.length());
                            name = String.valueOf(name) + oldName;
                        }
                        if (name.equals(extendValue = Extends.element("Value").getText())) continue;
                        Extends.element("Value").setText(name);
                    }
                    GotXmlDto.getInstance().updateEntityElement(formElement);
                    FormDataSyn.restore(trtmNewTreeitem, null);
                }
                catch (VTDException e) {
                    Logger.getLogger(MergeCleanAllTable.class).error((Object)e);
                }
            }
        });
        String formItemPrompt = "";
        return formItemPrompt;
    }
}

