/*
 * Decompiled with CFR 0.152.
 */
package info.gongqi.got.tool;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import gongqi.designer.services.LayerService;
import gongqi.erp.framework.core.ObjectContainer;
import gongqi.gdt.designer.ProjectConstants;
import gongqi.gdt.designer.plugin.GOTPlugin;
import gongqi.gdt.designer.utils.SWTUtils;
import info.gongqi.got.tool.FormDataSyn;
import info.gongqi.got.ui.ConfigComposite;
import info.gongqi.got.ui.LoadXmlCore;
import info.gongqi.got.util.GOTMessageDialog;
import java.io.File;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Dialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;

public class SwitchCurrentLayerDialog
extends Dialog {
    protected boolean result = false;
    protected Shell shell;
    public static String layer = "";
    public static String solution = "";
    public static String user;
    public Combo comboLayer;
    public Combo comboSolution;
    public Combo comboPlugin;
    public Combo comboUser;
    private static Logger log;
    private File historyFile = new File(ProjectConstants.getBasePath(), "Temp/switchCurrentUserHistory.json");
    private Map<String, UserHistory> historys = new HashMap<String, UserHistory>();

    static {
        log = Logger.getLogger(SwitchCurrentLayerDialog.class);
    }

    public SwitchCurrentLayerDialog(Shell parent, int style) {
        super(parent, style);
        this.setText("\u7f16\u8f91\u8303\u56f4");
    }

    public boolean open() {
        this.loadHistory();
        this.shell = new Shell(this.getParent(), this.getStyle() | 0x10000);
        this.shell.setSize(SWTUtils.zoom(230), SWTUtils.zoom(220));
        this.shell.setText(this.getText());
        this.shell.setLayout((Layout)new FormLayout());
        Label labelLayer = new Label((Composite)this.shell, 131072);
        labelLayer.setText("\u5c42");
        FormData formData = new FormData();
        formData.left = new FormAttachment(0, SWTUtils.zoom(10));
        formData.right = new FormAttachment(20);
        formData.top = new FormAttachment(0, SWTUtils.zoom(10));
        labelLayer.setLayoutData((Object)formData);
        this.comboLayer = new Combo((Composite)this.shell, 8);
        formData = new FormData();
        formData.top = new FormAttachment((Control)labelLayer, SWTUtils.zoom(-2), 128);
        formData.left = new FormAttachment((Control)labelLayer, SWTUtils.zoom(6), 131072);
        formData.right = new FormAttachment(100, SWTUtils.zoom(-10));
        this.comboLayer.setLayoutData((Object)formData);
        this.comboLayer.addSelectionListener(SelectionListener.widgetSelectedAdapter(e -> this.setDef()));
        Label labelSolution = new Label((Composite)this.shell, 131072);
        labelSolution.setText("\u5e94\u7528");
        formData = new FormData();
        formData.top = new FormAttachment((Control)labelLayer, SWTUtils.zoom(20), 1024);
        formData.right = new FormAttachment((Control)labelLayer, 0, 131072);
        labelSolution.setLayoutData((Object)formData);
        this.comboSolution = new Combo((Composite)this.shell, 8);
        this.comboSolution.setEnabled(false);
        formData = new FormData();
        formData.top = new FormAttachment((Control)labelSolution, SWTUtils.zoom(-2), 128);
        formData.left = new FormAttachment((Control)this.comboLayer, 0, 16384);
        formData.right = new FormAttachment((Control)this.comboLayer, 0, 131072);
        this.comboSolution.setLayoutData((Object)formData);
        this.comboSolution.addSelectionListener(SelectionListener.widgetSelectedAdapter(e -> {
            this.setPlug();
            this.setUser();
        }));
        Label labelPlugin = new Label((Composite)this.shell, 131072);
        labelPlugin.setText("\u63d2\u4ef6");
        formData = new FormData();
        formData.top = new FormAttachment((Control)labelSolution, SWTUtils.zoom(20), 1024);
        formData.right = new FormAttachment((Control)labelSolution, 0, 131072);
        labelPlugin.setLayoutData((Object)formData);
        this.comboPlugin = new Combo((Composite)this.shell, 8);
        this.comboPlugin.setEnabled(false);
        formData = new FormData();
        formData.top = new FormAttachment((Control)labelPlugin, SWTUtils.zoom(-2), 128);
        formData.left = new FormAttachment((Control)this.comboSolution, 0, 16384);
        formData.right = new FormAttachment((Control)this.comboSolution, 0, 131072);
        this.comboPlugin.setLayoutData((Object)formData);
        this.comboPlugin.addSelectionListener(SelectionListener.widgetSelectedAdapter(e -> {
            this.comboUser.removeAll();
            this.setUser();
        }));
        Label labelUser = new Label((Composite)this.shell, 131072);
        labelUser.setText("\u7528\u6237");
        formData = new FormData();
        formData.top = new FormAttachment((Control)labelPlugin, SWTUtils.zoom(20), 1024);
        formData.right = new FormAttachment((Control)labelPlugin, 0, 131072);
        labelUser.setLayoutData((Object)formData);
        this.comboUser = new Combo((Composite)this.shell, 8);
        formData = new FormData();
        formData.top = new FormAttachment((Control)labelUser, SWTUtils.zoom(-2), 128);
        formData.left = new FormAttachment((Control)this.comboPlugin, 0, 16384);
        formData.right = new FormAttachment((Control)this.comboPlugin, 0, 131072);
        this.comboUser.setLayoutData((Object)formData);
        Button buttonConfirm = new Button((Composite)this.shell, 0);
        buttonConfirm.addSelectionListener(SelectionListener.widgetSelectedAdapter(this::buttonConfirm));
        buttonConfirm.setText("\u786e\u5b9a");
        formData = new FormData(SWTUtils.zoom(64), SWTUtils.zoom(26));
        formData.bottom = new FormAttachment(100, SWTUtils.zoom(-10));
        formData.right = new FormAttachment(50, SWTUtils.zoom(-10));
        buttonConfirm.setLayoutData((Object)formData);
        Button buttonCancel = new Button((Composite)this.shell, 0);
        buttonCancel.addSelectionListener(SelectionListener.widgetSelectedAdapter(e -> {
            ConfigComposite.configComposite.button_restart.setEnabled(true);
            this.shell.close();
        }));
        buttonCancel.setText("\u53d6\u6d88");
        formData = new FormData(SWTUtils.zoom(64), SWTUtils.zoom(26));
        formData.top = new FormAttachment((Control)buttonConfirm, 0, 128);
        formData.left = new FormAttachment(50, SWTUtils.zoom(12));
        buttonCancel.setLayoutData((Object)formData);
        GOTMessageDialog.shells.add(this.shell);
        LayerService layerService = (LayerService)ObjectContainer.getInstance(LayerService.class);
        List array = layerService.getCanEditLayerList();
        String[] item = array.toArray(new String[array.size()]);
        this.comboLayer.setItems(item);
        if (item.length == 1) {
            this.comboLayer.setText(item[0]);
            this.setDef();
        }
        SWTUtils.showInScreenCenter(this.shell);
        Display display = this.getParent().getDisplay();
        while (!this.shell.isDisposed()) {
            if (display.readAndDispatch()) continue;
            display.sleep();
        }
        return this.result;
    }

    private void setPlug() {
        String text = this.comboLayer.getText();
        if (text.equals("plg")) {
            this.comboPlugin.setEnabled(true);
            this.comboPlugin.removeAll();
            LayerService layerService = (LayerService)ObjectContainer.getInstance(LayerService.class);
            List<String> plugs = layerService.getCanEditSolutionPluginList(this.comboSolution.getText()).stream().sorted().collect(Collectors.toList());
            this.comboPlugin.setItems(plugs.toArray(new String[plugs.size()]));
            if (plugs.size() > 0) {
                if (this.historys.containsKey(text)) {
                    JSONObject lastPluginObj = this.historys.get(text).getLastPlugin(this.comboSolution.getText());
                    String lastPlugin = lastPluginObj.getString("lastPlugin");
                    if (plugs.contains(lastPlugin)) {
                        this.comboPlugin.setText(lastPlugin);
                    } else {
                        this.comboPlugin.setText((String)plugs.get(0));
                    }
                } else {
                    this.comboPlugin.setText((String)plugs.get(0));
                }
            }
        } else {
            this.comboPlugin.setEnabled(false);
            this.comboPlugin.removeAll();
        }
    }

    private void setUser() {
        try {
            String plg = this.comboPlugin.getText();
            String app = this.comboSolution.getText();
            List user = LoadXmlCore.gotServices.getEditUsers(this.comboLayer.getText(), app, plg);
            String[] item = user.toArray(new String[user.size()]);
            this.comboUser.setItems(item);
            if (item.length > 1) {
                String text = this.comboLayer.getText();
                if (this.historys.containsKey(text)) {
                    if (text.equals("plg")) {
                        JSONObject lastPluginObj = this.historys.get(text).getLastPlugin(app);
                        String lastUser = lastPluginObj.getString("lastUser");
                        if (user.contains(lastUser)) {
                            this.comboUser.setText(lastUser);
                        } else {
                            this.comboUser.setText(item[0]);
                        }
                    } else {
                        String lastUser = this.historys.get(text).getLastUser();
                        if (user.contains(lastUser)) {
                            this.comboUser.setText(lastUser);
                        } else {
                            this.comboUser.setText(item[0]);
                        }
                    }
                } else {
                    this.comboUser.setText(item[0]);
                }
            } else if (item.length == 1) {
                this.comboUser.setText(item[0]);
            }
        }
        catch (Exception e) {
            log.error((Object)"", (Throwable)e);
        }
    }

    private void setDef() {
        try {
            this.comboUser.setItems(new String[0]);
            String text = this.comboLayer.getText();
            if (text.equals("app")) {
                this.comboSolution.removeAll();
                this.comboPlugin.removeAll();
                LayerService layerService = (LayerService)ObjectContainer.getInstance(LayerService.class);
                List<String> array = layerService.getCanEditSolutionList().stream().sorted().collect(Collectors.toList());
                String[] item = array.toArray(new String[array.size()]);
                this.comboSolution.setEnabled(true);
                this.comboSolution.setItems(item);
                if (item.length >= 1) {
                    if (this.historys.containsKey(text)) {
                        String lastSolution = this.historys.get(text).getLastSolution();
                        if (array.contains(lastSolution)) {
                            this.comboSolution.setText(lastSolution);
                        } else {
                            this.comboSolution.setText(item[0]);
                        }
                    } else {
                        this.comboSolution.setText(item[0]);
                    }
                    this.setPlug();
                    this.setUser();
                }
            } else if (text.equals("ext")) {
                this.comboSolution.removeAll();
                this.comboPlugin.removeAll();
                LayerService layerService = (LayerService)ObjectContainer.getInstance(LayerService.class);
                List<String> array = layerService.getCanEditExtensionList().stream().sorted().collect(Collectors.toList());
                String[] item = array.toArray(new String[array.size()]);
                this.comboSolution.setEnabled(true);
                this.comboSolution.setItems(item);
                if (item.length >= 1) {
                    if (this.historys.containsKey(text)) {
                        String lastSolution = this.historys.get(text).getLastSolution();
                        if (array.contains(lastSolution)) {
                            this.comboSolution.setText(lastSolution);
                        } else {
                            this.comboSolution.setText(item[0]);
                        }
                    } else {
                        this.comboSolution.setText(item[0]);
                    }
                    this.setUser();
                }
            } else if (text.equals("plg")) {
                this.comboSolution.removeAll();
                LayerService layerService = (LayerService)ObjectContainer.getInstance(LayerService.class);
                List array = layerService.getSolutionListForSourcePlugin();
                String[] item = array.toArray(new String[array.size()]);
                this.comboSolution.setEnabled(true);
                this.comboSolution.setItems(item);
                if (item.length > 0) {
                    if (this.historys.containsKey(text)) {
                        String lastSolution = this.historys.get(text).getLastSolution();
                        if (array.contains(lastSolution)) {
                            this.comboSolution.setText(lastSolution);
                        } else {
                            this.comboSolution.setText(item[0]);
                        }
                    } else {
                        this.comboSolution.setText(item[0]);
                    }
                    this.setPlug();
                    this.setUser();
                }
            } else {
                this.comboSolution.removeAll();
                this.comboUser.removeAll();
                this.comboPlugin.removeAll();
                this.comboSolution.setEnabled(false);
                this.comboPlugin.setEnabled(false);
                List user = LoadXmlCore.gotServices.getEditUsers(this.comboLayer.getText(), this.comboSolution.getText(), this.comboPlugin.getText());
                String[] item = user.toArray(new String[user.size()]);
                this.comboUser.setItems(item);
                if (item.length >= 1) {
                    if (this.historys.containsKey(text)) {
                        String lastUser = this.historys.get(text).getLastUser();
                        if (user.contains(lastUser)) {
                            this.comboUser.setText(lastUser);
                        } else {
                            this.comboUser.setText(item[0]);
                        }
                    } else {
                        this.comboUser.setText(item[0]);
                    }
                }
            }
        }
        catch (Exception e) {
            log.error((Object)"", (Throwable)e);
        }
    }

    private void buttonConfirm(SelectionEvent e) {
        String layerName = this.comboLayer.getText();
        String solutionName = this.comboSolution.getText();
        String solutionPluginName = this.comboPlugin.getText();
        String userId = this.comboUser.getText();
        String text = this.comboLayer.getText();
        if (StringUtils.isBlank((String)layerName) || StringUtils.isBlank((String)userId)) {
            GOTMessageDialog.alert("\u5c42\u6216\u8005\u7528\u6237\u4e0d\u80fd\u4e3a\u7a7a");
            return;
        }
        if ("app".equals(layerName) && StringUtils.isBlank((String)solutionName)) {
            GOTMessageDialog.alert("\u65b9\u6848\u4e0d\u5141\u8bb8\u4e3a\u7a7a");
            return;
        }
        if ("ext".equals(layerName) && StringUtils.isBlank((String)solutionName)) {
            GOTMessageDialog.alert("\u65b9\u6848\u4e0d\u5141\u8bb8\u4e3a\u7a7a");
            return;
        }
        if ("plg".equals(layerName) && (StringUtils.isBlank((String)solutionName) || StringUtils.isBlank((String)solutionPluginName))) {
            GOTMessageDialog.alert("\u65b9\u6848\u6216\u63d2\u4ef6\u4e0d\u5141\u8bb8\u4e3a\u7a7a");
            return;
        }
        layer = text;
        solution = this.comboSolution.getText();
        user = this.comboUser.getText();
        this.result = true;
        String comboLayerText = this.comboLayer.getText();
        this.shell.setVisible(false);
        this.shell.setData("Visible", (Object)false);
        this.updateHistory();
        new Thread(() -> {
            try {
                GOTPlugin.getDefault().switchCurrentLayer(layerName, solutionName, solutionPluginName, userId);
            }
            catch (Exception e1) {
                Display.getDefault().syncExec(() -> {
                    Logger.getLogger(((Object)((Object)this)).getClass()).error((Object)"\u5207\u6362\u5f53\u524d\u5c42\u65f6\u51fa\u73b0\u5f02\u5e38", (Throwable)e1);
                    GOTMessageDialog.alert(e1);
                    this.result = false;
                    if (!this.shell.isDisposed()) {
                        this.shell.close();
                    }
                });
                return;
            }
            Display.getDefault().syncExec(() -> {
                String currentInfoText = "app".equals(layerName) ? "\u5c42\uff1a" + layerName + "  \u65b9\u6848\uff1a" + solutionName + "  \u7528\u6237\uff1a" + userId : ("plg".equals(layerName) ? String.format("\u5c42\uff1a%s \u65b9\u6848\uff1a%s \u63d2\u4ef6\uff1a%s \u7528\u6237\uff1a%s", layerName, solutionName, solutionPluginName, userId) : ("ext".equals(comboLayerText) ? "\u5c42\uff1a" + layerName + " \u65b9\u6848\uff1a" + solutionName + " \u7528\u6237\uff1a" + userId : "\u5c42\uff1a" + layerName + " \u7528\u6237\uff1a" + userId));
                if (!ConfigComposite.configComposite.isDisposed()) {
                    ConfigComposite.configComposite.layer_label.setText(currentInfoText);
                    ConfigComposite.configComposite.button_restart.setEnabled(true);
                }
                if (FormDataSyn.treeUis.size() > 0) {
                    GOTMessageDialog.showExchangeLayer();
                }
                if (!this.shell.isDisposed()) {
                    this.shell.close();
                }
            });
        }).start();
    }

    private void loadHistory() {
        if (!this.historyFile.exists()) {
            return;
        }
        try {
            JSONObject content = JSON.parseObject((String)FileUtils.readFileToString((File)this.historyFile, (Charset)StandardCharsets.UTF_8));
            for (String layerName : content.keySet()) {
                this.historys.put(layerName, new UserHistory(content.getJSONObject(layerName)));
            }
        }
        catch (Exception e) {
            log.error((Object)"\u521d\u59cb\u5316\u7528\u6237\u9009\u62e9\u5386\u53f2\u5931\u8d25", (Throwable)e);
        }
    }

    private void updateHistory() {
        String layerName = this.comboLayer.getText();
        String solutionName = this.comboSolution.getText();
        String solutionPluginName = this.comboPlugin.getText();
        String userId = this.comboUser.getText();
        UserHistory userHistory = new UserHistory();
        userHistory.setLayerName(layerName);
        if (StringUtils.isNotBlank((String)solutionName)) {
            userHistory.setLastSolution(solutionName);
            if (StringUtils.isNotBlank((String)solutionPluginName)) {
                userHistory.setLastPlugin(solutionName, solutionPluginName, userId);
            }
        }
        userHistory.setLastUser(userId);
        this.historys.put(layerName, userHistory);
        new Thread(() -> {
            if (!this.historyFile.exists()) {
                this.historyFile.getParentFile().mkdirs();
            }
            JSONObject data = new JSONObject();
            for (String name : this.historys.keySet()) {
                data.put(name, (Object)this.historys.get(name).getNodeJSON());
            }
            try {
                FileUtils.writeStringToFile((File)this.historyFile, (String)data.toJSONString(), (Charset)StandardCharsets.UTF_8);
            }
            catch (Exception e) {
                log.error((Object)"\u4fdd\u5b58\u7528\u6237\u9009\u62e9\u5386\u53f2\u5931\u8d25", (Throwable)e);
            }
        }).start();
    }

    class UserHistory {
        private String layerName;
        private String lastUser;
        private String lastSolution;
        private Map<String, JSONObject> lastPlugins = new HashMap<String, JSONObject>();

        public UserHistory(JSONObject node) {
            this.layerName = node.getString("layerName");
            this.lastUser = node.getString("lastUser");
            this.lastSolution = node.getString("lastSolution");
            JSONObject lastPlugin = node.getJSONObject("lastPlugins");
            for (String appId : lastPlugin.keySet()) {
                this.lastPlugins.put(appId, lastPlugin.getJSONObject(appId));
            }
        }

        public UserHistory() {
        }

        public void setLayerName(String layerName) {
            this.layerName = layerName;
        }

        public void setLastUser(String lastUser) {
            this.lastUser = lastUser;
        }

        public void setLastSolution(String lastSolution) {
            this.lastSolution = lastSolution;
        }

        public void setLastPlugin(String appId, String lastPlugin, String lastUser) {
            JSONObject object = new JSONObject();
            object.put("lastPlugin", (Object)lastPlugin);
            object.put("lastUser", (Object)lastUser);
            this.lastPlugins.put(appId, object);
        }

        public String getLayerName() {
            return this.layerName;
        }

        public String getLastUser() {
            return this.lastUser;
        }

        public String getLastSolution() {
            return this.lastSolution;
        }

        public JSONObject getLastPlugin(String appId) {
            return this.lastPlugins.get(appId);
        }

        public JSONObject getNodeJSON() {
            JSONObject object = new JSONObject();
            object.put("layerName", (Object)this.layerName);
            object.put("lastUser", (Object)this.lastUser);
            object.put("lastSolution", (Object)this.lastSolution);
            object.put("lastPlugins", this.lastPlugins);
            return object;
        }
    }
}

