package client.gongqi.designer.event;

import java.util.ArrayList;
import java.util.List;

public class ValidationResultEvent {
	
	public static final String INVALID = "invalid";
	
	public List<ValidationResult> results = null;
	
	public static ValidationResultEvent validateNonBlank(String value){
		ValidationResultEvent resultEvent = new ValidationResultEvent();
		if("".equals(value)){
			List<ValidationResult> resultList =  new ArrayList<ValidationResult>();
			resultList.add(new ValidationResult("不能是空"));
			resultEvent.results = resultList;
			return resultEvent;
		}
		return resultEvent;
	}
	
	public static ValidationResultEvent positiveInteger(String value){
		ValidationResultEvent resultEvent = new ValidationResultEvent();
		if(!value.matches("[0-9]*")){
			List<ValidationResult> resultList =  new ArrayList<ValidationResult>();
			resultList.add(new ValidationResult("不能是非正整数"));
			resultEvent.results = resultList;
			return resultEvent;
		}
		return resultEvent;
	}
	
	public static ValidationResultEvent unNegativeInteger(String value){
		ValidationResultEvent resultEvent = new ValidationResultEvent();
		if(!value.matches("^\\d+$")){
			List<ValidationResult> resultList =  new ArrayList<ValidationResult>();
			resultList.add(new ValidationResult("不能是非负整数"));
			resultEvent.results = resultList;
			return resultEvent;
		}
		return resultEvent;
	}
	
	public static ValidationResultEvent integer(String value){
		ValidationResultEvent resultEvent = new ValidationResultEvent();
		if(!value.matches("^[-\\+]?[\\d]*$")){
			List<ValidationResult> resultList =  new ArrayList<ValidationResult>();
			resultList.add(new ValidationResult("不能是非整数"));
			resultEvent.results = resultList;
			return resultEvent;
		}
		return resultEvent;
	}

	public ValidationResultEvent() {

	}
	
	public ValidationResultEvent(String INVALID) {
//		List<ValidationResult> resultList =  new ArrayList<ValidationResult>();
//		resultList.add(new ValidationResult(INVALID));
//		this.results = resultList;
	}
}
