package client.gongqi.designer.got.node;

import gongqi.designer.services.LayerService;
import gongqi.designer.utils.GOTHelper;
import gongqi.erp.framework.core.ObjectContainer;
import gongqi.erp.gotmodel.core.EntityType;
import info.gongqi.got.ui.LoadXmlCore;
import info.gongqi.got.util.GOTMessageDialog;

import org.dom4j.Element;
import org.eclipse.swt.SWT;
import org.eclipse.swt.widgets.MessageBox;

import client.gongqi.designer.toolsgot.GOTXMLHelper;

public class DataTypes extends Outer{

	public DataTypes(){
		super();
	}
	
	@Override
	public NodeGOT getAccpDragNewNode(Element src){
		NodeGOT node ;
		if(src.getName().equals("TableField")){
			node = super.doAccpDragNew("DataType", src.attributeValue("type"));
			this.doAccpDragNewAfer(src, node.xml);
			return node;
		}
		return null;
	} 
	
	@SuppressWarnings("unused")
	private void doAccpDragNewAfer(Element src, Element node){
		Element targetPro ;
		Element stringSizePro = GOTHelper.getProperty(src, "StringSize");
		if(stringSizePro != null){
			targetPro = GOTHelper.getProperty(node,"StringSize");
			GOTXMLHelper.setProperty(node,"StringSize", stringSizePro.elementText("Value"), true);
		}
		
		Element numOfDecimalsPro = GOTHelper.getProperty(src,"NumOfDecimals");
		if(numOfDecimalsPro != null){
			targetPro = GOTHelper.getProperty(node,"NumOfDecimals");
			GOTXMLHelper.setProperty(node,"NumOfDecimals", numOfDecimalsPro.elementText("Value"), true);
		}
		
		Element displayLengthProSrc = GOTHelper.getProperty(src,"DisplayLength");
		if(displayLengthProSrc != null){
			targetPro = GOTHelper.getProperty(node,"DisplayLength");
			GOTXMLHelper.setProperty(node,"DisplayLength", displayLengthProSrc.elementText("Value"), displayLengthProSrc.elementText("Value").equals("") ? false : true);
		}
		
		Element labelPro = GOTHelper.getProperty(src,"Label");
		if(labelPro != null){
			targetPro = GOTHelper.getProperty(node,"Label");
			GOTXMLHelper.setProperty(node,"Label", labelPro.elementText("Value"), labelPro.elementText("Value").equals("") ? false : true);
		}
		node.attribute("name").setValue(src.attributeValue("name"));
		
		if(src.attributeValue("type").equals("String")){
			MessageBox messagebox = new MessageBox(GOTMessageDialog.shell, SWT.ICON_QUESTION
	                | SWT.YES | SWT.NO);
	        messagebox.setText("提示");
	        messagebox.setMessage("是否自动加入主表关联") ;
	        int message = messagebox.open();
	        addMainTableHandler(message, src, node);
		}
	} 
	
	private void addMainTableHandler(int event, Element src, Element node){
		if(event == SWT.YES){ 
			Element relation = node.element("DataTypeRelation");
			if(relation == null){
				relation = GOTXMLHelper.dataTypeRelationXML.createCopy();
				String currentLayer = ObjectContainer.getInstance(LayerService.class).getCurrentLayer();
				relation.addAttribute("createdLayer", currentLayer);
				relation.addAttribute("modifiedLayer", currentLayer);
				node.add(relation.detach());
			}
			if(relation != null){
				Element tablePro = GOTHelper.getProperty(relation,"Table");
				Element srcEntity = NodeGOT.getEntity(src);
				if(tablePro != null){
					if(tablePro.element("Value") == null){
						tablePro.addElement("Value");
					}
					tablePro.element("Value").setText(srcEntity.attributeValue("name"));
					tablePro.addAttribute("refentityid", srcEntity.attributeValue("id"));
				}
				Element fieldPro = GOTHelper.getProperty(relation, "Field");
				fieldPro.addAttribute("refentityid", srcEntity.attributeValue("id"));
				fieldPro.addAttribute("refinnerid", src.attributeValue("id"));
				fieldPro.element("Value").setText(src.attributeValue("name"));
//				NodeGOT relationItemNode = NodeFactory.createNode("DataTypeRelationItem","Normal","");
//				Element rinXML = relationItemNode.xml;
				
//				rinXML.addAttribute("id", "1");
//				node.addAttribute("nextInnerId", "2");
//				Element fieldPro = GOTHelper.getProperty(rinXML, "Field");
				
//				fieldPro.addAttribute("refentityid", srcEntity.attributeValue("id"));
//				fieldPro.addAttribute("refinnerid", src.attributeValue("id"));
//				if(fieldPro.element("Value") == null){
//					fieldPro.addElement("Value");
//				}
//				fieldPro.element("Value").setText(src.attributeValue("name"));
//				
//				rinXML.addAttribute("name", "this=="+srcEntity.attributeValue("name")+"."+ src.attributeValue("name"));
//				relation.add(rinXML.detach());
			}
		}
	}
	
	@Override
	public String getAccpDragNewInsertBase(){
		return "self";
	}
	
	@Override
	public String validateAccpDragNew(Element srcItem){
		if(srcItem.getName().equals("TableField")){
			Element extendsPro = GOTHelper.getProperty(srcItem,"Extends");
			if(extendsPro.attribute("refentityid") != null)
				return "TableField节点已存在继承关系";
		}
		
		String type = srcItem.attributeValue("type");
		if(type.equals("Enum") || type.equals("Component"))
			return "当前类型不支持拖动产生DataType";
		
		return "true";
	}
	
	@Override
	public void doAfterDragDroped(){
		String id = "";
		try {
			id = LoadXmlCore.gotServices.getEntityId(EntityType.DataType);
		} catch (Exception e) {
			e.printStackTrace();
			GOTMessageDialog.alert(e);
		}
		this.xml.addAttribute("id", id);
		
	}
	
}
