package client.gongqi.designer.got.node;

import java.util.List;

import org.dom4j.Element;

import client.gongqi.designer.event.ValidationResult;
import client.gongqi.designer.event.ValidationResultEvent;
import client.gongqi.designer.remote.RemoteService;
import client.gongqi.designer.toolsgot.Macros;
import gongqi.designer.services.LayerService;
import gongqi.erp.framework.core.ObjectContainer;

public class Entity extends NodeGOT{
	
	public static void sync(Element node){
		RemoteService.callBackWithoutArg("", "gongqi.designer.services.GOTService", "syncEntity", "String", node.asXML());
	}

	public Object save(){
		return null;	
	}
	
	public String validateBeforeSave(){
		if(this.xml.attribute("saved") == null)
			return "tree" + Macros.INFO_VALUE_NOTCHANGED;
		 
		String result ;
		result = this.validateAttributes();
		if(!result.equals("true")){
			return "tree" + result.substring(5);
		}
		
		result = this.validateProperties(this.xml);
		if(!result.equals("true")){
			return "grid" + result.substring(5) ;	
		}
		
		result = this.validateOther();
		if(!result.equals("true")){
			return "tree" + result.substring(5);
		}
		
		return Macros.INFO_TRUE;
	}
	
	public String validateBeforePromote(){
		return Macros.INFO_TRUE;
	}
	
	protected String validateAttributes(){
		return "true";
	}
	
	protected Boolean isNeedValidateOnSave(Element property){
		return true;
	}
	
	@SuppressWarnings("unchecked")
	protected String validateProperties(Element nodeBeValidated){
		String path = "Properties/Property";
		List<Element> propertyList = nodeBeValidated.selectNodes(path);
		
		NodeGOT node = NodeFactory.getNode(nodeBeValidated);
		
		List<ValidationResult> array = null ;
		
		ValidationResultEvent resultEvent;
		
		List<Element> childList = nodeBeValidated.elements();
		
		String result = "" ;
		
		//根据解析器针对单个property进行验证
		for (Element property : propertyList){
			//暂时先这样去除保存时对Extends和SubForm的验证
			if(property.elementText("Name").equals("Extends") || property.elementText("Name").equals("SubForm")){
				continue ;	
			}
			
			if(property.elementText("Name").equals("CreatedDate") ){
				break ;
			}
			
			if(!isNeedValidateOnSave(property))
				continue;
			
			resultEvent = node.validateProperty(property) ;
			
			if(resultEvent!=null){
				
				array = resultEvent.results ;	
			}				
			
			if(array!=null){
				for (ValidationResult r: array){
					result += property.elementText("Name") + "属性 值为" + property.elementText("Value") + ":" + r.getErrorMessage();
				}
				return "false"+result ;
			}
		}
		
		for(Element child : childList){
			if(child.getName().equals("Properties")){
				continue ;
			}
			result = validateProperties(child);
			if(!result.equals("true")){
				return result;
			}
		}
		
		return "true" ;
	}
	
	@Override
	public void doBeforeInsert(){
		
	}
	
	protected String validateOther(){
		return "true"; 
	}
	
	@Override
	public String validateDelete(){
		if(xml.attribute("saved") != null  && !xml.attributeValue("version").equals("0")){
			return Macros.INFO_FALSE + ":" + "编辑状态不允许删除";	
		}
		
		String currentLayer = ObjectContainer.getInstance(LayerService.class).getCurrentLayer();
		
		if(!xml.attributeValue("createdLayer").equals(currentLayer)){
			if(xml.attribute("locked") != null  && xml.attributeValue("locked").equals("true")){
				return Macros.INFO_FALSE + ":" + "该节点已被下层锁定";
			}	
		}
		
		return super.validateDelete();
	}
	
	@Override
	public String allowEdit(){
		String superresult = super.allowEdit();
		String currentLayer = ObjectContainer.getInstance(LayerService.class).getCurrentLayer();
		if(superresult.equals("true")){
			if(xml.attribute("locked") != null && xml.attributeValue("locked").equals("true") &&
				xml.attribute("createdLayer") != null  && !xml.attributeValue("createdLayer").equals(currentLayer) )
				superresult = "该节点已被下层锁定 不可编辑";
		}
		
		return superresult;
	}
}
