package client.gongqi.designer.got.node;

import java.util.List;

import org.dom4j.Element;

import client.gongqi.designer.toolsgot.Macros;
import gongqi.designer.services.LayerService;
import gongqi.erp.framework.core.ObjectContainer;
import info.gongqi.got.tool.GOTHelp;

public class Inner extends NodeGOT{

	public String validateNewNameString = "Locked Plan select from where updata delete having join";
	
	@Override
    public void doAfterNameModified(String oldName){
		super.doAfterNameModified(oldName);
		this.updateRelationNameInEntity();
	}
	
	protected  void updateRelationNameInEntity(){
		 
		String name = this.xml.attributeValue("name");
		
		List<Element> proList = this.getRelationInEntity();
		
		NodeGOT node = null;
		if(proList != null){ 
			for (Element pro : proList){
				pro.element("Value").setText(name); 
				node = NodeFactory.getNode(pro.getParent().getParent());
				if(node instanceof Inner){
					Inner inner = (Inner) node;
					inner.doPropertyTrigger(pro);
				}
			}
		}
	}
	
	@SuppressWarnings("unchecked")
	protected List<Element> getRelationInEntity(){
		String _id = this.xml.attributeValue("id");
		Element entity = NodeGOT.getEntity(this.xml);
		String xpath = ".//Property[@innerid='" + _id + "']" ;
		return entity.selectNodes(xpath);
	}
	
	@Override
	protected void doPropertyTrigger(Element property){
		super.doPropertyTrigger(property);
		this.changeNameByProperty(property);
	}
	
	protected void changeNameByProperty(Element property){
		String propertyName = property.elementText("Name");
		String triggers = rNode.getPropertyValue(propertyName,"Trigger");
		if("".equals(triggers) || triggers == null){
			return ;
		}
		//此处|为特殊字符需要转义
		String[] strs = triggers.split("\\|");
		for (String trigger : strs){
			String attrName = trigger.substring(0,trigger.indexOf("=",0));
			String triggerValue = trigger.substring(trigger.indexOf("=")+1);
			String[] array = triggerValue.split("");
			String text = "";
			String temp = "" ;
			Boolean flag = false ;
			for (String c : array){
				if(c.equals("(")){
					temp +=c ;
					flag = true;
					continue;
				}
				if(c.equals(")")){
					temp = temp.substring(1);
					if(temp.length() >6 && temp.substring(0,6).equals("parent")){
						temp = temp.substring(7);
						Element parent = this.xml.getParent();
						for (String s: temp.split("\\.")){
							if(s.equals("parent")){
								parent = parent.getParent() ;
							}else{
								temp = s ;
								break;
							}
						}
						if(temp.indexOf("@") == -1){
							text += GOTHelp.getPPAttValue(parent, "Name", temp);
						}else{
							text += parent.attributeValue(temp.replace("@", ""));
						}
					}else{
						if(temp.indexOf("@") == -1){
							text += GOTHelp.getPPAttValue(this.xml, "Name", temp);
						}else{
							text +=this.xml.attributeValue(temp.replace("@", ""));
						}
					}
					temp = "";
					flag = false;
					continue ;
				}
				
				if(flag){
					temp+=c ;
					continue ;
				}
				
				text += c ;
			}
			if(attrName.indexOf("@")>=0){
				String attr = attrName.replace("@", "");
				if(("FormDataSource".equals(this.xml.getName()) || "MenuItemButton".equals(this.xml.attributeValue("type"))) && attr.equals("name") && text.contains(".")){
					String[] temp_name = text.split("\\.");
					text = temp_name[temp_name.length -1 ];
					if("MenuItemButton".equals(this.xml.attributeValue("type"))){
						text = "MenuItem_" + text;
					}
				}
				if(("MenuRefMenuItem".equals(this.xml.getName()) || "DataTypeArrayItem".equals(this.xml.getName())) && text.contains(".")){
					String[] temps = text.split("\\.");
					text = temps[temps.length - 1];
				}
				if("DataTypeArrayItem".equals(this.xml.getName()) && text.contains("_")){
					text = text.replace("_", "");
				}
				this.xml.attribute(attr).setValue(text);
				if(!this.validateNewName(text)){
					NodeGOT.setBrotherUniqueName1(this.xml);
				}
			}else{
				GOTHelp.getPPAttElement(this.xml, "Name", attrName).element("Value").setText(text);
			}
		}
	}
	
	@Override
    public String validateDelete(){
		String superResult = super.validateDelete();
		if(!superResult.equals(Macros.INFO_TRUE))
			return superResult;
		
		List<Element> list = this.getRelationInEntity();
		if(list == null || list.size() == 0){
			return Macros.INFO_TRUE;
		}else{
			String result = Macros.INFO_FALSE;
			Element item;
			for(Element xml : list){
				item = xml.getParent().getParent() ;
				result += "\n" +  "innerId Ref: " + item.getName() + "-->" + item.getName() ;
			}
			return result;
		}
	}
	
	@Override
	public String allowEdit(){
		String result = super.allowEdit();
		String currentLayer = ObjectContainer.getInstance(LayerService.class).getCurrentLayer();
		if(result.equals("true")){
			Element entity = NodeGOT.getEntity(this.xml);
			if(entity.attribute("locked") != null  && entity.attributeValue("locked").equals("true") &&
					entity.attribute("createdLayer") != null && !entity.attributeValue("createdLayer").equals(currentLayer))
				return "该节点已被下层锁定 不可编辑";
		}
		return result;
	}
	
}
