package client.gongqi.designer.got.node;

import gongqi.designer.core.LayerLevelManager;
import gongqi.designer.services.LayerService;
import gongqi.designer.utils.GOTHelper;
import gongqi.erp.framework.core.LayerConstants;
import gongqi.erp.framework.core.ObjectContainer;
import gongqi.erp.framework.core.plugin.SolutionPluginDefinition;
import gongqi.erp.framework.core.plugin.SolutionPluginDefinitionManager;
import info.gongqi.got.model.GotXmlDto;
import info.gongqi.got.tool.GOTHelp;
import info.gongqi.got.tool.GotLayerAndUserDialog;
import info.gongqi.got.tool.TreeOperationInfo;
import info.gongqi.got.util.FromToMapping;
import info.gongqi.got.util.GOTMessageDialog;

import java.util.ArrayList;
import java.util.List;
import java.util.regex.Pattern;

import org.apache.commons.lang.StringUtils;
import org.dom4j.Attribute;
import org.dom4j.Element;
import org.dom4j.Node;
import org.eclipse.swt.events.MouseEvent;

import client.gongqi.designer.ResovlerContextMenuValue;
import client.gongqi.designer.clientsession.LayerType;
import client.gongqi.designer.event.ValidationResult;
import client.gongqi.designer.event.ValidationResultEvent;
import client.gongqi.designer.resolvergot.ResolverNode;
import client.gongqi.designer.resolvergot.ResolverNodeFactory;
import client.gongqi.designer.toolsgot.GOTXMLHelper;
import client.gongqi.designer.toolsgot.Macros;

import com.alibaba.fastjson.JSONObject;

public class NodeGOT {

//	public static Element gotXML;//全局记录根点节
//	public static String gotXMLString;
	public static List<Element> arrayDataType = null;
	public static List<String> arrayEnum = null ;
	public ResolverNode rNode;
	public Element xml;
	private String refentityId;
	
	public String getRefentityId() {
		return refentityId;
	}

	public void setRefentityId(String refentityId) {
		this.refentityId = refentityId;
	}

	//所有节点默认的接受拖拽的动作都是新建 子类可以覆写get方法重新指定
	//同级节点的拖动，在GOT_Control中已处理，不在此处处理
	public String getDragAccpAction(){
		return "new" ;
	}
	
	public NodeGOT(){

	}
	
	public final void createXml(String id){
		this.xml = GOTXMLHelper.createElement(rNode.getNode().attributeValue("name"));

		this.createAttriubtes(id);
		this.createProperties();
		this.createChildren();
	}
	
	private void createAttriubtes(String id){
		List<Element> array = rNode.getAttributes();
		
		if(rNode.getInfoValue("NodeType").equals("entity")){
			this.xml.addAttribute("saved", "0");
		}
		
		for (Element attr : array){
			if("optional".equals(attr.elementText("Use"))){
				continue ;
			}
			if(attr.elementText("Name").equals("id")){
				if(id != null){
					xml.addAttribute("id", id);
				}
			}else if(attr.element("Name").getText().equals("type")){
				xml.addAttribute("type", rNode.getInfoValue("Type"));
			}else if(attr.element("Name").getText().equals("name")){
				xml.addAttribute("name", this.getDefaultAttrName(attr));
			}else if(attr.element("Name").getText().equals("createdLayer")){
				xml.addAttribute("createdLayer", ObjectContainer.getInstance(LayerService.class).getCurrentLayer());
			}else if(attr.element("Name").getText().equals("modifiedLayer")){
				xml.addAttribute("modifiedLayer", ObjectContainer.getInstance(LayerService.class).getCurrentLayer());
			}else{ //此处假设attr.Default必为常量
				xml.addAttribute(attr.elementText("Name"), attr.element("Default").getText());
				
			}
		}
	}
	
	protected String getDefaultAttrName(Element attr){
		return attr.element("Default").getText(); 
	}
	
	private void createProperties(){
		this.setProperties();
		if(rNode.getInfoValue("NodeType").equals("entity")){
			GOTXMLHelper.addDateAndTime(xml);
		}
	}
	
	public String validateDelete(){
		String currentLayer = ObjectContainer.getInstance(LayerService.class).getCurrentLayer();
//		LayerDefinationManager s = ObjectContainer.getInstance(LayerDefinationManager.class);
//		String layerDeploymentMode = s.getLayer(currentLayer).getDeploymentMode().name();
//		if(layerDeploymentMode.equals(LayerType.PACKAGE))
//			return Macros.INFO_FALSE+ ":当前层是二进制层";
		
		if(this.xml.attribute("createdLayer") != null  && 
				!this.xml.attributeValue("createdLayer").equals(currentLayer))
			return Macros.INFO_FALSE + ":" + "非当前层节点不能删除";
		
		return Macros.INFO_TRUE;
	}
	
	public String validateRollback(){
		return Macros.INFO_TRUE;
	}
	
	private void createChildren(){
		
		@SuppressWarnings("unchecked")
//		List<Element> childList = rNode.getNode().selectNodes(".//node") ;
		List<Element> childList = rNode.getNode().elements("node") ;
		if(childList.size()>0){
			ResolverNode childrNode;
			for (Element child : childList){
				//Type没有继承关系child.Info.Type
				childrNode = ResolverNodeFactory.getRNode(child.attributeValue("name"),child.element("Info").elementText("Type")); 
					//new ResolverNode(child.@name,child.Info.Type);
				//0不自动新建， 大于1的情况暂时认为没有
				if(childrNode.getInfoValue("MinOccurs").equals("1")){
					String id = "";
					NodeGOT childNode = NodeFactory.createNode(child.attributeValue("name"), child.element("Info").elementText("Type"), id);
					//暂时认为只有append这种情况
					this.xml.add(childNode.xml.detach());
				}
			}
		}
	}
	
	private String getNextInnerId(){
		Element xmlEntity = NodeGOT.getEntity(xml);
		String result = xmlEntity.attributeValue("nextInnerId");
		int maxInnerId = Integer.valueOf(result);
		maxInnerId ++ ;
		xmlEntity.addAttribute("nextInnerId", String.valueOf(maxInnerId));
		return result;
	}
	
	//实现了新建节点名字Brother范围内唯一
	public void doAfterInsert(){
		String unique = this.rNode.getAttributeValue("name","Unique") ;

		if("brother".equals(unique)){
			setBrotherUniqueName(xml);
		}else if("inner".equals(unique)){
			setInnerUniqueName(xml);
		}
		
		if(xml.attribute("saved") != null){
			xml.remove(xml.attribute("saved"));
		}
		
		this.setUnsaved();
		this.setInnerId(this);

	}
	
	private void setInnerId(NodeGOT node){
		@SuppressWarnings("unchecked")
		List<Element> childList = node.xml.elements();
		ResolverNode childrNode = node.rNode ;
		if("##getInnerId".equals(childrNode.getAttributeValue("id", "Default"))){
			node.xml.addAttribute("id", node.getNextInnerId());
		}
		for (Element child : childList){
			if(child.getName().equals("Properties")){
				continue ;
			}
			setInnerId(NodeFactory.getNode(child));
		}		
	}
	
/*	private Boolean validateInnerUniqueName(String _name){
		String xpath = "./descendant::*[@name]";
		@SuppressWarnings("unchecked")
		List<Element> itemList = NodeGOT.getEntity(this.xml).selectNodes(xpath);;
		for(Element item : itemList){
			if(item.attributeValue("name").toLowerCase().equals(_name.toLowerCase()) && item != this.xml){
				return false;
			}
		}
		return true;
	}*/
	
	protected void setInnerUniqueName(Element newNode){
		String origName = newNode.attributeValue("name");
		if(origName.equals("")){
			origName = "A_" + this.xml.getName();
		}
		String temp = origName ;
		String xpath = "./descendant::*[@name]";
		@SuppressWarnings("unchecked")
		List<Element> itemList = NodeGOT.getEntity(this.xml).selectNodes(xpath);
		int last = 0;
		boolean same = false;
		for (Element child : itemList){
			if(child != this.xml){
				if(child.attribute("name") != null){
					String attrName = child.attributeValue("name");
					if(attrName.startsWith(origName)){
						if(attrName.equals(origName)){
							same = true;
						}
						attrName = attrName.replace(origName, "");
						if(isNumber(attrName)){
							int num = Integer.valueOf(attrName);
							if(num > last){
								last = num;
							}
						}
					}
				}
			}
		}
		
		if(last > 0){
			last ++;
			temp = origName + last;
		}else if(same){
			temp = origName + 1;
		}
		
//		int i = 1;
//		while(!validateInnerUniqueName(newName)){
//			newName = origName + i;
//			newNode.attribute("name").setValue(newName);
//			i++;
//		}
		newNode.attribute("name").setValue(temp);
		return;
	}
	
	public static void setBrotherUniqueName1(Element newNode){
		String origName = newNode.attributeValue("name");
		String newName;
		//ZSG 如果非实体节点名字有点 则舍弃
		if(!isEntity(newNode)){
			if(!newNode.getName().equals("FormDataSourceField") && !newNode.getName().equals("FormDataSourceRelationItem")){
				if(origName!=null && origName.contains(".")){
					origName = origName.substring(origName.indexOf(".")+1);
				}
			}

		}
		
		//此时即使没有Name为Extends的Property 也不会出错 而是返回“”
		String strExtends = GOTHelp.getPPAttValue(newNode, "Name", "Extends");
		if(strExtends.equals("")){
			if(origName == ""){
				newName	= "A_" + newNode.getName();
			}else{
				newName = origName ;
			}
		}else{
			if(origName.equals("") || origName.contains(newNode.getName())){
				newName	= strExtends;
			}else{
				newName = origName ;
			}
		}
		
		String temp = newName;
		Element parent = newNode.getParent();

		if(checkParentNodes(parent)){
			List<String> names = GotXmlDto.getInstance().typesNameList(newNode.getName(), newNode.attributeValue("id"));
			int last = 0;
			boolean same = false;
			for (String name : names){
				if(name.startsWith(newName)){
					if(name.equals(newName)){
						same = true;
					}
					name = name.replace(newName, "");
					if(isNumber(name)){
						int num = Integer.valueOf(name);
						if(num > last){
							last = num;
						}
					}
				}
			}
			
			if(last > 0){
				last ++;
				temp = newName + last;
			}else if(same){
				temp = newName + 1;
			}
			newNode.attribute("name").setValue(temp);
		}else{
			List<Element> childList = parent.elements(newNode.getName());
			int last = 0;
			boolean same = false;
			for (Element child : childList){
				if(child != newNode){
					if(child.attribute("name") != null){
						String attrName = child.attributeValue("name");
						if(attrName.startsWith(newName)){
							if(attrName.equals(newName)){
								same = true;
							}
							attrName = attrName.replace(newName, "");
							if(isNumber(attrName)){
								int num = Integer.valueOf(attrName);
								if(num > last){
									last = num;
								}
							}
						}
					}
				}
			}
			
			if(last > 0){
				last ++;
				temp = newName + last;
			}else if(same){
				temp = newName + 1;
			}
			newNode.attribute("name").setValue(temp);
		}
	}
	
	@SuppressWarnings("unchecked")
	public void setBrotherUniqueName(Element newNode){
		String origName = newNode.attributeValue("name");
		String newName;
		//此时即使没有Name为Extends的Property 也不会出错 而是返回“”
		String strExtends = GOTHelp.getPPAttValue(newNode, "Name", "Extends");
		if(newNode.getName().equals("TableField") && strExtends.contains(".")){
			String[] name = strExtends.split("\\.");
			strExtends = name[name.length - 1];
		}
		if(strExtends.equals("")){
			if(origName.equals("")){
				newName	= "A_" + newNode.getName();
				if(newNode.attribute("version") != null){
					if(GotLayerAndUserDialog.layer.equals("app") || GotLayerAndUserDialog.layer.equals("ext")){
						if(StringUtils.isNotBlank(GotLayerAndUserDialog.solution)){
							newName = GotLayerAndUserDialog.solution + ".A_" + newNode.getName();
						}
					}
				}
			}else{
				newName = origName ;
			}
		}else{
			if(origName.equals("")  || origName.contains(newNode.getName())){
				newName	= strExtends;
			}else{
				newName = origName ;
			}
		}
		
		String temp = newName;
		Element parent = newNode.getParent();
		
		if(checkParentNodes(parent)){
			List<String> names = GotXmlDto.getInstance().typesNameList(newNode.getName(), newNode.attributeValue("id"));
			int last = 0;
			boolean same = false;
			for (String name : names){
				if(name.startsWith(newName)){
					if(name.equals(newName)){
						same = true;
					}
					name = name.replace(newName, "");
					if(isNumber(name)){
						int num = Integer.valueOf(name);
						if(num > last){
							last = num;
						}
					}
				}
			}
			
			if(last > 0){
				last ++;
				temp = newName + last;
			}else if(same){
				temp = newName + 1;
			}
			newNode.attribute("name").setValue(temp);
		}else{
			List<Element> childList = parent.elements(newNode.getName());
			int last = 0;
			boolean same = false;
			for (Element child : childList){
				if(child != newNode){
					if(child.attribute("name") != null){
						String attrName = child.attributeValue("name");
						if(attrName.startsWith(newName)){
							if(attrName.equals(newName)){
								same = true;
							}
							attrName = attrName.replace(newName, "");
							if(isNumber(attrName)){
								int num = Integer.valueOf(attrName);
								if(num > last){
									last = num;
								}
							}
						}
					}
				}
			}
			
			if(last > 0){
				last ++;
				temp = newName + last;
			}else if(same){
				temp = newName + 1;
			}
			newNode.attribute("name").setValue(temp);
		}
	}
	
	public static boolean checkParentNodes(Element parent){
		if(parent == null || parent.getName().equals("Forms") || parent.getName().equals("Tables") || 
				parent.getName().equals("Menus") || parent.getName().equals("Enums") || parent.getName().equals("DataTypes") || parent.getName().equals("Classes")){
			return true;
		}
		return false;
	}
	
	public static boolean isNumber(String string) {
        if (string == null)
            return false;
        Pattern pattern = Pattern.compile("^-?\\d+(\\.\\d+)?$");
        return pattern.matcher(string).matches();
    }

	
	public String getInsertAt(){
		return this.rNode.getInfoValue("InsertAt");
	}
	
	public void doAfterNameModified(String oldName){
		this.setUnsaved();
	}
	
	@SuppressWarnings({"unchecked" })
	protected void addRelation(Element property){

		String propertyName = property.elementText("Name");
		
		String regular;
		
		String propertyValue = property.elementText("Value");
		
		Element baseXML;
		
		List<Element> result = null;
		
		String _rType = rNode.getPropertyValue(propertyName, "Type");
		if("enum".equals(_rType) || "comboBox".equals(_rType)){
			if(_rType.equals("comboBox")){
				if(propertyValue.indexOf("dt:")==0 || propertyValue.indexOf("lookup:")==0){
					List<Attribute> attributes = new ArrayList<>();
					attributes.addAll(property.attributes());
					for (Attribute attribute : attributes) {
						property.remove(attribute);
					}
					return;
				}
			}
			
			if(this.xml.getName().equals("FormItem") && propertyName.equals("DynamicColumn")){
				if(propertyValue.equals("")){
					if(property.attribute("innerid") != null){
						property.remove(property.attribute("innerid"));
						return;
					}
				}
				String xpath = "./FormItem[@name='" + propertyValue + "']";
				result = this.xml.selectNodes(xpath);
				if(result.size() == 0 || result.size() > 1){
					GOTMessageDialog.alert("entity节点间关联结果不唯一");
				}
				
				if(result.size()==1){
					property.addAttribute("innerid", result.get(0).attributeValue("id"));
				}
				return;
			}
			
			regular = rNode.getPropertyValue(propertyName,"Regular");
			
			if(regular.equals("")){
				return ;
			}else{
				if(regular.substring(0,2).equals("##")){
					regular = regular.substring(2);
					if(propertyValue.equals("")){
						List<Attribute> attributes = new ArrayList<>();
						attributes.addAll(property.attributes());
						for (Attribute attribute : attributes) {
							property.remove(attribute);
						}
						return;
					}
					
					//节点内关联
					if(regular.substring(0,7).equals("entity.")){
						baseXML = NodeGOT.getEntity(this.xml).createCopy();
						regular = regular.substring(7);
						regular += "[@name='" +propertyValue + "']";
						regular = regular.substring(regular.indexOf("/") + 1);
						result = baseXML.selectNodes(regular);
						if(result.size() == 0 || result.size() > 1){
							GOTMessageDialog.alert("entity内关联结果不唯一");
						}
						
						if(result.size() == 1 ){
							property.addAttribute("innerid", result.get(0).attributeValue("id"));
						}
					}else if(regular.substring(0,6).equals("parent") || regular.substring(0,7).equals("brother")){
						Element parent = this.xml.getParent();
						String proName = "" ;
						String temp = regular.substring(regular.indexOf(".",0)+1,regular.lastIndexOf("."));
						String[] parentArray = temp.split(".");
						for(String s: parentArray){
							if(s.equals("parent")){
								parent = parent.getParent();
							}else{
								proName = s ;
								break ;
							}
						}
						Element refPro = GOTHelp.getPPAttElement(parent, "Name", proName);
						if(refPro.attribute("refentityid") == null){
							GOTMessageDialog.alert("Inner节点间关联 父节点无refentityid");
							return ;
						}
						String refEntityId = refPro.attributeValue("refentityid");
						String basePath = "GOT/";
						basePath += ResolverNodeFactory.getRNodeByItem(parent).getPropertyValue(proName, "Regular").substring(2);
						basePath += "[@id=" +refEntityId+ "]";
						regular = regular.substring(regular.indexOf("/"));
						if(regular.indexOf("[") == -1){
							regular = basePath + regular + "[@name='" +property.getText()+ "']";
						}else{
							regular = basePath + regular.substring(0,regular.length()-1) + " and @name='" +property.getText()+ "']";
						}
						result = GotXmlDto.getInstance().getGotXMl(regular);
						if(result.size() == 0 || result.size()>1){
							GOTMessageDialog.alert("inner节点间关联结果不唯一" + result.toString());
						}
						
						if(result.size()==1){
							property.addAttribute("refentityid", refEntityId);
							property.addAttribute("refinnerid", result.get(0).attributeValue("id"));
							
						}
						
					}else if(regular.substring(0,4).equals("this")){
						regular = regular.substring(regular.indexOf(".")+1);
						String proName = regular.substring(0,regular.indexOf("."));
						Element refPro = GOTHelp.getPPAttElement(this.xml, "Name", proName);
						if(refPro.attribute("refentityid") == null){
							GOTMessageDialog.alert("Inner节点间关联 无refentityid");
							return ;
						}
						String refEntityId = refPro.attributeValue("refentityid");
//						String basePath = "./";
//						basePath += ResolverNodeFactory.getRNodeByItem(this.xml).getPropertyValue(proName, "Regular").substring(2);
//						basePath += "[@id='" +refEntityId+ "']";
						Element baseEntity = GotXmlDto.getInstance().getEntity(refEntityId);
						regular = regular.substring(regular.indexOf("/"));
						if(regular.indexOf("[") == -1){
							regular = regular + "[@name='" +property.elementText("Value") + "']";
						}else{
							regular = regular.substring(0,regular.length()-1) + " and @name='" + property.elementText("Value")+ "']";
						}
						result = baseEntity.selectNodes(regular);
						if(result.size() == 0 || result.size()>1){
							GOTMessageDialog.alert("inner节点间关联结果不唯一" + result.toString());
						}
						if(result.size()==1){
							property.addAttribute("refentityid", refEntityId);
							property.addAttribute("refinnerid", result.get(0).attributeValue("id"));
						}
					}else {
						regular = "./" + regular;
						if(regular.indexOf("[") == -1){
							regular += "[@name='" + property.elementText("Value")+ "']" ;
						}
						else{
							regular = regular.substring(0,regular.length() - 1);
							regular += " and @name='" +property.elementText("Value") + "']";
						}
						result = GotXmlDto.getInstance().getGotXMl(regular);
						if(result.size() == 0 || result.size() > 1){
							GOTMessageDialog.alert("entity节点间关联结果不唯一");
						}
						
						if(result.size()==1){
							property.addAttribute("refentityid", result.get(0).attributeValue("id"));
						}
					}
				}
			}
		}
		
	}
	
	public void doAfterPropertyModified(Element property, String...args){
		this.setUnsaved();
		
		this.addRelation(property);
		
		this.doIfExtendsAndFecth(property);
		
		this.doPropertyTrigger(property);
		
		//TODO 刷新map中的xml、此处注销
//		GotXmlDto.getInstance().updateEntityElement(getEntity(xml));
	}
	
	protected void setIfExtends(Element item, ResolverNode rNode){
		@SuppressWarnings("unchecked")
		List<Element> pps = item.element("Properties").elements("Property");
		if(StringUtils.isNotBlank(this.getRefentityId()) && item.getName().equals("TableField")){
			Element dataType = GotXmlDto.getInstance().currentEntityByTypeAndId("DataType", this.getRefentityId());
			for (Element property : pps){
				if(property.elementText("Name").equals("CreatedDate"))
					break;
				if(rNode.getPropertyValue(property.elementText("Name"),"Nonblank").equals("ifExtends"))
					property.element("Value").setText(GOTHelp.getPPAttValue(dataType, "Name", property.elementText("Name")));
			}
		}else{
			for (Element property : pps){
				if(property.elementText("Name").equals("CreatedDate"))
					break;
				if(rNode.getPropertyValue(property.elementText("Name"),"Nonblank").equals("ifExtends"))
					property.element("Value").setText(this.rNode.getPropertyValue(property.elementText("Name"), "Default"));
			}
		}

	}
	
	/**
	 * 继承之后清除或者设置部分属性，调用此方法
	 * @param item 节点
	 * @param rNode 解析器
	 */
	protected void clearIfExtends(Element item, ResolverNode rNode){
		@SuppressWarnings("unchecked")
		List<Element> pps = item.element("Properties").elements("Property");
		for(Element property : pps){
			if(property.elementText("Name").equals("CreatedDate"))
				break;
			if("ifExtends".equals(rNode.getPropertyValue(property.elementText("Name"),"Nonblank")))
				property.element("Value").setText("");
			if("fetch".equals(rNode.getPropertyValue(property.elementText("Name"),"Nonblank"))){
				List<Element> extendsPro = GOTHelp.getPPAttElementList(item, "Name", "Extends"); 
				if(extendsPro.isEmpty() || extendsPro.size()==0)
					throw new Error("fetch不被关联到Extends");
				if(extendsPro.get(0).attribute("refentityid") != null){
					try{
						property.element("Value").setText(getFetchFinalValue(extendsPro.get(0).attributeValue("refentityid"),property.elementText("Name")));
					}catch(Exception e){
						e.printStackTrace();
					}
				}
			}
			if(property.elementText("Name").equals("ChangeCase")){
				property.element("Value").setText("");
			}else if(property.elementText("Name").equals("Trim")){
				property.element("Value").setText("");
			}else if(property.elementText("Name").equals("NumOfDecimals") && item.getName().equals("Table")){
				property.element("Value").setText("");
			}
			
		}
	}
	
	@SuppressWarnings("unchecked")
	private String getFetchFinalValue(String dataTypeId, String proName){
//		String xpath = "DataDictionary/DataTypes/DataType[@id='" + dataTypeId + "']";
//		List<Element> dataType = NodeGOT.gotXML.selectNodes(xpath);
		Element dataType = GotXmlDto.getInstance().currentEntityByTypeAndId("DataType", dataTypeId);
		if(dataType == null)
			return "";
		List<Element> property = GOTHelp.getPPAttElementList(dataType, "Name", proName);
		if(property.size() < 1)
		{
			return "";
		}
		if(!property.get(0).elementText("Value").equals(""))
			return property.get(0).elementText("Value");
		Element dataTypeElement = dataType;
		Element extendsPro = GOTHelper.getProperty(dataTypeElement, "Extends");
		Attribute refentityidattr = extendsPro.attribute("refentityid");
		if(refentityidattr != null)
		{
			return getFetchFinalValue(refentityidattr.getStringValue(),proName);
		}
		return "";
	}
	
	protected void doIfExtendsAndFecth(Element property){
		String proName = property.elementText("Name");
		String proValue = property.elementText("Value");
		if(this.isIfExtendsRelated(proName)){
			if(proValue.equals("")){
				setIfExtends(this.xml,this.rNode);
			}else{
				clearIfExtends(this.xml,this.rNode);
			}
		}
	}
	
	protected void setUnsaved(){
		Element _entityNode = NodeGOT.getEntity(this.xml);
		if(_entityNode.attribute("saved") == null){
			_entityNode.addAttribute("saved", "0");
		}
		
		_entityNode.addAttribute("modifiedLayer", ObjectContainer.getInstance(LayerService.class).getCurrentLayer());
		xml.addAttribute("modifiedLayer", ObjectContainer.getInstance(LayerService.class).getCurrentLayer());
		int base = ObjectContainer.getInstance(LayerLevelManager.class).getLayerLevel(ObjectContainer.getInstance(LayerService.class).getCurrentLayer())*10000;
		int now = Integer.parseInt(_entityNode.attributeValue("nextInnerId"));
		if(now<base){
			_entityNode.addAttribute("nextInnerId", String.valueOf(base));
		}
	}
	
	public void setSelfUnsaved(){
		setUnsaved();
	}
	
	protected void doPropertyTrigger(Element property){
		String name;
		String qname;
		if(property.elementText("Name").equals("Extends")){
			name = this.xml.attributeValue("name");
			qname = this.xml.getName();
			if(name.contains(qname) || "".equals(name)){
				NodeGOT.setBrotherUniqueName1(this.xml);
			}
		}
	}
	
	public static Element getEntity(Element item){
		while(item != null){
			if(isEntity(item)){
				return item;
			}else{
				item = item.getParent();
			}
		}
		return null;
	
	}
	
	public static Boolean isEntity(Element node){
		if(node.attribute("version") != null){
			return true;
		}
		return false;
	}
	
	@SuppressWarnings("unchecked")
	public static Boolean validateUniqueBrother(Node item, String newName){
		String lowerCaseNewName = newName.toLowerCase();
		String itemNodeKind = item.getNodeTypeName();
		Element node;
		List<Element> brother;
		if(itemNodeKind.equals("Attribute")){
			node = item.getParent();
			
			if(checkParentNodes(node.getParent())){
				brother = GotXmlDto.getInstance().currentElements(node.getName() + "s");
			}else{
				brother = node.getParent().elements();
			}
			
			for(Element child : brother){
				if(!child.getName().equals("Properties") && !child.equals(node)){
					if((child.attributeValue(item.getName())).toLowerCase().equals(lowerCaseNewName)){
						return false;
					}
				}
			}
		}else if(itemNodeKind.equals("Element") && item.getName().equals("Property")){
			node = item.getParent().getParent(); 
			if(node.getParent() == null){
				brother = GotXmlDto.getInstance().currentElements(node.getName() + "s");
			}else{
				brother = node.getParent().elements();
			}
			
			for(Element child : brother){
				if(!child.getName().equals("Properties") && child != node ){
					Element ps = (Element) child.elements("Properties").get(0);
					List<Element> psList = ps.elements();
					for(Element p : psList){
						if((p.elementText("Name").equals(item.getParent().elementText("Name"))) && (p.elementText("Value").equals(item.getParent().elementText("Value")))){
							return false;
						}
					}
				}
			}
		}else{
			return false;
		}
		return true;
	}
	
	protected static Boolean validateUniqueOuter(Element item, String newName){
		return true;
	}
	
	private static Boolean validateAttrUniqueAllChild(Element item, Element element, String newName){
		@SuppressWarnings("unchecked")
		List<Element> inner = element.elements();
		Element parent = item.getParent();
		for(Element child : inner){
			if(child.attribute(item.getName()) != null && parent!=child){
				if(child.attributeValue(item.getName()).toLowerCase().equals(newName.toLowerCase())){
					return false ;
				}	
			}
			if(!validateAttrUniqueAllChild(item,child,newName)){
				return false ;
			}
		}
		return true ;
	}
	
	@SuppressWarnings("unchecked")
	public static Boolean validateUniqueInner(Node item, String newName){
		String itemNodeKind = item.getNodeTypeName();
		Element entity = NodeGOT.getEntity(item.getParent());
		List<Element> inner;
		Element parent = item.getParent();
		if(itemNodeKind.equals("Attribute") || itemNodeKind.equals("attribute")){
			inner = entity.elements();
			for(Element child : inner){
				if(child.attribute(item.getName()) != null && !(parent == child)){
					//if(child["@"+String(item.name())] == item.toXMLString())
					if(child.attributeValue(item.getName()).toLowerCase().equals(newName.toLowerCase())){
						return false ;
					}	
				}
				if(!validateAttrUniqueAllChild(item.getParent(),child,newName)){
					return false ;
				}
			}
			return true ;
		}else if(itemNodeKind.equals("Element") && item.getName().equals("Property")){
			String xpath = ".//Property";
			inner = entity.selectNodes(xpath);
			Element item_ = (Element)item;
			for(Element child : inner){
				if(child != item){
					if(child.elementText("Name").equals(item_.elementText("Name")) && child.elementText("Value").equals(item_.elementText("Value"))){
						return false;
					}
				}
			}
			return true ;
		}else{
			return false;
		}
	}
	
	public static Boolean getContextMenuShortCutEnable(Element node, String type){
		if(node == null)
			return false;
		if(type == ResovlerContextMenuValue.SAVE){
			if(getEntity(node) != null)
				return true;
		}
		ResolverNode rnode = ResolverNodeFactory.getRNode(node.getName(),node.attribute("type") == null ? node.attributeValue("type") : "");
		String result = rnode.getContextMenuValue(type);
		return result == "Y" ? true : false ;
	}
	
	private static String treeRightMenuDataString = 
			"<root>"
					+ "<menuitem label='打开新窗口%W' func='newWindow'/> " 
					+ "<menuitem label='显示XML' func='showXML'/> "
					+ "<menuitem type='separator'/>  "
					+ "<menuitem label='新 增%N' func='new'> "	+ "</menuitem> "
					+ "<menuitem label='复制' func='copy'/> "
					+ "<menuitem type='separator'/> "
					+ "<menuitem id='save' label='保存%S' func='save'/> "
					+ "<menuitem label='同步%Y' visible='true' func='sync'/> "
					+ "<menuitem type='separator'/> "
					+ "<menuitem label='恢复%R' func='restore'/> "
					+ "<menuitem id='delete' label='删除%Delete' func='delete'/> "
					+ "<menuitem label='方法%M' func='method'/> "
					+ "<menuitem type='separator'/> "
					+ "<menuitem label='引用列表%Q' func='quote'/> "
					+ "<menuitem label='层控制'> "
							+ "<menuitem label='标记废弃' visible='true' func='deprecate'/> "
							+ "<menuitem label='标记启用' visible='true' func='undeprecate'/> "
							+ "<menuitem label='标记可见' visible='true' func='tovisible'/> "
							+ "<menuitem label='标记不可见' visible='true' func='tounvisible'/> "
							+ "<menuitem label='标记锁定' visible='true' func='lock'/> "
							+ "<menuitem label='解除锁定' visible='true' func='unlock'/> "
					+ "</menuitem>"
					+ "<menuitem label='辅助功能' visible='false' > "
							+ "<menuitem label='同步数据源字段' func='syncFDSF' visible='true' /> "
							+ "<menuitem label='重置关联节点名称' func='resetRelationName' visible='true' /> "
					+ "</menuitem>"
					+ "<menuitem label='辅助功能' visible='false' > "
							+ "<menuitem label='重置关联节点名称' func='resetRelationName' visible='true' /> "
							+ "<menuitem label='FormDataSourceField利用率' func='checkFormDataSourceFieldRate' visible='true' /> "
					+ "</menuitem>"
					+ "<menuitem label='调整创建层' func='AdjustCreatedLayer'/> "
			+ "</root>";
	
	public static Element treeRightMenuData = GOTXMLHelper.createElementByXMLString(treeRightMenuDataString);
	
	public static String gridRightMenuDataString = "<root>"
				+ "<menuitem label='显示XML' func='showXML'/>"
				+ "<menuitem label='进入关联[1]' func='enterRelation'/>"
				+ "<menuitem label='继承追溯[2]' func='enterNodeExtends'/>"
				+ "<menuitem label='帮助' func='help'/>"
				+ "</root>";
	
	public static Element gridRightMenuData = GOTXMLHelper.createElementByXMLString(gridRightMenuDataString);
	
	@SuppressWarnings("unused")
	private static Boolean treeRightMenu_filterFunc(Element item){
		if(item.attribute("visible") != null  && item.attributeValue("visible").equals("false")){
			return false;
		}else{
			return true;
		}
	}
	
	public static Boolean canRevert(Element node){
		if(node==null){
			return false;
		}
		String currentLayer = ObjectContainer.getInstance(LayerService.class).getCurrentLayer();
		if(NodeGOT.isEntity(node)==true
			&& node.attribute("saved") == null
			&& !currentLayer.equals(node.attributeValue("createdLayer")) 
			&& currentLayer.equals(node.attributeValue("modifiedLayer"))){
			return true;
		}else{
			return false;
		}
	}
	
	public static Boolean canPromote(Element node){
		if(node==null){
			return false;
		}
		
		String currentLayer = ObjectContainer.getInstance(LayerService.class).getCurrentLayer();
		
		if(NodeGOT.isEntity(node)==true && node.attribute("saved") == null
			&& !currentLayer.equals(node.attributeValue("createdLayer")) 
			&& !currentLayer.equals(node.attributeValue("modifiedLayer")) ){
			return true;
		}else{
			return false;
		}
	}
	

	@SuppressWarnings("unchecked")
	public static int setContextMenu(Element node){
		String nodeType = node.attribute("type") != null ? node.attributeValue("type") : "" ;
		ResolverNode rnode = ResolverNodeFactory.getRNode(node.getName(),nodeType);
		int num = 0;
		List<Element> treeRightDataList = treeRightMenuData.elements("menuitem");
		Boolean _newWindow = (rnode.getContextMenuValue("NewWindow").equals("Y")) ? true : false ;
		if(_newWindow)num++;
		treeRightDataList.get(0).addAttribute("visible", _newWindow.toString());
		Boolean _showXML = (rnode.getContextMenuValue("ShowXML").equals("Y")) ? true : false ;
		if(_showXML)num++;
		treeRightDataList.get(1).addAttribute("visible", _showXML.toString());
		
		Boolean _new = (rnode.getContextMenuValue("New").equals("Y")) ? true : false ;
		if(_new)num++;
		treeRightDataList.get(3).addAttribute("visible", _new.toString());
		if(_new){
			List<Element> rNodeList = rnode.getNode().elements("node");
			Element _node3 = treeRightDataList.get(3);
			
			List<Element> _node3items = _node3.elements();
			for (Element element : _node3items) {
				_node3.remove(element);
			}
			
			if(rNodeList.size()>1){
				List<Element> tmp = new ArrayList<>();
				for (Element child : rNodeList){
					Element menuitem = GOTXMLHelper.createElementByXMLString("<menuitem func='new'/>");
					String _type = child.element("Info").elementText("Type");
					menuitem.addAttribute("label", !_type.equals("")?_type:child.attributeValue("name"));
					menuitem.addAttribute("nodeType", child.attributeValue("name")+"."+_type);
					menuitem.addAttribute("visible", "true");
					//_node3.appendChild(menuitem);
					tmp.add(menuitem);
				}
				for (Element element : tmp) {
					_node3.add(element.detach());
				}
			}else{
/*				Element el = GOTXMLHelper.createElementByXMLString("<menuitem/>");
				_node3.add(el.detach());*/
//				List<Element> _node3items = _node3.elements();
//				for (Element element : _node3items) {
//					_node3.remove(element);
//				}
//				delete _node3items[0];
			}
			
		}
		Boolean _duplicate = (rnode.getContextMenuValue("Duplicate").equals("Y")) ? true : false ;
		if(_duplicate)num++;
		treeRightDataList.get(4).addAttribute("visible", _duplicate.toString());
		
		Boolean _save = (rnode.getContextMenuValue("Save").equals("Y")) ? true : false;
		if(_save){
			num++;
			if(canPromote(node)){
				treeRightDataList.get(6).addAttribute("label", "提升");
			}else{
				treeRightDataList.get(6).addAttribute("label", "保存%S");
			}
		}
		
		treeRightDataList.get(6).addAttribute("visible", _save.toString());
		
		Boolean _sync = (rnode.getContextMenuValue("Sync").equals("Y"))?true:false;
		if(_sync)num++;
		treeRightDataList.get(7).addAttribute("visible", _sync.toString());
		
		Boolean _restore = (rnode.getContextMenuValue("Restore").equals("Y"))?true:false;
		if(_restore)num++;
		treeRightDataList.get(9).addAttribute("visible", _restore.toString());
		
		Boolean _del = (rnode.getContextMenuValue("Delete").equals("Y"))?true:false;
		if(_del){
			num++;
			if(canRevert(node)){
				treeRightDataList.get(10).attribute("label").setValue("回滚");	
			}else{
				treeRightDataList.get(10).attribute("label").setValue("删除&Delete");	
			}
			
		}
		treeRightDataList.get(10).addAttribute("visible", _del.toString());
		
		Boolean _m = true;
		if((node.getName().equals("Table") || node.getName().equals("Form") || 
				node.getName().equals("FormDataSource")   || "Button".equals(node.attributeValue("type")))){	
			treeRightDataList.get(11).addAttribute("visible", "true");
			
			if(!"0".equals(node.attributeValue("version"))){
				treeRightDataList.get(11).addAttribute("enabled", "true");
			}else{
				treeRightDataList.get(11).addAttribute("enabled", "false");
			}
		}else{
			treeRightDataList.get(11).addAttribute("visible", "false");
			_m = false;
		}
		if(_m)num++;
		Boolean _ref = node.attribute("id") != null ? true : false;
		if(_ref)num++;
		
		treeRightDataList.get(13).addAttribute("visible", _ref.toString());
		//如果是当前层创建则允许层控制
		Boolean _layerEnable =NodeGOT.isEntity(node) && node.attribute("createdLayer") != null  
				&& node.attributeValue("createdLayer").equals(ObjectContainer.getInstance(LayerService.class).getCurrentLayer());
		if(_layerEnable)num++;
		
		treeRightDataList.get(14).addAttribute("visible", _layerEnable.toString());
		Boolean bool = (_newWindow||_showXML) && (_new || _duplicate || _save|| _sync || _restore || _del || _m || _ref);
		if(bool)num++;
		treeRightDataList.get(2).addAttribute("visible", bool.toString());
		bool = (_new || _duplicate) && (_save|| _sync || _restore || _del || _m || _ref);
		if(bool)num++;
		treeRightDataList.get(5).addAttribute("visible", bool.toString());
		bool = (_save||_sync) && ( _restore || _del || _m || _ref);
		if(bool)num++;
		treeRightDataList.get(8).addAttribute("visible", bool.toString());
		bool = (_restore||_del||_m) && _ref;
		if(bool)num++;
		treeRightDataList.get(12).addAttribute("visible", bool.toString());
		
		if(node.getName().equals("Table")){
			treeRightDataList.get(15).addAttribute("visible", "true");
		}else{
			treeRightDataList.get(15).addAttribute("visible", "false");
		}
		
		if(node.getName().equals("FormDataSource")){
			treeRightDataList.get(16).addAttribute("visible", "true");
		}else{
			treeRightDataList.get(16).addAttribute("visible", "false");
		}
		
		if ("Enum".equals(node.getName()) || "DataType".equals(node.getName()) || "Table".equals(node.getName()) 
				|| "Form".equals(node.getName()) || "MenuItem".equals(node.getName()) || "Menu".equals(node.getName())) {
			String entityId = node.attributeValue("id");
			String modifiedLayer = node.attributeValue("modifiedLayer");
			boolean visible = false;
			if (LayerConstants.SOLUTION_LAYER.equals(modifiedLayer)) {
				String solutionName = entityId.substring(0, entityId.lastIndexOf("."));
				visible = ObjectContainer.getInstance(LayerService.class).getCanEditSolutionList().contains(solutionName);
			} else if (LayerConstants.SOLUTION_PLUGIN_LAYER.equals(modifiedLayer)) {
				String solutionPuginName = entityId.substring(0, entityId.lastIndexOf("."));
				SolutionPluginDefinition solutionPluginDefinition = ObjectContainer.getInstance(
						SolutionPluginDefinitionManager.class).getSolutionPlugin(solutionPuginName);
				visible = ObjectContainer.getInstance(LayerService.class).getCanEditSolutionPluginList(solutionPluginDefinition.getSolutionName()).contains(solutionPuginName);
			} else if (LayerConstants.SOLUTION_EXTENSION_LAYER.equals(modifiedLayer)){
				String soluitionName;
				String createdLayer = node.attributeValue("createdLayer");
				if (LayerConstants.SOLUTION_PLUGIN_LAYER.equals(createdLayer)) {
					String solutionPluginName = entityId.substring(0, entityId.lastIndexOf("."));
					SolutionPluginDefinition solutionPluginDefinition = ObjectContainer.getInstance(
							SolutionPluginDefinitionManager.class).getSolutionPlugin(solutionPluginName);
					visible = ObjectContainer.getInstance(LayerService.class).getCanEditExtensionList().contains(solutionPluginDefinition.getSolutionName());
				} else {
					soluitionName = entityId.substring(0, entityId.lastIndexOf("."));
					visible = ObjectContainer.getInstance(LayerService.class).getCanEditExtensionList().contains(soluitionName);
				}
			} else {				
				visible = ObjectContainer.getInstance(LayerService.class).getCanEditLayerList().contains(modifiedLayer);
			}
			
			treeRightDataList.get(17).addAttribute("visible", Boolean.toString(visible));
		} else {
			treeRightDataList.get(17).addAttribute("visible", "false");
		}
		
		return num;
	}
	
	public String allowPropertyEdit(String propertyName){
		if(ObjectContainer.getInstance(LayerService.class).getCurrentLayer().equals(LayerType.PACKAGE)){
			GOTMessageDialog.alert("当前层为二进制层，不支持该操作");
			return Macros.INFO_OPR_LAYERBINARAY_NOT_ALLOW;
		}
		
		switch(propertyName){
			case "CreatedDate":
			case "CreatedTime":
			case "CreatedBy":
			case "ModifiedDate":
			case "ModifiedTime":
			case "ModifiedBy":
				return Macros.INFO_OPR_NOT_ALLOW;
			case "StringSize":
			case "NumOfDecimals":{
				Element pro = GOTHelp.getPPAttElement(this.xml, "Name", "Extends");
				if(pro == null){
					return Macros.INFO_TRUE;
				}else{
					if(pro.elementText("Value").equals(""))
						return Macros.INFO_TRUE;
					else
						return Macros.INFO_FALSE;
				}
			}
		}
		
		Element entity = NodeGOT.getEntity(this.xml);
		if(entity.attribute("locked") != null && entity.attributeValue("locked").equals("true") &&
				entity.attribute("createdLayer") != null
				 && !entity.attributeValue("createdLayer").equals(ObjectContainer.getInstance(LayerService.class).getCurrentLayer()))
			return Macros.INFO_OPR_LAYERLOCK_NOT_ALLOW;
		return Macros.INFO_TRUE;
	}
	
	@SuppressWarnings({"unchecked"})
	public List<String> getPropertyItemEditorArray(String propertyName, String fixedRegular, Element fixedBaseXML){
		List<String> array = new ArrayList<>();
		String regular;
		List<Element> list;
		
		if(!fixedRegular.equals("")){
			array = new ArrayList<>();
			if(fixedBaseXML == null){
				list = GotXmlDto.getInstance().getGotXMl(fixedRegular);
			}else{
				list = fixedBaseXML.selectNodes(fixedRegular);
			}
			
			for (Element item : list){
				if(item != this.xml){
					array.add(item.attributeValue("name"));	
				}
			}
			array.add(0, "");
			return array ;
		}
		
		if(rNode.getPropertyValue(propertyName,"Type").equals("boolean")){
			array = new ArrayList<>();
			array.add("");
			array.add("true");
			array.add("false");
		}else if(rNode.getPropertyValue(propertyName, "Type").equals("enum") || rNode.getPropertyValue(propertyName, "Type").equals("comboBox")){
			try{
				regular = rNode.getPropertyValue(propertyName,"Regular");
				if(regular.equals("")){
					if("AttachmentFileType".equals(propertyName)){
						array.addAll(FromToMapping.AttachmentFileTypeMap.keySet());
					}else{
						array = null;
					}
				}else{
					//带#号 假设只要带#号就肯定是两个#号
					if(regular.substring(0,2).equals("##")){
						array = new ArrayList<>();
						regular = regular.substring(2);
						Element baseXML = null;
						if(regular.substring(0,7).equals("entity.")){
							baseXML = NodeGOT.getEntity(this.xml).createCopy();
							regular = regular.substring(7);
							regular = regular.substring(regular.indexOf("/") + 1);
						}else if(regular.substring(0,6).equals("parent")){
							Element parent = this.xml.getParent();
							String proName = "" ;
							String temp = regular.substring(regular.indexOf(".",0)+1,regular.lastIndexOf("."));
							String[] parentArray = temp.split("\\.");
							for(String s : parentArray){
								if(s.equals("parent")){
									parent = parent.getParent();
								}else{
									proName = s ;
									break ;
								}
							}
							Element property = GOTHelp.getPPAttElement(parent, "Name", proName);
							String proValue = property.elementText("Value");
							String refEntityId;
							if(proValue.equals("")){
								array.add("");
								return array;
							}else{
								refEntityId = property.attributeValue("refentityid");
								String basePath = "";
								basePath += ResolverNodeFactory.getRNodeByItem(parent).getPropertyValue(proName, "Regular").substring(2);
								basePath += "[@id='" +refEntityId+ "']";
								List<Element> baseList = GotXmlDto.getInstance().getGotXMl(basePath);
								baseXML = baseList.get(0).createCopy();
								regular = regular.substring(regular.indexOf("/")-1);
							}
						}else if(regular.substring(0,7).equals("brother")){

							regular = regular.substring(regular.indexOf(".") + 1 );
							String proName = regular.substring(0,regular.indexOf("."));
							List<Element> brothers = this.xml.getParent().elements();

							List<Element> properties = GOTHelp.getPPAttElementList(brothers.get(0), "Name", proName);
							Element selfProperty = GOTHelp.getPPAttElement(this.xml, "Name", proName);
							String tempstr = "DataDictionary/Tables/Table[";
							for(Element property : properties){
								if(property.attribute("refentityid") != null && property != selfProperty){
									tempstr += ("@id =" + property.attributeValue("refentityid") + " or ");
								}
							}
							tempstr = tempstr.substring(0,tempstr.length()-4)+"]" ;
//							baseXML = GotXmlDto.getInstance().getGotXMl();
							regular = tempstr+regular.substring(regular.indexOf("/"));
						}else if(regular.substring(0,4).equals("this")){
							regular = regular.substring(regular.indexOf(".")+1);
							String proName = regular.substring(0,regular.indexOf("."));
							Element property = GOTHelp.getPPAttElement(this.xml, "Name", proName);
							if(property.attribute("refentityid") == null ){
								array.add("");
								return array;
							}else{
								String refEntityId = property.attributeValue("refentityid");
								String basePath = "";
								basePath += ResolverNodeFactory.getRNodeByItem(this.xml).getPropertyValue(proName, "Regular").substring(2);
								basePath += "[@id='" +refEntityId+ "']";
								List<Element> baseList = GotXmlDto.getInstance().getGotXMl(basePath);
								baseXML = baseList.get(0).createCopy();
								regular = regular.substring(regular.indexOf("/"));
							}
						}else{
//							baseXML = GotXmlDto.getInstance().getGotXMl();	
						}
						if(regular.startsWith("//")){
							regular = "." + regular;
						}
						if(baseXML != null){
							list = baseXML.selectNodes(regular);
						}else{
							list = GotXmlDto.getInstance().getGotXMl(regular);
						}
						
						
						for(Element item : list){
							if(!item.asXML().equals(this.xml.asXML()) && item.attribute("saved") == null){
								array.add(item.attributeValue("name"));	
							}
						}
						array.add(0, "");
					}else{
						String[] strs = regular.split("\\|");
						for (String string : strs) {
							array.add(string);
						}
						array.add(0, "");
					}
				}
			}
			catch(Exception e){
				array = null;
				//ZSG 弹出解析器regular表达式错误提示？
				GOTMessageDialog.alert(e);
			}
		}
		return array;
	}
	
	protected String getPropertyStrict(String propertyName){
		return null;
	}
	
/*	@SuppressWarnings({ "unused", "rawtypes", "unchecked" })
	public ClassFactory getPropertyItemEditor(String propertyName){
		List<Element> itemList;
		ClassFactory editor = null;
		String proType = rNode.getPropertyValue(propertyName,"Type");
		Boolean _imeEnable = true;
		if(!proType.equals("string")){
			_imeEnable = false;
		}
		List<String> array = this.getPropertyItemEditorArray(propertyName, "", null);
		if(array.isEmpty()){
//			editor = new ClassFactory(NoWrapSparkGridItemEditor);
			String _strict = getPropertyStrict(propertyName);
			if(_strict == null){
//				editor.properties = {imeEnable:_imeEnable};
			}else{
//				editor.properties = {imeEnable:_imeEnable,strict:_strict};
			}
		}else{
			itemList = new ArrayList(array);
//			editor = new ClassFactory(RegItemEditor);
			if(proType.equals("comboBox")){
//				editor.properties = {dataProvider:itemList, allowNewValue:true, imeEnable:_imeEnable};	
			}else{
//				editor.properties = {dataProvider:itemList,imeEnable:_imeEnable};
			}
		}
		
		return editor;	
	}*/
	
	protected void setProperties(){
		List<Element> array = rNode.getProperties();
		for(Element property : array){
			GOTXMLHelper.addProperty(xml, property.elementText("Name"), property.element("Default").getText());
		}
	}
	
	//实现了删除时对Extends的验证 如果需要提高性能 可以将该方法继承实现 在需要的时候缩小搜索范围
	public static List<Object> getExtended(Element node, Element base){
		List<Object> array = new ArrayList<>();
		String extendName = node.attributeValue("name");
		String xpath = "/descendant::Property";
		@SuppressWarnings("unchecked")
		List<Element> allProList = base.selectNodes(xpath);

		for(Element pro : allProList){
			if(pro.elementText("Name").equals("Extends") && pro.elementText("Value").equals(extendName)){
				node = pro.getParent().getParent();
				JSONObject jsonObject = new JSONObject();
				jsonObject.put("name", node.attributeValue("name"));
				jsonObject.put("qname", node.getName());
				array.add(jsonObject);
			}
		}
		return array;
	}
	
	public NodeGOT getAccpDragNewNode(Element src){
		return null ;
	}
	
	protected NodeGOT doAccpDragNew(String name, String type){
		NodeGOT node = NodeFactory.createNode(name,type,"");
		return node ;
	}
	
	public String getAccpDragNewInsertBase(){
		return "false";
	}
	
	public String validateAccpDragMove(Element srcItem, MouseEvent event){
		return "true";
	}
	
	public String validateAccpDragNew(Element srcItem){
		return "true";
	}
		
	public Element getInsertChildBefore(Element parent){
		return null;
	}
	
	public void doAfterDragDroped(){
	
	}
	
	public String moveType(Element srcItem, MouseEvent event){
		return "false";
	}
	
	public Boolean isSibling(Element srcItem){
		if(srcItem.getName().equals(this.xml.getName()))
			return true;
		return false;
	}
	
	public Boolean switchSelf(){
		return false;
	}
	
	public String allowDcEnter(){
		return "true";
	}
	
	public String allowEdit(){
		if(ObjectContainer.getInstance(LayerService.class).getCurrentLayer().equals(LayerType.PACKAGE))
			return "当前层为二进制层,不允许编辑";
		//通过读取解析器判断其是否可编辑
		if(this.rNode.getInfoValue("Editable").equals("false")){
			return "该节点不允许被编辑" ;
		}
		
		if(!this.xml.attributeValue("createdLayer").equals(ObjectContainer.getInstance(LayerService.class).getCurrentLayer()))
			return "该节点为下层创建,不允许编辑";
		return "true";
	}
	
	public Boolean autoEdit(){
		return true ;
	}
	
	public Boolean allowNew(){
		/*LayerDefinationManager s = ObjectContainer.getInstance(LayerDefinationManager.class);
		String layerDeploymentMode = s.getLayer(ObjectContainer.getInstance(LayerService.class).getCurrentLayer()).getDeploymentMode().name();
		
		if(layerDeploymentMode.equals(LayerType.PACKAGE)){
			GOTMessageDialog.alert("当前层为二进制层，不支持该操作");
			return false;
		}*/
		
		Element entity = NodeGOT.getEntity(this.xml);
		if(entity != null){
			if(entity.attribute("locked") != null && entity.attributeValue("locked").equals("locked") &&
				entity.attribute("createdLayer") != null  && !entity.attributeValue("createdLayer").equals(ObjectContainer.getInstance(LayerService.class).getCurrentLayer()))
				return false;
		}
		return true ;
	}
	
	private static String javakeys = "BOOLEAN ABSTRACT ASSERT BREAK BYTE CASE CATCH CHAR CLASS CONST CONTINUE DEFAULT DO DOUBLE ELSE ENUM EXTENDS FINAL FINALLY FLOAT FOR GOTO IF IMPLEMENTS IMPORT INSTANCEOF INT INTERFACE NATIVE NEW PACKAGE PRIVATE PROTECTED PUBLIC STRICTFP SUPER SWITCH SYNCHRONIZED THIS THROW THROWS TRANSIENT TRY VOID VOLATILE";
	
	protected Boolean isNameValid(String name){
		if(name!= null && name.indexOf(".") != -1){
			int lastIndex = name.lastIndexOf(".");
			name = name.substring(lastIndex+1);
		}
		Boolean isjavakey = javakeys.contains(name.trim());
		String reg = "^[A-Z][a-zA-Z0-9_]*$";
		Boolean b = name.matches(reg);
		return b && !isjavakey;
	}
	
	public Boolean validateNewName(String newName){
		String isBlank = rNode.getAttributeValue("name","Nonblank");
		if(!"false".equals(isBlank)){
			if(newName.equals("")){
				return false ;
			}
		}
		if(!isNameValid(newName)){
			return false;
		}
		
		String nameUnique = rNode.getAttributeValue("name","Unique");
		if("brother".equals(nameUnique)){
			Node el = xml.attribute("name");
			return NodeGOT.validateUniqueBrother(el, newName);
		}
		if("inner".equals(nameUnique)){
			Node el = xml.attribute("name");
			return NodeGOT.validateUniqueInner(el, newName);
		}
		
		return true ;
		
	}
	
	protected Boolean isIfExtendsRelated(String proName){
		return false;
	}
	
	public Boolean editOnCreate(){
		return false;
	}
	
	public void doBeforeInsert(){

	}
	
	public void showXML(String info){
		TreeOperationInfo.addInfo(info);
	}
	
	public Boolean isFocusAfterDragDroped(Element src){
		return true;
	}

	public ValidationResultEvent validateProperty(Element property){
		
		ValidationResultEvent vre = null;
		
		String nonBlank = rNode.getPropertyValue(property.elementText("Name"), "Nonblank");
		nonBlank = nonBlank == null ? "" : nonBlank;
		if("true".equals(nonBlank)){
			vre = ValidationResultEvent.validateNonBlank(property.elementText("Value"));
			if(vre.results!=null){
				return vre ;
			} 
		}else if(nonBlank.equals("ifExtends")){
			if(isIfExtendsRelated("")){
				vre = ValidationResultEvent.validateNonBlank(property.elementText("Value"));
				if(vre.results!=null) return vre ;
			}else{
				//如果允许为空并且确实为空 不进行下面的判断 直接返回
				if(property.elementText("Value").equals("")){
					return null;
				}
			}
		}else if(nonBlank.equals("fetch")){
			vre = ValidationResultEvent.validateNonBlank(property.elementText("Value"));
			if(vre.results!=null) return vre ;
		}else if(nonBlank.equals("false")){
			if(property.elementText("Value").equals("")){
				return null;
			}
		}
		String type = rNode.getPropertyValue(property.elementText("Name"),"Type");
		type = type == null ? "" : type;
		//Type与Regular，暂时这几个，其它待补
		switch(type){
			case "positiveInteger":{
				vre = ValidationResultEvent.positiveInteger(property.elementText("Value"));
				if(vre!=null) return vre ;
			}
			case "nonNegativeInteger":{
				vre =  ValidationResultEvent.unNegativeInteger(property.elementText("Value"));
				if(vre!=null) return vre ;
			}
			case "Integer":{
				vre = ValidationResultEvent.integer(property.elementText("Value"));
				if(vre!=null) return vre ;
			}
			case "enum" :{
				//验证
				String regular= rNode.getPropertyValue(property.elementText("Name"),"Regular");
				if(!regular.startsWith("##")){
					String[] reges = regular.split("\\|");
					if(reges.length>1 && !regular.contains(property.elementText("Value"))){
						if(vre == null)
							vre = new ValidationResultEvent(ValidationResultEvent.INVALID);
						vre.results = new ArrayList<ValidationResult>();
						vre.results.add(new ValidationResult(true, "Property", Macros.ERROR_VALUE_VALUENOTINLIST, Macros.ERROR_VALUE_VALUENOTINLIST));
						return vre;
					}
				}
			}
			default:break ;
		}
		
		//对Unique的验证时间最长 所以放在最后面
		String sc = rNode.getPropertyValue(property.elementText("Name"),"Unique");
		sc = sc == null ? "" : sc;
		switch(sc){
			case "brother":{
				if(vre == null)
					vre = new ValidationResultEvent(ValidationResultEvent.INVALID);
				if(!NodeGOT.validateUniqueBrother(property, property.elementText("Value"))){
					vre.results = new ArrayList<ValidationResult>();
					vre.results.add(new ValidationResult(true, "Property", Macros.ERROR_VALUE_NONUNIQUE, Macros.ERROR_VALUE_NONUNIQUE));
					return vre;
				}
				break;
			}
				
			case "inner":{
				if(vre == null)
					vre = new ValidationResultEvent(ValidationResultEvent.INVALID);
				if(!NodeGOT.validateUniqueInner(property, property.elementText("Value"))){
					vre.results = new ArrayList<ValidationResult>();
					vre.results.add(new ValidationResult(true, "Property", Macros.ERROR_VALUE_NONUNIQUE, Macros.ERROR_VALUE_NONUNIQUE));
					return vre;
					
				}
				break;
			}
			case "outer":{
				//目前只有id用到，假设认为id从服务器取得不会重复
				break;
			}
			default:break ;
		}
		return vre ;
	}
	
	public ValidationResultEvent validatePropertyChanged(Element property){
		return null;
	}
}
