package client.gongqi.designer.got.node.form;

import gongqi.designer.utils.GOTHelper;
import gongqi.erp.gotmodel.core.EntityType;
import info.gongqi.got.model.GotXmlDto;
import info.gongqi.got.tool.GOTHelp;
import info.gongqi.got.ui.LoadXmlCore;
import info.gongqi.got.util.GOTMessageDialog;

import java.util.ArrayList;
import java.util.List;

import org.dom4j.Element;

import client.gongqi.designer.got.node.Entity;
import client.gongqi.designer.got.node.NodeFactory;
import client.gongqi.designer.got.node.NodeGOT;
import client.gongqi.designer.toolsgot.Macros;

public class Form extends Entity{

	public Form(){
		super();
	}
	
	@SuppressWarnings("unchecked")
	@Override
	protected String validateAttributes(){
		String xpath = ".//FormItem";
		List<Element> formItems = this.xml.selectNodes(xpath);
		for(Element formItem : formItems){
			if(formItem.attribute("editOnCreate") != null )
				formItem.remove(formItem.attribute("editOnCreate"));
		}
		return "true";
	}
	
	@Override
	protected Boolean isNeedValidateOnSave(Element property){
		String propertyName = property.elementText("Name");
		if(propertyName.equals("Width") || propertyName.equals("Height")){
			return false;
		}
		return true;
	}
	
	@SuppressWarnings("unchecked")
	@Override
	protected String validateOther(){
		String result = super.validateOther();
		if(result.equals("true")){
			List<Element> elements = this.xml.selectNodes("FormDataSources/FormDataSource");
			for(Element formDataSource : elements){
				String fsName = formDataSource.attributeValue("name");
				if(fsName.equals("Member"))
					return "false:FormDataSource的名字不允许为Member";
				Element joinSource = GOTHelper.getProperty(formDataSource,"JoinSource");
				
				List<Element> relationItems = formDataSource.element("FormDataSourceRelation").elements("FormDataSourceRelationItem");
				if(joinSource.attribute("innerid") == null ){
					if(relationItems.size() > 0)
						return "false:" +  formDataSource.attributeValue("name") + "多出FormDataSourceRelationItem";
				}else{
					String xpath = "FormDataSourceRelation/FormDataSourceRelationItem[@type='Normal']";
					List<Element> relationItems2 = formDataSource.selectNodes(xpath);
					if(relationItems2.size() == 0)
						return "false:" + formDataSource.attributeValue("name") + "应该至少有一个Normal类型的FromDataSourceRelationItem";
				}
			}
		}
		
		List<Element> formDataSources = this.xml.element("FormDataSources").elements("FormDataSource");
		List<Element> list = new ArrayList<>();
		for (Element formDataSource : formDataSources){
			Element temp = formDataSource;
			Element joinTypePro = GOTHelper.getProperty(temp,"JoinType");
			Element joinSourcePro = GOTHelper.getProperty(temp,"JoinSource");
			while(!(joinTypePro.elementText("Value").equals("ExistJoin") || joinTypePro.elementText("Value").equals("NotExistJoin"))
				&& joinSourcePro.attribute("innerid") != null ){
				String xpath = "FormDataSources/FormDataSource[@id='" + joinSourcePro.attributeValue("innerid") + "']";
				temp = (Element) this.xml.selectNodes(xpath).get(0);
				joinTypePro = GOTHelper.getProperty(temp, "JoinType");
				joinSourcePro = GOTHelper.getProperty(temp, "JoinSource");
			}
			
			if(joinTypePro.elementText("Value").equals("ExistJoin") || joinTypePro.elementText("Value").equals("NotExistJoin")){
				list.add(formDataSource);
			}
		}
		
		Element element = this.xml.element("FormDesign");
		return validateFormItem(element, list);
	}
	
	@SuppressWarnings("unchecked")
	private String validateFormItem(Element node, List<Element> list){
		List<Element> formItems = node.elements("FormItem");
		for (Element formItem : formItems){
			Element dataSourcePro = GOTHelper.getProperty(formItem, "DataSource");
			if(dataSourcePro!=null && dataSourcePro.attribute("innerid") != null){
				String innerid = dataSourcePro.attributeValue("innerid");
				List<Element> formDataSources = GOTHelp.getListById(list, "id", innerid);
				if(formDataSources.size() > 0)
					return "false:" + formDataSources.get(0).attributeValue("name") + ":NotExistJoin,ExistJoin所关联的字段不能出现在FormDesign下";
			}
			if(formItem.attributeValue("type").equals("DataGrid")){
				String xpath = "FormItem[@type!='FieldGroup']" ;
				List<Element> cols = formItem.selectNodes(xpath);
				String ds = null;
				for(Element col : cols){
					String dm = GOTHelper.getPropertyValue(col, "DataMethod");
					String extendsvalue = GOTHelper.getPropertyValue(col, "Extends");
					if("".equals(dm)  && "".equals(extendsvalue)){
						return "false:" + col.attributeValue("name") + "：DataMethod属性与Extends属性至少应有一个有值";
					}
					if(ds == null){
						ds = GOTHelper.getPropertyValue(col,"DataSource");
						continue;
					}else{
						String crds = GOTHelper.getPropertyValue(col,"DataSource");
						if(!isSameGroup(ds,crds))
							return "false:"+ds+"与"+crds+"不属于同一个组，不能同时用于同一个DataGrid的列";
					}
					
				}
			}
			if(formItem.attributeValue("type").equals("FieldGroup")){
				Element componentPro = GOTHelper.getProperty(formItem, "Component");
				if(componentPro.attribute("refentityid") != null ){
					String componentId = componentPro.attributeValue("refentityid");
					Element componentDataType = GOTHelper.getDataType(componentId);
					if(componentDataType.getName().equals("Table")){
						String xpath = "./TableFields/TableField[@id='" + componentPro.attributeValue("refinnerid") + "']";
						Element tableField = (Element) componentDataType.selectNodes(xpath).get(0);
						Element tableFieldPP = GOTHelper.getProperty(tableField, "Extends");
						componentId = tableFieldPP.attributeValue("refentityid");
						componentDataType = GOTHelper.getDataType(componentId);
					}
					
					List<Element> fieldGroupItems = formItem.elements("FormItem");
					for (Element item : fieldGroupItems){
						String itemName = item.attributeValue("name");
						String[] tmpArr = itemName.split("_");
						if(tmpArr.length>1){
							if(tmpArr.length == 2){
								String dimItemName = tmpArr[1];
								Element extendsPro = GOTHelper.getProperty(item,"Extends");
								String refDataTypeId = extendsPro.attributeValue("refentityid");
								List<Element> elements = componentDataType.element("DataTypeArray").elements("DataTypeArrayItem");
								for (Element dataTypeArrayItem : elements){
									Element refDataTypePro = GOTHelper.getProperty(dataTypeArrayItem,"RefDataType");
									@SuppressWarnings("unused")
									String refDataTypeId2 = refDataTypePro.attributeValue("refentityid");
									if(refDataTypeId.equals("refDataTypeId2")){
										if(!dimItemName.equals(dataTypeArrayItem.attributeValue("name")))
											return "false:由于维度控制 " + itemName + "的名字必须以" + dataTypeArrayItem.attributeValue("name")+"结尾";
										break;
									}
								}
							}else if(tmpArr.length == 3){
								String extendsName = tmpArr[2];
								String extendsProValue = GOTHelper.getPropertyValue(item, "Extends");
								String[] extendsProValueArr = extendsProValue.split(".");
								if(extendsProValueArr.length >1 &&extendsName != extendsProValueArr[1])
									return "false:由于维度控制 "+itemName+"的名字必须与Extends保持一致 如 XXX_Config 而不能是XXX_Config1";
								}
							}
						}
					}	
				}
			
			String result = validateFormItem(formItem,list);
				if(result != Macros.INFO_TRUE)
					return result;
		}
		return Macros.INFO_TRUE;
	}
	
	@SuppressWarnings("unchecked")
	private Boolean isSameGroup(String ds1, String ds2){
		if(ds1 == null || ds1.equals("") ||  ds2 == null || ds2.equals(""))
			return false;
		if(ds1.equals(ds2))
			return true;
		//return false;
		List<Element> fdss = this.xml.element("FormDataSources").elements("FormDataSource");
		String xpath = "FormDataSources/FormDataSource[@name='" + ds1 + "']";
		Element xds1 = (Element) this.xml.selectNodes(xpath).get(0);
		xpath = "FormDataSources/FormDataSource[@name='" + ds2 + "']";
		Element xds2 = (Element) this.xml.selectNodes(xpath).get(0);
		Boolean flag = true;
		Element xloopds = xds1;
		List<String> a1 = new ArrayList<String>();
		List<String> a2 = new ArrayList<String>();
		while(flag){
			String joinSource = GOTHelp.getPPAttValue(xloopds, "Name", "JoinSource");
			if(joinSource.equals(""))
				break;
			String joinType = GOTHelp.getPPAttValue(xloopds, "Name", "JoinType");
			if(joinType.equals("Passive") || joinType.equals("Delayed") || joinType.equals("Active") || joinType.equals(""))
				break;
			if(joinSource.equals(ds2))
				return true;
			a1.add(joinSource);
			xloopds = GOTHelp.getListById(fdss, "name", joinSource).get(0);
		}
		
		xloopds = xds2;
		while(flag){
			String joinSource = GOTHelper.getPropertyValue(xloopds,"JoinSource");
			if(joinSource.equals(""))
				break;
			String joinType = GOTHelper.getPropertyValue(xloopds,"JoinType");
			if(joinType.equals("Passive") || joinType.equals("Delayed") || joinType.equals("Active") || joinType.equals(""))
				break;
			if(joinSource.equals(ds1))
				return true;
			a2.add(joinSource);
			xloopds = GOTHelp.getListById(fdss, "name", joinSource).get(0);
		}
		
		for (String item : a1){
			if(a2.indexOf(item) != -1)
				return true;
		}
		
		return false;
	}
	
	@SuppressWarnings("unchecked")
	@Override
	protected String validateProperties(Element nodeBeValidated){
		String result = super.validateProperties(nodeBeValidated);
		if(result.equals(Macros.INFO_TRUE)){
			Element joinTypePro = GOTHelper.getProperty(nodeBeValidated, "JoinType");
			if(joinTypePro != null){
				String value = joinTypePro.elementText("Value");
				if(value.equals("InnerJoin") || value.equals("ExistJoin") || value.equals("NotExistJoin")){
					Element properties = joinTypePro.getParent();
					List<Element> elements = properties.element("Property").elements("Name");
					for (Element element : elements) {
						if(element.getText().equals("JoinSource")){
							if(element.elementText("Value").equals("")){
								Element formDataSource = properties.getParent();
								result = "false" + formDataSource.attributeValue("name") + ":InnerJoin,ExistJoin,NotExistJoin选项必须对应到JoinSource";
								return result;
							}
						}
					}
				}
			}
			
			Element dataMethodPro = GOTHelper.getProperty(nodeBeValidated,"DataMethod");
			if(dataMethodPro != null){
				String value = dataMethodPro.elementText("Value");
				if(value.startsWith("@")){
					value = value.substring(1);
					String dataSource = GOTHelper.getPropertyValue(nodeBeValidated, "DataSource");
					if(dataSource == null || dataSource.equals("")){
						return "false" + nodeBeValidated.attributeValue("name") + ":DataSource属性不应为空";
					}
					String path = "FormDataSources/FormDataSource[@name" + dataSource + "]";
					Element dataSourceXML = (Element) this.xml.selectNodes(path).get(0);
					if(dataSourceXML != null){
						List<Element> formdatasourcefields = dataSourceXML.element("FormDataSourceFields").elements("FormDataSourceField");
						for (Element field : formdatasourcefields){
							if(field.attributeValue("name").toLowerCase().equals(value.toLowerCase()))
								return "false" + nodeBeValidated.attributeValue("name") + ":DataMethod属性与某个FormDataSourceField重名";
						}		
					}
				}
			}
		}
		
		if(nodeBeValidated.getName().equals("Form")){
		//FIXME 这个属性没有了
			String subForm = GOTHelp.getPPAttValue(nodeBeValidated, "Name", "SubForm");
			if("true".equals(subForm)){
//				String xpath = "MenuItems/MenuItem";
//				List<Element> menuItems = NodeGOT.gotXML.selectNodes(xpath);
				List<Element> menuItems = GotXmlDto.getInstance().currentElements("MenuItems");
				for (Element menuItem : menuItems) {
					Element property = GOTHelper.getProperty(menuItem,"RefObject");
					if(property.attribute("refentityid") != null){
						String entityId = property.attributeValue("refentityid");
						if(nodeBeValidated.attributeValue("id").equals(entityId)){
							return "false" + "menuItem:" + menuItem.attributeValue("name") + "引用了form：" + nodeBeValidated.attributeValue("name") + "：因此SubForm属性不能为true";
						}
					}
				}
			}
		}
		
		return result;
	}
	
	@Override
	public NodeGOT getAccpDragNewNode(Element src){
		NodeGOT node ;
		if(src.getName().equals("Table")){
			node = super.doAccpDragNew("Form", "");
			this.doAccpDragNewAfer(src,node.xml);
			return node;
		}
		return null;
	}
	
	private void doAccpDragNewAfer(Element src, Element node){
		node.addAttribute("name", src.attributeValue("name"));
		NodeGOT ds = NodeFactory.createNode("FormDataSource","","");
		Element dss = node.element("FormDataSources");
		Element tablePro = GOTHelper.getProperty(ds.xml, "Table");
		tablePro.element("Value").setText(src.attributeValue("name"));
		tablePro.addAttribute("refentityid", src.attributeValue("id"));
		dss.add(ds.xml.detach());
	}
	
	@Override
	public String getAccpDragNewInsertBase(){
		return "parent";
	}
	
	@SuppressWarnings("unused")
	public void doAfterDragDroped(){
		Element ds = this.xml.element("FormDataSources").element("FormDataSource");
		//此时ID是按照顺序来编号的 FormDataSources的id是1 FormDesign的id是3 FormDataSource的id是2 FormDataSourceField从4开始
		Element formDesign = this.xml.element("FormDesign");
		//formDesign.@id = "2";
		ds.addAttribute("id", "1");
		if(ds != null){
			Element tablePro = GOTHelper.getProperty(ds,"Table");
			NodeGOT dsNode = NodeFactory.getNode(ds);
			dsNode.doAfterPropertyModified(tablePro);
		}
		String id = "";
		try {
			id = LoadXmlCore.gotServices.getEntityId(EntityType.Form);
		} catch (Exception e) {
			e.printStackTrace();
			GOTMessageDialog.alert(e);
		}
		this.xml.addAttribute("id", id);
		
	}
	
}
