package client.gongqi.designer.got.node.form;

import java.util.ArrayList;
import java.util.List;

import org.dom4j.Element;
import org.eclipse.swt.widgets.TreeItem;

import client.gongqi.designer.got.node.Inner;
import client.gongqi.designer.got.node.NodeGOT;
import client.gongqi.designer.toolsgot.GOTXMLHelper;
import client.gongqi.designer.toolsgot.Macros;
import gongqi.designer.services.LayerService;
import gongqi.designer.utils.GOTHelper;
import gongqi.erp.framework.core.ObjectContainer;
import info.gongqi.got.model.GotXmlDto;
import info.gongqi.got.tool.FormDataSyn;
import info.gongqi.got.tool.GOTHelp;
import info.gongqi.got.util.GOTMessageDialog;

public class FormDataSource extends Inner {

	public FormDataSource() {
		super();
	}

	@SuppressWarnings({ "unchecked", "unused" })
	@Override
	public void doAfterPropertyModified(Element property, String... args) {
		super.doAfterPropertyModified(property, args);

		if (property.elementText("Name").equals("Table")) {
			List<Element> tableFields;
			List<Element> tableGroups;
			if (property.attribute("refentityid") == null) {
				GOTMessageDialog.alert("aa");
				return;
			}
//			String xpath = "DataDictionary/Tables/Table[@id='" + property.attributeValue("refentityid") + "']";
//			List<Element> table = NodeGOT.gotXML.selectNodes(xpath);
			Element table = GotXmlDto.getInstance().currentEntityByTypeAndId("Table", property.attributeValue("refentityid"));
			
			String temporary = GOTHelper.getPropertyValue(table, "Temporary");
			if (temporary.equals("true")) {
				GOTHelp.getPPAttElement(this.xml, "Name", "AllowEdit").element("Value").setText("false");
				GOTHelp.getPPAttElement(this.xml, "Name", "AllowAdd").element("Value").setText("false");
				GOTHelp.getPPAttElement(this.xml, "Name", "AllowDelete").element("Value").setText("false");
				GOTHelp.getPPAttElement(this.xml, "Name", "AllowSave").element("Value").setText("false");
			} else if (temporary.equals("false")) {
				GOTHelp.getPPAttElement(this.xml, "Name", "AllowEdit").element("Value").setText("true");
				GOTHelp.getPPAttElement(this.xml, "Name", "AllowAdd").element("Value").setText("true");
				GOTHelp.getPPAttElement(this.xml, "Name", "AllowDelete").element("Value").setText("true");
				GOTHelp.getPPAttElement(this.xml, "Name", "AllowSave").element("Value").setText("true");
			}
			tableFields = table.element("TableFields").elements("TableField");
			tableGroups = table.element("TableFieldGroups").elements("TableFieldGroup");
			
			List<Element> elementList = this.xml.elements("FormDataSourceFields");
			for (Element element : elementList) {
				this.xml.remove(element);
			}
			
			List<Element> elementList2 = this.xml.elements("FormDataSourceFieldGroups");
			for (Element element : elementList2) {
				this.xml.remove(element);
			}

			Element formDataSourceRelation = this.xml.element("FormDataSourceRelation");
			Element fields = GOTXMLHelper.createElementByXMLString("<FormDataSourceFields name='Fields'/>");
			Element fieldGroups = GOTXMLHelper
					.createElementByXMLString("<FormDataSourceFieldGroups name = 'FieldGroups'/>");

			String lay = ObjectContainer.getInstance(LayerService.class).getCurrentLayer();
			fields.addAttribute("createdLayer", lay);
			fields.addAttribute("modifiedLayer", lay);
			fieldGroups.addAttribute("createdLayer", lay);
			fieldGroups.addAttribute("modifiedLayer", lay);

			NodeGOT node;
			Element temp;
			int nextInnerId = Integer.valueOf(NodeGOT.getEntity(this.xml).attributeValue("nextInnerId"));
			List<Element> pro;
			//TODO 此处是增加FormDataSourceField属性的方法，目前写死没按照解析器来
			for (Element tableField : tableFields) {
				String str = "<FormDataSourceField name='' id=''>" + "<Properties>" + "<Property>"
						+ " <Name>Label</Name>" + "   <Value/>" + " </Property>" + " <Property>"
						+ "<Name>HelpText</Name>" + "<Value/>" + "</Property>" + "<Property>"
						+ "<Name>DisplayLength</Name>" + "<Value/>" + "</Property>" + "<Property>"
						+ "<Name>AllowEdit</Name>" + "<Value/>" + "</Property>" + "<Property>" + "<Name>NotNull</Name>"
						+ "<Value/>" + " </Property>" + " <Property>" + "<Name>Visible</Name>" + "<Value>true</Value>"
						+ "</Property>" + "<Property>" + " <Name>Regular</Name>" + "<Value/>" + "</Property>"
						+ "<Property>" + " <Name>Field</Name>" + " <Value></Value>" + "</Property>"
						+ "<Property>" + " <Name>Fetch</Name>" + " <Value>true</Value>" + "</Property>"
						+ "<Property>" + " <Name>AggregateType</Name>" + " <Value></Value>" + "</Property>"
						+ "<Property>" + " <Name>Default</Name>" + " <Value></Value>" + "</Property>"
						+ "</Properties>"
						+ "</FormDataSourceField> ";
				temp = GOTXMLHelper.createElementByXMLString(str);
				temp.addAttribute("createdLayer", lay);
				temp.addAttribute("modifiedLayer", lay);
				
				if (tableField.attributeValue("type").equals("Component")) {
					List<Element> extendspro = GOTHelp.getPPAttElementList(tableField, "Name", "Extends");
					if (extendspro.get(0).attribute("refentityid") != null) {
//						xpath = "DataDictionary/DataTypes/DataType[@id='" + extendspro.get(0).attributeValue("refentityid")
//								+ "']";
//						List<Element> dataType = NodeGOT.gotXML.selectNodes(xpath);
						Element dataType = GotXmlDto.getInstance().currentEntityByTypeAndId("DataType", extendspro.get(0).attributeValue("refentityid"));
						
						Element tempCopy;
						List<Element> elements = dataType.element("DataTypeArray").elements("DataTypeArrayItem");
						for (Element arrayItem : elements) {
							List<Element> refDataTypePro = GOTHelp.getPPAttElementList(arrayItem, "Name",
									"RefDataType");
							tempCopy = temp.createCopy();
							tempCopy.addAttribute("name",
									tableField.attributeValue("name") + "." + arrayItem.attributeValue("name"));
//							xpath = "DataDictionary/DataTypes/DataType[@id='"+ refDataTypePro.get(0).attributeValue("refentityid") + "']";
//							Element element = (Element) NodeGOT.gotXML.selectNodes(xpath).get(0);
							Element element = GotXmlDto.getInstance().currentEntityByTypeAndId("DataType", refDataTypePro.get(0).attributeValue("refentityid"));
							tempCopy.addAttribute("type", element.attributeValue("type"));

							pro = GOTHelp.getPPAttElementList(tempCopy, "Name", "Field");
							pro.get(0).addAttribute("refentityid", property.attributeValue("refentityid"));
							pro.get(0).addAttribute("refinnerid", tableField.attributeValue("id"));
							pro.get(0).element("Value").setText(tempCopy.attributeValue("name"));
							tempCopy.addAttribute("id", String.valueOf(nextInnerId));
							nextInnerId++;
							fields.add(tempCopy.detach());
						}
					}
				}

				pro = GOTHelp.getPPAttElementList(temp, "Name", "Field");
				temp.addAttribute("name", tableField.attributeValue("name"));
				pro.get(0).addAttribute("refentityid", property.attributeValue("refentityid"));
				pro.get(0).addAttribute("refinnerid", tableField.attributeValue("id"));
				pro.get(0).element("Value").setText(tableField.attributeValue("name"));
				temp.addAttribute("type", tableField.attributeValue("type"));

				addProperty(tableField, temp, "ThousandSeperator");
				addProperty(tableField, temp, "DisplayDecimals");
				addProperty(tableField, temp, "ShowZero");
				addProperty(tableField, temp, "DisplayStyle");
				
				if(temp.attributeValue("type").equals("Component") || temp.attributeValue("type").equals("Boolean")){
					Element properties = temp.element("Properties");
					Element notNull = GOTHelp.getPPAttElement(temp, "Name", "NotNull");
					properties.remove(notNull);
				}

				temp.addAttribute("id", String.valueOf(nextInnerId));
				nextInnerId++;
				fields.add(temp.detach());
			}

			List<Element> tableGroupFieldPro;
			for (Element tableGroup : tableGroups) {
				String xml = "<FormDataSourceFieldGroup name='' id=''><Properties><Property> <Name>FieldGroup</Name><Value/></Property>"
						+ "</Properties></FormDataSourceFieldGroup>";
				temp = GOTXMLHelper.createElementByXMLString(xml);

				temp.addAttribute("createdLayer", lay);
				temp.addAttribute("modifiedLayer", lay);
				temp.addAttribute("name", tableGroup.attributeValue("name"));
				pro = GOTHelp.getPPAttElementList(temp, "Name", "FieldGroup");
				pro.get(0).addAttribute("refentityid", property.attributeValue("refentityid"));
				pro.get(0).addAttribute("refinnerid", tableGroup.attributeValue("id"));
				pro.get(0).element("Value").setText(tableGroup.attributeValue("name"));
				tableGroupFieldPro = GOTHelp.getPPAttElementList(tableGroup, "Name", "Field");
				temp.addAttribute("id", String.valueOf(nextInnerId));
				nextInnerId++;
				fieldGroups.add(temp.detach());
			}
			GOTHelp.insertChildBefore(this.xml, formDataSourceRelation, fields);
			GOTHelp.insertChildBefore(this.xml, formDataSourceRelation, fieldGroups);
			NodeGOT.getEntity(this.xml).addAttribute("nextInnerId", String.valueOf(nextInnerId));
			
			TreeItem treeItem = FormDataSyn.getTreeItrmByElement(this.xml, null);
			if(treeItem != null && !treeItem.isDisposed()){
				TreeItem itemFields = null;
				TreeItem itemFieldGroups = null;
				TreeItem Relation = null;
				TreeItem[] items = treeItem.getItems();
				if(items != null){
					for (TreeItem treeItem2 : items) {
						if(treeItem2.getText().equals("Fields")){
							itemFields = treeItem2;
						}else if(treeItem2.getText().equals("FieldGroups")){
							itemFieldGroups = treeItem2;
						}else if(treeItem2.getText().equals("Relation")){
							Relation = treeItem2;
						}
					}
					Element element = GotXmlDto.getInstance().getCurrentElement(itemFields);
					FormDataSyn.actionSyn(treeItem, itemFields.getData("id").toString(), this.xml.element("FormDataSourceFields"), this, 0, "DataSourcenew");
					
					element = GotXmlDto.getInstance().getCurrentElement(itemFieldGroups);
					FormDataSyn.actionSyn(treeItem, itemFieldGroups.getData("id").toString(), this.xml.element("FormDataSourceFieldGroups"), this, 1, "DataSourcenew");
					
					element = GotXmlDto.getInstance().getCurrentElement(Relation);
					FormDataSyn.actionSyn(treeItem, Relation.getData("id").toString(), this.xml.element("FormDataSourceRelation"), this, 2, "DataSourcenew");
					
					Relation.removeAll();
					Relation.dispose();
					itemFields.removeAll();
					itemFields.dispose();
					itemFieldGroups.removeAll();
					itemFieldGroups.dispose();
				}
			}
			
		}

		if (property.elementText("Name").equals("JoinSource")) {
			String origValue = args[0];
			if (property.attribute("innerid") != null) {
				if (isDeadLock(this.xml.attributeValue("id"), property.attributeValue("innerid"))) {
					GOTMessageDialog.alert("JoinSource 循环引用");
					property.remove(property.attribute("innerid"));
					property.element("Value").setText("");
					return;
				}
			}
		}

		if (property.elementText("Name").equals("JoinType")) {
			String value = property.elementText("Value");
			if (isNormalType(value)) {
				GOTHelp.getPPAttElement(this.xml, "Name", "AllowEdit").element("Value").setText("false");
				GOTHelp.getPPAttElement(this.xml, "Name", "AllowAdd").element("Value").setText("false");
				GOTHelp.getPPAttElement(this.xml, "Name", "AllowDelete").element("Value").setText("false");
				GOTHelp.getPPAttElement(this.xml, "Name", "AllowSave").element("Value").setText("false");
			}
		}
		
		if (property.elementText("Name").equals("DataSourceType")) {
			String value = property.elementText("Value");
			if (!value.equals("Piovt")) {
				GOTHelp.getPPAttElement(this.xml, "Name", "PivotColumn").element("Value").setText("");
				GOTHelp.getPPAttElement(this.xml, "Name", "PivotAggregateType").element("Value").setText("");
				GOTHelp.getPPAttElement(this.xml, "Name", "PivotAggregateColumn").element("Value").setText("");
			}
		}
		
		String propertyName = property.elementText("Name");
		if(propertyName.equals("PivotColumn") || propertyName.equals("PivotAggregateType")  || propertyName.equals("PivotAggregateColumn")){
			String value = property.elementText("Value");
			List<Element> elements = this.xml.selectNodes("./FormDataSourceFields/FormDataSourceField[@name='" + value + "']");
			if(!elements.isEmpty()){
				Element field = elements.get(0);
				Element fieldPP = GOTHelp.getPPAttElement(field, "Name", "Field");
				property.addAttribute("refentityid", fieldPP.attributeValue("refentityid"));
				property.addAttribute("refinnerid", fieldPP.attributeValue("refinnerid"));
			}
		}

	}

	private void addProperty(Element base, Element tar, String name){
		Element temp = GOTHelp.getPPAttElement(base, "Name", name);
		if(temp != null){
			Element properties = tar.element("Properties");
			properties.add(temp.detach());
		}
	}
	
	@SuppressWarnings("unchecked")
	private Boolean isDeadLock(String srcId, String joinId) {
		List<Element> itemList = xml.getParent().selectNodes("FormDataSource[@id=" + joinId + "]");

		if (itemList == null || itemList.size() == 0)
			throw new Error("GOT错误 找不到引用的FormDataSource");

		if (itemList.size() > 1)
			throw new Error("GOT错误 存在Id号相同的FormDataSource");

		Element item = itemList.get(0);

		List<Element> joinPro = GOTHelp.getPPAttElementList(item, "Name", "JoinSource");
		if (joinPro.get(0).attribute("innerid") == null) {
			return false;
		}
		String loopId = joinPro.get(0).attributeValue("innerid");
		if (loopId.equals(srcId)) {
			return true;
		}
		return isDeadLock(srcId, loopId);
	}

	private Boolean isNormalType(String value) {
		if (value.equals("InnerJoin") || value.equals("ExistJoin") || value.equals("NotExistJoin"))
			return true;
		return false;
	}

	@Override
	public NodeGOT getAccpDragNewNode(Element src) {
		NodeGOT node = super.doAccpDragNew("FormDataSource", "");
		this.doAccpDragNewAfter(src, node);
		return node;
	}

	private void doAccpDragNewAfter(Element src, NodeGOT node) {
		List<Element> tablePro = GOTHelp.getPPAttElementList(node.xml, "Name", "Table");
		tablePro.get(0).element("Value").setText(src.attributeValue("name"));
	}

	@Override
	public void doAfterDragDroped() {
		this.doAfterPropertyModified(GOTHelp.getPPAttElementList(this.xml, "Name", "Table").get(0));
	}

	@Override
	public String getAccpDragNewInsertBase() {
		return "parent";
	}

	@Override
	public Boolean autoEdit() {
		return false;
	}

	@SuppressWarnings("unchecked")
	@Override
	protected List<Element> getRelationInEntity() {
		/*Element entity = NodeGOT.getEntity(this.xml);
		String id = this.xml.attributeValue("id");
		List<Element> formDesign = entity.elements("FormDesign");
		List<Element> formDesignDataSourcePro = GOTHelp.getPPAttElementList(formDesign.get(0), "Name", "DataSource");
		if (formDesignDataSourcePro.get(0).attribute("innerid") != null
				&& formDesignDataSourcePro.get(0).attributeValue("innerid").equals(id)) {
			return formDesignDataSourcePro;
		}*/
		return super.getRelationInEntity();
	}

	@SuppressWarnings("unchecked")
	@Override
	public void doAfterNameModified(String oldName) {
		super.doAfterNameModified(oldName);
		String name = this.xml.attributeValue("name");
		Element fdss = this.xml.getParent();
		List<Element> fdsris = fdss.element("FormDataSource").element("FormDataSourceRelation")
				.elements("FormDataSourceRelationItem");
		for (Element fdsri : fdsris) {
			String itemName = fdsri.attributeValue("name");
			if (itemName.indexOf(oldName) != -1) {
				itemName = itemName.replace(oldName, name);
				fdsri.addAttribute("name", itemName);
			}
		}
	}

	@Override
	public String allowEdit() {
		String result = super.allowEdit();
		if (result.equals("true")) {
			String lay = ObjectContainer.getInstance(LayerService.class).getCurrentLayer();
			if (!this.xml.attributeValue("createdLayer").equals(lay))
				result = "该节点为下层创建,不允许编辑";
		}
		return result;
	}

	@Override
	public String allowPropertyEdit(String propertyName) {
		String result = super.allowPropertyEdit(propertyName);
		if (propertyName.equals("Table") && result.equals(Macros.INFO_TRUE)) {
			String lay = ObjectContainer.getInstance(LayerService.class).getCurrentLayer();
			if (!this.xml.attributeValue("createdLayer").equals(lay)){
				result = "非当前层的FormDataSource节点不能被编辑";
			}
			
			Element form = NodeGOT.getEntity(this.xml);
			String id = this.xml.attributeValue("id");
			String xpath = "//FormItem/Properties/Property[@innerid='" + id + "']";
			List<Element> elements = form.selectNodes(xpath);
			if(!elements.isEmpty()){
				result = "FormDataSource已经被引用，不能被编辑";
			}
		}
		
		//Pivot逻辑
		if(propertyName.equals("PivotColumn") || propertyName.equals("PivotAggregateType")  || propertyName.equals("PivotAggregateColumn")){
			Element dataType = GOTHelp.getPPAttElement(this.xml, "Name", "DataSourceType");
			if(dataType != null){
				String value = dataType.elementText("Value");
				if(!"Pivot".equals(value)){
					return "只有DataSourceType是Pivot才允许编辑";
				}
			}
			
		}
		
		return result;
	}

	@Override
	public String validateDelete() {
		String result = super.validateDelete();
		if (result.equals(Macros.INFO_TRUE)) {
			String lay = ObjectContainer.getInstance(LayerService.class).getCurrentLayer();
			if (!this.xml.attributeValue("createdLayer").equals(lay))
				result = Macros.INFO_FALSE + ":" + "该节点为下层创建,不允许删除";
		}
		return result;
	}
	
	@Override
	public List<String> getPropertyItemEditorArray(String propertyName, String fixedRuglar, Element baseXML){
		if(propertyName.equals("PivotColumn") || propertyName.equals("PivotAggregateColumn")){
			List<String> array = new ArrayList<>();
			array.add("");
			List<Element> elements = this.xml.selectNodes("./FormDataSourceFields/FormDataSourceField");
			for (Element element : elements) {
				if(propertyName.equals("PivotAggregateColumn")){
					String type = element.attributeValue("type");
					if("Long".equals(type) || "Decimal".equals(type) || "String".equals(type)){
						array.add(element.attributeValue("name"));
					}
				}else{
					array.add(element.attributeValue("name"));
				}
				
			}
			return array;
		}else{
			return super.getPropertyItemEditorArray(propertyName, fixedRuglar, baseXML);
		}
	}
}
