package client.gongqi.designer.got.node.form;

import java.util.ArrayList;
import java.util.List;

import org.dom4j.Element;

import client.gongqi.designer.got.node.Inner;
import client.gongqi.designer.got.node.NodeGOT;
import info.gongqi.got.tool.GOTHelp;
import info.gongqi.got.util.GOTMessageDialog;

public class FormDataSourceRelationItem extends Inner{

	public FormDataSourceRelationItem(){
		super();
	}
	
	@SuppressWarnings("unchecked")
	@Override
	public List<String> getPropertyItemEditorArray(String propertyName, String fixedRegular, Element fixedBaseXML){
		List<String> array = new ArrayList<>();	
		Element selfFormDataSource = this.xml.getParent().getParent();
		if(propertyName.equals("ParentField") ){
			List<Element> joinPro = GOTHelp.getPPAttElementList(selfFormDataSource, "Name", "JoinSource");
			if(joinPro.get(0).attribute("innerid") == null){
				array.add("");
				return array ;
			}
			String xpath = "FormDataSources/FormDataSource[@id='" + joinPro.get(0).attributeValue("innerid") + "']";
			List<Element> joinFormDataSource = NodeGOT.getEntity(this.xml).selectNodes(xpath);
			List<Element> elements = joinFormDataSource.get(0).element("FormDataSourceFields").elements("FormDataSourceField");
			for (Element dataSourceField : elements){
				array.add(dataSourceField.attributeValue("name"));
			}
			return array;
		}else if(propertyName.equals("Field")){
			List<Element> elements = selfFormDataSource.element("FormDataSourceFields").elements("FormDataSourceField");
			for(Element dataSourceField : elements){
				array.add(dataSourceField.attributeValue("name"));
			}
			return array ;
		}else{
			return super.getPropertyItemEditorArray(propertyName,fixedRegular,fixedBaseXML);
		}
	}
	
	@SuppressWarnings("unchecked")
	@Override
	protected void addRelation(Element property){
		if(property.elementText("Value").equals("")){
			if(property.attribute("innerid") != null ){
				property.remove(property.attribute("innerid"));
			}
			return ;
		}
		Element selfFormDataSource = this.xml.getParent().getParent();
		List<Element> dataSourceField;
		if("ParentField".equals(property.elementText("Name"))){
			List<Element> joinPro = GOTHelp.getPPAttElementList(selfFormDataSource, "Name", "JoinSource");
			if(joinPro.get(0).attribute("innerid") == null){
				return;
			}
			String xpath = "FormDataSources/FormDataSource[@id='" + joinPro.get(0).attributeValue("innerid") + "']";
			List<Element> joinFormDataSource = NodeGOT.getEntity(this.xml).selectNodes(xpath);
			xpath = "FormDataSourceFields/FormDataSourceField[@name='" + property.elementText("Value") + "']";
			dataSourceField = joinFormDataSource.get(0).selectNodes(xpath);
			if(dataSourceField.size()== 0){
				GOTMessageDialog.alert("找不到对应的FormDataSourceField");
				return ;
			}
			property.addAttribute("refentityid", GOTHelp.getPPAttElement(dataSourceField.get(0), "Name", "Field").attributeValue("refentityid"));
			property.addAttribute("refinnerid", GOTHelp.getPPAttElement(dataSourceField.get(0), "Name", "Field").attributeValue("refinnerid"));
		}else if(property.elementText("Name").equals("Field")){
			String xpath = "FormDataSourceFields/FormDataSourceField[@name='" + property.elementText("Value") + "']";
			dataSourceField = selfFormDataSource.selectNodes(xpath);
			if(dataSourceField.size()== 0){
				GOTMessageDialog.alert("找不到对应的FormDataSourceField");
				return ;
			}
			property.addAttribute("refentityid", GOTHelp.getPPAttElement(dataSourceField.get(0), "Name", "Field").attributeValue("refentityid"));
			property.addAttribute("refinnerid", GOTHelp.getPPAttElement(dataSourceField.get(0), "Name", "Field").attributeValue("refinnerid"));
		}
	}
	
	
}
