package client.gongqi.designer.got.node.form;

import java.util.ArrayList;
import java.util.List;

import org.dom4j.Attribute;
import org.dom4j.Element;

import client.gongqi.designer.got.node.Branch;
import client.gongqi.designer.got.node.NodeGOT;
import info.gongqi.got.model.GotXmlDto;
import info.gongqi.got.tool.GOTHelp;

public class FormDataSources extends Branch{

	public FormDataSources(){
		super();
	}
	
	@SuppressWarnings({ "unchecked" })
	private List<Element> getTableFields() {
		List<Element> returnTablePro = GOTHelp.getPPAttElementList(this.xml, "Name", "ReturnTable");
		String returnTableId = returnTablePro.get(0).attributeValue("innerid");
		List<Element> returnTableSource = new ArrayList<>();
		List<Element> tableFields = new ArrayList<>();
		if(!"".equals(returnTableId) && returnTableId != null){
			String xpath = "FormDataSource[@id='" + returnTableId + "']";
			returnTableSource = this.xml.selectNodes(xpath);
		}else{
			return null;
		}
		List<Element> tablePro = GOTHelp.getPPAttElementList(returnTableSource.get(0), "Name", "Table");
		if(tablePro.get(0).attribute("refentityid") == null ){
			return null;
		}
		String tableId = tablePro.get(0).attributeValue("refentityid");
//		String xpath = "DataDictionary/Tables/Table[@id='" + tableId + "']";
//		List<Element> table = NodeGOT.gotXML.selectNodes(xpath);
		Element table = GotXmlDto.getInstance().currentEntityByTypeAndId("Table", tableId);
		
		tableFields = table.element("TableFields").elements("TableField");
		return tableFields;
	}
	
	@Override
	public List<String> getPropertyItemEditorArray(String propertyName, String fixedRegular, Element fixedBaseXML){
		List<String> array = new ArrayList<>();
		if(propertyName.equals("ReturnField")){
			List<Element> tableFields = getTableFields();
			if(tableFields != null){
				for (Element field : tableFields){
					array.add(field.attributeValue("name"));
				}
			}
			return array;
		}
		return super.getPropertyItemEditorArray(propertyName,fixedRegular,fixedBaseXML);
	}
	
	@SuppressWarnings("unchecked")
	@Override
    public void doAfterPropertyModified(Element property, String...args){
		super.doAfterPropertyModified(property,args);
		String proName = property.elementText("Name");
		
		if(proName.equals("ReturnTable")){
			List<Element> returnFieldPro = GOTHelp.getPPAttElementList(this.xml, "Name", "ReturnField");
			List<Attribute> attributes = new ArrayList<>();
			attributes.addAll(returnFieldPro.get(0).attributes());
			for (Attribute attribute : attributes) {
				returnFieldPro.get(0).remove(attribute);
			}
			returnFieldPro.get(0).element("Value").setText("");
		}
		
		if(proName.equals("ReturnField")){
			if("".equals(property.elementText("Value"))){
				List<Attribute> attributes = new ArrayList<>();
				attributes.addAll(property.attributes());
				for (Attribute attribute : attributes) {
					property.remove(attribute);
				}
				return ;
			}
			
			List<Element> tableFields = getTableFields();
			String fieldName = property.elementText("Value");
			
			if(tableFields != null){
				List<Element> field = new ArrayList<>();
				for (Element element : tableFields) {
					if(fieldName.equals(element.attributeValue("name"))){
						field.add(element);
						break;
					}
				}
				
				List<Element> returnTablePro = GOTHelp.getPPAttElementList(this.xml, "Name", "ReturnTable");
				String xpath = "FormDataSource[@id='" + returnTablePro.get(0).attributeValue("innerid") + "']";
				List<Element> formDataSource = this.xml.selectNodes(xpath);
				List<Element> tablePro = GOTHelp.getPPAttElementList(formDataSource.get(0), "Name", "Table");
				property.addAttribute("refentityid", tablePro.get(0).attributeValue("refentityid"));
				property.addAttribute("refinnerid", field.get(0).attributeValue("id"));
					
			}
		}
	}
	
	@Override
	public NodeGOT getAccpDragNewNode(Element src){
		NodeGOT node = super.doAccpDragNew("FormDataSource", "");
		this.doAccpDragNewAfter(src,node);
		return node;
	}
	
	private void doAccpDragNewAfter(Element src, NodeGOT node){
		Element tablePro = GOTHelp.getPPAttElement(node.xml, "Name", "Table");
		if(tablePro.element("Value") == null){
			tablePro.addElement("Value");
		}
		tablePro.element("Value").setText(src.attributeValue("name"));
	}

	@Override
	public String getAccpDragNewInsertBase(){
		return "self";
	}
	
}
