package client.gongqi.designer.got.node.form;

import java.util.List;

import org.dom4j.Element;
import org.eclipse.swt.events.MouseEvent;

import client.gongqi.designer.got.node.Branch;
import client.gongqi.designer.got.node.NodeGOT;
import info.gongqi.got.tool.GOTHelp;

public class FormDesign extends Branch{

	private IFormItemDragController dragCtrl;
	public FormDesign(){
		super();
		dragCtrl = FormItemDragController.getInstance();
	}
	
	@Override
	public NodeGOT getAccpDragNewNode(Element src){
		NodeGOT node; 
		if(src.getName().equals("Enum")){
			//新建一个TableField 类型是Enum 设置好属性 并且返回这个node
			node = super.doAccpDragNew("FormItem", "EnumEditor");
			dragCtrl.doAccpDragNewAfter(src,node);
			return node;
		}else if(src.getName().equals("DataType")){
			String type = this.getFormItemType(src.attributeValue("type"));				
			node = super.doAccpDragNew("FormItem", type);
			dragCtrl.doAccpDragNewAfter(src,node);
			return node;
		}else if(src.getName().equals("FormDataSourceField")){
			node = super.doAccpDragNew("FormItem",this.getFormItemType(src.attributeValue("type")));
			dragCtrl.doAccpDragNewAfter(src,node);
			return node;
		}else if(src.getName().equals("FormDataSourceFieldGroup")){
			node = super.doAccpDragNew("FormItem","FieldGroup");
			dragCtrl.doAccpDragNewAfterForFormDataSourceFieldGroup(src,node);
			return node;
		}else if(src.getName().equals("MenuItem")){
			node = super.doAccpDragNew("FormItem","MenuItemButton");
			dragCtrl.doAccpDragNewAfter(src,node);
			return node;
		}
		return null;
	}
	
	private String getFormItemType(String origType){
		if(origType.equals("Component")){
			return "FieldGroup";
		}else{
			return origType + "Editor";
		}	
	}
	
	@SuppressWarnings("unused")
	private void setNotNullAndVisible(Element xml){
		List<Element> pro = GOTHelp.getDDDAttElementList(xml, "Name", "NotNull");
		if(pro.size() == 1)
			pro.get(0).element("Value").setText("false");
		
		pro = GOTHelp.getDDDAttElementList(xml, "Name", "Visible");
		if(pro.size() == 1)
			pro.get(0).element("Value").setText("true");
		
	}
	
	private Boolean isNotAllowDragOut(Element fieldGroup){
		List<Element> fieldGroupPro = GOTHelp.getPPAttElementList(fieldGroup, "Name", "FieldGroup"); 
		List<Element> componentPro = GOTHelp.getPPAttElementList(fieldGroup, "Name", "Component");
		List<Element> dataSourcePro = GOTHelp.getPPAttElementList(fieldGroup, "Name", "DataSource");
		
		String dataSourceValue = dataSourcePro.get(0).elementText("Value");
		String componentValue = componentPro.get(0).elementText("Value");
		String fieldGroupValue = fieldGroupPro.get(0).elementText("Value");
		
		if( (!dataSourceValue.equals("") && !componentValue.equals("")) || (!dataSourceValue.equals("") && !fieldGroupValue.equals("")) )	
			return true;
		return false;
	}
	
	@Override
	public String moveType(Element srcItem, MouseEvent event){
		if(srcItem.getName().equals("FormItem")){
			Element parent = srcItem.getParent();
			if(parent != null && "FieldGroup".equals(parent.attributeValue("type")))
				if(isNotAllowDragOut(parent))
					return "false";
			return "append" ;
		}
		return "false" ;
	}
	
	@Override
	public String getAccpDragNewInsertBase(){
		return "self";
	}
	
	@Override
	public Boolean isSibling(Element srcItem){
		if(srcItem.getName().equals("FormItem"))
			return true;
		return false;
	}
	
	@Override
	public String validateAccpDragMove(Element srcItem, MouseEvent event){
		Element parent = srcItem.getParent();
		if(isNotAllowDragOut(parent))
			return "do not place here";
		return "down";
	}
	
	@SuppressWarnings("unused")
	private void setAllowEditDefault(NodeGOT node){
		if(node == null)
			node = this;
		List<Element> allowEditPro = GOTHelp.getPPAttElementList(node.xml, "Name", "AllowEdit");
		if(allowEditPro.size() != 1)
			throw new Error("FormItem上没有找到正确数量的AllowEdit属性");
		allowEditPro.get(0).element("Value").setText(node.rNode.getPropertyValue("AllowEdit","Default"));
	}
}
