package client.gongqi.designer.got.node.form;

import gongqi.designer.services.LayerService;
import gongqi.designer.utils.GOTHelper;
import gongqi.erp.framework.core.ObjectContainer;
import info.gongqi.got.model.GotXmlDto;
import info.gongqi.got.tool.GOTHelp;
import info.gongqi.got.tool.GotLayerAndUserDialog;
import info.gongqi.got.util.GOTMessageDialog;

import java.util.ArrayList;
import java.util.List;

import org.apache.commons.lang.StringUtils;
import org.dom4j.Attribute;
import org.dom4j.Element;
import org.eclipse.swt.SWT;
import org.eclipse.swt.events.MouseEvent;

import client.gongqi.designer.event.ValidationResult;
import client.gongqi.designer.event.ValidationResultEvent;
import client.gongqi.designer.got.node.Inner;
import client.gongqi.designer.got.node.NodeFactory;
import client.gongqi.designer.got.node.NodeGOT;
import client.gongqi.designer.toolsgot.Macros;

import com.alibaba.fastjson.JSONObject;

public class FormItem extends Inner{

	private String temp = "";
	private IFormItemDragController dragCtrl;
	public FormItem(){
		super();
		dragCtrl = FormItemDragController.getInstance();
	}
	
	@Override
	public String allowEdit(){
		String result = super.allowEdit();
		if(result.equals("true"))
			return result;
		
		Element parent = this.xml.getParent();
		if(parent.attributeValue("type").equals("FieldGroup")){
			Element componentPro = GOTHelper.getProperty(parent,"Component"); 
			if(!componentPro.elementText("Value").equals("")){
				return "该节点不允许被编辑" ;
			}
		}
		String lay = ObjectContainer.getInstance(LayerService.class).getCurrentLayer();
		if(xml.attribute("createdLayer") != null && !xml.attribute("createdLayer").equals(lay))
			return "该节点不属于当前层 不可编辑";
		
		return "true";			
	}
	
	@Override
	public String allowPropertyEdit(String propertyName){
		if(propertyName.equals("FieldGroup") || propertyName.equals("Component")){
			String lay = ObjectContainer.getInstance(LayerService.class).getCurrentLayer();
			if(this.xml.attribute("createdLayer") != null && !this.xml.attributeValue("createdLayer").equals(lay))
				return Macros.INFO_FALSE;
			
			List<Element> dataSourcePro = GOTHelp.getPPAttElementList(this.xml, "Name", "DataSource");
			List<Element> fieldGroupPro ;
			List<Element> componentPro ;
			if(dataSourcePro. get(0).attribute("innerid") != null ){
				fieldGroupPro = GOTHelp.getPPAttElementList(this.xml, "Name", "FieldGroup");
				componentPro = GOTHelp.getPPAttElementList(this.xml, "Name", "Component");
				if(propertyName.equals("FieldGroup")  && !componentPro.get(0).elementText("Value").equals("")){
					return Macros.INFO_FALSE;
				}else if(propertyName.equals("Component")  && !fieldGroupPro.get(0).elementText("Value").equals("")){
					return Macros.INFO_FALSE;
				}
				return Macros.INFO_TRUE;
				
			}else{
				if(propertyName.equals("FieldGroup")){
					return Macros.INFO_FALSE;
				}else{
					if(this.xml.attribute("editOnCreate") != null )
						return Macros.INFO_TRUE ;
					return Macros.INFO_FALSE;
				}
			}
		}else if(propertyName.equals("DataSource")  || propertyName.equals("Extends")){
			Element parent = this.xml.getParent();
			if("FieldGroup".equals(parent.attributeValue("type"))){
				Element compPro = GOTHelper.getProperty(parent,"Component");
				if(!compPro.elementText("Value").equals("")){
					return Macros.INFO_FALSE;
				}
			}
			if(propertyName.equals("DataSource")){
				Element componentPro = GOTHelp.getPPAttElement(this.xml, "Name", "Component");
				if(componentPro != null && !"".equals(componentPro.elementText("Value"))){
					return Macros.INFO_FALSE;
				}
			}
		}else if(propertyName.equals("Default")){
			String datasource = GOTHelper.getPropertyValue(xml,"DataSource");
			if(!datasource.equals(""))
				return Macros.INFO_FALSE;
		}
		return super.allowPropertyEdit(propertyName);
	}
	
	@SuppressWarnings("unchecked")
	@Override
	public List<String> getPropertyItemEditorArray(String propertyName, String fixedRegular, Element fixedBaseXML){
		List<String> array = new ArrayList<>();
		List<Element> dataSource ;
		String type = "";
		if(propertyName.equals("Extends")){
			dataSource = GOTHelp.getPPAttElementList(this.xml, "Name", "DataSource");
			if(dataSource.get(0).attribute("innerid") != null ){
				type = this.getTypeByFormItemType(this.xml.attributeValue("type"));
				String xpath = ".//FormDataSource[@id='" + dataSource.get(0).attributeValue("innerid") + "']/FormDataSourceFields/FormDataSourceField[@type='" + type +"']";
				List<Element> dataSourceFields = NodeGOT.getEntity(this.xml).selectNodes(xpath); 
				for(Element dataSourceField : dataSourceFields){
					array.add(dataSourceField.attributeValue("name"));
				}
				return array ;
			}else{
				if(this.rNode.getInfoValue("Type").equals("EnumEditor")){
					List<Element> sourcePro = GOTHelp.getPPAttElementList(this.xml, "Name", "Source");
					type = sourcePro.get(0).elementText("Value");
					if(type.equals(""))
					type = "DataType";
				}
				
				if(type.equals("Regular")){
					List<Element> regularPro = GOTHelp.getPPAttElementList(this.xml, "Name", "Regular");
					String regular = regularPro.get(0).elementText("Value");
					String[] strs = regular.split("|");
					for (String s : strs) {
						array.add(s);
					}
					return array;
				}else if(type.equals("DataType") || type.equals("")){
					return this.getDataTypeArray(this.getTypeByFormItemType(this.xml.attributeValue("type")));
				}else if(type.equals("Enum")){
					if(NodeGOT.arrayEnum==null){
//						List<Element> elements = NodeGOT.gotXML.element("DataDictionary").element("Enums").elements("Enum");
						List<Element> elements = GotXmlDto.getInstance().currentElements("Enums");
						array = this.filterDropArray(elements);
						/*ZSG  for (Element enums : elements){
							array.add(enums.attributeValue("name"));
						}*/
						NodeGOT.arrayEnum = array ;
					}else{
						return NodeGOT.arrayEnum;
					}
						
					return NodeGOT.arrayEnum ;
				}
			}
			return this.getDataTypeArray(this.getTypeByFormItemType(this.xml.attributeValue("type")));	
		}else if(propertyName.equals("FieldGroup")){
			//此时dataSource肯定有值
			dataSource = GOTHelp.getPPAttElementList(this.xml, "Name", "DataSource");
			String xpath = "FormDataSources/FormDataSource[@id='" + dataSource.get(0).attributeValue("innerid") + "']/FormDataSourceFieldGroups/FormDataSourceFieldGroup";
			List<Element> elements = NodeGOT.getEntity(this.xml).selectNodes(xpath);
			for(Element fieldGroup : elements ){
				array.add(fieldGroup.attributeValue("name"));
			}
			return array ;
		}else if(propertyName.equals("Component")){
			dataSource = GOTHelp.getPPAttElementList(this.xml, "Name", "DataSource");
			if(dataSource.get(0).attribute("innerid") == null ){
//				String xpath = "DataDictionary/DataTypes/DataType[@type='Component']";
//				List<Element> components = NodeGOT.gotXML.selectNodes(xpath);
				List<Element> components = GotXmlDto.getInstance().currentElements("DataTypes", "type", "Component");
				for(Element component : components){
					array.add(component.attributeValue("name"));
				}
				return array ;
			}else{
				String xpath = "FormDataSources/FormDataSource[@id='" + dataSource.get(0).attributeValue("innerid") + "']/FormDataSourceFields/FormDataSourceField[@type='Component']";
				List<Element> elements = NodeGOT.getEntity(this.xml).selectNodes(xpath);
				for(Element field : elements){
					array.add(field.attributeValue("name"));
				}
				return array ;
			}
		}else if(propertyName.equals("QueryField")){
			dataSource = GOTHelp.getPPAttElementList(this.xml, "Name", "QuerySource");
			if(dataSource.get(0).attribute("innerid") != null ){
				type = this.getTypeByFormItemType(this.xml.attributeValue("type"));
				String xpath = ".//FormDataSource[@id='" + dataSource.get(0).attributeValue("innerid") + "']/FormDataSourceFields/FormDataSourceField[@type='" + type + "']";
				List<Element> dataSourceFields = NodeGOT.getEntity(this.xml).selectNodes(xpath);
				for (Element dataSourceField : dataSourceFields){
					array.add(dataSourceField.attributeValue("name"));
				}
				return array ;
			}else{
				return new ArrayList<>();
			}
		}else if(propertyName.equals("Default") && client.gongqi.designer.toolsgot.GOTHelper.isEnumDefault(this.xml)){
			List<String> result = client.gongqi.designer.toolsgot.GOTHelper.getDataSourceByTableField(this.xml);
			List<String> ar = new ArrayList<>();
			for (String item : result){
				JSONObject jsonObject = JSONObject.parseObject(item);
				ar.add(jsonObject.getString("label")); 
			}
			return ar.size()!=0?ar:super.getPropertyItemEditorArray(propertyName, "", null);
		}else if(propertyName.equals("DataMethod")){
			dataSource = GOTHelp.getPPAttElementList(this.xml, "Name", "DataSource");
			if(dataSource.get(0).attribute("innerid") != null ){
				return getDataSourceDataMethodEditorArray(dataSource);
			}else{
				return getNonDataSourceDataMethodEditorArray();
			}
		}else if(propertyName.equals("FormLookup")){ //ZSG FormLookup属性下拉时也需要过滤 DynamicColumn
			return this.getFormLookupArray();
		}else if(propertyName.equals("DynamicColumn")){
			List<String> tarList = new ArrayList<>();
			List<Element> elements = this.xml.elements();
			for (Element element : elements) {
				String tre_type = element.attributeValue("type") == null ? "" : element.attributeValue("type");
				if(tre_type.equals("LongEditor") || tre_type.equals("DecimalEditor") || tre_type.equals("StringEditor")){
					tarList.add(element.attributeValue("name"));
				}
			}
			return tarList;
		}else if(propertyName.equals("DataColumn")){
			List<String> tarList = new ArrayList<>();
			Element datasource = GOTHelp.getPPAttElement(this.xml, "Name", "DataSource");
			if(StringUtils.isNotBlank(datasource.elementText("Value"))){
				tarList.add("");
				String innerId = datasource.attributeValue("innerid");
				String xpath = "FormDataSources/FormDataSource[@id='" + innerId + "']/FormDataSourceFields/FormDataSourceField[@type='Enum']";
				List<Element> elements = NodeGOT.getEntity(this.xml).selectNodes(xpath);
				for (Element element : elements) {
					tarList.add(element.attributeValue("name"));
				}
			}
			return tarList;
		}else {
			return super.getPropertyItemEditorArray(propertyName,fixedRegular,fixedBaseXML);	
		}
	}
	
	private List<String> getDataSourceDataMethodEditorArray(List<Element> dataSource){
		String type = this.xml.attributeValue("type");
		List<String> res = new ArrayList<>();
		res.add("Normal");
		if(type.equals("BooleanEditor"))
			res.add("SelectRecords");
		return res;
	}
	
	@SuppressWarnings("unchecked")
	private List<String> getNonDataSourceDataMethodEditorArray(){
		String type = this.xml.attributeValue("type");
		List<String> res = new ArrayList<>();
		if(type.equals("StringEditor")){
			res.add("Password");
		}else if(type.equals("LongEditor")){
			Element entity = NodeGOT.getEntity(this.xml);
			List<Element> datasources = entity.element("FormDataSources").elements("FormDataSource");
			for(Element datasource : datasources){
				res.add("#Count(" + datasource.attributeValue("name") + ")");
			}
			
			for (Element datasource : datasources){
				String xpath = "FormDataSourceFields/FormDataSourceField[@type='Long']" ;
				List<Element> fields = datasource.selectNodes(xpath);
				for (Element field : fields){
					res.add("#Sum("+ datasource.attributeValue("name")+"."+ field.attributeValue("name") +")");
				}
			}
		}else if(type.equals("DecimalEditor")){
			Element entity = NodeGOT.getEntity(this.xml);
			List<Element> datasources = entity.element("FormDataSources").elements("FormDataSource");
			for(Element datasource : datasources){
				String xpath = "FormDataSourceFields/FormDataSourceField[@type='Decimal']" ;
				List<Element> fields = datasource.selectNodes(xpath);
				for(Element field : fields){
					res.add("#Sum("+ datasource.attributeValue("name")+"."+ field.attributeValue("name") +")");
				}
			}
		}
		return res;
	}
	//ZSG 判断某个节点是否应该在下拉列表中 总体规则：visible fixVisible 是否当前层 下层看不到上层
	//APP内看不到旁边
	private boolean isContainsDropList(Element element)
	{
		Attribute attribute = element.attribute("fixVisible");
		if(attribute != null)
		{
			if(attribute.getValue().equals("false"))
			{
				return false;
			}
		}
		
		Attribute att = element.attribute("visible");
		if(att != null)
		{
			if(att.getValue().equals("false"))
			{
				String createLayer = element.attributeValue("createdLayer");
				if(!createLayer.equals(ObjectContainer.getInstance(LayerService.class).getCurrentLayer()))
				{
					return false;
				}
			}
		}
		String modifiedLayer = element.attributeValue("modifiedLayer");
		String id = element.attributeValue("id");
		if("app".equals(GotLayerAndUserDialog.layer))
		{
			if("ext".equals(modifiedLayer))
			{
				return false;
			}
			
			if(id.contains(".") && !id.startsWith(GotLayerAndUserDialog.solution))
			{
				return false;
			}
		}
		else if("ext".equals(GotLayerAndUserDialog.layer))
		{
			if("ext".equals(modifiedLayer) || "app".equals(modifiedLayer))
			{
				if(id.contains(".") && !id.startsWith(GotLayerAndUserDialog.solution))
				{
					return false;
				}
			}
		}
		
		return true;
	}
	
	//ZSG 属性下拉的时候判断是否在下拉列表 并返回给控件数据源
	private List<String> filterDropArray(List<Element> elements)
	{
		List<String> array = new ArrayList<>();
		
		array.add("");
		
		for(Element element : elements)
		{
			if(this.isContainsDropList(element))
				array.add(element.attributeValue("name"));
		}
		return array;
	}
	
	@SuppressWarnings("unchecked")
	private List<String> getDataTypeArray(String type)
	{
//		String xpath = "DataDictionary/DataTypes/DataType[@type='" + type + "']";
//		List<Element> elements = NodeGOT.gotXML.selectNodes(xpath);
		
		List<Element> elements = GotXmlDto.getInstance().currentElements("DataTypes", "type",type);
		return this.filterDropArray(elements);
		
	}
	
	//ZSG 获取StringEditor的FormLookup属性下拉
	@SuppressWarnings("unchecked")
	private List<String> getFormLookupArray(){
//		String xpath = "Forms/Form";
//		List<Element> elements = NodeGOT.gotXML.selectNodes(xpath);
		String xpath = "./Forms/Form[Properties/Property[Name='FormType' and Value='Lookup']]";
		List<Element> elements = GotXmlDto.getInstance().getGotXMl(xpath);
		return this.filterDropArray(elements);
		
	}
	
	private Boolean validateFieldGroupDrag(Element base){
		List<Element> fieldGroup = GOTHelp.getPPAttElementList(base, "Name", "FieldGroup");
		List<Element> component = GOTHelp.getPPAttElementList(base, "Name", "Component");
		List<Element> dataSource = GOTHelp.getPPAttElementList(base, "Name", "DataSource");
		
		String dataSourceValue = dataSource.get(0).elementText("Value");
		String componentValue = component.get(0).elementText("Value");
		String fieldGroupValue = fieldGroup.get(0).elementText("Value");
		if( (!dataSourceValue.equals("") && !componentValue.equals("")) || (!dataSourceValue.equals("") && !fieldGroupValue.equals(""))|| !componentValue.equals("")){
			return false;
		}else{
			return true;
		}
		
	}
	
	@Override
	public String validateAccpDragMove(Element srcItem, MouseEvent event){
		Element parent = this.xml.getParent(); 
		String type = this.xml.attributeValue("type"); 
		Element srcParent = srcItem.getParent();
		if(srcParent.getName().equals("FormItem") && srcParent.attributeValue("type").equals("FieldGroup")){
			if(!validateFieldGroupDrag(srcParent)){
				return "do not place here";
			}
		}
		if(parent.getName().equals("FormDesign")){
			String position = this.getPosition("Design", srcItem.attributeValue("type"),type,event);
			if(type.equals("FieldGroup")){
				if(position.equals("true")){
					return "true";
				}else{
					if(position.equals("down")){
						if(this.validateFieldGroupDrag(this.xml)){
							return "down";
						}
						return "true";
					}
					return position;
				}
			}
			return position;
		}
		
		if(parent.attributeValue("type").equals("FieldGroup")){
			if(!this.validateFieldGroupDrag(parent)){
				return "do not place here";
			}
		}
		
		if(type.equals("FieldGroup")){
			String position = this.getPosition(parent.attributeValue("type"), srcItem.attributeValue("type"),type,event);
			if(position.equals("true")){
				return position;
			}else{
				if(position.equals("down")){
					if(this.validateFieldGroupDrag(this.xml)){
						return "down";
					}
					return "true";
				}
				return position;
			}
		}
		return this.getPosition(parent.attributeValue("type"), srcItem.attributeValue("type"),type,event);
	}
	
	@Override
	protected String getDefaultAttrName(Element attr){
		return this.rNode.getNode().element("Info").elementText("Type");
	}
	
	@SuppressWarnings({ "unchecked", "null" })
	@Override
	protected void doIfExtendsAndFecth(Element property){
		Element dataSourcePro = GOTHelper.getProperty(this.xml,"DataSource");
		if(property.elementText("Name").equals("Extends") && dataSourcePro.attribute("innerid") == null ){
			String proValue = property.elementText("Value");
			if(proValue.equals("")){
				List<Element> elements = this.xml.element("Properties").elements("Property");
				for (Element spro : elements){
					if(spro.elementText("Name").equals("CreatedDate"))
						break;
					if(!FormItemHelper.doSpecialPro(spro)){
						if(rNode.getPropertyValue(spro.elementText("Name"),"Nonblank").equals("ifExtends")){
							spro.element("Value").setText(this.rNode.getPropertyValue(spro.elementText("Name"), "Default"));
						}
					}
				}
			}else{
				List<Element> elements = this.xml.element("Properties").elements("Property");
				for (Element spro : elements){
					if(spro.elementText("Name").equals("CreatedDate"))
						break;
					if(spro.elementText("Name").equals("AllowEdit")){
						if(spro.elementText("Value").equals(""))
							spro.element("Value").setText("true");
					}else if(spro.elementText("Name").equals("Visible")){
						if(spro.elementText("Value").equals(""))
							spro.element("Value").setText("true");
					}else if(spro.elementText("Name").equals("NotNull")){
						if(spro.elementText("Value").equals(""))
							spro.element("Value").setText("true");
					}else if(rNode.getPropertyValue(spro.elementText("Name"),"Nonblank").equals("ifExtends")){
						spro.element("Value").setText("");
					}else if(rNode.getPropertyValue(spro.elementText("Name"),"Nonblank").equals("fetch")){
						List<Element> extendsPro = GOTHelp.getPPAttElementList(this.xml, "Name", "Extends");
						if(extendsPro != null || extendsPro.size()==0)
							throw new Error("fetch不被关联到Extends");
						if(extendsPro.get(0).attribute("refentityid") != null ){
							spro.element("Value").setText(FormItemHelper.getFetchFinalValue(extendsPro.get(0).attributeValue("refentityid"), spro.elementText("Name")));
						}
					}
				}
			}
		}else if(property.elementText("Name").equals("Component") && dataSourcePro.attribute("innerid") != null){
			Element visiblePro = GOTHelper.getProperty(xml,"Visible");
			Element allowEditPro = GOTHelper.getProperty(xml,"AllowEdit");
			if(property.elementText("Value").equals("")){
				visiblePro.element("Value").setText(this.rNode.getPropertyValue("Visible","Default"));
				allowEditPro.element("Value").setText(this.rNode.getPropertyValue("AllowEdit","Default"));
			}else{
				visiblePro.element("Value").setText("");
				allowEditPro.element("Value").setText("");
			}
			
			super.doIfExtendsAndFecth(property);
		}else{
			super.doIfExtendsAndFecth(property);
		}
	}
	
	@SuppressWarnings("unchecked")
	@Override
	public void doAfterPropertyModified(Element property, String...args){
		super.doAfterPropertyModified(property,args);
		String qname = property.elementText("Name");
		List<Element> dataSourcePro;
		switch(qname){
			case "DataSource":{
				List<Element> extendPro = GOTHelp.getPPAttElementList(this.xml, "Name", "Extends");
				String value = property.elementText("Value");
				if(extendPro!=null && extendPro.size()>0){
					if(!extendPro.get(0).elementText("Value").equals("")){
						extendPro.get(0).element("Value").setText("");
						doAfterPropertyModified(extendPro.get(0));
					}
				}
				
				String datasourcevalue = property.elementText("Value");
				if(!datasourcevalue.equals("")){
					Element defaultPro = GOTHelper.getProperty(xml,"Default");
					if(defaultPro != null){
						defaultPro.element("Value").setText("");
					}
				}
				
				if(this.xml.attributeValue("type").equals("FieldGroup")){
					List<Element> fieldGroupPro = GOTHelp.getPPAttElementList(this.xml, "Name", "FieldGroup");
					if(fieldGroupPro!=null && fieldGroupPro.size()>0){
						if(!fieldGroupPro.get(0).elementText("Value").equals("")){
							fieldGroupPro.get(0).element("Value").setText("");
							doAfterPropertyModified(fieldGroupPro.get(0),"");
						}
					}
					if(!value.equals("")){
						List<Element> componentPro = GOTHelp.getPPAttElementList(this.xml, "Name", "Component");
						if(componentPro!=null && componentPro.size()>0){
							if(!componentPro.get(0).elementText("Value").equals("")){
								String temp = componentPro.get(0).elementText("Value");
								componentPro.get(0).setText("");
								if(!value.equals(""))
									doAfterPropertyModified(componentPro.get(0),temp,"false");
								else
									doAfterPropertyModified(componentPro.get(0),temp,"true");
							}
						}
					}
				}
				break;
			}
			case "QuerySource":{
				List<Element> queryFieldPro = GOTHelp.getPPAttElementList(this.xml, "Name", "QueryField");
				if(queryFieldPro!=null && queryFieldPro.size()>0){
					if(!queryFieldPro.get(0).elementText("Value").equals("")){
						queryFieldPro.get(0).element("Value").setText("");
						doAfterPropertyModified(queryFieldPro.get(0));
					}
				}
				break;
			}
			
			case "Extends":
			case "QueryField":{
				if(property.elementText("Value").equals("")){
					List<Attribute> attributes = new ArrayList<>();
					attributes.addAll(property.attributes());
					for (Attribute attribute : attributes) {
						property.remove(attribute);
					}
					return ;
				}
				if(qname.equals("Extends")){
					dataSourcePro = GOTHelp.getPPAttElementList(this.xml, "Name", "DataSource");
				}else{
					dataSourcePro = GOTHelp.getPPAttElementList(this.xml, "Name", "QuerySource");
				}
				
				List<Element> dataType;
				if(dataSourcePro.get(0).attribute("innerid") != null){
					String xpath = "FormDataSources/FormDataSource[@id='" + dataSourcePro.get(0).attributeValue("innerid") + "']/FormDataSourceFields/FormDataSourceField[@name='" + property.elementText("Value") + "']";
					List<Element> formDataSourceField = NodeGOT.getEntity(this.xml).selectNodes(xpath);
					List<Element> formDataSourceFieldFieldPro = GOTHelp.getPPAttElementList(formDataSourceField.get(0), "Name", "Field");
					property.addAttribute("refentityid", formDataSourceFieldFieldPro.get(0).attributeValue("refentityid"));
					property.addAttribute("refinnerid", formDataSourceFieldFieldPro.get(0).attributeValue("refinnerid"));
					if(this.xml.attribute("createdLayer") != null && this.xml.attributeValue("createdLayer").equals("lay")){
						String name = (qname.equals("QueryField")?"QueryField_":"") + dataSourcePro.get(0).elementText("Value") + "_" + formDataSourceField.get(0).attributeValue("name").replace(".","_");
						this.xml.addAttribute("name", name);
					}
					Element datasource = formDataSourceField.get(0).getParent().getParent();
					Element DataSourceTypeElement = GOTHelp.getPPAttElement(datasource, "Name", "DataSourceType");
					if("Aggregate".equals(DataSourceTypeElement.elementText("Value"))){//如果是聚合表
						Element AggregateTypeFile = GOTHelp.getPPAttElement(formDataSourceField.get(0), "Name", "AggregateType");
						String AggValue = AggregateTypeFile.elementText("Value");
						if(StringUtils.isNotBlank(AggValue)){//字段的聚合属性
							String name = datasource.attributeValue("name") + "_Aggregate" + "_" + AggValue  + "_" + formDataSourceField.get(0).attributeValue("name");
							this.xml.addAttribute("name", name);
						}
					}
					
					this.setInnerUniqueName(this.xml);
					
				}else if(this.rNode.getInfoValue("Type").equals("EnumEditor") && qname.equals("Extends")){
					List<Element> soucePro = GOTHelp.getPPAttElementList(this.xml, "Name", "Source");
					String type = soucePro.get(0).elementText("Value");
					switch(type){
						case "Enum":{
//							String xpath = "DataDictionary/Enums/Enum[@name='" + property.elementText("Value") + "']";
//							List<Element> _enum = NodeGOT.gotXML.selectNodes(xpath) ;
							List<Element> _enum = GotXmlDto.getInstance().currentElements("Enums", "name", property.elementText("Value"));
							List<Attribute> attributes = new ArrayList<>();
							attributes.addAll(property.attributes());
							for (Attribute attribute : attributes) {
								property.remove(attribute);
							}
							property.addAttribute("refentityid", _enum.get(0).attributeValue("id"));
							if(this.xml.attribute("createdLayer") != null && this.xml.attributeValue("createdLayer").equals("lay"))
								this.xml.addAttribute("name", _enum.get(0).attributeValue("name"));
							this.setInnerUniqueName(this.xml);
							break;
						}
						case "Regular":{
							break;
						}
						case "DataType":
						case "DataSource":
						case "":{
//							String xpath = "DataDictionary/DataTypes/DataType[@name='" + property.elementText("Value") + "']";
//							dataType = NodeGOT.gotXML.selectNodes(xpath);
							dataType = GotXmlDto.getInstance().currentElements("DataTypes", "name", property.elementText("Value"));
							
							List<Attribute> attributes = new ArrayList<>();
							attributes.addAll(property.attributes());
							for (Attribute attribute : attributes) {
								property.remove(attribute);
							}
							property.addAttribute("refentityid", dataType.get(0).attributeValue("id"));
							
							if(this.xml.attribute("createdLayer") != null && this.xml.attributeValue("createdLayer").equals("lay"))
								this.xml.addAttribute("name", dataType.get(0).attributeValue("name"));
							this.setInnerUniqueName(this.xml);
							break;
						}
				    }
				}else if(qname.equals("Extends")){
//					String xpath = "DataDictionary/DataTypes/DataType[@name='" + property.elementText("Value") + "']";
//					dataType = NodeGOT.gotXML.selectNodes(xpath);
					dataType = GotXmlDto.getInstance().currentElements("DataTypes", "name", property.elementText("Value"));
					List<Attribute> attributes = new ArrayList<>();
					attributes.addAll(property.attributes());
					for (Attribute attribute : attributes) {
						property.remove(attribute);
					}
					property.addAttribute("refentityid", dataType.get(0).attributeValue("id"));
					if(this.xml.attribute("createdLayer") != null && this.xml.attributeValue("createdLayer").equals("lay"))
						this.xml.addAttribute("name", dataType.get(0).attributeValue("name"));
					this.setInnerUniqueName(this.xml);
				}
				
				break;
			}
				
			case "FieldGroup":{
				dataSourcePro = GOTHelp.getPPAttElementList(this.xml, "Name", "DataSource");
				if(dataSourcePro.get(0).attribute("innerid") != null ){
					String xpath = "FormDataSources/FormDataSource[@id='" + dataSourcePro.get(0).attributeValue("innerid") + "']";
					List<Element> dataSource = NodeGOT.getEntity(this.xml).selectNodes(xpath);
					xpath = "FormDataSourceFieldGroups/FormDataSourceFieldGroup[@name='" + property.elementText("Value") + "']";
					List<Element> dataSourceFieldGroup = dataSource.get(0).selectNodes(xpath);
					if(this.xml.attribute("createdLayer") != null && this.xml.attributeValue("createdLayer").equals("lay"))
						this.xml.addAttribute("name", dataSource.get(0).attributeValue("name") + "_"+dataSourceFieldGroup.get(0).attributeValue("name"));
					this.setInnerUniqueName(this.xml);
					
					List<Element> elementList = this.xml.elements("FormItem");
					for (Element element : elementList) {
						this.xml.remove(element);
					}
					
					if(property.elementText("Value").equals("")){
						List<Attribute> attributes = new ArrayList<>();
						attributes.addAll(property.attributes());
						for (Attribute attribute : attributes) {
							property.remove(attribute);
						}
						return ;
					}
					List<Element> dataSourceFieldGroupFieldGroupPro = GOTHelp.getPPAttElementList(dataSourceFieldGroup.get(0), "Name", "FieldGroup");
//					xpath = "DataDictionary/Tables/Table[@id='" + dataSourceFieldGroupFieldGroupPro.get(0).attributeValue("refentityid") + "']";
//					List<Element> table = NodeGOT.gotXML.selectNodes(xpath);
					Element table = GotXmlDto.getInstance().currentEntityByTypeAndId("Table", dataSourceFieldGroupFieldGroupPro.get(0).attributeValue("refentityid"));
					xpath = "TableFieldGroups/TableFieldGroup[@id='" + dataSourceFieldGroupFieldGroupPro.get(0).attributeValue("refinnerid") + "']"; 
					List<Element> tableFieldGroup = table.selectNodes(xpath);
					property.addAttribute("refentityid", table.attributeValue("id"));
					property.addAttribute("refinnerid", tableFieldGroup.get(0).attributeValue("id"));
					NodeGOT node;
					List<Element> refDataTypePro;
					Element refDataType;
					List<Element> elements = tableFieldGroup.get(0).elements("TableFieldGroupItem");
					for(Element tableFieldGroupItem : elements){
						xpath = "TableFields/TableField[@id='" + GOTHelp.getPPAttElement(tableFieldGroupItem, "Name", "Field").attributeValue("innerid") + "']";
						List<Element> tableField = table.selectNodes(xpath);
						List<Element> extendsPro = GOTHelp.getPPAttElementList(tableField.get(0), "Name", "Extends");
						
						if(tableField.get(0).attributeValue("type").equals("Component")){
							if(extendsPro.get(0).attribute("refentityid") == null)
								continue;
							Element dataType = GotXmlDto.getInstance().currentEntityByTypeAndId("DataType", extendsPro.get(0).attributeValue("refentityid"));
							List<Element> elements2 = dataType.element("DataTypeArray").elements("DataTypeArrayItem");
							for (Element arrayItem : elements2){
								refDataTypePro = GOTHelp.getPPAttElementList(arrayItem, "Name", "RefDataType");
								refDataType = GotXmlDto.getInstance().currentEntityByTypeAndId("DataType", refDataTypePro.get(0).attributeValue("refentityid"));
								String type = FormItemHelper.getFormItemTypeByType(refDataType.attributeValue("type"));
								node = NodeFactory.createNode("FormItem",type,"");
								extendsPro = GOTHelp.getPPAttElementList(node.xml, "Name", "Extends");
								extendsPro.get(0).addAttribute("refentityid", table.attributeValue("id"));
								extendsPro.get(0).addAttribute("refinnerid", tableField.get(0).attributeValue("id"));
								extendsPro.get(0).element("Value").setText(dataType.attributeValue("name") + "." + refDataType.attributeValue("name"));
								node.xml.addAttribute("name", dataSource.get(0).attributeValue("name") + "_" + extendsPro.get(0).elementText("Value").replace(".","_"));
								this.xml.add(node.xml.detach());
								node.doAfterInsert();
							}
							
						}else{
							String type = FormItemHelper.getFormItemTypeByType(tableField.get(0).attributeValue("type"));
							node = NodeFactory.createNode("FormItem",type,"");
							extendsPro = GOTHelp.getPPAttElementList(node.xml, "Name", "Extends");
							extendsPro.get(0).addAttribute("refentityid", table.attributeValue("id"));
							extendsPro.get(0).addAttribute("refinnerid", tableField.get(0).attributeValue("id"));
							extendsPro.get(0).element("Value").setText(tableField.get(0).attributeValue("name"));
							node.xml.addAttribute("name", dataSource.get(0).attributeValue("name") +"_"+ extendsPro.get(0).elementText("Value"));
							this.xml.add(node.xml.detach());
							node.doAfterInsert();
						}
					}
				}
				break;
			}
			case "Component":{
				dataSourcePro = GOTHelp.getPPAttElementList(this.xml, "Name", "DataSource");
				if(dataSourcePro.get(0).attribute("innerid") != null && !"".equals(property.elementText("Value"))){
					String xpath = "FormDataSources/FormDataSource[@id='" + dataSourcePro.get(0).attributeValue("innerid") + "']";
					List<Element> dataSource = NodeGOT.getEntity(this.xml).selectNodes(xpath);
					xpath = "FormDataSourceFields/FormDataSourceField[@name='" + property.elementText("Value") + "']";
					List<Element> dataSourceField = dataSource.get(0).selectNodes(xpath);
					
					if(this.xml.attribute("createdLayer") != null && this.xml.attributeValue("createdLayer").equals(ObjectContainer.getInstance(LayerService.class).getCurrentLayer()))
						this.xml.addAttribute("name", dataSource.get(0).attributeValue("name") +"_"+ dataSourceField.get(0).attributeValue("name"));
					this.setInnerUniqueName(this.xml);

					List<Element> elementList = this.xml.elements("FormItem");
					for (Element element : elementList) {
						this.xml.remove(element);
					}
					
					if(!property.elementText("Value").equals("")){
						List<Element> dataSourceFieldFieldPro = GOTHelp.getPPAttElementList(dataSourceField.get(0), "Name", "Field");
						property.addAttribute("refentityid", dataSourceFieldFieldPro.get(0).attributeValue("refentityid"));
						property.addAttribute("refinnerid", dataSourceFieldFieldPro.get(0).attributeValue("refinnerid"));
						List<Element> elements = dataSource.get(0).element("FormDataSourceFields").elements("FormDataSourceField");
						for (Element field : elements){
							List<Element> subfieldPro = GOTHelp.getPPAttElementList(field, "Name", "Field");
							if(subfieldPro.get(0).attributeValue("refinnerid").equals(dataSourceFieldFieldPro.get(0).attributeValue("refinnerid"))  && (!subfieldPro.get(0).equals(dataSourceFieldFieldPro.get(0)))){
								NodeGOT subNode = NodeFactory.createNode("FormItem",FormItemHelper.getFormItemTypeByType(field.attributeValue("type")),"");
								List<Element> extendsPro = GOTHelp.getPPAttElementList(subNode.xml, "Name", "Extends");
								List<Element> subDataSourcePro = GOTHelp.getPPAttElementList(subNode.xml, "Name", "DataSource");
								subDataSourcePro.get(0).addAttribute("innerid", dataSource.get(0).attributeValue("id"));
								subDataSourcePro.get(0).element("Value").setText(dataSource.get(0).attributeValue("name"));
								extendsPro.get(0).addAttribute("refentityid", dataSourceFieldFieldPro.get(0).attributeValue("refentityid"));
								extendsPro.get(0).addAttribute("refinnerid", dataSourceFieldFieldPro.get(0).attributeValue("refinnerid"));
								String fildName = field.attributeValue("name");
								extendsPro.get(0).element("Value").setText(fildName);
								if(fildName.contains(".")){
									fildName = fildName.split("\\.")[1];
								}
								String name = this.xml.attributeValue("name") + "_"+ fildName;
								subNode.xml.addAttribute("name", name);
								this.xml.add(subNode.xml.detach());
								subNode.doAfterInsert();
							}
						}
					}else{
						List<Attribute> attributes = new ArrayList<>();
						attributes.addAll(property.attributes());
						for (Attribute attribute : attributes) {
							property.remove(attribute);
						}
					}
					
				}else{
					List<Attribute> attributes = new ArrayList<>();
					attributes.addAll(property.attributes());
					for (Attribute attribute : attributes) {
						property.remove(attribute);
					}
					String value = property.elementText("Value");

					List<Element> elementList = this.xml.elements("FormItem");
					for (Element element : elementList) {
						this.xml.remove(element);
					}
					
					if(!value.equals("")){
						List<Element> dataType = GotXmlDto.getInstance().currentElements("DataTypes", "name", property.elementText("Value"));
						property.addAttribute("refentityid", dataType.get(0).attributeValue("id"));
						if(this.xml.attribute("createdLayer") != null && this.xml.attributeValue("createdLayer").equals("lay"))
							this.xml.addAttribute("name", dataType.get(0).attributeValue("name"));
						this.setInnerUniqueName(this.xml);
						List<Element> elements = dataType.get(0).element("DataTypeArray").elements("DataTypeArrayItem");
						for (Element arrayItem : elements){
							List<Element> refDataTypePro = GOTHelp.getPPAttElementList(arrayItem, "Name", "RefDataType");
							Element refDataType = GotXmlDto.getInstance().currentEntityByTypeAndId("DataType", refDataTypePro.get(0).attributeValue("refentityid"));
							String type = FormItemHelper.getFormItemTypeByType(refDataType.attributeValue("type"));
							NodeGOT node = NodeFactory.createNode("FormItem",type,"");
							List<Element> extendsPro = GOTHelp.getPPAttElementList(node.xml, "Name", "Extends");
							extendsPro.get(0).element("Value").setText(refDataType.attributeValue("name"));
							this.xml.add(node.xml.detach());
							node.doAfterPropertyModified(extendsPro.get(0));
							node.xml.addAttribute("name", this.xml.attributeValue("name") +"_" + arrayItem.attributeValue("name"));
							node.doAfterInsert();	
						}
					}
				}
				
				List<Element> visiblePro = GOTHelp.getPPAttElementList(this.xml, "Name", "Visible");
				if(args!=null && args.length>1){
					Boolean dataSourceRelated = Boolean.parseBoolean(args[1]);
					if(dataSourceRelated){
						visiblePro.get(0).element("Value").setText(this.rNode.getPropertyValue("Visible","Default"));
					}else{
						return ;
					}
				}
				break;
			}
			case "GroupType":{
				String value = property.elementText("Value");
				if(value.equals("Query")){
					Element layoutProperty = GOTHelper.getProperty(xml,"Layout");
					layoutProperty.element("Value").setText("horizontal");
				}
				break;
			}
			case "QueryType":{
				String value = property.elementText("Value");;
				Element aulevelProperty = GOTHelper.getProperty(xml,"AuthorityLevel");
				Element labelPro = GOTHelper.getProperty(xml,"Label");
				if(value.equals("Submit")){
					aulevelProperty.element("Value").setText("Query");
					labelPro.element("Value").setText("查询");
				}else if(value.equals("Reset")){
					aulevelProperty.element("Value").setText("Query");
					labelPro.element("Value").setText("重置");
				}else{
					aulevelProperty.element("Value").setText("Edit");	
				}
				break;
			}
			case "DataMethod":{
				String value = property.elementText("Value");
				Element allowEditPro = GOTHelper.getProperty(xml,"AllowEdit");
				if(value.equals("Normal")){
					allowEditPro.element("Value").setText("false");
				}else if(value.equals("SelectRecords")){
					allowEditPro.element("Value").setText("true");
				}
				break;
			}
			case "DataColumn":{
				String value = property.elementText("Value");
				Element datasource = GOTHelp.getPPAttElement(this.xml, "Name", "DataSource");
				if(StringUtils.isNotBlank(datasource.elementText("Value"))){
					String innerId = datasource.attributeValue("innerid");
					String xpath = "FormDataSources/FormDataSource[@id='" + innerId + "']/FormDataSourceFields/FormDataSourceField[@name='" + value + "']";
					List<Element> elements = NodeGOT.getEntity(this.xml).selectNodes(xpath);
					if(!elements.isEmpty()){
						Element field = elements.get(0);
						Element fieldPP = GOTHelp.getPPAttElement(field, "Name", "Field");
						property.addAttribute("refentityid", fieldPP.attributeValue("refentityid"));
						property.addAttribute("refinnerid", fieldPP.attributeValue("refinnerid"));
					}
				}
				break;
			}
		}
	}
	
	@SuppressWarnings("unused")
	private void setAllowEditDefault(NodeGOT node){
		if(node == null)
			node = this;
		List<Element> allowEditPro = GOTHelp.getPPAttElementList(node.xml, "Name", "AllowEdit");
		if(allowEditPro.size() != 1)
			throw new Error("FormItem上没有找到正确数量的AllowEdit属性");
		allowEditPro.get(0).element("Value").setText(node.rNode.getPropertyValue("AllowEdit","Default"));
	}
	
	@Override
	public Boolean autoEdit(){
		return false ;
	}
	
	@Override
	public Boolean allowNew(){
		if(this.rNode.getInfoValue("Type").equals("FieldGroup")){
			List<Element> fieldGroupPro = GOTHelp.getPPAttElementList(this.xml, "Name", "FieldGroup");
			List<Element> componentPro = GOTHelp.getPPAttElementList(this.xml, "Name", "Component");
			if(fieldGroupPro.get(0).elementText("Value").equals("") && componentPro.get(0).elementText("Value").equals("")){
				return true ;
			}else{
				return false ;
			}
		}else{
			return true ;
		}
	}
	
	@SuppressWarnings("unchecked")
	@Override
	public String validateDelete(){
		Element parent = this.xml.getParent();
		if(parent != null && "FieldGroup".equals(parent.attributeValue("type"))){
			List<Element> fieldGroupPro = GOTHelp.getPPAttElementList(parent, "Name", "FieldGroup");
			List<Element> componentPro = GOTHelp.getPPAttElementList(parent, "Name", "Component");
			
			if(!componentPro.get(0).elementText("Value").equals("")){
				return Macros.INFO_FALSE+":当前节点不允许被删除";
			}
			
			if(fieldGroupPro.get(0).elementText("Value").equals("")){
				return Macros.INFO_TRUE;
			}else{
				return Macros.INFO_FALSE+":当前节点不允许被删除";
			}
		}else if(parent != null && "DataGrid".equals(parent.attributeValue("type"))){
			Element componentPro = GOTHelper.getProperty(this.xml.getParent(),"DynamicColumn");
			if(componentPro != null){
				if(this.xml.attributeValue("id").equals(componentPro.attributeValue("innerid"))){
					return Macros.INFO_FALSE+":当前节点被父节点引用，不允许被删除";
				}
			}
		}
		
		String superresult = super.validateDelete();
		if(superresult.equals(Macros.INFO_TRUE)){
			List<Element> children = this.xml.elements("FormItem");
			String lay = ObjectContainer.getInstance(LayerService.class).getCurrentLayer();
			for(Element child : children){
				if(!child.attributeValue("createdLayer").equals(lay)){
					return Macros.INFO_FALSE+":该节点包含非当前层节点" + child.attributeValue("name") + "，所以无法被删除";
				}
			}
		}
		return superresult;
	}
	
	private String getTypeByFormItemType(String formItemType){
		if(formItemType.equals("FieldGroup")){
			return "Component";
		}else{
			return formItemType.substring(0,formItemType.length()-6);
		}
	}
	
	@SuppressWarnings("unchecked")
	@Override
	public void doAfterInsert(){
		if(this.xml.attributeValue("type").equals("FieldGroup")){
			this.setInnerUniqueName(this.xml);
			List<Element> componentPro = GOTHelp.getPPAttElementList(this.xml, "Name", "Component");
			List<Element> childs = this.xml.elements("FormItem");
			if(!componentPro.get(0).elementText("Value").equals("")){
				if(childs.size()>0){
//					String xpath = "DataDictionary/DataTypes/DataType[@name='" + componentPro.get(0).elementText("Value") + "']";
//					List<Element> dataType = NodeGOT.gotXML.selectNodes(xpath);
					List<Element> dataType = GotXmlDto.getInstance().currentElements("DataTypes", "name", componentPro.get(0).elementText("Value"));
					for (Element child : childs){
						List<Element> extendsPro = GOTHelp.getPPAttElementList(child, "Name", "Extends");
						String temp = extendsPro.get(0).elementText("Value");
						String refentityId = extendsPro.get(0).attributeValue("refentityid");
						List<Element> elements = dataType.get(0).element("DataTypeArray").elements("DataTypeArrayItem");
						for (Element arrayItem : elements){
							Element refDataTypePro = GOTHelper.getProperty(arrayItem,"RefDataType");
							if(refDataTypePro != null && refentityId.equals(refDataTypePro.attributeValue("refentityId"))){
								temp = arrayItem.attributeValue("name");
								break;
							}
						}
						
						if(temp.indexOf(".")==-1){
							child.addAttribute("name", this.xml.attributeValue("name") + "_" + temp);
						}else{
							child.addAttribute("name", this.xml.attributeValue("name") + "_" + temp.split("\\.")[1]);
						}
					}
				}
			}
		}
		int num = Integer.parseInt(NodeGOT.getEntity(this.xml).attributeValue("nextInnerId"));
		String nextId = this.setIdAndName(this.xml, num) + "";
		NodeGOT.getEntity(this.xml).addAttribute("nextInnerId", nextId);
		this.setUnsaved();
		List<Element> dataSourcePro = GOTHelp.getPPAttElementList(this.xml, "Name", "DataSource");
		if(!dataSourcePro.isEmpty()){
			if(dataSourcePro.get(0).elementText("Value").equals("")){
//				Element parent = this.xml.getParent();
				//TODO 由于FormDesigner没有DataSource属性，增加直接会报错，临时注释，其他情况有没有问题待测试
				/*List<Element> parentDataSourcePro = GOTHelp.getPPAttElementList(parent, "Name", "DataSource");
				if(parentDataSourcePro.get(0).attribute("innerid") != null ){
					dataSourcePro.get(0).addAttribute("innerid", parentDataSourcePro.get(0).attributeValue("innerid"));
					dataSourcePro.get(0).element("Value").setText(parentDataSourcePro.get(0).elementText("Value"));
				}*/
			}
		}
		
		if(xml.attributeValue("type").equals("TabPage")){
			int index = xml.getParent().indexOf(xml);
			List<Element> labelPro = GOTHelp.getPPAttElementList(xml, "Name", "Label");
			if(index == 1){
				labelPro.get(0).element("Value").setText("概览");		
			}else if(index == 2){
				labelPro.get(0).element("Value").setText("概述");
			}
		}
		String lay = ObjectContainer.getInstance(LayerService.class).getCurrentLayer();
		xml.addAttribute("createdLayer", lay);
	}
	
	//设置Inner唯一 对本身极其下所有子节点设置Inner唯一的@name 设置id
	@SuppressWarnings("unchecked")
	private int setIdAndName(Element node, int id){
		setInnerUniqueName1(node);	
		node.addAttribute("id", String.valueOf(id));
		List<Element> elements = node.elements("FormItem");
		for(Element child : elements){
			setIdAndName(child,++id);
		}
		return ++id ;
	}
	
	private void setInnerUniqueName1(Element newNode){
		String origName = newNode.attributeValue("name");
		String newName = origName ;
//		int i = 1;
//		ddd
//		while(!validateInnerUniqueName1(newName)){
//			newName = origName + i;
//			newNode.addAttribute("name", newName);
//			i++;
//		}
		
		List<Element> allFormItemList = NodeGOT.getEntity(this.xml).selectNodes(".//FormItem");
		int last = 0;
		boolean same = false;
		for (Element child : allFormItemList){
			if(child != this.xml){
				if(child.attribute("name") != null){
					String attrName = child.attributeValue("name");
					if(attrName.startsWith(origName)){
						if(attrName.equals(origName)){
							same = true;
						}
						attrName = attrName.replace(origName, "");
						if(isNumber(attrName)){
							int num = Integer.valueOf(attrName);
							if(num > last){
								last = num;
							}
						}
					}
				}
			}
		}
		if(last > 0){
			last ++;
			newName = origName + last;
		}else if(same){
			//此处维度字段后面不能加数字
			if(newNode.getParent() != null){
				if("FieldGroup".equals(newNode.getParent().attributeValue("type"))){
					List<Element> componentPro = GOTHelp.getPPAttElementList(this.xml, "Name", "Component");
					if(!componentPro.isEmpty()){
						if(!componentPro.get(0).elementText("Value").equals("")){
							newNode.addAttribute("name", newName);
							return;
						}
					}
				}
			}
			newName = origName + 1;
		}
		newNode.addAttribute("name", newName);
	}
	
/*	@SuppressWarnings("unchecked")
	private Boolean validateInnerUniqueName1(String newName){
		List<Element> formItemList = NodeGOT.getEntity(this.xml).selectNodes(".//FormItem");
		int num = 0;
		for(Element item : formItemList){
			if(item.attributeValue("name").toLowerCase().equals(newName.toLowerCase())){
				num ++;
			}
			if(num > 1)
				return false;
		}
		return true;
	}*/
	
	@Override
	protected void setInnerUniqueName(Element newNode){
		String origName = newNode.attributeValue("name");
		String newName = origName ;
		if(this.xml.attributeValue("type").equals("FieldGroup")){
			List<Element> componentPro = GOTHelp.getPPAttElementList(this.xml, "Name", "Component");
			if(!componentPro.get(0).elementText("Value").equals("")){
				int i = 1;
				while(!validateInnerUniqueName(newName)){
					newName = origName + i;
					newNode.addAttribute("name", newName);
					i++;
				}
				newNode.addAttribute("name", newName);
				return;
			}
		}
		List<Element> allFormItemList = NodeGOT.getEntity(this.xml).selectNodes(".//FormItem");
		
		int last = 0;
		boolean same = false;
		for (Element child : allFormItemList){
			if(child != this.xml){
				if(child.attribute("name") != null){
					String attrName = child.attributeValue("name");
					if(attrName.startsWith(origName)){
						if(attrName.equals(origName)){
							same = true;
						}
						attrName = attrName.replace(origName, "");
						if(isNumber(attrName)){
							int num = Integer.valueOf(attrName);
							if(num > last){
								last = num;
							}
						}
					}
				}
			}
		}
		
		if(last > 0){
			last ++;
			newName = origName + last;
		}else if(same){
			newName = origName + 1;
		}
		newNode.addAttribute("name", newName);
	}
	
	@Override
	public Boolean validateNewName(String newName){
		if(!isNameValid(newName))
			return false;
		
		return 	validateInnerUniqueName(newName);
	}
	
	@SuppressWarnings("unchecked")
	private Boolean validateInnerUniqueName(String newName){
		List<Element> allFormItemList = NodeGOT.getEntity(this.xml).selectNodes(".//FormItem");
		List<Element> formItemList = NodeGOT.getEntity(this.xml).selectNodes(".//FormItem[@name='" + newName + "']");
		Boolean result = true;
		if(formItemList.size() == 1){
			if(formItemList.get(0) == xml)
				result = true;
			else
				result = false;
		}else{
			result= formItemList.size()>0 ? false:true ;
		}
		
		if(result){
			if(this.xml.attributeValue("type").equals("FieldGroup") ){
				List<Element> componentPro = GOTHelp.getPPAttElementList(this.xml, "Name", "Component");
				if(!componentPro.get(0).elementText("Value").equals("")){
					for(Element formItem : allFormItemList){
						if(formItem != this.xml && formItem.getParent() != this.xml){
							Element extendsPro = GOTHelper.getProperty(formItem,"Extends");
							if(extendsPro != null && extendsPro.attribute("refinnerid") != null){
								if(extendsPro.attributeValue("refinnerid").equals(componentPro.get(0).attributeValue("refinnerid")) && 
										extendsPro.attributeValue("refentityid").equals(componentPro.get(0).attributeValue("refentityid"))){
									if(formItem.attributeValue("name").indexOf(newName)==0){
										result = false;
										break;
										}
								}
							}
						}
					}
				}
			}	
		}
		return result;
	}
	
	@Override
	public NodeGOT getAccpDragNewNode(Element src){
		NodeGOT node; 
		if(src.getName().equals("Enum")){
			node = super.doAccpDragNew("FormItem","EnumEditor");
			dragCtrl.doAccpDragNewAfter(src,node);
			return node;
		}else if(src.getName().equals("DataType")){
			String type = FormItemHelper.getFormItemTypeByType(src.attributeValue("type"));				
			node = super.doAccpDragNew("FormItem",type);
			dragCtrl.doAccpDragNewAfter(src,node);
			return node;
		}else if(src.getName().equals("FormDataSourceField")){
			node = super.doAccpDragNew("FormItem",FormItemHelper.getFormItemTypeByType(src.attributeValue("type")));
			dragCtrl.doAccpDragNewAfter(src,node);
			return node;
		}else if(src.getName().equals("FormDataSourceFieldGroup")){
			node = super.doAccpDragNew("FormItem","FieldGroup");
			dragCtrl.doAccpDragNewAfterForFormDataSourceFieldGroup(src,node);
			return node;
		}else if(src.getName().equals("MenuItem")){
			node = super.doAccpDragNew("FormItem","MenuItemButton");
			dragCtrl.doAccpDragNewAfter(src,node);
			return node;
		}
		return null;
	}
	
	@SuppressWarnings("unused")
	private void setNotNullAndVisible(Element xml){
		List<Element> pro = GOTHelp.getPPAttElementList(xml, "Name", "NotNull");
		if(pro.size() == 1)
			pro.get(0).element("Value").setText("false");
		pro = GOTHelp.getPPAttElementList(xml, "Name", "Visible");
		if(pro.size() == 1)
		pro.get(0).element("Value").setText("true");
		
	}
	
	@Override
    public void doAfterDragDroped(){
		if(this.xml.attributeValue("type").equals("MenuItemButton")){
			this.doAfterPropertyModified(GOTHelp.getPPAttElement(this.xml, "Name", "MenuItem"));
			this.setInnerUniqueName(this.xml);
			addAutoDataSource();
		}

	}
	
    private void addAutoDataSource(){
		Element parent = this.xml;
		List<Element> parentSourcePro = GOTHelp.getPPAttElementList(parent, "Name", "DataSource");
		while(parentSourcePro.get(0).attribute("innerid") == null){
			parent = parent.getParent();
			if(parent.getName().equals("FormDesign")){
				break;
			}
			parentSourcePro = GOTHelp.getPPAttElementList(parent, "Name", "DataSource");
		}
		
		List<Element> selfSourcePro = GOTHelp.getPPAttElementList(this.xml, "Name", "DataSource");
		if(parentSourcePro.get(0).attributeValue("innerid") != null){
			selfSourcePro.get(0).element("Value").setText(parentSourcePro.get(0).elementText("Value"));
			selfSourcePro.get(0).addAttribute("innerid", parentSourcePro.get(0).attributeValue("innerid"));
		}else{
			Element dataSource = NodeGOT.getEntity(this.xml).element("FormDataSources").element("FormDataSource");
			selfSourcePro.get(0).element("Value").setText(dataSource.attributeValue("name"));
			selfSourcePro.get(0).addAttribute("innerid", dataSource.attributeValue("id"));
		}
	}
	
    @Override
	public String getAccpDragNewInsertBase(){
		if(this.temp.equals("down"))
			return "self";
		return "parent";
	}
	
    @Override
	public String validateAccpDragNew(Element srcItem){
    	String type = this.xml.attributeValue("type");
    	Element parent = this.xml.getParent();
		
    	String formItemType = "";
		if(srcItem.attributeValue("type") != null){
			formItemType = FormItemHelper.getFormItemTypeByType(srcItem.attributeValue("type"));
		}else{
			if(srcItem.getName().equals("FormDataSourceFieldGroup")){
				formItemType = "FieldGroup";
			}else if(srcItem.getName().equals("Enum")){
				formItemType = "EnumEditor";
			}else{
				formItemType = "MenuItemButton";
			}
		}
		if("FieldGroup".equals(parent.attributeValue("type"))){
			if(!validateFieldGroupDrag(parent))
				return "do not place here";

		}
		
		if(type.equals("FieldGroup")){
			if(this.getPosition(parent.attributeValue("type"), formItemType, type, null).equals("true")){
				this.temp = "true";
				return "true";
			}else{
				if(!validateFieldGroupDrag(this.xml))
					return "true";
				
				String result = this.getPosition(parent.attributeValue("type"), formItemType, type, null);
				this.temp = result ;
				return result;
			}
		}
		String result = this.getPosition(parent.attributeValue("type"), formItemType, type, null);
		this.temp = result ;
		return result;
	}
	
	@Override
	protected Boolean isIfExtendsRelated(String proName){
		if(proName != null){
			if(proName.equals("Extends")||proName.equals("FormLookUp")||
					proName.equals("MenuItem")||proName.equals("Component"))
				return true;
			
			return false;
		}
		
		String type = this.xml.attributeValue("type");
		List<Element> pro = GOTHelp.getPPAttElementList(this.xml, "Name", "Extends");
		
		if(pro == null || pro.size() == 0){
			if(type.equals("StringEditor")){
				pro = GOTHelp.getPPAttElementList(this.xml, "Name", "FormLookUp");
			}
			if(type.equals("FieldGroup")){
				pro = GOTHelp.getPPAttElementList(this.xml, "Name", "Component");
			}
			
			if(type.equals("MenuItemButton")){
				pro = GOTHelp.getPPAttElementList(this.xml, "Name", "MenuItem");
			}
		}
			
		if(pro.get(0).attribute("refentityid") == null)
			return true;
	
		return false;
	}
	
	public Boolean isAllowPercentInput(){
		String type = this.xml.attributeValue("type");
		if(type.equals("Group") || type.equals("DividedBox")|| type.equals("ButtonGroup")||
				type.equals("DataGrid") || type.equals("Image") || type.equals("Tab") || type.equals("Plugin")){
			return true;
		}
		return false;
	}
	
	protected String getPosition(String parent, String from, String to, MouseEvent event){
		String str = from + "->" + parent;
		switch(str){
			case "TabPage->Design":
			case "FieldGroup->FieldGroup":
			case "Button->FieldGroup":
			case "MenuItemButton->FieldGroup":
			case "ButtonGroup->FieldGroup":
			case "ButtonMenu->FieldGroup":
			case "DataGrid->FieldGroup":
			case "Group->FieldGroup":
			case "DividedBox->FieldGroup":
			case "Tab->FieldGroup":
			case "TabPage->FieldGroup":
			case "Image->FieldGroup":
			case "Plugin->FieldGroup":
			case "Text->FieldGroup":
			case "StringEditor->ButtonGroup":
			case "LongEditor->ButtonGroup":
			case "DecimalEditor->ButtonGroup":
			case "DateEditor->ButtonGroup":
			case "TimeEditor->ButtonGroup":
			case "BooleanEditor->ButtonGroup":
			case "EnumEditor->ButtonGroup":
			case "FieldGroup->ButtonGroup":
			case "ButtonGroup->ButtonGroup":
			case "DataGrid->ButtonGroup":
			case "Group->ButtonGroup":
			case "DividedBox->ButtonGroup":
			case "Tab->ButtonGroup":
			case "TabPage->ButtonGroup":
			case "Image->ButtonGroup":
			case "Plugin->ButtonGroup":
			case "StringEditor->ButtonMenu":
			case "LongEditor->ButtonMenu":
			case "DecimalEditor->ButtonMenu":
			case "DateEditor->ButtonMenu":
			case "TimeEditor->ButtonMenu":
			case "BooleanEditor->ButtonMenu":
			case "EnumEditor->ButtonMenu":
			case "FieldGroup->ButtonMenu":
			case "ButtonGroup->ButtonMenu":
			case "ButtonMenu->ButtonMenu":
			case "DataGrid->ButtonMenu":
			case "Group->ButtonMenu":
			case "DividedBox->ButtonMenu":
			case "Tab->ButtonMenu":
			case "TabPage->ButtonMenu":
			case "Image->ButtonMenu":
			case "Plugin->ButtonMenu":
			case "Button->DataGrid":
			case "MenuItemButton->DataGrid":
			case "ButtonGroup->DataGrid":
			case "ButtonMenu->DataGrid":
			case "DataGrid->DataGrid":
			case "Group->DataGrid":
			case "DividedBox->DataGrid":
			case "Tab->DataGrid":
			case "TabPage->DataGrid":
			case "Image->DataGrid":
			case "Plugin->DataGrid":
			case "Text->DataGrid":
			case "TabPage->Group":
			case "TabPage->DividedBox":
			case "TabPage->TabPage":
				return "false";
		}
		
		str = from + "->" + to;
		
		switch(str){
			
			case "Text->StringEditor" :  return "true";
			case "Text->LongEditor" :  return "true";
			case "Text->DecimalEditor" :  return "true";
			case "Text->DateEditor" :  return "true";
			case "Text->TimeEditor" :  return "true";
			case "Text->BooleanEditor" :  return "true";
			case "Text->EnumEditor" :  return "true";
			case "Text->FieldGroup" :  return "true";//if(event!=null && event.stateMask == SWT.SHIFT)return"true";return "down";
			case "Text->Button" :  return "true";
			case "Text->MenuItemButton" :  return "true";
			case "Text->ButtonGroup" :  return "true";
			case "Text->ButtonMenu" :  return "true";
			case "Text->DataGrid" :  return "true";
			case "Text->Group" :  if(event!=null && event.stateMask == SWT.SHIFT)return "true"; return "down";
			case "Text->DividedBox" :  if(event!=null && event.stateMask == SWT.SHIFT)return "true"; return "down";
			case "Text->Tab" :  return "true";
			case "Text->TabPage" : return "down";
			case "Text->Image" : return "true";
			case "Text->Plugin" : return "true";	
	
			case "StringEditor->StringEditor" :  return "true";
			case "StringEditor->LongEditor" :  return "true";
			case "StringEditor->DecimalEditor" :  return "true";
			case "StringEditor->DateEditor" :  return "true";
			case "StringEditor->TimeEditor" :  return "true";
			case "StringEditor->BooleanEditor" :  return "true";
			case "StringEditor->EnumEditor" :  return "true";
			case "StringEditor->FieldGroup" :  if(event!=null && event.stateMask == SWT.SHIFT)return"true";return "down";
			case "StringEditor->Button" :  return "true";
			case "StringEditor->MenuItemButton" :  return "true";
			case "StringEditor->ButtonGroup" :  return "true";
			case "StringEditor->ButtonMenu" :  return "true";
			case "StringEditor->DataGrid" :  if(event!=null && event.stateMask == SWT.SHIFT)return "true"; return "down";
			case "StringEditor->Group" :  if(event!=null && event.stateMask == SWT.SHIFT)return "true"; return "down";
			case "StringEditor->DividedBox" :  if(event!=null && event.stateMask == SWT.SHIFT)return "true"; return "down";
			case "StringEditor->Tab" :  return "true";
			case "StringEditor->TabPage" : return "down";
			case "StringEditor->Image" : return "true";
			case "StringEditor->Plugin" : return "true";
			
			case "LongEditor->StringEditor" :  return "true";
			case "LongEditor->LongEditor" :  return "true";
			case "LongEditor->DecimalEditor" :  return "true";
			case "LongEditor->DateEditor" :  return "true";
			case "LongEditor->TimeEditor" :  return "true";
			case "LongEditor->BooleanEditor" :  return "true";
			case "LongEditor->EnumEditor" :  return "true";
			case "LongEditor->FieldGroup" :  if(event!=null && event.stateMask == SWT.SHIFT)return "true"; return "down";
			case "LongEditor->Button" :  return "true";
			case "LongEditor->MenuItemButton" :  return "true";
			case "LongEditor->ButtonGroup" :  return "true";
			case "LongEditor->ButtonMenu" :  return "true";
			case "LongEditor->DataGrid" :  if(event!=null && event.stateMask == SWT.SHIFT)return "true"; return "down";
			case "LongEditor->Group" :  if(event!=null && event.stateMask == SWT.SHIFT)return "true"; return "down";
			case "LongEditor->DividedBox" :  if(event!=null && event.stateMask == SWT.SHIFT)return "true"; return "down";
			case "LongEditor->Tab" :  return "true";
			case "LongEditor->TabPage" : return "down";
			case "LongEditor->Image" : return "true";
			case "LongEditor->Plugin" : return "true";
			
			case "DecimalEditor->StringEditor" :  return "true";
			case "DecimalEditor->LongEditor" :  return "true";
			case "DecimalEditor->DecimalEditor" :  return "true";
			case "DecimalEditor->DateEditor" :  return "true";
			case "DecimalEditor->TimeEditor" :  return "true";
			case "DecimalEditor->BooleanEditor" :  return "true";
			case "DecimalEditor->EnumEditor" :  return "true";
			case "DecimalEditor->FieldGroup" :  if(event!=null && event.stateMask == SWT.SHIFT)return "true"; return "down";
			case "DecimalEditor->Button" :  return "true";
			case "DecimalEditor->MenuItemButton" :  return "true";
			case "DecimalEditor->ButtonGroup" :  return "true";
			case "DecimalEditor->ButtonMenu" :  return "true";
			case "DecimalEditor->DataGrid" :  if(event!=null && event.stateMask == SWT.SHIFT)return "true"; return "down";
			case "DecimalEditor->Group" :  if(event!=null && event.stateMask == SWT.SHIFT)return "true"; return "down";
			case "DecimalEditor->DividedBox" :  if(event!=null && event.stateMask == SWT.SHIFT)return "true"; return "down";
			case "DecimalEditor->Tab" :  return "true";
			case "DecimalEditor->TabPage" : return "down";
			case "DecimalEditor->Image" : return "true";
			case "DecimalEditor->Plugin" : return "true";
			case "DateEditor->StringEditor" :  return "true";
			case "DateEditor->LongEditor" :  return "true";
			case "DateEditor->DecimalEditor" :  return "true";
			case "DateEditor->DateEditor" :  return "true";
			case "DateEditor->TimeEditor" :  return "true";
			case "DateEditor->BooleanEditor" :  return "true";
			case "DateEditor->EnumEditor" :  return "true";
			case "DateEditor->FieldGroup" :  if(event!=null && event.stateMask == SWT.SHIFT)return "true"; return "down";
			case "DateEditor->Button" :  return "true";
			case "DateEditor->MenuItemButton" :  return "true";
			case "DateEditor->ButtonGroup" :  return "true";
			case "DateEditor->ButtonMenu" :  return "true";
			case "DateEditor->DataGrid" :  if(event!=null && event.stateMask == SWT.SHIFT)return "true"; return "down";
			case "DateEditor->Group" :  if(event!=null && event.stateMask == SWT.SHIFT)return "true"; return "down";
			case "DateEditor->DividedBox" :  if(event!=null && event.stateMask == SWT.SHIFT)return "true"; return "down";
			case "DateEditor->Tab" :  return "true";
			case "DateEditor->TabPage" : return "down";
			case "DateEditor->Image" : return "true";
			case "DateEditor->Plugin" : return "true";
			
			case "TimeEditor->StringEditor" :  return "true";
			case "TimeEditor->LongEditor" :  return "true";
			case "TimeEditor->DecimalEditor" :  return "true";
			case "TimeEditor->DateEditor" :  return "true";
			case "TimeEditor->TimeEditor" :  return "true";
			case "TimeEditor->BooleanEditor" :  return "true";
			case "TimeEditor->EnumEditor" :  return "true";
			case "TimeEditor->FieldGroup" :  if(event!=null && event.stateMask == SWT.SHIFT)return "true"; return "down";
			case "TimeEditor->Button" :  return "true";
			case "TimeEditor->MenuItemButton" :  return "true";
			case "TimeEditor->ButtonGroup" :  return "true";
			case "TimeEditor->ButtonMenu" :  return "true";
			case "TimeEditor->DataGrid" :  if(event!=null && event.stateMask == SWT.SHIFT)return "true"; return "down";
			case "TimeEditor->Group" :  if(event!=null && event.stateMask == SWT.SHIFT)return "true"; return "down";
			case "TimeEditor->DividedBox" :  if(event!=null && event.stateMask == SWT.SHIFT)return "true"; return "down";
			case "TimeEditor->Tab" :  return "true";
			case "TimeEditor->TabPage" : return "down";
			case "TimeEditor->Image" : return "true";
			case "TimeEditor->Plugin" : return "true";
			
			case "DateTimeEditor->StringEditor" :  return "true";
			case "DateTimeEditor->LongEditor" :  return "true";
			case "DateTimeEditor->DecimalEditor" :  return "true";
			case "DateTimeEditor->DateEditor" :  return "true";
			case "DateTimeEditor->TimeEditor" :  return "true";
			case "DateTimeEditor->BooleanEditor" :  return "true";
			case "DateTimeEditor->EnumEditor" :  return "true";
			case "DateTimeEditor->FieldGroup" :  if(event!=null && event.stateMask == SWT.SHIFT)return "true"; return "down";
			case "DateTimeEditor->Button" :  return "true";
			case "DateTimeEditor->MenuItemButton" :  return "true";
			case "DateTimeEditor->ButtonGroup" :  return "true";
			case "DateTimeEditor->ButtonMenu" :  return "true";
			case "DateTimeEditor->DataGrid" :  if(event!=null && event.stateMask == SWT.SHIFT)return "true"; return "down";
			case "DateTimeEditor->Group" :  if(event!=null && event.stateMask == SWT.SHIFT)return "true"; return "down";
			case "DateTimeEditor->DividedBox" :  if(event!=null && event.stateMask == SWT.SHIFT)return "true"; return "down";
			case "DateTimeEditor->Tab" :  return "true";
			case "DateTimeEditor->TabPage" : return "down";
			case "DateTimeEditor->Image" : return "true";
			case "DateTimeEditor->Plugin" : return "true";
			
			case "BooleanEditor->StringEditor" :  return "true";
			case "BooleanEditor->LongEditor" :  return "true";
			case "BooleanEditor->DecimalEditor" :  return "true";
			case "BooleanEditor->DateEditor" :  return "true";
			case "BooleanEditor->TimeEditor" :  return "true";
			case "BooleanEditor->BooleanEditor" :  return "true";
			case "BooleanEditor->EnumEditor" :  return "true";
			case "BooleanEditor->FieldGroup" :  if(event!=null && event.stateMask == SWT.SHIFT)return "true"; return "down";
			case "BooleanEditor->Button" :  return "true";
			case "BooleanEditor->MenuItemButton" :  return "true";
			case "BooleanEditor->ButtonGroup" :  return "true";
			case "BooleanEditor->ButtonMenu" :  return "true";
			case "BooleanEditor->DataGrid" :  if(event!=null && event.stateMask == SWT.SHIFT)return "true"; return "down";
			case "BooleanEditor->Group" :  if(event!=null && event.stateMask == SWT.SHIFT)return "true"; return "down";
			case "BooleanEditor->DividedBox" :  if(event!=null && event.stateMask == SWT.SHIFT)return "true"; return "down";
			case "BooleanEditor->Tab" :  return "true";
			case "BooleanEditor->TabPage" : return "down";
			case "BooleanEditor->Image" : return "true";
			case "BooleanEditor->Plugin" : return "true";
			case "EnumEditor->StringEditor" :  return "true";
			case "EnumEditor->LongEditor" :  return "true";
			case "EnumEditor->DecimalEditor" :  return "true";
			case "EnumEditor->DateEditor" :  return "true";
			case "EnumEditor->TimeEditor" :  return "true";
			case "EnumEditor->BooleanEditor" :  return "true";
			case "EnumEditor->EnumEditor" :  return "true";
			case "EnumEditor->FieldGroup" :  if(event!=null && event.stateMask == SWT.SHIFT)return "true"; return "down";
			case "EnumEditor->Button" :  return "true";
			case "EnumEditor->MenuItemButton" :  return "true";
			case "EnumEditor->ButtonGroup" :  return "true";
			case "EnumEditor->ButtonMenu" :  return "true";
			case "EnumEditor->DataGrid" :  if(event!=null && event.stateMask == SWT.SHIFT)return "true"; return "down";
			case "EnumEditor->Group" :  if(event!=null && event.stateMask == SWT.SHIFT)return "true"; return "down";
			case "EnumEditor->DividedBox" :  if(event!=null && event.stateMask == SWT.SHIFT)return "true"; return "down";
			case "EnumEditor->Tab" :  return "true";
			case "EnumEditor->TabPage" : return "down";
			case "EnumEditor->Image" : return "true";
			case "EnumEditor->Plugin" : return "true";
			case "FieldGroup->StringEditor" :  return "true";
			case "FieldGroup->LongEditor" :  return "true";
			case "FieldGroup->DecimalEditor" :  return "true";
			case "FieldGroup->DateEditor" :  return "true";
			case "FieldGroup->TimeEditor" :  return "true";
			case "FieldGroup->BooleanEditor" :  return "true";
			case "FieldGroup->EnumEditor" :  return "true";
			case "FieldGroup->FieldGroup" :  return "true";
			case "FieldGroup->Button" :  return "true";
			case "FieldGroup->MenuItemButton" :  return "true";
			case "FieldGroup->ButtonGroup" :  return "true";
			case "FieldGroup->ButtonMenu" :  return "true";
			case "FieldGroup->DataGrid" :  if(event!=null && event.stateMask == SWT.SHIFT)return "true"; return "down";
			case "FieldGroup->Group" :  if(event!=null && event.stateMask == SWT.SHIFT)return "true"; return "down";
			case "FieldGroup->DividedBox" :  if(event!=null && event.stateMask == SWT.SHIFT)return "true"; return "down";
			case "FieldGroup->Tab" :  return "true";
			case "FieldGroup->TabPage" :  return "down";
			case "FieldGroup->Image" : return "true";
			case "FieldGroup->Plugin" : return "true";
			case "Button->StringEditor" :  return "true";
			case "Button->LongEditor" :  return "true";
			case "Button->DecimalEditor" :  return "true";
			case "Button->DateEditor" :  return "true";
			case "Button->TimeEditor" :  return "true";
			case "Button->BooleanEditor" :  return "true";
			case "Button->EnumEditor" :  return "true";
			case "Button->FieldGroup" :  return "true";
			case "Button->Button" :  return "true";
			case "Button->MenuItemButton" :  return "true";
			case "Button->ButtonGroup" :  if(event!=null && event.stateMask == SWT.SHIFT)return "true"; return "down";
			case "Button->ButtonMenu" :  if(event!=null && event.stateMask == SWT.SHIFT)return "true"; return "down";
			case "Button->DataGrid" :  return "true";
			case "Button->Group" :  if(event!=null && event.stateMask == SWT.SHIFT)return "true"; return "down";
			case "Button->DividedBox" :  if(event!=null && event.stateMask == SWT.SHIFT)return "true"; return "down";
			case "Button->Tab" :  return "true";
			case "Button->TabPage" : return "down";
			case "Button->Image" : return "true";
			case "Button->Plugin" : return "true";
			case "MenuItemButton->StringEditor" :  return "true";
			case "MenuItemButton->LongEditor" :  return "true";
			case "MenuItemButton->DecimalEditor" :  return "true";
			case "MenuItemButton->DateEditor" :  return "true";
			case "MenuItemButton->TimeEditor" :  return "true";
			case "MenuItemButton->BooleanEditor" :  return "true";
			case "MenuItemButton->EnumEditor" :  return "true";
			case "MenuItemButton->FieldGroup" :  return "true";
			case "MenuItemButton->Button" :  return "true";
			case "MenuItemButton->MenuItemButton" :  return "true";
			case "MenuItemButton->ButtonGroup" :  if(event!=null && event.stateMask == SWT.SHIFT)return "true"; return "down";
			case "MenuItemButton->ButtonMenu" :  if(event!=null && event.stateMask == SWT.SHIFT)return "true"; return "down";
			case "MenuItemButton->DataGrid" :  return "true";
			case "MenuItemButton->Group" :  if(event!=null && event.stateMask == SWT.SHIFT)return "true"; return "down";
			case "MenuItemButton->DividedBox" :  if(event!=null && event.stateMask == SWT.SHIFT)return "true"; return "down";
			case "MenuItemButton->Tab" :  return "true";
			case "MenuItemButton->TabPage" : return "down";
			case "MenuItemButton->Image" : return "true";
			case "MenuItemButton->Plugin" : return "true";
			case "ButtonGroup->StringEditor" :  return "true";
			case "ButtonGroup->LongEditor" :  return "true";
			case "ButtonGroup->DecimalEditor" :  return "true";
			case "ButtonGroup->DateEditor" :  return "true";
			case "ButtonGroup->TimeEditor" :  return "true";
			case "ButtonGroup->BooleanEditor" :  return "true";
			case "ButtonGroup->EnumEditor" :  return "true";
			case "ButtonGroup->FieldGroup" :  return "true";
			case "ButtonGroup->Button" :  return "true";
			case "ButtonGroup->MenuItemButton" :  return "true";
			case "ButtonGroup->ButtonGroup" :  return "true";
			case "ButtonGroup->ButtonMenu" :  return "true";
			case "ButtonGroup->DataGrid" :  return "true";
			case "ButtonGroup->Group" :  if(event!=null && event.stateMask == SWT.SHIFT)return "true"; return "down";
			case "ButtonGroup->DividedBox" :  if(event!=null && event.stateMask == SWT.SHIFT)return "true"; return "down";
			case "ButtonGroup->Tab" :  return "true";
			case "ButtonGroup->TabPage" : return "down";
			case "ButtonGroup->Image" : return "true";
			case "ButtonGroup->Plugin" : return "true";
			case "ButtonMenu->StringEditor" :  return "true";
			case "ButtonMenu->LongEditor" :  return "true";
			case "ButtonMenu->DecimalEditor" :  return "true";
			case "ButtonMenu->DateEditor" :  return "true";
			case "ButtonMenu->TimeEditor" :  return "true";
			case "ButtonMenu->BooleanEditor" :  return "true";
			case "ButtonMenu->EnumEditor" :  return "true";
			case "ButtonMenu->FieldGroup" :  return "true";
			case "ButtonMenu->Button" :  return "true";
			case "ButtonMenu->MenuItemButton" :  return "true";
			case "ButtonMenu->ButtonGroup" :  if(event!=null && event.stateMask == SWT.SHIFT)return "true"; return "down";
			case "ButtonMenu->ButtonMenu" :  return "true";
			case "ButtonMenu->DataGrid" :  return "true";
			case "ButtonMenu->Group" :  if(event!=null && event.stateMask == SWT.SHIFT)return "true"; return "down";
			case "ButtonMenu->DividedBox" :  if(event!=null && event.stateMask == SWT.SHIFT)return "true"; return "down";
			case "ButtonMenu->Tab" :  return "true";
			case "ButtonMenu->TabPage" : return "down";
			case "ButtonMenu->Image" : return "true";
			case "ButtonMenu->Plugin" : return "true";
			case "DataGrid->StringEditor" :  return "true";
			case "DataGrid->LongEditor" :  return "true";
			case "DataGrid->DecimalEditor" :  return "true";
			case "DataGrid->DateEditor" :  return "true";
			case "DataGrid->TimeEditor" :  return "true";
			case "DataGrid->BooleanEditor" :  return "true";
			case "DataGrid->EnumEditor" :  return "true";
			case "DataGrid->FieldGroup" :  return "true";
			case "DataGrid->Button" :  return "true";
			case "DataGrid->MenuItemButton" :  return "true";
			case "DataGrid->ButtonGroup" :  return "true";
			case "DataGrid->ButtonMenu" :  return "true";
			case "DataGrid->DataGrid" :  return "true";
			case "DataGrid->Group" :  if(event!=null && event.stateMask == SWT.SHIFT)return "true"; return "down";
			case "DataGrid->DividedBox" : if(event!=null && event.stateMask == SWT.SHIFT)return "true";  return "down";
			case "DataGrid->Tab" :  return "true";
			case "DataGrid->TabPage" : return "down";
			case "DataGrid->Image" : return "true";
			case "DataGrid->Plugin" : return "true";
			case "Group->StringEditor" :  return "true";
			case "Group->LongEditor" :  return "true";
			case "Group->DecimalEditor" :  return "true";
			case "Group->DateEditor" :  return "true";
			case "Group->TimeEditor" :  return "true";
			case "Group->BooleanEditor" :  return "true";
			case "Group->EnumEditor" :  return "true";
			case "Group->FieldGroup" :  return "true";
			case "Group->Button" :  return "true";
			case "Group->MenuItemButton" :  return "true";
			case "Group->ButtonGroup" :  return "true";
			case "Group->ButtonMenu" :  return "true";
			case "Group->DataGrid" :  return "true";
			case "Group->Group" : if(event!=null && event.stateMask == SWT.SHIFT)return "true";  return "down";
			case "Group->DividedBox" :  if(event!=null && event.stateMask == SWT.SHIFT)return "true"; return "down";
			case "Group->Tab" :  return "true";
			case "Group->TabPage" : return "down";
			case "Group->Image" : return "true";
			case "Group->Plugin" : return "true";
			case "DividedBox->StringEditor" :  return "true";
			case "DividedBox->LongEditor" :  return "true";
			case "DividedBox->DecimalEditor" :  return "true";
			case "DividedBox->DateEditor" :  return "true";
			case "DividedBox->TimeEditor" :  return "true";
			case "DividedBox->BooleanEditor" :  return "true";
			case "DividedBox->EnumEditor" :  return "true";
			case "DividedBox->FieldGroup" :  return "true";
			case "DividedBox->Button" :  return "true";
			case "DividedBox->MenuItemButton" :  return "true";
			case "DividedBox->ButtonGroup" :  return "true";
			case "DividedBox->ButtonMenu" :  return "true";
			case "DividedBox->DataGrid" :  return "true";
			case "DividedBox->Group" : if(event!=null && event.stateMask == SWT.SHIFT)return "true";  return "down";
			case "DividedBox->DividedBox" :  if(event!=null && event.stateMask == SWT.SHIFT)return "true"; return "down";
			case "DividedBox->Tab" :  return "true";
			case "DividedBox->TabPage" : return "down";
			case "DividedBox->Image" : return "true";
			case "DividedBox->Plugin" : return "true";
			case "Tab->StringEditor" :  return "true";
			case "Tab->LongEditor" :  return "true";
			case "Tab->DecimalEditor" :  return "true";
			case "Tab->DateEditor" :  return "true";
			case "Tab->TimeEditor" :  return "true";
			case "Tab->BooleanEditor" :  return "true";
			case "Tab->EnumEditor" :  return "true";
			case "Tab->FieldGroup" :  return "true";
			case "Tab->Button" :  return "true";
			case "Tab->MenuItemButton" :  return "true";
			case "Tab->ButtonGroup" :  return "true";
			case "Tab->ButtonMenu" :  return "true";
			case "Tab->DataGrid" :  return "true";
			case "Tab->Group" : if(event!=null && event.stateMask == SWT.SHIFT)return "true"; return "down";
			case "Tab->DividedBox" :  if(event!=null && event.stateMask == SWT.SHIFT)return "true"; return "down";
			case "Tab->Tab" :  return "true";
			case "Tab->TabPage" :  return "down";
			case "Tab->Image" : return "true";
			case "Tab->Plugin" : return "true";
			case "TabPage->StringEditor" :  return "false";
			case "TabPage->LongEditor" :  return "false";
			case "TabPage->DecimalEditor" :  return "false";
			case "TabPage->DateEditor" :  return "false";
			case "TabPage->TimeEditor" :  return "false";
			case "TabPage->BooleanEditor" :  return "false";
			case "TabPage->EnumEditor" :  return "false";
			case "TabPage->FieldGroup" :  return "false";
			case "TabPage->Button" :  return "false";
			case "TabPage->MenuItemButton" :  return "false";
			case "TabPage->ButtonGroup" :  return "false";
			case "TabPage->ButtonMenu" :  return "false";
			case "TabPage->DataGrid" :  return "false";
			case "TabPage->Group" :  return "false";
			case "TabPage->DividedBox" :  return "false";
			case "TabPage->Tab" :  return "down";
			case "TabPage->TabPage" :  return "true";
			case "TabPage->Image" : return "false";
			case "TabPage->Plugin" : return "false";
			case "Image->StringEditor" :  return "true";
			case "Image->LongEditor" :  return "true";
			case "Image->DecimalEditor" :  return "true";
			case "Image->DateEditor" :  return "true";
			case "Image->TimeEditor" :  return "true";
			case "Image->BooleanEditor" :  return "true";
			case "Image->EnumEditor" :  return "true";
			case "Image->FieldGroup" :  return "true";
			case "Image->Button" :  return "true";
			case "Image->MenuItemButton" :  return "true";
			case "Image->ButtonGroup" :  return "true";
			case "Image->ButtonMenu" :  return "true";
			case "Image->DataGrid" :  return "true";
			case "Image->Group" :  if(event!=null && event.stateMask == SWT.SHIFT)return "true"; return "down";
			case "Image->DividedBox" :  if(event!=null && event.stateMask == SWT.SHIFT)return "true"; return "down";
			case "Image->Tab" :  return "true";
			case "Image->TabPage" : return "down";
			case "Image->Image" : return "true";
			case "Image->Plugin" : return "true";
			case "Plugin->StringEditor" :  return "true";
			case "Plugin->LongEditor" :  return "true";
			case "Plugin->DecimalEditor" :  return "true";
			case "Plugin->DateEditor" :  return "true";
			case "Plugin->TimeEditor" :  return "true";
			case "Plugin->BooleanEditor" :  return "true";
			case "Plugin->EnumEditor" :  return "true";
			case "Plugin->FieldGroup" :  return "true";
			case "Plugin->Button" :  return "true";
			case "Plugin->MenuItemButton" :  return "true";
			case "Plugin->ButtonGroup" :  return "true";
			case "Plugin->ButtonMenu" :  return "true";
			case "Plugin->DataGrid" :  return "true";
			case "Plugin->Group" :  if(event!=null && event.stateMask == SWT.SHIFT)return "true"; return "down";
			case "Plugin->DividedBox" :  if(event!=null && event.stateMask == SWT.SHIFT)return "true"; return "down";
			case "Plugin->Tab" :  return "true";
			case "Plugin->TabPage" : return "down";
			case "Plugin->Image" : return "true";
			case "Plugin->Plugin" : return "true";

			default :
				return "true";
		}
//		return "true";
	}
	
	@Override
	public Boolean editOnCreate(){
		if(this.xml.attributeValue("type") == null){
			System.out.println();
		}
		if("FieldGroup".equals(this.xml.attributeValue("type"))){
			return true;
		}
		return false;
	}
	
	//本来是复写了空方法，由于filterEditor引用被删除没有提示，注释了
//	@Override
//	protected List<Element> getRelationInEntity(){
//		return null;
//	}
	
	@Override
	public Boolean switchSelf(){
		Element parent = this.xml.getParent();
		int childIndex = this.xml.getParent().indexOf(this.xml);
		if(childIndex>1){
			Element sibling = (Element) parent.elements().get(childIndex-1);
			String type = sibling.attributeValue("type");
			if(type.equals("FieldGroup") || type.equals("Group")|| type.equals("ButtonGroup") ||
				type.equals("TabPage") || type.equals("Tab") || type.equals("DividedBox") || type.equals("DataGrid"))
				return true;
		}
		return false;
	}
	
	@SuppressWarnings("unchecked")
	@Override
	public void doAfterNameModified(String oldName){
		super.doAfterNameModified(oldName);
		if(this.xml.attributeValue("type").equals("FieldGroup")){
			String newName = this.xml.attributeValue("name");
			Element componentPro = GOTHelper.getProperty(this.xml,"Component");
			if(componentPro.attribute("refentityid") != null ){
				List<Element> elements = this.xml.elements("FormItem");
				for(Element item : elements){
					if(!item.attributeValue("type").equals("StringEditor")){
						GOTMessageDialog.alert("Component的FieldGroup下面有非StringEditor类型的FormItem");
					}
					//若FieldGroup的名字与其子节点的名字一样 则该方法逻辑上存在漏洞 但是实际情况不会出问题
					String itemName = item.attributeValue("name");
					itemName = itemName.replace(oldName,newName);
					item.addAttribute("name", itemName);
				}
				GotXmlDto.getInstance().updateEntityElement(NodeGOT.getEntity(this.xml));
			}
		}else if(this.xml.getParent() != null && "DataGrid".equals(this.xml.getParent().attributeValue("type"))){
			Element componentPro = GOTHelper.getProperty(this.xml.getParent(),"DynamicColumn");
			if(componentPro != null){
				if(this.xml.attributeValue("id").equals(componentPro.attributeValue("innerid"))){
					componentPro.element("Value").setText(this.xml.attributeValue("name"));
					GotXmlDto.getInstance().updateEntityElement(NodeGOT.getEntity(this.xml));
				}
			}
		}
	}
	
	@Override
	public ValidationResultEvent validateProperty(Element property){
		if(property.elementText("Name").equals("Visible")){
			if(this.xml.attributeValue("type").equals("FieldGroup")){
				List<Element> dataSourcePro = GOTHelp.getPPAttElementList(this.xml, "Name", "DataSource");
				List<Element> componentPro = GOTHelp.getPPAttElementList(this.xml, "Name", "Component");
				if(!dataSourcePro.get(0).elementText("Value").equals("") && !componentPro.get(0).elementText("Value").equals("")){
					if(property.elementText("Value").equals("")){
						return null;
					}
				}
			}
		}
		
		if(isAllowPercentInput()){
			String propertyName = property.elementText("Name");
			if(propertyName.equals("Width") || propertyName.equals("Height")){
				String propertyValue = property.elementText("Value");
				if(propertyValue.equals(""))
					return null;
				if(!propertyValue.matches("^[0-9]+([.]{1}[0-9]+){0,1}[%]*$")){
					ValidationResultEvent vre = new ValidationResultEvent(ValidationResultEvent.INVALID);
					vre.results = new ArrayList<>();
					vre.results.add(new ValidationResult(true, "Property", "", "格式不正确"));
					return vre;
				}
				return null;
			}
		}
		
		return super.validateProperty(property);
	}
}
