package client.gongqi.designer.got.node.gotenum;

import java.util.List;

import org.apache.commons.lang.StringUtils;
import org.dom4j.Element;

import client.gongqi.designer.got.node.Inner;
import client.gongqi.designer.toolsgot.GOTXMLHelper;

public class EnumItem extends Inner{

	@Override
	public void doAfterInsert(){
		super.doAfterInsert();
		int value = this.getEnumItemInnerValue();
		GOTXMLHelper.setProperty(xml, "Value", String.valueOf(value), true);
	}
	
	
	@SuppressWarnings("unchecked")
	private int getEnumItemInnerValue(){
		int MaxValue = -1 ;
		List<Element> itemList = xml.getParent().elements("EnumItem");
		
		if(itemList.size() == 1)
			return 0;
		
		for (Element item : itemList){
			List<?> list = item.element("Properties").elements("Property");
			if(list != null && !list.isEmpty()){
				Element e = (Element) list.get(0);
				boolean flag = e.element("Value") == null ? false : true;
				if(flag){
					String value = StringUtils.isNotBlank(e.elementText("Value")) ? e.elementText("Value") : "0";
					int mum = Integer.parseInt(value);
					if(mum > MaxValue){
						MaxValue = mum;
					}
				}
			}
	
		}
		return MaxValue+1 ;
	}
}
