package client.gongqi.designer.got.node.map;

import java.util.List;

import org.dom4j.Element;

import client.gongqi.designer.got.node.Entity;
import client.gongqi.designer.got.node.NodeFactory;
import client.gongqi.designer.got.node.NodeGOT;
import gongqi.designer.utils.GOTHelper;
import info.gongqi.got.tool.GOTHelp;

public class Map extends Entity{

	public  Map(){
		super();
	}
	
	@SuppressWarnings("unchecked")
	@Override
	protected String validateAttributes(){
		List<Element> mapFields = this.xml.element("MapFields").elements("MapField");
		for (Element mapField : mapFields){
			if(mapField.attribute("editOnCreate") != null){
				mapField.remove(mapField.attribute("editOnCreate"));
			}
		}
		return "true";
	}
	
	@SuppressWarnings("unchecked")
	@Override
	public void doAfterPropertyModified(Element property, String...args){
		super.doAfterPropertyModified(property);
		
		String newValue = property.elementText("Value");
		
		String origValue = args[0];
		
		if(newValue.equals(origValue))
			return ;
		
		Element mapFields = xml.element("MapFields");
		List<Element> mapFieldList = mapFields.elements("MapField") ;
		
		int length = mapFieldList.size();
		
		for(int i = 0 ; i<length ; i++){
			mapFieldList.remove(0);
		}
		
		List<Element> mapRelationList = xml.element("MapRelations").elements("MapRelation");
		
		length = mapRelationList.size();
		
		for (int i = 0; i<length; i++){
			mapFieldList.remove(0);
		}
		
		if(property.elementText("Value").equals(""))
			return;
		
		Element table = GOTHelper.getTable(property.attributeValue("refentityid"));
		
		List<Element> tableFields = table.element("TableFields").elements("TableField");
		NodeGOT node;
		Element extendsPro;
		String tableId = table.attributeValue("id");
		int innerid = 1;
		for(Element tableField : tableFields){
			node = NodeFactory.createNode("MapField", tableField.attributeValue("type"), "");
			extendsPro = GOTHelp.getPPAttElement(node.xml, "Name", "Extends");
			extendsPro.element("Value").setText(tableField.attributeValue("name"));
			extendsPro.addAttribute("refentityid", tableId);
			extendsPro.addAttribute("refinnerid", tableField.attributeValue("id"));
			node.xml.addAttribute("id", String.valueOf(innerid));
			node.xml.addAttribute("name", tableField.attributeValue("name"));
			innerid ++ ;
			mapFields.add(node.xml.detach());
			
		}
		xml.addAttribute("nextInnerId", String.valueOf(innerid));
	}
}
