package client.gongqi.designer.got.node.map;

import java.util.ArrayList;
import java.util.List;

import org.dom4j.Attribute;
import org.dom4j.Element;

import client.gongqi.designer.got.node.Inner;
import client.gongqi.designer.got.node.NodeGOT;
import client.gongqi.designer.toolsgot.GOTXMLHelper;
import client.gongqi.designer.toolsgot.Macros;
import info.gongqi.got.model.GotXmlDto;
import info.gongqi.got.tool.GOTHelp;

public class MapField extends Inner{

	public MapField(){
		super();
	}
	
	//覆写了protected方法 它只在Node内部被调用
	@Override
	public List<String> getPropertyItemEditorArray(String propertyName,String fixedRuglar, Element baseXML ){
		if(this.xml.attributeValue("type").equals("Enum") && propertyName.equals("Extends")){
			if(GOTHelp.getPPAttValue(xml, "Name", "Source").equals("Enum")){
				List<Element> elements = GotXmlDto.getInstance().currentElements("Enums");
				return super.getPropertyItemEditorArray(propertyName,"Enum", elements.get(0));
			}else{
				List<Element> elements = GotXmlDto.getInstance().currentElements("DataTypes");
				return super.getPropertyItemEditorArray(propertyName,"DataType[@type='Enum']", elements.get(0));
			}
		}else{
			return super.getPropertyItemEditorArray(propertyName,"",null);
		}
	}
	
	@SuppressWarnings("unchecked")
	@Override
	public void doAfterPropertyModified(Element property, String...args){
		if(property.elementText("Name").equals("Source")){
			List<Element> extendsPro = GOTHelp.getPPAttElementList(this.xml, "Name", "Extends");
			extendsPro.get(0).element("Value").setText("");
			doAfterPropertyModified(extendsPro.get(0));
			return;
		}
		
		if(property.elementText("Name").equals("Extends")){
			String extendName = property.elementText("Name");
			if(rNode.getInfoValue("Type").equals("Enum")){
				if(extendName.equals("")){
					List<Attribute> attributes = new ArrayList<>();
					attributes.addAll(property.attributes());
					for (Attribute attribute : attributes) {
						property.remove(attribute);
					}
				}else{
					String source = GOTHelp.getPPAttValue(this.xml, "Name", "Source");
					Element extendNode;
					if(source.equals("Enum")){
//						String xpath = "DataDictionary/Enums/Enum[@name='" + extendName + "']";
//						extendNode = (Element) NodeGOT.gotXML.selectNodes(xpath).get(0);
						extendNode = GotXmlDto.getInstance().currentElements("Enums", "name", extendName).get(0);
						property.addAttribute("refentityid", extendNode.attributeValue("id"));
					}else if(source.equals("DataType")){
//						String xpath = "DataDictionary/DataTypes/DataType[@name='" + extendName + "']";
//						extendNode = (Element) NodeGOT.gotXML.selectNodes(xpath).get(0);
						extendNode = GotXmlDto.getInstance().currentElements("DataTypes", "name", extendName).get(0);
						property.addAttribute("refentityid", extendNode.attributeValue("id"));
						
					}
					
				}
			}
	   	}
		
		super.doAfterPropertyModified(property,args) ;
	}
	
	@Override
	protected Boolean isIfExtendsRelated(String proName){
		if(proName != null && proName.equals("Extends"))
			return true;
		
		return false;
	}
	
	//xml has been created
	@Override
	public Boolean editOnCreate(){
		if(this.xml.attributeValue("type").equals("Component")){
			return true;
		}
		return false;
	}
	
	@Override
	public String allowPropertyEdit(String propertyName){
		
		if(propertyName.equals("Extends") && this.xml.attributeValue("type").equals("Component")){
			if(this.xml.attribute("editOnCreate") != null)
				return Macros.INFO_TRUE;
			return Macros.INFO_FALSE;
		}
		
		return super.allowPropertyEdit(propertyName) ;
	}
	
	
	@Override
	public String getAccpDragNewInsertBase(){
		return "parent";
	}
	
	@Override
	public NodeGOT getAccpDragNewNode(Element src){
		NodeGOT node;
		if(src.getName().equals("DataType")){
			//新建一个TableField 类型是Enum 设置好属性 并且返回这个node
			node = super.doAccpDragNew("MapField", src.attributeValue("type"));
			this.doAccpDragNewAfer(src,node.xml);
			return node;
			
		}
		return null;
	}
	
	private void doAccpDragNewAfer(Element src, Element node){
		String extendName = src.attributeValue("name");
		GOTXMLHelper.setProperty(node,"Extends",extendName,true);
		node.addAttribute("name", extendName);
		if(node.attributeValue("type").equals("Enum")){
			if(src.getName().equals("Enum")){
				GOTXMLHelper.setProperty(node,"Source","Enum",true);
			}else{
				GOTXMLHelper.setProperty(node,"Source","DataType",true);
			}
		}else if(node.attributeValue("type").equals("Component")){
			node.addAttribute("editOnCreate", "true");
		}
	}
	
	@Override
	public void doAfterDragDroped(){
		this.doAfterPropertyModified(GOTHelp.getPPAttElement(this.xml, "Name", "Extends"));
	}
	
	
}
