package client.gongqi.designer.got.node.map;

import org.dom4j.Element;
import org.eclipse.swt.events.MouseEvent;

import client.gongqi.designer.got.node.Branch;
import client.gongqi.designer.got.node.NodeGOT;
import client.gongqi.designer.toolsgot.GOTXMLHelper;

public class MapFields extends Branch{

	public MapFields(){
		super();
	}
	
	@Override
	public String validateAccpDragMove(Element srcItem, MouseEvent event){
		return "down";
	}
	
	@Override
	public String getAccpDragNewInsertBase(){
		return "self";
	}
	
	@Override
	public NodeGOT getAccpDragNewNode(Element src){
		NodeGOT node;
		if(src.getName().equals("DataType")){
			//新建一个TableField 类型是Enum 设置好属性 并且返回这个node
			node = super.doAccpDragNew("MapField", src.attributeValue("type"));
			this.doAccpDragNewAfer(src,node.xml);
			return node;
			
		}
		return null;
	}
	
	private void doAccpDragNewAfer(Element src, Element node){
		String extendName = src.attributeValue("name");
		GOTXMLHelper.setProperty(node,"Extends",extendName,true);
		node.addAttribute("name", extendName);
		if(node.attributeValue("type").equals("Enum")){
			if(src.getName().equals("Enum")){
				GOTXMLHelper.setProperty(node,"Source","Enum",true);
			}else{
				GOTXMLHelper.setProperty(node,"Source","DataType",true);
			}
		}else if(node.attributeValue("type").equals("Component")){
			node.addAttribute("editOnCreate", "true");
		}
	}
	
}
